/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.content.Context;
import android.location.GpsNavigationMessageEvent;
import android.location.IGpsNavigationMessageListener;
import android.location.ILocationManager;
import android.location.LocalListenerHelper;
import android.os.RemoteException;

class GpsNavigationMessageListenerTransport
extends LocalListenerHelper<GpsNavigationMessageEvent.Listener> {
    private final Context mContext;
    private final ILocationManager mLocationManager;
    private final IGpsNavigationMessageListener mListenerTransport = new ListenerTransport();

    public GpsNavigationMessageListenerTransport(Context context, ILocationManager locationManager) {
        super("GpsNavigationMessageListenerTransport");
        this.mContext = context;
        this.mLocationManager = locationManager;
    }

    @Override
    protected boolean registerWithServer() throws RemoteException {
        return this.mLocationManager.addGpsNavigationMessageListener(this.mListenerTransport, this.mContext.getPackageName());
    }

    @Override
    protected void unregisterFromServer() throws RemoteException {
        this.mLocationManager.removeGpsNavigationMessageListener(this.mListenerTransport);
    }

    private class ListenerTransport
    extends IGpsNavigationMessageListener.Stub {
        private ListenerTransport() {
        }

        @Override
        public void onGpsNavigationMessageReceived(final GpsNavigationMessageEvent event) {
            LocalListenerHelper.ListenerOperation<GpsNavigationMessageEvent.Listener> operation = new LocalListenerHelper.ListenerOperation<GpsNavigationMessageEvent.Listener>(){

                @Override
                public void execute(GpsNavigationMessageEvent.Listener listener) throws RemoteException {
                    listener.onGpsNavigationMessageReceived(event);
                }
            };
            GpsNavigationMessageListenerTransport.this.foreach(operation);
        }
    }
}

