/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.IRemoteControlDisplay;
import android.media.Rating;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IRemoteControlClient
extends IInterface {
    public void onInformationRequested(int var1, int var2) throws RemoteException;

    public void informationRequestForDisplay(IRemoteControlDisplay var1, int var2, int var3) throws RemoteException;

    public void setCurrentClientGenerationId(int var1) throws RemoteException;

    public void plugRemoteControlDisplay(IRemoteControlDisplay var1, int var2, int var3) throws RemoteException;

    public void unplugRemoteControlDisplay(IRemoteControlDisplay var1) throws RemoteException;

    public void setBitmapSizeForDisplay(IRemoteControlDisplay var1, int var2, int var3) throws RemoteException;

    public void setWantsSyncForDisplay(IRemoteControlDisplay var1, boolean var2) throws RemoteException;

    public void enableRemoteControlDisplay(IRemoteControlDisplay var1, boolean var2) throws RemoteException;

    public void seekTo(int var1, long var2) throws RemoteException;

    public void updateMetadata(int var1, int var2, Rating var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IRemoteControlClient {
        private static final String DESCRIPTOR = "android.media.IRemoteControlClient";
        static final int TRANSACTION_onInformationRequested = 1;
        static final int TRANSACTION_informationRequestForDisplay = 2;
        static final int TRANSACTION_setCurrentClientGenerationId = 3;
        static final int TRANSACTION_plugRemoteControlDisplay = 4;
        static final int TRANSACTION_unplugRemoteControlDisplay = 5;
        static final int TRANSACTION_setBitmapSizeForDisplay = 6;
        static final int TRANSACTION_setWantsSyncForDisplay = 7;
        static final int TRANSACTION_enableRemoteControlDisplay = 8;
        static final int TRANSACTION_seekTo = 9;
        static final int TRANSACTION_updateMetadata = 10;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IRemoteControlClient asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IRemoteControlClient) {
                return (IRemoteControlClient)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            switch (code) {
                case 1598968902: {
                    reply.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    this.onInformationRequested(_arg0, _arg1);
                    return true;
                }
                case 2: {
                    data.enforceInterface(DESCRIPTOR);
                    IRemoteControlDisplay _arg0 = IRemoteControlDisplay.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    this.informationRequestForDisplay(_arg0, _arg1, _arg2);
                    return true;
                }
                case 3: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    this.setCurrentClientGenerationId(_arg0);
                    return true;
                }
                case 4: {
                    data.enforceInterface(DESCRIPTOR);
                    IRemoteControlDisplay _arg0 = IRemoteControlDisplay.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    this.plugRemoteControlDisplay(_arg0, _arg1, _arg2);
                    return true;
                }
                case 5: {
                    data.enforceInterface(DESCRIPTOR);
                    IRemoteControlDisplay _arg0 = IRemoteControlDisplay.Stub.asInterface(data.readStrongBinder());
                    this.unplugRemoteControlDisplay(_arg0);
                    return true;
                }
                case 6: {
                    data.enforceInterface(DESCRIPTOR);
                    IRemoteControlDisplay _arg0 = IRemoteControlDisplay.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    this.setBitmapSizeForDisplay(_arg0, _arg1, _arg2);
                    return true;
                }
                case 7: {
                    data.enforceInterface(DESCRIPTOR);
                    IRemoteControlDisplay _arg0 = IRemoteControlDisplay.Stub.asInterface(data.readStrongBinder());
                    boolean _arg1 = 0 != data.readInt();
                    this.setWantsSyncForDisplay(_arg0, _arg1);
                    return true;
                }
                case 8: {
                    data.enforceInterface(DESCRIPTOR);
                    IRemoteControlDisplay _arg0 = IRemoteControlDisplay.Stub.asInterface(data.readStrongBinder());
                    boolean _arg1 = 0 != data.readInt();
                    this.enableRemoteControlDisplay(_arg0, _arg1);
                    return true;
                }
                case 9: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    long _arg1 = data.readLong();
                    this.seekTo(_arg0, _arg1);
                    return true;
                }
                case 10: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    Rating _arg2 = 0 != data.readInt() ? Rating.CREATOR.createFromParcel(data) : null;
                    this.updateMetadata(_arg0, _arg1, _arg2);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        private static class Proxy
        implements IRemoteControlClient {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onInformationRequested(int generationId, int infoFlags) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(generationId);
                    _data.writeInt(infoFlags);
                    this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void informationRequestForDisplay(IRemoteControlDisplay rcd, int w, int h) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(rcd != null ? rcd.asBinder() : null);
                    _data.writeInt(w);
                    _data.writeInt(h);
                    this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setCurrentClientGenerationId(int clientGeneration) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(clientGeneration);
                    this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void plugRemoteControlDisplay(IRemoteControlDisplay rcd, int w, int h) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(rcd != null ? rcd.asBinder() : null);
                    _data.writeInt(w);
                    _data.writeInt(h);
                    this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unplugRemoteControlDisplay(IRemoteControlDisplay rcd) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(rcd != null ? rcd.asBinder() : null);
                    this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setBitmapSizeForDisplay(IRemoteControlDisplay rcd, int w, int h) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(rcd != null ? rcd.asBinder() : null);
                    _data.writeInt(w);
                    _data.writeInt(h);
                    this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setWantsSyncForDisplay(IRemoteControlDisplay rcd, boolean wantsSync) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(rcd != null ? rcd.asBinder() : null);
                    _data.writeInt(wantsSync ? 1 : 0);
                    this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void enableRemoteControlDisplay(IRemoteControlDisplay rcd, boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(rcd != null ? rcd.asBinder() : null);
                    _data.writeInt(enabled ? 1 : 0);
                    this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void seekTo(int clientGeneration, long timeMs) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(clientGeneration);
                    _data.writeLong(timeMs);
                    this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateMetadata(int clientGeneration, int key, Rating value) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(clientGeneration);
                    _data.writeInt(key);
                    if (value != null) {
                        _data.writeInt(1);
                        value.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(10, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }
}

