/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.MediaCryptoException;
import java.util.UUID;

public final class MediaCrypto {
    private long mNativeContext;

    public static final boolean isCryptoSchemeSupported(UUID uuid) {
        return MediaCrypto.isCryptoSchemeSupportedNative(MediaCrypto.getByteArrayFromUUID(uuid));
    }

    private static final byte[] getByteArrayFromUUID(UUID uuid) {
        long msb = uuid.getMostSignificantBits();
        long lsb = uuid.getLeastSignificantBits();
        byte[] uuidBytes = new byte[16];
        for (int i = 0; i < 8; ++i) {
            uuidBytes[i] = (byte)(msb >>> 8 * (7 - i));
            uuidBytes[8 + i] = (byte)(lsb >>> 8 * (7 - i));
        }
        return uuidBytes;
    }

    private static final native boolean isCryptoSchemeSupportedNative(byte[] var0);

    public MediaCrypto(UUID uuid, byte[] initData) throws MediaCryptoException {
        this.native_setup(MediaCrypto.getByteArrayFromUUID(uuid), initData);
    }

    public final native boolean requiresSecureDecoderComponent(String var1);

    protected void finalize() {
        this.native_finalize();
    }

    public final native void release();

    private static final native void native_init();

    private final native void native_setup(byte[] var1, byte[] var2) throws MediaCryptoException;

    private final native void native_finalize();

    static {
        System.loadLibrary("media_jni");
        MediaCrypto.native_init();
    }
}

