/*
 * Decompiled with CFR 0.152.
 */
package android.media.audiofx;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.UUID;

public class AudioEffect {
    private static final String TAG = "AudioEffect-JAVA";
    public static final UUID EFFECT_TYPE_ENV_REVERB;
    public static final UUID EFFECT_TYPE_PRESET_REVERB;
    public static final UUID EFFECT_TYPE_EQUALIZER;
    public static final UUID EFFECT_TYPE_BASS_BOOST;
    public static final UUID EFFECT_TYPE_VIRTUALIZER;
    public static final UUID EFFECT_TYPE_AGC;
    public static final UUID EFFECT_TYPE_AEC;
    public static final UUID EFFECT_TYPE_NS;
    public static final UUID EFFECT_TYPE_LOUDNESS_ENHANCER;
    public static final UUID EFFECT_TYPE_NULL;
    public static final int STATE_UNINITIALIZED = 0;
    public static final int STATE_INITIALIZED = 1;
    public static final int NATIVE_EVENT_CONTROL_STATUS = 0;
    public static final int NATIVE_EVENT_ENABLED_STATUS = 1;
    public static final int NATIVE_EVENT_PARAMETER_CHANGED = 2;
    public static final int SUCCESS = 0;
    public static final int ERROR = -1;
    public static final int ALREADY_EXISTS = -2;
    public static final int ERROR_NO_INIT = -3;
    public static final int ERROR_BAD_VALUE = -4;
    public static final int ERROR_INVALID_OPERATION = -5;
    public static final int ERROR_NO_MEMORY = -6;
    public static final int ERROR_DEAD_OBJECT = -7;
    public static final String EFFECT_INSERT = "Insert";
    public static final String EFFECT_AUXILIARY = "Auxiliary";
    public static final String EFFECT_PRE_PROCESSING = "Pre Processing";
    private int mState = 0;
    private final Object mStateLock = new Object();
    private int mId;
    private long mNativeAudioEffect;
    private long mJniData;
    private Descriptor mDescriptor;
    private OnEnableStatusChangeListener mEnableStatusChangeListener = null;
    private OnControlStatusChangeListener mControlChangeStatusListener = null;
    private OnParameterChangeListener mParameterChangeListener = null;
    public final Object mListenerLock = new Object();
    public NativeEventHandler mNativeEventHandler = null;
    public static final String ACTION_DISPLAY_AUDIO_EFFECT_CONTROL_PANEL = "android.media.action.DISPLAY_AUDIO_EFFECT_CONTROL_PANEL";
    public static final String ACTION_OPEN_AUDIO_EFFECT_CONTROL_SESSION = "android.media.action.OPEN_AUDIO_EFFECT_CONTROL_SESSION";
    public static final String ACTION_CLOSE_AUDIO_EFFECT_CONTROL_SESSION = "android.media.action.CLOSE_AUDIO_EFFECT_CONTROL_SESSION";
    public static final String EXTRA_AUDIO_SESSION = "android.media.extra.AUDIO_SESSION";
    public static final String EXTRA_PACKAGE_NAME = "android.media.extra.PACKAGE_NAME";
    public static final String EXTRA_CONTENT_TYPE = "android.media.extra.CONTENT_TYPE";
    public static final int CONTENT_TYPE_MUSIC = 0;
    public static final int CONTENT_TYPE_MOVIE = 1;
    public static final int CONTENT_TYPE_GAME = 2;
    public static final int CONTENT_TYPE_VOICE = 3;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AudioEffect(UUID type, UUID uuid, int priority, int audioSession) throws IllegalArgumentException, UnsupportedOperationException, RuntimeException {
        int[] id2 = new int[1];
        Object[] desc = new Descriptor[1];
        int initResult = this.native_setup(new WeakReference<AudioEffect>(this), type.toString(), uuid.toString(), priority, audioSession, id2, desc);
        if (initResult != 0 && initResult != -2) {
            Log.e(TAG, "Error code " + initResult + " when initializing AudioEffect.");
            switch (initResult) {
                case -4: {
                    throw new IllegalArgumentException("Effect type: " + type + " not supported.");
                }
                case -5: {
                    throw new UnsupportedOperationException("Effect library not loaded");
                }
            }
            throw new RuntimeException("Cannot initialize effect engine for type: " + type + " Error: " + initResult);
        }
        this.mId = id2[0];
        this.mDescriptor = desc[0];
        Object object = this.mStateLock;
        synchronized (object) {
            this.mState = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = this.mStateLock;
        synchronized (object) {
            this.native_release();
            this.mState = 0;
        }
    }

    protected void finalize() {
        this.native_finalize();
    }

    public Descriptor getDescriptor() throws IllegalStateException {
        this.checkState("getDescriptor()");
        return this.mDescriptor;
    }

    public static Descriptor[] queryEffects() {
        return (Descriptor[])AudioEffect.native_query_effects();
    }

    public static Descriptor[] queryPreProcessings(int audioSession) {
        return (Descriptor[])AudioEffect.native_query_pre_processing(audioSession);
    }

    public static boolean isEffectTypeAvailable(UUID type) {
        Descriptor[] desc = AudioEffect.queryEffects();
        for (int i = 0; i < desc.length; ++i) {
            if (!desc[i].type.equals(type)) continue;
            return true;
        }
        return false;
    }

    public int setEnabled(boolean enabled) throws IllegalStateException {
        this.checkState("setEnabled()");
        return this.native_setEnabled(enabled);
    }

    public int setParameter(byte[] param, byte[] value) throws IllegalStateException {
        this.checkState("setParameter()");
        return this.native_setParameter(param.length, param, value.length, value);
    }

    public int setParameter(int param, int value) throws IllegalStateException {
        byte[] p = AudioEffect.intToByteArray(param);
        byte[] v = AudioEffect.intToByteArray(value);
        return this.setParameter(p, v);
    }

    public int setParameter(int param, short value) throws IllegalStateException {
        byte[] p = AudioEffect.intToByteArray(param);
        byte[] v = AudioEffect.shortToByteArray(value);
        return this.setParameter(p, v);
    }

    public int setParameter(int param, byte[] value) throws IllegalStateException {
        byte[] p = AudioEffect.intToByteArray(param);
        return this.setParameter(p, value);
    }

    public int setParameter(int[] param, int[] value) throws IllegalStateException {
        if (param.length > 2 || value.length > 2) {
            return -4;
        }
        byte[] p = AudioEffect.intToByteArray(param[0]);
        if (param.length > 1) {
            byte[] p2 = AudioEffect.intToByteArray(param[1]);
            p = AudioEffect.concatArrays(p, p2);
        }
        byte[] v = AudioEffect.intToByteArray(value[0]);
        if (value.length > 1) {
            byte[] v2 = AudioEffect.intToByteArray(value[1]);
            v = AudioEffect.concatArrays(v, v2);
        }
        return this.setParameter(p, v);
    }

    public int setParameter(int[] param, short[] value) throws IllegalStateException {
        if (param.length > 2 || value.length > 2) {
            return -4;
        }
        byte[] p = AudioEffect.intToByteArray(param[0]);
        if (param.length > 1) {
            byte[] p2 = AudioEffect.intToByteArray(param[1]);
            p = AudioEffect.concatArrays(p, p2);
        }
        byte[] v = AudioEffect.shortToByteArray(value[0]);
        if (value.length > 1) {
            byte[] v2 = AudioEffect.shortToByteArray(value[1]);
            v = AudioEffect.concatArrays(v, v2);
        }
        return this.setParameter(p, v);
    }

    public int setParameter(int[] param, byte[] value) throws IllegalStateException {
        if (param.length > 2) {
            return -4;
        }
        byte[] p = AudioEffect.intToByteArray(param[0]);
        if (param.length > 1) {
            byte[] p2 = AudioEffect.intToByteArray(param[1]);
            p = AudioEffect.concatArrays(p, p2);
        }
        return this.setParameter(p, value);
    }

    public int getParameter(byte[] param, byte[] value) throws IllegalStateException {
        this.checkState("getParameter()");
        return this.native_getParameter(param.length, param, value.length, value);
    }

    public int getParameter(int param, byte[] value) throws IllegalStateException {
        byte[] p = AudioEffect.intToByteArray(param);
        return this.getParameter(p, value);
    }

    public int getParameter(int param, int[] value) throws IllegalStateException {
        byte[] v;
        if (value.length > 2) {
            return -4;
        }
        byte[] p = AudioEffect.intToByteArray(param);
        int status = this.getParameter(p, v = new byte[value.length * 4]);
        if (status == 4 || status == 8) {
            value[0] = AudioEffect.byteArrayToInt(v);
            if (status == 8) {
                value[1] = AudioEffect.byteArrayToInt(v, 4);
            }
            status /= 4;
        } else {
            status = -1;
        }
        return status;
    }

    public int getParameter(int param, short[] value) throws IllegalStateException {
        byte[] v;
        if (value.length > 2) {
            return -4;
        }
        byte[] p = AudioEffect.intToByteArray(param);
        int status = this.getParameter(p, v = new byte[value.length * 2]);
        if (status == 2 || status == 4) {
            value[0] = AudioEffect.byteArrayToShort(v);
            if (status == 4) {
                value[1] = AudioEffect.byteArrayToShort(v, 2);
            }
            status /= 2;
        } else {
            status = -1;
        }
        return status;
    }

    public int getParameter(int[] param, int[] value) throws IllegalStateException {
        byte[] v;
        int status;
        if (param.length > 2 || value.length > 2) {
            return -4;
        }
        byte[] p = AudioEffect.intToByteArray(param[0]);
        if (param.length > 1) {
            byte[] p2 = AudioEffect.intToByteArray(param[1]);
            p = AudioEffect.concatArrays(p, p2);
        }
        if ((status = this.getParameter(p, v = new byte[value.length * 4])) == 4 || status == 8) {
            value[0] = AudioEffect.byteArrayToInt(v);
            if (status == 8) {
                value[1] = AudioEffect.byteArrayToInt(v, 4);
            }
            status /= 4;
        } else {
            status = -1;
        }
        return status;
    }

    public int getParameter(int[] param, short[] value) throws IllegalStateException {
        byte[] v;
        int status;
        if (param.length > 2 || value.length > 2) {
            return -4;
        }
        byte[] p = AudioEffect.intToByteArray(param[0]);
        if (param.length > 1) {
            byte[] p2 = AudioEffect.intToByteArray(param[1]);
            p = AudioEffect.concatArrays(p, p2);
        }
        if ((status = this.getParameter(p, v = new byte[value.length * 2])) == 2 || status == 4) {
            value[0] = AudioEffect.byteArrayToShort(v);
            if (status == 4) {
                value[1] = AudioEffect.byteArrayToShort(v, 2);
            }
            status /= 2;
        } else {
            status = -1;
        }
        return status;
    }

    public int getParameter(int[] param, byte[] value) throws IllegalStateException {
        if (param.length > 2) {
            return -4;
        }
        byte[] p = AudioEffect.intToByteArray(param[0]);
        if (param.length > 1) {
            byte[] p2 = AudioEffect.intToByteArray(param[1]);
            p = AudioEffect.concatArrays(p, p2);
        }
        return this.getParameter(p, value);
    }

    public int command(int cmdCode, byte[] command, byte[] reply) throws IllegalStateException {
        this.checkState("command()");
        return this.native_command(cmdCode, command.length, command, reply.length, reply);
    }

    public int getId() throws IllegalStateException {
        this.checkState("getId()");
        return this.mId;
    }

    public boolean getEnabled() throws IllegalStateException {
        this.checkState("getEnabled()");
        return this.native_getEnabled();
    }

    public boolean hasControl() throws IllegalStateException {
        this.checkState("hasControl()");
        return this.native_hasControl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnableStatusListener(OnEnableStatusChangeListener listener) {
        Object object = this.mListenerLock;
        synchronized (object) {
            this.mEnableStatusChangeListener = listener;
        }
        if (listener != null && this.mNativeEventHandler == null) {
            this.createNativeEventHandler();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setControlStatusListener(OnControlStatusChangeListener listener) {
        Object object = this.mListenerLock;
        synchronized (object) {
            this.mControlChangeStatusListener = listener;
        }
        if (listener != null && this.mNativeEventHandler == null) {
            this.createNativeEventHandler();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParameterListener(OnParameterChangeListener listener) {
        Object object = this.mListenerLock;
        synchronized (object) {
            this.mParameterChangeListener = listener;
        }
        if (listener != null && this.mNativeEventHandler == null) {
            this.createNativeEventHandler();
        }
    }

    private void createNativeEventHandler() {
        Looper looper = Looper.myLooper();
        this.mNativeEventHandler = looper != null ? new NativeEventHandler(this, looper) : ((looper = Looper.getMainLooper()) != null ? new NativeEventHandler(this, looper) : null);
    }

    private static void postEventFromNative(Object effect_ref, int what, int arg1, int arg2, Object obj) {
        AudioEffect effect = (AudioEffect)((WeakReference)effect_ref).get();
        if (effect == null) {
            return;
        }
        if (effect.mNativeEventHandler != null) {
            Message m = effect.mNativeEventHandler.obtainMessage(what, arg1, arg2, obj);
            effect.mNativeEventHandler.sendMessage(m);
        }
    }

    private static final native void native_init();

    private final native int native_setup(Object var1, String var2, String var3, int var4, int var5, int[] var6, Object[] var7);

    private final native void native_finalize();

    private final native void native_release();

    private final native int native_setEnabled(boolean var1);

    private final native boolean native_getEnabled();

    private final native boolean native_hasControl();

    private final native int native_setParameter(int var1, byte[] var2, int var3, byte[] var4);

    private final native int native_getParameter(int var1, byte[] var2, int var3, byte[] var4);

    private final native int native_command(int var1, int var2, byte[] var3, int var4, byte[] var5);

    private static native Object[] native_query_effects();

    private static native Object[] native_query_pre_processing(int var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkState(String methodName) throws IllegalStateException {
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mState != 1) {
                throw new IllegalStateException(methodName + " called on uninitialized AudioEffect.");
            }
        }
    }

    public void checkStatus(int status) {
        if (AudioEffect.isError(status)) {
            switch (status) {
                case -4: {
                    throw new IllegalArgumentException("AudioEffect: bad parameter value");
                }
                case -5: {
                    throw new UnsupportedOperationException("AudioEffect: invalid parameter operation");
                }
            }
            throw new RuntimeException("AudioEffect: set/get parameter error");
        }
    }

    public static boolean isError(int status) {
        return status < 0;
    }

    public static int byteArrayToInt(byte[] valueBuf) {
        return AudioEffect.byteArrayToInt(valueBuf, 0);
    }

    public static int byteArrayToInt(byte[] valueBuf, int offset) {
        ByteBuffer converter = ByteBuffer.wrap(valueBuf);
        converter.order(ByteOrder.nativeOrder());
        return converter.getInt(offset);
    }

    public static byte[] intToByteArray(int value) {
        ByteBuffer converter = ByteBuffer.allocate(4);
        converter.order(ByteOrder.nativeOrder());
        converter.putInt(value);
        return converter.array();
    }

    public static short byteArrayToShort(byte[] valueBuf) {
        return AudioEffect.byteArrayToShort(valueBuf, 0);
    }

    public static short byteArrayToShort(byte[] valueBuf, int offset) {
        ByteBuffer converter = ByteBuffer.wrap(valueBuf);
        converter.order(ByteOrder.nativeOrder());
        return converter.getShort(offset);
    }

    public static byte[] shortToByteArray(short value) {
        ByteBuffer converter = ByteBuffer.allocate(2);
        converter.order(ByteOrder.nativeOrder());
        short sValue = value;
        converter.putShort(sValue);
        return converter.array();
    }

    public static byte[] concatArrays(byte[] ... arrays) {
        int len = 0;
        for (byte[] a : arrays) {
            len += a.length;
        }
        byte[] b = new byte[len];
        int offs = 0;
        for (byte[] a : arrays) {
            System.arraycopy((byte[])a, (int)0, (byte[])b, (int)offs, (int)a.length);
            offs += a.length;
        }
        return b;
    }

    static {
        System.loadLibrary("audioeffect_jni");
        AudioEffect.native_init();
        EFFECT_TYPE_ENV_REVERB = UUID.fromString("c2e5d5f0-94bd-4763-9cac-4e234d06839e");
        EFFECT_TYPE_PRESET_REVERB = UUID.fromString("47382d60-ddd8-11db-bf3a-0002a5d5c51b");
        EFFECT_TYPE_EQUALIZER = UUID.fromString("0bed4300-ddd6-11db-8f34-0002a5d5c51b");
        EFFECT_TYPE_BASS_BOOST = UUID.fromString("0634f220-ddd4-11db-a0fc-0002a5d5c51b");
        EFFECT_TYPE_VIRTUALIZER = UUID.fromString("37cc2c00-dddd-11db-8577-0002a5d5c51b");
        EFFECT_TYPE_AGC = UUID.fromString("0a8abfe0-654c-11e0-ba26-0002a5d5c51b");
        EFFECT_TYPE_AEC = UUID.fromString("7b491460-8d4d-11e0-bd61-0002a5d5c51b");
        EFFECT_TYPE_NS = UUID.fromString("58b4b260-8e06-11e0-aa8e-0002a5d5c51b");
        EFFECT_TYPE_LOUDNESS_ENHANCER = UUID.fromString("fe3199be-aed0-413f-87bb-11260eb63cf1");
        EFFECT_TYPE_NULL = UUID.fromString("ec7178ec-e5e1-4432-a3f4-4657e6795210");
    }

    private class NativeEventHandler
    extends Handler {
        private AudioEffect mAudioEffect;

        public NativeEventHandler(AudioEffect ae, Looper looper) {
            super(looper);
            this.mAudioEffect = ae;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            if (this.mAudioEffect == null) {
                return;
            }
            switch (msg.what) {
                case 1: {
                    OnEnableStatusChangeListener enableStatusChangeListener = null;
                    Object object = AudioEffect.this.mListenerLock;
                    synchronized (object) {
                        enableStatusChangeListener = this.mAudioEffect.mEnableStatusChangeListener;
                    }
                    if (enableStatusChangeListener == null) break;
                    enableStatusChangeListener.onEnableStatusChange(this.mAudioEffect, msg.arg1 != 0);
                    break;
                }
                case 0: {
                    OnControlStatusChangeListener controlStatusChangeListener = null;
                    Object object = AudioEffect.this.mListenerLock;
                    synchronized (object) {
                        controlStatusChangeListener = this.mAudioEffect.mControlChangeStatusListener;
                    }
                    if (controlStatusChangeListener == null) break;
                    controlStatusChangeListener.onControlStatusChange(this.mAudioEffect, msg.arg1 != 0);
                    break;
                }
                case 2: {
                    OnParameterChangeListener parameterChangeListener = null;
                    Object object = AudioEffect.this.mListenerLock;
                    synchronized (object) {
                        parameterChangeListener = this.mAudioEffect.mParameterChangeListener;
                    }
                    if (parameterChangeListener == null) break;
                    int vOffset = msg.arg1;
                    byte[] p = (byte[])msg.obj;
                    int status = AudioEffect.byteArrayToInt(p, 0);
                    int psize = AudioEffect.byteArrayToInt(p, 4);
                    int vsize = AudioEffect.byteArrayToInt(p, 8);
                    byte[] param = new byte[psize];
                    byte[] value = new byte[vsize];
                    System.arraycopy((byte[])p, (int)12, (byte[])param, (int)0, (int)psize);
                    System.arraycopy((byte[])p, (int)vOffset, (byte[])value, (int)0, (int)vsize);
                    parameterChangeListener.onParameterChange(this.mAudioEffect, status, param, value);
                    break;
                }
                default: {
                    Log.e(AudioEffect.TAG, "handleMessage() Unknown event type: " + msg.what);
                }
            }
        }
    }

    public static interface OnParameterChangeListener {
        public void onParameterChange(AudioEffect var1, int var2, byte[] var3, byte[] var4);
    }

    public static interface OnControlStatusChangeListener {
        public void onControlStatusChange(AudioEffect var1, boolean var2);
    }

    public static interface OnEnableStatusChangeListener {
        public void onEnableStatusChange(AudioEffect var1, boolean var2);
    }

    public static class Descriptor {
        public UUID type;
        public UUID uuid;
        public String connectMode;
        public String name;
        public String implementor;

        public Descriptor() {
        }

        public Descriptor(String type, String uuid, String connectMode, String name, String implementor) {
            this.type = UUID.fromString(type);
            this.uuid = UUID.fromString(uuid);
            this.connectMode = connectMode;
            this.name = name;
            this.implementor = implementor;
        }
    }
}

