/*
 * Decompiled with CFR 0.152.
 */
package android.media.audiopolicy;

import android.media.AudioAttributes;
import java.util.ArrayList;

public class AudioMixingRule {
    public static final int RULE_MATCH_ATTRIBUTE_USAGE = 1;
    public static final int RULE_EXCLUDE_ATTRIBUTE_USAGE = 2;
    private ArrayList<AttributeMatchCriterion> mCriteria;

    private AudioMixingRule(ArrayList<AttributeMatchCriterion> criteria) {
        this.mCriteria = criteria;
    }

    ArrayList<AttributeMatchCriterion> getCriteria() {
        return this.mCriteria;
    }

    public static class Builder {
        private ArrayList<AttributeMatchCriterion> mCriteria = new ArrayList();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Builder addRule(AudioAttributes attrToMatch, int rule) throws IllegalArgumentException {
            if (attrToMatch == null) {
                throw new IllegalArgumentException("Illegal null AudioAttributes argument");
            }
            if (rule != 1 && rule != 2) {
                throw new IllegalArgumentException("Illegal rule value " + rule);
            }
            ArrayList<AttributeMatchCriterion> arrayList = this.mCriteria;
            synchronized (arrayList) {
                for (AttributeMatchCriterion criterion : this.mCriteria) {
                    if (rule != 1 && rule != 2 || criterion.mAttr.getUsage() != attrToMatch.getUsage()) continue;
                    if (criterion.mRule == rule) {
                        return this;
                    }
                    throw new IllegalArgumentException("Contradictory rule exists for " + attrToMatch);
                }
                this.mCriteria.add(new AttributeMatchCriterion(attrToMatch, rule));
            }
            return this;
        }

        public AudioMixingRule build() {
            return new AudioMixingRule(this.mCriteria);
        }
    }

    static final class AttributeMatchCriterion {
        AudioAttributes mAttr;
        int mRule;

        AttributeMatchCriterion(AudioAttributes attributes, int rule) {
            this.mAttr = attributes;
            this.mRule = rule;
        }
    }
}

