/*
 * Decompiled with CFR 0.152.
 */
package android.media.tv;

import android.media.tv.TvInputInfo;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface ITvInputServiceCallback
extends IInterface {
    public void addHardwareTvInput(int var1, TvInputInfo var2) throws RemoteException;

    public void addHdmiTvInput(int var1, TvInputInfo var2) throws RemoteException;

    public void removeTvInput(String var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ITvInputServiceCallback {
        private static final String DESCRIPTOR = "android.media.tv.ITvInputServiceCallback";
        static final int TRANSACTION_addHardwareTvInput = 1;
        static final int TRANSACTION_addHdmiTvInput = 2;
        static final int TRANSACTION_removeTvInput = 3;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ITvInputServiceCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof ITvInputServiceCallback) {
                return (ITvInputServiceCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            switch (code) {
                case 1598968902: {
                    reply.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    TvInputInfo _arg1 = 0 != data.readInt() ? TvInputInfo.CREATOR.createFromParcel(data) : null;
                    this.addHardwareTvInput(_arg0, _arg1);
                    return true;
                }
                case 2: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    TvInputInfo _arg1 = 0 != data.readInt() ? TvInputInfo.CREATOR.createFromParcel(data) : null;
                    this.addHdmiTvInput(_arg0, _arg1);
                    return true;
                }
                case 3: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    this.removeTvInput(_arg0);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        private static class Proxy
        implements ITvInputServiceCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addHardwareTvInput(int deviceId, TvInputInfo inputInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    if (inputInfo != null) {
                        _data.writeInt(1);
                        inputInfo.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addHdmiTvInput(int id2, TvInputInfo inputInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(id2);
                    if (inputInfo != null) {
                        _data.writeInt(1);
                        inputInfo.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeTvInput(String inputId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(inputId);
                    this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }
}

