/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.LinkProperties;
import android.net.NetworkUtils;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.provider.Settings;
import android.util.Log;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;

public final class DnsPinger
extends Handler {
    private static final boolean DBG = false;
    private static final int RECEIVE_POLL_INTERVAL_MS = 200;
    private static final int DNS_PORT = 53;
    private static final int SOCKET_TIMEOUT_MS = 1;
    private static final Random sRandom = new Random();
    private static final AtomicInteger sCounter = new AtomicInteger();
    private ConnectivityManager mConnectivityManager = null;
    private final Context mContext;
    private final int mConnectionType;
    private final Handler mTarget;
    private final ArrayList<InetAddress> mDefaultDns;
    private String TAG;
    private AtomicInteger mCurrentToken = new AtomicInteger();
    private static final int BASE = 327680;
    public static final int DNS_PING_RESULT = 327680;
    public static final int TIMEOUT = -1;
    public static final int SOCKET_EXCEPTION = -2;
    private static final int ACTION_PING_DNS = 327681;
    private static final int ACTION_LISTEN_FOR_RESPONSE = 327682;
    private static final int ACTION_CANCEL_ALL_PINGS = 327683;
    private List<ActivePing> mActivePings = new ArrayList<ActivePing>();
    private int mEventCounter;
    private static final byte[] mDnsQuery = new byte[]{0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 3, 119, 119, 119, 6, 103, 111, 111, 103, 108, 101, 3, 99, 111, 109, 0, 0, 1, 0, 1};

    public DnsPinger(Context context, String TAG, Looper looper, Handler target, int connectionType) {
        super(looper);
        this.TAG = TAG;
        this.mContext = context;
        this.mTarget = target;
        this.mConnectionType = connectionType;
        if (!ConnectivityManager.isNetworkTypeValid(connectionType)) {
            throw new IllegalArgumentException("Invalid connectionType in constructor: " + connectionType);
        }
        this.mDefaultDns = new ArrayList();
        this.mDefaultDns.add(this.getDefaultDns());
        this.mEventCounter = 0;
    }

    @Override
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 327681: {
                DnsArg dnsArg = (DnsArg)msg.obj;
                if (dnsArg.seq != this.mCurrentToken.get()) break;
                try {
                    ActivePing newActivePing = new ActivePing();
                    InetAddress dnsAddress = dnsArg.dns;
                    newActivePing.internalId = msg.arg1;
                    newActivePing.timeout = msg.arg2;
                    newActivePing.socket = new DatagramSocket();
                    newActivePing.socket.setSoTimeout(1);
                    try {
                        newActivePing.socket.setNetworkInterface(NetworkInterface.getByName(this.getCurrentLinkProperties().getInterfaceName()));
                    }
                    catch (Exception e) {
                        this.loge("sendDnsPing::Error binding to socket " + e);
                    }
                    newActivePing.packetId = (short)sRandom.nextInt();
                    byte[] buf = (byte[])mDnsQuery.clone();
                    buf[0] = (byte)(newActivePing.packetId >> 8);
                    buf[1] = (byte)newActivePing.packetId;
                    DatagramPacket packet = new DatagramPacket(buf, buf.length, dnsAddress, 53);
                    newActivePing.socket.send(packet);
                    this.mActivePings.add(newActivePing);
                    ++this.mEventCounter;
                    this.sendMessageDelayed(this.obtainMessage(327682, this.mEventCounter, 0), 200L);
                }
                catch (IOException e) {
                    this.sendResponse(msg.arg1, -9999, -2);
                }
                break;
            }
            case 327682: {
                if (msg.arg1 != this.mEventCounter) break;
                for (ActivePing curPing : this.mActivePings) {
                    try {
                        byte[] responseBuf = new byte[2];
                        DatagramPacket replyPacket = new DatagramPacket(responseBuf, 2);
                        curPing.socket.receive(replyPacket);
                        if (responseBuf[0] != (byte)(curPing.packetId >> 8) || responseBuf[1] != (byte)curPing.packetId) continue;
                        curPing.result = (int)(SystemClock.elapsedRealtime() - curPing.start);
                    }
                    catch (SocketTimeoutException e) {
                    }
                    catch (Exception e) {
                        curPing.result = -2;
                    }
                }
                Iterator<ActivePing> iter = this.mActivePings.iterator();
                while (iter.hasNext()) {
                    ActivePing curPing;
                    curPing = iter.next();
                    if (curPing.result != null) {
                        this.sendResponse(curPing.internalId, curPing.packetId, curPing.result);
                        curPing.socket.close();
                        iter.remove();
                        continue;
                    }
                    if (SystemClock.elapsedRealtime() <= curPing.start + (long)curPing.timeout) continue;
                    this.sendResponse(curPing.internalId, curPing.packetId, -1);
                    curPing.socket.close();
                    iter.remove();
                }
                if (this.mActivePings.isEmpty()) break;
                this.sendMessageDelayed(this.obtainMessage(327682, this.mEventCounter, 0), 200L);
                break;
            }
            case 327683: {
                for (ActivePing activePing : this.mActivePings) {
                    activePing.socket.close();
                }
                this.mActivePings.clear();
            }
        }
    }

    public List<InetAddress> getDnsList() {
        LinkProperties curLinkProps = this.getCurrentLinkProperties();
        if (curLinkProps == null) {
            this.loge("getCurLinkProperties:: LP for type" + this.mConnectionType + " is null!");
            return this.mDefaultDns;
        }
        List<InetAddress> dnses = curLinkProps.getDnsServers();
        if (dnses == null || dnses.size() == 0) {
            this.loge("getDns::LinkProps has null dns - returning default");
            return this.mDefaultDns;
        }
        return new ArrayList<InetAddress>(dnses);
    }

    public int pingDnsAsync(InetAddress dns, int timeout, int delay) {
        int id2 = sCounter.incrementAndGet();
        this.sendMessageDelayed(this.obtainMessage(327681, id2, timeout, new DnsArg(dns, this.mCurrentToken.get())), delay);
        return id2;
    }

    public void cancelPings() {
        this.mCurrentToken.incrementAndGet();
        this.obtainMessage(327683).sendToTarget();
    }

    private void sendResponse(int internalId, int externalId, int responseVal) {
        this.mTarget.sendMessage(this.obtainMessage(327680, internalId, responseVal));
    }

    private LinkProperties getCurrentLinkProperties() {
        if (this.mConnectivityManager == null) {
            this.mConnectivityManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        }
        return this.mConnectivityManager.getLinkProperties(this.mConnectionType);
    }

    private InetAddress getDefaultDns() {
        String dns = Settings.Global.getString(this.mContext.getContentResolver(), "default_dns_server");
        if (dns == null || dns.length() == 0) {
            dns = this.mContext.getResources().getString(17039400);
        }
        try {
            return NetworkUtils.numericToInetAddress(dns);
        }
        catch (IllegalArgumentException e) {
            this.loge("getDefaultDns::malformed default dns address");
            return null;
        }
    }

    private void log(String s) {
        Log.d(this.TAG, s);
    }

    private void loge(String s) {
        Log.e(this.TAG, s);
    }

    private class DnsArg {
        InetAddress dns;
        int seq;

        DnsArg(InetAddress d, int s) {
            this.dns = d;
            this.seq = s;
        }
    }

    private class ActivePing {
        DatagramSocket socket;
        int internalId;
        short packetId;
        int timeout;
        Integer result;
        long start = SystemClock.elapsedRealtime();

        private ActivePing() {
        }
    }
}

