/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.BaseNetworkStateTracker;
import android.net.LinkProperties;
import android.net.LinkQualityInfo;
import android.net.MobileLinkQualityInfo;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.SamplingDataTracker;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.telephony.PhoneStateListener;
import android.telephony.SignalStrength;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Slog;
import com.android.internal.telephony.ITelephony;
import com.android.internal.telephony.PhoneConstants;
import com.android.internal.util.AsyncChannel;
import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.util.concurrent.atomic.AtomicBoolean;

public class MobileDataStateTracker
extends BaseNetworkStateTracker {
    private static final String TAG = "MobileDataStateTracker";
    private static final boolean DBG = false;
    private static final boolean VDBG = false;
    private PhoneConstants.DataState mMobileDataState;
    private ITelephony mPhoneService;
    private String mApnType;
    private NetworkInfo mNetworkInfo;
    private boolean mTeardownRequested = false;
    private Handler mTarget;
    private Context mContext;
    private LinkProperties mLinkProperties;
    private boolean mPrivateDnsRouteSet = false;
    private boolean mDefaultRouteSet = false;
    protected boolean mUserDataEnabled = true;
    protected boolean mPolicyDataEnabled = true;
    private Handler mHandler;
    private AsyncChannel mDataConnectionTrackerAc;
    private AtomicBoolean mIsCaptivePortal = new AtomicBoolean(false);
    private SignalStrength mSignalStrength;
    private SamplingDataTracker mSamplingDataTracker = new SamplingDataTracker();
    private static final int UNKNOWN = Integer.MAX_VALUE;
    private final PhoneStateListener mPhoneStateListener = new PhoneStateListener(){

        @Override
        public void onSignalStrengthsChanged(SignalStrength signalStrength) {
            MobileDataStateTracker.this.mSignalStrength = signalStrength;
        }
    };
    private static NetworkDataEntry[] mTheoreticalBWTable = new NetworkDataEntry[]{new NetworkDataEntry(2, 237, 118, Integer.MAX_VALUE), new NetworkDataEntry(1, 48, 40, Integer.MAX_VALUE), new NetworkDataEntry(3, 384, 64, Integer.MAX_VALUE), new NetworkDataEntry(8, 14400, Integer.MAX_VALUE, Integer.MAX_VALUE), new NetworkDataEntry(9, 14400, 5760, Integer.MAX_VALUE), new NetworkDataEntry(10, 14400, 5760, Integer.MAX_VALUE), new NetworkDataEntry(15, 21000, 5760, Integer.MAX_VALUE), new NetworkDataEntry(4, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE), new NetworkDataEntry(7, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE), new NetworkDataEntry(5, 2468, 153, Integer.MAX_VALUE), new NetworkDataEntry(6, 3072, 1800, Integer.MAX_VALUE), new NetworkDataEntry(12, 14700, 1800, Integer.MAX_VALUE), new NetworkDataEntry(11, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE), new NetworkDataEntry(13, 100000, 50000, Integer.MAX_VALUE), new NetworkDataEntry(14, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE)};

    public MobileDataStateTracker(int netType, String tag) {
        this.mNetworkInfo = new NetworkInfo(netType, TelephonyManager.getDefault().getNetworkType(), tag, TelephonyManager.getDefault().getNetworkTypeName());
        this.mApnType = MobileDataStateTracker.networkTypeToApnType(netType);
    }

    @Override
    public void startMonitoring(Context context, Handler target) {
        this.mTarget = target;
        this.mContext = context;
        this.mHandler = new MdstHandler(target.getLooper(), this);
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.ANY_DATA_STATE");
        filter.addAction("android.intent.action.DATA_CONNECTION_CONNECTED_TO_PROVISIONING_APN");
        filter.addAction("android.intent.action.DATA_CONNECTION_FAILED");
        this.mContext.registerReceiver(new MobileDataStateReceiver(), filter);
        this.mMobileDataState = PhoneConstants.DataState.DISCONNECTED;
        TelephonyManager tm = (TelephonyManager)this.mContext.getSystemService("phone");
        tm.listen(this.mPhoneStateListener, 256);
    }

    @Override
    public boolean isPrivateDnsRouteSet() {
        return this.mPrivateDnsRouteSet;
    }

    @Override
    public void privateDnsRouteSet(boolean enabled) {
        this.mPrivateDnsRouteSet = enabled;
    }

    @Override
    public NetworkInfo getNetworkInfo() {
        return this.mNetworkInfo;
    }

    @Override
    public boolean isDefaultRouteSet() {
        return this.mDefaultRouteSet;
    }

    @Override
    public void defaultRouteSet(boolean enabled) {
        this.mDefaultRouteSet = enabled;
    }

    public void releaseWakeLock() {
    }

    private void updateLinkProperitesAndCapatilities(Intent intent) {
        this.mLinkProperties = (LinkProperties)intent.getParcelableExtra("linkProperties");
        if (this.mLinkProperties == null) {
            this.loge("CONNECTED event did not supply link properties.");
            this.mLinkProperties = new LinkProperties();
        }
        this.mLinkProperties.setMtu(this.mContext.getResources().getInteger(17694832));
        this.mNetworkCapabilities = (NetworkCapabilities)intent.getParcelableExtra("networkCapabilities");
        if (this.mNetworkCapabilities == null) {
            this.loge("CONNECTED event did not supply network capabilities.");
            this.mNetworkCapabilities = new NetworkCapabilities();
        }
    }

    private void getPhoneService(boolean forceRefresh) {
        if (this.mPhoneService == null || forceRefresh) {
            this.mPhoneService = ITelephony.Stub.asInterface(ServiceManager.getService("phone"));
        }
    }

    @Override
    public boolean isAvailable() {
        return this.mNetworkInfo.isAvailable();
    }

    @Override
    public String getTcpBufferSizesPropName() {
        String networkTypeStr = "unknown";
        TelephonyManager tm = new TelephonyManager(this.mContext);
        switch (tm.getNetworkType()) {
            case 1: {
                networkTypeStr = "gprs";
                break;
            }
            case 2: {
                networkTypeStr = "edge";
                break;
            }
            case 3: {
                networkTypeStr = "umts";
                break;
            }
            case 8: {
                networkTypeStr = "hsdpa";
                break;
            }
            case 9: {
                networkTypeStr = "hsupa";
                break;
            }
            case 10: {
                networkTypeStr = "hspa";
                break;
            }
            case 15: {
                networkTypeStr = "hspap";
                break;
            }
            case 4: {
                networkTypeStr = "cdma";
                break;
            }
            case 7: {
                networkTypeStr = "1xrtt";
                break;
            }
            case 5: {
                networkTypeStr = "evdo";
                break;
            }
            case 6: {
                networkTypeStr = "evdo";
                break;
            }
            case 12: {
                networkTypeStr = "evdo";
                break;
            }
            case 11: {
                networkTypeStr = "iden";
                break;
            }
            case 13: {
                networkTypeStr = "lte";
                break;
            }
            case 14: {
                networkTypeStr = "ehrpd";
                break;
            }
            default: {
                this.loge("unknown network type: " + tm.getNetworkType());
            }
        }
        return "net.tcp.buffersize." + networkTypeStr;
    }

    @Override
    public boolean teardown() {
        this.setTeardownRequested(true);
        return this.setEnableApn(this.mApnType, false) != 3;
    }

    public boolean isReady() {
        return this.mDataConnectionTrackerAc != null;
    }

    @Override
    public void captivePortalCheckCompleted(boolean isCaptivePortal) {
        if (this.mIsCaptivePortal.getAndSet(isCaptivePortal) != isCaptivePortal) {
            this.setEnableFailFastMobileData(isCaptivePortal ? 1 : 0);
        }
    }

    private void setDetailedState(NetworkInfo.DetailedState state, String reason, String extraInfo) {
        if (state != this.mNetworkInfo.getDetailedState()) {
            boolean wasConnecting = this.mNetworkInfo.getState() == NetworkInfo.State.CONNECTING;
            String lastReason = this.mNetworkInfo.getReason();
            if (wasConnecting && state == NetworkInfo.DetailedState.CONNECTED && reason == null && lastReason != null) {
                reason = lastReason;
            }
            this.mNetworkInfo.setDetailedState(state, reason, extraInfo);
            Message msg = this.mTarget.obtainMessage(458752, new NetworkInfo(this.mNetworkInfo));
            msg.sendToTarget();
        }
    }

    @Override
    public void setTeardownRequested(boolean isRequested) {
        this.mTeardownRequested = isRequested;
    }

    @Override
    public boolean isTeardownRequested() {
        return this.mTeardownRequested;
    }

    @Override
    public boolean reconnect() {
        boolean retValue = false;
        this.setTeardownRequested(false);
        switch (this.setEnableApn(this.mApnType, true)) {
            case 0: {
                retValue = true;
                break;
            }
            case 1: {
                this.mNetworkInfo.setDetailedState(NetworkInfo.DetailedState.IDLE, null, null);
                retValue = true;
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            default: {
                this.loge("Error in reconnect - unexpected response.");
            }
        }
        return retValue;
    }

    @Override
    public boolean setRadio(boolean turnOn) {
        this.getPhoneService(false);
        for (int retry = 0; retry < 2; ++retry) {
            if (this.mPhoneService == null) {
                this.loge("Ignoring mobile radio request because could not acquire PhoneService");
                break;
            }
            try {
                return this.mPhoneService.setRadio(turnOn);
            }
            catch (RemoteException e) {
                if (retry != 0) continue;
                this.getPhoneService(true);
                continue;
            }
        }
        this.loge("Could not set radio power to " + (turnOn ? "on" : "off"));
        return false;
    }

    public void setInternalDataEnable(boolean enabled) {
        AsyncChannel channel = this.mDataConnectionTrackerAc;
        if (channel != null) {
            channel.sendMessage(270363, enabled ? 1 : 0);
        }
    }

    @Override
    public void setUserDataEnable(boolean enabled) {
        AsyncChannel channel = this.mDataConnectionTrackerAc;
        if (channel != null) {
            channel.sendMessage(270366, enabled ? 1 : 0);
            this.mUserDataEnabled = enabled;
        }
    }

    @Override
    public void setPolicyDataEnable(boolean enabled) {
        AsyncChannel channel = this.mDataConnectionTrackerAc;
        if (channel != null) {
            channel.sendMessage(270368, enabled ? 1 : 0);
            this.mPolicyDataEnabled = enabled;
        }
    }

    public void setEnableFailFastMobileData(int enabled) {
        AsyncChannel channel = this.mDataConnectionTrackerAc;
        if (channel != null) {
            channel.sendMessage(270372, enabled);
        }
    }

    @Override
    public void setDependencyMet(boolean met) {
        Bundle bundle = Bundle.forPair("apnType", this.mApnType);
        try {
            Message msg = Message.obtain();
            msg.what = 270367;
            msg.arg1 = met ? 1 : 0;
            msg.setData(bundle);
            this.mDataConnectionTrackerAc.sendMessage(msg);
        }
        catch (NullPointerException e) {
            this.loge("setDependencyMet: X mAc was null" + e);
        }
    }

    public void enableMobileProvisioning(String url) {
        AsyncChannel channel = this.mDataConnectionTrackerAc;
        if (channel != null) {
            Message msg = Message.obtain();
            msg.what = 270373;
            msg.setData(Bundle.forPair("provisioningUrl", url));
            channel.sendMessage(msg);
        }
    }

    public boolean isProvisioningNetwork() {
        boolean retVal;
        try {
            Message msg = Message.obtain();
            msg.what = 270374;
            msg.setData(Bundle.forPair("apnType", this.mApnType));
            Message result = this.mDataConnectionTrackerAc.sendMessageSynchronously(msg);
            retVal = result.arg1 == 1;
        }
        catch (NullPointerException e) {
            this.loge("isProvisioningNetwork: X " + e);
            retVal = false;
        }
        return retVal;
    }

    @Override
    public void addStackedLink(LinkProperties link) {
        this.mLinkProperties.addStackedLink(link);
    }

    @Override
    public void removeStackedLink(LinkProperties link) {
        this.mLinkProperties.removeStackedLink(link);
    }

    public String toString() {
        CharArrayWriter writer = new CharArrayWriter();
        PrintWriter pw = new PrintWriter(writer);
        pw.print("Mobile data state: ");
        pw.println((Object)this.mMobileDataState);
        pw.print("Data enabled: user=");
        pw.print(this.mUserDataEnabled);
        pw.print(", policy=");
        pw.println(this.mPolicyDataEnabled);
        return writer.toString();
    }

    private int setEnableApn(String apnType, boolean enable) {
        this.getPhoneService(false);
        for (int retry = 0; retry < 2; ++retry) {
            if (this.mPhoneService != null) continue;
            this.loge("Ignoring feature request because could not acquire PhoneService");
            break;
        }
        this.loge("Could not " + (enable ? "enable" : "disable") + " APN type \"" + apnType + "\"");
        return 3;
    }

    public static String networkTypeToApnType(int netType) {
        switch (netType) {
            case 0: {
                return "default";
            }
            case 2: {
                return "mms";
            }
            case 3: {
                return "supl";
            }
            case 4: {
                return "dun";
            }
            case 5: {
                return "hipri";
            }
            case 10: {
                return "fota";
            }
            case 11: {
                return "ims";
            }
            case 12: {
                return "cbs";
            }
            case 14: {
                return "ia";
            }
            case 15: {
                return "emergency";
            }
        }
        MobileDataStateTracker.sloge("Error mapping networkType " + netType + " to apnType.");
        return null;
    }

    @Override
    public LinkProperties getLinkProperties() {
        return new LinkProperties(this.mLinkProperties);
    }

    @Override
    public void supplyMessenger(Messenger messenger) {
        AsyncChannel ac = new AsyncChannel();
        ac.connect(this.mContext, this.mHandler, messenger);
    }

    private void log(String s) {
        Slog.d(TAG, this.mApnType + ": " + s);
    }

    private void loge(String s) {
        Slog.e(TAG, this.mApnType + ": " + s);
    }

    private static void sloge(String s) {
        Slog.e(TAG, s);
    }

    @Override
    public LinkQualityInfo getLinkQualityInfo() {
        SignalStrength ss;
        if (this.mNetworkInfo == null || this.mNetworkInfo.getType() == -1) {
            return null;
        }
        MobileLinkQualityInfo li = new MobileLinkQualityInfo();
        li.setNetworkType(this.mNetworkInfo.getType());
        this.mSamplingDataTracker.setCommonLinkQualityInfoFields(li);
        if (this.mNetworkInfo.getSubtype() != 0) {
            li.setMobileNetworkType(this.mNetworkInfo.getSubtype());
            NetworkDataEntry entry = MobileDataStateTracker.getNetworkDataEntry(this.mNetworkInfo.getSubtype());
            if (entry != null) {
                li.setTheoreticalRxBandwidth(entry.downloadBandwidth);
                li.setTheoreticalRxBandwidth(entry.uploadBandwidth);
                li.setTheoreticalLatency(entry.latency);
            }
            if (this.mSignalStrength != null) {
                li.setNormalizedSignalStrength(MobileDataStateTracker.getNormalizedSignalStrength(li.getMobileNetworkType(), this.mSignalStrength));
            }
        }
        if ((ss = this.mSignalStrength) != null) {
            li.setRssi(ss.getGsmSignalStrength());
            li.setGsmErrorRate(ss.getGsmBitErrorRate());
            li.setCdmaDbm(ss.getCdmaDbm());
            li.setCdmaEcio(ss.getCdmaEcio());
            li.setEvdoDbm(ss.getEvdoDbm());
            li.setEvdoEcio(ss.getEvdoEcio());
            li.setEvdoSnr(ss.getEvdoSnr());
            li.setLteSignalStrength(ss.getLteSignalStrength());
            li.setLteRsrp(ss.getLteRsrp());
            li.setLteRsrq(ss.getLteRsrq());
            li.setLteRssnr(ss.getLteRssnr());
            li.setLteCqi(ss.getLteCqi());
        }
        return li;
    }

    private static NetworkDataEntry getNetworkDataEntry(int networkType) {
        for (NetworkDataEntry entry : mTheoreticalBWTable) {
            if (entry.networkType != networkType) continue;
            return entry;
        }
        Slog.e(TAG, "Could not find Theoretical BW entry for " + String.valueOf(networkType));
        return null;
    }

    private static int getNormalizedSignalStrength(int networkType, SignalStrength ss) {
        int level;
        switch (networkType) {
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 15: {
                level = ss.getGsmLevel();
                break;
            }
            case 4: 
            case 7: {
                level = ss.getCdmaLevel();
                break;
            }
            case 5: 
            case 6: 
            case 12: {
                level = ss.getEvdoLevel();
                break;
            }
            case 13: {
                level = ss.getLteLevel();
                break;
            }
            default: {
                return Integer.MAX_VALUE;
            }
        }
        return level * 100 / 5;
    }

    @Override
    public void startSampling(SamplingDataTracker.SamplingSnapshot s) {
        this.mSamplingDataTracker.startSampling(s);
    }

    @Override
    public void stopSampling(SamplingDataTracker.SamplingSnapshot s) {
        this.mSamplingDataTracker.stopSampling(s);
    }

    static class NetworkDataEntry {
        public int networkType;
        public int downloadBandwidth;
        public int uploadBandwidth;
        public int latency;

        NetworkDataEntry(int i1, int i2, int i3, int i4) {
            this.networkType = i1;
            this.downloadBandwidth = i2;
            this.uploadBandwidth = i3;
            this.latency = i4;
        }
    }

    private class MobileDataStateReceiver
    extends BroadcastReceiver {
        private MobileDataStateReceiver() {
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("android.intent.action.DATA_CONNECTION_CONNECTED_TO_PROVISIONING_APN")) {
                String apnName = intent.getStringExtra("apn");
                String apnType = intent.getStringExtra("apnType");
                if (!TextUtils.equals(MobileDataStateTracker.this.mApnType, apnType)) {
                    return;
                }
                MobileDataStateTracker.this.mMobileDataState = PhoneConstants.DataState.CONNECTING;
                MobileDataStateTracker.this.updateLinkProperitesAndCapatilities(intent);
                MobileDataStateTracker.this.mNetworkInfo.setIsConnectedToProvisioningNetwork(true);
                MobileDataStateTracker.this.setDetailedState(NetworkInfo.DetailedState.SUSPENDED, "", apnName);
            } else if (intent.getAction().equals("android.intent.action.ANY_DATA_STATE")) {
                String apnType = intent.getStringExtra("apnType");
                if (!TextUtils.equals(apnType, MobileDataStateTracker.this.mApnType)) {
                    return;
                }
                MobileDataStateTracker.this.mNetworkInfo.setIsConnectedToProvisioningNetwork(false);
                int oldSubtype = MobileDataStateTracker.this.mNetworkInfo.getSubtype();
                int newSubType = TelephonyManager.getDefault().getNetworkType();
                String subTypeName = TelephonyManager.getDefault().getNetworkTypeName();
                MobileDataStateTracker.this.mNetworkInfo.setSubtype(newSubType, subTypeName);
                if (newSubType != oldSubtype && MobileDataStateTracker.this.mNetworkInfo.isConnected()) {
                    Message msg = MobileDataStateTracker.this.mTarget.obtainMessage(458755, oldSubtype, 0, MobileDataStateTracker.this.mNetworkInfo);
                    msg.sendToTarget();
                }
                PhoneConstants.DataState state = Enum.valueOf(PhoneConstants.DataState.class, intent.getStringExtra("state"));
                String reason = intent.getStringExtra("reason");
                String apnName = intent.getStringExtra("apn");
                MobileDataStateTracker.this.mNetworkInfo.setRoaming(intent.getBooleanExtra("networkRoaming", false));
                MobileDataStateTracker.this.mNetworkInfo.setIsAvailable(!intent.getBooleanExtra("networkUnvailable", false));
                if (MobileDataStateTracker.this.mMobileDataState != state) {
                    MobileDataStateTracker.this.mMobileDataState = state;
                    switch (state) {
                        case DISCONNECTED: {
                            if (MobileDataStateTracker.this.isTeardownRequested()) {
                                MobileDataStateTracker.this.setTeardownRequested(false);
                            }
                            MobileDataStateTracker.this.setDetailedState(NetworkInfo.DetailedState.DISCONNECTED, reason, apnName);
                            break;
                        }
                        case CONNECTING: {
                            MobileDataStateTracker.this.setDetailedState(NetworkInfo.DetailedState.CONNECTING, reason, apnName);
                            break;
                        }
                        case SUSPENDED: {
                            MobileDataStateTracker.this.setDetailedState(NetworkInfo.DetailedState.SUSPENDED, reason, apnName);
                            break;
                        }
                        case CONNECTED: {
                            MobileDataStateTracker.this.updateLinkProperitesAndCapatilities(intent);
                            MobileDataStateTracker.this.setDetailedState(NetworkInfo.DetailedState.CONNECTED, reason, apnName);
                        }
                    }
                    MobileDataStateTracker.this.mSamplingDataTracker.resetSamplingData();
                } else if (TextUtils.equals(reason, "linkPropertiesChanged")) {
                    MobileDataStateTracker.this.mLinkProperties = (LinkProperties)intent.getParcelableExtra("linkProperties");
                    if (MobileDataStateTracker.this.mLinkProperties == null) {
                        MobileDataStateTracker.this.loge("No link property in LINK_PROPERTIES change event.");
                        MobileDataStateTracker.this.mLinkProperties = new LinkProperties();
                    }
                    MobileDataStateTracker.this.mNetworkInfo.setDetailedState(MobileDataStateTracker.this.mNetworkInfo.getDetailedState(), reason, MobileDataStateTracker.this.mNetworkInfo.getExtraInfo());
                    Message msg = MobileDataStateTracker.this.mTarget.obtainMessage(458753, MobileDataStateTracker.this.mNetworkInfo);
                    msg.sendToTarget();
                }
            } else if (intent.getAction().equals("android.intent.action.DATA_CONNECTION_FAILED")) {
                String apnType = intent.getStringExtra("apnType");
                if (!TextUtils.equals(apnType, MobileDataStateTracker.this.mApnType)) {
                    return;
                }
                MobileDataStateTracker.this.mNetworkInfo.setIsConnectedToProvisioningNetwork(false);
                String reason = intent.getStringExtra("reason");
                String apnName = intent.getStringExtra("apn");
                MobileDataStateTracker.this.setDetailedState(NetworkInfo.DetailedState.FAILED, reason, apnName);
            }
        }
    }

    static class MdstHandler
    extends Handler {
        private MobileDataStateTracker mMdst;

        MdstHandler(Looper looper, MobileDataStateTracker mdst) {
            super(looper);
            this.mMdst = mdst;
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 69632: {
                    if (msg.arg1 != 0) break;
                    this.mMdst.mDataConnectionTrackerAc = (AsyncChannel)msg.obj;
                    break;
                }
                case 69636: {
                    this.mMdst.mDataConnectionTrackerAc = null;
                    break;
                }
            }
        }
    }
}

