/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import android.content.Context;
import android.net.http.Connection;
import android.net.http.Request;
import android.net.http.RequestFeeder;
import android.net.http.RequestQueue;
import android.os.Process;
import android.os.SystemClock;

class ConnectionThread
extends Thread {
    static final int WAIT_TIMEOUT = 5000;
    static final int WAIT_TICK = 1000;
    long mCurrentThreadTime;
    long mTotalThreadTime;
    private boolean mWaiting;
    private volatile boolean mRunning = true;
    private Context mContext;
    private RequestQueue.ConnectionManager mConnectionManager;
    private RequestFeeder mRequestFeeder;
    private int mId;
    Connection mConnection;

    ConnectionThread(Context context, int id2, RequestQueue.ConnectionManager connectionManager, RequestFeeder requestFeeder) {
        this.mContext = context;
        this.setName("http" + id2);
        this.mId = id2;
        this.mConnectionManager = connectionManager;
        this.mRequestFeeder = requestFeeder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void requestStop() {
        RequestFeeder requestFeeder = this.mRequestFeeder;
        synchronized (requestFeeder) {
            this.mRunning = false;
            this.mRequestFeeder.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Process.setThreadPriority(1);
        this.mCurrentThreadTime = 0L;
        this.mTotalThreadTime = 0L;
        while (this.mRunning) {
            Request request;
            if (this.mCurrentThreadTime == -1L) {
                this.mCurrentThreadTime = SystemClock.currentThreadTimeMillis();
            }
            if ((request = this.mRequestFeeder.getRequest()) == null) {
                RequestFeeder requestFeeder = this.mRequestFeeder;
                synchronized (requestFeeder) {
                    this.mWaiting = true;
                    try {
                        this.mRequestFeeder.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.mWaiting = false;
                    if (this.mCurrentThreadTime != 0L) {
                        this.mCurrentThreadTime = SystemClock.currentThreadTimeMillis();
                    }
                    continue;
                }
            }
            this.mConnection = this.mConnectionManager.getConnection(this.mContext, request.mHost);
            this.mConnection.processRequests(request);
            if (this.mConnection.getCanPersist()) {
                if (!this.mConnectionManager.recycleConnection(this.mConnection)) {
                    this.mConnection.closeConnection();
                }
            } else {
                this.mConnection.closeConnection();
            }
            this.mConnection = null;
            if (this.mCurrentThreadTime <= 0L) continue;
            long start = this.mCurrentThreadTime;
            this.mCurrentThreadTime = SystemClock.currentThreadTimeMillis();
            this.mTotalThreadTime += this.mCurrentThreadTime - start;
        }
    }

    @Override
    public synchronized String toString() {
        String con = this.mConnection == null ? "" : this.mConnection.toString();
        String active = this.mWaiting ? "w" : "a";
        return "cid " + this.mId + " " + active + " " + con;
    }
}

