/*
 * Decompiled with CFR 0.152.
 */
package android.provider;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.content.UriMatcher;
import android.content.pm.ProviderInfo;
import android.content.res.AssetFileDescriptor;
import android.database.Cursor;
import android.graphics.Point;
import android.net.Uri;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.ParcelFileDescriptor;
import android.provider.DocumentsContract;
import android.util.Log;
import java.io.FileNotFoundException;
import java.util.Objects;
import libcore.io.IoUtils;

public abstract class DocumentsProvider
extends ContentProvider {
    private static final String TAG = "DocumentsProvider";
    private static final int MATCH_ROOTS = 1;
    private static final int MATCH_ROOT = 2;
    private static final int MATCH_RECENT = 3;
    private static final int MATCH_SEARCH = 4;
    private static final int MATCH_DOCUMENT = 5;
    private static final int MATCH_CHILDREN = 6;
    private static final int MATCH_DOCUMENT_TREE = 7;
    private static final int MATCH_CHILDREN_TREE = 8;
    private String mAuthority;
    private UriMatcher mMatcher;

    @Override
    public void attachInfo(Context context, ProviderInfo info) {
        this.mAuthority = info.authority;
        this.mMatcher = new UriMatcher(-1);
        this.mMatcher.addURI(this.mAuthority, "root", 1);
        this.mMatcher.addURI(this.mAuthority, "root/*", 2);
        this.mMatcher.addURI(this.mAuthority, "root/*/recent", 3);
        this.mMatcher.addURI(this.mAuthority, "root/*/search", 4);
        this.mMatcher.addURI(this.mAuthority, "document/*", 5);
        this.mMatcher.addURI(this.mAuthority, "document/*/children", 6);
        this.mMatcher.addURI(this.mAuthority, "tree/*/document/*", 7);
        this.mMatcher.addURI(this.mAuthority, "tree/*/document/*/children", 8);
        if (!info.exported) {
            throw new SecurityException("Provider must be exported");
        }
        if (!info.grantUriPermissions) {
            throw new SecurityException("Provider must grantUriPermissions");
        }
        if (!"android.permission.MANAGE_DOCUMENTS".equals(info.readPermission) || !"android.permission.MANAGE_DOCUMENTS".equals(info.writePermission)) {
            throw new SecurityException("Provider must be protected by MANAGE_DOCUMENTS");
        }
        super.attachInfo(context, info);
    }

    public boolean isChildDocument(String parentDocumentId, String documentId) {
        return false;
    }

    private void enforceTree(Uri documentUri) {
        if (DocumentsContract.isTreeUri(documentUri)) {
            String child;
            String parent = DocumentsContract.getTreeDocumentId(documentUri);
            if (Objects.equals(parent, child = DocumentsContract.getDocumentId(documentUri))) {
                return;
            }
            if (!this.isChildDocument(parent, child)) {
                throw new SecurityException("Document " + child + " is not a descendant of " + parent);
            }
        }
    }

    public String createDocument(String parentDocumentId, String mimeType, String displayName) throws FileNotFoundException {
        throw new UnsupportedOperationException("Create not supported");
    }

    public String renameDocument(String documentId, String displayName) throws FileNotFoundException {
        throw new UnsupportedOperationException("Rename not supported");
    }

    public void deleteDocument(String documentId) throws FileNotFoundException {
        throw new UnsupportedOperationException("Delete not supported");
    }

    public abstract Cursor queryRoots(String[] var1) throws FileNotFoundException;

    public Cursor queryRecentDocuments(String rootId, String[] projection) throws FileNotFoundException {
        throw new UnsupportedOperationException("Recent not supported");
    }

    public abstract Cursor queryDocument(String var1, String[] var2) throws FileNotFoundException;

    public abstract Cursor queryChildDocuments(String var1, String[] var2, String var3) throws FileNotFoundException;

    public Cursor queryChildDocumentsForManage(String parentDocumentId, String[] projection, String sortOrder) throws FileNotFoundException {
        throw new UnsupportedOperationException("Manage not supported");
    }

    public Cursor querySearchDocuments(String rootId, String query, String[] projection) throws FileNotFoundException {
        throw new UnsupportedOperationException("Search not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDocumentType(String documentId) throws FileNotFoundException {
        Cursor cursor = this.queryDocument(documentId, null);
        try {
            if (cursor.moveToFirst()) {
                String string2 = cursor.getString(cursor.getColumnIndexOrThrow("mime_type"));
                return string2;
            }
            String string3 = null;
            return string3;
        }
        finally {
            IoUtils.closeQuietly(cursor);
        }
    }

    public abstract ParcelFileDescriptor openDocument(String var1, String var2, CancellationSignal var3) throws FileNotFoundException;

    public AssetFileDescriptor openDocumentThumbnail(String documentId, Point sizeHint, CancellationSignal signal) throws FileNotFoundException {
        throw new UnsupportedOperationException("Thumbnails not supported");
    }

    @Override
    public final Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        try {
            switch (this.mMatcher.match(uri)) {
                case 1: {
                    return this.queryRoots(projection);
                }
                case 3: {
                    return this.queryRecentDocuments(DocumentsContract.getRootId(uri), projection);
                }
                case 4: {
                    return this.querySearchDocuments(DocumentsContract.getRootId(uri), DocumentsContract.getSearchDocumentsQuery(uri), projection);
                }
                case 5: 
                case 7: {
                    this.enforceTree(uri);
                    return this.queryDocument(DocumentsContract.getDocumentId(uri), projection);
                }
                case 6: 
                case 8: {
                    this.enforceTree(uri);
                    if (DocumentsContract.isManageMode(uri)) {
                        return this.queryChildDocumentsForManage(DocumentsContract.getDocumentId(uri), projection, sortOrder);
                    }
                    return this.queryChildDocuments(DocumentsContract.getDocumentId(uri), projection, sortOrder);
                }
            }
            throw new UnsupportedOperationException("Unsupported Uri " + uri);
        }
        catch (FileNotFoundException e) {
            Log.w(TAG, "Failed during query", e);
            return null;
        }
    }

    @Override
    public final String getType(Uri uri) {
        try {
            switch (this.mMatcher.match(uri)) {
                case 2: {
                    return "vnd.android.document/root";
                }
                case 5: 
                case 7: {
                    this.enforceTree(uri);
                    return this.getDocumentType(DocumentsContract.getDocumentId(uri));
                }
            }
            return null;
        }
        catch (FileNotFoundException e) {
            Log.w(TAG, "Failed during getType", e);
            return null;
        }
    }

    @Override
    public Uri canonicalize(Uri uri) {
        Context context = this.getContext();
        switch (this.mMatcher.match(uri)) {
            case 7: {
                this.enforceTree(uri);
                Uri narrowUri = DocumentsContract.buildDocumentUri(uri.getAuthority(), DocumentsContract.getDocumentId(uri));
                int modeFlags = DocumentsProvider.getCallingOrSelfUriPermissionModeFlags(context, uri);
                context.grantUriPermission(this.getCallingPackage(), narrowUri, modeFlags);
                return narrowUri;
            }
        }
        return null;
    }

    private static int getCallingOrSelfUriPermissionModeFlags(Context context, Uri uri) {
        int modeFlags = 0;
        if (context.checkCallingOrSelfUriPermission(uri, 1) == 0) {
            modeFlags |= 1;
        }
        if (context.checkCallingOrSelfUriPermission(uri, 2) == 0) {
            modeFlags |= 2;
        }
        if (context.checkCallingOrSelfUriPermission(uri, 65) == 0) {
            modeFlags |= 0x40;
        }
        return modeFlags;
    }

    @Override
    public final Uri insert(Uri uri, ContentValues values) {
        throw new UnsupportedOperationException("Insert not supported");
    }

    @Override
    public final int delete(Uri uri, String selection, String[] selectionArgs) {
        throw new UnsupportedOperationException("Delete not supported");
    }

    @Override
    public final int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        throw new UnsupportedOperationException("Update not supported");
    }

    @Override
    public Bundle call(String method, String arg, Bundle extras) {
        Bundle out;
        block9: {
            if (!method.startsWith("android:")) {
                return super.call(method, arg, extras);
            }
            Context context = this.getContext();
            Uri documentUri = (Uri)extras.getParcelable("uri");
            String authority = documentUri.getAuthority();
            String documentId = DocumentsContract.getDocumentId(documentUri);
            if (!this.mAuthority.equals(authority)) {
                throw new SecurityException("Requested authority " + authority + " doesn't match provider " + this.mAuthority);
            }
            this.enforceTree(documentUri);
            out = new Bundle();
            try {
                if ("android:createDocument".equals(method)) {
                    this.enforceWritePermissionInner(documentUri);
                    String mimeType = extras.getString("mime_type");
                    String displayName = extras.getString("_display_name");
                    String newDocumentId = this.createDocument(documentId, mimeType, displayName);
                    Uri newDocumentUri = DocumentsContract.buildDocumentUriMaybeUsingTree(documentUri, newDocumentId);
                    out.putParcelable("uri", newDocumentUri);
                    break block9;
                }
                if ("android:renameDocument".equals(method)) {
                    this.enforceWritePermissionInner(documentUri);
                    String displayName = extras.getString("_display_name");
                    String newDocumentId = this.renameDocument(documentId, displayName);
                    if (newDocumentId != null) {
                        Uri newDocumentUri = DocumentsContract.buildDocumentUriMaybeUsingTree(documentUri, newDocumentId);
                        if (!DocumentsContract.isTreeUri(newDocumentUri)) {
                            int modeFlags = DocumentsProvider.getCallingOrSelfUriPermissionModeFlags(context, documentUri);
                            context.grantUriPermission(this.getCallingPackage(), newDocumentUri, modeFlags);
                        }
                        out.putParcelable("uri", newDocumentUri);
                        this.revokeDocumentPermission(documentId);
                    }
                    break block9;
                }
                if ("android:deleteDocument".equals(method)) {
                    this.enforceWritePermissionInner(documentUri);
                    this.deleteDocument(documentId);
                    this.revokeDocumentPermission(documentId);
                    break block9;
                }
                throw new UnsupportedOperationException("Method not supported " + method);
            }
            catch (FileNotFoundException e) {
                throw new IllegalStateException("Failed call " + method, e);
            }
        }
        return out;
    }

    public final void revokeDocumentPermission(String documentId) {
        Context context = this.getContext();
        context.revokeUriPermission(DocumentsContract.buildDocumentUri(this.mAuthority, documentId), -1);
        context.revokeUriPermission(DocumentsContract.buildTreeDocumentUri(this.mAuthority, documentId), -1);
    }

    @Override
    public final ParcelFileDescriptor openFile(Uri uri, String mode) throws FileNotFoundException {
        this.enforceTree(uri);
        return this.openDocument(DocumentsContract.getDocumentId(uri), mode, null);
    }

    @Override
    public final ParcelFileDescriptor openFile(Uri uri, String mode, CancellationSignal signal) throws FileNotFoundException {
        this.enforceTree(uri);
        return this.openDocument(DocumentsContract.getDocumentId(uri), mode, signal);
    }

    @Override
    public final AssetFileDescriptor openAssetFile(Uri uri, String mode) throws FileNotFoundException {
        this.enforceTree(uri);
        ParcelFileDescriptor fd = this.openDocument(DocumentsContract.getDocumentId(uri), mode, null);
        return fd != null ? new AssetFileDescriptor(fd, 0L, -1L) : null;
    }

    @Override
    public final AssetFileDescriptor openAssetFile(Uri uri, String mode, CancellationSignal signal) throws FileNotFoundException {
        this.enforceTree(uri);
        ParcelFileDescriptor fd = this.openDocument(DocumentsContract.getDocumentId(uri), mode, signal);
        return fd != null ? new AssetFileDescriptor(fd, 0L, -1L) : null;
    }

    @Override
    public final AssetFileDescriptor openTypedAssetFile(Uri uri, String mimeTypeFilter, Bundle opts) throws FileNotFoundException {
        this.enforceTree(uri);
        if (opts != null && opts.containsKey("android.content.extra.SIZE")) {
            Point sizeHint = (Point)opts.getParcelable("android.content.extra.SIZE");
            return this.openDocumentThumbnail(DocumentsContract.getDocumentId(uri), sizeHint, null);
        }
        return super.openTypedAssetFile(uri, mimeTypeFilter, opts);
    }

    @Override
    public final AssetFileDescriptor openTypedAssetFile(Uri uri, String mimeTypeFilter, Bundle opts, CancellationSignal signal) throws FileNotFoundException {
        this.enforceTree(uri);
        if (opts != null && opts.containsKey("android.content.extra.SIZE")) {
            Point sizeHint = (Point)opts.getParcelable("android.content.extra.SIZE");
            return this.openDocumentThumbnail(DocumentsContract.getDocumentId(uri), sizeHint, signal);
        }
        return super.openTypedAssetFile(uri, mimeTypeFilter, opts, signal);
    }
}

