/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.renderscript.Allocation;
import android.renderscript.BaseObj;
import android.renderscript.RenderScript;

public class Path
extends BaseObj {
    Allocation mVertexBuffer;
    Allocation mLoopBuffer;
    Primitive mPrimitive;
    float mQuality;
    boolean mCoverageToAlpha;

    Path(long id2, RenderScript rs, Primitive p, Allocation vtx, Allocation loop, float q) {
        super(id2, rs);
        this.mVertexBuffer = vtx;
        this.mLoopBuffer = loop;
        this.mPrimitive = p;
        this.mQuality = q;
    }

    public Allocation getVertexAllocation() {
        return this.mVertexBuffer;
    }

    public Allocation getLoopAllocation() {
        return this.mLoopBuffer;
    }

    public Primitive getPrimitive() {
        return this.mPrimitive;
    }

    @Override
    void updateFromNative() {
    }

    public static Path createStaticPath(RenderScript rs, Primitive p, float quality, Allocation vtx) {
        long id2 = rs.nPathCreate(p.mID, false, vtx.getID(rs), 0L, quality);
        Path newPath = new Path(id2, rs, p, null, null, quality);
        return newPath;
    }

    public static Path createStaticPath(RenderScript rs, Primitive p, float quality, Allocation vtx, Allocation loops) {
        return null;
    }

    public static Path createDynamicPath(RenderScript rs, Primitive p, float quality, Allocation vtx) {
        return null;
    }

    public static Path createDynamicPath(RenderScript rs, Primitive p, float quality, Allocation vtx, Allocation loops) {
        return null;
    }

    public static enum Primitive {
        QUADRATIC_BEZIER(0),
        CUBIC_BEZIER(1);

        int mID;

        private Primitive(int id2) {
            this.mID = id2;
        }
    }
}

