/*
 * Decompiled with CFR 0.152.
 */
package android.security;

import android.content.Context;
import java.security.KeyStore;

public final class KeyStoreParameter
implements KeyStore.ProtectionParameter {
    private int mFlags;

    private KeyStoreParameter(int flags) {
        this.mFlags = flags;
    }

    public int getFlags() {
        return this.mFlags;
    }

    public boolean isEncryptionRequired() {
        return (this.mFlags & 1) != 0;
    }

    public static final class Builder {
        private int mFlags;

        public Builder(Context context) {
            if (context == null) {
                throw new NullPointerException("context == null");
            }
        }

        public Builder setEncryptionRequired(boolean required) {
            this.mFlags = required ? (this.mFlags |= 1) : (this.mFlags &= 0xFFFFFFFE);
            return this;
        }

        public KeyStoreParameter build() {
            return new KeyStoreParameter(this.mFlags);
        }
    }
}

