/*
 * Decompiled with CFR 0.152.
 */
package android.service.voice;

import android.app.Service;
import android.content.Intent;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.service.voice.IVoiceInteractionSessionService;
import android.service.voice.VoiceInteractionSession;
import com.android.internal.app.IVoiceInteractionManagerService;
import com.android.internal.os.HandlerCaller;
import com.android.internal.os.SomeArgs;

public abstract class VoiceInteractionSessionService
extends Service {
    static final int MSG_NEW_SESSION = 1;
    IVoiceInteractionManagerService mSystemService;
    VoiceInteractionSession mSession;
    IVoiceInteractionSessionService mInterface = new IVoiceInteractionSessionService.Stub(){

        @Override
        public void newSession(IBinder token, Bundle args) {
            VoiceInteractionSessionService.this.mHandlerCaller.sendMessage(VoiceInteractionSessionService.this.mHandlerCaller.obtainMessageOO(1, token, args));
        }
    };
    HandlerCaller mHandlerCaller;
    final HandlerCaller.Callback mHandlerCallerCallback = new HandlerCaller.Callback(){

        @Override
        public void executeMessage(Message msg) {
            SomeArgs args = (SomeArgs)msg.obj;
            switch (msg.what) {
                case 1: {
                    VoiceInteractionSessionService.this.doNewSession((IBinder)args.arg1, (Bundle)args.arg2);
                }
            }
        }
    };

    @Override
    public void onCreate() {
        super.onCreate();
        this.mSystemService = IVoiceInteractionManagerService.Stub.asInterface(ServiceManager.getService("voiceinteraction"));
        this.mHandlerCaller = new HandlerCaller(this, Looper.myLooper(), this.mHandlerCallerCallback, true);
    }

    public abstract VoiceInteractionSession onNewSession(Bundle var1);

    @Override
    public IBinder onBind(Intent intent) {
        return this.mInterface.asBinder();
    }

    void doNewSession(IBinder token, Bundle args) {
        if (this.mSession != null) {
            this.mSession.doDestroy();
            this.mSession = null;
        }
        this.mSession = this.onNewSession(args);
        try {
            this.mSystemService.deliverNewSession(token, this.mSession.mSession, this.mSession.mInteractor);
            this.mSession.doCreate(this.mSystemService, token, args);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }
}

