/*
 * Decompiled with CFR 0.152.
 */
package android.speech.tts;

import android.os.ConditionVariable;
import android.speech.tts.PlaybackQueueItem;
import android.speech.tts.TextToSpeechService;

class SilencePlaybackQueueItem
extends PlaybackQueueItem {
    private final ConditionVariable mCondVar = new ConditionVariable();
    private final long mSilenceDurationMs;

    SilencePlaybackQueueItem(TextToSpeechService.UtteranceProgressDispatcher dispatcher, Object callerIdentity, long silenceDurationMs) {
        super(dispatcher, callerIdentity);
        this.mSilenceDurationMs = silenceDurationMs;
    }

    @Override
    public void run() {
        this.getDispatcher().dispatchOnStart();
        boolean wasStopped = false;
        if (this.mSilenceDurationMs > 0L) {
            wasStopped = this.mCondVar.block(this.mSilenceDurationMs);
        }
        if (wasStopped) {
            this.getDispatcher().dispatchOnStop();
        } else {
            this.getDispatcher().dispatchOnSuccess();
        }
    }

    @Override
    void stop(int errorCode) {
        this.mCondVar.open();
    }
}

