/*
 * Decompiled with CFR 0.152.
 */
package android.system;

import android.system.OsConstants;
import java.io.IOException;
import java.net.SocketException;
import libcore.io.Libcore;

public final class ErrnoException
extends Exception {
    private final String functionName;
    public final int errno;

    public ErrnoException(String functionName, int errno) {
        this.functionName = functionName;
        this.errno = errno;
    }

    public ErrnoException(String functionName, int errno, Throwable cause) {
        super(cause);
        this.functionName = functionName;
        this.errno = errno;
    }

    @Override
    public String getMessage() {
        String errnoName = OsConstants.errnoName(this.errno);
        if (errnoName == null) {
            errnoName = "errno " + this.errno;
        }
        String description = Libcore.os.strerror(this.errno);
        return this.functionName + " failed: " + errnoName + " (" + description + ")";
    }

    public IOException rethrowAsIOException() throws IOException {
        IOException newException = new IOException(this.getMessage());
        newException.initCause(this);
        throw newException;
    }

    public SocketException rethrowAsSocketException() throws SocketException {
        throw new SocketException(this.getMessage(), this);
    }
}

