/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.net.Uri;
import android.os.Bundle;
import android.telecom.DisconnectCause;
import android.telecom.GatewayInfo;
import android.telecom.InCallAdapter;
import android.telecom.InCallService;
import android.telecom.Log;
import android.telecom.ParcelableCall;
import android.telecom.Phone;
import android.telecom.PhoneAccountHandle;
import android.telecom.StatusHints;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;

public final class Call {
    public static final int STATE_NEW = 0;
    public static final int STATE_DIALING = 1;
    public static final int STATE_RINGING = 2;
    public static final int STATE_HOLDING = 3;
    public static final int STATE_ACTIVE = 4;
    public static final int STATE_DISCONNECTED = 7;
    public static final int STATE_PRE_DIAL_WAIT = 8;
    public static final int STATE_CONNECTING = 9;
    public static final int STATE_DISCONNECTING = 10;
    public static final String AVAILABLE_PHONE_ACCOUNTS = "selectPhoneAccountAccounts";
    private final Phone mPhone;
    private final String mTelecomCallId;
    private final InCallAdapter mInCallAdapter;
    private final List<String> mChildrenIds = new ArrayList<String>();
    private final List<Call> mChildren = new ArrayList<Call>();
    private final List<Call> mUnmodifiableChildren = Collections.unmodifiableList(this.mChildren);
    private final List<Listener> mListeners = new CopyOnWriteArrayList<Listener>();
    private final List<Call> mConferenceableCalls = new ArrayList<Call>();
    private final List<Call> mUnmodifiableConferenceableCalls = Collections.unmodifiableList(this.mConferenceableCalls);
    private boolean mChildrenCached;
    private String mParentId = null;
    private int mState;
    private List<String> mCannedTextResponses = null;
    private String mRemainingPostDialSequence;
    private InCallService.VideoCall mVideoCall;
    private Details mDetails;

    public String getRemainingPostDialSequence() {
        return this.mRemainingPostDialSequence;
    }

    public void answer(int videoState) {
        this.mInCallAdapter.answerCall(this.mTelecomCallId, videoState);
    }

    public void reject(boolean rejectWithMessage, String textMessage) {
        this.mInCallAdapter.rejectCall(this.mTelecomCallId, rejectWithMessage, textMessage);
    }

    public void disconnect() {
        this.mInCallAdapter.disconnectCall(this.mTelecomCallId);
    }

    public void hold() {
        this.mInCallAdapter.holdCall(this.mTelecomCallId);
    }

    public void unhold() {
        this.mInCallAdapter.unholdCall(this.mTelecomCallId);
    }

    public void playDtmfTone(char digit) {
        this.mInCallAdapter.playDtmfTone(this.mTelecomCallId, digit);
    }

    public void stopDtmfTone() {
        this.mInCallAdapter.stopDtmfTone(this.mTelecomCallId);
    }

    public void postDialContinue(boolean proceed) {
        this.mInCallAdapter.postDialContinue(this.mTelecomCallId, proceed);
    }

    public void phoneAccountSelected(PhoneAccountHandle accountHandle) {
        this.mInCallAdapter.phoneAccountSelected(this.mTelecomCallId, accountHandle);
    }

    public void conference(Call callToConferenceWith) {
        if (callToConferenceWith != null) {
            this.mInCallAdapter.conference(this.mTelecomCallId, callToConferenceWith.mTelecomCallId);
        }
    }

    public void splitFromConference() {
        this.mInCallAdapter.splitFromConference(this.mTelecomCallId);
    }

    public void mergeConference() {
        this.mInCallAdapter.mergeConference(this.mTelecomCallId);
    }

    public void swapConference() {
        this.mInCallAdapter.swapConference(this.mTelecomCallId);
    }

    public Call getParent() {
        if (this.mParentId != null) {
            return this.mPhone.internalGetCallByTelecomId(this.mParentId);
        }
        return null;
    }

    public List<Call> getChildren() {
        if (!this.mChildrenCached) {
            this.mChildrenCached = true;
            this.mChildren.clear();
            for (String id2 : this.mChildrenIds) {
                Call call = this.mPhone.internalGetCallByTelecomId(id2);
                if (call == null) {
                    this.mChildrenCached = false;
                    continue;
                }
                this.mChildren.add(call);
            }
        }
        return this.mUnmodifiableChildren;
    }

    public List<Call> getConferenceableCalls() {
        return this.mUnmodifiableConferenceableCalls;
    }

    public int getState() {
        return this.mState;
    }

    public List<String> getCannedTextResponses() {
        return this.mCannedTextResponses;
    }

    public InCallService.VideoCall getVideoCall() {
        return this.mVideoCall;
    }

    public Details getDetails() {
        return this.mDetails;
    }

    public void addListener(Listener listener) {
        this.mListeners.add(listener);
    }

    public void removeListener(Listener listener) {
        if (listener != null) {
            this.mListeners.remove(listener);
        }
    }

    Call(Phone phone, String telecomCallId, InCallAdapter inCallAdapter) {
        this.mPhone = phone;
        this.mTelecomCallId = telecomCallId;
        this.mInCallAdapter = inCallAdapter;
        this.mState = 0;
    }

    final String internalGetCallId() {
        return this.mTelecomCallId;
    }

    final void internalUpdate(ParcelableCall parcelableCall, Map<String, Call> callIdMap) {
        List<String> childCallIds;
        boolean childrenChanged;
        String parentId;
        boolean parentChanged;
        int state;
        boolean stateChanged;
        boolean videoCallChanged;
        boolean detailsChanged;
        Details details = new Details(parcelableCall.getHandle(), parcelableCall.getHandlePresentation(), parcelableCall.getCallerDisplayName(), parcelableCall.getCallerDisplayNamePresentation(), parcelableCall.getAccountHandle(), parcelableCall.getCapabilities(), parcelableCall.getProperties(), parcelableCall.getDisconnectCause(), parcelableCall.getConnectTimeMillis(), parcelableCall.getGatewayInfo(), parcelableCall.getVideoState(), parcelableCall.getStatusHints(), parcelableCall.getExtras());
        boolean bl = detailsChanged = !Objects.equals(this.mDetails, details);
        if (detailsChanged) {
            this.mDetails = details;
        }
        boolean cannedTextResponsesChanged = false;
        if (this.mCannedTextResponses == null && parcelableCall.getCannedSmsResponses() != null && !parcelableCall.getCannedSmsResponses().isEmpty()) {
            this.mCannedTextResponses = Collections.unmodifiableList(parcelableCall.getCannedSmsResponses());
        }
        boolean bl2 = videoCallChanged = !Objects.equals(this.mVideoCall, parcelableCall.getVideoCall());
        if (videoCallChanged) {
            this.mVideoCall = parcelableCall.getVideoCall();
        }
        boolean bl3 = stateChanged = this.mState != (state = this.stateFromParcelableCallState(parcelableCall.getState()));
        if (stateChanged) {
            this.mState = state;
        }
        boolean bl4 = parentChanged = !Objects.equals(this.mParentId, parentId = parcelableCall.getParentCallId());
        if (parentChanged) {
            this.mParentId = parentId;
        }
        boolean bl5 = childrenChanged = !Objects.equals(childCallIds = parcelableCall.getChildCallIds(), this.mChildrenIds);
        if (childrenChanged) {
            this.mChildrenIds.clear();
            this.mChildrenIds.addAll(parcelableCall.getChildCallIds());
            this.mChildrenCached = false;
        }
        List<String> conferenceableCallIds = parcelableCall.getConferenceableCallIds();
        ArrayList<Call> conferenceableCalls = new ArrayList<Call>(conferenceableCallIds.size());
        for (String otherId : conferenceableCallIds) {
            if (!callIdMap.containsKey(otherId)) continue;
            conferenceableCalls.add(callIdMap.get(otherId));
        }
        if (!Objects.equals(this.mConferenceableCalls, conferenceableCalls)) {
            this.mConferenceableCalls.clear();
            this.mConferenceableCalls.addAll(conferenceableCalls);
            this.fireConferenceableCallsChanged();
        }
        if (stateChanged) {
            this.fireStateChanged(this.mState);
        }
        if (detailsChanged) {
            this.fireDetailsChanged(this.mDetails);
        }
        if (cannedTextResponsesChanged) {
            this.fireCannedTextResponsesLoaded(this.mCannedTextResponses);
        }
        if (videoCallChanged) {
            this.fireVideoCallChanged(this.mVideoCall);
        }
        if (parentChanged) {
            this.fireParentChanged(this.getParent());
        }
        if (childrenChanged) {
            this.fireChildrenChanged(this.getChildren());
        }
        if (this.mState == 7) {
            this.fireCallDestroyed();
            this.mPhone.internalRemoveCall(this);
        }
    }

    final void internalSetPostDialWait(String remaining) {
        this.mRemainingPostDialSequence = remaining;
        this.firePostDialWait(this.mRemainingPostDialSequence);
    }

    final void internalSetDisconnected() {
        if (this.mState != 7) {
            this.mState = 7;
            this.fireStateChanged(this.mState);
            this.fireCallDestroyed();
            this.mPhone.internalRemoveCall(this);
        }
    }

    private void fireStateChanged(int newState) {
        for (Listener listener : this.mListeners) {
            listener.onStateChanged(this, newState);
        }
    }

    private void fireParentChanged(Call newParent) {
        for (Listener listener : this.mListeners) {
            listener.onParentChanged(this, newParent);
        }
    }

    private void fireChildrenChanged(List<Call> children) {
        for (Listener listener : this.mListeners) {
            listener.onChildrenChanged(this, children);
        }
    }

    private void fireDetailsChanged(Details details) {
        for (Listener listener : this.mListeners) {
            listener.onDetailsChanged(this, details);
        }
    }

    private void fireCannedTextResponsesLoaded(List<String> cannedTextResponses) {
        for (Listener listener : this.mListeners) {
            listener.onCannedTextResponsesLoaded(this, cannedTextResponses);
        }
    }

    private void fireVideoCallChanged(InCallService.VideoCall videoCall) {
        for (Listener listener : this.mListeners) {
            listener.onVideoCallChanged(this, videoCall);
        }
    }

    private void firePostDialWait(String remainingPostDialSequence) {
        for (Listener listener : this.mListeners) {
            listener.onPostDialWait(this, remainingPostDialSequence);
        }
    }

    private void fireCallDestroyed() {
        for (Listener listener : this.mListeners) {
            listener.onCallDestroyed(this);
        }
    }

    private void fireConferenceableCallsChanged() {
        for (Listener listener : this.mListeners) {
            listener.onConferenceableCallsChanged(this, this.mUnmodifiableConferenceableCalls);
        }
    }

    private int stateFromParcelableCallState(int parcelableCallState) {
        switch (parcelableCallState) {
            case 0: {
                return 0;
            }
            case 1: {
                return 9;
            }
            case 2: {
                return 8;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 5: {
                return 4;
            }
            case 6: {
                return 3;
            }
            case 7: {
                return 7;
            }
            case 8: {
                return 7;
            }
            case 9: {
                return 10;
            }
        }
        Log.wtf((Object)this, "Unrecognized CallState %s", parcelableCallState);
        return 0;
    }

    public static abstract class Listener {
        public void onStateChanged(Call call, int state) {
        }

        public void onParentChanged(Call call, Call parent) {
        }

        public void onChildrenChanged(Call call, List<Call> children) {
        }

        public void onDetailsChanged(Call call, Details details) {
        }

        public void onCannedTextResponsesLoaded(Call call, List<String> cannedTextResponses) {
        }

        public void onPostDialWait(Call call, String remainingPostDialSequence) {
        }

        public void onVideoCallChanged(Call call, InCallService.VideoCall videoCall) {
        }

        public void onCallDestroyed(Call call) {
        }

        public void onConferenceableCallsChanged(Call call, List<Call> conferenceableCalls) {
        }
    }

    public static class Details {
        private final Uri mHandle;
        private final int mHandlePresentation;
        private final String mCallerDisplayName;
        private final int mCallerDisplayNamePresentation;
        private final PhoneAccountHandle mAccountHandle;
        private final int mCallCapabilities;
        private final int mCallProperties;
        private final DisconnectCause mDisconnectCause;
        private final long mConnectTimeMillis;
        private final GatewayInfo mGatewayInfo;
        private final int mVideoState;
        private final StatusHints mStatusHints;
        private final Bundle mExtras;

        public Uri getHandle() {
            return this.mHandle;
        }

        public int getHandlePresentation() {
            return this.mHandlePresentation;
        }

        public String getCallerDisplayName() {
            return this.mCallerDisplayName;
        }

        public int getCallerDisplayNamePresentation() {
            return this.mCallerDisplayNamePresentation;
        }

        public PhoneAccountHandle getAccountHandle() {
            return this.mAccountHandle;
        }

        public int getCallCapabilities() {
            return this.mCallCapabilities;
        }

        public int getCallProperties() {
            return this.mCallProperties;
        }

        public DisconnectCause getDisconnectCause() {
            return this.mDisconnectCause;
        }

        public long getConnectTimeMillis() {
            return this.mConnectTimeMillis;
        }

        public GatewayInfo getGatewayInfo() {
            return this.mGatewayInfo;
        }

        public int getVideoState() {
            return this.mVideoState;
        }

        public StatusHints getStatusHints() {
            return this.mStatusHints;
        }

        public Bundle getExtras() {
            return this.mExtras;
        }

        public boolean equals(Object o) {
            if (o instanceof Details) {
                Details d = (Details)o;
                return Objects.equals(this.mHandle, d.mHandle) && Objects.equals(this.mHandlePresentation, d.mHandlePresentation) && Objects.equals(this.mCallerDisplayName, d.mCallerDisplayName) && Objects.equals(this.mCallerDisplayNamePresentation, d.mCallerDisplayNamePresentation) && Objects.equals(this.mAccountHandle, d.mAccountHandle) && Objects.equals(this.mCallCapabilities, d.mCallCapabilities) && Objects.equals(this.mCallProperties, d.mCallProperties) && Objects.equals(this.mDisconnectCause, d.mDisconnectCause) && Objects.equals(this.mConnectTimeMillis, d.mConnectTimeMillis) && Objects.equals(this.mGatewayInfo, d.mGatewayInfo) && Objects.equals(this.mVideoState, d.mVideoState) && Objects.equals(this.mStatusHints, d.mStatusHints) && Objects.equals(this.mExtras, d.mExtras);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode(this.mHandle) + Objects.hashCode(this.mHandlePresentation) + Objects.hashCode(this.mCallerDisplayName) + Objects.hashCode(this.mCallerDisplayNamePresentation) + Objects.hashCode(this.mAccountHandle) + Objects.hashCode(this.mCallCapabilities) + Objects.hashCode(this.mCallProperties) + Objects.hashCode(this.mDisconnectCause) + Objects.hashCode(this.mConnectTimeMillis) + Objects.hashCode(this.mGatewayInfo) + Objects.hashCode(this.mVideoState) + Objects.hashCode(this.mStatusHints) + Objects.hashCode(this.mExtras);
        }

        public Details(Uri handle, int handlePresentation, String callerDisplayName, int callerDisplayNamePresentation, PhoneAccountHandle accountHandle, int capabilities, int properties, DisconnectCause disconnectCause, long connectTimeMillis, GatewayInfo gatewayInfo, int videoState, StatusHints statusHints, Bundle extras) {
            this.mHandle = handle;
            this.mHandlePresentation = handlePresentation;
            this.mCallerDisplayName = callerDisplayName;
            this.mCallerDisplayNamePresentation = callerDisplayNamePresentation;
            this.mAccountHandle = accountHandle;
            this.mCallCapabilities = capabilities;
            this.mCallProperties = properties;
            this.mDisconnectCause = disconnectCause;
            this.mConnectTimeMillis = connectTimeMillis;
            this.mGatewayInfo = gatewayInfo;
            this.mVideoState = videoState;
            this.mStatusHints = statusHints;
            this.mExtras = extras;
        }
    }
}

