/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.telecom.CameraCapabilities;
import android.telecom.InCallService;
import android.telecom.VideoProfile;
import android.view.Surface;
import com.android.internal.os.SomeArgs;
import com.android.internal.telecom.IVideoCallback;
import com.android.internal.telecom.IVideoProvider;

public class VideoCallImpl
extends InCallService.VideoCall {
    private static final int MSG_RECEIVE_SESSION_MODIFY_REQUEST = 1;
    private static final int MSG_RECEIVE_SESSION_MODIFY_RESPONSE = 2;
    private static final int MSG_HANDLE_CALL_SESSION_EVENT = 3;
    private static final int MSG_CHANGE_PEER_DIMENSIONS = 4;
    private static final int MSG_CHANGE_CALL_DATA_USAGE = 5;
    private static final int MSG_CHANGE_CAMERA_CAPABILITIES = 6;
    private final IVideoProvider mVideoProvider;
    private final VideoCallListenerBinder mBinder;
    private InCallService.VideoCall.Listener mVideoCallListener;
    private IBinder.DeathRecipient mDeathRecipient = new IBinder.DeathRecipient(){

        @Override
        public void binderDied() {
            VideoCallImpl.this.mVideoProvider.asBinder().unlinkToDeath(this, 0);
        }
    };
    private final Handler mHandler = new Handler(Looper.getMainLooper()){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            if (VideoCallImpl.this.mVideoCallListener == null) {
                return;
            }
            switch (msg.what) {
                case 1: {
                    VideoCallImpl.this.mVideoCallListener.onSessionModifyRequestReceived((VideoProfile)msg.obj);
                    break;
                }
                case 2: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    try {
                        int status = (Integer)args.arg1;
                        VideoProfile requestProfile = (VideoProfile)args.arg2;
                        VideoProfile responseProfile = (VideoProfile)args.arg3;
                        VideoCallImpl.this.mVideoCallListener.onSessionModifyResponseReceived(status, requestProfile, responseProfile);
                        break;
                    }
                    finally {
                        args.recycle();
                    }
                }
                case 3: {
                    VideoCallImpl.this.mVideoCallListener.onCallSessionEvent((Integer)msg.obj);
                    break;
                }
                case 4: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    try {
                        int width = (Integer)args.arg1;
                        int height = (Integer)args.arg2;
                        VideoCallImpl.this.mVideoCallListener.onPeerDimensionsChanged(width, height);
                        break;
                    }
                    finally {
                        args.recycle();
                    }
                }
                case 5: {
                    VideoCallImpl.this.mVideoCallListener.onCallDataUsageChanged(msg.arg1);
                    break;
                }
                case 6: {
                    VideoCallImpl.this.mVideoCallListener.onCameraCapabilitiesChanged((CameraCapabilities)msg.obj);
                    break;
                }
            }
        }
    };

    VideoCallImpl(IVideoProvider videoProvider) throws RemoteException {
        this.mVideoProvider = videoProvider;
        this.mVideoProvider.asBinder().linkToDeath(this.mDeathRecipient, 0);
        this.mBinder = new VideoCallListenerBinder();
        this.mVideoProvider.setVideoCallback(this.mBinder);
    }

    @Override
    public void setVideoCallListener(InCallService.VideoCall.Listener videoCallListener) {
        this.mVideoCallListener = videoCallListener;
    }

    @Override
    public void setCamera(String cameraId) {
        try {
            this.mVideoProvider.setCamera(cameraId);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void setPreviewSurface(Surface surface) {
        try {
            this.mVideoProvider.setPreviewSurface(surface);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void setDisplaySurface(Surface surface) {
        try {
            this.mVideoProvider.setDisplaySurface(surface);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void setDeviceOrientation(int rotation) {
        try {
            this.mVideoProvider.setDeviceOrientation(rotation);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void setZoom(float value) {
        try {
            this.mVideoProvider.setZoom(value);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void sendSessionModifyRequest(VideoProfile requestProfile) {
        try {
            this.mVideoProvider.sendSessionModifyRequest(requestProfile);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void sendSessionModifyResponse(VideoProfile responseProfile) {
        try {
            this.mVideoProvider.sendSessionModifyResponse(responseProfile);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void requestCameraCapabilities() {
        try {
            this.mVideoProvider.requestCameraCapabilities();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void requestCallDataUsage() {
        try {
            this.mVideoProvider.requestCallDataUsage();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void setPauseImage(String uri) {
        try {
            this.mVideoProvider.setPauseImage(uri);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final class VideoCallListenerBinder
    extends IVideoCallback.Stub {
        private VideoCallListenerBinder() {
        }

        @Override
        public void receiveSessionModifyRequest(VideoProfile videoProfile) {
            VideoCallImpl.this.mHandler.obtainMessage(1, videoProfile).sendToTarget();
        }

        @Override
        public void receiveSessionModifyResponse(int status, VideoProfile requestProfile, VideoProfile responseProfile) {
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = status;
            args.arg2 = requestProfile;
            args.arg3 = responseProfile;
            VideoCallImpl.this.mHandler.obtainMessage(2, args).sendToTarget();
        }

        @Override
        public void handleCallSessionEvent(int event) {
            VideoCallImpl.this.mHandler.obtainMessage(3, event).sendToTarget();
        }

        @Override
        public void changePeerDimensions(int width, int height) {
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = width;
            args.arg2 = height;
            VideoCallImpl.this.mHandler.obtainMessage(4, args).sendToTarget();
        }

        @Override
        public void changeCallDataUsage(int dataUsage) {
            VideoCallImpl.this.mHandler.obtainMessage(5, dataUsage).sendToTarget();
        }

        @Override
        public void changeCameraCapabilities(CameraCapabilities cameraCapabilities) {
            VideoCallImpl.this.mHandler.obtainMessage(6, cameraCapabilities).sendToTarget();
        }
    }
}

