/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.app.ActivityThread;
import android.app.PendingIntent;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.telephony.SmsMessage;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.ArrayMap;
import com.android.internal.telephony.IMms;
import com.android.internal.telephony.ISms;
import com.android.internal.telephony.SmsRawData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public final class SmsManager {
    private static final int DEFAULT_SUB_ID = -1002;
    private static final SmsManager sInstance = new SmsManager(-1002L);
    private static final Object sLockObject = new Object();
    private static final Map<Long, SmsManager> sSubInstances = new ArrayMap<Long, SmsManager>();
    private long mSubId;
    public static final String MMS_CONFIG_APPEND_TRANSACTION_ID = "enabledTransID";
    public static final String MMS_CONFIG_MMS_ENABLED = "enabledMMS";
    public static final String MMS_CONFIG_GROUP_MMS_ENABLED = "enableGroupMms";
    public static final String MMS_CONFIG_NOTIFY_WAP_MMSC_ENABLED = "enabledNotifyWapMMSC";
    public static final String MMS_CONFIG_ALIAS_ENABLED = "aliasEnabled";
    public static final String MMS_CONFIG_ALLOW_ATTACH_AUDIO = "allowAttachAudio";
    public static final String MMS_CONFIG_MULTIPART_SMS_ENABLED = "enableMultipartSMS";
    public static final String MMS_CONFIG_SMS_DELIVERY_REPORT_ENABLED = "enableSMSDeliveryReports";
    public static final String MMS_CONFIG_SUPPORT_MMS_CONTENT_DISPOSITION = "supportMmsContentDisposition";
    public static final String MMS_CONFIG_SEND_MULTIPART_SMS_AS_SEPARATE_MESSAGES = "sendMultipartSmsAsSeparateMessages";
    public static final String MMS_CONFIG_MMS_READ_REPORT_ENABLED = "enableMMSReadReports";
    public static final String MMS_CONFIG_MMS_DELIVERY_REPORT_ENABLED = "enableMMSDeliveryReports";
    public static final String MMS_CONFIG_MAX_MESSAGE_SIZE = "maxMessageSize";
    public static final String MMS_CONFIG_MAX_IMAGE_WIDTH = "maxImageWidth";
    public static final String MMS_CONFIG_MAX_IMAGE_HEIGHT = "maxImageHeight";
    public static final String MMS_CONFIG_RECIPIENT_LIMIT = "recipientLimit";
    public static final String MMS_CONFIG_ALIAS_MIN_CHARS = "aliasMinChars";
    public static final String MMS_CONFIG_ALIAS_MAX_CHARS = "aliasMaxChars";
    public static final String MMS_CONFIG_SMS_TO_MMS_TEXT_THRESHOLD = "smsToMmsTextThreshold";
    public static final String MMS_CONFIG_SMS_TO_MMS_TEXT_LENGTH_THRESHOLD = "smsToMmsTextLengthThreshold";
    public static final String MMS_CONFIG_MESSAGE_TEXT_MAX_SIZE = "maxMessageTextSize";
    public static final String MMS_CONFIG_SUBJECT_MAX_LENGTH = "maxSubjectLength";
    public static final String MMS_CONFIG_HTTP_SOCKET_TIMEOUT = "httpSocketTimeout";
    public static final String MMS_CONFIG_UA_PROF_TAG_NAME = "uaProfTagName";
    public static final String MMS_CONFIG_USER_AGENT = "userAgent";
    public static final String MMS_CONFIG_UA_PROF_URL = "uaProfUrl";
    public static final String MMS_CONFIG_HTTP_PARAMS = "httpParams";
    public static final String MMS_CONFIG_EMAIL_GATEWAY_NUMBER = "emailGatewayNumber";
    public static final String MMS_CONFIG_NAI_SUFFIX = "naiSuffix";
    public static final int STATUS_ON_ICC_FREE = 0;
    public static final int STATUS_ON_ICC_READ = 1;
    public static final int STATUS_ON_ICC_UNREAD = 3;
    public static final int STATUS_ON_ICC_SENT = 5;
    public static final int STATUS_ON_ICC_UNSENT = 7;
    public static final int RESULT_ERROR_GENERIC_FAILURE = 1;
    public static final int RESULT_ERROR_RADIO_OFF = 2;
    public static final int RESULT_ERROR_NULL_PDU = 3;
    public static final int RESULT_ERROR_NO_SERVICE = 4;
    public static final int RESULT_ERROR_LIMIT_EXCEEDED = 5;
    public static final int RESULT_ERROR_FDN_CHECK_FAILURE = 6;
    private static final String PHONE_PACKAGE_NAME = "com.android.phone";
    public static final int MMS_ERROR_UNSPECIFIED = 1;
    public static final int MMS_ERROR_INVALID_APN = 2;
    public static final int MMS_ERROR_UNABLE_CONNECT_MMS = 3;
    public static final int MMS_ERROR_HTTP_FAILURE = 4;
    public static final int MMS_ERROR_IO_ERROR = 5;
    public static final int MMS_ERROR_RETRY = 6;
    public static final int MMS_ERROR_CONFIGURATION_ERROR = 7;
    public static final String EXTRA_MMS_DATA = "android.telephony.extra.MMS_DATA";
    public static final int SMS_TYPE_INCOMING = 0;
    public static final int SMS_TYPE_OUTGOING = 1;
    public static final String MESSAGE_STATUS_SEEN = "seen";
    public static final String MESSAGE_STATUS_READ = "read";

    public void sendTextMessage(String destinationAddress, String scAddress, String text, PendingIntent sentIntent, PendingIntent deliveryIntent) {
        if (TextUtils.isEmpty(destinationAddress)) {
            throw new IllegalArgumentException("Invalid destinationAddress");
        }
        if (TextUtils.isEmpty(text)) {
            throw new IllegalArgumentException("Invalid message body");
        }
        try {
            ISms iccISms = SmsManager.getISmsServiceOrThrow();
            iccISms.sendText(ActivityThread.currentPackageName(), destinationAddress, scAddress, text, sentIntent, deliveryIntent);
        }
        catch (RemoteException ex) {
            // empty catch block
        }
    }

    public void injectSmsPdu(byte[] pdu, String format, PendingIntent receivedIntent) {
        if (!format.equals("3gpp") && !format.equals("3gpp2")) {
            throw new IllegalArgumentException("Invalid pdu format. format must be either 3gpp or 3gpp2");
        }
        try {
            ISms iccISms = ISms.Stub.asInterface(ServiceManager.getService("isms"));
            if (iccISms != null) {
                iccISms.injectSmsPdu(pdu, format, receivedIntent);
            }
        }
        catch (RemoteException ex) {
            // empty catch block
        }
    }

    public void updateSmsSendStatus(int messageRef, boolean success) {
        try {
            ISms iccISms = ISms.Stub.asInterface(ServiceManager.getService("isms"));
            if (iccISms != null) {
                iccISms.updateSmsSendStatus(messageRef, success);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public ArrayList<String> divideMessage(String text) {
        if (null == text) {
            throw new IllegalArgumentException("text is null");
        }
        return SmsMessage.fragmentText(text);
    }

    public void sendMultipartTextMessage(String destinationAddress, String scAddress, ArrayList<String> parts, ArrayList<PendingIntent> sentIntents, ArrayList<PendingIntent> deliveryIntents) {
        if (TextUtils.isEmpty(destinationAddress)) {
            throw new IllegalArgumentException("Invalid destinationAddress");
        }
        if (parts == null || parts.size() < 1) {
            throw new IllegalArgumentException("Invalid message body");
        }
        if (parts.size() > 1) {
            try {
                ISms iccISms = SmsManager.getISmsServiceOrThrow();
                iccISms.sendMultipartText(ActivityThread.currentPackageName(), destinationAddress, scAddress, parts, sentIntents, deliveryIntents);
            }
            catch (RemoteException ex) {}
        } else {
            PendingIntent sentIntent = null;
            PendingIntent deliveryIntent = null;
            if (sentIntents != null && sentIntents.size() > 0) {
                sentIntent = sentIntents.get(0);
            }
            if (deliveryIntents != null && deliveryIntents.size() > 0) {
                deliveryIntent = deliveryIntents.get(0);
            }
            this.sendTextMessage(destinationAddress, scAddress, parts.get(0), sentIntent, deliveryIntent);
        }
    }

    public void sendDataMessage(String destinationAddress, String scAddress, short destinationPort, byte[] data, PendingIntent sentIntent, PendingIntent deliveryIntent) {
        if (TextUtils.isEmpty(destinationAddress)) {
            throw new IllegalArgumentException("Invalid destinationAddress");
        }
        if (data == null || data.length == 0) {
            throw new IllegalArgumentException("Invalid message data");
        }
        try {
            ISms iccISms = SmsManager.getISmsServiceOrThrow();
            iccISms.sendData(ActivityThread.currentPackageName(), destinationAddress, scAddress, destinationPort & 0xFFFF, data, sentIntent, deliveryIntent);
        }
        catch (RemoteException ex) {
            // empty catch block
        }
    }

    public static SmsManager getDefault() {
        return sInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SmsManager getSmsManagerForSubscriber(long subId) {
        Object object = sLockObject;
        synchronized (object) {
            SmsManager smsManager = sSubInstances.get(subId);
            if (smsManager == null) {
                smsManager = new SmsManager(subId);
                sSubInstances.put(subId, smsManager);
            }
            return smsManager;
        }
    }

    private SmsManager(long subId) {
        this.mSubId = subId;
    }

    public long getSubId() {
        if (this.mSubId == -1002L) {
            return SmsManager.getDefaultSmsSubId();
        }
        return this.mSubId;
    }

    private static ISms getISmsServiceOrThrow() {
        ISms iccISms = SmsManager.getISmsService();
        if (iccISms == null) {
            throw new UnsupportedOperationException("Sms is not supported");
        }
        return iccISms;
    }

    private static ISms getISmsService() {
        return ISms.Stub.asInterface(ServiceManager.getService("isms"));
    }

    public boolean copyMessageToIcc(byte[] smsc, byte[] pdu, int status) {
        boolean success = false;
        if (null == pdu) {
            throw new IllegalArgumentException("pdu is NULL");
        }
        try {
            ISms iccISms = SmsManager.getISmsService();
            if (iccISms != null) {
                success = iccISms.copyMessageToIccEf(ActivityThread.currentPackageName(), status, pdu, smsc);
            }
        }
        catch (RemoteException ex) {
            // empty catch block
        }
        return success;
    }

    public boolean deleteMessageFromIcc(int messageIndex) {
        boolean success = false;
        byte[] pdu = new byte[175];
        Arrays.fill(pdu, (byte)-1);
        try {
            ISms iccISms = SmsManager.getISmsService();
            if (iccISms != null) {
                success = iccISms.updateMessageOnIccEf(ActivityThread.currentPackageName(), messageIndex, 0, pdu);
            }
        }
        catch (RemoteException ex) {
            // empty catch block
        }
        return success;
    }

    public boolean updateMessageOnIcc(int messageIndex, int newStatus, byte[] pdu) {
        boolean success = false;
        try {
            ISms iccISms = SmsManager.getISmsService();
            if (iccISms != null) {
                success = iccISms.updateMessageOnIccEf(ActivityThread.currentPackageName(), messageIndex, newStatus, pdu);
            }
        }
        catch (RemoteException ex) {
            // empty catch block
        }
        return success;
    }

    public static ArrayList<SmsMessage> getAllMessagesFromIcc() {
        List<SmsRawData> records = null;
        try {
            ISms iccISms = SmsManager.getISmsService();
            if (iccISms != null) {
                records = iccISms.getAllMessagesFromIccEf(ActivityThread.currentPackageName());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return SmsManager.createMessageListFromRawRecords(records);
    }

    public boolean enableCellBroadcast(int messageIdentifier) {
        boolean success = false;
        try {
            ISms iccISms = SmsManager.getISmsService();
            if (iccISms != null) {
                success = iccISms.enableCellBroadcast(messageIdentifier);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return success;
    }

    public boolean disableCellBroadcast(int messageIdentifier) {
        boolean success = false;
        try {
            ISms iccISms = SmsManager.getISmsService();
            if (iccISms != null) {
                success = iccISms.disableCellBroadcast(messageIdentifier);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return success;
    }

    public boolean enableCellBroadcastRange(int startMessageId, int endMessageId) {
        boolean success = false;
        if (endMessageId < startMessageId) {
            throw new IllegalArgumentException("endMessageId < startMessageId");
        }
        try {
            ISms iccISms = SmsManager.getISmsService();
            if (iccISms != null) {
                success = iccISms.enableCellBroadcastRange(startMessageId, endMessageId);
            }
        }
        catch (RemoteException ex) {
            // empty catch block
        }
        return success;
    }

    public boolean disableCellBroadcastRange(int startMessageId, int endMessageId) {
        boolean success = false;
        if (endMessageId < startMessageId) {
            throw new IllegalArgumentException("endMessageId < startMessageId");
        }
        try {
            ISms iccISms = SmsManager.getISmsService();
            if (iccISms != null) {
                success = iccISms.disableCellBroadcastRange(startMessageId, endMessageId);
            }
        }
        catch (RemoteException ex) {
            // empty catch block
        }
        return success;
    }

    private static ArrayList<SmsMessage> createMessageListFromRawRecords(List<SmsRawData> records) {
        ArrayList<SmsMessage> messages = new ArrayList<SmsMessage>();
        if (records != null) {
            int count = records.size();
            for (int i = 0; i < count; ++i) {
                SmsMessage sms;
                SmsRawData data = records.get(i);
                if (data == null || (sms = SmsMessage.createFromEfRecord(i + 1, data.getBytes())) == null) continue;
                messages.add(sms);
            }
        }
        return messages;
    }

    public boolean isImsSmsSupported() {
        boolean boSupported = false;
        try {
            ISms iccISms = SmsManager.getISmsService();
            if (iccISms != null) {
                boSupported = iccISms.isImsSmsSupported();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return boSupported;
    }

    public String getImsSmsFormat() {
        String format = "unknown";
        try {
            ISms iccISms = SmsManager.getISmsService();
            if (iccISms != null) {
                format = iccISms.getImsSmsFormat();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return format;
    }

    public static long getDefaultSmsSubId() {
        ISms iccISms = null;
        try {
            iccISms = ISms.Stub.asInterface(ServiceManager.getService("isms"));
            return iccISms.getPreferredSmsSubscription();
        }
        catch (RemoteException ex) {
            return -1002L;
        }
        catch (NullPointerException ex) {
            return -1002L;
        }
    }

    public boolean isSMSPromptEnabled() {
        ISms iccISms = null;
        try {
            iccISms = ISms.Stub.asInterface(ServiceManager.getService("isms"));
            return iccISms.isSMSPromptEnabled();
        }
        catch (RemoteException ex) {
            return false;
        }
        catch (NullPointerException ex) {
            return false;
        }
    }

    public void sendMultimediaMessage(Context context, Uri contentUri, String locationUrl, Bundle configOverrides, PendingIntent sentIntent) {
        if (contentUri == null) {
            throw new IllegalArgumentException("Uri contentUri null");
        }
        try {
            IMms iMms = IMms.Stub.asInterface(ServiceManager.getService("imms"));
            if (iMms == null) {
                return;
            }
            context.grantUriPermission(PHONE_PACKAGE_NAME, contentUri, 1);
            this.grantCarrierPackageUriPermission(context, contentUri, "android.provider.Telephony.MMS_SEND", 1);
            iMms.sendMessage(this.getSubId(), ActivityThread.currentPackageName(), contentUri, locationUrl, configOverrides, sentIntent);
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    private void grantCarrierPackageUriPermission(Context context, Uri contentUri, String action, int permission2) {
        Intent intent = new Intent(action);
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        List<String> carrierPackages = telephonyManager.getCarrierPackageNamesForIntent(intent);
        if (carrierPackages != null && carrierPackages.size() == 1) {
            context.grantUriPermission(carrierPackages.get(0), contentUri, permission2);
        }
    }

    public void downloadMultimediaMessage(Context context, String locationUrl, Uri contentUri, Bundle configOverrides, PendingIntent downloadedIntent) {
        if (TextUtils.isEmpty(locationUrl)) {
            throw new IllegalArgumentException("Empty MMS location URL");
        }
        if (contentUri == null) {
            throw new IllegalArgumentException("Uri contentUri null");
        }
        try {
            IMms iMms = IMms.Stub.asInterface(ServiceManager.getService("imms"));
            if (iMms == null) {
                return;
            }
            context.grantUriPermission(PHONE_PACKAGE_NAME, contentUri, 2);
            this.grantCarrierPackageUriPermission(context, contentUri, "android.provider.Telephony.MMS_DOWNLOAD", 2);
            iMms.downloadMessage(this.getSubId(), ActivityThread.currentPackageName(), locationUrl, contentUri, configOverrides, downloadedIntent);
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    public void updateMmsSendStatus(Context context, int messageRef, byte[] pdu, int status, Uri contentUri) {
        try {
            IMms iMms = IMms.Stub.asInterface(ServiceManager.getService("imms"));
            if (iMms == null) {
                return;
            }
            iMms.updateMmsSendStatus(messageRef, pdu, status);
        }
        catch (RemoteException ex) {
            // empty catch block
        }
        if (contentUri != null) {
            context.revokeUriPermission(contentUri, 1);
        }
    }

    public void updateMmsDownloadStatus(Context context, int messageRef, int status, Uri contentUri) {
        try {
            IMms iMms = IMms.Stub.asInterface(ServiceManager.getService("imms"));
            if (iMms == null) {
                return;
            }
            iMms.updateMmsDownloadStatus(messageRef, status);
        }
        catch (RemoteException ex) {
            // empty catch block
        }
        if (contentUri != null) {
            context.revokeUriPermission(contentUri, 2);
        }
    }

    public Uri importTextMessage(String address, int type, String text, long timestampMillis, boolean seen, boolean read) {
        try {
            IMms iMms = IMms.Stub.asInterface(ServiceManager.getService("imms"));
            if (iMms != null) {
                return iMms.importTextMessage(ActivityThread.currentPackageName(), address, type, text, timestampMillis, seen, read);
            }
        }
        catch (RemoteException ex) {
            // empty catch block
        }
        return null;
    }

    public Uri importMultimediaMessage(Uri contentUri, String messageId, long timestampSecs, boolean seen, boolean read) {
        if (contentUri == null) {
            throw new IllegalArgumentException("Uri contentUri null");
        }
        try {
            IMms iMms = IMms.Stub.asInterface(ServiceManager.getService("imms"));
            if (iMms != null) {
                return iMms.importMultimediaMessage(ActivityThread.currentPackageName(), contentUri, messageId, timestampSecs, seen, read);
            }
        }
        catch (RemoteException ex) {
            // empty catch block
        }
        return null;
    }

    public boolean deleteStoredMessage(Uri messageUri) {
        if (messageUri == null) {
            throw new IllegalArgumentException("Empty message URI");
        }
        try {
            IMms iMms = IMms.Stub.asInterface(ServiceManager.getService("imms"));
            if (iMms != null) {
                return iMms.deleteStoredMessage(ActivityThread.currentPackageName(), messageUri);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return false;
    }

    public boolean deleteStoredConversation(long conversationId) {
        try {
            IMms iMms = IMms.Stub.asInterface(ServiceManager.getService("imms"));
            if (iMms != null) {
                return iMms.deleteStoredConversation(ActivityThread.currentPackageName(), conversationId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return false;
    }

    public boolean updateStoredMessageStatus(Uri messageUri, ContentValues statusValues) {
        if (messageUri == null) {
            throw new IllegalArgumentException("Empty message URI");
        }
        try {
            IMms iMms = IMms.Stub.asInterface(ServiceManager.getService("imms"));
            if (iMms != null) {
                return iMms.updateStoredMessageStatus(ActivityThread.currentPackageName(), messageUri, statusValues);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return false;
    }

    public boolean archiveStoredConversation(long conversationId, boolean archived) {
        try {
            IMms iMms = IMms.Stub.asInterface(ServiceManager.getService("imms"));
            if (iMms != null) {
                return iMms.archiveStoredConversation(ActivityThread.currentPackageName(), conversationId, archived);
            }
        }
        catch (RemoteException ex) {
            // empty catch block
        }
        return false;
    }

    public Uri addTextMessageDraft(String address, String text) {
        try {
            IMms iMms = IMms.Stub.asInterface(ServiceManager.getService("imms"));
            if (iMms != null) {
                return iMms.addTextMessageDraft(ActivityThread.currentPackageName(), address, text);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return null;
    }

    public Uri addMultimediaMessageDraft(Uri contentUri) {
        if (contentUri == null) {
            throw new IllegalArgumentException("Uri contentUri null");
        }
        try {
            IMms iMms = IMms.Stub.asInterface(ServiceManager.getService("imms"));
            if (iMms != null) {
                return iMms.addMultimediaMessageDraft(ActivityThread.currentPackageName(), contentUri);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return null;
    }

    public void sendStoredTextMessage(Uri messageUri, String scAddress, PendingIntent sentIntent, PendingIntent deliveryIntent) {
        if (messageUri == null) {
            throw new IllegalArgumentException("Empty message URI");
        }
        try {
            ISms iccISms = SmsManager.getISmsServiceOrThrow();
            iccISms.sendStoredText(this.getSubId(), ActivityThread.currentPackageName(), messageUri, scAddress, sentIntent, deliveryIntent);
        }
        catch (RemoteException ex) {
            // empty catch block
        }
    }

    public void sendStoredMultipartTextMessage(Uri messageUri, String scAddress, ArrayList<PendingIntent> sentIntents, ArrayList<PendingIntent> deliveryIntents) {
        if (messageUri == null) {
            throw new IllegalArgumentException("Empty message URI");
        }
        try {
            ISms iccISms = SmsManager.getISmsServiceOrThrow();
            iccISms.sendStoredMultipartText(this.getSubId(), ActivityThread.currentPackageName(), messageUri, scAddress, sentIntents, deliveryIntents);
        }
        catch (RemoteException ex) {
            // empty catch block
        }
    }

    public void sendStoredMultimediaMessage(Uri messageUri, Bundle configOverrides, PendingIntent sentIntent) {
        if (messageUri == null) {
            throw new IllegalArgumentException("Empty message URI");
        }
        try {
            IMms iMms = IMms.Stub.asInterface(ServiceManager.getService("imms"));
            if (iMms != null) {
                iMms.sendStoredMessage(this.getSubId(), ActivityThread.currentPackageName(), messageUri, configOverrides, sentIntent);
            }
        }
        catch (RemoteException ex) {
            // empty catch block
        }
    }

    public void setAutoPersisting(boolean enabled) {
        try {
            IMms iMms = IMms.Stub.asInterface(ServiceManager.getService("imms"));
            if (iMms != null) {
                iMms.setAutoPersisting(ActivityThread.currentPackageName(), enabled);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public boolean getAutoPersisting() {
        try {
            IMms iMms = IMms.Stub.asInterface(ServiceManager.getService("imms"));
            if (iMms != null) {
                return iMms.getAutoPersisting();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return false;
    }

    public Bundle getCarrierConfigValues() {
        try {
            IMms iMms = IMms.Stub.asInterface(ServiceManager.getService("imms"));
            if (iMms != null) {
                return iMms.getCarrierConfigValues(this.getSubId());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return null;
    }
}

