/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.text.Spanned;
import java.lang.reflect.Array;

public class SpanSet<E> {
    private final Class<? extends E> classType;
    int numberOfSpans;
    E[] spans;
    int[] spanStarts;
    int[] spanEnds;
    int[] spanFlags;

    SpanSet(Class<? extends E> type) {
        this.classType = type;
        this.numberOfSpans = 0;
    }

    public void init(Spanned spanned, int start, int limit) {
        E[] allSpans = spanned.getSpans(start, limit, this.classType);
        int length = allSpans.length;
        if (length > 0 && (this.spans == null || this.spans.length < length)) {
            this.spans = (Object[])Array.newInstance(this.classType, length);
            this.spanStarts = new int[length];
            this.spanEnds = new int[length];
            this.spanFlags = new int[length];
        }
        this.numberOfSpans = 0;
        for (int i = 0; i < length; ++i) {
            int spanEnd;
            E span = allSpans[i];
            int spanStart = spanned.getSpanStart(span);
            if (spanStart == (spanEnd = spanned.getSpanEnd(span))) continue;
            int spanFlag = spanned.getSpanFlags(span);
            this.spans[this.numberOfSpans] = span;
            this.spanStarts[this.numberOfSpans] = spanStart;
            this.spanEnds[this.numberOfSpans] = spanEnd;
            this.spanFlags[this.numberOfSpans] = spanFlag;
            ++this.numberOfSpans;
        }
    }

    public boolean hasSpansIntersecting(int start, int end) {
        for (int i = 0; i < this.numberOfSpans; ++i) {
            if (this.spanStarts[i] >= end || this.spanEnds[i] <= start) continue;
            return true;
        }
        return false;
    }

    int getNextTransition(int start, int limit) {
        for (int i = 0; i < this.numberOfSpans; ++i) {
            int spanStart = this.spanStarts[i];
            int spanEnd = this.spanEnds[i];
            if (spanStart > start && spanStart < limit) {
                limit = spanStart;
            }
            if (spanEnd <= start || spanEnd >= limit) continue;
            limit = spanEnd;
        }
        return limit;
    }

    public void recycle() {
        for (int i = 0; i < this.numberOfSpans; ++i) {
            this.spans[i] = null;
        }
    }
}

