/*
 * Decompiled with CFR 0.152.
 */
package android.text.format;

import android.text.format.TimeFormatter;
import android.util.TimeFormatException;
import java.io.IOException;
import java.util.Locale;
import java.util.TimeZone;
import libcore.util.ZoneInfo;
import libcore.util.ZoneInfoDB;

public class Time {
    private static final String Y_M_D_T_H_M_S_000 = "%Y-%m-%dT%H:%M:%S.000";
    private static final String Y_M_D_T_H_M_S_000_Z = "%Y-%m-%dT%H:%M:%S.000Z";
    private static final String Y_M_D = "%Y-%m-%d";
    public static final String TIMEZONE_UTC = "UTC";
    public static final int EPOCH_JULIAN_DAY = 2440588;
    public static final int MONDAY_BEFORE_JULIAN_EPOCH = 2440585;
    public boolean allDay;
    public int second;
    public int minute;
    public int hour;
    public int monthDay;
    public int month;
    public int year;
    public int weekDay;
    public int yearDay;
    public int isDst;
    public long gmtoff;
    public String timezone;
    public static final int SECOND = 1;
    public static final int MINUTE = 2;
    public static final int HOUR = 3;
    public static final int MONTH_DAY = 4;
    public static final int MONTH = 5;
    public static final int YEAR = 6;
    public static final int WEEK_DAY = 7;
    public static final int YEAR_DAY = 8;
    public static final int WEEK_NUM = 9;
    public static final int SUNDAY = 0;
    public static final int MONDAY = 1;
    public static final int TUESDAY = 2;
    public static final int WEDNESDAY = 3;
    public static final int THURSDAY = 4;
    public static final int FRIDAY = 5;
    public static final int SATURDAY = 6;
    private TimeCalculator calculator;
    private static final int[] DAYS_PER_MONTH = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int[] sThursdayOffset = new int[]{-3, 3, 2, 1, 0, -1, -2};

    public Time(String timezoneId) {
        if (timezoneId == null) {
            throw new NullPointerException("timezoneId is null!");
        }
        this.initialize(timezoneId);
    }

    public Time() {
        this.initialize(TimeZone.getDefault().getID());
    }

    public Time(Time other) {
        this.initialize(other.timezone);
        this.set(other);
    }

    private void initialize(String timezoneId) {
        this.timezone = timezoneId;
        this.year = 1970;
        this.monthDay = 1;
        this.isDst = -1;
        this.calculator = new TimeCalculator(timezoneId);
    }

    public long normalize(boolean ignoreDst) {
        this.calculator.copyFieldsFromTime(this);
        long timeInMillis = this.calculator.toMillis(ignoreDst);
        this.calculator.copyFieldsToTime(this);
        return timeInMillis;
    }

    public void switchTimezone(String timezone) {
        this.calculator.copyFieldsFromTime(this);
        this.calculator.switchTimeZone(timezone);
        this.calculator.copyFieldsToTime(this);
        this.timezone = timezone;
    }

    public int getActualMaximum(int field) {
        switch (field) {
            case 1: {
                return 59;
            }
            case 2: {
                return 59;
            }
            case 3: {
                return 23;
            }
            case 4: {
                int n = DAYS_PER_MONTH[this.month];
                if (n != 28) {
                    return n;
                }
                int y = this.year;
                return y % 4 == 0 && (y % 100 != 0 || y % 400 == 0) ? 29 : 28;
            }
            case 5: {
                return 11;
            }
            case 6: {
                return 2037;
            }
            case 7: {
                return 6;
            }
            case 8: {
                int y = this.year;
                return y % 4 == 0 && (y % 100 != 0 || y % 400 == 0) ? 365 : 364;
            }
            case 9: {
                throw new RuntimeException("WEEK_NUM not implemented");
            }
        }
        throw new RuntimeException("bad field=" + field);
    }

    public void clear(String timezoneId) {
        if (timezoneId == null) {
            throw new NullPointerException("timezone is null!");
        }
        this.timezone = timezoneId;
        this.allDay = false;
        this.second = 0;
        this.minute = 0;
        this.hour = 0;
        this.monthDay = 0;
        this.month = 0;
        this.year = 0;
        this.weekDay = 0;
        this.yearDay = 0;
        this.gmtoff = 0L;
        this.isDst = -1;
    }

    public static int compare(Time a, Time b) {
        if (a == null) {
            throw new NullPointerException("a == null");
        }
        if (b == null) {
            throw new NullPointerException("b == null");
        }
        a.calculator.copyFieldsFromTime(a);
        b.calculator.copyFieldsFromTime(b);
        return TimeCalculator.compare(a.calculator, b.calculator);
    }

    public String format(String format) {
        this.calculator.copyFieldsFromTime(this);
        return this.calculator.format(format);
    }

    public String toString() {
        TimeCalculator calculator = new TimeCalculator(this.timezone);
        calculator.copyFieldsFromTime(this);
        return calculator.toStringInternal();
    }

    public boolean parse(String s) {
        if (s == null) {
            throw new NullPointerException("time string is null");
        }
        if (this.parseInternal(s)) {
            this.timezone = TIMEZONE_UTC;
            return true;
        }
        return false;
    }

    private boolean parseInternal(String s) {
        int len = s.length();
        if (len < 8) {
            throw new TimeFormatException("String is too short: \"" + s + "\" Expected at least 8 characters.");
        }
        boolean inUtc = false;
        int n = Time.getChar(s, 0, 1000);
        n += Time.getChar(s, 1, 100);
        n += Time.getChar(s, 2, 10);
        this.year = n += Time.getChar(s, 3, 1);
        n = Time.getChar(s, 4, 10);
        n += Time.getChar(s, 5, 1);
        this.month = --n;
        n = Time.getChar(s, 6, 10);
        this.monthDay = n += Time.getChar(s, 7, 1);
        if (len > 8) {
            if (len < 15) {
                throw new TimeFormatException("String is too short: \"" + s + "\" If there are more than 8 characters there must be at least" + " 15.");
            }
            this.checkChar(s, 8, 'T');
            this.allDay = false;
            n = Time.getChar(s, 9, 10);
            this.hour = n += Time.getChar(s, 10, 1);
            n = Time.getChar(s, 11, 10);
            this.minute = n += Time.getChar(s, 12, 1);
            n = Time.getChar(s, 13, 10);
            this.second = n += Time.getChar(s, 14, 1);
            if (len > 15) {
                this.checkChar(s, 15, 'Z');
                inUtc = true;
            }
        } else {
            this.allDay = true;
            this.hour = 0;
            this.minute = 0;
            this.second = 0;
        }
        this.weekDay = 0;
        this.yearDay = 0;
        this.isDst = -1;
        this.gmtoff = 0L;
        return inUtc;
    }

    private void checkChar(String s, int spos, char expected) {
        char c = s.charAt(spos);
        if (c != expected) {
            throw new TimeFormatException(String.format("Unexpected character 0x%02d at pos=%d.  Expected 0x%02d ('%c').", c, spos, (int)expected, Character.valueOf(expected)));
        }
    }

    private static int getChar(String s, int spos, int mul) {
        char c = s.charAt(spos);
        if (Character.isDigit(c)) {
            return Character.getNumericValue(c) * mul;
        }
        throw new TimeFormatException("Parse error at pos=" + spos);
    }

    public boolean parse3339(String s) {
        if (s == null) {
            throw new NullPointerException("time string is null");
        }
        if (this.parse3339Internal(s)) {
            this.timezone = TIMEZONE_UTC;
            return true;
        }
        return false;
    }

    private boolean parse3339Internal(String s) {
        int len = s.length();
        if (len < 10) {
            throw new TimeFormatException("String too short --- expected at least 10 characters.");
        }
        boolean inUtc = false;
        int n = Time.getChar(s, 0, 1000);
        n += Time.getChar(s, 1, 100);
        n += Time.getChar(s, 2, 10);
        this.year = n += Time.getChar(s, 3, 1);
        this.checkChar(s, 4, '-');
        n = Time.getChar(s, 5, 10);
        n += Time.getChar(s, 6, 1);
        this.month = --n;
        this.checkChar(s, 7, '-');
        n = Time.getChar(s, 8, 10);
        this.monthDay = n += Time.getChar(s, 9, 1);
        if (len >= 19) {
            this.checkChar(s, 10, 'T');
            this.allDay = false;
            n = Time.getChar(s, 11, 10);
            int hour = n += Time.getChar(s, 12, 1);
            this.checkChar(s, 13, ':');
            n = Time.getChar(s, 14, 10);
            int minute = n += Time.getChar(s, 15, 1);
            this.checkChar(s, 16, ':');
            n = Time.getChar(s, 17, 10);
            this.second = n += Time.getChar(s, 18, 1);
            int tzIndex = 19;
            if (tzIndex < len && s.charAt(tzIndex) == '.') {
                while (++tzIndex < len && Character.isDigit(s.charAt(tzIndex))) {
                }
            }
            int offset = 0;
            if (len > tzIndex) {
                char c = s.charAt(tzIndex);
                switch (c) {
                    case 'Z': {
                        offset = 0;
                        break;
                    }
                    case '-': {
                        offset = 1;
                        break;
                    }
                    case '+': {
                        offset = -1;
                        break;
                    }
                    default: {
                        throw new TimeFormatException(String.format("Unexpected character 0x%02d at position %d.  Expected + or -", c, tzIndex));
                    }
                }
                inUtc = true;
                if (offset != 0) {
                    if (len < tzIndex + 6) {
                        throw new TimeFormatException(String.format("Unexpected length; should be %d characters", tzIndex + 6));
                    }
                    n = Time.getChar(s, tzIndex + 1, 10);
                    n += Time.getChar(s, tzIndex + 2, 1);
                    hour += (n *= offset);
                    n = Time.getChar(s, tzIndex + 4, 10);
                    n += Time.getChar(s, tzIndex + 5, 1);
                    minute += (n *= offset);
                }
            }
            this.hour = hour;
            this.minute = minute;
            if (offset != 0) {
                this.normalize(false);
            }
        } else {
            this.allDay = true;
            this.hour = 0;
            this.minute = 0;
            this.second = 0;
        }
        this.weekDay = 0;
        this.yearDay = 0;
        this.isDst = -1;
        this.gmtoff = 0L;
        return inUtc;
    }

    public static String getCurrentTimezone() {
        return TimeZone.getDefault().getID();
    }

    public void setToNow() {
        this.set(System.currentTimeMillis());
    }

    public long toMillis(boolean ignoreDst) {
        this.calculator.copyFieldsFromTime(this);
        return this.calculator.toMillis(ignoreDst);
    }

    public void set(long millis) {
        this.allDay = false;
        this.calculator.timezone = this.timezone;
        this.calculator.setTimeInMillis(millis);
        this.calculator.copyFieldsToTime(this);
    }

    public String format2445() {
        this.calculator.copyFieldsFromTime(this);
        return this.calculator.format2445(!this.allDay);
    }

    public void set(Time that) {
        this.timezone = that.timezone;
        this.allDay = that.allDay;
        this.second = that.second;
        this.minute = that.minute;
        this.hour = that.hour;
        this.monthDay = that.monthDay;
        this.month = that.month;
        this.year = that.year;
        this.weekDay = that.weekDay;
        this.yearDay = that.yearDay;
        this.isDst = that.isDst;
        this.gmtoff = that.gmtoff;
    }

    public void set(int second, int minute, int hour, int monthDay, int month, int year) {
        this.allDay = false;
        this.second = second;
        this.minute = minute;
        this.hour = hour;
        this.monthDay = monthDay;
        this.month = month;
        this.year = year;
        this.weekDay = 0;
        this.yearDay = 0;
        this.isDst = -1;
        this.gmtoff = 0L;
    }

    public void set(int monthDay, int month, int year) {
        this.allDay = true;
        this.second = 0;
        this.minute = 0;
        this.hour = 0;
        this.monthDay = monthDay;
        this.month = month;
        this.year = year;
        this.weekDay = 0;
        this.yearDay = 0;
        this.isDst = -1;
        this.gmtoff = 0L;
    }

    public boolean before(Time that) {
        return Time.compare(this, that) < 0;
    }

    public boolean after(Time that) {
        return Time.compare(this, that) > 0;
    }

    public int getWeekNumber() {
        int closestThursday = this.yearDay + sThursdayOffset[this.weekDay];
        if (closestThursday >= 0 && closestThursday <= 364) {
            return closestThursday / 7 + 1;
        }
        Time temp = new Time(this);
        temp.monthDay += sThursdayOffset[this.weekDay];
        temp.normalize(true);
        return temp.yearDay / 7 + 1;
    }

    public String format3339(boolean allDay) {
        if (allDay) {
            return this.format(Y_M_D);
        }
        if (TIMEZONE_UTC.equals(this.timezone)) {
            return this.format(Y_M_D_T_H_M_S_000_Z);
        }
        String base = this.format(Y_M_D_T_H_M_S_000);
        String sign = this.gmtoff < 0L ? "-" : "+";
        int offset = (int)Math.abs(this.gmtoff);
        int minutes = offset % 3600 / 60;
        int hours = offset / 3600;
        return String.format(Locale.US, "%s%s%02d:%02d", base, sign, hours, minutes);
    }

    public static boolean isEpoch(Time time) {
        long millis = time.toMillis(true);
        return Time.getJulianDay(millis, 0L) == 2440588;
    }

    public static int getJulianDay(long millis, long gmtoff) {
        long offsetMillis = gmtoff * 1000L;
        long julianDay = (millis + offsetMillis) / 86400000L;
        return (int)julianDay + 2440588;
    }

    public long setJulianDay(int julianDay) {
        long millis = (long)(julianDay - 2440588) * 86400000L;
        this.set(millis);
        int approximateDay = Time.getJulianDay(millis, this.gmtoff);
        int diff = julianDay - approximateDay;
        this.monthDay += diff;
        this.hour = 0;
        this.minute = 0;
        this.second = 0;
        millis = this.normalize(true);
        return millis;
    }

    public static int getWeeksSinceEpochFromJulianDay(int julianDay, int firstDayOfWeek) {
        int diff = 4 - firstDayOfWeek;
        if (diff < 0) {
            diff += 7;
        }
        int refDay = 2440588 - diff;
        return (julianDay - refDay) / 7;
    }

    public static int getJulianMondayFromWeeksSinceEpoch(int week) {
        return 2440585 + week * 7;
    }

    private static class TimeCalculator {
        public final ZoneInfo.WallTime wallTime;
        public String timezone;
        private ZoneInfo zoneInfo;

        public TimeCalculator(String timezoneId) {
            this.zoneInfo = TimeCalculator.lookupZoneInfo(timezoneId);
            this.wallTime = new ZoneInfo.WallTime();
        }

        public long toMillis(boolean ignoreDst) {
            int r;
            if (ignoreDst) {
                this.wallTime.setIsDst(-1);
            }
            if ((r = this.wallTime.mktime(this.zoneInfo)) == -1) {
                return -1L;
            }
            return (long)r * 1000L;
        }

        public void setTimeInMillis(long millis) {
            int intSeconds = (int)(millis / 1000L);
            this.updateZoneInfoFromTimeZone();
            this.wallTime.localtime(intSeconds, this.zoneInfo);
        }

        public String format(String format) {
            if (format == null) {
                format = "%c";
            }
            TimeFormatter formatter = new TimeFormatter();
            return formatter.format(format, this.wallTime, this.zoneInfo);
        }

        private void updateZoneInfoFromTimeZone() {
            if (!this.zoneInfo.getID().equals(this.timezone)) {
                this.zoneInfo = TimeCalculator.lookupZoneInfo(this.timezone);
            }
        }

        private static ZoneInfo lookupZoneInfo(String timezoneId) {
            try {
                ZoneInfo zoneInfo = ZoneInfoDB.getInstance().makeTimeZone(timezoneId);
                if (zoneInfo == null) {
                    zoneInfo = ZoneInfoDB.getInstance().makeTimeZone("GMT");
                }
                if (zoneInfo == null) {
                    throw new AssertionError((Object)("GMT not found: \"" + timezoneId + "\""));
                }
                return zoneInfo;
            }
            catch (IOException e) {
                throw new AssertionError("Error loading timezone: \"" + timezoneId + "\"", e);
            }
        }

        public void switchTimeZone(String timezone) {
            int seconds = this.wallTime.mktime(this.zoneInfo);
            this.timezone = timezone;
            this.updateZoneInfoFromTimeZone();
            this.wallTime.localtime(seconds, this.zoneInfo);
        }

        public String format2445(boolean hasTime) {
            char[] buf = new char[hasTime ? 16 : 8];
            int n = this.wallTime.getYear();
            buf[0] = this.toChar(n / 1000);
            buf[1] = this.toChar((n %= 1000) / 100);
            buf[2] = this.toChar((n %= 100) / 10);
            buf[3] = this.toChar(n %= 10);
            n = this.wallTime.getMonth() + 1;
            buf[4] = this.toChar(n / 10);
            buf[5] = this.toChar(n % 10);
            n = this.wallTime.getMonthDay();
            buf[6] = this.toChar(n / 10);
            buf[7] = this.toChar(n % 10);
            if (!hasTime) {
                return new String(buf, 0, 8);
            }
            buf[8] = 84;
            n = this.wallTime.getHour();
            buf[9] = this.toChar(n / 10);
            buf[10] = this.toChar(n % 10);
            n = this.wallTime.getMinute();
            buf[11] = this.toChar(n / 10);
            buf[12] = this.toChar(n % 10);
            n = this.wallTime.getSecond();
            buf[13] = this.toChar(n / 10);
            buf[14] = this.toChar(n % 10);
            if (Time.TIMEZONE_UTC.equals(this.timezone)) {
                buf[15] = 90;
                return new String(buf, 0, 16);
            }
            return new String(buf, 0, 15);
        }

        private char toChar(int n) {
            return n >= 0 && n <= 9 ? (char)(n + 48) : (char)' ';
        }

        public String toStringInternal() {
            return String.format("%04d%02d%02dT%02d%02d%02d%s(%d,%d,%d,%d,%d)", this.wallTime.getYear(), this.wallTime.getMonth() + 1, this.wallTime.getMonthDay(), this.wallTime.getHour(), this.wallTime.getMinute(), this.wallTime.getSecond(), this.timezone, this.wallTime.getWeekDay(), this.wallTime.getYearDay(), this.wallTime.getGmtOffset(), this.wallTime.getIsDst(), this.toMillis(false) / 1000L);
        }

        public static int compare(TimeCalculator aObject, TimeCalculator bObject) {
            long bm;
            if (aObject.timezone.equals(bObject.timezone)) {
                int diff = aObject.wallTime.getYear() - bObject.wallTime.getYear();
                if (diff != 0) {
                    return diff;
                }
                diff = aObject.wallTime.getMonth() - bObject.wallTime.getMonth();
                if (diff != 0) {
                    return diff;
                }
                diff = aObject.wallTime.getMonthDay() - bObject.wallTime.getMonthDay();
                if (diff != 0) {
                    return diff;
                }
                diff = aObject.wallTime.getHour() - bObject.wallTime.getHour();
                if (diff != 0) {
                    return diff;
                }
                diff = aObject.wallTime.getMinute() - bObject.wallTime.getMinute();
                if (diff != 0) {
                    return diff;
                }
                diff = aObject.wallTime.getSecond() - bObject.wallTime.getSecond();
                if (diff != 0) {
                    return diff;
                }
                return 0;
            }
            long am = aObject.toMillis(false);
            long diff = am - (bm = bObject.toMillis(false));
            return diff < 0L ? -1 : (diff > 0L ? 1 : 0);
        }

        public void copyFieldsToTime(Time time) {
            time.second = this.wallTime.getSecond();
            time.minute = this.wallTime.getMinute();
            time.hour = this.wallTime.getHour();
            time.monthDay = this.wallTime.getMonthDay();
            time.month = this.wallTime.getMonth();
            time.year = this.wallTime.getYear();
            time.weekDay = this.wallTime.getWeekDay();
            time.yearDay = this.wallTime.getYearDay();
            time.isDst = this.wallTime.getIsDst();
            time.gmtoff = this.wallTime.getGmtOffset();
        }

        public void copyFieldsFromTime(Time time) {
            this.wallTime.setSecond(time.second);
            this.wallTime.setMinute(time.minute);
            this.wallTime.setHour(time.hour);
            this.wallTime.setMonthDay(time.monthDay);
            this.wallTime.setMonth(time.month);
            this.wallTime.setYear(time.year);
            this.wallTime.setWeekDay(time.weekDay);
            this.wallTime.setYearDay(time.yearDay);
            this.wallTime.setIsDst(time.isDst);
            this.wallTime.setGmtOffset((int)time.gmtoff);
            if (time.allDay && (time.second != 0 || time.minute != 0 || time.hour != 0)) {
                throw new IllegalArgumentException("allDay is true but sec, min, hour are not 0.");
            }
            this.timezone = time.timezone;
            this.updateZoneInfoFromTimeZone();
        }
    }
}

