/*
 * Decompiled with CFR 0.152.
 */
package android.transition;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Path;
import android.transition.PathMotion;
import android.util.AttributeSet;
import android.util.FloatMath;
import com.android.internal.R;

public class ArcMotion
extends PathMotion {
    private static final float DEFAULT_MIN_ANGLE_DEGREES = 0.0f;
    private static final float DEFAULT_MAX_ANGLE_DEGREES = 70.0f;
    private static final float DEFAULT_MAX_TANGENT = (float)Math.tan(Math.toRadians(35.0));
    private float mMinimumHorizontalAngle = 0.0f;
    private float mMinimumVerticalAngle = 0.0f;
    private float mMaximumAngle = 70.0f;
    private float mMinimumHorizontalTangent = 0.0f;
    private float mMinimumVerticalTangent = 0.0f;
    private float mMaximumTangent = DEFAULT_MAX_TANGENT;

    public ArcMotion() {
    }

    public ArcMotion(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ArcMotion);
        float minimumVerticalAngle = a.getFloat(1, 0.0f);
        this.setMinimumVerticalAngle(minimumVerticalAngle);
        float minimumHorizontalAngle = a.getFloat(0, 0.0f);
        this.setMinimumHorizontalAngle(minimumHorizontalAngle);
        float maximumAngle = a.getFloat(2, 70.0f);
        this.setMaximumAngle(maximumAngle);
        a.recycle();
    }

    public void setMinimumHorizontalAngle(float angleInDegrees) {
        this.mMinimumHorizontalAngle = angleInDegrees;
        this.mMinimumHorizontalTangent = ArcMotion.toTangent(angleInDegrees);
    }

    public float getMinimumHorizontalAngle() {
        return this.mMinimumHorizontalAngle;
    }

    public void setMinimumVerticalAngle(float angleInDegrees) {
        this.mMinimumVerticalAngle = angleInDegrees;
        this.mMinimumVerticalTangent = ArcMotion.toTangent(angleInDegrees);
    }

    public float getMinimumVerticalAngle() {
        return this.mMinimumVerticalAngle;
    }

    public void setMaximumAngle(float angleInDegrees) {
        this.mMaximumAngle = angleInDegrees;
        this.mMaximumTangent = ArcMotion.toTangent(angleInDegrees);
    }

    public float getMaximumAngle() {
        return this.mMaximumAngle;
    }

    private static float toTangent(float arcInDegrees) {
        if (arcInDegrees < 0.0f || arcInDegrees > 90.0f) {
            throw new IllegalArgumentException("Arc must be between 0 and 90 degrees");
        }
        return (float)Math.tan(Math.toRadians(arcInDegrees / 2.0f));
    }

    @Override
    public Path getPath(float startX, float startY, float endX, float endY) {
        float ey;
        float ex;
        Path path = new Path();
        path.moveTo(startX, startY);
        if (startY == endY) {
            ex = (startX + endX) / 2.0f;
            ey = startY + this.mMinimumHorizontalTangent * Math.abs(endX - startX) / 2.0f;
        } else if (startX == endX) {
            ex = startX + this.mMinimumVerticalTangent * Math.abs(endY - startY) / 2.0f;
            ey = (startY + endY) / 2.0f;
        } else {
            float deltaX = endX - startX;
            float deltaY = startY - endY;
            float h2 = deltaX * deltaX + deltaY * deltaY;
            float dx = (startX + endX) / 2.0f;
            float dy = (startY + endY) / 2.0f;
            float midDist2 = h2 * 0.25f;
            float minimumArcDist2 = 0.0f;
            if (Math.abs(deltaX) < Math.abs(deltaY)) {
                float eDistY = h2 / (2.0f * deltaY);
                ey = endY + eDistY;
                ex = endX;
                minimumArcDist2 = midDist2 * this.mMinimumVerticalTangent * this.mMinimumVerticalTangent;
            } else {
                float eDistX = h2 / (2.0f * deltaX);
                ex = endX + eDistX;
                ey = endY;
                minimumArcDist2 = midDist2 * this.mMinimumHorizontalTangent * this.mMinimumHorizontalTangent;
            }
            float arcDistX = dx - ex;
            float arcDistY = dy - ey;
            float arcDist2 = arcDistX * arcDistX + arcDistY * arcDistY;
            float maximumArcDist2 = midDist2 * this.mMaximumTangent * this.mMaximumTangent;
            float newArcDistance2 = 0.0f;
            if (arcDist2 < minimumArcDist2) {
                newArcDistance2 = minimumArcDist2;
            } else if (arcDist2 > maximumArcDist2) {
                newArcDistance2 = maximumArcDist2;
            }
            if (newArcDistance2 != 0.0f) {
                float ratio2 = newArcDistance2 / arcDist2;
                float ratio = FloatMath.sqrt(ratio2);
                ex = dx + ratio * (ex - dx);
                ey = dy + ratio * (ey - dy);
            }
        }
        float controlX1 = (startX + ex) / 2.0f;
        float controlY1 = (startY + ey) / 2.0f;
        float controlX2 = (ex + endX) / 2.0f;
        float controlY2 = (ey + endY) / 2.0f;
        path.cubicTo(controlX1, controlY1, controlX2, controlY2, endX, endY);
        return path;
    }
}

