/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import com.android.internal.util.Preconditions;

public final class Size {
    private final int mWidth;
    private final int mHeight;

    public Size(int width, int height) {
        this.mWidth = width;
        this.mHeight = height;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof Size) {
            Size other = (Size)obj;
            return this.mWidth == other.mWidth && this.mHeight == other.mHeight;
        }
        return false;
    }

    public String toString() {
        return this.mWidth + "x" + this.mHeight;
    }

    private static NumberFormatException invalidSize(String s) {
        throw new NumberFormatException("Invalid Size: \"" + s + "\"");
    }

    public static Size parseSize(String string2) throws NumberFormatException {
        Preconditions.checkNotNull(string2, "string must not be null");
        int sep_ix = string2.indexOf(42);
        if (sep_ix < 0) {
            sep_ix = string2.indexOf(120);
        }
        if (sep_ix < 0) {
            throw Size.invalidSize(string2);
        }
        try {
            return new Size(Integer.parseInt(string2.substring(0, sep_ix)), Integer.parseInt(string2.substring(sep_ix + 1)));
        }
        catch (NumberFormatException e) {
            throw Size.invalidSize(string2);
        }
    }

    public int hashCode() {
        return this.mHeight ^ (this.mWidth << 16 | this.mWidth >>> 16);
    }
}

