/*
 * Decompiled with CFR 0.152.
 */
package android.view.animation;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.util.Xml;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.AnticipateInterpolator;
import android.view.animation.AnticipateOvershootInterpolator;
import android.view.animation.BounceInterpolator;
import android.view.animation.CycleInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.GridLayoutAnimationController;
import android.view.animation.Interpolator;
import android.view.animation.LayoutAnimationController;
import android.view.animation.LinearInterpolator;
import android.view.animation.OvershootInterpolator;
import android.view.animation.PathInterpolator;
import android.view.animation.RotateAnimation;
import android.view.animation.ScaleAnimation;
import android.view.animation.TranslateAnimation;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class AnimationUtils {
    private static final int TOGETHER = 0;
    private static final int SEQUENTIALLY = 1;

    public static long currentAnimationTimeMillis() {
        return SystemClock.uptimeMillis();
    }

    public static Animation loadAnimation(Context context, int id2) throws Resources.NotFoundException {
        try (XmlResourceParser parser = null;){
            parser = context.getResources().getAnimation(id2);
            Animation animation = AnimationUtils.createAnimationFromXml(context, parser);
            return animation;
        }
    }

    private static Animation createAnimationFromXml(Context c, XmlPullParser parser) throws XmlPullParserException, IOException {
        return AnimationUtils.createAnimationFromXml(c, parser, null, Xml.asAttributeSet(parser));
    }

    private static Animation createAnimationFromXml(Context c, XmlPullParser parser, AnimationSet parent, AttributeSet attrs) throws XmlPullParserException, IOException {
        int type;
        Animation anim2 = null;
        int depth = parser.getDepth();
        while (((type = parser.next()) != 3 || parser.getDepth() > depth) && type != 1) {
            if (type != 2) continue;
            String name = parser.getName();
            if (name.equals("set")) {
                anim2 = new AnimationSet(c, attrs);
                AnimationUtils.createAnimationFromXml(c, parser, anim2, attrs);
            } else if (name.equals("alpha")) {
                anim2 = new AlphaAnimation(c, attrs);
            } else if (name.equals("scale")) {
                anim2 = new ScaleAnimation(c, attrs);
            } else if (name.equals("rotate")) {
                anim2 = new RotateAnimation(c, attrs);
            } else if (name.equals("translate")) {
                anim2 = new TranslateAnimation(c, attrs);
            } else {
                throw new RuntimeException("Unknown animation name: " + parser.getName());
            }
            if (parent == null) continue;
            parent.addAnimation(anim2);
        }
        return anim2;
    }

    public static LayoutAnimationController loadLayoutAnimation(Context context, int id2) throws Resources.NotFoundException {
        try (XmlResourceParser parser = null;){
            parser = context.getResources().getAnimation(id2);
            LayoutAnimationController layoutAnimationController = AnimationUtils.createLayoutAnimationFromXml(context, parser);
            return layoutAnimationController;
        }
    }

    private static LayoutAnimationController createLayoutAnimationFromXml(Context c, XmlPullParser parser) throws XmlPullParserException, IOException {
        return AnimationUtils.createLayoutAnimationFromXml(c, parser, Xml.asAttributeSet(parser));
    }

    private static LayoutAnimationController createLayoutAnimationFromXml(Context c, XmlPullParser parser, AttributeSet attrs) throws XmlPullParserException, IOException {
        int type;
        LayoutAnimationController controller = null;
        int depth = parser.getDepth();
        while (((type = parser.next()) != 3 || parser.getDepth() > depth) && type != 1) {
            if (type != 2) continue;
            String name = parser.getName();
            if ("layoutAnimation".equals(name)) {
                controller = new LayoutAnimationController(c, attrs);
                continue;
            }
            if ("gridLayoutAnimation".equals(name)) {
                controller = new GridLayoutAnimationController(c, attrs);
                continue;
            }
            throw new RuntimeException("Unknown layout animation name: " + name);
        }
        return controller;
    }

    public static Animation makeInAnimation(Context c, boolean fromLeft) {
        Animation a = fromLeft ? AnimationUtils.loadAnimation(c, 17432578) : AnimationUtils.loadAnimation(c, 17432673);
        a.setInterpolator(new DecelerateInterpolator());
        a.setStartTime(AnimationUtils.currentAnimationTimeMillis());
        return a;
    }

    public static Animation makeOutAnimation(Context c, boolean toRight) {
        Animation a = toRight ? AnimationUtils.loadAnimation(c, 17432579) : AnimationUtils.loadAnimation(c, 17432676);
        a.setInterpolator(new AccelerateInterpolator());
        a.setStartTime(AnimationUtils.currentAnimationTimeMillis());
        return a;
    }

    public static Animation makeInChildBottomAnimation(Context c) {
        Animation a = AnimationUtils.loadAnimation(c, 17432671);
        a.setInterpolator(new AccelerateInterpolator());
        a.setStartTime(AnimationUtils.currentAnimationTimeMillis());
        return a;
    }

    public static Interpolator loadInterpolator(Context context, int id2) throws Resources.NotFoundException {
        try (XmlResourceParser parser = null;){
            parser = context.getResources().getAnimation(id2);
            Interpolator interpolator2 = AnimationUtils.createInterpolatorFromXml(context.getResources(), context.getTheme(), parser);
            return interpolator2;
        }
    }

    public static Interpolator loadInterpolator(Resources res, Resources.Theme theme, int id2) throws Resources.NotFoundException {
        try (XmlResourceParser parser = null;){
            parser = res.getAnimation(id2);
            Interpolator interpolator2 = AnimationUtils.createInterpolatorFromXml(res, theme, parser);
            return interpolator2;
        }
    }

    private static Interpolator createInterpolatorFromXml(Resources res, Resources.Theme theme, XmlPullParser parser) throws XmlPullParserException, IOException {
        int type;
        Interpolator interpolator2 = null;
        int depth = parser.getDepth();
        while (((type = parser.next()) != 3 || parser.getDepth() > depth) && type != 1) {
            if (type != 2) continue;
            AttributeSet attrs = Xml.asAttributeSet(parser);
            String name = parser.getName();
            if (name.equals("linearInterpolator")) {
                interpolator2 = new LinearInterpolator();
                continue;
            }
            if (name.equals("accelerateInterpolator")) {
                interpolator2 = new AccelerateInterpolator(res, theme, attrs);
                continue;
            }
            if (name.equals("decelerateInterpolator")) {
                interpolator2 = new DecelerateInterpolator(res, theme, attrs);
                continue;
            }
            if (name.equals("accelerateDecelerateInterpolator")) {
                interpolator2 = new AccelerateDecelerateInterpolator();
                continue;
            }
            if (name.equals("cycleInterpolator")) {
                interpolator2 = new CycleInterpolator(res, theme, attrs);
                continue;
            }
            if (name.equals("anticipateInterpolator")) {
                interpolator2 = new AnticipateInterpolator(res, theme, attrs);
                continue;
            }
            if (name.equals("overshootInterpolator")) {
                interpolator2 = new OvershootInterpolator(res, theme, attrs);
                continue;
            }
            if (name.equals("anticipateOvershootInterpolator")) {
                interpolator2 = new AnticipateOvershootInterpolator(res, theme, attrs);
                continue;
            }
            if (name.equals("bounceInterpolator")) {
                interpolator2 = new BounceInterpolator();
                continue;
            }
            if (name.equals("pathInterpolator")) {
                interpolator2 = new PathInterpolator(res, theme, attrs);
                continue;
            }
            throw new RuntimeException("Unknown interpolator name: " + parser.getName());
        }
        return interpolator2;
    }
}

