/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.format.DateFormat;
import android.text.format.DateUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.animation.AlphaAnimation;
import android.widget.CalendarView;
import android.widget.DatePicker;
import android.widget.DatePickerController;
import android.widget.DayPickerView;
import android.widget.LinearLayout;
import android.widget.OnDateChangedListener;
import android.widget.TextView;
import android.widget.YearPickerView;
import com.android.internal.R;
import com.android.internal.widget.AccessibleDateAnimator;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Locale;

class DatePickerCalendarDelegate
extends DatePicker.AbstractDatePickerDelegate
implements View.OnClickListener,
DatePickerController {
    private static final int USE_LOCALE = 0;
    private static final int UNINITIALIZED = -1;
    private static final int MONTH_AND_DAY_VIEW = 0;
    private static final int YEAR_VIEW = 1;
    private static final int DEFAULT_START_YEAR = 1900;
    private static final int DEFAULT_END_YEAR = 2100;
    private static final int ANIMATION_DURATION = 300;
    private static final int MONTH_INDEX = 0;
    private static final int DAY_INDEX = 1;
    private static final int YEAR_INDEX = 2;
    private SimpleDateFormat mYearFormat = new SimpleDateFormat("y", Locale.getDefault());
    private SimpleDateFormat mDayFormat = new SimpleDateFormat("d", Locale.getDefault());
    private TextView mDayOfWeekView;
    private LinearLayout mMonthDayYearLayout;
    private LinearLayout mMonthAndDayLayout;
    private TextView mHeaderMonthTextView;
    private TextView mHeaderDayOfMonthTextView;
    private TextView mHeaderYearTextView;
    private DayPickerView mDayPickerView;
    private YearPickerView mYearPickerView;
    private boolean mIsEnabled = true;
    private String mDayPickerDescription;
    private String mSelectDay;
    private String mYearPickerDescription;
    private String mSelectYear;
    private AccessibleDateAnimator mAnimator;
    private DatePicker.OnDateChangedListener mDateChangedListener;
    private int mCurrentView = -1;
    private Calendar mCurrentDate;
    private Calendar mTempDate;
    private Calendar mMinDate;
    private Calendar mMaxDate;
    private int mFirstDayOfWeek = 0;
    private HashSet<OnDateChangedListener> mListeners = new HashSet();

    public DatePickerCalendarDelegate(DatePicker delegator, Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(delegator, context);
        Locale locale = Locale.getDefault();
        this.mMinDate = this.getCalendarForLocale(this.mMinDate, locale);
        this.mMaxDate = this.getCalendarForLocale(this.mMaxDate, locale);
        this.mTempDate = this.getCalendarForLocale(this.mMaxDate, locale);
        this.mCurrentDate = this.getCalendarForLocale(this.mCurrentDate, locale);
        this.mMinDate.set(1900, 1, 1);
        this.mMaxDate.set(2100, 12, 31);
        Resources res = this.mDelegator.getResources();
        TypedArray a = this.mContext.obtainStyledAttributes(attrs, R.styleable.DatePicker, defStyleAttr, defStyleRes);
        LayoutInflater inflater = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
        int layoutResourceId = a.getResourceId(17, 17367105);
        View mainView = inflater.inflate(layoutResourceId, null);
        this.mDelegator.addView(mainView);
        this.mDayOfWeekView = (TextView)mainView.findViewById(16909033);
        LinearLayout dateLayout = (LinearLayout)mainView.findViewById(16909032);
        this.mMonthDayYearLayout = (LinearLayout)mainView.findViewById(16909034);
        this.mMonthAndDayLayout = (LinearLayout)mainView.findViewById(16909035);
        this.mMonthAndDayLayout.setOnClickListener(this);
        this.mHeaderMonthTextView = (TextView)mainView.findViewById(16909036);
        this.mHeaderDayOfMonthTextView = (TextView)mainView.findViewById(16909037);
        this.mHeaderYearTextView = (TextView)mainView.findViewById(16909038);
        this.mHeaderYearTextView.setOnClickListener(this);
        int defaultHighlightColor = this.mHeaderYearTextView.getHighlightColor();
        int dayOfWeekTextAppearanceResId = a.getResourceId(9, -1);
        if (dayOfWeekTextAppearanceResId != -1) {
            this.mDayOfWeekView.setTextAppearance(context, dayOfWeekTextAppearanceResId);
        }
        this.mDayOfWeekView.setBackground(a.getDrawable(8));
        dateLayout.setBackground(a.getDrawable(0));
        int headerSelectedTextColor = a.getColor(20, defaultHighlightColor);
        int monthTextAppearanceResId = a.getResourceId(10, -1);
        if (monthTextAppearanceResId != -1) {
            this.mHeaderMonthTextView.setTextAppearance(context, monthTextAppearanceResId);
        }
        this.mHeaderMonthTextView.setTextColor(ColorStateList.addFirstIfMissing(this.mHeaderMonthTextView.getTextColors(), 0x10100A1, headerSelectedTextColor));
        int dayOfMonthTextAppearanceResId = a.getResourceId(11, -1);
        if (dayOfMonthTextAppearanceResId != -1) {
            this.mHeaderDayOfMonthTextView.setTextAppearance(context, dayOfMonthTextAppearanceResId);
        }
        this.mHeaderDayOfMonthTextView.setTextColor(ColorStateList.addFirstIfMissing(this.mHeaderDayOfMonthTextView.getTextColors(), 0x10100A1, headerSelectedTextColor));
        int yearTextAppearanceResId = a.getResourceId(12, -1);
        if (yearTextAppearanceResId != -1) {
            this.mHeaderYearTextView.setTextAppearance(context, yearTextAppearanceResId);
        }
        this.mHeaderYearTextView.setTextColor(ColorStateList.addFirstIfMissing(this.mHeaderYearTextView.getTextColors(), 0x10100A1, headerSelectedTextColor));
        this.mDayPickerView = new DayPickerView(this.mContext, this);
        this.mYearPickerView = new YearPickerView(this.mContext);
        this.mYearPickerView.init(this);
        int yearSelectedCircleColor = a.getColor(14, defaultHighlightColor);
        this.mYearPickerView.setYearSelectedCircleColor(yearSelectedCircleColor);
        ColorStateList calendarTextColor = a.getColorStateList(15);
        int calendarSelectedTextColor = a.getColor(18, defaultHighlightColor);
        this.mDayPickerView.setCalendarTextColor(ColorStateList.addFirstIfMissing(calendarTextColor, 0x10100A1, calendarSelectedTextColor));
        this.mDayPickerDescription = res.getString(17040998);
        this.mSelectDay = res.getString(17041000);
        this.mYearPickerDescription = res.getString(17040999);
        this.mSelectYear = res.getString(17041001);
        this.mAnimator = (AccessibleDateAnimator)mainView.findViewById(16909039);
        this.mAnimator.addView(this.mDayPickerView);
        this.mAnimator.addView(this.mYearPickerView);
        this.mAnimator.setDateMillis(this.mCurrentDate.getTimeInMillis());
        AlphaAnimation animation = new AlphaAnimation(0.0f, 1.0f);
        animation.setDuration(300L);
        this.mAnimator.setInAnimation(animation);
        AlphaAnimation animation2 = new AlphaAnimation(1.0f, 0.0f);
        animation2.setDuration(300L);
        this.mAnimator.setOutAnimation(animation2);
        this.updateDisplay(false);
        this.setCurrentView(0);
    }

    private Calendar getCalendarForLocale(Calendar oldCalendar, Locale locale) {
        if (oldCalendar == null) {
            return Calendar.getInstance(locale);
        }
        long currentTimeMillis = oldCalendar.getTimeInMillis();
        Calendar newCalendar = Calendar.getInstance(locale);
        newCalendar.setTimeInMillis(currentTimeMillis);
        return newCalendar;
    }

    private int[] getMonthDayYearIndexes(String pattern) {
        int[] result = new int[3];
        String filteredPattern = pattern.replaceAll("'.*?'", "");
        int dayIndex = filteredPattern.indexOf(100);
        int monthMIndex = filteredPattern.indexOf("M");
        int monthIndex = monthMIndex != -1 ? monthMIndex : filteredPattern.indexOf("L");
        int yearIndex = filteredPattern.indexOf("y");
        if (yearIndex < monthIndex) {
            result[2] = 0;
            if (monthIndex < dayIndex) {
                result[0] = 1;
                result[1] = 2;
            } else {
                result[0] = 2;
                result[1] = 1;
            }
        } else {
            result[2] = 2;
            if (monthIndex < dayIndex) {
                result[0] = 0;
                result[1] = 1;
            } else {
                result[0] = 1;
                result[1] = 0;
            }
        }
        return result;
    }

    private void updateDisplay(boolean announce) {
        if (this.mDayOfWeekView != null) {
            this.mDayOfWeekView.setText(this.mCurrentDate.getDisplayName(7, 2, Locale.getDefault()));
        }
        String bestDateTimePattern = DateFormat.getBestDateTimePattern(this.mCurrentLocale, "yMMMd");
        int[] viewIndices = this.getMonthDayYearIndexes(bestDateTimePattern);
        this.mMonthDayYearLayout.removeAllViews();
        if (viewIndices[2] == 0) {
            this.mMonthDayYearLayout.addView(this.mHeaderYearTextView);
            this.mMonthDayYearLayout.addView(this.mMonthAndDayLayout);
        } else {
            this.mMonthDayYearLayout.addView(this.mMonthAndDayLayout);
            this.mMonthDayYearLayout.addView(this.mHeaderYearTextView);
        }
        this.mMonthAndDayLayout.removeAllViews();
        if (viewIndices[0] > viewIndices[1]) {
            this.mMonthAndDayLayout.addView(this.mHeaderDayOfMonthTextView);
            this.mMonthAndDayLayout.addView(this.mHeaderMonthTextView);
        } else {
            this.mMonthAndDayLayout.addView(this.mHeaderMonthTextView);
            this.mMonthAndDayLayout.addView(this.mHeaderDayOfMonthTextView);
        }
        this.mHeaderMonthTextView.setText(this.mCurrentDate.getDisplayName(2, 1, Locale.getDefault()).toUpperCase(Locale.getDefault()));
        this.mHeaderDayOfMonthTextView.setText(this.mDayFormat.format(this.mCurrentDate.getTime()));
        this.mHeaderYearTextView.setText(this.mYearFormat.format(this.mCurrentDate.getTime()));
        long millis = this.mCurrentDate.getTimeInMillis();
        this.mAnimator.setDateMillis(millis);
        int flags = 24;
        String monthAndDayText = DateUtils.formatDateTime(this.mContext, millis, flags);
        this.mMonthAndDayLayout.setContentDescription(monthAndDayText);
        if (announce) {
            flags = 20;
            String fullDateText = DateUtils.formatDateTime(this.mContext, millis, flags);
            this.mAnimator.announceForAccessibility(fullDateText);
        }
        this.updatePickers();
    }

    private void setCurrentView(int viewIndex) {
        long millis = this.mCurrentDate.getTimeInMillis();
        switch (viewIndex) {
            case 0: {
                this.mDayPickerView.onDateChanged();
                if (this.mCurrentView != viewIndex) {
                    this.mMonthAndDayLayout.setSelected(true);
                    this.mHeaderYearTextView.setSelected(false);
                    this.mAnimator.setDisplayedChild(0);
                    this.mCurrentView = viewIndex;
                }
                int flags = 16;
                String dayString = DateUtils.formatDateTime(this.mContext, millis, 16);
                this.mAnimator.setContentDescription(this.mDayPickerDescription + ": " + dayString);
                this.mAnimator.announceForAccessibility(this.mSelectDay);
                break;
            }
            case 1: {
                this.mYearPickerView.onDateChanged();
                if (this.mCurrentView != viewIndex) {
                    this.mMonthAndDayLayout.setSelected(false);
                    this.mHeaderYearTextView.setSelected(true);
                    this.mAnimator.setDisplayedChild(1);
                    this.mCurrentView = viewIndex;
                }
                String yearString = this.mYearFormat.format(millis);
                this.mAnimator.setContentDescription(this.mYearPickerDescription + ": " + yearString);
                this.mAnimator.announceForAccessibility(this.mSelectYear);
            }
        }
    }

    @Override
    public void init(int year, int monthOfYear, int dayOfMonth, DatePicker.OnDateChangedListener callBack) {
        this.mDateChangedListener = callBack;
        this.mCurrentDate.set(1, year);
        this.mCurrentDate.set(2, monthOfYear);
        this.mCurrentDate.set(5, dayOfMonth);
        this.updateDisplay(false);
    }

    @Override
    public void updateDate(int year, int month, int dayOfMonth) {
        this.mCurrentDate.set(1, year);
        this.mCurrentDate.set(2, month);
        this.mCurrentDate.set(5, dayOfMonth);
        if (this.mDateChangedListener != null) {
            this.mDateChangedListener.onDateChanged(this.mDelegator, year, month, dayOfMonth);
        }
        this.updateDisplay(false);
    }

    @Override
    public int getYear() {
        return this.mCurrentDate.get(1);
    }

    @Override
    public int getMonth() {
        return this.mCurrentDate.get(2);
    }

    @Override
    public int getDayOfMonth() {
        return this.mCurrentDate.get(5);
    }

    @Override
    public void setMinDate(long minDate) {
        this.mTempDate.setTimeInMillis(minDate);
        if (this.mTempDate.get(1) == this.mMinDate.get(1) && this.mTempDate.get(6) != this.mMinDate.get(6)) {
            return;
        }
        if (this.mCurrentDate.before(this.mTempDate)) {
            this.mCurrentDate.setTimeInMillis(minDate);
            this.updatePickers();
            this.updateDisplay(false);
        }
        this.mMinDate.setTimeInMillis(minDate);
        this.mDayPickerView.goTo(this.getSelectedDay(), false, true, true);
    }

    @Override
    public Calendar getMinDate() {
        return this.mMinDate;
    }

    @Override
    public void setMaxDate(long maxDate) {
        this.mTempDate.setTimeInMillis(maxDate);
        if (this.mTempDate.get(1) == this.mMaxDate.get(1) && this.mTempDate.get(6) != this.mMaxDate.get(6)) {
            return;
        }
        if (this.mCurrentDate.after(this.mTempDate)) {
            this.mCurrentDate.setTimeInMillis(maxDate);
            this.updatePickers();
            this.updateDisplay(false);
        }
        this.mMaxDate.setTimeInMillis(maxDate);
        this.mDayPickerView.goTo(this.getSelectedDay(), false, true, true);
    }

    @Override
    public Calendar getMaxDate() {
        return this.mMaxDate;
    }

    @Override
    public void setFirstDayOfWeek(int firstDayOfWeek) {
        this.mFirstDayOfWeek = firstDayOfWeek;
    }

    @Override
    public int getFirstDayOfWeek() {
        if (this.mFirstDayOfWeek != 0) {
            return this.mFirstDayOfWeek;
        }
        return this.mCurrentDate.getFirstDayOfWeek();
    }

    @Override
    public int getMinYear() {
        return this.mMinDate.get(1);
    }

    @Override
    public int getMaxYear() {
        return this.mMaxDate.get(1);
    }

    @Override
    public int getMinMonth() {
        return this.mMinDate.get(2);
    }

    @Override
    public int getMaxMonth() {
        return this.mMaxDate.get(2);
    }

    @Override
    public int getMinDay() {
        return this.mMinDate.get(5);
    }

    @Override
    public int getMaxDay() {
        return this.mMaxDate.get(5);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.mMonthAndDayLayout.setEnabled(enabled);
        this.mHeaderYearTextView.setEnabled(enabled);
        this.mAnimator.setEnabled(enabled);
        this.mIsEnabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.mIsEnabled;
    }

    @Override
    public CalendarView getCalendarView() {
        throw new UnsupportedOperationException("CalendarView does not exists for the new DatePicker");
    }

    @Override
    public void setCalendarViewShown(boolean shown) {
    }

    @Override
    public boolean getCalendarViewShown() {
        return false;
    }

    @Override
    public void setSpinnersShown(boolean shown) {
    }

    @Override
    public boolean getSpinnersShown() {
        return false;
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        this.mYearFormat = new SimpleDateFormat("y", newConfig.locale);
        this.mDayFormat = new SimpleDateFormat("d", newConfig.locale);
    }

    @Override
    public Parcelable onSaveInstanceState(Parcelable superState) {
        int year = this.mCurrentDate.get(1);
        int month = this.mCurrentDate.get(2);
        int day = this.mCurrentDate.get(5);
        int listPosition = -1;
        int listPositionOffset = -1;
        if (this.mCurrentView == 0) {
            listPosition = this.mDayPickerView.getMostVisiblePosition();
        } else if (this.mCurrentView == 1) {
            listPosition = this.mYearPickerView.getFirstVisiblePosition();
            listPositionOffset = this.mYearPickerView.getFirstPositionOffset();
        }
        return new SavedState(superState, year, month, day, this.mMinDate.getTimeInMillis(), this.mMaxDate.getTimeInMillis(), this.mCurrentView, listPosition, listPositionOffset);
    }

    @Override
    public void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        this.mCurrentDate.set(ss.getSelectedYear(), ss.getSelectedMonth(), ss.getSelectedDay());
        this.mCurrentView = ss.getCurrentView();
        this.mMinDate.setTimeInMillis(ss.getMinDate());
        this.mMaxDate.setTimeInMillis(ss.getMaxDate());
        this.updateDisplay(false);
        this.setCurrentView(this.mCurrentView);
        int listPosition = ss.getListPosition();
        if (listPosition != -1) {
            if (this.mCurrentView == 0) {
                this.mDayPickerView.postSetSelection(listPosition);
            } else if (this.mCurrentView == 1) {
                this.mYearPickerView.postSetSelectionFromTop(listPosition, ss.getListPositionOffset());
            }
        }
    }

    @Override
    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
        this.onPopulateAccessibilityEvent(event);
        return true;
    }

    @Override
    public void onPopulateAccessibilityEvent(AccessibilityEvent event) {
        event.getText().add(this.mCurrentDate.getTime().toString());
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent event) {
        event.setClassName(DatePicker.class.getName());
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        info.setClassName(DatePicker.class.getName());
    }

    @Override
    public void onYearSelected(int year) {
        this.adjustDayInMonthIfNeeded(this.mCurrentDate.get(2), year);
        this.mCurrentDate.set(1, year);
        this.updatePickers();
        this.setCurrentView(0);
        this.updateDisplay(true);
    }

    private void adjustDayInMonthIfNeeded(int month, int year) {
        int daysInMonth;
        int day = this.mCurrentDate.get(5);
        if (day > (daysInMonth = DatePickerCalendarDelegate.getDaysInMonth(month, year))) {
            this.mCurrentDate.set(5, daysInMonth);
        }
    }

    public static int getDaysInMonth(int month, int year) {
        switch (month) {
            case 0: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                return 31;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                return 30;
            }
            case 1: {
                return year % 4 == 0 ? 29 : 28;
            }
        }
        throw new IllegalArgumentException("Invalid Month");
    }

    @Override
    public void onDayOfMonthSelected(int year, int month, int day) {
        this.mCurrentDate.set(1, year);
        this.mCurrentDate.set(2, month);
        this.mCurrentDate.set(5, day);
        this.updatePickers();
        this.updateDisplay(true);
    }

    private void updatePickers() {
        for (OnDateChangedListener listener : this.mListeners) {
            listener.onDateChanged();
        }
    }

    @Override
    public void registerOnDateChangedListener(OnDateChangedListener listener) {
        this.mListeners.add(listener);
    }

    @Override
    public void unregisterOnDateChangedListener(OnDateChangedListener listener) {
        this.mListeners.remove(listener);
    }

    @Override
    public Calendar getSelectedDay() {
        return this.mCurrentDate;
    }

    @Override
    public void tryVibrate() {
        this.mDelegator.performHapticFeedback(5);
    }

    @Override
    public void onClick(View v) {
        this.tryVibrate();
        if (v.getId() == 16909038) {
            this.setCurrentView(1);
        } else if (v.getId() == 16909035) {
            this.setCurrentView(0);
        }
    }

    private static class SavedState
    extends View.BaseSavedState {
        private final int mSelectedYear;
        private final int mSelectedMonth;
        private final int mSelectedDay;
        private final long mMinDate;
        private final long mMaxDate;
        private final int mCurrentView;
        private final int mListPosition;
        private final int mListPositionOffset;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        private SavedState(Parcelable superState, int year, int month, int day, long minDate, long maxDate, int currentView, int listPosition, int listPositionOffset) {
            super(superState);
            this.mSelectedYear = year;
            this.mSelectedMonth = month;
            this.mSelectedDay = day;
            this.mMinDate = minDate;
            this.mMaxDate = maxDate;
            this.mCurrentView = currentView;
            this.mListPosition = listPosition;
            this.mListPositionOffset = listPositionOffset;
        }

        private SavedState(Parcel in) {
            super(in);
            this.mSelectedYear = in.readInt();
            this.mSelectedMonth = in.readInt();
            this.mSelectedDay = in.readInt();
            this.mMinDate = in.readLong();
            this.mMaxDate = in.readLong();
            this.mCurrentView = in.readInt();
            this.mListPosition = in.readInt();
            this.mListPositionOffset = in.readInt();
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.mSelectedYear);
            dest.writeInt(this.mSelectedMonth);
            dest.writeInt(this.mSelectedDay);
            dest.writeLong(this.mMinDate);
            dest.writeLong(this.mMaxDate);
            dest.writeInt(this.mCurrentView);
            dest.writeInt(this.mListPosition);
            dest.writeInt(this.mListPositionOffset);
        }

        public int getSelectedDay() {
            return this.mSelectedDay;
        }

        public int getSelectedMonth() {
            return this.mSelectedMonth;
        }

        public int getSelectedYear() {
            return this.mSelectedYear;
        }

        public long getMinDate() {
            return this.mMinDate;
        }

        public long getMaxDate() {
            return this.mMaxDate;
        }

        public int getCurrentView() {
            return this.mCurrentView;
        }

        public int getListPosition() {
            return this.mListPosition;
        }

        public int getListPositionOffset() {
            return this.mListPositionOffset;
        }
    }
}

