/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.os.Bundle;
import android.text.format.DateFormat;
import android.text.format.DateUtils;
import android.text.format.Time;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import com.android.internal.widget.ExploreByTouchHelper;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;

class SimpleMonthView
extends View {
    private static final String TAG = "SimpleMonthView";
    private static final int DEFAULT_HEIGHT = 32;
    private static final int MIN_HEIGHT = 10;
    private static final int DEFAULT_SELECTED_DAY = -1;
    private static final int DEFAULT_WEEK_START = 1;
    private static final int DEFAULT_NUM_DAYS = 7;
    private static final int DEFAULT_NUM_ROWS = 6;
    private static final int MAX_NUM_ROWS = 6;
    private static final int SELECTED_CIRCLE_ALPHA = 60;
    private static final int DAY_SEPARATOR_WIDTH = 1;
    private final int mMiniDayNumberTextSize;
    private final int mMonthLabelTextSize;
    private final int mMonthDayLabelTextSize;
    private final int mMonthHeaderSize;
    private final int mDaySelectedCircleSize;
    private static float mScale = 0.0f;
    private SimpleDateFormat mDayFormatter = new SimpleDateFormat("EEEEE", Locale.getDefault());
    private int mPadding = 0;
    private String mDayOfWeekTypeface;
    private String mMonthTitleTypeface;
    private Paint mDayNumberPaint;
    private Paint mDayNumberDisabledPaint;
    private Paint mDayNumberSelectedPaint;
    private Paint mMonthTitlePaint;
    private Paint mMonthDayLabelPaint;
    private final Formatter mFormatter;
    private final StringBuilder mStringBuilder;
    private int mMonth;
    private int mYear;
    private int mWidth;
    private int mRowHeight = 32;
    private boolean mHasToday = false;
    private int mSelectedDay = -1;
    private int mToday = -1;
    private int mWeekStart = 1;
    private int mNumDays;
    private int mNumCells = this.mNumDays = 7;
    private int mDayOfWeekStart = 0;
    private int mEnabledDayStart = 1;
    private int mEnabledDayEnd = 31;
    private final Calendar mCalendar = Calendar.getInstance();
    private final Calendar mDayLabelCalendar = Calendar.getInstance();
    private final MonthViewTouchHelper mTouchHelper;
    private int mNumRows = 6;
    private OnDayClickListener mOnDayClickListener;
    private boolean mLockAccessibilityDelegate;
    private int mNormalTextColor;
    private int mDisabledTextColor;
    private int mSelectedDayColor;

    public SimpleMonthView(Context context) {
        this(context, null);
    }

    public SimpleMonthView(Context context, AttributeSet attrs) {
        this(context, attrs, 16843612);
    }

    public SimpleMonthView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs);
        Resources res = context.getResources();
        this.mDayOfWeekTypeface = res.getString(17041008);
        this.mMonthTitleTypeface = res.getString(17041007);
        this.mStringBuilder = new StringBuilder(50);
        this.mFormatter = new Formatter(this.mStringBuilder, Locale.getDefault());
        this.mMiniDayNumberTextSize = res.getDimensionPixelSize(17105031);
        this.mMonthLabelTextSize = res.getDimensionPixelSize(17105032);
        this.mMonthDayLabelTextSize = res.getDimensionPixelSize(17105033);
        this.mMonthHeaderSize = res.getDimensionPixelOffset(17105034);
        this.mDaySelectedCircleSize = res.getDimensionPixelSize(17105035);
        this.mRowHeight = (res.getDimensionPixelOffset(17105036) - this.mMonthHeaderSize) / 6;
        this.mTouchHelper = new MonthViewTouchHelper(this);
        this.setAccessibilityDelegate(this.mTouchHelper);
        this.setImportantForAccessibility(1);
        this.mLockAccessibilityDelegate = true;
        this.initView();
    }

    @Override
    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.mDayFormatter = new SimpleDateFormat("EEEEE", newConfig.locale);
    }

    void setTextColor(ColorStateList colors) {
        Resources res = this.getContext().getResources();
        this.mNormalTextColor = colors.getColorForState(ENABLED_STATE_SET, res.getColor(17170586));
        this.mMonthTitlePaint.setColor(this.mNormalTextColor);
        this.mMonthDayLabelPaint.setColor(this.mNormalTextColor);
        this.mDisabledTextColor = colors.getColorForState(EMPTY_STATE_SET, res.getColor(17170588));
        this.mDayNumberDisabledPaint.setColor(this.mDisabledTextColor);
        this.mSelectedDayColor = colors.getColorForState(ENABLED_SELECTED_STATE_SET, res.getColor(17170450));
        this.mDayNumberSelectedPaint.setColor(this.mSelectedDayColor);
        this.mDayNumberSelectedPaint.setAlpha(60);
    }

    @Override
    public void setAccessibilityDelegate(View.AccessibilityDelegate delegate) {
        if (!this.mLockAccessibilityDelegate) {
            super.setAccessibilityDelegate(delegate);
        }
    }

    public void setOnDayClickListener(OnDayClickListener listener) {
        this.mOnDayClickListener = listener;
    }

    @Override
    public boolean dispatchHoverEvent(MotionEvent event) {
        if (this.mTouchHelper.dispatchHoverEvent(event)) {
            return true;
        }
        return super.dispatchHoverEvent(event);
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 1: {
                int day = this.getDayFromLocation(event.getX(), event.getY());
                if (day < 0) break;
                this.onDayClick(day);
            }
        }
        return true;
    }

    private void initView() {
        this.mMonthTitlePaint = new Paint();
        this.mMonthTitlePaint.setAntiAlias(true);
        this.mMonthTitlePaint.setColor(this.mNormalTextColor);
        this.mMonthTitlePaint.setTextSize(this.mMonthLabelTextSize);
        this.mMonthTitlePaint.setTypeface(Typeface.create(this.mMonthTitleTypeface, 1));
        this.mMonthTitlePaint.setTextAlign(Paint.Align.CENTER);
        this.mMonthTitlePaint.setStyle(Paint.Style.FILL);
        this.mMonthTitlePaint.setFakeBoldText(true);
        this.mMonthDayLabelPaint = new Paint();
        this.mMonthDayLabelPaint.setAntiAlias(true);
        this.mMonthDayLabelPaint.setColor(this.mNormalTextColor);
        this.mMonthDayLabelPaint.setTextSize(this.mMonthDayLabelTextSize);
        this.mMonthDayLabelPaint.setTypeface(Typeface.create(this.mDayOfWeekTypeface, 0));
        this.mMonthDayLabelPaint.setTextAlign(Paint.Align.CENTER);
        this.mMonthDayLabelPaint.setStyle(Paint.Style.FILL);
        this.mMonthDayLabelPaint.setFakeBoldText(true);
        this.mDayNumberSelectedPaint = new Paint();
        this.mDayNumberSelectedPaint.setAntiAlias(true);
        this.mDayNumberSelectedPaint.setColor(this.mSelectedDayColor);
        this.mDayNumberSelectedPaint.setAlpha(60);
        this.mDayNumberSelectedPaint.setTextAlign(Paint.Align.CENTER);
        this.mDayNumberSelectedPaint.setStyle(Paint.Style.FILL);
        this.mDayNumberSelectedPaint.setFakeBoldText(true);
        this.mDayNumberPaint = new Paint();
        this.mDayNumberPaint.setAntiAlias(true);
        this.mDayNumberPaint.setTextSize(this.mMiniDayNumberTextSize);
        this.mDayNumberPaint.setTextAlign(Paint.Align.CENTER);
        this.mDayNumberPaint.setStyle(Paint.Style.FILL);
        this.mDayNumberPaint.setFakeBoldText(false);
        this.mDayNumberDisabledPaint = new Paint();
        this.mDayNumberDisabledPaint.setAntiAlias(true);
        this.mDayNumberDisabledPaint.setColor(this.mDisabledTextColor);
        this.mDayNumberDisabledPaint.setTextSize(this.mMiniDayNumberTextSize);
        this.mDayNumberDisabledPaint.setTextAlign(Paint.Align.CENTER);
        this.mDayNumberDisabledPaint.setStyle(Paint.Style.FILL);
        this.mDayNumberDisabledPaint.setFakeBoldText(false);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        this.drawMonthTitle(canvas);
        this.drawWeekDayLabels(canvas);
        this.drawDays(canvas);
    }

    private static boolean isValidDayOfWeek(int day) {
        return day >= 1 && day <= 7;
    }

    private static boolean isValidMonth(int month) {
        return month >= 0 && month <= 11;
    }

    void setMonthParams(int selectedDay, int month, int year, int weekStart, int enabledDayStart, int enabledDayEnd) {
        if (this.mRowHeight < 10) {
            this.mRowHeight = 10;
        }
        this.mSelectedDay = selectedDay;
        if (SimpleMonthView.isValidMonth(month)) {
            this.mMonth = month;
        }
        this.mYear = year;
        Time today = new Time(Time.getCurrentTimezone());
        today.setToNow();
        this.mHasToday = false;
        this.mToday = -1;
        this.mCalendar.set(2, this.mMonth);
        this.mCalendar.set(1, this.mYear);
        this.mCalendar.set(5, 1);
        this.mDayOfWeekStart = this.mCalendar.get(7);
        this.mWeekStart = SimpleMonthView.isValidDayOfWeek(weekStart) ? weekStart : this.mCalendar.getFirstDayOfWeek();
        if (enabledDayStart > 0 && enabledDayEnd < 32) {
            this.mEnabledDayStart = enabledDayStart;
        }
        if (enabledDayEnd > 0 && enabledDayEnd < 32 && enabledDayEnd >= enabledDayStart) {
            this.mEnabledDayEnd = enabledDayEnd;
        }
        this.mNumCells = SimpleMonthView.getDaysInMonth(this.mMonth, this.mYear);
        for (int i = 0; i < this.mNumCells; ++i) {
            int day = i + 1;
            if (!this.sameDay(day, today)) continue;
            this.mHasToday = true;
            this.mToday = day;
        }
        this.mNumRows = this.calculateNumRows();
        this.mTouchHelper.invalidateRoot();
    }

    private static int getDaysInMonth(int month, int year) {
        switch (month) {
            case 0: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                return 31;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                return 30;
            }
            case 1: {
                return year % 4 == 0 ? 29 : 28;
            }
        }
        throw new IllegalArgumentException("Invalid Month");
    }

    public void reuse() {
        this.mNumRows = 6;
        this.requestLayout();
    }

    private int calculateNumRows() {
        int offset = this.findDayOffset();
        int dividend = (offset + this.mNumCells) / this.mNumDays;
        int remainder = (offset + this.mNumCells) % this.mNumDays;
        return dividend + (remainder > 0 ? 1 : 0);
    }

    private boolean sameDay(int day, Time today) {
        return this.mYear == today.year && this.mMonth == today.month && day == today.monthDay;
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(View.MeasureSpec.getSize(widthMeasureSpec), this.mRowHeight * this.mNumRows + this.mMonthHeaderSize);
    }

    @Override
    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        this.mWidth = w;
        this.mTouchHelper.invalidateRoot();
    }

    private String getMonthAndYearString() {
        int flags = 52;
        this.mStringBuilder.setLength(0);
        long millis = this.mCalendar.getTimeInMillis();
        return DateUtils.formatDateRange(this.getContext(), this.mFormatter, millis, millis, flags, Time.getCurrentTimezone()).toString();
    }

    private void drawMonthTitle(Canvas canvas) {
        float x = (float)(this.mWidth + 2 * this.mPadding) / 2.0f;
        float y = (float)(this.mMonthHeaderSize - this.mMonthDayLabelTextSize) / 2.0f;
        canvas.drawText(this.getMonthAndYearString(), x, y, this.mMonthTitlePaint);
    }

    private void drawWeekDayLabels(Canvas canvas) {
        int y = this.mMonthHeaderSize - this.mMonthDayLabelTextSize / 2;
        int dayWidthHalf = (this.mWidth - this.mPadding * 2) / (this.mNumDays * 2);
        for (int i = 0; i < this.mNumDays; ++i) {
            int calendarDay = (i + this.mWeekStart) % this.mNumDays;
            this.mDayLabelCalendar.set(7, calendarDay);
            String dayLabel = this.mDayFormatter.format(this.mDayLabelCalendar.getTime());
            int x = (2 * i + 1) * dayWidthHalf + this.mPadding;
            canvas.drawText(dayLabel, x, y, this.mMonthDayLabelPaint);
        }
    }

    private void drawDays(Canvas canvas) {
        int y = (this.mRowHeight + this.mMiniDayNumberTextSize) / 2 - 1 + this.mMonthHeaderSize;
        int dayWidthHalf = (this.mWidth - this.mPadding * 2) / (this.mNumDays * 2);
        int j = this.findDayOffset();
        for (int day = 1; day <= this.mNumCells; ++day) {
            int x = (2 * j + 1) * dayWidthHalf + this.mPadding;
            if (this.mSelectedDay == day) {
                canvas.drawCircle(x, y - this.mMiniDayNumberTextSize / 3, this.mDaySelectedCircleSize, this.mDayNumberSelectedPaint);
            }
            if (this.mHasToday && this.mToday == day) {
                this.mDayNumberPaint.setColor(this.mSelectedDayColor);
            } else {
                this.mDayNumberPaint.setColor(this.mNormalTextColor);
            }
            Paint paint = day < this.mEnabledDayStart || day > this.mEnabledDayEnd ? this.mDayNumberDisabledPaint : this.mDayNumberPaint;
            canvas.drawText(String.format("%d", day), x, y, paint);
            if (++j != this.mNumDays) continue;
            j = 0;
            y += this.mRowHeight;
        }
    }

    private int findDayOffset() {
        return (this.mDayOfWeekStart < this.mWeekStart ? this.mDayOfWeekStart + this.mNumDays : this.mDayOfWeekStart) - this.mWeekStart;
    }

    private int getDayFromLocation(float x, float y) {
        int dayStart = this.mPadding;
        if (x < (float)dayStart || x > (float)(this.mWidth - this.mPadding)) {
            return -1;
        }
        int row = (int)(y - (float)this.mMonthHeaderSize) / this.mRowHeight;
        int column = (int)((x - (float)dayStart) * (float)this.mNumDays / (float)(this.mWidth - dayStart - this.mPadding));
        int day = column - this.findDayOffset() + 1;
        if ((day += row * this.mNumDays) < 1 || day > this.mNumCells) {
            return -1;
        }
        return day;
    }

    private void onDayClick(int day) {
        if (this.mOnDayClickListener != null) {
            Calendar date = Calendar.getInstance();
            date.set(this.mYear, this.mMonth, day);
            this.mOnDayClickListener.onDayClick(this, date);
        }
        this.mTouchHelper.sendEventForVirtualView(day, 1);
    }

    Calendar getAccessibilityFocus() {
        int day = this.mTouchHelper.getFocusedVirtualView();
        Calendar date = null;
        if (day >= 0) {
            date = Calendar.getInstance();
            date.set(this.mYear, this.mMonth, day);
        }
        return date;
    }

    @Override
    public void clearAccessibilityFocus() {
        this.mTouchHelper.clearFocusedVirtualView();
    }

    boolean restoreAccessibilityFocus(Calendar day) {
        if (day.get(1) != this.mYear || day.get(2) != this.mMonth || day.get(5) > this.mNumCells) {
            return false;
        }
        this.mTouchHelper.setFocusedVirtualView(day.get(5));
        return true;
    }

    public static interface OnDayClickListener {
        public void onDayClick(SimpleMonthView var1, Calendar var2);
    }

    private class MonthViewTouchHelper
    extends ExploreByTouchHelper {
        private static final String DATE_FORMAT = "dd MMMM yyyy";
        private final Rect mTempRect;
        private final Calendar mTempCalendar;

        public MonthViewTouchHelper(View host) {
            super(host);
            this.mTempRect = new Rect();
            this.mTempCalendar = Calendar.getInstance();
        }

        public void setFocusedVirtualView(int virtualViewId) {
            this.getAccessibilityNodeProvider(SimpleMonthView.this).performAction(virtualViewId, 64, null);
        }

        public void clearFocusedVirtualView() {
            int focusedVirtualView = this.getFocusedVirtualView();
            if (focusedVirtualView != Integer.MIN_VALUE) {
                this.getAccessibilityNodeProvider(SimpleMonthView.this).performAction(focusedVirtualView, 128, null);
            }
        }

        @Override
        protected int getVirtualViewAt(float x, float y) {
            int day = SimpleMonthView.this.getDayFromLocation(x, y);
            if (day >= 0) {
                return day;
            }
            return Integer.MIN_VALUE;
        }

        @Override
        protected void getVisibleVirtualViews(List<Integer> virtualViewIds) {
            for (int day = 1; day <= SimpleMonthView.this.mNumCells; ++day) {
                virtualViewIds.add(day);
            }
        }

        @Override
        protected void onPopulateEventForVirtualView(int virtualViewId, AccessibilityEvent event) {
            event.setContentDescription(this.getItemDescription(virtualViewId));
        }

        @Override
        protected void onPopulateNodeForVirtualView(int virtualViewId, AccessibilityNodeInfo node) {
            this.getItemBounds(virtualViewId, this.mTempRect);
            node.setContentDescription(this.getItemDescription(virtualViewId));
            node.setBoundsInParent(this.mTempRect);
            node.addAction(16);
            if (virtualViewId == SimpleMonthView.this.mSelectedDay) {
                node.setSelected(true);
            }
        }

        @Override
        protected boolean onPerformActionForVirtualView(int virtualViewId, int action, Bundle arguments) {
            switch (action) {
                case 16: {
                    SimpleMonthView.this.onDayClick(virtualViewId);
                    return true;
                }
            }
            return false;
        }

        private void getItemBounds(int day, Rect rect) {
            int offsetX = SimpleMonthView.this.mPadding;
            int offsetY = SimpleMonthView.this.mMonthHeaderSize;
            int cellHeight = SimpleMonthView.this.mRowHeight;
            int cellWidth = (SimpleMonthView.this.mWidth - 2 * SimpleMonthView.this.mPadding) / SimpleMonthView.this.mNumDays;
            int index = day - 1 + SimpleMonthView.this.findDayOffset();
            int row = index / SimpleMonthView.this.mNumDays;
            int column = index % SimpleMonthView.this.mNumDays;
            int x = offsetX + column * cellWidth;
            int y = offsetY + row * cellHeight;
            rect.set(x, y, x + cellWidth, y + cellHeight);
        }

        private CharSequence getItemDescription(int day) {
            this.mTempCalendar.set(SimpleMonthView.this.mYear, SimpleMonthView.this.mMonth, day);
            CharSequence date = DateFormat.format((CharSequence)DATE_FORMAT, this.mTempCalendar.getTimeInMillis());
            if (day == SimpleMonthView.this.mSelectedDay) {
                return SimpleMonthView.this.getContext().getString(17041002, date);
            }
            return date;
        }
    }
}

