/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.ActivityManagerNative;
import android.app.ActivityThread;
import android.app.AppGlobals;
import android.app.usage.UsageStats;
import android.app.usage.UsageStatsManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.LabeledIntent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.UserInfo;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.PatternMatcher;
import android.os.RemoteException;
import android.os.UserHandle;
import android.os.UserManager;
import android.text.TextUtils;
import android.util.Log;
import android.util.Slog;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;
import com.android.internal.content.PackageMonitor;
import com.android.internal.widget.ResolverDrawerLayout;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ResolverActivity
extends Activity
implements AdapterView.OnItemClickListener {
    private static final String TAG = "ResolverActivity";
    private static final boolean DEBUG = false;
    private int mLaunchedFromUid;
    private ResolveListAdapter mAdapter;
    private PackageManager mPm;
    private boolean mSafeForwardingMode;
    private boolean mAlwaysUseOption;
    private boolean mShowExtended;
    private ListView mListView;
    private Button mAlwaysButton;
    private Button mOnceButton;
    private int mIconDpi;
    private int mIconSize;
    private int mMaxColumns;
    private int mLastSelected = -1;
    private boolean mResolvingHome = false;
    private UsageStatsManager mUsm;
    private Map<String, UsageStats> mStats;
    private static final long USAGE_STATS_PERIOD = 1209600000L;
    private boolean mRegistered;
    private final PackageMonitor mPackageMonitor = new PackageMonitor(){

        @Override
        public void onSomePackagesChanged() {
            ResolverActivity.this.mAdapter.handlePackagesChanged();
        }
    };

    private Intent makeMyIntent() {
        Intent intent = new Intent(this.getIntent());
        intent.setComponent(null);
        intent.setFlags(intent.getFlags() & 0xFF7FFFFF);
        return intent;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        Intent intent = this.makeMyIntent();
        Set<String> categories = intent.getCategories();
        if ("android.intent.action.MAIN".equals(intent.getAction()) && categories != null && categories.size() == 1 && categories.contains("android.intent.category.HOME")) {
            this.mResolvingHome = true;
        }
        this.setSafeForwardingMode(true);
        this.onCreate(savedInstanceState, intent, null, 0, null, null, true);
    }

    protected void onCreate(Bundle savedInstanceState, Intent intent, CharSequence title, Intent[] initialIntents, List<ResolveInfo> rList, boolean alwaysUseOption) {
        this.onCreate(savedInstanceState, intent, title, 0, initialIntents, rList, alwaysUseOption);
    }

    protected void onCreate(Bundle savedInstanceState, Intent intent, CharSequence title, int defaultTitleRes, Intent[] initialIntents, List<ResolveInfo> rList, boolean alwaysUseOption) {
        ResolverDrawerLayout rdl;
        boolean useHeader;
        int layoutId;
        this.setTheme(16974991);
        super.onCreate(savedInstanceState);
        try {
            this.mLaunchedFromUid = ActivityManagerNative.getDefault().getLaunchedFromUid(this.getActivityToken());
        }
        catch (RemoteException e) {
            this.mLaunchedFromUid = -1;
        }
        this.mPm = this.getPackageManager();
        this.mUsm = (UsageStatsManager)this.getSystemService("usagestats");
        long sinceTime = System.currentTimeMillis() - 1209600000L;
        this.mStats = this.mUsm.queryAndAggregateUsageStats(sinceTime, System.currentTimeMillis());
        Log.d(TAG, "sinceTime=" + sinceTime);
        this.mMaxColumns = this.getResources().getInteger(17694829);
        this.mPackageMonitor.register(this, this.getMainLooper(), false);
        this.mRegistered = true;
        ActivityManager am = (ActivityManager)this.getSystemService("activity");
        this.mIconDpi = am.getLauncherLargeIconDensity();
        this.mIconSize = am.getLauncherLargeIconSize();
        this.mAdapter = new ResolveListAdapter(this, intent, initialIntents, rList, this.mLaunchedFromUid, alwaysUseOption);
        if (this.mAdapter.hasFilteredItem()) {
            layoutId = 17367215;
            alwaysUseOption = false;
            useHeader = true;
        } else {
            useHeader = false;
            layoutId = 17367214;
        }
        this.mAlwaysUseOption = alwaysUseOption;
        int count = this.mAdapter.mList.size();
        if (this.mLaunchedFromUid < 0 || UserHandle.isIsolated(this.mLaunchedFromUid)) {
            this.finish();
            return;
        }
        if (count > 1) {
            this.setContentView(layoutId);
            this.mListView = (ListView)this.findViewById(16909156);
            this.mListView.setAdapter(this.mAdapter);
            this.mListView.setOnItemClickListener(this);
            this.mListView.setOnItemLongClickListener(new ItemLongClickListener());
            if (alwaysUseOption) {
                this.mListView.setChoiceMode(1);
            }
            if (useHeader) {
                this.mListView.addHeaderView(LayoutInflater.from(this).inflate(17367213, (ViewGroup)this.mListView, false));
            }
        } else {
            if (count == 1) {
                this.safelyStartActivity(this.mAdapter.intentForPosition(0, false));
                this.mPackageMonitor.unregister();
                this.mRegistered = false;
                this.finish();
                return;
            }
            this.setContentView(17367214);
            TextView empty = (TextView)this.findViewById(16908292);
            empty.setVisibility(0);
            this.mListView = (ListView)this.findViewById(16909156);
            this.mListView.setVisibility(8);
        }
        if ((rdl = (ResolverDrawerLayout)this.findViewById(16908996)) != null) {
            rdl.setOnClickOutsideListener(new View.OnClickListener(){

                @Override
                public void onClick(View v) {
                    ResolverActivity.this.finish();
                }
            });
        }
        if (title == null) {
            title = this.getTitleForAction(intent.getAction(), defaultTitleRes);
        }
        if (!TextUtils.isEmpty(title)) {
            TextView titleView = (TextView)this.findViewById(16908310);
            if (titleView != null) {
                titleView.setText(title);
            }
            this.setTitle(title);
        }
        ImageView iconView = (ImageView)this.findViewById(16908294);
        DisplayResolveInfo iconInfo = this.mAdapter.getFilteredItem();
        if (iconView != null && iconInfo != null) {
            new LoadIconIntoViewTask(iconView).execute(iconInfo);
        }
        if (alwaysUseOption || this.mAdapter.hasFilteredItem()) {
            ViewGroup buttonLayout = (ViewGroup)this.findViewById(16909010);
            if (buttonLayout != null) {
                buttonLayout.setVisibility(0);
                this.mAlwaysButton = (Button)buttonLayout.findViewById(16909158);
                this.mOnceButton = (Button)buttonLayout.findViewById(16909157);
            } else {
                this.mAlwaysUseOption = false;
            }
        }
        if (this.mAdapter.hasFilteredItem()) {
            this.setAlwaysButtonEnabled(true, this.mAdapter.getFilteredPosition(), false);
            this.mOnceButton.setEnabled(true);
        }
    }

    public void setSafeForwardingMode(boolean safeForwarding) {
        this.mSafeForwardingMode = safeForwarding;
    }

    protected CharSequence getTitleForAction(String action, int defaultTitleRes) {
        ActionTitle title = this.mResolvingHome ? ActionTitle.HOME : ActionTitle.forAction(action);
        boolean named = this.mAdapter.hasFilteredItem();
        if (title == ActionTitle.DEFAULT && defaultTitleRes != 0) {
            return this.getString(defaultTitleRes);
        }
        return named ? this.getString(title.namedTitleRes, this.mAdapter.getFilteredItem().displayLabel) : this.getString(title.titleRes);
    }

    void dismiss() {
        if (!this.isFinishing()) {
            this.finish();
        }
    }

    Drawable getIcon(Resources res, int resId) {
        Drawable result;
        try {
            result = res.getDrawableForDensity(resId, this.mIconDpi);
        }
        catch (Resources.NotFoundException e) {
            result = null;
        }
        return result;
    }

    Drawable loadIconForResolveInfo(ResolveInfo ri) {
        try {
            Drawable dr;
            if (ri.resolvePackageName != null && ri.icon != 0 && (dr = this.getIcon(this.mPm.getResourcesForApplication(ri.resolvePackageName), ri.icon)) != null) {
                return dr;
            }
            int iconRes = ri.getIconResource();
            if (iconRes != 0 && (dr = this.getIcon(this.mPm.getResourcesForApplication(ri.activityInfo.packageName), iconRes)) != null) {
                return dr;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e(TAG, "Couldn't find resources for package", e);
        }
        return ri.loadIcon(this.mPm);
    }

    @Override
    protected void onRestart() {
        super.onRestart();
        if (!this.mRegistered) {
            this.mPackageMonitor.register(this, this.getMainLooper(), false);
            this.mRegistered = true;
        }
        this.mAdapter.handlePackagesChanged();
    }

    @Override
    protected void onStop() {
        super.onStop();
        if (this.mRegistered) {
            this.mPackageMonitor.unregister();
            this.mRegistered = false;
        }
        if ((this.getIntent().getFlags() & 0x10000000) != 0 && !this.isChangingConfigurations()) {
            this.finish();
        }
    }

    @Override
    protected void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        if (this.mAlwaysUseOption) {
            int checkedPos = this.mListView.getCheckedItemPosition();
            boolean hasValidSelection = checkedPos != -1;
            this.mLastSelected = checkedPos;
            this.setAlwaysButtonEnabled(hasValidSelection, checkedPos, true);
            this.mOnceButton.setEnabled(hasValidSelection);
            if (hasValidSelection) {
                this.mListView.setSelection(checkedPos);
            }
        }
    }

    @Override
    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        boolean hasValidSelection;
        if ((position -= this.mListView.getHeaderViewsCount()) < 0) {
            return;
        }
        ResolveInfo resolveInfo = this.mAdapter.resolveInfoForPosition(position, true);
        if (this.mResolvingHome && this.hasManagedProfile() && !this.supportsManagedProfiles(resolveInfo)) {
            Toast.makeText((Context)this, String.format(this.getResources().getString(17040823), resolveInfo.activityInfo.loadLabel(this.getPackageManager()).toString()), 1).show();
            return;
        }
        int checkedPos = this.mListView.getCheckedItemPosition();
        boolean bl = hasValidSelection = checkedPos != -1;
        if (this.mAlwaysUseOption && (!hasValidSelection || this.mLastSelected != checkedPos)) {
            this.setAlwaysButtonEnabled(hasValidSelection, checkedPos, true);
            this.mOnceButton.setEnabled(hasValidSelection);
            if (hasValidSelection) {
                this.mListView.smoothScrollToPosition(checkedPos);
            }
            this.mLastSelected = checkedPos;
        } else {
            this.startSelected(position, false, true);
        }
    }

    private boolean hasManagedProfile() {
        UserManager userManager = (UserManager)this.getSystemService("user");
        if (userManager == null) {
            return false;
        }
        try {
            List<UserInfo> profiles = userManager.getProfiles(this.getUserId());
            for (UserInfo userInfo : profiles) {
                if (userInfo == null || !userInfo.isManagedProfile()) continue;
                return true;
            }
        }
        catch (SecurityException e) {
            return false;
        }
        return false;
    }

    private boolean supportsManagedProfiles(ResolveInfo resolveInfo) {
        try {
            ApplicationInfo appInfo = this.getPackageManager().getApplicationInfo(resolveInfo.activityInfo.packageName, 0);
            return this.versionNumberAtLeastL(appInfo.targetSdkVersion);
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }

    private boolean versionNumberAtLeastL(int versionNumber) {
        return versionNumber >= 21;
    }

    private void setAlwaysButtonEnabled(boolean hasValidSelection, int checkedPos, boolean filtered) {
        boolean enabled = false;
        if (hasValidSelection) {
            ResolveInfo ri = this.mAdapter.resolveInfoForPosition(checkedPos, filtered);
            if (ri.targetUserId == -2) {
                enabled = true;
            }
        }
        this.mAlwaysButton.setEnabled(enabled);
    }

    public void onButtonClick(View v) {
        int id2 = v.getId();
        this.startSelected(this.mAlwaysUseOption ? this.mListView.getCheckedItemPosition() : this.mAdapter.getFilteredPosition(), id2 == 16909158, this.mAlwaysUseOption);
        this.dismiss();
    }

    void startSelected(int which, boolean always, boolean filtered) {
        if (this.isFinishing()) {
            return;
        }
        ResolveInfo ri = this.mAdapter.resolveInfoForPosition(which, filtered);
        Intent intent = this.mAdapter.intentForPosition(which, filtered);
        this.onIntentSelected(ri, intent, always);
        this.finish();
    }

    public Intent getReplacementIntent(String packageName, Intent defIntent) {
        return defIntent;
    }

    protected void onIntentSelected(ResolveInfo ri, Intent intent, boolean alwaysCheck) {
        if ((this.mAlwaysUseOption || this.mAdapter.hasFilteredItem()) && this.mAdapter.mOrigResolveList != null) {
            String mimeType;
            Set<String> categories;
            IntentFilter filter = new IntentFilter();
            if (intent.getAction() != null) {
                filter.addAction(intent.getAction());
            }
            if ((categories = intent.getCategories()) != null) {
                for (String cat : categories) {
                    filter.addCategory(cat);
                }
            }
            filter.addCategory("android.intent.category.DEFAULT");
            int cat = ri.match & 0xFFF0000;
            Uri data = intent.getData();
            if (cat == 0x600000 && (mimeType = intent.resolveType(this)) != null) {
                try {
                    filter.addDataType(mimeType);
                }
                catch (IntentFilter.MalformedMimeTypeException e) {
                    Log.w(TAG, e);
                    filter = null;
                }
            }
            if (data != null && data.getScheme() != null && (cat != 0x600000 || !"file".equals(data.getScheme()) && !"content".equals(data.getScheme()))) {
                Iterator<IntentFilter.AuthorityEntry> aIt;
                filter.addDataScheme(data.getScheme());
                Iterator<PatternMatcher> pIt = ri.filter.schemeSpecificPartsIterator();
                if (pIt != null) {
                    String ssp = data.getSchemeSpecificPart();
                    while (ssp != null && pIt.hasNext()) {
                        PatternMatcher p = pIt.next();
                        if (!p.match(ssp)) continue;
                        filter.addDataSchemeSpecificPart(p.getPath(), p.getType());
                        break;
                    }
                }
                if ((aIt = ri.filter.authoritiesIterator()) != null) {
                    while (aIt.hasNext()) {
                        IntentFilter.AuthorityEntry a = aIt.next();
                        if (a.match(data) < 0) continue;
                        int port = a.getPort();
                        filter.addDataAuthority(a.getHost(), port >= 0 ? Integer.toString(port) : null);
                        break;
                    }
                }
                if ((pIt = ri.filter.pathsIterator()) != null) {
                    String path = data.getPath();
                    while (path != null && pIt.hasNext()) {
                        PatternMatcher p = pIt.next();
                        if (!p.match(path)) continue;
                        filter.addDataPath(p.getPath(), p.getType());
                        break;
                    }
                }
            }
            if (filter != null) {
                int N = this.mAdapter.mOrigResolveList.size();
                ComponentName[] set = new ComponentName[N];
                int bestMatch = 0;
                for (int i = 0; i < N; ++i) {
                    ResolveInfo r = this.mAdapter.mOrigResolveList.get(i);
                    set[i] = new ComponentName(r.activityInfo.packageName, r.activityInfo.name);
                    if (r.match <= bestMatch) continue;
                    bestMatch = r.match;
                }
                if (alwaysCheck) {
                    this.getPackageManager().addPreferredActivity(filter, bestMatch, set, intent.getComponent());
                } else {
                    try {
                        AppGlobals.getPackageManager().setLastChosenActivity(intent, intent.resolveTypeIfNeeded(this.getContentResolver()), 65536, filter, bestMatch, intent.getComponent());
                    }
                    catch (RemoteException re) {
                        Log.d(TAG, "Error calling setLastChosenActivity\n" + re);
                    }
                }
            }
        }
        if (intent != null) {
            this.safelyStartActivity(intent);
        }
    }

    public void safelyStartActivity(Intent intent) {
        if (!this.mSafeForwardingMode) {
            this.startActivity(intent);
            return;
        }
        try {
            this.startActivityAsCaller(intent, null, -10000);
        }
        catch (RuntimeException e) {
            String launchedFromPackage;
            try {
                launchedFromPackage = ActivityManagerNative.getDefault().getLaunchedFromPackage(this.getActivityToken());
            }
            catch (RemoteException e2) {
                launchedFromPackage = "??";
            }
            Slog.wtf(TAG, "Unable to launch as uid " + this.mLaunchedFromUid + " package " + launchedFromPackage + ", while running in " + ActivityThread.currentProcessName(), e);
        }
    }

    void showAppDetails(ResolveInfo ri) {
        Intent in = new Intent().setAction("android.settings.APPLICATION_DETAILS_SETTINGS").setData(Uri.fromParts("package", ri.activityInfo.packageName, null)).addFlags(524288);
        this.startActivity(in);
    }

    class ResolverComparator
    implements Comparator<ResolveInfo> {
        private final Collator mCollator;

        public ResolverComparator(Context context) {
            this.mCollator = Collator.getInstance(context.getResources().getConfiguration().locale);
        }

        @Override
        public int compare(ResolveInfo lhs, ResolveInfo rhs) {
            CharSequence sb;
            long timeDiff;
            if (lhs.targetUserId != -2) {
                return 1;
            }
            if (ResolverActivity.this.mStats != null && (timeDiff = this.getPackageTimeSpent(rhs.activityInfo.packageName) - this.getPackageTimeSpent(lhs.activityInfo.packageName)) != 0L) {
                return timeDiff > 0L ? 1 : -1;
            }
            CharSequence sa = lhs.loadLabel(ResolverActivity.this.mPm);
            if (sa == null) {
                sa = lhs.activityInfo.name;
            }
            if ((sb = rhs.loadLabel(ResolverActivity.this.mPm)) == null) {
                sb = rhs.activityInfo.name;
            }
            return this.mCollator.compare(sa.toString(), sb.toString());
        }

        private long getPackageTimeSpent(String packageName) {
            UsageStats stats;
            if (ResolverActivity.this.mStats != null && (stats = (UsageStats)ResolverActivity.this.mStats.get(packageName)) != null) {
                return stats.getTotalTimeInForeground();
            }
            return 0L;
        }
    }

    class LoadIconIntoViewTask
    extends AsyncTask<DisplayResolveInfo, Void, DisplayResolveInfo> {
        final ImageView mTargetView;

        public LoadIconIntoViewTask(ImageView target) {
            this.mTargetView = target;
        }

        protected DisplayResolveInfo doInBackground(DisplayResolveInfo ... params) {
            DisplayResolveInfo info = params[0];
            if (info.displayIcon == null) {
                info.displayIcon = ResolverActivity.this.loadIconForResolveInfo(info.ri);
            }
            return info;
        }

        @Override
        protected void onPostExecute(DisplayResolveInfo info) {
            this.mTargetView.setImageDrawable(info.displayIcon);
        }
    }

    class LoadIconTask
    extends AsyncTask<DisplayResolveInfo, Void, DisplayResolveInfo> {
        LoadIconTask() {
        }

        protected DisplayResolveInfo doInBackground(DisplayResolveInfo ... params) {
            DisplayResolveInfo info = params[0];
            if (info.displayIcon == null) {
                info.displayIcon = ResolverActivity.this.loadIconForResolveInfo(info.ri);
            }
            return info;
        }

        @Override
        protected void onPostExecute(DisplayResolveInfo info) {
            ResolverActivity.this.mAdapter.notifyDataSetChanged();
        }
    }

    class ItemLongClickListener
    implements AdapterView.OnItemLongClickListener {
        ItemLongClickListener() {
        }

        @Override
        public boolean onItemLongClick(AdapterView<?> parent, View view, int position, long id2) {
            if ((position -= ResolverActivity.this.mListView.getHeaderViewsCount()) < 0) {
                return false;
            }
            ResolveInfo ri = ResolverActivity.this.mAdapter.resolveInfoForPosition(position, true);
            ResolverActivity.this.showAppDetails(ri);
            return true;
        }
    }

    static class ViewHolder {
        public TextView text;
        public TextView text2;
        public ImageView icon;

        public ViewHolder(View view) {
            this.text = (TextView)view.findViewById(16908308);
            this.text2 = (TextView)view.findViewById(16908309);
            this.icon = (ImageView)view.findViewById(16908294);
        }
    }

    private final class ResolveListAdapter
    extends BaseAdapter {
        private final Intent[] mInitialIntents;
        private final List<ResolveInfo> mBaseResolveList;
        private ResolveInfo mLastChosen;
        private final Intent mIntent;
        private final int mLaunchedFromUid;
        private final LayoutInflater mInflater;
        List<DisplayResolveInfo> mList;
        List<ResolveInfo> mOrigResolveList;
        private int mLastChosenPosition = -1;
        private boolean mFilterLastUsed;

        public ResolveListAdapter(Context context, Intent intent, Intent[] initialIntents, List<ResolveInfo> rList, int launchedFromUid, boolean filterLastUsed) {
            this.mIntent = new Intent(intent);
            this.mInitialIntents = initialIntents;
            this.mBaseResolveList = rList;
            this.mLaunchedFromUid = launchedFromUid;
            this.mInflater = LayoutInflater.from(context);
            this.mList = new ArrayList<DisplayResolveInfo>();
            this.mFilterLastUsed = filterLastUsed;
            this.rebuildList();
        }

        public void handlePackagesChanged() {
            int oldItemCount = this.getCount();
            this.rebuildList();
            this.notifyDataSetChanged();
            int newItemCount = this.getCount();
            if (newItemCount == 0) {
                ResolverActivity.this.finish();
            }
        }

        public DisplayResolveInfo getFilteredItem() {
            if (this.mFilterLastUsed && this.mLastChosenPosition >= 0) {
                return this.mList.get(this.mLastChosenPosition);
            }
            return null;
        }

        public int getFilteredPosition() {
            if (this.mFilterLastUsed && this.mLastChosenPosition >= 0) {
                return this.mLastChosenPosition;
            }
            return -1;
        }

        public boolean hasFilteredItem() {
            return this.mFilterLastUsed && this.mLastChosenPosition >= 0;
        }

        private void rebuildList() {
            int N;
            List<ResolveInfo> currentResolveList;
            try {
                this.mLastChosen = AppGlobals.getPackageManager().getLastChosenActivity(this.mIntent, this.mIntent.resolveTypeIfNeeded(ResolverActivity.this.getContentResolver()), 65536);
            }
            catch (RemoteException re) {
                Log.d(ResolverActivity.TAG, "Error calling setLastChosenActivity\n" + re);
            }
            this.mList.clear();
            if (this.mBaseResolveList != null) {
                this.mOrigResolveList = this.mBaseResolveList;
                currentResolveList = this.mOrigResolveList;
            } else {
                this.mOrigResolveList = ResolverActivity.this.mPm.queryIntentActivities(this.mIntent, 0x10000 | (this.mFilterLastUsed ? 64 : 0));
                currentResolveList = this.mOrigResolveList;
                if (currentResolveList != null) {
                    for (int i = currentResolveList.size() - 1; i >= 0; --i) {
                        ActivityInfo ai = currentResolveList.get((int)i).activityInfo;
                        int granted = ActivityManager.checkComponentPermission(ai.permission, this.mLaunchedFromUid, ai.applicationInfo.uid, ai.exported);
                        if (granted == 0) continue;
                        if (this.mOrigResolveList == currentResolveList) {
                            this.mOrigResolveList = new ArrayList<ResolveInfo>(this.mOrigResolveList);
                        }
                        currentResolveList.remove(i);
                    }
                }
            }
            if (currentResolveList != null && (N = currentResolveList.size()) > 0) {
                ResolveInfo ri;
                ResolveInfo r0 = currentResolveList.get(0);
                for (int i = 1; i < N; ++i) {
                    ResolveInfo ri2 = currentResolveList.get(i);
                    if (r0.priority == ri2.priority && r0.isDefault == ri2.isDefault) continue;
                    while (i < N) {
                        if (this.mOrigResolveList == currentResolveList) {
                            this.mOrigResolveList = new ArrayList<ResolveInfo>(this.mOrigResolveList);
                        }
                        currentResolveList.remove(i);
                        --N;
                    }
                }
                if (N > 1) {
                    ResolverComparator rComparator = new ResolverComparator(ResolverActivity.this);
                    Collections.sort(currentResolveList, rComparator);
                }
                if (this.mInitialIntents != null) {
                    for (int i = 0; i < this.mInitialIntents.length; ++i) {
                        Intent ii = this.mInitialIntents[i];
                        if (ii == null) continue;
                        ActivityInfo ai = ii.resolveActivityInfo(ResolverActivity.this.getPackageManager(), 0);
                        if (ai == null) {
                            Log.w(ResolverActivity.TAG, "No activity found for " + ii);
                            continue;
                        }
                        ri = new ResolveInfo();
                        ri.activityInfo = ai;
                        if (ii instanceof LabeledIntent) {
                            LabeledIntent li = (LabeledIntent)ii;
                            ri.resolvePackageName = li.getSourcePackage();
                            ri.labelRes = li.getLabelResource();
                            ri.nonLocalizedLabel = li.getNonLocalizedLabel();
                            ri.icon = li.getIconResource();
                        }
                        this.mList.add(new DisplayResolveInfo(ri, ri.loadLabel(ResolverActivity.this.getPackageManager()), null, ii));
                    }
                }
                r0 = currentResolveList.get(0);
                int start = 0;
                CharSequence r0Label = r0.loadLabel(ResolverActivity.this.mPm);
                ResolverActivity.this.mShowExtended = false;
                for (int i = 1; i < N; ++i) {
                    CharSequence riLabel;
                    if (r0Label == null) {
                        r0Label = r0.activityInfo.packageName;
                    }
                    if ((riLabel = (ri = currentResolveList.get(i)).loadLabel(ResolverActivity.this.mPm)) == null) {
                        riLabel = ri.activityInfo.packageName;
                    }
                    if (riLabel.equals(r0Label)) continue;
                    this.processGroup(currentResolveList, start, i - 1, r0, r0Label);
                    r0 = ri;
                    r0Label = riLabel;
                    start = i;
                }
                this.processGroup(currentResolveList, start, N - 1, r0, r0Label);
            }
        }

        private void processGroup(List<ResolveInfo> rList, int start, int end, ResolveInfo ro, CharSequence roLabel) {
            int num = end - start + 1;
            if (num == 1) {
                if (this.mLastChosen != null && this.mLastChosen.activityInfo.packageName.equals(ro.activityInfo.packageName) && this.mLastChosen.activityInfo.name.equals(ro.activityInfo.name)) {
                    this.mLastChosenPosition = this.mList.size();
                }
                this.mList.add(new DisplayResolveInfo(ro, roLabel, null, null));
            } else {
                ResolverActivity.this.mShowExtended = true;
                boolean usePkg = false;
                CharSequence startApp = ro.activityInfo.applicationInfo.loadLabel(ResolverActivity.this.mPm);
                if (startApp == null) {
                    usePkg = true;
                }
                if (!usePkg) {
                    HashSet<CharSequence> duplicates = new HashSet<CharSequence>();
                    duplicates.add(startApp);
                    for (int j = start + 1; j <= end; ++j) {
                        ResolveInfo jRi = rList.get(j);
                        CharSequence jApp = jRi.activityInfo.applicationInfo.loadLabel(ResolverActivity.this.mPm);
                        if (jApp == null || duplicates.contains(jApp)) {
                            usePkg = true;
                            break;
                        }
                        duplicates.add(jApp);
                    }
                    duplicates.clear();
                }
                for (int k = start; k <= end; ++k) {
                    ResolveInfo add = rList.get(k);
                    if (this.mLastChosen != null && this.mLastChosen.activityInfo.packageName.equals(add.activityInfo.packageName) && this.mLastChosen.activityInfo.name.equals(add.activityInfo.name)) {
                        this.mLastChosenPosition = this.mList.size();
                    }
                    if (usePkg) {
                        this.mList.add(new DisplayResolveInfo(add, roLabel, add.activityInfo.packageName, null));
                        continue;
                    }
                    this.mList.add(new DisplayResolveInfo(add, roLabel, add.activityInfo.applicationInfo.loadLabel(ResolverActivity.this.mPm), null));
                }
            }
        }

        public ResolveInfo resolveInfoForPosition(int position, boolean filtered) {
            return (filtered ? this.getItem((int)position) : this.mList.get((int)position)).ri;
        }

        public Intent intentForPosition(int position, boolean filtered) {
            DisplayResolveInfo dri = filtered ? this.getItem(position) : this.mList.get(position);
            Intent intent = new Intent(dri.origIntent != null ? dri.origIntent : ResolverActivity.this.getReplacementIntent(dri.ri.activityInfo.packageName, this.mIntent));
            intent.addFlags(0x3000000);
            ActivityInfo ai = dri.ri.activityInfo;
            intent.setComponent(new ComponentName(ai.applicationInfo.packageName, ai.name));
            return intent;
        }

        @Override
        public int getCount() {
            int result = this.mList.size();
            if (this.mFilterLastUsed && this.mLastChosenPosition >= 0) {
                --result;
            }
            return result;
        }

        @Override
        public DisplayResolveInfo getItem(int position) {
            if (this.mFilterLastUsed && this.mLastChosenPosition >= 0 && position >= this.mLastChosenPosition) {
                ++position;
            }
            return this.mList.get(position);
        }

        @Override
        public long getItemId(int position) {
            return position;
        }

        @Override
        public View getView(int position, View convertView, ViewGroup parent) {
            View view = convertView;
            if (view == null) {
                view = this.mInflater.inflate(17367212, parent, false);
                ViewHolder holder = new ViewHolder(view);
                view.setTag(holder);
            }
            this.bindView(view, this.getItem(position));
            return view;
        }

        private final void bindView(View view, DisplayResolveInfo info) {
            ViewHolder holder = (ViewHolder)view.getTag();
            holder.text.setText(info.displayLabel);
            if (ResolverActivity.this.mShowExtended) {
                holder.text2.setVisibility(0);
                holder.text2.setText(info.extendedInfo);
            } else {
                holder.text2.setVisibility(8);
            }
            if (info.displayIcon == null) {
                new LoadIconTask().execute(info);
            }
            holder.icon.setImageDrawable(info.displayIcon);
        }
    }

    private final class DisplayResolveInfo {
        ResolveInfo ri;
        CharSequence displayLabel;
        Drawable displayIcon;
        CharSequence extendedInfo;
        Intent origIntent;

        DisplayResolveInfo(ResolveInfo pri, CharSequence pLabel, CharSequence pInfo, Intent pOrigIntent) {
            this.ri = pri;
            this.displayLabel = pLabel;
            this.extendedInfo = pInfo;
            this.origIntent = pOrigIntent;
        }
    }

    private static enum ActionTitle {
        VIEW("android.intent.action.VIEW", 17040482, 17040483),
        EDIT("android.intent.action.EDIT", 17040484, 17040485),
        SEND("android.intent.action.SEND", 17040486, 17040487),
        SENDTO("android.intent.action.SENDTO", 17040486, 17040487),
        SEND_MULTIPLE("android.intent.action.SEND_MULTIPLE", 17040486, 17040487),
        DEFAULT(null, 17040480, 17040481),
        HOME("android.intent.action.MAIN", 17040488, 17040489);

        public final String action;
        public final int titleRes;
        public final int namedTitleRes;

        private ActionTitle(String action, int titleRes, int namedTitleRes) {
            this.action = action;
            this.titleRes = titleRes;
            this.namedTitleRes = namedTitleRes;
        }

        public static ActionTitle forAction(String action) {
            for (ActionTitle title : ActionTitle.values()) {
                if (title == HOME || action == null || !action.equals(title.action)) continue;
                return title;
            }
            return DEFAULT;
        }
    }
}

