/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.policy.impl;

import android.app.ActivityManager;
import android.app.ActivityManagerNative;
import android.app.IUiModeManager;
import android.app.ProgressDialog;
import android.app.SearchManager;
import android.app.UiModeManager;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.database.ContentObserver;
import android.graphics.Rect;
import android.media.AudioAttributes;
import android.media.AudioManager;
import android.media.IAudioService;
import android.media.Ringtone;
import android.media.RingtoneManager;
import android.media.session.MediaSessionLegacyHelper;
import android.os.Bundle;
import android.os.FactoryTest;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.PowerManager;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UEventObserver;
import android.os.UserHandle;
import android.os.Vibrator;
import android.provider.Settings;
import android.service.dreams.DreamManagerInternal;
import android.service.dreams.IDreamManager;
import android.telecom.TelecomManager;
import android.util.EventLog;
import android.util.Log;
import android.util.Slog;
import android.util.SparseArray;
import android.view.Display;
import android.view.IApplicationToken;
import android.view.IWindowManager;
import android.view.InputChannel;
import android.view.InputEvent;
import android.view.InputEventReceiver;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.Window;
import android.view.WindowManager;
import android.view.WindowManagerInternal;
import android.view.WindowManagerPolicy;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.AnimationUtils;
import com.android.internal.policy.PolicyManager;
import com.android.internal.policy.impl.BarController;
import com.android.internal.policy.impl.GlobalActions;
import com.android.internal.policy.impl.GlobalKeyManager;
import com.android.internal.policy.impl.ImmersiveModeConfirmation;
import com.android.internal.policy.impl.LogDecelerateInterpolator;
import com.android.internal.policy.impl.PolicyControl;
import com.android.internal.policy.impl.ShortcutManager;
import com.android.internal.policy.impl.SystemGesturesPointerEventListener;
import com.android.internal.policy.impl.WakeGestureListener;
import com.android.internal.policy.impl.WindowOrientationListener;
import com.android.internal.policy.impl.keyguard.KeyguardServiceDelegate;
import com.android.internal.statusbar.IStatusBarService;
import com.android.internal.widget.PointerLocationView;
import com.android.server.LocalServices;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;

public class PhoneWindowManager
implements WindowManagerPolicy {
    static final String TAG = "WindowManager";
    static final boolean DEBUG = false;
    static final boolean localLOGV = false;
    static final boolean DEBUG_LAYOUT = false;
    static final boolean DEBUG_INPUT = false;
    static final boolean DEBUG_STARTING_WINDOW = false;
    static final boolean DEBUG_WAKEUP = false;
    static final boolean SHOW_STARTING_ANIMATIONS = true;
    static final boolean SHOW_PROCESSES_ON_ALT_MENU = false;
    static final boolean ENABLE_CAR_DOCK_HOME_CAPTURE = true;
    static final boolean ENABLE_DESK_DOCK_HOME_CAPTURE = false;
    static final int SHORT_PRESS_POWER_NOTHING = 0;
    static final int SHORT_PRESS_POWER_GO_TO_SLEEP = 1;
    static final int SHORT_PRESS_POWER_REALLY_GO_TO_SLEEP = 2;
    static final int SHORT_PRESS_POWER_REALLY_GO_TO_SLEEP_AND_GO_HOME = 3;
    static final int LONG_PRESS_POWER_NOTHING = 0;
    static final int LONG_PRESS_POWER_GLOBAL_ACTIONS = 1;
    static final int LONG_PRESS_POWER_SHUT_OFF = 2;
    static final int LONG_PRESS_POWER_SHUT_OFF_NO_CONFIRM = 3;
    static final int LONG_PRESS_HOME_NOTHING = 0;
    static final int LONG_PRESS_HOME_RECENT_SYSTEM_UI = 1;
    static final int LONG_PRESS_HOME_ASSIST = 2;
    static final int DOUBLE_TAP_HOME_NOTHING = 0;
    static final int DOUBLE_TAP_HOME_RECENT_SYSTEM_UI = 1;
    static final int APPLICATION_MEDIA_SUBLAYER = -2;
    static final int APPLICATION_MEDIA_OVERLAY_SUBLAYER = -1;
    static final int APPLICATION_PANEL_SUBLAYER = 1;
    static final int APPLICATION_SUB_PANEL_SUBLAYER = 2;
    public static final String SYSTEM_DIALOG_REASON_KEY = "reason";
    public static final String SYSTEM_DIALOG_REASON_GLOBAL_ACTIONS = "globalactions";
    public static final String SYSTEM_DIALOG_REASON_RECENT_APPS = "recentapps";
    public static final String SYSTEM_DIALOG_REASON_HOME_KEY = "homekey";
    public static final String SYSTEM_DIALOG_REASON_ASSIST = "assist";
    static final int SYSTEM_UI_CHANGING_LAYOUT = -1073709050;
    private static final AudioAttributes VIBRATION_ATTRIBUTES = new AudioAttributes.Builder().setContentType(4).setUsage(13).build();
    private WindowManagerPolicy.WindowState mKeyguardScrim;
    private boolean mKeyguardHidden;
    private boolean mKeyguardDrawnOnce;
    static SparseArray<String> sApplicationLaunchKeyCategories = new SparseArray();
    static final int WAITING_FOR_DRAWN_TIMEOUT = 1000;
    private final Object mLock = new Object();
    Context mContext;
    IWindowManager mWindowManager;
    WindowManagerPolicy.WindowManagerFuncs mWindowManagerFuncs;
    WindowManagerInternal mWindowManagerInternal;
    PowerManager mPowerManager;
    DreamManagerInternal mDreamManagerInternal;
    IStatusBarService mStatusBarService;
    boolean mPreloadedRecentApps;
    final Object mServiceAquireLock = new Object();
    Vibrator mVibrator;
    SearchManager mSearchManager;
    AccessibilityManager mAccessibilityManager;
    long[] mLongPressVibePattern;
    long[] mVirtualKeyVibePattern;
    long[] mKeyboardTapVibePattern;
    long[] mClockTickVibePattern;
    long[] mCalendarDateVibePattern;
    long[] mSafeModeDisabledVibePattern;
    long[] mSafeModeEnabledVibePattern;
    boolean mEnableShiftMenuBugReports = false;
    boolean mSafeMode;
    WindowManagerPolicy.WindowState mStatusBar = null;
    int mStatusBarHeight;
    WindowManagerPolicy.WindowState mNavigationBar = null;
    boolean mHasNavigationBar = false;
    boolean mCanHideNavigationBar = false;
    boolean mNavigationBarCanMove = false;
    boolean mNavigationBarOnBottom = true;
    int[] mNavigationBarHeightForRotation = new int[4];
    int[] mNavigationBarWidthForRotation = new int[4];
    boolean mBootMessageNeedsHiding;
    KeyguardServiceDelegate mKeyguardDelegate;
    final Runnable mWindowManagerDrawCallback = new Runnable(){

        @Override
        public void run() {
            PhoneWindowManager.this.mHandler.sendEmptyMessage(7);
        }
    };
    final KeyguardServiceDelegate.ShowListener mKeyguardDelegateCallback = new KeyguardServiceDelegate.ShowListener(){

        @Override
        public void onShown(IBinder windowToken) {
            PhoneWindowManager.this.mHandler.sendEmptyMessage(5);
        }
    };
    GlobalActions mGlobalActions;
    volatile boolean mPowerKeyHandled;
    boolean mPendingPowerKeyUpCanceled;
    Handler mHandler;
    WindowManagerPolicy.WindowState mLastInputMethodWindow = null;
    WindowManagerPolicy.WindowState mLastInputMethodTargetWindow = null;
    boolean mRecentsVisible;
    int mRecentAppsHeldModifiers;
    boolean mLanguageSwitchKeyPressed;
    int mLidState = -1;
    int mCameraLensCoverState = -1;
    boolean mHaveBuiltInKeyboard;
    boolean mSystemReady;
    boolean mSystemBooted;
    boolean mHdmiPlugged;
    IUiModeManager mUiModeManager;
    int mUiMode;
    int mDockMode = 0;
    int mLidOpenRotation;
    int mCarDockRotation;
    int mDeskDockRotation;
    int mUndockedHdmiRotation;
    int mDemoHdmiRotation;
    boolean mDemoHdmiRotationLock;
    boolean mWakeGestureEnabledSetting;
    MyWakeGestureListener mWakeGestureListener;
    private boolean mForceDefaultOrientation = false;
    int mUserRotationMode = 0;
    int mUserRotation = 0;
    boolean mAccelerometerDefault;
    boolean mSupportAutoRotation;
    int mAllowAllRotations = -1;
    boolean mCarDockEnablesAccelerometer;
    boolean mDeskDockEnablesAccelerometer;
    int mLidKeyboardAccessibility;
    int mLidNavigationAccessibility;
    boolean mLidControlsSleep;
    int mShortPressOnPowerBehavior = -1;
    int mLongPressOnPowerBehavior = -1;
    boolean mAwake;
    boolean mScreenOnEarly;
    boolean mScreenOnFully;
    WindowManagerPolicy.ScreenOnListener mScreenOnListener;
    boolean mKeyguardDrawComplete;
    boolean mWindowManagerDrawComplete;
    boolean mOrientationSensorEnabled = false;
    int mCurrentAppOrientation = -1;
    boolean mHasSoftInput = false;
    boolean mTranslucentDecorEnabled = true;
    int mPointerLocationMode = 0;
    WindowManagerPolicy.WindowState mFocusedWindow;
    IApplicationToken mFocusedApp;
    PointerLocationView mPointerLocationView;
    int mOverscanScreenLeft;
    int mOverscanScreenTop;
    int mOverscanScreenWidth;
    int mOverscanScreenHeight;
    int mUnrestrictedScreenLeft;
    int mUnrestrictedScreenTop;
    int mUnrestrictedScreenWidth;
    int mUnrestrictedScreenHeight;
    int mRestrictedOverscanScreenLeft;
    int mRestrictedOverscanScreenTop;
    int mRestrictedOverscanScreenWidth;
    int mRestrictedOverscanScreenHeight;
    int mRestrictedScreenLeft;
    int mRestrictedScreenTop;
    int mRestrictedScreenWidth;
    int mRestrictedScreenHeight;
    int mSystemLeft;
    int mSystemTop;
    int mSystemRight;
    int mSystemBottom;
    int mStableLeft;
    int mStableTop;
    int mStableRight;
    int mStableBottom;
    int mStableFullscreenLeft;
    int mStableFullscreenTop;
    int mStableFullscreenRight;
    int mStableFullscreenBottom;
    int mCurLeft;
    int mCurTop;
    int mCurRight;
    int mCurBottom;
    int mContentLeft;
    int mContentTop;
    int mContentRight;
    int mContentBottom;
    int mVoiceContentLeft;
    int mVoiceContentTop;
    int mVoiceContentRight;
    int mVoiceContentBottom;
    int mDockLeft;
    int mDockTop;
    int mDockRight;
    int mDockBottom;
    int mDockLayer;
    int mStatusBarLayer;
    int mLastSystemUiFlags;
    int mResettingSystemUiFlags = 0;
    int mForceClearedSystemUiFlags = 0;
    boolean mLastFocusNeedsMenu = false;
    WindowManagerPolicy.FakeWindow mHideNavFakeWindow = null;
    static final Rect mTmpParentFrame;
    static final Rect mTmpDisplayFrame;
    static final Rect mTmpOverscanFrame;
    static final Rect mTmpContentFrame;
    static final Rect mTmpVisibleFrame;
    static final Rect mTmpDecorFrame;
    static final Rect mTmpStableFrame;
    static final Rect mTmpNavigationFrame;
    WindowManagerPolicy.WindowState mTopFullscreenOpaqueWindowState;
    HashSet<IApplicationToken> mAppsToBeHidden = new HashSet();
    HashSet<IApplicationToken> mAppsThatDismissKeyguard = new HashSet();
    boolean mTopIsFullscreen;
    boolean mForceStatusBar;
    boolean mForceStatusBarFromKeyguard;
    boolean mHideLockScreen;
    boolean mForcingShowNavBar;
    int mForcingShowNavBarLayer;
    private static final int DISMISS_KEYGUARD_NONE = 0;
    private static final int DISMISS_KEYGUARD_START = 1;
    private static final int DISMISS_KEYGUARD_CONTINUE = 2;
    int mDismissKeyguard = 0;
    private WindowManagerPolicy.WindowState mWinDismissingKeyguard;
    private WindowManagerPolicy.WindowState mWinShowWhenLocked;
    boolean mShowingLockscreen;
    boolean mShowingDream;
    boolean mDreamingLockscreen;
    boolean mHomePressed;
    boolean mHomeConsumed;
    boolean mHomeDoubleTapPending;
    Intent mHomeIntent;
    Intent mCarDockIntent;
    Intent mDeskDockIntent;
    boolean mSearchKeyShortcutPending;
    boolean mConsumeSearchKeyUp;
    boolean mAssistKeyLongPressed;
    boolean mPendingMetaAction;
    boolean mAllowLockscreenWhenOn;
    int mLockScreenTimeout;
    boolean mLockScreenTimerActive;
    int mEndcallBehavior;
    int mIncallPowerBehavior;
    Display mDisplay;
    int mLandscapeRotation = 0;
    int mSeascapeRotation = 0;
    int mPortraitRotation = 0;
    int mUpsideDownRotation = 0;
    int mOverscanLeft = 0;
    int mOverscanTop = 0;
    int mOverscanRight = 0;
    int mOverscanBottom = 0;
    private int mLongPressOnHomeBehavior;
    private int mDoubleTapOnHomeBehavior;
    private static final long SCREENSHOT_CHORD_DEBOUNCE_DELAY_MILLIS = 150L;
    private static final float KEYGUARD_SCREENSHOT_CHORD_DELAY_MULTIPLIER = 2.5f;
    private boolean mScreenshotChordEnabled;
    private boolean mVolumeDownKeyTriggered;
    private long mVolumeDownKeyTime;
    private boolean mVolumeDownKeyConsumedByScreenshotChord;
    private boolean mVolumeUpKeyTriggered;
    private boolean mPowerKeyTriggered;
    private long mPowerKeyTime;
    private static final int BRIGHTNESS_STEPS = 10;
    SettingsObserver mSettingsObserver;
    ShortcutManager mShortcutManager;
    PowerManager.WakeLock mBroadcastWakeLock;
    boolean mHavePendingMediaKeyRepeatWithWakeLock;
    private int mCurrentUserId;
    private GlobalKeyManager mGlobalKeyManager;
    private final SparseArray<KeyCharacterMap.FallbackAction> mFallbackActions = new SparseArray();
    private final LogDecelerateInterpolator mLogDecelerateInterpolator = new LogDecelerateInterpolator(100, 0);
    private static final int MSG_ENABLE_POINTER_LOCATION = 1;
    private static final int MSG_DISABLE_POINTER_LOCATION = 2;
    private static final int MSG_DISPATCH_MEDIA_KEY_WITH_WAKE_LOCK = 3;
    private static final int MSG_DISPATCH_MEDIA_KEY_REPEAT_WITH_WAKE_LOCK = 4;
    private static final int MSG_KEYGUARD_DRAWN_COMPLETE = 5;
    private static final int MSG_KEYGUARD_DRAWN_TIMEOUT = 6;
    private static final int MSG_WINDOW_MANAGER_DRAWN_COMPLETE = 7;
    private static final int MSG_DISPATCH_SHOW_RECENTS = 9;
    private static final int MSG_DISPATCH_SHOW_GLOBAL_ACTIONS = 10;
    private static final int MSG_HIDE_BOOT_MESSAGE = 11;
    private static final int MSG_LAUNCH_VOICE_ASSIST_WITH_WAKE_LOCK = 12;
    private UEventObserver mHDMIObserver = new UEventObserver(){

        @Override
        public void onUEvent(UEventObserver.UEvent event) {
            PhoneWindowManager.this.setHdmiPlugged("1".equals(event.get("SWITCH_STATE")));
        }
    };
    MyOrientationListener mOrientationListener;
    private final BarController mStatusBarController = new BarController("StatusBar", 0x4000000, 0x10000000, 0x40000000, 1, 0x4000000);
    private final BarController mNavigationBarController = new BarController("NavigationBar", 0x8000000, 0x20000000, Integer.MIN_VALUE, 2, 0x8000000);
    private ImmersiveModeConfirmation mImmersiveModeConfirmation;
    private SystemGesturesPointerEventListener mSystemGestures;
    private final Runnable mPowerLongPress = new Runnable(){

        @Override
        public void run() {
            if (PhoneWindowManager.this.mLongPressOnPowerBehavior < 0) {
                PhoneWindowManager.this.mLongPressOnPowerBehavior = PhoneWindowManager.this.mContext.getResources().getInteger(17694779);
            }
            int resolvedBehavior = PhoneWindowManager.this.mLongPressOnPowerBehavior;
            if (FactoryTest.isLongPressOnPowerOffEnabled()) {
                resolvedBehavior = 3;
            }
            switch (resolvedBehavior) {
                case 0: {
                    break;
                }
                case 1: {
                    PhoneWindowManager.this.mPowerKeyHandled = true;
                    if (!PhoneWindowManager.this.performHapticFeedbackLw(null, 0, false)) {
                        PhoneWindowManager.this.performAuditoryFeedbackForAccessibilityIfNeed();
                    }
                    PhoneWindowManager.this.showGlobalActionsInternal();
                    break;
                }
                case 2: 
                case 3: {
                    PhoneWindowManager.this.mPowerKeyHandled = true;
                    PhoneWindowManager.this.performHapticFeedbackLw(null, 0, false);
                    PhoneWindowManager.this.sendCloseSystemWindows(PhoneWindowManager.SYSTEM_DIALOG_REASON_GLOBAL_ACTIONS);
                    PhoneWindowManager.this.mWindowManagerFuncs.shutdown(resolvedBehavior == 2);
                }
            }
        }
    };
    private final Runnable mScreenshotRunnable = new Runnable(){

        @Override
        public void run() {
            PhoneWindowManager.this.takeScreenshot();
        }
    };
    private final Runnable mHomeDoubleTapTimeoutRunnable = new Runnable(){

        @Override
        public void run() {
            if (PhoneWindowManager.this.mHomeDoubleTapPending) {
                PhoneWindowManager.this.mHomeDoubleTapPending = false;
                PhoneWindowManager.this.launchHomeFromHotKey();
            }
        }
    };
    static final boolean PRINT_ANIM = false;
    private static final int[] WINDOW_TYPES_WHERE_HOME_DOESNT_WORK;
    private final Runnable mClearHideNavigationFlag = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = PhoneWindowManager.this.mWindowManagerFuncs.getWindowManagerLock();
            synchronized (object) {
                PhoneWindowManager.this.mForceClearedSystemUiFlags &= 0xFFFFFFFD;
            }
            PhoneWindowManager.this.mWindowManagerFuncs.reevaluateStatusBarVisibility();
        }
    };
    final InputEventReceiver.Factory mHideNavInputEventReceiverFactory = new InputEventReceiver.Factory(){

        @Override
        public InputEventReceiver createInputEventReceiver(InputChannel inputChannel, Looper looper) {
            return new HideNavInputEventReceiver(inputChannel, looper);
        }
    };
    final Object mScreenshotLock = new Object();
    ServiceConnection mScreenshotConnection = null;
    final Runnable mScreenshotTimeout = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = PhoneWindowManager.this.mScreenshotLock;
            synchronized (object) {
                if (PhoneWindowManager.this.mScreenshotConnection != null) {
                    PhoneWindowManager.this.mContext.unbindService(PhoneWindowManager.this.mScreenshotConnection);
                    PhoneWindowManager.this.mScreenshotConnection = null;
                }
            }
        }
    };
    BroadcastReceiver mDockReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            if ("android.intent.action.DOCK_EVENT".equals(intent.getAction())) {
                PhoneWindowManager.this.mDockMode = intent.getIntExtra("android.intent.extra.DOCK_STATE", 0);
            } else {
                try {
                    IUiModeManager uiModeService = IUiModeManager.Stub.asInterface(ServiceManager.getService("uimode"));
                    PhoneWindowManager.this.mUiMode = uiModeService.getCurrentModeType();
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            PhoneWindowManager.this.updateRotation(true);
            Object object = PhoneWindowManager.this.mLock;
            synchronized (object) {
                PhoneWindowManager.this.updateOrientationListenerLp();
            }
        }
    };
    BroadcastReceiver mDreamReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            if ("android.intent.action.DREAMING_STARTED".equals(intent.getAction())) {
                if (PhoneWindowManager.this.mKeyguardDelegate != null) {
                    PhoneWindowManager.this.mKeyguardDelegate.onDreamingStarted();
                }
            } else if ("android.intent.action.DREAMING_STOPPED".equals(intent.getAction()) && PhoneWindowManager.this.mKeyguardDelegate != null) {
                PhoneWindowManager.this.mKeyguardDelegate.onDreamingStopped();
            }
        }
    };
    BroadcastReceiver mMultiuserReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            if ("android.intent.action.USER_SWITCHED".equals(intent.getAction())) {
                PhoneWindowManager.this.mSettingsObserver.onChange(false);
                Object object = PhoneWindowManager.this.mWindowManagerFuncs.getWindowManagerLock();
                synchronized (object) {
                    PhoneWindowManager.this.mLastSystemUiFlags = 0;
                    PhoneWindowManager.this.updateSystemUiVisibilityLw();
                }
            }
        }
    };
    private final Runnable mRequestTransientNav = new Runnable(){

        @Override
        public void run() {
            PhoneWindowManager.this.requestTransientBars(PhoneWindowManager.this.mNavigationBar);
        }
    };
    ProgressDialog mBootMsgDialog = null;
    ScreenLockTimeout mScreenLockTimeout = new ScreenLockTimeout();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IStatusBarService getStatusBarService() {
        Object object = this.mServiceAquireLock;
        synchronized (object) {
            if (this.mStatusBarService == null) {
                this.mStatusBarService = IStatusBarService.Stub.asInterface(ServiceManager.getService("statusbar"));
            }
            return this.mStatusBarService;
        }
    }

    boolean needSensorRunningLp() {
        if (this.mSupportAutoRotation && (this.mCurrentAppOrientation == 4 || this.mCurrentAppOrientation == 10 || this.mCurrentAppOrientation == 7 || this.mCurrentAppOrientation == 6)) {
            return true;
        }
        if (this.mCarDockEnablesAccelerometer && this.mDockMode == 2 || this.mDeskDockEnablesAccelerometer && (this.mDockMode == 1 || this.mDockMode == 3 || this.mDockMode == 4)) {
            return true;
        }
        if (this.mUserRotationMode == 1) {
            return false;
        }
        return this.mSupportAutoRotation;
    }

    void updateOrientationListenerLp() {
        if (!this.mOrientationListener.canDetectOrientation()) {
            return;
        }
        boolean disable = true;
        if (this.mScreenOnEarly && this.mAwake && this.needSensorRunningLp()) {
            disable = false;
            if (!this.mOrientationSensorEnabled) {
                this.mOrientationListener.enable();
                this.mOrientationSensorEnabled = true;
            }
        }
        if (disable && this.mOrientationSensorEnabled) {
            this.mOrientationListener.disable();
            this.mOrientationSensorEnabled = false;
        }
    }

    private void interceptPowerKeyDown(boolean handled) {
        this.mPowerKeyHandled = handled;
        if (!handled) {
            this.mHandler.postDelayed(this.mPowerLongPress, ViewConfiguration.get(this.mContext).getDeviceGlobalActionKeyTimeout());
        }
    }

    private boolean interceptPowerKeyUp(boolean canceled) {
        if (!this.mPowerKeyHandled) {
            this.mHandler.removeCallbacks(this.mPowerLongPress);
            return !canceled;
        }
        return false;
    }

    private void cancelPendingPowerKeyAction() {
        if (!this.mPowerKeyHandled) {
            this.mHandler.removeCallbacks(this.mPowerLongPress);
        }
        if (this.mPowerKeyTriggered) {
            this.mPendingPowerKeyUpCanceled = true;
        }
    }

    private void interceptScreenshotChord() {
        long now;
        if (this.mScreenshotChordEnabled && this.mVolumeDownKeyTriggered && this.mPowerKeyTriggered && !this.mVolumeUpKeyTriggered && (now = SystemClock.uptimeMillis()) <= this.mVolumeDownKeyTime + 150L && now <= this.mPowerKeyTime + 150L) {
            this.mVolumeDownKeyConsumedByScreenshotChord = true;
            this.cancelPendingPowerKeyAction();
            this.mHandler.postDelayed(this.mScreenshotRunnable, this.getScreenshotChordLongPressDelay());
        }
    }

    private long getScreenshotChordLongPressDelay() {
        if (this.mKeyguardDelegate.isShowing()) {
            return (long)(2.5f * (float)ViewConfiguration.get(this.mContext).getDeviceGlobalActionKeyTimeout());
        }
        return ViewConfiguration.get(this.mContext).getDeviceGlobalActionKeyTimeout();
    }

    private void cancelPendingScreenshotChordAction() {
        this.mHandler.removeCallbacks(this.mScreenshotRunnable);
    }

    private void powerShortPress(long eventTime) {
        if (this.mShortPressOnPowerBehavior < 0) {
            this.mShortPressOnPowerBehavior = this.mContext.getResources().getInteger(17694780);
        }
        switch (this.mShortPressOnPowerBehavior) {
            case 0: {
                break;
            }
            case 1: {
                this.mPowerManager.goToSleep(eventTime, 4, 0);
                break;
            }
            case 2: {
                this.mPowerManager.goToSleep(eventTime, 4, 1);
                break;
            }
            case 3: {
                this.mPowerManager.goToSleep(eventTime, 4, 1);
                this.launchHomeFromHotKey();
            }
        }
    }

    @Override
    public void showGlobalActions() {
        this.mHandler.removeMessages(10);
        this.mHandler.sendEmptyMessage(10);
    }

    void showGlobalActionsInternal() {
        this.sendCloseSystemWindows(SYSTEM_DIALOG_REASON_GLOBAL_ACTIONS);
        if (this.mGlobalActions == null) {
            this.mGlobalActions = new GlobalActions(this.mContext, this.mWindowManagerFuncs);
        }
        boolean keyguardShowing = this.keyguardIsShowingTq();
        this.mGlobalActions.showDialog(keyguardShowing, this.isDeviceProvisioned());
        if (keyguardShowing) {
            this.mPowerManager.userActivity(SystemClock.uptimeMillis(), false);
        }
    }

    boolean isDeviceProvisioned() {
        return Settings.Global.getInt(this.mContext.getContentResolver(), "device_provisioned", 0) != 0;
    }

    boolean isUserSetupComplete() {
        return Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "user_setup_complete", 0, -2) != 0;
    }

    private void handleLongPressOnHome() {
        if (this.mLongPressOnHomeBehavior != 0) {
            this.mHomeConsumed = true;
            this.performHapticFeedbackLw(null, 0, false);
            if (this.mLongPressOnHomeBehavior == 1) {
                this.toggleRecentApps();
            } else if (this.mLongPressOnHomeBehavior == 2) {
                this.launchAssistAction();
            }
        }
    }

    private void handleDoubleTapOnHome() {
        if (this.mDoubleTapOnHomeBehavior == 1) {
            this.mHomeConsumed = true;
            this.toggleRecentApps();
        }
    }

    @Override
    public void init(Context context, IWindowManager windowManager, WindowManagerPolicy.WindowManagerFuncs windowManagerFuncs) {
        this.mContext = context;
        this.mWindowManager = windowManager;
        this.mWindowManagerFuncs = windowManagerFuncs;
        this.mWindowManagerInternal = LocalServices.getService(WindowManagerInternal.class);
        this.mDreamManagerInternal = LocalServices.getService(DreamManagerInternal.class);
        this.mHandler = new PolicyHandler();
        this.mWakeGestureListener = new MyWakeGestureListener(this.mContext, this.mHandler);
        this.mOrientationListener = new MyOrientationListener(this.mContext, this.mHandler);
        try {
            this.mOrientationListener.setCurrentRotation(windowManager.getRotation());
        }
        catch (RemoteException ex) {
            // empty catch block
        }
        this.mSettingsObserver = new SettingsObserver(this.mHandler);
        this.mSettingsObserver.observe();
        this.mShortcutManager = new ShortcutManager(context, this.mHandler);
        this.mShortcutManager.observe();
        this.mUiMode = context.getResources().getInteger(17694778);
        this.mHomeIntent = new Intent("android.intent.action.MAIN", null);
        this.mHomeIntent.addCategory("android.intent.category.HOME");
        this.mHomeIntent.addFlags(0x10200000);
        this.mCarDockIntent = new Intent("android.intent.action.MAIN", null);
        this.mCarDockIntent.addCategory("android.intent.category.CAR_DOCK");
        this.mCarDockIntent.addFlags(0x10200000);
        this.mDeskDockIntent = new Intent("android.intent.action.MAIN", null);
        this.mDeskDockIntent.addCategory("android.intent.category.DESK_DOCK");
        this.mDeskDockIntent.addFlags(0x10200000);
        this.mPowerManager = (PowerManager)context.getSystemService("power");
        this.mBroadcastWakeLock = this.mPowerManager.newWakeLock(1, "PhoneWindowManager.mBroadcastWakeLock");
        this.mEnableShiftMenuBugReports = "1".equals(SystemProperties.get("ro.debuggable"));
        this.mSupportAutoRotation = this.mContext.getResources().getBoolean(17956901);
        this.mLidOpenRotation = this.readRotation(17694770);
        this.mCarDockRotation = this.readRotation(17694775);
        this.mDeskDockRotation = this.readRotation(17694773);
        this.mUndockedHdmiRotation = this.readRotation(17694777);
        this.mCarDockEnablesAccelerometer = this.mContext.getResources().getBoolean(17956906);
        this.mDeskDockEnablesAccelerometer = this.mContext.getResources().getBoolean(17956905);
        this.mLidKeyboardAccessibility = this.mContext.getResources().getInteger(17694771);
        this.mLidNavigationAccessibility = this.mContext.getResources().getInteger(17694772);
        this.mLidControlsSleep = this.mContext.getResources().getBoolean(17956904);
        this.mTranslucentDecorEnabled = this.mContext.getResources().getBoolean(17956915);
        this.readConfigurationDependentBehaviors();
        this.mAccessibilityManager = (AccessibilityManager)context.getSystemService("accessibility");
        IntentFilter filter = new IntentFilter();
        filter.addAction(UiModeManager.ACTION_ENTER_CAR_MODE);
        filter.addAction(UiModeManager.ACTION_EXIT_CAR_MODE);
        filter.addAction(UiModeManager.ACTION_ENTER_DESK_MODE);
        filter.addAction(UiModeManager.ACTION_EXIT_DESK_MODE);
        filter.addAction("android.intent.action.DOCK_EVENT");
        Intent intent = context.registerReceiver(this.mDockReceiver, filter);
        if (intent != null) {
            this.mDockMode = intent.getIntExtra("android.intent.extra.DOCK_STATE", 0);
        }
        filter = new IntentFilter();
        filter.addAction("android.intent.action.DREAMING_STARTED");
        filter.addAction("android.intent.action.DREAMING_STOPPED");
        context.registerReceiver(this.mDreamReceiver, filter);
        filter = new IntentFilter("android.intent.action.USER_SWITCHED");
        context.registerReceiver(this.mMultiuserReceiver, filter);
        this.mSystemGestures = new SystemGesturesPointerEventListener(context, new SystemGesturesPointerEventListener.Callbacks(){

            @Override
            public void onSwipeFromTop() {
                if (PhoneWindowManager.this.mStatusBar != null) {
                    PhoneWindowManager.this.requestTransientBars(PhoneWindowManager.this.mStatusBar);
                }
            }

            @Override
            public void onSwipeFromBottom() {
                if (PhoneWindowManager.this.mNavigationBar != null && PhoneWindowManager.this.mNavigationBarOnBottom) {
                    PhoneWindowManager.this.requestTransientBars(PhoneWindowManager.this.mNavigationBar);
                }
            }

            @Override
            public void onSwipeFromRight() {
                if (PhoneWindowManager.this.mNavigationBar != null && !PhoneWindowManager.this.mNavigationBarOnBottom) {
                    PhoneWindowManager.this.requestTransientBars(PhoneWindowManager.this.mNavigationBar);
                }
            }

            @Override
            public void onDebug() {
            }
        });
        this.mImmersiveModeConfirmation = new ImmersiveModeConfirmation(this.mContext);
        this.mWindowManagerFuncs.registerPointerEventListener(this.mSystemGestures);
        this.mVibrator = (Vibrator)context.getSystemService("vibrator");
        this.mLongPressVibePattern = PhoneWindowManager.getLongIntArray(this.mContext.getResources(), 17235994);
        this.mVirtualKeyVibePattern = PhoneWindowManager.getLongIntArray(this.mContext.getResources(), 17235995);
        this.mKeyboardTapVibePattern = PhoneWindowManager.getLongIntArray(this.mContext.getResources(), 17235996);
        this.mClockTickVibePattern = PhoneWindowManager.getLongIntArray(this.mContext.getResources(), 17235997);
        this.mCalendarDateVibePattern = PhoneWindowManager.getLongIntArray(this.mContext.getResources(), 17235998);
        this.mSafeModeDisabledVibePattern = PhoneWindowManager.getLongIntArray(this.mContext.getResources(), 17235999);
        this.mSafeModeEnabledVibePattern = PhoneWindowManager.getLongIntArray(this.mContext.getResources(), 17236000);
        this.mScreenshotChordEnabled = this.mContext.getResources().getBoolean(17956900);
        this.mGlobalKeyManager = new GlobalKeyManager(this.mContext);
        this.initializeHdmiState();
        if (!this.mPowerManager.isInteractive()) {
            this.goingToSleep(2);
        }
    }

    private void readConfigurationDependentBehaviors() {
        this.mLongPressOnHomeBehavior = this.mContext.getResources().getInteger(17694793);
        if (this.mLongPressOnHomeBehavior < 0 || this.mLongPressOnHomeBehavior > 2) {
            this.mLongPressOnHomeBehavior = 0;
        }
        this.mDoubleTapOnHomeBehavior = this.mContext.getResources().getInteger(17694794);
        if (this.mDoubleTapOnHomeBehavior < 0 || this.mDoubleTapOnHomeBehavior > 1) {
            this.mDoubleTapOnHomeBehavior = 0;
        }
    }

    @Override
    public void setInitialDisplaySize(Display display, int width, int height, int density) {
        int longSize;
        int shortSize;
        if (this.mContext == null || display.getDisplayId() != 0) {
            return;
        }
        this.mDisplay = display;
        Resources res = this.mContext.getResources();
        if (width > height) {
            shortSize = height;
            longSize = width;
            this.mLandscapeRotation = 0;
            this.mSeascapeRotation = 2;
            if (res.getBoolean(17956903)) {
                this.mPortraitRotation = 1;
                this.mUpsideDownRotation = 3;
            } else {
                this.mPortraitRotation = 3;
                this.mUpsideDownRotation = 1;
            }
        } else {
            shortSize = width;
            longSize = height;
            this.mPortraitRotation = 0;
            this.mUpsideDownRotation = 2;
            if (res.getBoolean(17956903)) {
                this.mLandscapeRotation = 3;
                this.mSeascapeRotation = 1;
            } else {
                this.mLandscapeRotation = 1;
                this.mSeascapeRotation = 3;
            }
        }
        this.mStatusBarHeight = res.getDimensionPixelSize(0x1050010);
        this.mNavigationBarHeightForRotation[this.mPortraitRotation] = this.mNavigationBarHeightForRotation[this.mUpsideDownRotation] = res.getDimensionPixelSize(0x1050011);
        this.mNavigationBarHeightForRotation[this.mLandscapeRotation] = this.mNavigationBarHeightForRotation[this.mSeascapeRotation] = res.getDimensionPixelSize(17104914);
        this.mNavigationBarWidthForRotation[this.mLandscapeRotation] = this.mNavigationBarWidthForRotation[this.mSeascapeRotation] = res.getDimensionPixelSize(17104915);
        this.mNavigationBarWidthForRotation[this.mUpsideDownRotation] = this.mNavigationBarWidthForRotation[this.mSeascapeRotation];
        this.mNavigationBarWidthForRotation[this.mPortraitRotation] = this.mNavigationBarWidthForRotation[this.mSeascapeRotation];
        int shortSizeDp = shortSize * 160 / density;
        int longSizeDp = longSize * 160 / density;
        this.mNavigationBarCanMove = shortSizeDp < 600;
        this.mHasNavigationBar = res.getBoolean(17956943);
        String navBarOverride = SystemProperties.get("qemu.hw.mainkeys");
        if ("1".equals(navBarOverride)) {
            this.mHasNavigationBar = false;
        } else if ("0".equals(navBarOverride)) {
            this.mHasNavigationBar = true;
        }
        this.mDemoHdmiRotation = "portrait".equals(SystemProperties.get("persist.demo.hdmirotation")) ? this.mPortraitRotation : this.mLandscapeRotation;
        this.mDemoHdmiRotationLock = SystemProperties.getBoolean("persist.demo.hdmirotationlock", false);
        this.mForceDefaultOrientation = longSizeDp >= 960 && shortSizeDp >= 720 && res.getBoolean(17956969) && !"true".equals(SystemProperties.get("config.override_forced_orient"));
    }

    private boolean canHideNavigationBar() {
        return this.mHasNavigationBar && !this.mAccessibilityManager.isTouchExplorationEnabled();
    }

    @Override
    public boolean isDefaultOrientationForced() {
        return this.mForceDefaultOrientation;
    }

    @Override
    public void setDisplayOverscan(Display display, int left, int top, int right, int bottom) {
        if (display.getDisplayId() == 0) {
            this.mOverscanLeft = left;
            this.mOverscanTop = top;
            this.mOverscanRight = right;
            this.mOverscanBottom = bottom;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSettings() {
        ContentResolver resolver = this.mContext.getContentResolver();
        boolean updateRotation = false;
        Object object = this.mLock;
        synchronized (object) {
            boolean hasSoftInput;
            int pointerLocation;
            int userRotationMode;
            int userRotation;
            boolean wakeGestureEnabledSetting;
            this.mEndcallBehavior = Settings.System.getIntForUser(resolver, "end_button_behavior", 2, -2);
            this.mIncallPowerBehavior = Settings.Secure.getIntForUser(resolver, "incall_power_button_behavior", 1, -2);
            boolean bl = wakeGestureEnabledSetting = Settings.Secure.getIntForUser(resolver, "wake_gesture_enabled", 0, -2) != 0;
            if (this.mWakeGestureEnabledSetting != wakeGestureEnabledSetting) {
                this.mWakeGestureEnabledSetting = wakeGestureEnabledSetting;
                this.updateWakeGestureListenerLp();
            }
            if (this.mUserRotation != (userRotation = Settings.System.getIntForUser(resolver, "user_rotation", 0, -2))) {
                this.mUserRotation = userRotation;
                updateRotation = true;
            }
            int n = userRotationMode = Settings.System.getIntForUser(resolver, "accelerometer_rotation", 0, -2) != 0 ? 0 : 1;
            if (this.mUserRotationMode != userRotationMode) {
                this.mUserRotationMode = userRotationMode;
                updateRotation = true;
                this.updateOrientationListenerLp();
            }
            if (this.mSystemReady && this.mPointerLocationMode != (pointerLocation = Settings.System.getIntForUser(resolver, "pointer_location", 0, -2))) {
                this.mPointerLocationMode = pointerLocation;
                this.mHandler.sendEmptyMessage(pointerLocation != 0 ? 1 : 2);
            }
            this.mLockScreenTimeout = Settings.System.getIntForUser(resolver, "screen_off_timeout", 0, -2);
            String imId = Settings.Secure.getStringForUser(resolver, "default_input_method", -2);
            boolean bl2 = hasSoftInput = imId != null && imId.length() > 0;
            if (this.mHasSoftInput != hasSoftInput) {
                this.mHasSoftInput = hasSoftInput;
                updateRotation = true;
            }
            if (this.mImmersiveModeConfirmation != null) {
                this.mImmersiveModeConfirmation.loadSetting(this.mCurrentUserId);
            }
            PolicyControl.reloadFromSetting(this.mContext);
        }
        if (updateRotation) {
            this.updateRotation(true);
        }
    }

    private void updateWakeGestureListenerLp() {
        if (this.shouldEnableWakeGestureLp()) {
            this.mWakeGestureListener.requestWakeUpTrigger();
        } else {
            this.mWakeGestureListener.cancelWakeUpTrigger();
        }
    }

    private boolean shouldEnableWakeGestureLp() {
        return this.mWakeGestureEnabledSetting && !this.mAwake && (!this.mLidControlsSleep || this.mLidState != 0) && this.mWakeGestureListener.isSupported();
    }

    private void enablePointerLocation() {
        if (this.mPointerLocationView == null) {
            this.mPointerLocationView = new PointerLocationView(this.mContext);
            this.mPointerLocationView.setPrintCoords(false);
            WindowManager.LayoutParams lp = new WindowManager.LayoutParams(-1, -1);
            lp.type = 2015;
            lp.flags = 1304;
            if (ActivityManager.isHighEndGfx()) {
                lp.flags |= 0x1000000;
                lp.privateFlags |= 2;
            }
            lp.format = -3;
            lp.setTitle("PointerLocation");
            WindowManager wm = (WindowManager)this.mContext.getSystemService("window");
            lp.inputFeatures |= 2;
            wm.addView(this.mPointerLocationView, lp);
            this.mWindowManagerFuncs.registerPointerEventListener(this.mPointerLocationView);
        }
    }

    private void disablePointerLocation() {
        if (this.mPointerLocationView != null) {
            this.mWindowManagerFuncs.unregisterPointerEventListener(this.mPointerLocationView);
            WindowManager wm = (WindowManager)this.mContext.getSystemService("window");
            wm.removeView(this.mPointerLocationView);
            this.mPointerLocationView = null;
        }
    }

    private int readRotation(int resID) {
        try {
            int rotation = this.mContext.getResources().getInteger(resID);
            switch (rotation) {
                case 0: {
                    return 0;
                }
                case 90: {
                    return 1;
                }
                case 180: {
                    return 2;
                }
                case 270: {
                    return 3;
                }
            }
        }
        catch (Resources.NotFoundException notFoundException) {
            // empty catch block
        }
        return -1;
    }

    @Override
    public int checkAddPermission(WindowManager.LayoutParams attrs, int[] outAppOp) {
        int type = attrs.type;
        outAppOp[0] = -1;
        if (type < 2000 || type > 2999) {
            return 0;
        }
        String permission2 = null;
        switch (type) {
            case 2005: {
                outAppOp[0] = 45;
                break;
            }
            case 2011: 
            case 2013: 
            case 2023: 
            case 2030: 
            case 2031: {
                break;
            }
            case 2002: 
            case 2003: 
            case 2006: 
            case 2007: 
            case 2010: {
                permission2 = "android.permission.SYSTEM_ALERT_WINDOW";
                outAppOp[0] = 24;
                break;
            }
            default: {
                permission2 = "android.permission.INTERNAL_SYSTEM_WINDOW";
            }
        }
        if (permission2 != null && this.mContext.checkCallingOrSelfPermission(permission2) != 0) {
            return -8;
        }
        return 0;
    }

    @Override
    public boolean checkShowToOwnerOnly(WindowManager.LayoutParams attrs) {
        switch (attrs.type) {
            default: {
                if ((attrs.privateFlags & 0x10) != 0) break;
                return true;
            }
            case 3: 
            case 2000: 
            case 2001: 
            case 2002: 
            case 2007: 
            case 2008: 
            case 2009: 
            case 2014: 
            case 2017: 
            case 2018: 
            case 2019: 
            case 2020: 
            case 2021: 
            case 2022: 
            case 2024: 
            case 2025: 
            case 2026: 
            case 2027: 
            case 2028: 
            case 2029: 
            case 2030: 
        }
        return this.mContext.checkCallingOrSelfPermission("android.permission.INTERNAL_SYSTEM_WINDOW") != 0;
    }

    @Override
    public void adjustWindowParamsLw(WindowManager.LayoutParams attrs) {
        switch (attrs.type) {
            case 2006: 
            case 2015: {
                attrs.flags |= 0x18;
                attrs.flags &= 0xFFFBFFFF;
                break;
            }
            case 2000: {
                if (!this.mKeyguardHidden) break;
                attrs.flags &= 0xFFEFFFFF;
                attrs.privateFlags &= 0xFFFFFBFF;
            }
        }
        if (attrs.type != 2000) {
            attrs.privateFlags &= 0xFFFFFBFF;
        }
        if (ActivityManager.isHighEndGfx() && (attrs.flags & Integer.MIN_VALUE) != 0) {
            attrs.subtreeSystemUiVisibility |= 0x600;
        }
    }

    void readLidState() {
        this.mLidState = this.mWindowManagerFuncs.getLidState();
    }

    private void readCameraLensCoverState() {
        this.mCameraLensCoverState = this.mWindowManagerFuncs.getCameraLensCoverState();
    }

    private boolean isHidden(int accessibilityMode) {
        switch (accessibilityMode) {
            case 1: {
                return this.mLidState == 0;
            }
            case 2: {
                return this.mLidState == 1;
            }
        }
        return false;
    }

    @Override
    public void adjustConfigurationLw(Configuration config, int keyboardPresence, int navigationPresence) {
        this.mHaveBuiltInKeyboard = (keyboardPresence & 1) != 0;
        this.readConfigurationDependentBehaviors();
        this.readLidState();
        this.applyLidSwitchState();
        if (config.keyboard == 1 || keyboardPresence == 1 && this.isHidden(this.mLidKeyboardAccessibility)) {
            config.hardKeyboardHidden = 2;
            if (!this.mHasSoftInput) {
                config.keyboardHidden = 2;
            }
        }
        if (config.navigation == 1 || navigationPresence == 1 && this.isHidden(this.mLidNavigationAccessibility)) {
            config.navigationHidden = 2;
        }
    }

    @Override
    public int windowTypeToLayerLw(int type) {
        if (type >= 1 && type <= 99) {
            return 2;
        }
        switch (type) {
            case 2025: {
                return 1;
            }
            case 2030: {
                return 2;
            }
            case 2013: {
                return 2;
            }
            case 2002: {
                return 3;
            }
            case 2001: {
                return 4;
            }
            case 2031: {
                return 5;
            }
            case 2008: 
            case 2028: {
                return 6;
            }
            case 2005: {
                return 7;
            }
            case 2007: {
                return 8;
            }
            case 2023: {
                return 9;
            }
            case 2003: {
                return 10;
            }
            case 2011: {
                return 11;
            }
            case 2012: {
                return 12;
            }
            case 2029: {
                return 13;
            }
            case 2017: {
                return 14;
            }
            case 2000: {
                return 15;
            }
            case 2014: {
                return 16;
            }
            case 2009: {
                return 17;
            }
            case 2020: {
                return 18;
            }
            case 2006: {
                return 19;
            }
            case 2019: {
                return 20;
            }
            case 2024: {
                return 21;
            }
            case 2010: {
                return 22;
            }
            case 2027: {
                return 23;
            }
            case 2026: {
                return 24;
            }
            case 2016: {
                return 25;
            }
            case 2015: {
                return 26;
            }
            case 2021: {
                return 27;
            }
            case 2018: {
                return 28;
            }
            case 2022: {
                return 29;
            }
        }
        Log.e(TAG, "Unknown window type: " + type);
        return 2;
    }

    @Override
    public int subWindowTypeToLayerLw(int type) {
        switch (type) {
            case 1000: 
            case 1003: {
                return 1;
            }
            case 1001: {
                return -2;
            }
            case 1004: {
                return -1;
            }
            case 1002: {
                return 2;
            }
        }
        Log.e(TAG, "Unknown sub-window type: " + type);
        return 0;
    }

    @Override
    public int getMaxWallpaperLayer() {
        return this.windowTypeToLayerLw(2000);
    }

    @Override
    public int getAboveUniverseLayer() {
        return this.windowTypeToLayerLw(2010);
    }

    @Override
    public int getNonDecorDisplayWidth(int fullWidth, int fullHeight, int rotation) {
        if (this.mHasNavigationBar && this.mNavigationBarCanMove && fullWidth > fullHeight) {
            return fullWidth - this.mNavigationBarWidthForRotation[rotation];
        }
        return fullWidth;
    }

    @Override
    public int getNonDecorDisplayHeight(int fullWidth, int fullHeight, int rotation) {
        if (this.mHasNavigationBar && (!this.mNavigationBarCanMove || fullWidth < fullHeight)) {
            return fullHeight - this.mNavigationBarHeightForRotation[rotation];
        }
        return fullHeight;
    }

    @Override
    public int getConfigDisplayWidth(int fullWidth, int fullHeight, int rotation) {
        return this.getNonDecorDisplayWidth(fullWidth, fullHeight, rotation);
    }

    @Override
    public int getConfigDisplayHeight(int fullWidth, int fullHeight, int rotation) {
        return this.getNonDecorDisplayHeight(fullWidth, fullHeight, rotation) - this.mStatusBarHeight;
    }

    @Override
    public boolean isForceHiding(WindowManager.LayoutParams attrs) {
        return (attrs.privateFlags & 0x400) != 0 || this.isKeyguardHostWindow(attrs) && this.isKeyguardSecureIncludingHidden() || attrs.type == 2029;
    }

    @Override
    public boolean isKeyguardHostWindow(WindowManager.LayoutParams attrs) {
        return attrs.type == 2000;
    }

    @Override
    public boolean canBeForceHidden(WindowManagerPolicy.WindowState win, WindowManager.LayoutParams attrs) {
        switch (attrs.type) {
            case 2000: 
            case 2013: 
            case 2019: 
            case 2023: 
            case 2025: 
            case 2029: {
                return false;
            }
        }
        return true;
    }

    @Override
    public WindowManagerPolicy.WindowState getWinShowWhenLockedLw() {
        return this.mWinShowWhenLocked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public View addStartingWindow(IBinder appToken, String packageName, int theme, CompatibilityInfo compatInfo, CharSequence nonLocalizedLabel, int labelRes, int icon, int logo, int windowFlags) {
        if (packageName == null) {
            return null;
        }
        WindowManager wm = null;
        View view = null;
        try {
            Window win;
            TypedArray ta;
            Context context = this.mContext;
            if (theme != context.getThemeResId() || labelRes != 0) {
                try {
                    context = context.createPackageContext(packageName, 0);
                    context.setTheme(theme);
                }
                catch (PackageManager.NameNotFoundException e) {
                    // empty catch block
                }
            }
            if ((ta = (win = PolicyManager.makeNewWindow(context)).getWindowStyle()).getBoolean(12, false) || ta.getBoolean(14, false)) {
                View view2 = null;
                return view2;
            }
            Resources r = context.getResources();
            win.setTitle(r.getText(labelRes, nonLocalizedLabel));
            win.setType(3);
            win.setFlags(windowFlags | 0x10 | 8 | 0x20000, windowFlags | 0x10 | 8 | 0x20000);
            win.setDefaultIcon(icon);
            win.setDefaultLogo(logo);
            win.setLayout(-1, -1);
            WindowManager.LayoutParams params = win.getAttributes();
            params.token = appToken;
            params.packageName = packageName;
            params.windowAnimations = win.getWindowStyle().getResourceId(8, 0);
            params.privateFlags |= 1;
            params.privateFlags |= 0x10;
            if (!compatInfo.supportsScreen()) {
                params.privateFlags |= 0x80;
            }
            params.setTitle("Starting " + packageName);
            wm = (WindowManager)context.getSystemService("window");
            view = win.getDecorView();
            if (win.isFloating()) {
                View view3 = null;
                return view3;
            }
            wm.addView(view, params);
            View view4 = view.getParent() != null ? view : null;
            return view4;
        }
        catch (WindowManager.BadTokenException e) {
            Log.w(TAG, appToken + " already running, starting window not displayed. " + e.getMessage());
        }
        catch (RuntimeException e) {
            Log.w(TAG, appToken + " failed creating starting window", e);
        }
        finally {
            if (view != null && view.getParent() == null) {
                Log.w(TAG, "view not successfully added to wm, removing view");
                wm.removeViewImmediate(view);
            }
        }
        return null;
    }

    @Override
    public void removeStartingWindow(IBinder appToken, View window) {
        if (window != null) {
            WindowManager wm = (WindowManager)this.mContext.getSystemService("window");
            wm.removeView(window);
        }
    }

    @Override
    public int prepareAddWindowLw(WindowManagerPolicy.WindowState win, WindowManager.LayoutParams attrs) {
        switch (attrs.type) {
            case 2000: {
                this.mContext.enforceCallingOrSelfPermission("android.permission.STATUS_BAR_SERVICE", "PhoneWindowManager");
                if (this.mStatusBar != null && this.mStatusBar.isAlive()) {
                    return -7;
                }
                this.mStatusBar = win;
                this.mStatusBarController.setWindow(win);
                this.mKeyguardDelegate.hideScrim();
                break;
            }
            case 2019: {
                this.mContext.enforceCallingOrSelfPermission("android.permission.STATUS_BAR_SERVICE", "PhoneWindowManager");
                if (this.mNavigationBar != null && this.mNavigationBar.isAlive()) {
                    return -7;
                }
                this.mNavigationBar = win;
                this.mNavigationBarController.setWindow(win);
                break;
            }
            case 2024: {
                this.mContext.enforceCallingOrSelfPermission("android.permission.STATUS_BAR_SERVICE", "PhoneWindowManager");
                break;
            }
            case 2014: {
                this.mContext.enforceCallingOrSelfPermission("android.permission.STATUS_BAR_SERVICE", "PhoneWindowManager");
                break;
            }
            case 2017: {
                this.mContext.enforceCallingOrSelfPermission("android.permission.STATUS_BAR_SERVICE", "PhoneWindowManager");
                break;
            }
            case 2029: {
                if (this.mKeyguardScrim != null) {
                    return -7;
                }
                this.mKeyguardScrim = win;
            }
        }
        return 0;
    }

    @Override
    public void removeWindowLw(WindowManagerPolicy.WindowState win) {
        if (this.mStatusBar == win) {
            this.mStatusBar = null;
            this.mStatusBarController.setWindow(null);
            this.mKeyguardDelegate.showScrim();
        } else if (this.mKeyguardScrim == win) {
            Log.v(TAG, "Removing keyguard scrim");
            this.mKeyguardScrim = null;
        }
        if (this.mNavigationBar == win) {
            this.mNavigationBar = null;
            this.mNavigationBarController.setWindow(null);
        }
    }

    @Override
    public int selectAnimationLw(WindowManagerPolicy.WindowState win, int transit) {
        if (win == this.mStatusBar) {
            boolean isKeyguard;
            boolean bl = isKeyguard = (win.getAttrs().privateFlags & 0x400) != 0;
            if (transit == 2 || transit == 4) {
                return isKeyguard ? -1 : 17432605;
            }
            if (transit == 1 || transit == 3) {
                return isKeyguard ? -1 : 17432604;
            }
        } else if (win == this.mNavigationBar) {
            if (this.mNavigationBarOnBottom) {
                if (transit == 2 || transit == 4) {
                    return 17432599;
                }
                if (transit == 1 || transit == 3) {
                    return 17432598;
                }
            } else {
                if (transit == 2 || transit == 4) {
                    return 17432603;
                }
                if (transit == 1 || transit == 3) {
                    return 0x10A001A;
                }
            }
        }
        if (transit == 5) {
            if (win.hasAppShownWindows()) {
                return 0x10A0011;
            }
        } else if (win.getAttrs().type == 2023 && this.mDreamingLockscreen && transit == 1) {
            return -1;
        }
        return 0;
    }

    @Override
    public void selectRotationAnimationLw(int[] anim2) {
        if (this.mTopFullscreenOpaqueWindowState != null && this.mTopIsFullscreen) {
            switch (this.mTopFullscreenOpaqueWindowState.getAttrs().rotationAnimation) {
                case 1: {
                    anim2[0] = 17432645;
                    anim2[1] = 17432643;
                    break;
                }
                case 2: {
                    anim2[0] = 17432644;
                    anim2[1] = 17432643;
                    break;
                }
                default: {
                    anim2[1] = 0;
                    anim2[0] = 0;
                    break;
                }
            }
        } else {
            anim2[1] = 0;
            anim2[0] = 0;
        }
    }

    @Override
    public boolean validateRotationAnimationLw(int exitAnimId, int enterAnimId, boolean forceDefault) {
        switch (exitAnimId) {
            case 17432644: 
            case 17432645: {
                if (forceDefault) {
                    return false;
                }
                int[] anim2 = new int[2];
                this.selectRotationAnimationLw(anim2);
                return exitAnimId == anim2[0] && enterAnimId == anim2[1];
            }
        }
        return true;
    }

    @Override
    public Animation createForceHideEnterAnimation(boolean onWallpaper, boolean goingToNotificationShade) {
        if (goingToNotificationShade) {
            return AnimationUtils.loadAnimation(this.mContext, 17432620);
        }
        if (onWallpaper) {
            Animation a = AnimationUtils.loadAnimation(this.mContext, 17432621);
            AnimationSet set = (AnimationSet)a;
            set.getAnimations().get(0).setInterpolator(this.mLogDecelerateInterpolator);
            set.getAnimations().get(1).setInterpolator(this.mLogDecelerateInterpolator);
            return set;
        }
        Animation a = AnimationUtils.loadAnimation(this.mContext, 17432619);
        AnimationSet set = (AnimationSet)a;
        set.getAnimations().get(0).setInterpolator(this.mLogDecelerateInterpolator);
        return set;
    }

    @Override
    public Animation createForceHideWallpaperExitAnimation(boolean goingToNotificationShade) {
        if (goingToNotificationShade) {
            return null;
        }
        return AnimationUtils.loadAnimation(this.mContext, 17432624);
    }

    private static void awakenDreams() {
        IDreamManager dreamManager = PhoneWindowManager.getDreamManager();
        if (dreamManager != null) {
            try {
                dreamManager.awaken();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    static IDreamManager getDreamManager() {
        return IDreamManager.Stub.asInterface(ServiceManager.checkService("dreams"));
    }

    TelecomManager getTelecommService() {
        return (TelecomManager)this.mContext.getSystemService("telecom");
    }

    static IAudioService getAudioService() {
        IAudioService audioService = IAudioService.Stub.asInterface(ServiceManager.checkService("audio"));
        if (audioService == null) {
            Log.w(TAG, "Unable to find IAudioService interface.");
        }
        return audioService;
    }

    boolean keyguardOn() {
        return this.keyguardIsShowingTq() || this.inKeyguardRestrictedKeyInputMode();
    }

    @Override
    public long interceptKeyBeforeDispatching(WindowManagerPolicy.WindowState win, KeyEvent event, int policyFlags) {
        String category;
        Intent shortcutIntent;
        KeyCharacterMap kcm;
        boolean keyguardOn = this.keyguardOn();
        int keyCode = event.getKeyCode();
        int repeatCount = event.getRepeatCount();
        int metaState = event.getMetaState();
        int flags = event.getFlags();
        boolean down = event.getAction() == 0;
        boolean canceled = event.isCanceled();
        if (this.mScreenshotChordEnabled && (flags & 0x400) == 0) {
            long timeoutTime;
            long now;
            if (this.mVolumeDownKeyTriggered && !this.mPowerKeyTriggered && (now = SystemClock.uptimeMillis()) < (timeoutTime = this.mVolumeDownKeyTime + 150L)) {
                return timeoutTime - now;
            }
            if (keyCode == 25 && this.mVolumeDownKeyConsumedByScreenshotChord) {
                if (!down) {
                    this.mVolumeDownKeyConsumedByScreenshotChord = false;
                }
                return -1L;
            }
        }
        if (this.mPendingMetaAction && !KeyEvent.isMetaKey(keyCode)) {
            this.mPendingMetaAction = false;
        }
        if (keyCode == 3) {
            WindowManager.LayoutParams attrs;
            if (!down) {
                this.cancelPreloadRecentApps();
                this.mHomePressed = false;
                if (this.mHomeConsumed) {
                    this.mHomeConsumed = false;
                    return -1L;
                }
                if (canceled) {
                    Log.i(TAG, "Ignoring HOME; event canceled.");
                    return -1L;
                }
                TelecomManager telecomManager = this.getTelecommService();
                if (telecomManager != null && telecomManager.isRinging()) {
                    Log.i(TAG, "Ignoring HOME; there's a ringing incoming call.");
                    return -1L;
                }
                if (this.mDoubleTapOnHomeBehavior != 0) {
                    this.mHandler.removeCallbacks(this.mHomeDoubleTapTimeoutRunnable);
                    this.mHomeDoubleTapPending = true;
                    this.mHandler.postDelayed(this.mHomeDoubleTapTimeoutRunnable, ViewConfiguration.getDoubleTapTimeout());
                    return -1L;
                }
                if (this.mDreamManagerInternal != null && this.mDreamManagerInternal.isDreaming()) {
                    this.mDreamManagerInternal.stopDream(false);
                    return -1L;
                }
                this.launchHomeFromHotKey();
                return -1L;
            }
            WindowManager.LayoutParams layoutParams = attrs = win != null ? win.getAttrs() : null;
            if (attrs != null) {
                int type = attrs.type;
                if (type == 2029 || type == 2009 || (attrs.privateFlags & 0x400) != 0) {
                    return 0L;
                }
                int typeCount = WINDOW_TYPES_WHERE_HOME_DOESNT_WORK.length;
                for (int i = 0; i < typeCount; ++i) {
                    if (type != WINDOW_TYPES_WHERE_HOME_DOESNT_WORK[i]) continue;
                    return -1L;
                }
            }
            if (repeatCount == 0) {
                this.mHomePressed = true;
                if (this.mHomeDoubleTapPending) {
                    this.mHomeDoubleTapPending = false;
                    this.mHandler.removeCallbacks(this.mHomeDoubleTapTimeoutRunnable);
                    this.handleDoubleTapOnHome();
                } else if (this.mLongPressOnHomeBehavior == 1 || this.mDoubleTapOnHomeBehavior == 1) {
                    this.preloadRecentApps();
                }
            } else if ((event.getFlags() & 0x80) != 0 && !keyguardOn) {
                this.handleLongPressOnHome();
            }
            return -1L;
        }
        if (keyCode == 82) {
            boolean chordBug = true;
            if (down && repeatCount == 0 && this.mEnableShiftMenuBugReports && (metaState & 1) == 1) {
                Intent intent = new Intent("android.intent.action.BUG_REPORT");
                this.mContext.sendOrderedBroadcastAsUser(intent, UserHandle.CURRENT, null, null, null, 0, null, null);
                return -1L;
            }
        } else {
            if (keyCode == 84) {
                if (down) {
                    if (repeatCount == 0) {
                        this.mSearchKeyShortcutPending = true;
                        this.mConsumeSearchKeyUp = false;
                    }
                } else {
                    this.mSearchKeyShortcutPending = false;
                    if (this.mConsumeSearchKeyUp) {
                        this.mConsumeSearchKeyUp = false;
                        return -1L;
                    }
                }
                return 0L;
            }
            if (keyCode == 187) {
                if (!keyguardOn) {
                    if (down && repeatCount == 0) {
                        this.preloadRecentApps();
                    } else if (!down) {
                        this.toggleRecentApps();
                    }
                }
                return -1L;
            }
            if (keyCode == 219) {
                if (down) {
                    if (repeatCount == 0) {
                        this.mAssistKeyLongPressed = false;
                    } else if (repeatCount == 1) {
                        this.mAssistKeyLongPressed = true;
                        if (!keyguardOn) {
                            this.launchAssistLongPressAction();
                        }
                    }
                } else if (this.mAssistKeyLongPressed) {
                    this.mAssistKeyLongPressed = false;
                } else if (!keyguardOn) {
                    this.launchAssistAction();
                }
                return -1L;
            }
            if (keyCode == 231) {
                if (!down) {
                    Intent voiceIntent;
                    if (!keyguardOn) {
                        voiceIntent = new Intent("android.speech.action.WEB_SEARCH");
                    } else {
                        voiceIntent = new Intent("android.speech.action.VOICE_SEARCH_HANDS_FREE");
                        voiceIntent.putExtra("android.speech.extras.EXTRA_SECURE", true);
                    }
                    this.mContext.startActivityAsUser(voiceIntent, UserHandle.CURRENT_OR_SELF);
                }
            } else {
                if (keyCode == 120) {
                    if (down && repeatCount == 0) {
                        this.mHandler.post(this.mScreenshotRunnable);
                    }
                    return -1L;
                }
                if (keyCode == 221 || keyCode == 220) {
                    if (down) {
                        int direction = keyCode == 221 ? 1 : -1;
                        int auto = Settings.System.getIntForUser(this.mContext.getContentResolver(), "screen_brightness_mode", 0, -3);
                        if (auto != 0) {
                            Settings.System.putIntForUser(this.mContext.getContentResolver(), "screen_brightness_mode", 0, -3);
                        }
                        int min = this.mPowerManager.getMinimumScreenBrightnessSetting();
                        int max = this.mPowerManager.getMaximumScreenBrightnessSetting();
                        int step = (max - min + 10 - 1) / 10 * direction;
                        int brightness = Settings.System.getIntForUser(this.mContext.getContentResolver(), "screen_brightness", this.mPowerManager.getDefaultScreenBrightnessSetting(), -3);
                        brightness += step;
                        brightness = Math.min(max, brightness);
                        brightness = Math.max(min, brightness);
                        Settings.System.putIntForUser(this.mContext.getContentResolver(), "screen_brightness", brightness, -3);
                        this.mContext.startActivityAsUser(new Intent("android.intent.action.SHOW_BRIGHTNESS_DIALOG"), UserHandle.CURRENT_OR_SELF);
                    }
                    return -1L;
                }
                if (KeyEvent.isMetaKey(keyCode)) {
                    if (down) {
                        this.mPendingMetaAction = true;
                    } else if (this.mPendingMetaAction) {
                        this.launchAssistAction("android.intent.extra.ASSIST_INPUT_HINT_KEYBOARD");
                    }
                    return -1L;
                }
            }
        }
        if (this.mSearchKeyShortcutPending && (kcm = event.getKeyCharacterMap()).isPrintingKey(keyCode)) {
            this.mConsumeSearchKeyUp = true;
            this.mSearchKeyShortcutPending = false;
            if (down && repeatCount == 0 && !keyguardOn) {
                Intent shortcutIntent2 = this.mShortcutManager.getIntent(kcm, keyCode, metaState);
                if (shortcutIntent2 != null) {
                    shortcutIntent2.addFlags(0x10000000);
                    try {
                        this.mContext.startActivityAsUser(shortcutIntent2, UserHandle.CURRENT);
                    }
                    catch (ActivityNotFoundException ex) {
                        Slog.w(TAG, "Dropping shortcut key combination because the activity to which it is registered was not found: SEARCH+" + KeyEvent.keyCodeToString(keyCode), ex);
                    }
                } else {
                    Slog.i(TAG, "Dropping unregistered shortcut key combination: SEARCH+" + KeyEvent.keyCodeToString(keyCode));
                }
            }
            return -1L;
        }
        if (down && repeatCount == 0 && !keyguardOn && (metaState & 0x10000) != 0 && (kcm = event.getKeyCharacterMap()).isPrintingKey(keyCode) && (shortcutIntent = this.mShortcutManager.getIntent(kcm, keyCode, metaState & 0xFFF8FFFF)) != null) {
            shortcutIntent.addFlags(0x10000000);
            try {
                this.mContext.startActivityAsUser(shortcutIntent, UserHandle.CURRENT);
            }
            catch (ActivityNotFoundException ex) {
                Slog.w(TAG, "Dropping shortcut key combination because the activity to which it is registered was not found: META+" + KeyEvent.keyCodeToString(keyCode), ex);
            }
            return -1L;
        }
        if (down && repeatCount == 0 && !keyguardOn && (category = sApplicationLaunchKeyCategories.get(keyCode)) != null) {
            Intent intent = Intent.makeMainSelectorActivity("android.intent.action.MAIN", category);
            intent.setFlags(0x10000000);
            try {
                this.mContext.startActivityAsUser(intent, UserHandle.CURRENT);
            }
            catch (ActivityNotFoundException ex) {
                Slog.w(TAG, "Dropping application launch key because the activity to which it is registered was not found: keyCode=" + keyCode + ", category=" + category, ex);
            }
            return -1L;
        }
        if (down && repeatCount == 0 && keyCode == 61) {
            int shiftlessModifiers;
            if (this.mRecentAppsHeldModifiers == 0 && !keyguardOn && KeyEvent.metaStateHasModifiers(shiftlessModifiers = event.getModifiers() & 0xFFFFFF3E, 2)) {
                this.mRecentAppsHeldModifiers = shiftlessModifiers;
                this.showRecentApps(true);
                return -1L;
            }
        } else if (!down && this.mRecentAppsHeldModifiers != 0 && (metaState & this.mRecentAppsHeldModifiers) == 0) {
            this.mRecentAppsHeldModifiers = 0;
            this.hideRecentApps(true, false);
        }
        if (down && repeatCount == 0 && (keyCode == 204 || keyCode == 62 && (metaState & 0x7000) != 0)) {
            int direction = (metaState & 0xC1) != 0 ? -1 : 1;
            this.mWindowManagerFuncs.switchKeyboardLayout(event.getDeviceId(), direction);
            return -1L;
        }
        if (this.mLanguageSwitchKeyPressed && !down && (keyCode == 204 || keyCode == 62)) {
            this.mLanguageSwitchKeyPressed = false;
            return -1L;
        }
        if (this.mGlobalKeyManager.handleGlobalKey(this.mContext, keyCode, event)) {
            return -1L;
        }
        if ((metaState & 0x10000) != 0) {
            return -1L;
        }
        return 0L;
    }

    @Override
    public KeyEvent dispatchUnhandledKey(WindowManagerPolicy.WindowState win, KeyEvent event, int policyFlags) {
        KeyEvent fallbackEvent = null;
        if ((event.getFlags() & 0x400) == 0) {
            KeyCharacterMap kcm = event.getKeyCharacterMap();
            int keyCode = event.getKeyCode();
            int metaState = event.getMetaState();
            boolean initialDown = event.getAction() == 0 && event.getRepeatCount() == 0;
            KeyCharacterMap.FallbackAction fallbackAction = initialDown ? kcm.getFallbackAction(keyCode, metaState) : this.mFallbackActions.get(keyCode);
            if (fallbackAction != null) {
                int flags = event.getFlags() | 0x400;
                fallbackEvent = KeyEvent.obtain(event.getDownTime(), event.getEventTime(), event.getAction(), fallbackAction.keyCode, event.getRepeatCount(), fallbackAction.metaState, event.getDeviceId(), event.getScanCode(), flags, event.getSource(), null);
                if (!this.interceptFallback(win, fallbackEvent, policyFlags)) {
                    fallbackEvent.recycle();
                    fallbackEvent = null;
                }
                if (initialDown) {
                    this.mFallbackActions.put(keyCode, fallbackAction);
                } else if (event.getAction() == 1) {
                    this.mFallbackActions.remove(keyCode);
                    fallbackAction.recycle();
                }
            }
        }
        return fallbackEvent;
    }

    private boolean interceptFallback(WindowManagerPolicy.WindowState win, KeyEvent fallbackEvent, int policyFlags) {
        long delayMillis;
        int actions = this.interceptKeyBeforeQueueing(fallbackEvent, policyFlags);
        return (actions & 1) != 0 && (delayMillis = this.interceptKeyBeforeDispatching(win, fallbackEvent, policyFlags)) == 0L;
    }

    private void launchAssistLongPressAction() {
        this.performHapticFeedbackLw(null, 0, false);
        this.sendCloseSystemWindows(SYSTEM_DIALOG_REASON_ASSIST);
        Intent intent = new Intent("android.intent.action.SEARCH_LONG_PRESS");
        intent.setFlags(0x10000000);
        try {
            SearchManager searchManager = this.getSearchManager();
            if (searchManager != null) {
                searchManager.stopSearch();
            }
            this.mContext.startActivityAsUser(intent, UserHandle.CURRENT);
        }
        catch (ActivityNotFoundException e) {
            Slog.w(TAG, "No activity to handle assist long press action.", e);
        }
    }

    private void launchAssistAction() {
        this.launchAssistAction(null);
    }

    private void launchAssistAction(String hint) {
        this.sendCloseSystemWindows(SYSTEM_DIALOG_REASON_ASSIST);
        Intent intent = ((SearchManager)this.mContext.getSystemService("search")).getAssistIntent(this.mContext, true, -2);
        if (intent != null) {
            if (hint != null) {
                intent.putExtra(hint, true);
            }
            intent.setFlags(0x34000000);
            try {
                this.mContext.startActivityAsUser(intent, UserHandle.CURRENT);
            }
            catch (ActivityNotFoundException e) {
                Slog.w(TAG, "No activity to handle assist action.", e);
            }
        }
    }

    private SearchManager getSearchManager() {
        if (this.mSearchManager == null) {
            this.mSearchManager = (SearchManager)this.mContext.getSystemService("search");
        }
        return this.mSearchManager;
    }

    private void preloadRecentApps() {
        this.mPreloadedRecentApps = true;
        try {
            IStatusBarService statusbar = this.getStatusBarService();
            if (statusbar != null) {
                statusbar.preloadRecentApps();
            }
        }
        catch (RemoteException e) {
            Slog.e(TAG, "RemoteException when preloading recent apps", e);
            this.mStatusBarService = null;
        }
    }

    private void cancelPreloadRecentApps() {
        if (this.mPreloadedRecentApps) {
            this.mPreloadedRecentApps = false;
            try {
                IStatusBarService statusbar = this.getStatusBarService();
                if (statusbar != null) {
                    statusbar.cancelPreloadRecentApps();
                }
            }
            catch (RemoteException e) {
                Slog.e(TAG, "RemoteException when cancelling recent apps preload", e);
                this.mStatusBarService = null;
            }
        }
    }

    private void toggleRecentApps() {
        this.mPreloadedRecentApps = false;
        try {
            IStatusBarService statusbar = this.getStatusBarService();
            if (statusbar != null) {
                statusbar.toggleRecentApps();
            }
        }
        catch (RemoteException e) {
            Slog.e(TAG, "RemoteException when toggling recent apps", e);
            this.mStatusBarService = null;
        }
    }

    @Override
    public void showRecentApps() {
        this.mHandler.removeMessages(9);
        this.mHandler.sendEmptyMessage(9);
    }

    private void showRecentApps(boolean triggeredFromAltTab) {
        this.mPreloadedRecentApps = false;
        try {
            IStatusBarService statusbar = this.getStatusBarService();
            if (statusbar != null) {
                statusbar.showRecentApps(triggeredFromAltTab);
            }
        }
        catch (RemoteException e) {
            Slog.e(TAG, "RemoteException when showing recent apps", e);
            this.mStatusBarService = null;
        }
    }

    private void hideRecentApps(boolean triggeredFromAltTab, boolean triggeredFromHome) {
        this.mPreloadedRecentApps = false;
        try {
            IStatusBarService statusbar = this.getStatusBarService();
            if (statusbar != null) {
                statusbar.hideRecentApps(triggeredFromAltTab, triggeredFromHome);
            }
        }
        catch (RemoteException e) {
            Slog.e(TAG, "RemoteException when closing recent apps", e);
            this.mStatusBarService = null;
        }
    }

    void launchHomeFromHotKey() {
        if (this.mKeyguardDelegate == null || !this.mKeyguardDelegate.isShowingAndNotOccluded()) {
            if (!this.mHideLockScreen && this.mKeyguardDelegate.isInputRestricted()) {
                this.mKeyguardDelegate.verifyUnlock(new WindowManagerPolicy.OnKeyguardExitResult(){

                    @Override
                    public void onKeyguardExitResult(boolean success) {
                        if (success) {
                            try {
                                ActivityManagerNative.getDefault().stopAppSwitches();
                            }
                            catch (RemoteException remoteException) {
                                // empty catch block
                            }
                            PhoneWindowManager.this.sendCloseSystemWindows(PhoneWindowManager.SYSTEM_DIALOG_REASON_HOME_KEY);
                            PhoneWindowManager.this.startDockOrHome();
                        }
                    }
                });
            } else {
                try {
                    ActivityManagerNative.getDefault().stopAppSwitches();
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                if (this.mRecentsVisible) {
                    PhoneWindowManager.awakenDreams();
                    this.sendCloseSystemWindows(SYSTEM_DIALOG_REASON_HOME_KEY);
                    this.hideRecentApps(false, true);
                } else {
                    this.sendCloseSystemWindows(SYSTEM_DIALOG_REASON_HOME_KEY);
                    this.startDockOrHome();
                }
            }
        }
    }

    @Override
    public int adjustSystemUiVisibilityLw(int visibility) {
        this.mStatusBarController.adjustSystemUiVisibilityLw(this.mLastSystemUiFlags, visibility);
        this.mNavigationBarController.adjustSystemUiVisibilityLw(this.mLastSystemUiFlags, visibility);
        this.mRecentsVisible = (visibility & 0x4000) > 0;
        this.mResettingSystemUiFlags &= visibility;
        return visibility & ~this.mResettingSystemUiFlags & ~this.mForceClearedSystemUiFlags;
    }

    @Override
    public void getContentInsetHintLw(WindowManager.LayoutParams attrs, Rect contentInset) {
        int fl = PolicyControl.getWindowFlags(null, attrs);
        int sysuiVis = PolicyControl.getSystemUiVisibility(null, attrs);
        int systemUiVisibility = sysuiVis | attrs.subtreeSystemUiVisibility;
        if ((fl & 0x10100) == 65792) {
            int availBottom;
            int availRight;
            if (this.canHideNavigationBar() && (systemUiVisibility & 0x200) != 0) {
                availRight = this.mUnrestrictedScreenLeft + this.mUnrestrictedScreenWidth;
                availBottom = this.mUnrestrictedScreenTop + this.mUnrestrictedScreenHeight;
            } else {
                availRight = this.mRestrictedScreenLeft + this.mRestrictedScreenWidth;
                availBottom = this.mRestrictedScreenTop + this.mRestrictedScreenHeight;
            }
            if ((systemUiVisibility & 0x100) != 0) {
                if ((fl & 0x400) != 0) {
                    contentInset.set(this.mStableFullscreenLeft, this.mStableFullscreenTop, availRight - this.mStableFullscreenRight, availBottom - this.mStableFullscreenBottom);
                } else {
                    contentInset.set(this.mStableLeft, this.mStableTop, availRight - this.mStableRight, availBottom - this.mStableBottom);
                }
            } else if ((fl & 0x400) != 0 || (fl & 0x2000000) != 0) {
                contentInset.setEmpty();
            } else if ((systemUiVisibility & 0x404) == 0) {
                contentInset.set(this.mCurLeft, this.mCurTop, availRight - this.mCurRight, availBottom - this.mCurBottom);
            } else {
                contentInset.set(this.mCurLeft, this.mCurTop, availRight - this.mCurRight, availBottom - this.mCurBottom);
            }
            return;
        }
        contentInset.setEmpty();
    }

    @Override
    public void beginLayoutLw(boolean isDefaultDisplay, int displayWidth, int displayHeight, int displayRotation) {
        int overscanBottom;
        int overscanRight;
        int overscanTop;
        int overscanLeft;
        if (isDefaultDisplay) {
            switch (displayRotation) {
                case 1: {
                    overscanLeft = this.mOverscanTop;
                    overscanTop = this.mOverscanRight;
                    overscanRight = this.mOverscanBottom;
                    overscanBottom = this.mOverscanLeft;
                    break;
                }
                case 2: {
                    overscanLeft = this.mOverscanRight;
                    overscanTop = this.mOverscanBottom;
                    overscanRight = this.mOverscanLeft;
                    overscanBottom = this.mOverscanTop;
                    break;
                }
                case 3: {
                    overscanLeft = this.mOverscanBottom;
                    overscanTop = this.mOverscanLeft;
                    overscanRight = this.mOverscanTop;
                    overscanBottom = this.mOverscanRight;
                    break;
                }
                default: {
                    overscanLeft = this.mOverscanLeft;
                    overscanTop = this.mOverscanTop;
                    overscanRight = this.mOverscanRight;
                    overscanBottom = this.mOverscanBottom;
                    break;
                }
            }
        } else {
            overscanLeft = 0;
            overscanTop = 0;
            overscanRight = 0;
            overscanBottom = 0;
        }
        this.mRestrictedOverscanScreenLeft = 0;
        this.mOverscanScreenLeft = 0;
        this.mRestrictedOverscanScreenTop = 0;
        this.mOverscanScreenTop = 0;
        this.mOverscanScreenWidth = this.mRestrictedOverscanScreenWidth = displayWidth;
        this.mOverscanScreenHeight = this.mRestrictedOverscanScreenHeight = displayHeight;
        this.mSystemLeft = 0;
        this.mSystemTop = 0;
        this.mSystemRight = displayWidth;
        this.mSystemBottom = displayHeight;
        this.mUnrestrictedScreenLeft = overscanLeft;
        this.mUnrestrictedScreenTop = overscanTop;
        this.mUnrestrictedScreenWidth = displayWidth - overscanLeft - overscanRight;
        this.mUnrestrictedScreenHeight = displayHeight - overscanTop - overscanBottom;
        this.mRestrictedScreenLeft = this.mUnrestrictedScreenLeft;
        this.mRestrictedScreenTop = this.mUnrestrictedScreenTop;
        this.mRestrictedScreenWidth = this.mSystemGestures.screenWidth = this.mUnrestrictedScreenWidth;
        this.mRestrictedScreenHeight = this.mSystemGestures.screenHeight = this.mUnrestrictedScreenHeight;
        this.mStableFullscreenLeft = this.mCurLeft = this.mUnrestrictedScreenLeft;
        this.mStableLeft = this.mCurLeft;
        this.mVoiceContentLeft = this.mCurLeft;
        this.mContentLeft = this.mCurLeft;
        this.mDockLeft = this.mCurLeft;
        this.mStableFullscreenTop = this.mCurTop = this.mUnrestrictedScreenTop;
        this.mStableTop = this.mCurTop;
        this.mVoiceContentTop = this.mCurTop;
        this.mContentTop = this.mCurTop;
        this.mDockTop = this.mCurTop;
        this.mStableFullscreenRight = this.mCurRight = displayWidth - overscanRight;
        this.mStableRight = this.mCurRight;
        this.mVoiceContentRight = this.mCurRight;
        this.mContentRight = this.mCurRight;
        this.mDockRight = this.mCurRight;
        this.mStableFullscreenBottom = this.mCurBottom = displayHeight - overscanBottom;
        this.mStableBottom = this.mCurBottom;
        this.mVoiceContentBottom = this.mCurBottom;
        this.mContentBottom = this.mCurBottom;
        this.mDockBottom = this.mCurBottom;
        this.mDockLayer = 0x10000000;
        this.mStatusBarLayer = -1;
        Rect pf = mTmpParentFrame;
        Rect df = mTmpDisplayFrame;
        Rect of = mTmpOverscanFrame;
        Rect vf = mTmpVisibleFrame;
        Rect dcf = mTmpDecorFrame;
        of.left = vf.left = this.mDockLeft;
        df.left = vf.left;
        pf.left = vf.left;
        of.top = vf.top = this.mDockTop;
        df.top = vf.top;
        pf.top = vf.top;
        of.right = vf.right = this.mDockRight;
        df.right = vf.right;
        pf.right = vf.right;
        of.bottom = vf.bottom = this.mDockBottom;
        df.bottom = vf.bottom;
        pf.bottom = vf.bottom;
        dcf.setEmpty();
        if (isDefaultDisplay) {
            boolean isKeyguardShowing;
            int sysui = this.mLastSystemUiFlags;
            boolean navVisible = (sysui & 2) == 0;
            boolean navTranslucent = (sysui & 0x80008000) != 0;
            boolean immersive = (sysui & 0x800) != 0;
            boolean immersiveSticky = (sysui & 0x1000) != 0;
            boolean navAllowedHidden = immersive || immersiveSticky;
            navTranslucent &= !immersiveSticky;
            boolean bl = isKeyguardShowing = this.isStatusBarKeyguard() && !this.mHideLockScreen;
            if (!isKeyguardShowing) {
                navTranslucent &= this.areTranslucentBarsAllowed();
            }
            if (navVisible || navAllowedHidden) {
                if (this.mHideNavFakeWindow != null) {
                    this.mHideNavFakeWindow.dismiss();
                    this.mHideNavFakeWindow = null;
                }
            } else if (this.mHideNavFakeWindow == null) {
                this.mHideNavFakeWindow = this.mWindowManagerFuncs.addFakeWindow(this.mHandler.getLooper(), this.mHideNavInputEventReceiverFactory, "hidden nav", 2022, 0, 0, false, false, true);
            }
            navVisible |= !this.canHideNavigationBar();
            boolean updateSysUiVisibility = false;
            if (this.mNavigationBar != null) {
                boolean transientNavBarShowing = this.mNavigationBarController.isTransientShowing();
                boolean bl2 = this.mNavigationBarOnBottom = !this.mNavigationBarCanMove || displayWidth < displayHeight;
                if (this.mNavigationBarOnBottom) {
                    int top = displayHeight - overscanBottom - this.mNavigationBarHeightForRotation[displayRotation];
                    mTmpNavigationFrame.set(0, top, displayWidth, displayHeight - overscanBottom);
                    this.mStableBottom = this.mStableFullscreenBottom = PhoneWindowManager.mTmpNavigationFrame.top;
                    if (transientNavBarShowing) {
                        this.mNavigationBarController.setBarShowingLw(true);
                    } else if (navVisible) {
                        this.mNavigationBarController.setBarShowingLw(true);
                        this.mDockBottom = PhoneWindowManager.mTmpNavigationFrame.top;
                        this.mRestrictedScreenHeight = this.mDockBottom - this.mRestrictedScreenTop;
                        this.mRestrictedOverscanScreenHeight = this.mDockBottom - this.mRestrictedOverscanScreenTop;
                    } else {
                        this.mNavigationBarController.setBarShowingLw(false);
                    }
                    if (!(!navVisible || navTranslucent || navAllowedHidden || this.mNavigationBar.isAnimatingLw() || this.mNavigationBarController.wasRecentlyTranslucent())) {
                        this.mSystemBottom = PhoneWindowManager.mTmpNavigationFrame.top;
                    }
                } else {
                    int left = displayWidth - overscanRight - this.mNavigationBarWidthForRotation[displayRotation];
                    mTmpNavigationFrame.set(left, 0, displayWidth - overscanRight, displayHeight);
                    this.mStableRight = this.mStableFullscreenRight = PhoneWindowManager.mTmpNavigationFrame.left;
                    if (transientNavBarShowing) {
                        this.mNavigationBarController.setBarShowingLw(true);
                    } else if (navVisible) {
                        this.mNavigationBarController.setBarShowingLw(true);
                        this.mDockRight = PhoneWindowManager.mTmpNavigationFrame.left;
                        this.mRestrictedScreenWidth = this.mDockRight - this.mRestrictedScreenLeft;
                        this.mRestrictedOverscanScreenWidth = this.mDockRight - this.mRestrictedOverscanScreenLeft;
                    } else {
                        this.mNavigationBarController.setBarShowingLw(false);
                    }
                    if (navVisible && !navTranslucent && !this.mNavigationBar.isAnimatingLw() && !this.mNavigationBarController.wasRecentlyTranslucent()) {
                        this.mSystemRight = PhoneWindowManager.mTmpNavigationFrame.left;
                    }
                }
                this.mVoiceContentTop = this.mCurTop = this.mDockTop;
                this.mContentTop = this.mCurTop;
                this.mVoiceContentBottom = this.mCurBottom = this.mDockBottom;
                this.mContentBottom = this.mCurBottom;
                this.mVoiceContentLeft = this.mCurLeft = this.mDockLeft;
                this.mContentLeft = this.mCurLeft;
                this.mVoiceContentRight = this.mCurRight = this.mDockRight;
                this.mContentRight = this.mCurRight;
                this.mStatusBarLayer = this.mNavigationBar.getSurfaceLayer();
                this.mNavigationBar.computeFrameLw(mTmpNavigationFrame, mTmpNavigationFrame, mTmpNavigationFrame, mTmpNavigationFrame, mTmpNavigationFrame, dcf, mTmpNavigationFrame);
                if (this.mNavigationBarController.checkHiddenLw()) {
                    updateSysUiVisibility = true;
                }
            }
            if (this.mStatusBar != null) {
                boolean statusBarTranslucent;
                df.left = of.left = this.mUnrestrictedScreenLeft;
                pf.left = of.left;
                df.top = of.top = this.mUnrestrictedScreenTop;
                pf.top = of.top;
                df.right = of.right = this.mUnrestrictedScreenWidth + this.mUnrestrictedScreenLeft;
                pf.right = of.right;
                df.bottom = of.bottom = this.mUnrestrictedScreenHeight + this.mUnrestrictedScreenTop;
                pf.bottom = of.bottom;
                vf.left = this.mStableLeft;
                vf.top = this.mStableTop;
                vf.right = this.mStableRight;
                vf.bottom = this.mStableBottom;
                this.mStatusBarLayer = this.mStatusBar.getSurfaceLayer();
                this.mStatusBar.computeFrameLw(pf, df, vf, vf, vf, dcf, vf);
                this.mStableTop = this.mUnrestrictedScreenTop + this.mStatusBarHeight;
                boolean statusBarTransient = (sysui & 0x4000000) != 0;
                boolean bl3 = statusBarTranslucent = (sysui & 0x40008000) != 0;
                if (!isKeyguardShowing) {
                    statusBarTranslucent &= this.areTranslucentBarsAllowed();
                }
                if (this.mStatusBar.isVisibleLw() && !statusBarTransient) {
                    this.mVoiceContentTop = this.mCurTop = (this.mDockTop = this.mUnrestrictedScreenTop + this.mStatusBarHeight);
                    this.mContentTop = this.mCurTop;
                    this.mVoiceContentBottom = this.mCurBottom = this.mDockBottom;
                    this.mContentBottom = this.mCurBottom;
                    this.mVoiceContentLeft = this.mCurLeft = this.mDockLeft;
                    this.mContentLeft = this.mCurLeft;
                    this.mVoiceContentRight = this.mCurRight = this.mDockRight;
                    this.mContentRight = this.mCurRight;
                }
                if (!(!this.mStatusBar.isVisibleLw() || this.mStatusBar.isAnimatingLw() || statusBarTransient || statusBarTranslucent || this.mStatusBarController.wasRecentlyTranslucent())) {
                    this.mSystemTop = this.mUnrestrictedScreenTop + this.mStatusBarHeight;
                }
                if (this.mStatusBarController.checkHiddenLw()) {
                    updateSysUiVisibility = true;
                }
            }
            if (updateSysUiVisibility) {
                this.updateSystemUiVisibilityLw();
            }
        }
    }

    @Override
    public int getSystemDecorLayerLw() {
        if (this.mStatusBar != null) {
            return this.mStatusBar.getSurfaceLayer();
        }
        if (this.mNavigationBar != null) {
            return this.mNavigationBar.getSurfaceLayer();
        }
        return 0;
    }

    @Override
    public void getContentRectLw(Rect r) {
        r.set(this.mContentLeft, this.mContentTop, this.mContentRight, this.mContentBottom);
    }

    void setAttachedWindowFrames(WindowManagerPolicy.WindowState win, int fl, int adjust, WindowManagerPolicy.WindowState attached, boolean insetDecors, Rect pf, Rect df, Rect of, Rect cf, Rect vf) {
        if (win.getSurfaceLayer() > this.mDockLayer && attached.getSurfaceLayer() < this.mDockLayer) {
            cf.left = vf.left = this.mDockLeft;
            of.left = vf.left;
            df.left = vf.left;
            cf.top = vf.top = this.mDockTop;
            of.top = vf.top;
            df.top = vf.top;
            cf.right = vf.right = this.mDockRight;
            of.right = vf.right;
            df.right = vf.right;
            cf.bottom = vf.bottom = this.mDockBottom;
            of.bottom = vf.bottom;
            df.bottom = vf.bottom;
        } else {
            if (adjust != 16) {
                cf.set(attached.getOverscanFrameLw());
            } else {
                cf.set(attached.getContentFrameLw());
                if (attached.isVoiceInteraction()) {
                    if (cf.left < this.mVoiceContentLeft) {
                        cf.left = this.mVoiceContentLeft;
                    }
                    if (cf.top < this.mVoiceContentTop) {
                        cf.top = this.mVoiceContentTop;
                    }
                    if (cf.right > this.mVoiceContentRight) {
                        cf.right = this.mVoiceContentRight;
                    }
                    if (cf.bottom > this.mVoiceContentBottom) {
                        cf.bottom = this.mVoiceContentBottom;
                    }
                } else if (attached.getSurfaceLayer() < this.mDockLayer) {
                    if (cf.left < this.mContentLeft) {
                        cf.left = this.mContentLeft;
                    }
                    if (cf.top < this.mContentTop) {
                        cf.top = this.mContentTop;
                    }
                    if (cf.right > this.mContentRight) {
                        cf.right = this.mContentRight;
                    }
                    if (cf.bottom > this.mContentBottom) {
                        cf.bottom = this.mContentBottom;
                    }
                }
            }
            df.set(insetDecors ? attached.getDisplayFrameLw() : cf);
            of.set(insetDecors ? attached.getOverscanFrameLw() : cf);
            vf.set(attached.getVisibleFrameLw());
        }
        pf.set((fl & 0x100) == 0 ? attached.getFrameLw() : df);
    }

    private void applyStableConstraints(int sysui, int fl, Rect r) {
        if ((sysui & 0x100) != 0) {
            if ((fl & 0x400) != 0) {
                if (r.left < this.mStableFullscreenLeft) {
                    r.left = this.mStableFullscreenLeft;
                }
                if (r.top < this.mStableFullscreenTop) {
                    r.top = this.mStableFullscreenTop;
                }
                if (r.right > this.mStableFullscreenRight) {
                    r.right = this.mStableFullscreenRight;
                }
                if (r.bottom > this.mStableFullscreenBottom) {
                    r.bottom = this.mStableFullscreenBottom;
                }
            } else {
                if (r.left < this.mStableLeft) {
                    r.left = this.mStableLeft;
                }
                if (r.top < this.mStableTop) {
                    r.top = this.mStableTop;
                }
                if (r.right > this.mStableRight) {
                    r.right = this.mStableRight;
                }
                if (r.bottom > this.mStableBottom) {
                    r.bottom = this.mStableBottom;
                }
            }
        }
    }

    @Override
    public void layoutWindowLw(WindowManagerPolicy.WindowState win, WindowManagerPolicy.WindowState attached) {
        boolean needsToOffsetInputMethodTarget;
        WindowManager.LayoutParams attrs = win.getAttrs();
        if (win == this.mStatusBar && (attrs.privateFlags & 0x400) == 0 || win == this.mNavigationBar) {
            return;
        }
        boolean isDefaultDisplay = win.isDefaultDisplay();
        boolean bl = needsToOffsetInputMethodTarget = isDefaultDisplay && win == this.mLastInputMethodTargetWindow && this.mLastInputMethodWindow != null;
        if (needsToOffsetInputMethodTarget) {
            this.offsetInputMethodWindowLw(this.mLastInputMethodWindow);
        }
        int fl = PolicyControl.getWindowFlags(win, attrs);
        int sim = attrs.softInputMode;
        int sysUiFl = PolicyControl.getSystemUiVisibility(win, null);
        Rect pf = mTmpParentFrame;
        Rect df = mTmpDisplayFrame;
        Rect of = mTmpOverscanFrame;
        Rect cf = mTmpContentFrame;
        Rect vf = mTmpVisibleFrame;
        Rect dcf = mTmpDecorFrame;
        Rect sf = mTmpStableFrame;
        dcf.setEmpty();
        boolean hasNavBar = isDefaultDisplay && this.mHasNavigationBar && this.mNavigationBar != null && this.mNavigationBar.isVisibleLw();
        int adjust = sim & 0xF0;
        if (isDefaultDisplay) {
            sf.set(this.mStableLeft, this.mStableTop, this.mStableRight, this.mStableBottom);
        } else {
            sf.set(this.mOverscanLeft, this.mOverscanTop, this.mOverscanRight, this.mOverscanBottom);
        }
        if (!isDefaultDisplay) {
            if (attached != null) {
                this.setAttachedWindowFrames(win, fl, adjust, attached, true, pf, df, of, cf, vf);
            } else {
                of.left = cf.left = this.mOverscanScreenLeft;
                df.left = cf.left;
                pf.left = cf.left;
                of.top = cf.top = this.mOverscanScreenTop;
                df.top = cf.top;
                pf.top = cf.top;
                of.right = cf.right = this.mOverscanScreenLeft + this.mOverscanScreenWidth;
                df.right = cf.right;
                pf.right = cf.right;
                of.bottom = cf.bottom = this.mOverscanScreenTop + this.mOverscanScreenHeight;
                df.bottom = cf.bottom;
                pf.bottom = cf.bottom;
            }
        } else if (attrs.type == 2011) {
            cf.left = vf.left = this.mDockLeft;
            of.left = vf.left;
            df.left = vf.left;
            pf.left = vf.left;
            cf.top = vf.top = this.mDockTop;
            of.top = vf.top;
            df.top = vf.top;
            pf.top = vf.top;
            cf.right = vf.right = this.mDockRight;
            of.right = vf.right;
            df.right = vf.right;
            pf.right = vf.right;
            df.bottom = of.bottom = this.mUnrestrictedScreenTop + this.mUnrestrictedScreenHeight;
            pf.bottom = of.bottom;
            cf.bottom = vf.bottom = this.mStableBottom;
            attrs.gravity = 80;
            this.mDockLayer = win.getSurfaceLayer();
        } else if (win == this.mStatusBar && (attrs.privateFlags & 0x400) != 0) {
            df.left = of.left = this.mUnrestrictedScreenLeft;
            pf.left = of.left;
            df.top = of.top = this.mUnrestrictedScreenTop;
            pf.top = of.top;
            df.right = of.right = this.mUnrestrictedScreenWidth + this.mUnrestrictedScreenLeft;
            pf.right = of.right;
            df.bottom = of.bottom = this.mUnrestrictedScreenHeight + this.mUnrestrictedScreenTop;
            pf.bottom = of.bottom;
            cf.left = vf.left = this.mStableLeft;
            cf.top = vf.top = this.mStableTop;
            cf.right = vf.right = this.mStableRight;
            vf.bottom = this.mStableBottom;
            cf.bottom = this.mContentBottom;
        } else {
            boolean topAtRest;
            dcf.left = this.mSystemLeft;
            dcf.top = this.mSystemTop;
            dcf.right = this.mSystemRight;
            dcf.bottom = this.mSystemBottom;
            boolean inheritTranslucentDecor = (attrs.privateFlags & 0x200) != 0;
            boolean isAppWindow = attrs.type >= 1 && attrs.type <= 99;
            boolean bl2 = topAtRest = win == this.mTopFullscreenOpaqueWindowState && !win.isAnimatingLw();
            if (isAppWindow && !inheritTranslucentDecor && !topAtRest) {
                if ((sysUiFl & 4) == 0 && (fl & 0x400) == 0 && (fl & 0x4000000) == 0 && (fl & Integer.MIN_VALUE) == 0) {
                    dcf.top = this.mStableTop;
                }
                if ((fl & 0x8000000) == 0 && (sysUiFl & 2) == 0 && (fl & Integer.MIN_VALUE) == 0) {
                    dcf.bottom = this.mStableBottom;
                    dcf.right = this.mStableRight;
                }
            }
            if ((fl & 0x10100) == 65792) {
                if (attached != null) {
                    this.setAttachedWindowFrames(win, fl, adjust, attached, true, pf, df, of, cf, vf);
                } else {
                    if (attrs.type == 2014 || attrs.type == 2017) {
                        of.left = hasNavBar ? this.mDockLeft : this.mUnrestrictedScreenLeft;
                        df.left = of.left;
                        pf.left = of.left;
                        df.top = of.top = this.mUnrestrictedScreenTop;
                        pf.top = of.top;
                        of.right = hasNavBar ? this.mRestrictedScreenLeft + this.mRestrictedScreenWidth : this.mUnrestrictedScreenLeft + this.mUnrestrictedScreenWidth;
                        df.right = of.right;
                        pf.right = of.right;
                        of.bottom = hasNavBar ? this.mRestrictedScreenTop + this.mRestrictedScreenHeight : this.mUnrestrictedScreenTop + this.mUnrestrictedScreenHeight;
                        df.bottom = of.bottom;
                        pf.bottom = of.bottom;
                    } else if ((fl & 0x2000000) != 0 && attrs.type >= 1 && attrs.type <= 1999) {
                        df.left = of.left = this.mOverscanScreenLeft;
                        pf.left = of.left;
                        df.top = of.top = this.mOverscanScreenTop;
                        pf.top = of.top;
                        df.right = of.right = this.mOverscanScreenLeft + this.mOverscanScreenWidth;
                        pf.right = of.right;
                        df.bottom = of.bottom = this.mOverscanScreenTop + this.mOverscanScreenHeight;
                        pf.bottom = of.bottom;
                    } else if (this.canHideNavigationBar() && (sysUiFl & 0x200) != 0 && attrs.type >= 1 && attrs.type <= 1999) {
                        pf.left = df.left = this.mOverscanScreenLeft;
                        pf.top = df.top = this.mOverscanScreenTop;
                        pf.right = df.right = this.mOverscanScreenLeft + this.mOverscanScreenWidth;
                        pf.bottom = df.bottom = this.mOverscanScreenTop + this.mOverscanScreenHeight;
                        of.left = this.mUnrestrictedScreenLeft;
                        of.top = this.mUnrestrictedScreenTop;
                        of.right = this.mUnrestrictedScreenLeft + this.mUnrestrictedScreenWidth;
                        of.bottom = this.mUnrestrictedScreenTop + this.mUnrestrictedScreenHeight;
                    } else {
                        pf.left = df.left = this.mRestrictedOverscanScreenLeft;
                        pf.top = df.top = this.mRestrictedOverscanScreenTop;
                        pf.right = df.right = this.mRestrictedOverscanScreenLeft + this.mRestrictedOverscanScreenWidth;
                        pf.bottom = df.bottom = this.mRestrictedOverscanScreenTop + this.mRestrictedOverscanScreenHeight;
                        of.left = this.mUnrestrictedScreenLeft;
                        of.top = this.mUnrestrictedScreenTop;
                        of.right = this.mUnrestrictedScreenLeft + this.mUnrestrictedScreenWidth;
                        of.bottom = this.mUnrestrictedScreenTop + this.mUnrestrictedScreenHeight;
                    }
                    if ((fl & 0x400) == 0) {
                        if (win.isVoiceInteraction()) {
                            cf.left = this.mVoiceContentLeft;
                            cf.top = this.mVoiceContentTop;
                            cf.right = this.mVoiceContentRight;
                            cf.bottom = this.mVoiceContentBottom;
                        } else if (adjust != 16) {
                            cf.left = this.mDockLeft;
                            cf.top = this.mDockTop;
                            cf.right = this.mDockRight;
                            cf.bottom = this.mDockBottom;
                        } else {
                            cf.left = this.mContentLeft;
                            cf.top = this.mContentTop;
                            cf.right = this.mContentRight;
                            cf.bottom = this.mContentBottom;
                        }
                    } else {
                        cf.left = this.mRestrictedScreenLeft;
                        cf.top = this.mRestrictedScreenTop;
                        cf.right = this.mRestrictedScreenLeft + this.mRestrictedScreenWidth;
                        cf.bottom = this.mRestrictedScreenTop + this.mRestrictedScreenHeight;
                    }
                    this.applyStableConstraints(sysUiFl, fl, cf);
                    if (adjust != 48) {
                        vf.left = this.mCurLeft;
                        vf.top = this.mCurTop;
                        vf.right = this.mCurRight;
                        vf.bottom = this.mCurBottom;
                    } else {
                        vf.set(cf);
                    }
                }
            } else if ((fl & 0x100) != 0 || (sysUiFl & 0x600) != 0) {
                if (attrs.type == 2014 || attrs.type == 2017) {
                    cf.left = hasNavBar ? this.mDockLeft : this.mUnrestrictedScreenLeft;
                    of.left = cf.left;
                    df.left = cf.left;
                    pf.left = cf.left;
                    of.top = cf.top = this.mUnrestrictedScreenTop;
                    df.top = cf.top;
                    pf.top = cf.top;
                    cf.right = hasNavBar ? this.mRestrictedScreenLeft + this.mRestrictedScreenWidth : this.mUnrestrictedScreenLeft + this.mUnrestrictedScreenWidth;
                    of.right = cf.right;
                    df.right = cf.right;
                    pf.right = cf.right;
                    cf.bottom = hasNavBar ? this.mRestrictedScreenTop + this.mRestrictedScreenHeight : this.mUnrestrictedScreenTop + this.mUnrestrictedScreenHeight;
                    of.bottom = cf.bottom;
                    df.bottom = cf.bottom;
                    pf.bottom = cf.bottom;
                } else if (attrs.type == 2019 || attrs.type == 2024) {
                    df.left = of.left = this.mUnrestrictedScreenLeft;
                    pf.left = of.left;
                    df.top = of.top = this.mUnrestrictedScreenTop;
                    pf.top = of.top;
                    df.right = of.right = this.mUnrestrictedScreenLeft + this.mUnrestrictedScreenWidth;
                    pf.right = of.right;
                    df.bottom = of.bottom = this.mUnrestrictedScreenTop + this.mUnrestrictedScreenHeight;
                    pf.bottom = of.bottom;
                } else if ((attrs.type == 2015 || attrs.type == 2021) && (fl & 0x400) != 0) {
                    of.left = cf.left = this.mOverscanScreenLeft;
                    df.left = cf.left;
                    pf.left = cf.left;
                    of.top = cf.top = this.mOverscanScreenTop;
                    df.top = cf.top;
                    pf.top = cf.top;
                    of.right = cf.right = this.mOverscanScreenLeft + this.mOverscanScreenWidth;
                    df.right = cf.right;
                    pf.right = cf.right;
                    of.bottom = cf.bottom = this.mOverscanScreenTop + this.mOverscanScreenHeight;
                    df.bottom = cf.bottom;
                    pf.bottom = cf.bottom;
                } else if (attrs.type == 2021 || attrs.type == 2025) {
                    of.left = cf.left = this.mOverscanScreenLeft;
                    df.left = cf.left;
                    pf.left = cf.left;
                    of.top = cf.top = this.mOverscanScreenTop;
                    df.top = cf.top;
                    pf.top = cf.top;
                    of.right = cf.right = this.mOverscanScreenLeft + this.mOverscanScreenWidth;
                    df.right = cf.right;
                    pf.right = cf.right;
                    of.bottom = cf.bottom = this.mOverscanScreenTop + this.mOverscanScreenHeight;
                    df.bottom = cf.bottom;
                    pf.bottom = cf.bottom;
                } else if (attrs.type == 2013) {
                    pf.left = df.left = this.mOverscanScreenLeft;
                    pf.top = df.top = this.mOverscanScreenTop;
                    pf.right = df.right = this.mOverscanScreenLeft + this.mOverscanScreenWidth;
                    pf.bottom = df.bottom = this.mOverscanScreenTop + this.mOverscanScreenHeight;
                    of.left = cf.left = this.mUnrestrictedScreenLeft;
                    of.top = cf.top = this.mUnrestrictedScreenTop;
                    of.right = cf.right = this.mUnrestrictedScreenLeft + this.mUnrestrictedScreenWidth;
                    of.bottom = cf.bottom = this.mUnrestrictedScreenTop + this.mUnrestrictedScreenHeight;
                } else if ((fl & 0x2000000) != 0 && attrs.type >= 1 && attrs.type <= 1999) {
                    of.left = cf.left = this.mOverscanScreenLeft;
                    df.left = cf.left;
                    pf.left = cf.left;
                    of.top = cf.top = this.mOverscanScreenTop;
                    df.top = cf.top;
                    pf.top = cf.top;
                    of.right = cf.right = this.mOverscanScreenLeft + this.mOverscanScreenWidth;
                    df.right = cf.right;
                    pf.right = cf.right;
                    of.bottom = cf.bottom = this.mOverscanScreenTop + this.mOverscanScreenHeight;
                    df.bottom = cf.bottom;
                    pf.bottom = cf.bottom;
                } else if (this.canHideNavigationBar() && (sysUiFl & 0x200) != 0 && (attrs.type == 2000 || attrs.type == 2005 || attrs.type >= 1 && attrs.type <= 1999)) {
                    of.left = cf.left = this.mUnrestrictedScreenLeft;
                    df.left = cf.left;
                    pf.left = cf.left;
                    of.top = cf.top = this.mUnrestrictedScreenTop;
                    df.top = cf.top;
                    pf.top = cf.top;
                    of.right = cf.right = this.mUnrestrictedScreenLeft + this.mUnrestrictedScreenWidth;
                    df.right = cf.right;
                    pf.right = cf.right;
                    of.bottom = cf.bottom = this.mUnrestrictedScreenTop + this.mUnrestrictedScreenHeight;
                    df.bottom = cf.bottom;
                    pf.bottom = cf.bottom;
                } else {
                    of.left = cf.left = this.mRestrictedScreenLeft;
                    df.left = cf.left;
                    pf.left = cf.left;
                    of.top = cf.top = this.mRestrictedScreenTop;
                    df.top = cf.top;
                    pf.top = cf.top;
                    of.right = cf.right = this.mRestrictedScreenLeft + this.mRestrictedScreenWidth;
                    df.right = cf.right;
                    pf.right = cf.right;
                    of.bottom = cf.bottom = this.mRestrictedScreenTop + this.mRestrictedScreenHeight;
                    df.bottom = cf.bottom;
                    pf.bottom = cf.bottom;
                }
                this.applyStableConstraints(sysUiFl, fl, cf);
                if (adjust != 48) {
                    vf.left = this.mCurLeft;
                    vf.top = this.mCurTop;
                    vf.right = this.mCurRight;
                    vf.bottom = this.mCurBottom;
                } else {
                    vf.set(cf);
                }
            } else if (attached != null) {
                this.setAttachedWindowFrames(win, fl, adjust, attached, false, pf, df, of, cf, vf);
            } else if (attrs.type == 2014) {
                of.left = cf.left = this.mRestrictedScreenLeft;
                df.left = cf.left;
                pf.left = cf.left;
                of.top = cf.top = this.mRestrictedScreenTop;
                df.top = cf.top;
                pf.top = cf.top;
                of.right = cf.right = this.mRestrictedScreenLeft + this.mRestrictedScreenWidth;
                df.right = cf.right;
                pf.right = cf.right;
                of.bottom = cf.bottom = this.mRestrictedScreenTop + this.mRestrictedScreenHeight;
                df.bottom = cf.bottom;
                pf.bottom = cf.bottom;
            } else if (attrs.type == 2005 || attrs.type == 2003 || attrs.type == 2020) {
                of.left = cf.left = this.mStableLeft;
                df.left = cf.left;
                pf.left = cf.left;
                of.top = cf.top = this.mStableTop;
                df.top = cf.top;
                pf.top = cf.top;
                of.right = cf.right = this.mStableRight;
                df.right = cf.right;
                pf.right = cf.right;
                of.bottom = cf.bottom = this.mStableBottom;
                df.bottom = cf.bottom;
                pf.bottom = cf.bottom;
            } else {
                pf.left = this.mContentLeft;
                pf.top = this.mContentTop;
                pf.right = this.mContentRight;
                pf.bottom = this.mContentBottom;
                if (win.isVoiceInteraction()) {
                    of.left = cf.left = this.mVoiceContentLeft;
                    df.left = cf.left;
                    of.top = cf.top = this.mVoiceContentTop;
                    df.top = cf.top;
                    of.right = cf.right = this.mVoiceContentRight;
                    df.right = cf.right;
                    of.bottom = cf.bottom = this.mVoiceContentBottom;
                    df.bottom = cf.bottom;
                } else if (adjust != 16) {
                    of.left = cf.left = this.mDockLeft;
                    df.left = cf.left;
                    of.top = cf.top = this.mDockTop;
                    df.top = cf.top;
                    of.right = cf.right = this.mDockRight;
                    df.right = cf.right;
                    of.bottom = cf.bottom = this.mDockBottom;
                    df.bottom = cf.bottom;
                } else {
                    of.left = cf.left = this.mContentLeft;
                    df.left = cf.left;
                    of.top = cf.top = this.mContentTop;
                    df.top = cf.top;
                    of.right = cf.right = this.mContentRight;
                    df.right = cf.right;
                    of.bottom = cf.bottom = this.mContentBottom;
                    df.bottom = cf.bottom;
                }
                if (adjust != 48) {
                    vf.left = this.mCurLeft;
                    vf.top = this.mCurTop;
                    vf.right = this.mCurRight;
                    vf.bottom = this.mCurBottom;
                } else {
                    vf.set(cf);
                }
            }
        }
        if ((fl & 0x200) != 0 && attrs.type != 2010) {
            df.top = -10000;
            df.left = -10000;
            df.bottom = 10000;
            df.right = 10000;
            if (attrs.type != 2013) {
                vf.top = -10000;
                vf.left = -10000;
                cf.top = -10000;
                cf.left = -10000;
                of.top = -10000;
                of.left = -10000;
                vf.bottom = 10000;
                vf.right = 10000;
                cf.bottom = 10000;
                cf.right = 10000;
                of.bottom = 10000;
                of.right = 10000;
            }
        }
        win.computeFrameLw(pf, df, of, cf, vf, dcf, sf);
        if (attrs.type == 2011 && win.isVisibleOrBehindKeyguardLw() && !win.getGivenInsetsPendingLw()) {
            this.setLastInputMethodWindowLw(null, null);
            this.offsetInputMethodWindowLw(win);
        }
        if (attrs.type == 2031 && win.isVisibleOrBehindKeyguardLw() && !win.getGivenInsetsPendingLw()) {
            this.offsetVoiceInputWindowLw(win);
        }
    }

    private void offsetInputMethodWindowLw(WindowManagerPolicy.WindowState win) {
        int top = win.getContentFrameLw().top;
        if (this.mContentBottom > (top += win.getGivenContentInsetsLw().top)) {
            this.mContentBottom = top;
        }
        if (this.mVoiceContentBottom > top) {
            this.mVoiceContentBottom = top;
        }
        top = win.getVisibleFrameLw().top;
        if (this.mCurBottom > (top += win.getGivenVisibleInsetsLw().top)) {
            this.mCurBottom = top;
        }
    }

    private void offsetVoiceInputWindowLw(WindowManagerPolicy.WindowState win) {
        int gravity = win.getAttrs().gravity;
        switch (gravity & 6) {
            case 2: {
                int right = win.getContentFrameLw().right - win.getGivenContentInsetsLw().right;
                if (this.mVoiceContentLeft >= right) break;
                this.mVoiceContentLeft = right;
                break;
            }
            case 4: {
                int left = win.getContentFrameLw().left - win.getGivenContentInsetsLw().left;
                if (this.mVoiceContentRight >= left) break;
                this.mVoiceContentRight = left;
            }
        }
        switch (gravity & 0x60) {
            case 32: {
                int bottom = win.getContentFrameLw().bottom - win.getGivenContentInsetsLw().bottom;
                if (this.mVoiceContentTop >= bottom) break;
                this.mVoiceContentTop = bottom;
                break;
            }
            case 64: {
                int top = win.getContentFrameLw().top - win.getGivenContentInsetsLw().top;
                if (this.mVoiceContentBottom >= top) break;
                this.mVoiceContentBottom = top;
            }
        }
    }

    @Override
    public void finishLayoutLw() {
    }

    @Override
    public void beginPostLayoutPolicyLw(int displayWidth, int displayHeight) {
        this.mTopFullscreenOpaqueWindowState = null;
        this.mAppsToBeHidden.clear();
        this.mAppsThatDismissKeyguard.clear();
        this.mForceStatusBar = false;
        this.mForceStatusBarFromKeyguard = false;
        this.mForcingShowNavBar = false;
        this.mForcingShowNavBarLayer = -1;
        this.mHideLockScreen = false;
        this.mAllowLockscreenWhenOn = false;
        this.mDismissKeyguard = 0;
        this.mShowingLockscreen = false;
        this.mShowingDream = false;
        this.mWinShowWhenLocked = null;
    }

    @Override
    public void applyPostLayoutPolicyLw(WindowManagerPolicy.WindowState win, WindowManager.LayoutParams attrs) {
        int fl = PolicyControl.getWindowFlags(win, attrs);
        if (this.mTopFullscreenOpaqueWindowState == null && win.isVisibleLw() && attrs.type == 2011) {
            this.mForcingShowNavBar = true;
            this.mForcingShowNavBarLayer = win.getSurfaceLayer();
        }
        if (attrs.type == 2000 && (attrs.privateFlags & 0x400) != 0) {
            this.mForceStatusBarFromKeyguard = true;
        }
        if (this.mTopFullscreenOpaqueWindowState == null && win.isVisibleOrBehindKeyguardLw() && !win.isGoneForLayoutLw()) {
            boolean appWindow;
            if ((fl & 0x800) != 0) {
                if ((attrs.privateFlags & 0x400) != 0) {
                    this.mForceStatusBarFromKeyguard = true;
                } else {
                    this.mForceStatusBar = true;
                }
            }
            if ((attrs.privateFlags & 0x400) != 0) {
                this.mShowingLockscreen = true;
            }
            boolean bl = appWindow = attrs.type >= 1 && attrs.type < 2000;
            if (attrs.type == 2023 && (!this.mDreamingLockscreen || win.isVisibleLw() && win.hasDrawnLw())) {
                this.mShowingDream = true;
                appWindow = true;
            }
            boolean showWhenLocked = (fl & 0x80000) != 0;
            boolean dismissKeyguard = (fl & 0x400000) != 0;
            boolean secureKeyguard = this.isKeyguardSecure();
            if (appWindow) {
                IApplicationToken appToken = win.getAppToken();
                if (showWhenLocked) {
                    this.mAppsToBeHidden.remove(appToken);
                    this.mAppsThatDismissKeyguard.remove(appToken);
                    if (this.mAppsToBeHidden.isEmpty() && this.isKeyguardSecureIncludingHidden()) {
                        this.mWinShowWhenLocked = win;
                        this.mHideLockScreen = true;
                        this.mForceStatusBarFromKeyguard = false;
                    }
                } else if (dismissKeyguard) {
                    if (secureKeyguard) {
                        this.mAppsToBeHidden.add(appToken);
                    } else {
                        this.mAppsToBeHidden.remove(appToken);
                    }
                    this.mAppsThatDismissKeyguard.add(appToken);
                } else {
                    this.mAppsToBeHidden.add(appToken);
                }
                if (attrs.x == 0 && attrs.y == 0 && attrs.width == -1 && attrs.height == -1) {
                    this.mTopFullscreenOpaqueWindowState = win;
                    if (!this.mAppsThatDismissKeyguard.isEmpty() && this.mDismissKeyguard == 0) {
                        this.mDismissKeyguard = this.mWinDismissingKeyguard == win ? 2 : 1;
                        this.mWinDismissingKeyguard = win;
                        this.mForceStatusBarFromKeyguard = this.mShowingLockscreen && secureKeyguard;
                    } else if (this.mAppsToBeHidden.isEmpty() && showWhenLocked) {
                        this.mHideLockScreen = true;
                        this.mForceStatusBarFromKeyguard = false;
                    }
                    if ((fl & 1) != 0) {
                        this.mAllowLockscreenWhenOn = true;
                    }
                }
                if (this.mWinShowWhenLocked != null && this.mWinShowWhenLocked.getAppToken() != win.getAppToken()) {
                    win.hideLw(false);
                }
            }
        }
    }

    @Override
    public int finishPostLayoutPolicyLw() {
        WindowManager.LayoutParams lp;
        if (this.mWinShowWhenLocked != null && this.mWinShowWhenLocked != this.mTopFullscreenOpaqueWindowState) {
            this.mWinShowWhenLocked.getAttrs().flags |= 0x100000;
            this.mTopFullscreenOpaqueWindowState.hideLw(false);
            this.mTopFullscreenOpaqueWindowState = this.mWinShowWhenLocked;
        }
        int changes = 0;
        boolean topIsFullscreen = false;
        WindowManager.LayoutParams layoutParams = lp = this.mTopFullscreenOpaqueWindowState != null ? this.mTopFullscreenOpaqueWindowState.getAttrs() : null;
        if (!this.mShowingDream) {
            this.mDreamingLockscreen = this.mShowingLockscreen;
        }
        if (this.mStatusBar != null) {
            if (this.mForceStatusBar || this.mForceStatusBarFromKeyguard) {
                if (this.mStatusBarController.setBarShowingLw(true)) {
                    changes |= 1;
                }
                boolean bl = topIsFullscreen = this.mTopIsFullscreen && this.mStatusBar.isAnimatingLw();
                if (this.mForceStatusBarFromKeyguard && this.mStatusBarController.isTransientShowing()) {
                    this.mStatusBarController.updateVisibilityLw(false, this.mLastSystemUiFlags, this.mLastSystemUiFlags);
                }
            } else if (this.mTopFullscreenOpaqueWindowState != null) {
                int fl = PolicyControl.getWindowFlags(null, lp);
                boolean bl = topIsFullscreen = (fl & 0x400) != 0 || (this.mLastSystemUiFlags & 4) != 0;
                if (this.mStatusBarController.isTransientShowing()) {
                    if (this.mStatusBarController.setBarShowingLw(true)) {
                        changes |= 1;
                    }
                } else if (topIsFullscreen) {
                    if (this.mStatusBarController.setBarShowingLw(false)) {
                        changes |= 1;
                    }
                } else if (this.mStatusBarController.setBarShowingLw(true)) {
                    changes |= 1;
                }
            }
        }
        if (this.mTopIsFullscreen != topIsFullscreen) {
            if (!topIsFullscreen) {
                changes |= 1;
            }
            this.mTopIsFullscreen = topIsFullscreen;
        }
        if (this.mKeyguardDelegate != null && this.mStatusBar != null) {
            if (this.mDismissKeyguard != 0 && !this.isKeyguardSecure()) {
                this.mKeyguardHidden = true;
                if (this.processKeyguardSetHiddenResultLw(this.mKeyguardDelegate.setOccluded(true))) {
                    changes |= 7;
                }
                if (this.mKeyguardDelegate.isShowing()) {
                    this.mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            PhoneWindowManager.this.mKeyguardDelegate.keyguardDone(false, false);
                        }
                    });
                }
            } else if (this.mHideLockScreen) {
                this.mKeyguardHidden = true;
                if (this.processKeyguardSetHiddenResultLw(this.mKeyguardDelegate.setOccluded(true))) {
                    changes |= 7;
                }
            } else if (this.mDismissKeyguard != 0) {
                if (this.mDismissKeyguard == 1) {
                    this.mKeyguardHidden = false;
                    if (this.processKeyguardSetHiddenResultLw(this.mKeyguardDelegate.setOccluded(false))) {
                        changes |= 7;
                    }
                    this.mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            PhoneWindowManager.this.mKeyguardDelegate.dismiss();
                        }
                    });
                }
            } else {
                this.mWinDismissingKeyguard = null;
                this.mKeyguardHidden = false;
                if (this.processKeyguardSetHiddenResultLw(this.mKeyguardDelegate.setOccluded(false))) {
                    changes |= 7;
                }
            }
        }
        if ((this.updateSystemUiVisibilityLw() & 0xC0008006) != 0) {
            changes |= 1;
        }
        this.updateLockScreenTimeout();
        return changes;
    }

    private boolean processKeyguardSetHiddenResultLw(int setHiddenResult) {
        if (setHiddenResult == 1) {
            this.mStatusBar.getAttrs().privateFlags |= 0x400;
            this.mStatusBar.getAttrs().flags |= 0x100000;
            return true;
        }
        if (setHiddenResult == 2) {
            this.mStatusBar.getAttrs().privateFlags &= 0xFFFFFBFF;
            this.mStatusBar.getAttrs().flags &= 0xFFEFFFFF;
            return true;
        }
        return false;
    }

    private boolean isStatusBarKeyguard() {
        return this.mStatusBar != null && (this.mStatusBar.getAttrs().privateFlags & 0x400) != 0;
    }

    @Override
    public boolean allowAppAnimationsLw() {
        return !this.isStatusBarKeyguard() && !this.mShowingDream;
    }

    @Override
    public int focusChangedLw(WindowManagerPolicy.WindowState lastFocus, WindowManagerPolicy.WindowState newFocus) {
        this.mFocusedWindow = newFocus;
        if ((this.updateSystemUiVisibilityLw() & 0xC0008006) != 0) {
            return 1;
        }
        return 0;
    }

    @Override
    public void notifyLidSwitchChanged(long whenNanos, boolean lidOpen) {
        int newLidState;
        int n = newLidState = lidOpen ? 1 : 0;
        if (newLidState == this.mLidState) {
            return;
        }
        this.mLidState = newLidState;
        this.applyLidSwitchState();
        this.updateRotation(true);
        if (lidOpen) {
            this.mPowerManager.wakeUp(SystemClock.uptimeMillis());
        } else if (!this.mLidControlsSleep) {
            this.mPowerManager.userActivity(SystemClock.uptimeMillis(), false);
        }
    }

    @Override
    public void notifyCameraLensCoverSwitchChanged(long whenNanos, boolean lensCovered) {
        int lensCoverState;
        int n = lensCoverState = lensCovered ? 1 : 0;
        if (this.mCameraLensCoverState == lensCoverState) {
            return;
        }
        if (this.mCameraLensCoverState == 1 && lensCoverState == 0) {
            boolean keyguardActive = this.mKeyguardDelegate == null ? false : this.mKeyguardDelegate.isShowing();
            Intent intent = keyguardActive ? new Intent("android.media.action.STILL_IMAGE_CAMERA_SECURE") : new Intent("android.media.action.STILL_IMAGE_CAMERA");
            this.mPowerManager.wakeUp(whenNanos / 1000000L);
            this.mContext.startActivityAsUser(intent, UserHandle.CURRENT_OR_SELF);
        }
        this.mCameraLensCoverState = lensCoverState;
    }

    void setHdmiPlugged(boolean plugged) {
        if (this.mHdmiPlugged != plugged) {
            this.mHdmiPlugged = plugged;
            this.updateRotation(true, true);
            Intent intent = new Intent("android.intent.action.HDMI_PLUGGED");
            intent.addFlags(0x4000000);
            intent.putExtra("state", plugged);
            this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initializeHdmiState() {
        boolean plugged = false;
        if (new File("/sys/devices/virtual/switch/hdmi/state").exists()) {
            this.mHDMIObserver.startObserving("DEVPATH=/devices/virtual/switch/hdmi");
            String filename = "/sys/class/switch/hdmi/state";
            FileReader reader = null;
            try {
                reader = new FileReader("/sys/class/switch/hdmi/state");
                char[] buf = new char[15];
                int n = reader.read(buf);
                if (n > 1) {
                    plugged = 0 != Integer.parseInt(new String(buf, 0, n - 1));
                }
            }
            catch (IOException ex) {
                Slog.w(TAG, "Couldn't read hdmi state from /sys/class/switch/hdmi/state: " + ex);
            }
            catch (NumberFormatException ex) {
                Slog.w(TAG, "Couldn't read hdmi state from /sys/class/switch/hdmi/state: " + ex);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException ex) {}
                }
            }
        }
        this.mHdmiPlugged = !plugged;
        this.setHdmiPlugged(!this.mHdmiPlugged);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void takeScreenshot() {
        Object object = this.mScreenshotLock;
        synchronized (object) {
            if (this.mScreenshotConnection != null) {
                return;
            }
            ComponentName cn = new ComponentName("com.android.systemui", "com.android.systemui.screenshot.TakeScreenshotService");
            Intent intent = new Intent();
            intent.setComponent(cn);
            ServiceConnection conn = new ServiceConnection(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onServiceConnected(ComponentName name, IBinder service) {
                    Object object = PhoneWindowManager.this.mScreenshotLock;
                    synchronized (object) {
                        if (PhoneWindowManager.this.mScreenshotConnection != this) {
                            return;
                        }
                        Messenger messenger = new Messenger(service);
                        Message msg = Message.obtain(null, 1);
                        final 14 myConn = this;
                        Handler h = new Handler(PhoneWindowManager.this.mHandler.getLooper()){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void handleMessage(Message msg) {
                                Object object = PhoneWindowManager.this.mScreenshotLock;
                                synchronized (object) {
                                    if (PhoneWindowManager.this.mScreenshotConnection == myConn) {
                                        PhoneWindowManager.this.mContext.unbindService(PhoneWindowManager.this.mScreenshotConnection);
                                        PhoneWindowManager.this.mScreenshotConnection = null;
                                        PhoneWindowManager.this.mHandler.removeCallbacks(PhoneWindowManager.this.mScreenshotTimeout);
                                    }
                                }
                            }
                        };
                        msg.replyTo = new Messenger(h);
                        msg.arg2 = 0;
                        msg.arg1 = 0;
                        if (PhoneWindowManager.this.mStatusBar != null && PhoneWindowManager.this.mStatusBar.isVisibleLw()) {
                            msg.arg1 = 1;
                        }
                        if (PhoneWindowManager.this.mNavigationBar != null && PhoneWindowManager.this.mNavigationBar.isVisibleLw()) {
                            msg.arg2 = 1;
                        }
                        try {
                            messenger.send(msg);
                        }
                        catch (RemoteException e) {
                            // empty catch block
                        }
                    }
                }

                @Override
                public void onServiceDisconnected(ComponentName name) {
                }
            };
            if (this.mContext.bindServiceAsUser(intent, conn, 1, UserHandle.CURRENT)) {
                this.mScreenshotConnection = conn;
                this.mHandler.postDelayed(this.mScreenshotTimeout, 10000L);
            }
        }
    }

    @Override
    public int interceptKeyBeforeQueueing(KeyEvent event, int policyFlags) {
        int result;
        boolean isWakeKey;
        boolean isInjected;
        if (!this.mSystemBooted) {
            return 0;
        }
        boolean interactive = (policyFlags & 0x20000000) != 0;
        boolean down = event.getAction() == 0;
        boolean canceled = event.isCanceled();
        int keyCode = event.getKeyCode();
        boolean bl = isInjected = (policyFlags & 0x1000000) != 0;
        boolean keyguardActive = this.mKeyguardDelegate == null ? false : (interactive ? this.mKeyguardDelegate.isShowingAndNotOccluded() : this.mKeyguardDelegate.isShowing());
        boolean bl2 = isWakeKey = (policyFlags & 1) != 0 || event.isWakeKey();
        if (interactive || isInjected && !isWakeKey) {
            result = 1;
            isWakeKey = false;
        } else if (!interactive && this.shouldDispatchInputWhenNonInteractive()) {
            result = 1;
        } else {
            result = 0;
            if (!(!isWakeKey || down && this.isWakeKeyWhenScreenOff(keyCode))) {
                isWakeKey = false;
            }
        }
        if (this.mGlobalKeyManager.shouldHandleGlobalKey(keyCode, event)) {
            if (isWakeKey) {
                this.mPowerManager.wakeUp(event.getEventTime());
            }
            return result;
        }
        boolean useHapticFeedback = down && (policyFlags & 2) != 0 && event.getRepeatCount() == 0;
        switch (keyCode) {
            case 24: 
            case 25: 
            case 164: {
                if (keyCode == 25) {
                    if (down) {
                        if (interactive && !this.mVolumeDownKeyTriggered && (event.getFlags() & 0x400) == 0) {
                            this.mVolumeDownKeyTriggered = true;
                            this.mVolumeDownKeyTime = event.getDownTime();
                            this.mVolumeDownKeyConsumedByScreenshotChord = false;
                            this.cancelPendingPowerKeyAction();
                            this.interceptScreenshotChord();
                        }
                    } else {
                        this.mVolumeDownKeyTriggered = false;
                        this.cancelPendingScreenshotChordAction();
                    }
                } else if (keyCode == 24) {
                    if (down) {
                        if (interactive && !this.mVolumeUpKeyTriggered && (event.getFlags() & 0x400) == 0) {
                            this.mVolumeUpKeyTriggered = true;
                            this.cancelPendingPowerKeyAction();
                            this.cancelPendingScreenshotChordAction();
                        }
                    } else {
                        this.mVolumeUpKeyTriggered = false;
                        this.cancelPendingScreenshotChordAction();
                    }
                }
                if (!down) break;
                TelecomManager telecomManager = this.getTelecommService();
                if (telecomManager != null) {
                    if (telecomManager.isRinging()) {
                        Log.i(TAG, "interceptKeyBeforeQueueing: VOLUME key-down while ringing: Silence ringer!");
                        telecomManager.silenceRinger();
                        result &= 0xFFFFFFFE;
                        break;
                    }
                    if (telecomManager.isInCall() && (result & 1) == 0) {
                        MediaSessionLegacyHelper.getHelper(this.mContext).sendVolumeKeyEvent(event, false);
                        break;
                    }
                }
                if ((result & 1) != 0) break;
                MediaSessionLegacyHelper.getHelper(this.mContext).sendVolumeKeyEvent(event, true);
                break;
            }
            case 6: {
                result &= 0xFFFFFFFE;
                if (down) {
                    TelecomManager telecomManager = this.getTelecommService();
                    boolean hungUp = false;
                    if (telecomManager != null) {
                        hungUp = telecomManager.endCall();
                    }
                    this.interceptPowerKeyDown(!interactive || hungUp);
                    break;
                }
                if (!this.interceptPowerKeyUp(canceled) || (this.mEndcallBehavior & 1) != 0 && this.goHome() || (this.mEndcallBehavior & 2) == 0) break;
                this.mPowerManager.goToSleep(event.getEventTime(), 4, 0);
                isWakeKey = false;
                break;
            }
            case 26: {
                result &= 0xFFFFFFFE;
                if (down) {
                    boolean panic = this.mImmersiveModeConfirmation.onPowerKeyDown(interactive, event.getDownTime(), this.isImmersiveMode(this.mLastSystemUiFlags));
                    if (panic) {
                        this.mHandler.post(this.mRequestTransientNav);
                    }
                    if (interactive && !this.mPowerKeyTriggered && (event.getFlags() & 0x400) == 0) {
                        this.mPowerKeyTriggered = true;
                        this.mPowerKeyTime = event.getDownTime();
                        this.interceptScreenshotChord();
                    }
                    TelecomManager telecomManager = this.getTelecommService();
                    boolean hungUp = false;
                    if (telecomManager != null) {
                        if (telecomManager.isRinging()) {
                            telecomManager.silenceRinger();
                        } else if ((this.mIncallPowerBehavior & 2) != 0 && telecomManager.isInCall() && interactive) {
                            hungUp = telecomManager.endCall();
                        }
                    }
                    this.interceptPowerKeyDown(!interactive || hungUp || this.mVolumeDownKeyTriggered || this.mVolumeUpKeyTriggered);
                    break;
                }
                this.mPowerKeyTriggered = false;
                this.cancelPendingScreenshotChordAction();
                if (this.interceptPowerKeyUp(canceled || this.mPendingPowerKeyUpCanceled)) {
                    if (this.mScreenOnEarly && !this.mScreenOnFully) {
                        Slog.i(TAG, "Suppressed redundant power key press while already in the process of turning the screen on.");
                    } else {
                        this.powerShortPress(event.getEventTime());
                    }
                    isWakeKey = false;
                }
                this.mPendingPowerKeyUpCanceled = false;
                break;
            }
            case 223: {
                result &= 0xFFFFFFFE;
                if (!this.mPowerManager.isInteractive()) {
                    useHapticFeedback = false;
                }
                this.mPowerManager.goToSleep(event.getEventTime(), 4, 0);
                isWakeKey = false;
                break;
            }
            case 224: {
                result &= 0xFFFFFFFE;
                isWakeKey = true;
                break;
            }
            case 79: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 126: 
            case 127: 
            case 130: 
            case 222: {
                if (MediaSessionLegacyHelper.getHelper(this.mContext).isGlobalPriorityActive()) {
                    result &= 0xFFFFFFFE;
                }
                if ((result & 1) != 0) break;
                this.mBroadcastWakeLock.acquire();
                Message msg = this.mHandler.obtainMessage(3, new KeyEvent(event));
                msg.setAsynchronous(true);
                msg.sendToTarget();
                break;
            }
            case 5: {
                TelecomManager telecomManager;
                if (!down || (telecomManager = this.getTelecommService()) == null || !telecomManager.isRinging()) break;
                Log.i(TAG, "interceptKeyBeforeQueueing: CALL key-down while ringing: Answer the call!");
                telecomManager.acceptRingingCall();
                result &= 0xFFFFFFFE;
                break;
            }
            case 231: {
                if ((result & 1) != 0 || down) break;
                this.mBroadcastWakeLock.acquire();
                Message msg = this.mHandler.obtainMessage(12, keyguardActive ? 1 : 0, 0);
                msg.setAsynchronous(true);
                msg.sendToTarget();
            }
        }
        if (useHapticFeedback) {
            this.performHapticFeedbackLw(null, 1, false);
        }
        if (isWakeKey) {
            this.mPowerManager.wakeUp(event.getEventTime());
        }
        return result;
    }

    private boolean isWakeKeyWhenScreenOff(int keyCode) {
        switch (keyCode) {
            case 24: 
            case 25: 
            case 164: {
                return this.mDockMode != 0;
            }
            case 27: 
            case 79: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 126: 
            case 127: 
            case 130: 
            case 222: {
                return false;
            }
        }
        return true;
    }

    @Override
    public int interceptMotionBeforeQueueingNonInteractive(long whenNanos, int policyFlags) {
        if ((policyFlags & 1) != 0) {
            this.mPowerManager.wakeUp(whenNanos / 1000000L);
            return 0;
        }
        if (this.shouldDispatchInputWhenNonInteractive()) {
            return 1;
        }
        return 0;
    }

    private boolean shouldDispatchInputWhenNonInteractive() {
        return this.keyguardIsShowingTq() && this.mDisplay != null && this.mDisplay.getState() != 1;
    }

    void dispatchMediaKeyWithWakeLock(KeyEvent event) {
        if (this.mHavePendingMediaKeyRepeatWithWakeLock) {
            this.mHandler.removeMessages(4);
            this.mHavePendingMediaKeyRepeatWithWakeLock = false;
            this.mBroadcastWakeLock.release();
        }
        this.dispatchMediaKeyWithWakeLockToAudioService(event);
        if (event.getAction() == 0 && event.getRepeatCount() == 0) {
            this.mHavePendingMediaKeyRepeatWithWakeLock = true;
            Message msg = this.mHandler.obtainMessage(4, event);
            msg.setAsynchronous(true);
            this.mHandler.sendMessageDelayed(msg, ViewConfiguration.getKeyRepeatTimeout());
        } else {
            this.mBroadcastWakeLock.release();
        }
    }

    void dispatchMediaKeyRepeatWithWakeLock(KeyEvent event) {
        this.mHavePendingMediaKeyRepeatWithWakeLock = false;
        KeyEvent repeatEvent = KeyEvent.changeTimeRepeat(event, SystemClock.uptimeMillis(), 1, event.getFlags() | 0x80);
        this.dispatchMediaKeyWithWakeLockToAudioService(repeatEvent);
        this.mBroadcastWakeLock.release();
    }

    void dispatchMediaKeyWithWakeLockToAudioService(KeyEvent event) {
        if (ActivityManagerNative.isSystemReady()) {
            MediaSessionLegacyHelper.getHelper(this.mContext).sendMediaButtonEvent(event, true);
        }
    }

    void launchVoiceAssistWithWakeLock(boolean keyguardActive) {
        Intent voiceIntent = new Intent("android.speech.action.VOICE_SEARCH_HANDS_FREE");
        voiceIntent.putExtra("android.speech.extras.EXTRA_SECURE", keyguardActive);
        this.mContext.startActivityAsUser(voiceIntent, UserHandle.CURRENT_OR_SELF);
        this.mBroadcastWakeLock.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestTransientBars(WindowManagerPolicy.WindowState swipeTarget) {
        Object object = this.mWindowManagerFuncs.getWindowManagerLock();
        synchronized (object) {
            if (!this.isUserSetupComplete()) {
                return;
            }
            boolean sb = this.mStatusBarController.checkShowTransientBarLw();
            boolean nb = this.mNavigationBarController.checkShowTransientBarLw();
            if (sb || nb) {
                WindowManagerPolicy.WindowState barTarget;
                WindowManagerPolicy.WindowState windowState = barTarget = sb ? this.mStatusBar : this.mNavigationBar;
                if (sb ^ nb && barTarget != swipeTarget) {
                    return;
                }
                if (sb) {
                    this.mStatusBarController.showTransient();
                }
                if (nb) {
                    this.mNavigationBarController.showTransient();
                }
                this.mImmersiveModeConfirmation.confirmCurrentPrompt();
                this.updateSystemUiVisibilityLw();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void goingToSleep(int why) {
        EventLog.writeEvent(70000, 0);
        Object object = this.mLock;
        synchronized (object) {
            this.mAwake = false;
            this.mKeyguardDrawComplete = false;
            this.updateWakeGestureListenerLp();
            this.updateOrientationListenerLp();
            this.updateLockScreenTimeout();
        }
        if (this.mKeyguardDelegate != null) {
            this.mKeyguardDelegate.onScreenTurnedOff(why);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void wakingUp() {
        EventLog.writeEvent(70000, 1);
        Object object = this.mLock;
        synchronized (object) {
            this.mAwake = true;
            this.mKeyguardDrawComplete = false;
            if (this.mKeyguardDelegate != null) {
                this.mHandler.removeMessages(6);
                this.mHandler.sendEmptyMessageDelayed(6, 1000L);
            }
            this.updateWakeGestureListenerLp();
            this.updateOrientationListenerLp();
            this.updateLockScreenTimeout();
        }
        if (this.mKeyguardDelegate != null) {
            this.mKeyguardDelegate.onScreenTurnedOn(this.mKeyguardDelegateCallback);
        } else {
            this.finishKeyguardDrawn();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishKeyguardDrawn() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mAwake || this.mKeyguardDrawComplete) {
                return;
            }
            this.mKeyguardDrawComplete = true;
            if (this.mKeyguardDelegate != null) {
                this.mHandler.removeMessages(6);
            }
        }
        this.finishScreenTurningOn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void screenTurnedOff() {
        Object object = this.mLock;
        synchronized (object) {
            this.mScreenOnEarly = false;
            this.mScreenOnFully = false;
            this.mWindowManagerDrawComplete = false;
            this.mScreenOnListener = null;
            this.updateOrientationListenerLp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void screenTurningOn(WindowManagerPolicy.ScreenOnListener screenOnListener) {
        Object object = this.mLock;
        synchronized (object) {
            this.mScreenOnEarly = true;
            this.mScreenOnFully = false;
            this.mWindowManagerDrawComplete = false;
            this.mScreenOnListener = screenOnListener;
            this.updateOrientationListenerLp();
        }
        this.mWindowManagerInternal.waitForAllWindowsDrawn(this.mWindowManagerDrawCallback, 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishWindowsDrawn() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mScreenOnEarly || this.mWindowManagerDrawComplete) {
                return;
            }
            this.mWindowManagerDrawComplete = true;
        }
        this.finishScreenTurningOn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishScreenTurningOn() {
        boolean enableScreen;
        WindowManagerPolicy.ScreenOnListener listener;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mScreenOnFully || !this.mScreenOnEarly || !this.mWindowManagerDrawComplete || this.mAwake && !this.mKeyguardDrawComplete) {
                return;
            }
            listener = this.mScreenOnListener;
            this.mScreenOnListener = null;
            this.mScreenOnFully = true;
            if (!this.mKeyguardDrawnOnce && this.mAwake) {
                this.mKeyguardDrawnOnce = true;
                enableScreen = true;
                if (this.mBootMessageNeedsHiding) {
                    this.mBootMessageNeedsHiding = false;
                    this.hideBootMessages();
                }
            } else {
                enableScreen = false;
            }
        }
        if (listener != null) {
            listener.onScreenOn();
        }
        if (enableScreen) {
            try {
                this.mWindowManager.enableScreenIfNeeded();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleHideBootMessage() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mKeyguardDrawnOnce) {
                this.mBootMessageNeedsHiding = true;
                return;
            }
        }
        if (this.mBootMsgDialog != null) {
            this.mBootMsgDialog.dismiss();
            this.mBootMsgDialog = null;
        }
    }

    @Override
    public boolean isScreenOn() {
        return this.mScreenOnFully;
    }

    @Override
    public void enableKeyguard(boolean enabled) {
        if (this.mKeyguardDelegate != null) {
            this.mKeyguardDelegate.setKeyguardEnabled(enabled);
        }
    }

    @Override
    public void exitKeyguardSecurely(WindowManagerPolicy.OnKeyguardExitResult callback) {
        if (this.mKeyguardDelegate != null) {
            this.mKeyguardDelegate.verifyUnlock(callback);
        }
    }

    private boolean keyguardIsShowingTq() {
        if (this.mKeyguardDelegate == null) {
            return false;
        }
        return this.mKeyguardDelegate.isShowingAndNotOccluded();
    }

    @Override
    public boolean isKeyguardLocked() {
        return this.keyguardOn();
    }

    @Override
    public boolean isKeyguardSecure() {
        if (this.mKeyguardDelegate == null) {
            return false;
        }
        return this.mKeyguardDelegate.isSecure();
    }

    private boolean isKeyguardSecureIncludingHidden() {
        return this.mKeyguardDelegate.isSecure() && this.mKeyguardDelegate.isShowing();
    }

    @Override
    public boolean inKeyguardRestrictedKeyInputMode() {
        if (this.mKeyguardDelegate == null) {
            return false;
        }
        return this.mKeyguardDelegate.isInputRestricted();
    }

    @Override
    public void dismissKeyguardLw() {
        if (this.mKeyguardDelegate != null && this.mKeyguardDelegate.isShowing()) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    PhoneWindowManager.this.mKeyguardDelegate.dismiss();
                }
            });
        }
    }

    @Override
    public void notifyActivityDrawnForKeyguardLw() {
        if (this.mKeyguardDelegate != null) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    PhoneWindowManager.this.mKeyguardDelegate.onActivityDrawn();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isKeyguardDrawnLw() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mKeyguardDrawnOnce;
        }
    }

    @Override
    public void startKeyguardExitAnimation(long startTime, long fadeoutDuration) {
        if (this.mKeyguardDelegate != null) {
            this.mKeyguardDelegate.startKeyguardExitAnimation(startTime, fadeoutDuration);
        }
    }

    void sendCloseSystemWindows() {
        PhoneWindowManager.sendCloseSystemWindows(this.mContext, null);
    }

    void sendCloseSystemWindows(String reason) {
        PhoneWindowManager.sendCloseSystemWindows(this.mContext, reason);
    }

    static void sendCloseSystemWindows(Context context, String reason) {
        if (ActivityManagerNative.isSystemReady()) {
            try {
                ActivityManagerNative.getDefault().closeSystemDialogs(reason);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int rotationForOrientationLw(int orientation, int lastRotation) {
        if (this.mForceDefaultOrientation) {
            return 0;
        }
        Object object = this.mLock;
        synchronized (object) {
            int preferredRotation;
            int sensorRotation = this.mOrientationListener.getProposedRotation();
            if (sensorRotation < 0) {
                sensorRotation = lastRotation;
            }
            if (this.mLidState == 1 && this.mLidOpenRotation >= 0) {
                preferredRotation = this.mLidOpenRotation;
            } else if (this.mDockMode == 2 && (this.mCarDockEnablesAccelerometer || this.mCarDockRotation >= 0)) {
                preferredRotation = this.mCarDockEnablesAccelerometer ? sensorRotation : this.mCarDockRotation;
            } else if (!(this.mDockMode != 1 && this.mDockMode != 3 && this.mDockMode != 4 || !this.mDeskDockEnablesAccelerometer && this.mDeskDockRotation < 0)) {
                preferredRotation = this.mDeskDockEnablesAccelerometer ? sensorRotation : this.mDeskDockRotation;
            } else if (this.mHdmiPlugged && this.mDemoHdmiRotationLock) {
                preferredRotation = this.mDemoHdmiRotation;
            } else if (this.mHdmiPlugged && this.mDockMode == 0 && this.mUndockedHdmiRotation >= 0) {
                preferredRotation = this.mUndockedHdmiRotation;
            } else if (orientation == 14) {
                preferredRotation = lastRotation;
            } else if (!this.mSupportAutoRotation) {
                preferredRotation = -1;
            } else if (this.mUserRotationMode == 0 && (orientation == 2 || orientation == -1 || orientation == 11 || orientation == 12 || orientation == 13) || orientation == 4 || orientation == 10 || orientation == 6 || orientation == 7) {
                if (this.mAllowAllRotations < 0) {
                    int n = this.mAllowAllRotations = this.mContext.getResources().getBoolean(17956902) ? 1 : 0;
                }
                preferredRotation = sensorRotation != 2 || this.mAllowAllRotations == 1 || orientation == 10 || orientation == 13 ? sensorRotation : lastRotation;
            } else {
                preferredRotation = this.mUserRotationMode == 1 && orientation != 5 ? this.mUserRotation : -1;
            }
            switch (orientation) {
                case 1: {
                    if (this.isAnyPortrait(preferredRotation)) {
                        return preferredRotation;
                    }
                    return this.mPortraitRotation;
                }
                case 0: {
                    if (this.isLandscapeOrSeascape(preferredRotation)) {
                        return preferredRotation;
                    }
                    return this.mLandscapeRotation;
                }
                case 9: {
                    if (this.isAnyPortrait(preferredRotation)) {
                        return preferredRotation;
                    }
                    return this.mUpsideDownRotation;
                }
                case 8: {
                    if (this.isLandscapeOrSeascape(preferredRotation)) {
                        return preferredRotation;
                    }
                    return this.mSeascapeRotation;
                }
                case 6: 
                case 11: {
                    if (this.isLandscapeOrSeascape(preferredRotation)) {
                        return preferredRotation;
                    }
                    if (this.isLandscapeOrSeascape(lastRotation)) {
                        return lastRotation;
                    }
                    return this.mLandscapeRotation;
                }
                case 7: 
                case 12: {
                    if (this.isAnyPortrait(preferredRotation)) {
                        return preferredRotation;
                    }
                    if (this.isAnyPortrait(lastRotation)) {
                        return lastRotation;
                    }
                    return this.mPortraitRotation;
                }
            }
            if (preferredRotation >= 0) {
                return preferredRotation;
            }
            return 0;
        }
    }

    @Override
    public boolean rotationHasCompatibleMetricsLw(int orientation, int rotation) {
        switch (orientation) {
            case 1: 
            case 7: 
            case 9: {
                return this.isAnyPortrait(rotation);
            }
            case 0: 
            case 6: 
            case 8: {
                return this.isLandscapeOrSeascape(rotation);
            }
        }
        return true;
    }

    @Override
    public void setRotationLw(int rotation) {
        this.mOrientationListener.setCurrentRotation(rotation);
    }

    private boolean isLandscapeOrSeascape(int rotation) {
        return rotation == this.mLandscapeRotation || rotation == this.mSeascapeRotation;
    }

    private boolean isAnyPortrait(int rotation) {
        return rotation == this.mPortraitRotation || rotation == this.mUpsideDownRotation;
    }

    @Override
    public int getUserRotationMode() {
        return Settings.System.getIntForUser(this.mContext.getContentResolver(), "accelerometer_rotation", 0, -2) != 0 ? 0 : 1;
    }

    @Override
    public void setUserRotationMode(int mode, int rot) {
        ContentResolver res = this.mContext.getContentResolver();
        if (mode == 1) {
            Settings.System.putIntForUser(res, "user_rotation", rot, -2);
            Settings.System.putIntForUser(res, "accelerometer_rotation", 0, -2);
        } else {
            Settings.System.putIntForUser(res, "accelerometer_rotation", 1, -2);
        }
    }

    @Override
    public void setSafeMode(boolean safeMode) {
        this.mSafeMode = safeMode;
        this.performHapticFeedbackLw(null, safeMode ? 10001 : 10000, true);
    }

    static long[] getLongIntArray(Resources r, int resid) {
        int[] ar = r.getIntArray(resid);
        if (ar == null) {
            return null;
        }
        long[] out = new long[ar.length];
        for (int i = 0; i < ar.length; ++i) {
            out[i] = ar[i];
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void systemReady() {
        this.mKeyguardDelegate = new KeyguardServiceDelegate(this.mContext, null);
        this.mKeyguardDelegate.onSystemReady();
        this.readCameraLensCoverState();
        this.updateUiMode();
        Object object = this.mLock;
        synchronized (object) {
            this.updateOrientationListenerLp();
            this.mSystemReady = true;
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    PhoneWindowManager.this.updateSettings();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void systemBooted() {
        if (this.mKeyguardDelegate != null) {
            this.mKeyguardDelegate.bindService(this.mContext);
            this.mKeyguardDelegate.onBootCompleted();
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mSystemBooted = true;
        }
        this.wakingUp();
        this.screenTurningOn(null);
    }

    @Override
    public void showBootMessage(final CharSequence msg, boolean always) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (PhoneWindowManager.this.mBootMsgDialog == null) {
                    int theme = PhoneWindowManager.this.mContext.getPackageManager().hasSystemFeature("android.hardware.type.watch") ? 16975034 : (PhoneWindowManager.this.mContext.getPackageManager().hasSystemFeature("android.hardware.type.television") ? 16975008 : 0);
                    PhoneWindowManager.this.mBootMsgDialog = new ProgressDialog(PhoneWindowManager.this.mContext, theme){

                        @Override
                        public boolean dispatchKeyEvent(KeyEvent event) {
                            return true;
                        }

                        @Override
                        public boolean dispatchKeyShortcutEvent(KeyEvent event) {
                            return true;
                        }

                        @Override
                        public boolean dispatchTouchEvent(MotionEvent ev) {
                            return true;
                        }

                        @Override
                        public boolean dispatchTrackballEvent(MotionEvent ev) {
                            return true;
                        }

                        @Override
                        public boolean dispatchGenericMotionEvent(MotionEvent ev) {
                            return true;
                        }

                        @Override
                        public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
                            return true;
                        }
                    };
                    PhoneWindowManager.this.mBootMsgDialog.setTitle(17040516);
                    PhoneWindowManager.this.mBootMsgDialog.setProgressStyle(0);
                    PhoneWindowManager.this.mBootMsgDialog.setIndeterminate(true);
                    PhoneWindowManager.this.mBootMsgDialog.getWindow().setType(2021);
                    PhoneWindowManager.this.mBootMsgDialog.getWindow().addFlags(258);
                    PhoneWindowManager.this.mBootMsgDialog.getWindow().setDimAmount(1.0f);
                    WindowManager.LayoutParams lp = PhoneWindowManager.this.mBootMsgDialog.getWindow().getAttributes();
                    lp.screenOrientation = 5;
                    PhoneWindowManager.this.mBootMsgDialog.getWindow().setAttributes(lp);
                    PhoneWindowManager.this.mBootMsgDialog.setCancelable(false);
                    PhoneWindowManager.this.mBootMsgDialog.show();
                }
                PhoneWindowManager.this.mBootMsgDialog.setMessage(msg);
            }
        });
    }

    @Override
    public void hideBootMessages() {
        this.mHandler.sendEmptyMessage(11);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void userActivity() {
        ScreenLockTimeout screenLockTimeout = this.mScreenLockTimeout;
        synchronized (screenLockTimeout) {
            if (this.mLockScreenTimerActive) {
                this.mHandler.removeCallbacks(this.mScreenLockTimeout);
                this.mHandler.postDelayed(this.mScreenLockTimeout, this.mLockScreenTimeout);
            }
        }
    }

    @Override
    public void lockNow(Bundle options) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
        this.mHandler.removeCallbacks(this.mScreenLockTimeout);
        if (options != null) {
            this.mScreenLockTimeout.setLockOptions(options);
        }
        this.mHandler.post(this.mScreenLockTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLockScreenTimeout() {
        ScreenLockTimeout screenLockTimeout = this.mScreenLockTimeout;
        synchronized (screenLockTimeout) {
            boolean enable;
            boolean bl = enable = this.mAllowLockscreenWhenOn && this.mAwake && this.mKeyguardDelegate != null && this.mKeyguardDelegate.isSecure();
            if (this.mLockScreenTimerActive != enable) {
                if (enable) {
                    this.mHandler.postDelayed(this.mScreenLockTimeout, this.mLockScreenTimeout);
                } else {
                    this.mHandler.removeCallbacks(this.mScreenLockTimeout);
                }
                this.mLockScreenTimerActive = enable;
            }
        }
    }

    @Override
    public void enableScreenAfterBoot() {
        this.readLidState();
        this.applyLidSwitchState();
        this.updateRotation(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyLidSwitchState() {
        if (this.mLidState == 0 && this.mLidControlsSleep) {
            this.mPowerManager.goToSleep(SystemClock.uptimeMillis(), 3, 1);
        }
        Object object = this.mLock;
        synchronized (object) {
            this.updateWakeGestureListenerLp();
        }
    }

    void updateUiMode() {
        if (this.mUiModeManager == null) {
            this.mUiModeManager = IUiModeManager.Stub.asInterface(ServiceManager.getService("uimode"));
        }
        try {
            this.mUiMode = this.mUiModeManager.getCurrentModeType();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    void updateRotation(boolean alwaysSendConfiguration) {
        try {
            this.mWindowManager.updateRotation(alwaysSendConfiguration, false);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    void updateRotation(boolean alwaysSendConfiguration, boolean forceRelayout) {
        try {
            this.mWindowManager.updateRotation(alwaysSendConfiguration, forceRelayout);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    Intent createHomeDockIntent() {
        Intent intent = null;
        if (this.mUiMode == 3) {
            intent = this.mCarDockIntent;
        } else if (this.mUiMode != 2 && this.mUiMode == 6 && (this.mDockMode == 1 || this.mDockMode == 4 || this.mDockMode == 3)) {
            intent = this.mDeskDockIntent;
        }
        if (intent == null) {
            return null;
        }
        ActivityInfo ai = null;
        ResolveInfo info = this.mContext.getPackageManager().resolveActivityAsUser(intent, 65664, this.mCurrentUserId);
        if (info != null) {
            ai = info.activityInfo;
        }
        if (ai != null && ai.metaData != null && ai.metaData.getBoolean("android.dock_home")) {
            intent = new Intent(intent);
            intent.setClassName(ai.packageName, ai.name);
            return intent;
        }
        return null;
    }

    void startDockOrHome() {
        PhoneWindowManager.awakenDreams();
        Intent dock = this.createHomeDockIntent();
        if (dock != null) {
            try {
                this.mContext.startActivityAsUser(dock, UserHandle.CURRENT);
                return;
            }
            catch (ActivityNotFoundException activityNotFoundException) {
                // empty catch block
            }
        }
        this.mContext.startActivityAsUser(this.mHomeIntent, UserHandle.CURRENT);
    }

    boolean goHome() {
        try {
            if (SystemProperties.getInt("persist.sys.uts-test-mode", 0) == 1) {
                Log.d(TAG, "UTS-TEST-MODE");
            } else {
                int result;
                ActivityManagerNative.getDefault().stopAppSwitches();
                this.sendCloseSystemWindows();
                Intent dock = this.createHomeDockIntent();
                if (dock != null && (result = ActivityManagerNative.getDefault().startActivityAsUser(null, null, dock, dock.resolveTypeIfNeeded(this.mContext.getContentResolver()), null, null, 0, 1, null, null, -2)) == 1) {
                    return false;
                }
            }
            int result = ActivityManagerNative.getDefault().startActivityAsUser(null, null, this.mHomeIntent, this.mHomeIntent.resolveTypeIfNeeded(this.mContext.getContentResolver()), null, null, 0, 1, null, null, -2);
            if (result == 1) {
                return false;
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCurrentOrientationLw(int newOrientation) {
        Object object = this.mLock;
        synchronized (object) {
            if (newOrientation != this.mCurrentAppOrientation) {
                this.mCurrentAppOrientation = newOrientation;
                this.updateOrientationListenerLp();
            }
        }
    }

    private void performAuditoryFeedbackForAccessibilityIfNeed() {
        if (!this.isGlobalAccessibilityGestureEnabled()) {
            return;
        }
        AudioManager audioManager = (AudioManager)this.mContext.getSystemService("audio");
        if (audioManager.isSilentMode()) {
            return;
        }
        Ringtone ringTone = RingtoneManager.getRingtone(this.mContext, Settings.System.DEFAULT_NOTIFICATION_URI);
        ringTone.setStreamType(3);
        ringTone.play();
    }

    private boolean isGlobalAccessibilityGestureEnabled() {
        return Settings.Global.getInt(this.mContext.getContentResolver(), "enable_accessibility_global_gesture_enabled", 0) == 1;
    }

    @Override
    public boolean performHapticFeedbackLw(WindowManagerPolicy.WindowState win, int effectId, boolean always) {
        String owningPackage;
        int owningUid;
        boolean hapticsDisabled;
        if (!this.mVibrator.hasVibrator()) {
            return false;
        }
        boolean bl = hapticsDisabled = Settings.System.getIntForUser(this.mContext.getContentResolver(), "haptic_feedback_enabled", 0, -2) == 0;
        if (hapticsDisabled && !always) {
            return false;
        }
        long[] pattern = null;
        switch (effectId) {
            case 0: {
                pattern = this.mLongPressVibePattern;
                break;
            }
            case 1: {
                pattern = this.mVirtualKeyVibePattern;
                break;
            }
            case 3: {
                pattern = this.mKeyboardTapVibePattern;
                break;
            }
            case 4: {
                pattern = this.mClockTickVibePattern;
                break;
            }
            case 5: {
                pattern = this.mCalendarDateVibePattern;
                break;
            }
            case 10000: {
                pattern = this.mSafeModeDisabledVibePattern;
                break;
            }
            case 10001: {
                pattern = this.mSafeModeEnabledVibePattern;
                break;
            }
            default: {
                return false;
            }
        }
        if (win != null) {
            owningUid = win.getOwningUid();
            owningPackage = win.getOwningPackage();
        } else {
            owningUid = Process.myUid();
            owningPackage = this.mContext.getOpPackageName();
        }
        if (pattern.length == 1) {
            this.mVibrator.vibrate(owningUid, owningPackage, pattern[0], VIBRATION_ATTRIBUTES);
        } else {
            this.mVibrator.vibrate(owningUid, owningPackage, pattern, -1, VIBRATION_ATTRIBUTES);
        }
        return true;
    }

    @Override
    public void keepScreenOnStartedLw() {
    }

    @Override
    public void keepScreenOnStoppedLw() {
        if (this.mKeyguardDelegate != null && !this.mKeyguardDelegate.isShowingAndNotOccluded()) {
            this.mPowerManager.userActivity(SystemClock.uptimeMillis(), false);
        }
    }

    private int updateSystemUiVisibilityLw() {
        WindowManagerPolicy.WindowState win;
        WindowManagerPolicy.WindowState windowState = win = this.mFocusedWindow != null ? this.mFocusedWindow : this.mTopFullscreenOpaqueWindowState;
        if (win == null) {
            return 0;
        }
        if ((win.getAttrs().privateFlags & 0x400) != 0 && this.mHideLockScreen) {
            return 0;
        }
        int tmpVisibility = PolicyControl.getSystemUiVisibility(win, null) & ~this.mResettingSystemUiFlags & ~this.mForceClearedSystemUiFlags;
        if (this.mForcingShowNavBar && win.getSurfaceLayer() < this.mForcingShowNavBarLayer) {
            tmpVisibility &= ~PolicyControl.adjustClearableFlags(win, 7);
        }
        final int visibility = this.updateSystemBarsLw(win, this.mLastSystemUiFlags, tmpVisibility);
        int diff = visibility ^ this.mLastSystemUiFlags;
        final boolean needsMenu = win.getNeedsMenuLw(this.mTopFullscreenOpaqueWindowState);
        if (diff == 0 && this.mLastFocusNeedsMenu == needsMenu && this.mFocusedApp == win.getAppToken()) {
            return 0;
        }
        this.mLastSystemUiFlags = visibility;
        this.mLastFocusNeedsMenu = needsMenu;
        this.mFocusedApp = win.getAppToken();
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                try {
                    IStatusBarService statusbar = PhoneWindowManager.this.getStatusBarService();
                    if (statusbar != null) {
                        statusbar.setSystemUiVisibility(visibility, -1);
                        statusbar.topAppWindowChanged(needsMenu);
                    }
                }
                catch (RemoteException e) {
                    PhoneWindowManager.this.mStatusBarService = null;
                }
            }
        });
        return diff;
    }

    private int updateSystemBarsLw(WindowManagerPolicy.WindowState win, int oldVis, int vis) {
        boolean denyTransientNav;
        boolean statusBarHasFocus;
        WindowManagerPolicy.WindowState transWin = this.isStatusBarKeyguard() && !this.mHideLockScreen ? this.mStatusBar : this.mTopFullscreenOpaqueWindowState;
        vis = this.mStatusBarController.applyTranslucentFlagLw(transWin, vis, oldVis);
        vis = this.mNavigationBarController.applyTranslucentFlagLw(transWin, vis, oldVis);
        boolean bl = statusBarHasFocus = win.getAttrs().type == 2000;
        if (statusBarHasFocus && !this.isStatusBarKeyguard()) {
            int flags = 6150;
            if (this.mHideLockScreen) {
                flags |= 0xC0000000;
            }
            vis = vis & ~flags | oldVis & flags;
        }
        if (!this.areTranslucentBarsAllowed() && transWin != this.mStatusBar) {
            vis &= 0x3FFF7FFF;
        }
        boolean immersiveSticky = (vis & 0x1000) != 0;
        boolean hideStatusBarWM = this.mTopFullscreenOpaqueWindowState != null && (PolicyControl.getWindowFlags(this.mTopFullscreenOpaqueWindowState, null) & 0x400) != 0;
        boolean hideStatusBarSysui = (vis & 4) != 0;
        boolean hideNavBarSysui = (vis & 2) != 0;
        boolean transientStatusBarAllowed = this.mStatusBar != null && (hideStatusBarWM || hideStatusBarSysui && immersiveSticky || statusBarHasFocus);
        boolean transientNavBarAllowed = this.mNavigationBar != null && hideNavBarSysui && immersiveSticky;
        boolean denyTransientStatus = this.mStatusBarController.isTransientShowRequested() && !transientStatusBarAllowed && hideStatusBarSysui;
        boolean bl2 = denyTransientNav = this.mNavigationBarController.isTransientShowRequested() && !transientNavBarAllowed;
        if (denyTransientStatus || denyTransientNav) {
            this.clearClearableFlagsLw();
        }
        vis = this.mStatusBarController.updateVisibilityLw(transientStatusBarAllowed, oldVis, vis);
        boolean oldImmersiveMode = this.isImmersiveMode(oldVis);
        boolean newImmersiveMode = this.isImmersiveMode(vis);
        if (win != null && oldImmersiveMode != newImmersiveMode) {
            String pkg = win.getOwningPackage();
            this.mImmersiveModeConfirmation.immersiveModeChanged(pkg, newImmersiveMode, this.isUserSetupComplete());
        }
        vis = this.mNavigationBarController.updateVisibilityLw(transientNavBarAllowed, oldVis, vis);
        return vis;
    }

    private void clearClearableFlagsLw() {
        int newVal = this.mResettingSystemUiFlags | 7;
        if (newVal != this.mResettingSystemUiFlags) {
            this.mResettingSystemUiFlags = newVal;
            this.mWindowManagerFuncs.reevaluateStatusBarVisibility();
        }
    }

    private boolean isImmersiveMode(int vis) {
        int flags = 6144;
        return this.mNavigationBar != null && (vis & 2) != 0 && (vis & 0x1800) != 0 && this.canHideNavigationBar();
    }

    private boolean areTranslucentBarsAllowed() {
        return this.mTranslucentDecorEnabled && !this.mAccessibilityManager.isTouchExplorationEnabled();
    }

    @Override
    public boolean hasNavigationBar() {
        return this.mHasNavigationBar;
    }

    @Override
    public void setLastInputMethodWindowLw(WindowManagerPolicy.WindowState ime, WindowManagerPolicy.WindowState target) {
        this.mLastInputMethodWindow = ime;
        this.mLastInputMethodTargetWindow = target;
    }

    @Override
    public int getInputMethodWindowVisibleHeightLw() {
        return this.mDockBottom - this.mCurBottom;
    }

    @Override
    public void setCurrentUserLw(int newUserId) {
        this.mCurrentUserId = newUserId;
        if (this.mKeyguardDelegate != null) {
            this.mKeyguardDelegate.setCurrentUser(newUserId);
        }
        if (this.mStatusBarService != null) {
            try {
                this.mStatusBarService.setCurrentUser(newUserId);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        this.setLastInputMethodWindowLw(null, null);
    }

    @Override
    public boolean canMagnifyWindow(int windowType) {
        switch (windowType) {
            case 2011: 
            case 2012: 
            case 2019: 
            case 2027: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isTopLevelWindow(int windowType) {
        if (windowType >= 1000 && windowType <= 1999) {
            return windowType == 1003;
        }
        return true;
    }

    @Override
    public void dump(String prefix, PrintWriter pw, String[] args) {
        pw.print(prefix);
        pw.print("mSafeMode=");
        pw.print(this.mSafeMode);
        pw.print(" mSystemReady=");
        pw.print(this.mSystemReady);
        pw.print(" mSystemBooted=");
        pw.println(this.mSystemBooted);
        pw.print(prefix);
        pw.print("mLidState=");
        pw.print(this.mLidState);
        pw.print(" mLidOpenRotation=");
        pw.print(this.mLidOpenRotation);
        pw.print(" mCameraLensCoverState=");
        pw.print(this.mCameraLensCoverState);
        pw.print(" mHdmiPlugged=");
        pw.println(this.mHdmiPlugged);
        if (this.mLastSystemUiFlags != 0 || this.mResettingSystemUiFlags != 0 || this.mForceClearedSystemUiFlags != 0) {
            pw.print(prefix);
            pw.print("mLastSystemUiFlags=0x");
            pw.print(Integer.toHexString(this.mLastSystemUiFlags));
            pw.print(" mResettingSystemUiFlags=0x");
            pw.print(Integer.toHexString(this.mResettingSystemUiFlags));
            pw.print(" mForceClearedSystemUiFlags=0x");
            pw.println(Integer.toHexString(this.mForceClearedSystemUiFlags));
        }
        if (this.mLastFocusNeedsMenu) {
            pw.print(prefix);
            pw.print("mLastFocusNeedsMenu=");
            pw.println(this.mLastFocusNeedsMenu);
        }
        pw.print(prefix);
        pw.print("mWakeGestureEnabledSetting=");
        pw.println(this.mWakeGestureEnabledSetting);
        pw.print(prefix);
        pw.print("mSupportAutoRotation=");
        pw.println(this.mSupportAutoRotation);
        pw.print(prefix);
        pw.print("mUiMode=");
        pw.print(this.mUiMode);
        pw.print(" mDockMode=");
        pw.print(this.mDockMode);
        pw.print(" mCarDockRotation=");
        pw.print(this.mCarDockRotation);
        pw.print(" mDeskDockRotation=");
        pw.println(this.mDeskDockRotation);
        pw.print(prefix);
        pw.print("mUserRotationMode=");
        pw.print(this.mUserRotationMode);
        pw.print(" mUserRotation=");
        pw.print(this.mUserRotation);
        pw.print(" mAllowAllRotations=");
        pw.println(this.mAllowAllRotations);
        pw.print(prefix);
        pw.print("mCurrentAppOrientation=");
        pw.println(this.mCurrentAppOrientation);
        pw.print(prefix);
        pw.print("mCarDockEnablesAccelerometer=");
        pw.print(this.mCarDockEnablesAccelerometer);
        pw.print(" mDeskDockEnablesAccelerometer=");
        pw.println(this.mDeskDockEnablesAccelerometer);
        pw.print(prefix);
        pw.print("mLidKeyboardAccessibility=");
        pw.print(this.mLidKeyboardAccessibility);
        pw.print(" mLidNavigationAccessibility=");
        pw.print(this.mLidNavigationAccessibility);
        pw.print(" mLidControlsSleep=");
        pw.println(this.mLidControlsSleep);
        pw.print(prefix);
        pw.print("mShortPressOnPowerBehavior=");
        pw.print(this.mShortPressOnPowerBehavior);
        pw.print(" mLongPressOnPowerBehavior=");
        pw.println(this.mLongPressOnPowerBehavior);
        pw.print(prefix);
        pw.print("mHasSoftInput=");
        pw.println(this.mHasSoftInput);
        pw.print(prefix);
        pw.print("mAwake=");
        pw.println(this.mAwake);
        pw.print(prefix);
        pw.print("mScreenOnEarly=");
        pw.print(this.mScreenOnEarly);
        pw.print(" mScreenOnFully=");
        pw.println(this.mScreenOnFully);
        pw.print(prefix);
        pw.print("mKeyguardDrawComplete=");
        pw.print(this.mKeyguardDrawComplete);
        pw.print(" mWindowManagerDrawComplete=");
        pw.println(this.mWindowManagerDrawComplete);
        pw.print(prefix);
        pw.print("mOrientationSensorEnabled=");
        pw.println(this.mOrientationSensorEnabled);
        pw.print(prefix);
        pw.print("mOverscanScreen=(");
        pw.print(this.mOverscanScreenLeft);
        pw.print(",");
        pw.print(this.mOverscanScreenTop);
        pw.print(") ");
        pw.print(this.mOverscanScreenWidth);
        pw.print("x");
        pw.println(this.mOverscanScreenHeight);
        if (this.mOverscanLeft != 0 || this.mOverscanTop != 0 || this.mOverscanRight != 0 || this.mOverscanBottom != 0) {
            pw.print(prefix);
            pw.print("mOverscan left=");
            pw.print(this.mOverscanLeft);
            pw.print(" top=");
            pw.print(this.mOverscanTop);
            pw.print(" right=");
            pw.print(this.mOverscanRight);
            pw.print(" bottom=");
            pw.println(this.mOverscanBottom);
        }
        pw.print(prefix);
        pw.print("mRestrictedOverscanScreen=(");
        pw.print(this.mRestrictedOverscanScreenLeft);
        pw.print(",");
        pw.print(this.mRestrictedOverscanScreenTop);
        pw.print(") ");
        pw.print(this.mRestrictedOverscanScreenWidth);
        pw.print("x");
        pw.println(this.mRestrictedOverscanScreenHeight);
        pw.print(prefix);
        pw.print("mUnrestrictedScreen=(");
        pw.print(this.mUnrestrictedScreenLeft);
        pw.print(",");
        pw.print(this.mUnrestrictedScreenTop);
        pw.print(") ");
        pw.print(this.mUnrestrictedScreenWidth);
        pw.print("x");
        pw.println(this.mUnrestrictedScreenHeight);
        pw.print(prefix);
        pw.print("mRestrictedScreen=(");
        pw.print(this.mRestrictedScreenLeft);
        pw.print(",");
        pw.print(this.mRestrictedScreenTop);
        pw.print(") ");
        pw.print(this.mRestrictedScreenWidth);
        pw.print("x");
        pw.println(this.mRestrictedScreenHeight);
        pw.print(prefix);
        pw.print("mStableFullscreen=(");
        pw.print(this.mStableFullscreenLeft);
        pw.print(",");
        pw.print(this.mStableFullscreenTop);
        pw.print(")-(");
        pw.print(this.mStableFullscreenRight);
        pw.print(",");
        pw.print(this.mStableFullscreenBottom);
        pw.println(")");
        pw.print(prefix);
        pw.print("mStable=(");
        pw.print(this.mStableLeft);
        pw.print(",");
        pw.print(this.mStableTop);
        pw.print(")-(");
        pw.print(this.mStableRight);
        pw.print(",");
        pw.print(this.mStableBottom);
        pw.println(")");
        pw.print(prefix);
        pw.print("mSystem=(");
        pw.print(this.mSystemLeft);
        pw.print(",");
        pw.print(this.mSystemTop);
        pw.print(")-(");
        pw.print(this.mSystemRight);
        pw.print(",");
        pw.print(this.mSystemBottom);
        pw.println(")");
        pw.print(prefix);
        pw.print("mCur=(");
        pw.print(this.mCurLeft);
        pw.print(",");
        pw.print(this.mCurTop);
        pw.print(")-(");
        pw.print(this.mCurRight);
        pw.print(",");
        pw.print(this.mCurBottom);
        pw.println(")");
        pw.print(prefix);
        pw.print("mContent=(");
        pw.print(this.mContentLeft);
        pw.print(",");
        pw.print(this.mContentTop);
        pw.print(")-(");
        pw.print(this.mContentRight);
        pw.print(",");
        pw.print(this.mContentBottom);
        pw.println(")");
        pw.print(prefix);
        pw.print("mVoiceContent=(");
        pw.print(this.mVoiceContentLeft);
        pw.print(",");
        pw.print(this.mVoiceContentTop);
        pw.print(")-(");
        pw.print(this.mVoiceContentRight);
        pw.print(",");
        pw.print(this.mVoiceContentBottom);
        pw.println(")");
        pw.print(prefix);
        pw.print("mDock=(");
        pw.print(this.mDockLeft);
        pw.print(",");
        pw.print(this.mDockTop);
        pw.print(")-(");
        pw.print(this.mDockRight);
        pw.print(",");
        pw.print(this.mDockBottom);
        pw.println(")");
        pw.print(prefix);
        pw.print("mDockLayer=");
        pw.print(this.mDockLayer);
        pw.print(" mStatusBarLayer=");
        pw.println(this.mStatusBarLayer);
        pw.print(prefix);
        pw.print("mShowingLockscreen=");
        pw.print(this.mShowingLockscreen);
        pw.print(" mShowingDream=");
        pw.print(this.mShowingDream);
        pw.print(" mDreamingLockscreen=");
        pw.println(this.mDreamingLockscreen);
        if (this.mLastInputMethodWindow != null) {
            pw.print(prefix);
            pw.print("mLastInputMethodWindow=");
            pw.println(this.mLastInputMethodWindow);
        }
        if (this.mLastInputMethodTargetWindow != null) {
            pw.print(prefix);
            pw.print("mLastInputMethodTargetWindow=");
            pw.println(this.mLastInputMethodTargetWindow);
        }
        if (this.mStatusBar != null) {
            pw.print(prefix);
            pw.print("mStatusBar=");
            pw.println(this.mStatusBar);
            pw.print(prefix);
            pw.print("isStatusBarKeyguard=");
            pw.print(this.isStatusBarKeyguard());
        }
        if (this.mNavigationBar != null) {
            pw.print(prefix);
            pw.print("mNavigationBar=");
            pw.println(this.mNavigationBar);
        }
        if (this.mFocusedWindow != null) {
            pw.print(prefix);
            pw.print("mFocusedWindow=");
            pw.println(this.mFocusedWindow);
        }
        if (this.mFocusedApp != null) {
            pw.print(prefix);
            pw.print("mFocusedApp=");
            pw.println(this.mFocusedApp);
        }
        if (this.mWinDismissingKeyguard != null) {
            pw.print(prefix);
            pw.print("mWinDismissingKeyguard=");
            pw.println(this.mWinDismissingKeyguard);
        }
        if (this.mTopFullscreenOpaqueWindowState != null) {
            pw.print(prefix);
            pw.print("mTopFullscreenOpaqueWindowState=");
            pw.println(this.mTopFullscreenOpaqueWindowState);
        }
        if (this.mForcingShowNavBar) {
            pw.print(prefix);
            pw.print("mForcingShowNavBar=");
            pw.println(this.mForcingShowNavBar);
            pw.print("mForcingShowNavBarLayer=");
            pw.println(this.mForcingShowNavBarLayer);
        }
        pw.print(prefix);
        pw.print("mTopIsFullscreen=");
        pw.print(this.mTopIsFullscreen);
        pw.print(" mHideLockScreen=");
        pw.println(this.mHideLockScreen);
        pw.print(prefix);
        pw.print("mForceStatusBar=");
        pw.print(this.mForceStatusBar);
        pw.print(" mForceStatusBarFromKeyguard=");
        pw.println(this.mForceStatusBarFromKeyguard);
        pw.print(prefix);
        pw.print("mDismissKeyguard=");
        pw.print(this.mDismissKeyguard);
        pw.print(" mWinDismissingKeyguard=");
        pw.print(this.mWinDismissingKeyguard);
        pw.print(" mHomePressed=");
        pw.println(this.mHomePressed);
        pw.print(prefix);
        pw.print("mAllowLockscreenWhenOn=");
        pw.print(this.mAllowLockscreenWhenOn);
        pw.print(" mLockScreenTimeout=");
        pw.print(this.mLockScreenTimeout);
        pw.print(" mLockScreenTimerActive=");
        pw.println(this.mLockScreenTimerActive);
        pw.print(prefix);
        pw.print("mEndcallBehavior=");
        pw.print(this.mEndcallBehavior);
        pw.print(" mIncallPowerBehavior=");
        pw.print(this.mIncallPowerBehavior);
        pw.print(" mLongPressOnHomeBehavior=");
        pw.println(this.mLongPressOnHomeBehavior);
        pw.print(prefix);
        pw.print("mLandscapeRotation=");
        pw.print(this.mLandscapeRotation);
        pw.print(" mSeascapeRotation=");
        pw.println(this.mSeascapeRotation);
        pw.print(prefix);
        pw.print("mPortraitRotation=");
        pw.print(this.mPortraitRotation);
        pw.print(" mUpsideDownRotation=");
        pw.println(this.mUpsideDownRotation);
        pw.print(prefix);
        pw.print("mDemoHdmiRotation=");
        pw.print(this.mDemoHdmiRotation);
        pw.print(" mDemoHdmiRotationLock=");
        pw.println(this.mDemoHdmiRotationLock);
        pw.print(prefix);
        pw.print("mUndockedHdmiRotation=");
        pw.println(this.mUndockedHdmiRotation);
        this.mGlobalKeyManager.dump(prefix, pw);
        this.mStatusBarController.dump(pw, prefix);
        this.mNavigationBarController.dump(pw, prefix);
        PolicyControl.dump(prefix, pw);
        if (this.mWakeGestureListener != null) {
            this.mWakeGestureListener.dump(pw, prefix);
        }
        if (this.mOrientationListener != null) {
            this.mOrientationListener.dump(pw, prefix);
        }
    }

    static {
        sApplicationLaunchKeyCategories.append(64, "android.intent.category.APP_BROWSER");
        sApplicationLaunchKeyCategories.append(65, "android.intent.category.APP_EMAIL");
        sApplicationLaunchKeyCategories.append(207, "android.intent.category.APP_CONTACTS");
        sApplicationLaunchKeyCategories.append(208, "android.intent.category.APP_CALENDAR");
        sApplicationLaunchKeyCategories.append(209, "android.intent.category.APP_MUSIC");
        sApplicationLaunchKeyCategories.append(210, "android.intent.category.APP_CALCULATOR");
        mTmpParentFrame = new Rect();
        mTmpDisplayFrame = new Rect();
        mTmpOverscanFrame = new Rect();
        mTmpContentFrame = new Rect();
        mTmpVisibleFrame = new Rect();
        mTmpDecorFrame = new Rect();
        mTmpStableFrame = new Rect();
        mTmpNavigationFrame = new Rect();
        WINDOW_TYPES_WHERE_HOME_DOESNT_WORK = new int[]{2003, 2010};
    }

    class ScreenLockTimeout
    implements Runnable {
        Bundle options;

        ScreenLockTimeout() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ScreenLockTimeout screenLockTimeout = this;
            synchronized (screenLockTimeout) {
                if (PhoneWindowManager.this.mKeyguardDelegate != null) {
                    PhoneWindowManager.this.mKeyguardDelegate.doKeyguardTimeout(this.options);
                }
                PhoneWindowManager.this.mLockScreenTimerActive = false;
                this.options = null;
            }
        }

        public void setLockOptions(Bundle options) {
            this.options = options;
        }
    }

    final class HideNavInputEventReceiver
    extends InputEventReceiver {
        public HideNavInputEventReceiver(InputChannel inputChannel, Looper looper) {
            super(inputChannel, looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onInputEvent(InputEvent event) {
            block9: {
                boolean handled = false;
                try {
                    MotionEvent motionEvent;
                    if (!(event instanceof MotionEvent) || (event.getSource() & 2) == 0 || (motionEvent = (MotionEvent)event).getAction() != 0) break block9;
                    boolean changed = false;
                    Object object = PhoneWindowManager.this.mWindowManagerFuncs.getWindowManagerLock();
                    synchronized (object) {
                        int newVal = PhoneWindowManager.this.mResettingSystemUiFlags | 2 | 1 | 4;
                        if (PhoneWindowManager.this.mResettingSystemUiFlags != newVal) {
                            PhoneWindowManager.this.mResettingSystemUiFlags = newVal;
                            changed = true;
                        }
                        if (PhoneWindowManager.this.mForceClearedSystemUiFlags != (newVal = PhoneWindowManager.this.mForceClearedSystemUiFlags | 2)) {
                            PhoneWindowManager.this.mForceClearedSystemUiFlags = newVal;
                            changed = true;
                            PhoneWindowManager.this.mHandler.postDelayed(PhoneWindowManager.this.mClearHideNavigationFlag, 1000L);
                        }
                    }
                    if (changed) {
                        PhoneWindowManager.this.mWindowManagerFuncs.reevaluateStatusBarVisibility();
                    }
                }
                finally {
                    this.finishInputEvent(event, handled);
                }
            }
        }
    }

    class MyOrientationListener
    extends WindowOrientationListener {
        MyOrientationListener(Context context, Handler handler) {
            super(context, handler);
        }

        @Override
        public void onProposedRotationChanged(int rotation) {
            PhoneWindowManager.this.updateRotation(false);
        }
    }

    class MyWakeGestureListener
    extends WakeGestureListener {
        MyWakeGestureListener(Context context, Handler handler) {
            super(context, handler);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onWakeUp() {
            Object object = PhoneWindowManager.this.mLock;
            synchronized (object) {
                if (PhoneWindowManager.this.shouldEnableWakeGestureLp()) {
                    PhoneWindowManager.this.performHapticFeedbackLw(null, 1, false);
                    PhoneWindowManager.this.mPowerManager.wakeUp(SystemClock.uptimeMillis());
                }
            }
        }
    }

    class SettingsObserver
    extends ContentObserver {
        SettingsObserver(Handler handler) {
            super(handler);
        }

        void observe() {
            ContentResolver resolver = PhoneWindowManager.this.mContext.getContentResolver();
            resolver.registerContentObserver(Settings.System.getUriFor("end_button_behavior"), false, this, -1);
            resolver.registerContentObserver(Settings.Secure.getUriFor("incall_power_button_behavior"), false, this, -1);
            resolver.registerContentObserver(Settings.Secure.getUriFor("wake_gesture_enabled"), false, this, -1);
            resolver.registerContentObserver(Settings.System.getUriFor("accelerometer_rotation"), false, this, -1);
            resolver.registerContentObserver(Settings.System.getUriFor("user_rotation"), false, this, -1);
            resolver.registerContentObserver(Settings.System.getUriFor("screen_off_timeout"), false, this, -1);
            resolver.registerContentObserver(Settings.System.getUriFor("pointer_location"), false, this, -1);
            resolver.registerContentObserver(Settings.Secure.getUriFor("default_input_method"), false, this, -1);
            resolver.registerContentObserver(Settings.Secure.getUriFor("immersive_mode_confirmations"), false, this, -1);
            resolver.registerContentObserver(Settings.Global.getUriFor("policy_control"), false, this, -1);
            PhoneWindowManager.this.updateSettings();
        }

        @Override
        public void onChange(boolean selfChange) {
            PhoneWindowManager.this.updateSettings();
            PhoneWindowManager.this.updateRotation(false);
        }
    }

    private class PolicyHandler
    extends Handler {
        private PolicyHandler() {
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    PhoneWindowManager.this.enablePointerLocation();
                    break;
                }
                case 2: {
                    PhoneWindowManager.this.disablePointerLocation();
                    break;
                }
                case 3: {
                    PhoneWindowManager.this.dispatchMediaKeyWithWakeLock((KeyEvent)msg.obj);
                    break;
                }
                case 4: {
                    PhoneWindowManager.this.dispatchMediaKeyRepeatWithWakeLock((KeyEvent)msg.obj);
                    break;
                }
                case 9: {
                    PhoneWindowManager.this.showRecentApps(false);
                    break;
                }
                case 10: {
                    PhoneWindowManager.this.showGlobalActionsInternal();
                    break;
                }
                case 5: {
                    PhoneWindowManager.this.finishKeyguardDrawn();
                    break;
                }
                case 6: {
                    Slog.w(PhoneWindowManager.TAG, "Keyguard drawn timeout. Setting mKeyguardDrawComplete");
                    PhoneWindowManager.this.finishKeyguardDrawn();
                    break;
                }
                case 7: {
                    PhoneWindowManager.this.finishWindowsDrawn();
                    break;
                }
                case 11: {
                    PhoneWindowManager.this.handleHideBootMessage();
                    break;
                }
                case 12: {
                    PhoneWindowManager.this.launchVoiceAssistWithWakeLock(msg.arg1 != 0);
                }
            }
        }
    }
}

