/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.policy.impl;

import android.content.Context;
import android.view.MotionEvent;
import android.view.WindowManagerPolicy;

public class SystemGesturesPointerEventListener
implements WindowManagerPolicy.PointerEventListener {
    private static final String TAG = "SystemGestures";
    private static final boolean DEBUG = false;
    private static final long SWIPE_TIMEOUT_MS = 500L;
    private static final int MAX_TRACKED_POINTERS = 32;
    private static final int UNTRACKED_POINTER = -1;
    private static final int SWIPE_NONE = 0;
    private static final int SWIPE_FROM_TOP = 1;
    private static final int SWIPE_FROM_BOTTOM = 2;
    private static final int SWIPE_FROM_RIGHT = 3;
    private final int mSwipeStartThreshold;
    private final int mSwipeDistanceThreshold;
    private final Callbacks mCallbacks;
    private final int[] mDownPointerId = new int[32];
    private final float[] mDownX = new float[32];
    private final float[] mDownY = new float[32];
    private final long[] mDownTime = new long[32];
    int screenHeight;
    int screenWidth;
    private int mDownPointers;
    private boolean mSwipeFireable;
    private boolean mDebugFireable;

    public SystemGesturesPointerEventListener(Context context, Callbacks callbacks) {
        this.mCallbacks = SystemGesturesPointerEventListener.checkNull("callbacks", callbacks);
        this.mSwipeDistanceThreshold = this.mSwipeStartThreshold = SystemGesturesPointerEventListener.checkNull("context", context).getResources().getDimensionPixelSize(0x1050010);
    }

    private static <T> T checkNull(String name, T arg) {
        if (arg == null) {
            throw new IllegalArgumentException(name + " must not be null");
        }
        return arg;
    }

    @Override
    public void onPointerEvent(MotionEvent event) {
        switch (event.getActionMasked()) {
            case 0: {
                this.mSwipeFireable = true;
                this.mDebugFireable = true;
                this.mDownPointers = 0;
                this.captureDown(event, 0);
                break;
            }
            case 5: {
                this.captureDown(event, event.getActionIndex());
                if (!this.mDebugFireable) break;
                boolean bl = this.mDebugFireable = event.getPointerCount() < 5;
                if (this.mDebugFireable) break;
                this.mCallbacks.onDebug();
                break;
            }
            case 2: {
                if (!this.mSwipeFireable) break;
                int swipe = this.detectSwipe(event);
                boolean bl = this.mSwipeFireable = swipe == 0;
                if (swipe == 1) {
                    this.mCallbacks.onSwipeFromTop();
                    break;
                }
                if (swipe == 2) {
                    this.mCallbacks.onSwipeFromBottom();
                    break;
                }
                if (swipe != 3) break;
                this.mCallbacks.onSwipeFromRight();
                break;
            }
            case 1: 
            case 3: {
                this.mSwipeFireable = false;
                this.mDebugFireable = false;
                break;
            }
        }
    }

    private void captureDown(MotionEvent event, int pointerIndex) {
        int pointerId = event.getPointerId(pointerIndex);
        int i = this.findIndex(pointerId);
        if (i != -1) {
            this.mDownX[i] = event.getX(pointerIndex);
            this.mDownY[i] = event.getY(pointerIndex);
            this.mDownTime[i] = event.getEventTime();
        }
    }

    private int findIndex(int pointerId) {
        for (int i = 0; i < this.mDownPointers; ++i) {
            if (this.mDownPointerId[i] != pointerId) continue;
            return i;
        }
        if (this.mDownPointers == 32 || pointerId == -1) {
            return -1;
        }
        this.mDownPointerId[this.mDownPointers++] = pointerId;
        return this.mDownPointers - 1;
    }

    private int detectSwipe(MotionEvent move) {
        int historySize = move.getHistorySize();
        int pointerCount = move.getPointerCount();
        for (int p = 0; p < pointerCount; ++p) {
            int pointerId = move.getPointerId(p);
            int i = this.findIndex(pointerId);
            if (i == -1) continue;
            for (int h = 0; h < historySize; ++h) {
                float y;
                float x;
                long time = move.getHistoricalEventTime(h);
                int swipe = this.detectSwipe(i, time, x = move.getHistoricalX(p, h), y = move.getHistoricalY(p, h));
                if (swipe == 0) continue;
                return swipe;
            }
            int swipe = this.detectSwipe(i, move.getEventTime(), move.getX(p), move.getY(p));
            if (swipe == 0) continue;
            return swipe;
        }
        return 0;
    }

    private int detectSwipe(int i, long time, float x, float y) {
        float fromX = this.mDownX[i];
        float fromY = this.mDownY[i];
        long elapsed = time - this.mDownTime[i];
        if (fromY <= (float)this.mSwipeStartThreshold && y > fromY + (float)this.mSwipeDistanceThreshold && elapsed < 500L) {
            return 1;
        }
        if (fromY >= (float)(this.screenHeight - this.mSwipeStartThreshold) && y < fromY - (float)this.mSwipeDistanceThreshold && elapsed < 500L) {
            return 2;
        }
        if (fromX >= (float)(this.screenWidth - this.mSwipeStartThreshold) && x < fromX - (float)this.mSwipeDistanceThreshold && elapsed < 500L) {
            return 3;
        }
        return 0;
    }

    static interface Callbacks {
        public void onSwipeFromTop();

        public void onSwipeFromBottom();

        public void onSwipeFromRight();

        public void onDebug();
    }
}

