/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.policy.impl.keyguard;

import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Slog;
import android.view.MotionEvent;
import com.android.internal.policy.IKeyguardExitCallback;
import com.android.internal.policy.IKeyguardService;
import com.android.internal.policy.IKeyguardShowCallback;

public class KeyguardServiceWrapper
implements IKeyguardService {
    private IKeyguardService mService;
    private String TAG = "KeyguardServiceWrapper";

    public KeyguardServiceWrapper(IKeyguardService service) {
        this.mService = service;
    }

    @Override
    public boolean isShowing() {
        try {
            return this.mService.isShowing();
        }
        catch (RemoteException e) {
            Slog.w(this.TAG, "Remote Exception", e);
            return false;
        }
    }

    @Override
    public boolean isSecure() {
        try {
            return this.mService.isSecure();
        }
        catch (RemoteException e) {
            Slog.w(this.TAG, "Remote Exception", e);
            return false;
        }
    }

    @Override
    public boolean isShowingAndNotOccluded() {
        try {
            return this.mService.isShowingAndNotOccluded();
        }
        catch (RemoteException e) {
            Slog.w(this.TAG, "Remote Exception", e);
            return false;
        }
    }

    @Override
    public boolean isInputRestricted() {
        try {
            return this.mService.isInputRestricted();
        }
        catch (RemoteException e) {
            Slog.w(this.TAG, "Remote Exception", e);
            return false;
        }
    }

    @Override
    public boolean isDismissable() {
        try {
            return this.mService.isDismissable();
        }
        catch (RemoteException e) {
            Slog.w(this.TAG, "Remote Exception", e);
            return true;
        }
    }

    @Override
    public void verifyUnlock(IKeyguardExitCallback callback) {
        try {
            this.mService.verifyUnlock(callback);
        }
        catch (RemoteException e) {
            Slog.w(this.TAG, "Remote Exception", e);
        }
    }

    @Override
    public void keyguardDone(boolean authenticated, boolean wakeup) {
        try {
            this.mService.keyguardDone(authenticated, wakeup);
        }
        catch (RemoteException e) {
            Slog.w(this.TAG, "Remote Exception", e);
        }
    }

    @Override
    public int setOccluded(boolean isOccluded) {
        try {
            return this.mService.setOccluded(isOccluded);
        }
        catch (RemoteException e) {
            Slog.w(this.TAG, "Remote Exception", e);
            return 0;
        }
    }

    @Override
    public void dismiss() {
        try {
            this.mService.dismiss();
        }
        catch (RemoteException e) {
            Slog.w(this.TAG, "Remote Exception", e);
        }
    }

    @Override
    public void onDreamingStarted() {
        try {
            this.mService.onDreamingStarted();
        }
        catch (RemoteException e) {
            Slog.w(this.TAG, "Remote Exception", e);
        }
    }

    @Override
    public void onDreamingStopped() {
        try {
            this.mService.onDreamingStopped();
        }
        catch (RemoteException e) {
            Slog.w(this.TAG, "Remote Exception", e);
        }
    }

    @Override
    public void onScreenTurnedOff(int reason) {
        try {
            this.mService.onScreenTurnedOff(reason);
        }
        catch (RemoteException e) {
            Slog.w(this.TAG, "Remote Exception", e);
        }
    }

    @Override
    public void onScreenTurnedOn(IKeyguardShowCallback result) {
        try {
            this.mService.onScreenTurnedOn(result);
        }
        catch (RemoteException e) {
            Slog.w(this.TAG, "Remote Exception", e);
        }
    }

    @Override
    public void setKeyguardEnabled(boolean enabled) {
        try {
            this.mService.setKeyguardEnabled(enabled);
        }
        catch (RemoteException e) {
            Slog.w(this.TAG, "Remote Exception", e);
        }
    }

    @Override
    public void onSystemReady() {
        try {
            this.mService.onSystemReady();
        }
        catch (RemoteException e) {
            Slog.w(this.TAG, "Remote Exception", e);
        }
    }

    @Override
    public void doKeyguardTimeout(Bundle options) {
        try {
            this.mService.doKeyguardTimeout(options);
        }
        catch (RemoteException e) {
            Slog.w(this.TAG, "Remote Exception", e);
        }
    }

    @Override
    public void setCurrentUser(int userId) {
        try {
            this.mService.setCurrentUser(userId);
        }
        catch (RemoteException e) {
            Slog.w(this.TAG, "Remote Exception", e);
        }
    }

    @Override
    public void onBootCompleted() {
        try {
            this.mService.onBootCompleted();
        }
        catch (RemoteException e) {
            Slog.w(this.TAG, "Remote Exception", e);
        }
    }

    @Override
    public void startKeyguardExitAnimation(long startTime, long fadeoutDuration) {
        try {
            this.mService.startKeyguardExitAnimation(startTime, fadeoutDuration);
        }
        catch (RemoteException e) {
            Slog.w(this.TAG, "Remote Exception", e);
        }
    }

    @Override
    public void onActivityDrawn() {
        try {
            this.mService.onActivityDrawn();
        }
        catch (RemoteException e) {
            Slog.w(this.TAG, "Remote Exception", e);
        }
    }

    @Override
    public void showAssistant() {
    }

    @Override
    public void dispatch(MotionEvent event) {
    }

    @Override
    public void launchCamera() {
    }

    @Override
    public IBinder asBinder() {
        return this.mService.asBinder();
    }
}

