/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.SystemProperties;
import android.telephony.PhoneNumberUtils;
import android.text.TextUtils;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.PhoneBase;
import java.io.FileDescriptor;
import java.io.PrintWriter;

public abstract class CallTracker
extends Handler {
    private static final boolean DBG_POLL = false;
    static final int POLL_DELAY_MSEC = 250;
    protected int mPendingOperations;
    protected boolean mNeedsPoll;
    protected Message mLastRelevantPoll;
    protected Connection mHandoverConnection;
    public CommandsInterface mCi;
    protected boolean mNumberConverted = false;
    private final int VALID_COMPARE_LENGTH = 3;
    protected static final int EVENT_POLL_CALLS_RESULT = 1;
    protected static final int EVENT_CALL_STATE_CHANGE = 2;
    protected static final int EVENT_REPOLL_AFTER_DELAY = 3;
    protected static final int EVENT_OPERATION_COMPLETE = 4;
    protected static final int EVENT_GET_LAST_CALL_FAIL_CAUSE = 5;
    protected static final int EVENT_SWITCH_RESULT = 8;
    protected static final int EVENT_RADIO_AVAILABLE = 9;
    protected static final int EVENT_RADIO_NOT_AVAILABLE = 10;
    protected static final int EVENT_CONFERENCE_RESULT = 11;
    protected static final int EVENT_SEPARATE_RESULT = 12;
    protected static final int EVENT_ECT_RESULT = 13;
    protected static final int EVENT_EXIT_ECM_RESPONSE_CDMA = 14;
    protected static final int EVENT_CALL_WAITING_INFO_CDMA = 15;
    protected static final int EVENT_THREE_WAY_DIAL_L2_RESULT_CDMA = 16;
    protected static final int EVENT_THREE_WAY_DIAL_BLANK_FLASH = 20;

    protected void pollCallsWhenSafe() {
        this.mNeedsPoll = true;
        if (this.checkNoOperationsPending()) {
            this.mLastRelevantPoll = this.obtainMessage(1);
            this.mCi.getCurrentCalls(this.mLastRelevantPoll);
        }
    }

    protected void pollCallsAfterDelay() {
        Message msg = this.obtainMessage();
        msg.what = 3;
        this.sendMessageDelayed(msg, 250L);
    }

    protected boolean isCommandExceptionRadioNotAvailable(Throwable e) {
        return e != null && e instanceof CommandException && ((CommandException)e).getCommandError() == CommandException.Error.RADIO_NOT_AVAILABLE;
    }

    protected abstract void handlePollCalls(AsyncResult var1);

    protected void notifySrvccState(Call.SrvccState state, Connection c) {
        if (state == Call.SrvccState.STARTED) {
            this.mHandoverConnection = c;
        } else if (state != Call.SrvccState.COMPLETED) {
            this.mHandoverConnection = null;
        }
    }

    protected void handleRadioAvailable() {
        this.pollCallsWhenSafe();
    }

    protected Message obtainNoPollCompleteMessage(int what) {
        ++this.mPendingOperations;
        this.mLastRelevantPoll = null;
        return this.obtainMessage(what);
    }

    private boolean checkNoOperationsPending() {
        return this.mPendingOperations == 0;
    }

    protected String checkForTestEmergencyNumber(String dialString) {
        String testEn = SystemProperties.get("ril.test.emergencynumber");
        if (!TextUtils.isEmpty(testEn)) {
            String[] values = testEn.split(":");
            this.log("checkForTestEmergencyNumber: values.length=" + values.length);
            if (values.length == 2 && values[0].equals(PhoneNumberUtils.stripSeparators(dialString))) {
                this.mCi.testingEmergencyCall();
                this.log("checkForTestEmergencyNumber: remap " + dialString + " to " + values[1]);
                dialString = values[1];
            }
        }
        return dialString;
    }

    protected String convertNumberIfNecessary(PhoneBase phoneBase, String dialNumber) {
        if (dialNumber == null) {
            return dialNumber;
        }
        String[] convertMaps = phoneBase.getContext().getResources().getStringArray(17236027);
        this.log("convertNumberIfNecessary Roaming convertMaps.length " + convertMaps.length + " dialNumber.length() " + dialNumber.length());
        if (convertMaps.length < 1 || dialNumber.length() < 3) {
            return dialNumber;
        }
        String outNumber = "";
        for (String convertMap : convertMaps) {
            this.log("convertNumberIfNecessary: " + convertMap);
            String[] entry = convertMap.split(":");
            if (entry.length <= 1) continue;
            String[] tmpArray = entry[1].split(",");
            if (TextUtils.isEmpty(entry[0]) || !dialNumber.equals(entry[0])) continue;
            if (tmpArray.length >= 2 && !TextUtils.isEmpty(tmpArray[1])) {
                if (this.compareGid1(phoneBase, tmpArray[1])) {
                    this.mNumberConverted = true;
                }
            } else if (outNumber.isEmpty()) {
                this.mNumberConverted = true;
            }
            if (!this.mNumberConverted) continue;
            if (!TextUtils.isEmpty(tmpArray[0]) && tmpArray[0].endsWith("MDN")) {
                String prefix = tmpArray[0].substring(0, tmpArray[0].length() - 3);
                outNumber = prefix + phoneBase.getLine1Number();
                continue;
            }
            outNumber = tmpArray[0];
        }
        if (this.mNumberConverted) {
            this.log("convertNumberIfNecessary: convert service number");
            return outNumber;
        }
        return dialNumber;
    }

    private boolean compareGid1(PhoneBase phoneBase, String serviceGid1) {
        String gid1 = phoneBase.getGroupIdLevel1();
        int gid_length = serviceGid1.length();
        boolean ret = true;
        if (serviceGid1 == null || serviceGid1.equals("")) {
            this.log("compareGid1 serviceGid is empty, return " + ret);
            return ret;
        }
        if (gid1 == null || gid1.length() < gid_length || !gid1.substring(0, gid_length).equalsIgnoreCase(serviceGid1)) {
            this.log(" gid1 " + gid1 + " serviceGid1 " + serviceGid1);
            ret = false;
        }
        this.log("compareGid1 is " + (ret ? "Same" : "Different"));
        return ret;
    }

    @Override
    public abstract void handleMessage(Message var1);

    public abstract void registerForVoiceCallStarted(Handler var1, int var2, Object var3);

    public abstract void unregisterForVoiceCallStarted(Handler var1);

    public abstract void registerForVoiceCallEnded(Handler var1, int var2, Object var3);

    public abstract void unregisterForVoiceCallEnded(Handler var1);

    protected abstract void log(String var1);

    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("CallTracker:");
        pw.println(" mPendingOperations=" + this.mPendingOperations);
        pw.println(" mNeedsPoll=" + this.mNeedsPoll);
        pw.println(" mLastRelevantPoll=" + this.mLastRelevantPoll);
    }
}

