/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.os.SystemClock;
import android.telecom.Connection;
import android.telephony.Rlog;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.UUSInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public abstract class Connection {
    public static final int AUDIO_QUALITY_STANDARD = 1;
    public static final int AUDIO_QUALITY_HIGH_DEFINITION = 2;
    protected String mCnapName;
    protected int mCnapNamePresentation = 1;
    protected String mAddress;
    protected String mDialString;
    protected int mNumberPresentation = 1;
    protected boolean mIsIncoming;
    protected long mCreateTime;
    protected long mConnectTime;
    protected long mConnectTimeReal;
    protected long mDuration;
    protected long mHoldingStartTime;
    protected Connection mOrigConnection;
    private List<PostDialListener> mPostDialListeners = new ArrayList<PostDialListener>();
    public Set<Listener> mListeners = new CopyOnWriteArraySet<Listener>();
    protected boolean mNumberConverted = false;
    protected String mConvertedNumber;
    private static String LOG_TAG = "Connection";
    Object mUserData;
    private int mVideoState;
    private boolean mLocalVideoCapable;
    private boolean mRemoteVideoCapable;
    private int mAudioQuality;
    private Connection.VideoProvider mVideoProvider;

    public String getAddress() {
        return this.mAddress;
    }

    public String getCnapName() {
        return this.mCnapName;
    }

    public String getOrigDialString() {
        return null;
    }

    public int getCnapNamePresentation() {
        return this.mCnapNamePresentation;
    }

    public abstract Call getCall();

    public long getCreateTime() {
        return this.mCreateTime;
    }

    public long getConnectTime() {
        return this.mConnectTime;
    }

    public long getConnectTimeReal() {
        return this.mConnectTimeReal;
    }

    public abstract long getDisconnectTime();

    public long getDurationMillis() {
        if (this.mConnectTimeReal == 0L) {
            return 0L;
        }
        if (this.mDuration == 0L) {
            return SystemClock.elapsedRealtime() - this.mConnectTimeReal;
        }
        return this.mDuration;
    }

    public long getHoldingStartTime() {
        return this.mHoldingStartTime;
    }

    public abstract long getHoldDurationMillis();

    public abstract int getDisconnectCause();

    public boolean isIncoming() {
        return this.mIsIncoming;
    }

    public Call.State getState() {
        Call c = this.getCall();
        if (c == null) {
            return Call.State.IDLE;
        }
        return c.getState();
    }

    public boolean isAlive() {
        return this.getState().isAlive();
    }

    public boolean isRinging() {
        return this.getState().isRinging();
    }

    public Object getUserData() {
        return this.mUserData;
    }

    public void setUserData(Object userdata) {
        this.mUserData = userdata;
    }

    public abstract void hangup() throws CallStateException;

    public abstract void separate() throws CallStateException;

    public void clearUserData() {
        this.mUserData = null;
    }

    public final void addPostDialListener(PostDialListener listener) {
        if (!this.mPostDialListeners.contains(listener)) {
            this.mPostDialListeners.add(listener);
        }
    }

    protected final void clearPostDialListeners() {
        this.mPostDialListeners.clear();
    }

    protected final void notifyPostDialListeners() {
        if (this.getPostDialState() == PostDialState.WAIT) {
            for (PostDialListener listener : new ArrayList<PostDialListener>(this.mPostDialListeners)) {
                listener.onPostDialWait();
            }
        }
    }

    public abstract PostDialState getPostDialState();

    public abstract String getRemainingPostDialString();

    public abstract void proceedAfterWaitChar();

    public abstract void proceedAfterWildChar(String var1);

    public abstract void cancelPostDial();

    public abstract int getNumberPresentation();

    public abstract UUSInfo getUUSInfo();

    public abstract int getPreciseDisconnectCause();

    public Connection getOrigConnection() {
        return this.mOrigConnection;
    }

    public abstract boolean isMultiparty();

    public void migrateFrom(Connection c) {
        if (c == null) {
            return;
        }
        this.mListeners = c.mListeners;
        this.mAddress = c.getAddress();
        this.mNumberPresentation = c.getNumberPresentation();
        this.mDialString = c.getOrigDialString();
        this.mCnapName = c.getCnapName();
        this.mCnapNamePresentation = c.getCnapNamePresentation();
        this.mIsIncoming = c.isIncoming();
        this.mCreateTime = c.getCreateTime();
        this.mConnectTime = c.getConnectTime();
        this.mConnectTimeReal = c.getConnectTimeReal();
        this.mHoldingStartTime = c.getHoldingStartTime();
        this.mOrigConnection = c.getOrigConnection();
    }

    public final void addListener(Listener listener) {
        this.mListeners.add(listener);
    }

    public final void removeListener(Listener listener) {
        this.mListeners.remove(listener);
    }

    public int getVideoState() {
        return this.mVideoState;
    }

    public boolean isLocalVideoCapable() {
        return this.mLocalVideoCapable;
    }

    public boolean isRemoteVideoCapable() {
        return this.mRemoteVideoCapable;
    }

    public Connection.VideoProvider getVideoProvider() {
        return this.mVideoProvider;
    }

    public int getAudioQuality() {
        return this.mAudioQuality;
    }

    public void setVideoState(int videoState) {
        this.mVideoState = videoState;
        for (Listener l : this.mListeners) {
            l.onVideoStateChanged(this.mVideoState);
        }
    }

    public void setLocalVideoCapable(boolean capable) {
        this.mLocalVideoCapable = capable;
        for (Listener l : this.mListeners) {
            l.onLocalVideoCapabilityChanged(this.mLocalVideoCapable);
        }
    }

    public void setRemoteVideoCapable(boolean capable) {
        this.mRemoteVideoCapable = capable;
        for (Listener l : this.mListeners) {
            l.onRemoteVideoCapabilityChanged(this.mRemoteVideoCapable);
        }
    }

    public void setAudioQuality(int audioQuality) {
        this.mAudioQuality = audioQuality;
        for (Listener l : this.mListeners) {
            l.onAudioQualityChanged(this.mAudioQuality);
        }
    }

    public void setVideoProvider(Connection.VideoProvider videoProvider) {
        this.mVideoProvider = videoProvider;
        for (Listener l : this.mListeners) {
            l.onVideoProviderChanged(this.mVideoProvider);
        }
    }

    public void setConverted(String oriNumber) {
        this.mNumberConverted = true;
        this.mConvertedNumber = this.mAddress;
        this.mAddress = oriNumber;
        this.mDialString = oriNumber;
    }

    public String toString() {
        StringBuilder str = new StringBuilder(128);
        if (Rlog.isLoggable(LOG_TAG, 3)) {
            str.append("addr: " + this.getAddress()).append(" pres.: " + this.getNumberPresentation()).append(" dial: " + this.getOrigDialString()).append(" postdial: " + this.getRemainingPostDialString()).append(" cnap name: " + this.getCnapName()).append("(" + this.getCnapNamePresentation() + ")");
        }
        str.append(" incoming: " + this.isIncoming()).append(" state: " + (Object)((Object)this.getState())).append(" post dial state: " + (Object)((Object)this.getPostDialState()));
        return str.toString();
    }

    public static enum PostDialState {
        NOT_STARTED,
        STARTED,
        WAIT,
        WILD,
        COMPLETE,
        CANCELLED,
        PAUSE;

    }

    public static abstract class ListenerBase
    implements Listener {
        @Override
        public void onVideoStateChanged(int videoState) {
        }

        @Override
        public void onLocalVideoCapabilityChanged(boolean capable) {
        }

        @Override
        public void onRemoteVideoCapabilityChanged(boolean capable) {
        }

        @Override
        public void onVideoProviderChanged(Connection.VideoProvider videoProvider) {
        }

        @Override
        public void onAudioQualityChanged(int audioQuality) {
        }
    }

    public static interface Listener {
        public void onVideoStateChanged(int var1);

        public void onLocalVideoCapabilityChanged(boolean var1);

        public void onRemoteVideoCapabilityChanged(boolean var1);

        public void onVideoProviderChanged(Connection.VideoProvider var1);

        public void onAudioQualityChanged(int var1);
    }

    public static interface PostDialListener {
        public void onPostDialWait();
    }
}

