/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.telephony.Rlog;
import com.android.internal.telephony.PhoneBase;
import com.android.internal.telephony.PhoneFactory;
import com.android.internal.telephony.PhoneProxy;
import com.android.internal.telephony.RIL;
import com.android.internal.telephony.SubscriptionController;
import com.android.internal.telephony.uicc.IccCardProxy;
import com.android.internal.telephony.uicc.UiccController;
import java.io.FileDescriptor;
import java.io.PrintWriter;

public class DebugService {
    private static String TAG = "DebugService";

    public DebugService() {
        DebugService.log("DebugService:");
    }

    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        DebugService.log("dump: +");
        PhoneProxy phoneProxy = null;
        PhoneBase phoneBase = null;
        try {
            phoneProxy = (PhoneProxy)PhoneFactory.getDefaultPhone();
        }
        catch (Exception e) {
            pw.println("Telephony DebugService: Could not getDefaultPhone e=" + e);
            return;
        }
        try {
            phoneBase = (PhoneBase)phoneProxy.getActivePhone();
        }
        catch (Exception e) {
            pw.println("Telephony DebugService: Could not PhoneBase e=" + e);
            return;
        }
        pw.println();
        pw.println("++++++++++++++++++++++++++++++++");
        pw.flush();
        try {
            phoneBase.dump(fd, pw, args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        pw.flush();
        pw.println("++++++++++++++++++++++++++++++++");
        try {
            phoneBase.mDcTracker.dump(fd, pw, args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        pw.flush();
        pw.println("++++++++++++++++++++++++++++++++");
        try {
            phoneBase.getServiceStateTracker().dump(fd, pw, args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        pw.flush();
        pw.println("++++++++++++++++++++++++++++++++");
        try {
            phoneBase.getCallTracker().dump(fd, pw, args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        pw.flush();
        pw.println("++++++++++++++++++++++++++++++++");
        try {
            ((RIL)phoneBase.mCi).dump(fd, pw, args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        pw.flush();
        pw.println("++++++++++++++++++++++++++++++++");
        try {
            UiccController.getInstance().dump(fd, pw, args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        pw.flush();
        pw.println("++++++++++++++++++++++++++++++++");
        try {
            ((IccCardProxy)phoneProxy.getIccCard()).dump(fd, pw, args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        pw.flush();
        pw.println("++++++++++++++++++++++++++++++++");
        try {
            SubscriptionController.getInstance().dump(fd, pw, args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        pw.flush();
        DebugService.log("dump: -");
    }

    private static void log(String s) {
        Rlog.d(TAG, "DebugService " + s);
    }
}

