/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.net.LocalServerSocket;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.provider.Settings;
import android.telephony.Rlog;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.DefaultPhoneNotifier;
import com.android.internal.telephony.MccTable;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneBase;
import com.android.internal.telephony.PhoneNotifier;
import com.android.internal.telephony.PhoneProxy;
import com.android.internal.telephony.ProxyController;
import com.android.internal.telephony.RIL;
import com.android.internal.telephony.SmsApplication;
import com.android.internal.telephony.SubInfoRecordUpdater;
import com.android.internal.telephony.SubscriptionController;
import com.android.internal.telephony.TelephonyDevController;
import com.android.internal.telephony.cdma.CDMALTEPhone;
import com.android.internal.telephony.cdma.CDMAPhone;
import com.android.internal.telephony.cdma.CdmaSubscriptionSourceManager;
import com.android.internal.telephony.gsm.GSMPhone;
import com.android.internal.telephony.imsphone.ImsPhone;
import com.android.internal.telephony.imsphone.ImsPhoneFactory;
import com.android.internal.telephony.sip.SipPhone;
import com.android.internal.telephony.sip.SipPhoneFactory;
import com.android.internal.telephony.uicc.UiccController;
import java.io.IOException;

public class PhoneFactory {
    static final String LOG_TAG = "PhoneFactory";
    static final int SOCKET_OPEN_RETRY_MILLIS = 2000;
    static final int SOCKET_OPEN_MAX_RETRY = 3;
    static final Object sLockProxyPhones = new Object();
    private static PhoneProxy[] sProxyPhones = null;
    private static PhoneProxy sProxyPhone = null;
    private static CommandsInterface[] sCommandsInterfaces = null;
    private static ProxyController mProxyController;
    private static UiccController mUiccController;
    private static CommandsInterface sCommandsInterface;
    private static SubInfoRecordUpdater sSubInfoRecordUpdater;
    private static boolean sMadeDefaults;
    private static PhoneNotifier sPhoneNotifier;
    private static Context sContext;

    public static void makeDefaultPhones(Context context) {
        PhoneFactory.makeDefaultPhone(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void makeDefaultPhone(Context context) {
        Object object = sLockProxyPhones;
        synchronized (object) {
            if (!sMadeDefaults) {
                int i;
                sContext = context;
                TelephonyDevController.create();
                int retryCount = 0;
                while (true) {
                    boolean hasException = false;
                    ++retryCount;
                    try {
                        new LocalServerSocket("com.android.internal.telephony");
                    }
                    catch (IOException ex) {
                        hasException = true;
                    }
                    if (!hasException) break;
                    if (retryCount > 3) {
                        throw new RuntimeException("PhoneFactory probably already running");
                    }
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException er) {}
                }
                sPhoneNotifier = new DefaultPhoneNotifier();
                int preferredNetworkMode = 0;
                if (TelephonyManager.getLteOnCdmaModeStatic() == 1) {
                    preferredNetworkMode = 7;
                }
                int cdmaSubscription = CdmaSubscriptionSourceManager.getDefault(context);
                Rlog.i(LOG_TAG, "Cdma Subscription set to " + cdmaSubscription);
                int numPhones = TelephonyManager.getDefault().getPhoneCount();
                int[] networkModes = new int[numPhones];
                sProxyPhones = new PhoneProxy[numPhones];
                sCommandsInterfaces = new RIL[numPhones];
                for (i = 0; i < numPhones; ++i) {
                    try {
                        networkModes[i] = TelephonyManager.getIntAtIndex(context.getContentResolver(), "preferred_network_mode", i);
                    }
                    catch (Settings.SettingNotFoundException snfe) {
                        Rlog.e(LOG_TAG, "Settings Exception Reading Value At Index for Settings.Global.PREFERRED_NETWORK_MODE");
                        networkModes[i] = preferredNetworkMode;
                    }
                    Rlog.i(LOG_TAG, "Network Mode set to " + Integer.toString(networkModes[i]));
                    PhoneFactory.sCommandsInterfaces[i] = new RIL(context, networkModes[i], cdmaSubscription, i);
                }
                Rlog.i(LOG_TAG, "Creating SubscriptionController");
                SubscriptionController.init(context, sCommandsInterfaces);
                mUiccController = UiccController.make(context, sCommandsInterfaces);
                for (i = 0; i < numPhones; ++i) {
                    PhoneBase phone = null;
                    int phoneType = TelephonyManager.getPhoneType(networkModes[i]);
                    if (phoneType == 1) {
                        phone = new GSMPhone(context, sCommandsInterfaces[i], sPhoneNotifier, i);
                    } else if (phoneType == 2) {
                        phone = new CDMALTEPhone(context, sCommandsInterfaces[i], sPhoneNotifier, i);
                    }
                    Rlog.i(LOG_TAG, "Creating Phone with type = " + phoneType + " sub = " + i);
                    PhoneFactory.sProxyPhones[i] = new PhoneProxy(phone);
                }
                mProxyController = ProxyController.getInstance(context, sProxyPhones, mUiccController, sCommandsInterfaces);
                sProxyPhone = sProxyPhones[0];
                sCommandsInterface = sCommandsInterfaces[0];
                ComponentName componentName = SmsApplication.getDefaultSmsApplication(context, true);
                String packageName = "NONE";
                if (componentName != null) {
                    packageName = componentName.getPackageName();
                }
                Rlog.i(LOG_TAG, "defaultSmsApplication: " + packageName);
                SmsApplication.initSmsPackageMonitor(context);
                sMadeDefaults = true;
                Rlog.i(LOG_TAG, "Creating SubInfoRecordUpdater ");
                sSubInfoRecordUpdater = new SubInfoRecordUpdater(context, sProxyPhones, sCommandsInterfaces);
                SubscriptionController.getInstance().updatePhonesAvailability(sProxyPhones);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Phone getCdmaPhone(int phoneId) {
        CDMALTEPhone phone;
        Object object = PhoneProxy.lockForRadioTechnologyChange;
        synchronized (object) {
            phone = new CDMALTEPhone(sContext, sCommandsInterfaces[phoneId], sPhoneNotifier, phoneId);
        }
        return phone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Phone getGsmPhone(int phoneId) {
        Object object = PhoneProxy.lockForRadioTechnologyChange;
        synchronized (object) {
            GSMPhone phone = new GSMPhone(sContext, sCommandsInterfaces[phoneId], sPhoneNotifier, phoneId);
            return phone;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Phone getDefaultPhone() {
        Object object = sLockProxyPhones;
        synchronized (object) {
            if (!sMadeDefaults) {
                throw new IllegalStateException("Default phones haven't been made yet!");
            }
            return sProxyPhone;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Phone getPhone(int phoneId) {
        Object object = sLockProxyPhones;
        synchronized (object) {
            PhoneProxy phone;
            if (!sMadeDefaults) {
                throw new IllegalStateException("Default phones haven't been made yet!");
            }
            if (phoneId == Integer.MAX_VALUE) {
                Rlog.d(LOG_TAG, "getPhone: phoneId == DEFAULT_PHONE_ID");
                phone = sProxyPhone;
            } else {
                Rlog.d(LOG_TAG, "getPhone: phoneId != DEFAULT_PHONE_ID");
                phone = phoneId >= 0 && phoneId < TelephonyManager.getDefault().getPhoneCount() ? sProxyPhones[phoneId] : null;
            }
            Rlog.d(LOG_TAG, "getPhone:- phone=" + phone);
            return phone;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Phone[] getPhones() {
        Object object = sLockProxyPhones;
        synchronized (object) {
            if (!sMadeDefaults) {
                throw new IllegalStateException("Default phones haven't been made yet!");
            }
            return sProxyPhones;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Phone getCdmaPhone() {
        CDMAPhone phone;
        if (!sMadeDefaults) {
            throw new IllegalStateException("Default phones haven't been made yet!");
        }
        Object object = PhoneProxy.lockForRadioTechnologyChange;
        synchronized (object) {
            switch (TelephonyManager.getLteOnCdmaModeStatic()) {
                case 1: {
                    phone = new CDMALTEPhone(sContext, sCommandsInterface, sPhoneNotifier);
                    break;
                }
                default: {
                    phone = new CDMAPhone(sContext, sCommandsInterface, sPhoneNotifier);
                }
            }
        }
        return phone;
    }

    public static Phone getGsmPhone() {
        int phoneId = SubscriptionController.getInstance().getPhoneId(PhoneFactory.getDefaultSubscription());
        if (phoneId < 0 || phoneId >= TelephonyManager.getDefault().getPhoneCount()) {
            phoneId = 0;
        }
        return PhoneFactory.getGsmPhone(phoneId);
    }

    public static SipPhone makeSipPhone(String sipUri) {
        return SipPhoneFactory.makePhone(sipUri, sContext, sPhoneNotifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefaultSubscription(int subId) {
        SystemProperties.set("persist.radio.default.sub", Integer.toString(subId));
        int phoneId = SubscriptionController.getInstance().getPhoneId(subId);
        Object object = sLockProxyPhones;
        synchronized (object) {
            if (phoneId >= 0 && phoneId < sProxyPhones.length) {
                sProxyPhone = sProxyPhones[phoneId];
                sCommandsInterface = sCommandsInterfaces[phoneId];
                sMadeDefaults = true;
            }
        }
        String defaultMccMnc = TelephonyManager.getDefault().getSimOperator(phoneId);
        Rlog.d(LOG_TAG, "update mccmnc=" + defaultMccMnc);
        MccTable.updateMccMncConfiguration(sContext, defaultMccMnc, false);
        Intent intent = new Intent("android.intent.action.ACTION_DEFAULT_SUBSCRIPTION_CHANGED");
        intent.addFlags(0x20000000);
        SubscriptionManager.putPhoneIdAndSubIdExtra(intent, phoneId);
        Rlog.d(LOG_TAG, "setDefaultSubscription : " + subId + " Broadcasting Default Subscription Changed...");
        sContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
    }

    public static int calculatePreferredNetworkType(Context context) {
        int preferredNetworkType = 0;
        if (TelephonyManager.getLteOnCdmaModeStatic() == 1) {
            preferredNetworkType = 7;
        }
        int networkType = Settings.Global.getInt(context.getContentResolver(), "preferred_network_mode", preferredNetworkType);
        return networkType;
    }

    public static long getDefaultSubscription() {
        return SubscriptionController.getInstance().getDefaultSubId();
    }

    public static int getVoiceSubscription() {
        int subId = 0;
        try {
            subId = Settings.Global.getInt(sContext.getContentResolver(), "multi_sim_voice_call");
        }
        catch (Settings.SettingNotFoundException snfe) {
            Rlog.e(LOG_TAG, "Settings Exception Reading Dual Sim Voice Call Values");
        }
        int phoneId = SubscriptionController.getInstance().getPhoneId(subId);
        if (phoneId < 0 || phoneId >= TelephonyManager.getDefault().getPhoneCount()) {
            Rlog.i(LOG_TAG, "Subscription is invalid..." + subId + " Set to 0");
            subId = 0;
            PhoneFactory.setVoiceSubscription(subId);
        }
        return subId;
    }

    public static boolean isPromptEnabled() {
        boolean prompt = false;
        int value = 0;
        try {
            value = Settings.Global.getInt(sContext.getContentResolver(), "multi_sim_voice_prompt");
        }
        catch (Settings.SettingNotFoundException snfe) {
            Rlog.e(LOG_TAG, "Settings Exception Reading Dual Sim Voice Prompt Values");
        }
        prompt = value != 0;
        Rlog.d(LOG_TAG, "Prompt option:" + prompt);
        return prompt;
    }

    public static void setPromptEnabled(boolean enabled) {
        int value = !enabled ? 0 : 1;
        Settings.Global.putInt(sContext.getContentResolver(), "multi_sim_voice_prompt", value);
        Rlog.d(LOG_TAG, "setVoicePromptOption to " + enabled);
    }

    public static boolean isSMSPromptEnabled() {
        boolean prompt = false;
        int value = 0;
        try {
            value = Settings.Global.getInt(sContext.getContentResolver(), "multi_sim_sms_prompt");
        }
        catch (Settings.SettingNotFoundException snfe) {
            Rlog.e(LOG_TAG, "Settings Exception Reading Dual Sim SMS Prompt Values");
        }
        prompt = value != 0;
        Rlog.d(LOG_TAG, "SMS Prompt option:" + prompt);
        return prompt;
    }

    public static void setSMSPromptEnabled(boolean enabled) {
        int value = !enabled ? 0 : 1;
        Settings.Global.putInt(sContext.getContentResolver(), "multi_sim_sms_prompt", value);
        Rlog.d(LOG_TAG, "setSMSPromptOption to " + enabled);
    }

    public static long getDataSubscription() {
        long subId = 1L;
        try {
            subId = Settings.Global.getLong(sContext.getContentResolver(), "multi_sim_data_call");
        }
        catch (Settings.SettingNotFoundException snfe) {
            Rlog.e(LOG_TAG, "Settings Exception Reading Dual Sim Data Call Values");
        }
        int phoneId = SubscriptionController.getInstance().getPhoneId(subId);
        if (phoneId < 0 || phoneId >= TelephonyManager.getDefault().getPhoneCount()) {
            subId = 1L;
            Rlog.i(LOG_TAG, "Subscription is invalid..." + subId + " Set to 0");
            PhoneFactory.setDataSubscription(subId);
        }
        return subId;
    }

    public static int getSMSSubscription() {
        int subId = 0;
        try {
            subId = Settings.Global.getInt(sContext.getContentResolver(), "multi_sim_sms");
        }
        catch (Settings.SettingNotFoundException snfe) {
            Rlog.e(LOG_TAG, "Settings Exception Reading Dual Sim SMS Values");
        }
        int phoneId = SubscriptionController.getInstance().getPhoneId(subId);
        if (phoneId < 0 || phoneId >= TelephonyManager.getDefault().getPhoneCount()) {
            Rlog.i(LOG_TAG, "Subscription is invalid..." + subId + " Set to 0");
            subId = 0;
            PhoneFactory.setSMSSubscription(subId);
        }
        return subId;
    }

    public static void setVoiceSubscription(int subId) {
        Settings.Global.putInt(sContext.getContentResolver(), "multi_sim_voice_call", subId);
        Rlog.d(LOG_TAG, "setVoiceSubscription : " + subId);
    }

    public static void setDataSubscription(long subId) {
        Settings.Global.putLong(sContext.getContentResolver(), "multi_sim_data_call", subId);
        Rlog.d(LOG_TAG, "setDataSubscription: " + subId);
        boolean enabled = Settings.Global.getInt(sContext.getContentResolver(), "mobile_data" + subId, 0) != 0;
        Settings.Global.putInt(sContext.getContentResolver(), "mobile_data", enabled ? 1 : 0);
        Rlog.d(LOG_TAG, "set mobile_data: " + enabled);
        enabled = Settings.Global.getInt(sContext.getContentResolver(), "data_roaming" + subId, 0) != 0;
        Settings.Global.putInt(sContext.getContentResolver(), "data_roaming", enabled ? 1 : 0);
        Rlog.d(LOG_TAG, "set data_roaming: " + enabled);
    }

    public static void setSMSSubscription(int subId) {
        Settings.Global.putInt(sContext.getContentResolver(), "multi_sim_sms", subId);
        Intent intent = new Intent("com.android.mms.transaction.SEND_MESSAGE");
        sContext.sendBroadcast(intent);
        Rlog.d(LOG_TAG, "setSMSSubscription : " + subId);
    }

    public static ImsPhone makeImsPhone(PhoneNotifier phoneNotifier, Phone defaultPhone) {
        return ImsPhoneFactory.makePhone(sContext, phoneNotifier, defaultPhone);
    }

    static {
        sCommandsInterface = null;
        sSubInfoRecordUpdater = null;
        sMadeDefaults = false;
    }
}

