/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.os.RemoteException;
import android.os.ServiceManager;
import android.telephony.Rlog;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import com.android.internal.telephony.IPhoneSubInfo;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneFactory;
import com.android.internal.telephony.PhoneProxy;
import com.android.internal.telephony.PhoneSubInfoProxy;

public class PhoneSubInfoController
extends IPhoneSubInfo.Stub {
    private static final String TAG = "PhoneSubInfoController";
    private Phone[] mPhone;

    public PhoneSubInfoController(Phone[] phone) {
        this.mPhone = phone;
        if (ServiceManager.getService("iphonesubinfo") == null) {
            ServiceManager.addService("iphonesubinfo", this);
        }
    }

    @Override
    public String getDeviceId() {
        return this.getDeviceIdForSubscriber(this.getDefaultSubscription());
    }

    @Override
    public String getDeviceIdForSubscriber(long subId) {
        PhoneSubInfoProxy phoneSubInfoProxy = this.getPhoneSubInfoProxy(subId);
        if (phoneSubInfoProxy != null) {
            return phoneSubInfoProxy.getDeviceId();
        }
        Rlog.e(TAG, "getDeviceId phoneSubInfoProxy is null for Subscription:" + subId);
        return null;
    }

    @Override
    public String getImeiForSubscriber(long subId) {
        PhoneSubInfoProxy phoneSubInfoProxy = this.getPhoneSubInfoProxy(subId);
        if (phoneSubInfoProxy != null) {
            return phoneSubInfoProxy.getImei();
        }
        Rlog.e(TAG, "getDeviceId phoneSubInfoProxy is null for Subscription:" + subId);
        return null;
    }

    @Override
    public String getDeviceSvn() {
        PhoneSubInfoProxy phoneSubInfoProxy = this.getPhoneSubInfoProxy(this.getDefaultSubscription());
        if (phoneSubInfoProxy != null) {
            return phoneSubInfoProxy.getDeviceSvn();
        }
        Rlog.e(TAG, "getDeviceSvn phoneSubInfoProxy is null");
        return null;
    }

    @Override
    public String getSubscriberId() {
        return this.getSubscriberIdForSubscriber(this.getDefaultSubscription());
    }

    @Override
    public String getSubscriberIdForSubscriber(long subId) {
        PhoneSubInfoProxy phoneSubInfoProxy = this.getPhoneSubInfoProxy(subId);
        if (phoneSubInfoProxy != null) {
            return phoneSubInfoProxy.getSubscriberId();
        }
        Rlog.e(TAG, "getSubscriberId phoneSubInfoProxy is null for Subscription:" + subId);
        return null;
    }

    @Override
    public String getIccSerialNumber() {
        return this.getIccSerialNumberForSubscriber(this.getDefaultSubscription());
    }

    @Override
    public String getIccSerialNumberForSubscriber(long subId) {
        PhoneSubInfoProxy phoneSubInfoProxy = this.getPhoneSubInfoProxy(subId);
        if (phoneSubInfoProxy != null) {
            return phoneSubInfoProxy.getIccSerialNumber();
        }
        Rlog.e(TAG, "getIccSerialNumber phoneSubInfoProxy is null for Subscription:" + subId);
        return null;
    }

    @Override
    public String getLine1Number() {
        return this.getLine1NumberForSubscriber(this.getDefaultSubscription());
    }

    @Override
    public String getLine1NumberForSubscriber(long subId) {
        PhoneSubInfoProxy phoneSubInfoProxy = this.getPhoneSubInfoProxy(subId);
        if (phoneSubInfoProxy != null) {
            return phoneSubInfoProxy.getLine1Number();
        }
        Rlog.e(TAG, "getLine1Number phoneSubInfoProxy is null for Subscription:" + subId);
        return null;
    }

    @Override
    public String getLine1AlphaTag() {
        return this.getLine1AlphaTagForSubscriber(this.getDefaultSubscription());
    }

    @Override
    public String getLine1AlphaTagForSubscriber(long subId) {
        PhoneSubInfoProxy phoneSubInfoProxy = this.getPhoneSubInfoProxy(subId);
        if (phoneSubInfoProxy != null) {
            return phoneSubInfoProxy.getLine1AlphaTag();
        }
        Rlog.e(TAG, "getLine1AlphaTag phoneSubInfoProxy is null for Subscription:" + subId);
        return null;
    }

    @Override
    public String getMsisdn() {
        return this.getMsisdnForSubscriber(this.getDefaultSubscription());
    }

    @Override
    public String getMsisdnForSubscriber(long subId) {
        PhoneSubInfoProxy phoneSubInfoProxy = this.getPhoneSubInfoProxy(subId);
        if (phoneSubInfoProxy != null) {
            return phoneSubInfoProxy.getMsisdn();
        }
        Rlog.e(TAG, "getMsisdn phoneSubInfoProxy is null for Subscription:" + subId);
        return null;
    }

    @Override
    public String getVoiceMailNumber() {
        return this.getVoiceMailNumberForSubscriber(this.getDefaultSubscription());
    }

    @Override
    public String getVoiceMailNumberForSubscriber(long subId) {
        PhoneSubInfoProxy phoneSubInfoProxy = this.getPhoneSubInfoProxy(subId);
        if (phoneSubInfoProxy != null) {
            return phoneSubInfoProxy.getVoiceMailNumber();
        }
        Rlog.e(TAG, "getVoiceMailNumber phoneSubInfoProxy is null for Subscription:" + subId);
        return null;
    }

    @Override
    public String getCompleteVoiceMailNumber() {
        return this.getCompleteVoiceMailNumberForSubscriber(this.getDefaultSubscription());
    }

    @Override
    public String getCompleteVoiceMailNumberForSubscriber(long subId) {
        PhoneSubInfoProxy phoneSubInfoProxy = this.getPhoneSubInfoProxy(subId);
        if (phoneSubInfoProxy != null) {
            return phoneSubInfoProxy.getCompleteVoiceMailNumber();
        }
        Rlog.e(TAG, "getCompleteVoiceMailNumber phoneSubInfoProxy is null for Subscription:" + subId);
        return null;
    }

    @Override
    public String getVoiceMailAlphaTag() {
        return this.getVoiceMailAlphaTagForSubscriber(this.getDefaultSubscription());
    }

    @Override
    public String getVoiceMailAlphaTagForSubscriber(long subId) {
        PhoneSubInfoProxy phoneSubInfoProxy = this.getPhoneSubInfoProxy(subId);
        if (phoneSubInfoProxy != null) {
            return phoneSubInfoProxy.getVoiceMailAlphaTag();
        }
        Rlog.e(TAG, "getVoiceMailAlphaTag phoneSubInfoProxy is null for Subscription:" + subId);
        return null;
    }

    private PhoneSubInfoProxy getPhoneSubInfoProxy(long subId) {
        long phoneId = SubscriptionManager.getPhoneId(subId);
        if (phoneId < 0L || phoneId >= (long)TelephonyManager.getDefault().getPhoneCount()) {
            phoneId = 0L;
        }
        try {
            return ((PhoneProxy)this.mPhone[(int)phoneId]).getPhoneSubInfoProxy();
        }
        catch (NullPointerException e) {
            Rlog.e(TAG, "Exception is :" + e.toString() + " For subId :" + subId);
            e.printStackTrace();
            return null;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Rlog.e(TAG, "Exception is :" + e.toString() + " For subId :" + subId);
            e.printStackTrace();
            return null;
        }
    }

    private long getDefaultSubscription() {
        return PhoneFactory.getDefaultSubscription();
    }

    @Override
    public String getIsimImpi() {
        PhoneSubInfoProxy phoneSubInfoProxy = this.getPhoneSubInfoProxy(this.getDefaultSubscription());
        return phoneSubInfoProxy.getIsimImpi();
    }

    @Override
    public String getIsimDomain() {
        PhoneSubInfoProxy phoneSubInfoProxy = this.getPhoneSubInfoProxy(this.getDefaultSubscription());
        return phoneSubInfoProxy.getIsimDomain();
    }

    @Override
    public String[] getIsimImpu() {
        PhoneSubInfoProxy phoneSubInfoProxy = this.getPhoneSubInfoProxy(this.getDefaultSubscription());
        return phoneSubInfoProxy.getIsimImpu();
    }

    @Override
    public String getIsimIst() throws RemoteException {
        PhoneSubInfoProxy phoneSubInfoProxy = this.getPhoneSubInfoProxy(this.getDefaultSubscription());
        return phoneSubInfoProxy.getIsimIst();
    }

    @Override
    public String[] getIsimPcscf() throws RemoteException {
        PhoneSubInfoProxy phoneSubInfoProxy = this.getPhoneSubInfoProxy(this.getDefaultSubscription());
        return phoneSubInfoProxy.getIsimPcscf();
    }

    @Override
    public String getIsimChallengeResponse(String nonce) throws RemoteException {
        PhoneSubInfoProxy phoneSubInfoProxy = this.getPhoneSubInfoProxy(this.getDefaultSubscription());
        return phoneSubInfoProxy.getIsimChallengeResponse(nonce);
    }

    @Override
    public String getIccSimChallengeResponse(long subId, int appType, String data) throws RemoteException {
        PhoneSubInfoProxy phoneSubInfoProxy = this.getPhoneSubInfoProxy(subId);
        return phoneSubInfoProxy.getIccSimChallengeResponse(subId, appType, data);
    }

    @Override
    public String getGroupIdLevel1() {
        return this.getGroupIdLevel1ForSubscriber(this.getDefaultSubscription());
    }

    @Override
    public String getGroupIdLevel1ForSubscriber(long subId) {
        PhoneSubInfoProxy phoneSubInfoProxy = this.getPhoneSubInfoProxy(subId);
        if (phoneSubInfoProxy != null) {
            return phoneSubInfoProxy.getGroupIdLevel1();
        }
        Rlog.e(TAG, "getGroupIdLevel1 phoneSubInfoProxy is null for Subscription:" + subId);
        return null;
    }
}

