/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.Context;
import android.hardware.display.DisplayManager;
import android.net.ConnectivityManager;
import android.net.LocalSocket;
import android.net.LocalSocketAddress;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.PowerManager;
import android.os.SystemProperties;
import android.telephony.CellInfo;
import android.telephony.NeighboringCellInfo;
import android.telephony.PhoneNumberUtils;
import android.telephony.Rlog;
import android.telephony.SignalStrength;
import android.telephony.SmsMessage;
import android.text.TextUtils;
import android.util.Base64;
import android.util.SparseArray;
import android.view.Display;
import com.android.internal.telephony.BaseCommands;
import com.android.internal.telephony.CallForwardInfo;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.DriverCall;
import com.android.internal.telephony.HardwareConfig;
import com.android.internal.telephony.OperatorInfo;
import com.android.internal.telephony.RILRequest;
import com.android.internal.telephony.SmsResponse;
import com.android.internal.telephony.TelephonyDevController;
import com.android.internal.telephony.UUSInfo;
import com.android.internal.telephony.cdma.CdmaCallWaitingNotification;
import com.android.internal.telephony.cdma.CdmaInformationRecords;
import com.android.internal.telephony.cdma.CdmaSmsBroadcastConfigInfo;
import com.android.internal.telephony.dataconnection.DataCallResponse;
import com.android.internal.telephony.dataconnection.DataProfile;
import com.android.internal.telephony.dataconnection.DcFailCause;
import com.android.internal.telephony.gsm.SmsBroadcastConfigInfo;
import com.android.internal.telephony.gsm.SuppServiceNotification;
import com.android.internal.telephony.uicc.IccCardApplicationStatus;
import com.android.internal.telephony.uicc.IccCardStatus;
import com.android.internal.telephony.uicc.IccIoResult;
import com.android.internal.telephony.uicc.IccRefreshResponse;
import com.android.internal.telephony.uicc.IccUtils;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;

public final class RIL
extends BaseCommands
implements CommandsInterface {
    static final String RILJ_LOG_TAG = "RILJ";
    static final boolean RILJ_LOGD = true;
    static final boolean RILJ_LOGV = false;
    private static final int DEFAULT_WAKE_LOCK_TIMEOUT = 60000;
    LocalSocket mSocket;
    HandlerThread mSenderThread;
    RILSender mSender;
    Thread mReceiverThread;
    RILReceiver mReceiver;
    Display mDefaultDisplay;
    int mDefaultDisplayState = 0;
    PowerManager.WakeLock mWakeLock;
    final int mWakeLockTimeout;
    int mWakeLockCount;
    SparseArray<RILRequest> mRequestList = new SparseArray();
    Object mLastNITZTimeInfo;
    AtomicBoolean mTestingEmergencyCall = new AtomicBoolean(false);
    private Integer mInstanceId;
    static final int EVENT_SEND = 1;
    static final int EVENT_WAKE_LOCK_TIMEOUT = 2;
    static final int RIL_MAX_COMMAND_BYTES = 8192;
    static final int RESPONSE_SOLICITED = 0;
    static final int RESPONSE_UNSOLICITED = 1;
    static final String[] SOCKET_NAME_RIL = new String[]{"rild", "rild2", "rild3"};
    static final int SOCKET_OPEN_RETRY_MILLIS = 4000;
    private static final int CDMA_BSI_NO_OF_INTS_STRUCT = 3;
    private static final int CDMA_BROADCAST_SMS_NO_OF_SERVICE_CATEGORIES = 31;
    private final DisplayManager.DisplayListener mDisplayListener = new DisplayManager.DisplayListener(){

        @Override
        public void onDisplayAdded(int displayId) {
        }

        @Override
        public void onDisplayRemoved(int displayId) {
        }

        @Override
        public void onDisplayChanged(int displayId) {
            if (displayId == 0) {
                RIL.this.updateScreenState();
            }
        }
    };

    private static int readRilMessage(InputStream is, byte[] buffer) throws IOException {
        int countRead;
        int offset = 0;
        int remaining = 4;
        do {
            if ((countRead = is.read(buffer, offset, remaining)) < 0) {
                Rlog.e(RILJ_LOG_TAG, "Hit EOS reading message length");
                return -1;
            }
            offset += countRead;
        } while ((remaining -= countRead) > 0);
        int messageLength = (buffer[0] & 0xFF) << 24 | (buffer[1] & 0xFF) << 16 | (buffer[2] & 0xFF) << 8 | buffer[3] & 0xFF;
        offset = 0;
        remaining = messageLength;
        do {
            if ((countRead = is.read(buffer, offset, remaining)) < 0) {
                Rlog.e(RILJ_LOG_TAG, "Hit EOS reading message.  messageLength=" + messageLength + " remaining=" + remaining);
                return -1;
            }
            offset += countRead;
        } while ((remaining -= countRead) > 0);
        return messageLength;
    }

    public RIL(Context context, int preferredNetworkType, int cdmaSubscription) {
        this(context, preferredNetworkType, cdmaSubscription, null);
    }

    public RIL(Context context, int preferredNetworkType, int cdmaSubscription, Integer instanceId) {
        super(context);
        this.riljLog("RIL(context, preferredNetworkType=" + preferredNetworkType + " cdmaSubscription=" + cdmaSubscription + ")");
        this.mContext = context;
        this.mCdmaSubscription = cdmaSubscription;
        this.mPreferredNetworkType = preferredNetworkType;
        this.mPhoneType = 0;
        this.mInstanceId = instanceId;
        PowerManager pm = (PowerManager)context.getSystemService("power");
        this.mWakeLock = pm.newWakeLock(1, RILJ_LOG_TAG);
        this.mWakeLock.setReferenceCounted(false);
        this.mWakeLockTimeout = SystemProperties.getInt("ro.ril.wake_lock_timeout", 60000);
        this.mWakeLockCount = 0;
        this.mSenderThread = new HandlerThread("RILSender");
        this.mSenderThread.start();
        Looper looper = this.mSenderThread.getLooper();
        this.mSender = new RILSender(looper);
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        if (!cm.isNetworkSupported(0)) {
            this.riljLog("Not starting RILReceiver: wifi-only");
        } else {
            this.riljLog("Starting RILReceiver");
            this.mReceiver = new RILReceiver();
            this.mReceiverThread = new Thread((Runnable)this.mReceiver, "RILReceiver");
            this.mReceiverThread.start();
            DisplayManager dm = (DisplayManager)context.getSystemService("display");
            this.mDefaultDisplay = dm.getDisplay(0);
            dm.registerDisplayListener(this.mDisplayListener, null);
        }
        TelephonyDevController tdc = TelephonyDevController.getInstance();
        TelephonyDevController.registerRIL(this);
    }

    @Override
    public void getVoiceRadioTechnology(Message result) {
        RILRequest rr = RILRequest.obtain(108, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    @Override
    public void getImsRegistrationState(Message result) {
        RILRequest rr = RILRequest.obtain(112, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    @Override
    public void setOnNITZTime(Handler h, int what, Object obj) {
        super.setOnNITZTime(h, what, obj);
        if (this.mLastNITZTimeInfo != null) {
            this.mNITZTimeRegistrant.notifyRegistrant(new AsyncResult(null, this.mLastNITZTimeInfo, null));
            this.mLastNITZTimeInfo = null;
        }
    }

    @Override
    public void getIccCardStatus(Message result) {
        RILRequest rr = RILRequest.obtain(1, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    @Override
    public void setUiccSubscription(int slotId, int appIndex, int subId, int subStatus, Message result) {
        RILRequest rr = RILRequest.obtain(122, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " slot: " + slotId + " appIndex: " + appIndex + " subId: " + subId + " subStatus: " + subStatus);
        rr.mParcel.writeInt(slotId);
        rr.mParcel.writeInt(appIndex);
        rr.mParcel.writeInt(subId);
        rr.mParcel.writeInt(subStatus);
        this.send(rr);
    }

    @Override
    public void setDataAllowed(boolean allowed, Message result) {
        RILRequest rr = RILRequest.obtain(123, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        rr.mParcel.writeInt(1);
        rr.mParcel.writeInt(allowed ? 1 : 0);
        this.send(rr);
    }

    @Override
    public void supplyIccPin(String pin, Message result) {
        this.supplyIccPinForApp(pin, null, result);
    }

    @Override
    public void supplyIccPinForApp(String pin, String aid, Message result) {
        RILRequest rr = RILRequest.obtain(2, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        rr.mParcel.writeInt(2);
        rr.mParcel.writeString(pin);
        rr.mParcel.writeString(aid);
        this.send(rr);
    }

    @Override
    public void supplyIccPuk(String puk, String newPin, Message result) {
        this.supplyIccPukForApp(puk, newPin, null, result);
    }

    @Override
    public void supplyIccPukForApp(String puk, String newPin, String aid, Message result) {
        RILRequest rr = RILRequest.obtain(3, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        rr.mParcel.writeInt(3);
        rr.mParcel.writeString(puk);
        rr.mParcel.writeString(newPin);
        rr.mParcel.writeString(aid);
        this.send(rr);
    }

    @Override
    public void supplyIccPin2(String pin, Message result) {
        this.supplyIccPin2ForApp(pin, null, result);
    }

    @Override
    public void supplyIccPin2ForApp(String pin, String aid, Message result) {
        RILRequest rr = RILRequest.obtain(4, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        rr.mParcel.writeInt(2);
        rr.mParcel.writeString(pin);
        rr.mParcel.writeString(aid);
        this.send(rr);
    }

    @Override
    public void supplyIccPuk2(String puk2, String newPin2, Message result) {
        this.supplyIccPuk2ForApp(puk2, newPin2, null, result);
    }

    @Override
    public void supplyIccPuk2ForApp(String puk, String newPin2, String aid, Message result) {
        RILRequest rr = RILRequest.obtain(5, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        rr.mParcel.writeInt(3);
        rr.mParcel.writeString(puk);
        rr.mParcel.writeString(newPin2);
        rr.mParcel.writeString(aid);
        this.send(rr);
    }

    @Override
    public void changeIccPin(String oldPin, String newPin, Message result) {
        this.changeIccPinForApp(oldPin, newPin, null, result);
    }

    @Override
    public void changeIccPinForApp(String oldPin, String newPin, String aid, Message result) {
        RILRequest rr = RILRequest.obtain(6, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        rr.mParcel.writeInt(3);
        rr.mParcel.writeString(oldPin);
        rr.mParcel.writeString(newPin);
        rr.mParcel.writeString(aid);
        this.send(rr);
    }

    @Override
    public void changeIccPin2(String oldPin2, String newPin2, Message result) {
        this.changeIccPin2ForApp(oldPin2, newPin2, null, result);
    }

    @Override
    public void changeIccPin2ForApp(String oldPin2, String newPin2, String aid, Message result) {
        RILRequest rr = RILRequest.obtain(7, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        rr.mParcel.writeInt(3);
        rr.mParcel.writeString(oldPin2);
        rr.mParcel.writeString(newPin2);
        rr.mParcel.writeString(aid);
        this.send(rr);
    }

    @Override
    public void changeBarringPassword(String facility, String oldPwd, String newPwd, Message result) {
        RILRequest rr = RILRequest.obtain(44, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        rr.mParcel.writeInt(3);
        rr.mParcel.writeString(facility);
        rr.mParcel.writeString(oldPwd);
        rr.mParcel.writeString(newPwd);
        this.send(rr);
    }

    @Override
    public void supplyNetworkDepersonalization(String netpin, Message result) {
        RILRequest rr = RILRequest.obtain(8, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        rr.mParcel.writeInt(1);
        rr.mParcel.writeString(netpin);
        this.send(rr);
    }

    @Override
    public void getCurrentCalls(Message result) {
        RILRequest rr = RILRequest.obtain(9, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    @Override
    @Deprecated
    public void getPDPContextList(Message result) {
        this.getDataCallList(result);
    }

    @Override
    public void getDataCallList(Message result) {
        RILRequest rr = RILRequest.obtain(57, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    @Override
    public void dial(String address, int clirMode, Message result) {
        this.dial(address, clirMode, null, result);
    }

    @Override
    public void dial(String address, int clirMode, UUSInfo uusInfo, Message result) {
        RILRequest rr = RILRequest.obtain(10, result);
        rr.mParcel.writeString(address);
        rr.mParcel.writeInt(clirMode);
        if (uusInfo == null) {
            rr.mParcel.writeInt(0);
        } else {
            rr.mParcel.writeInt(1);
            rr.mParcel.writeInt(uusInfo.getType());
            rr.mParcel.writeInt(uusInfo.getDcs());
            rr.mParcel.writeByteArray(uusInfo.getUserData());
        }
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    @Override
    public void getIMSI(Message result) {
        this.getIMSIForApp(null, result);
    }

    @Override
    public void getIMSIForApp(String aid, Message result) {
        RILRequest rr = RILRequest.obtain(11, result);
        rr.mParcel.writeInt(1);
        rr.mParcel.writeString(aid);
        this.riljLog(rr.serialString() + "> getIMSI: " + RIL.requestToString(rr.mRequest) + " aid: " + aid);
        this.send(rr);
    }

    @Override
    public void getIMEI(Message result) {
        RILRequest rr = RILRequest.obtain(38, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    @Override
    public void getIMEISV(Message result) {
        RILRequest rr = RILRequest.obtain(39, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    @Override
    public void hangupConnection(int gsmIndex, Message result) {
        this.riljLog("hangupConnection: gsmIndex=" + gsmIndex);
        RILRequest rr = RILRequest.obtain(12, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " " + gsmIndex);
        rr.mParcel.writeInt(1);
        rr.mParcel.writeInt(gsmIndex);
        this.send(rr);
    }

    @Override
    public void hangupWaitingOrBackground(Message result) {
        RILRequest rr = RILRequest.obtain(13, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    @Override
    public void hangupForegroundResumeBackground(Message result) {
        RILRequest rr = RILRequest.obtain(14, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    @Override
    public void switchWaitingOrHoldingAndActive(Message result) {
        RILRequest rr = RILRequest.obtain(15, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    @Override
    public void conference(Message result) {
        RILRequest rr = RILRequest.obtain(16, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    @Override
    public void setPreferredVoicePrivacy(boolean enable, Message result) {
        RILRequest rr = RILRequest.obtain(82, result);
        rr.mParcel.writeInt(1);
        rr.mParcel.writeInt(enable ? 1 : 0);
        this.send(rr);
    }

    @Override
    public void getPreferredVoicePrivacy(Message result) {
        RILRequest rr = RILRequest.obtain(83, result);
        this.send(rr);
    }

    @Override
    public void separateConnection(int gsmIndex, Message result) {
        RILRequest rr = RILRequest.obtain(52, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " " + gsmIndex);
        rr.mParcel.writeInt(1);
        rr.mParcel.writeInt(gsmIndex);
        this.send(rr);
    }

    @Override
    public void acceptCall(Message result) {
        RILRequest rr = RILRequest.obtain(40, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    @Override
    public void rejectCall(Message result) {
        RILRequest rr = RILRequest.obtain(17, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    @Override
    public void explicitCallTransfer(Message result) {
        RILRequest rr = RILRequest.obtain(72, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    @Override
    public void getLastCallFailCause(Message result) {
        RILRequest rr = RILRequest.obtain(18, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    @Override
    @Deprecated
    public void getLastPdpFailCause(Message result) {
        this.getLastDataCallFailCause(result);
    }

    @Override
    public void getLastDataCallFailCause(Message result) {
        RILRequest rr = RILRequest.obtain(56, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    @Override
    public void setMute(boolean enableMute, Message response) {
        RILRequest rr = RILRequest.obtain(53, response);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " " + enableMute);
        rr.mParcel.writeInt(1);
        rr.mParcel.writeInt(enableMute ? 1 : 0);
        this.send(rr);
    }

    @Override
    public void getMute(Message response) {
        RILRequest rr = RILRequest.obtain(54, response);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    @Override
    public void getSignalStrength(Message result) {
        RILRequest rr = RILRequest.obtain(19, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    @Override
    public void getVoiceRegistrationState(Message result) {
        RILRequest rr = RILRequest.obtain(20, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    @Override
    public void getDataRegistrationState(Message result) {
        RILRequest rr = RILRequest.obtain(21, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    @Override
    public void getOperator(Message result) {
        RILRequest rr = RILRequest.obtain(22, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    @Override
    public void getHardwareConfig(Message result) {
        RILRequest rr = RILRequest.obtain(124, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    @Override
    public void sendDtmf(char c, Message result) {
        RILRequest rr = RILRequest.obtain(24, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        rr.mParcel.writeString(Character.toString(c));
        this.send(rr);
    }

    @Override
    public void startDtmf(char c, Message result) {
        RILRequest rr = RILRequest.obtain(49, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        rr.mParcel.writeString(Character.toString(c));
        this.send(rr);
    }

    @Override
    public void stopDtmf(Message result) {
        RILRequest rr = RILRequest.obtain(50, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    @Override
    public void sendBurstDtmf(String dtmfString, int on, int off, Message result) {
        RILRequest rr = RILRequest.obtain(85, result);
        rr.mParcel.writeInt(3);
        rr.mParcel.writeString(dtmfString);
        rr.mParcel.writeString(Integer.toString(on));
        rr.mParcel.writeString(Integer.toString(off));
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " : " + dtmfString);
        this.send(rr);
    }

    private void constructGsmSendSmsRilRequest(RILRequest rr, String smscPDU, String pdu) {
        rr.mParcel.writeInt(2);
        rr.mParcel.writeString(smscPDU);
        rr.mParcel.writeString(pdu);
    }

    @Override
    public void sendSMS(String smscPDU, String pdu, Message result) {
        RILRequest rr = RILRequest.obtain(25, result);
        this.constructGsmSendSmsRilRequest(rr, smscPDU, pdu);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    @Override
    public void sendSMSExpectMore(String smscPDU, String pdu, Message result) {
        RILRequest rr = RILRequest.obtain(26, result);
        this.constructGsmSendSmsRilRequest(rr, smscPDU, pdu);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    private void constructCdmaSendSmsRilRequest(RILRequest rr, byte[] pdu) {
        ByteArrayInputStream bais = new ByteArrayInputStream(pdu);
        DataInputStream dis = new DataInputStream(bais);
        try {
            int i;
            rr.mParcel.writeInt(dis.readInt());
            rr.mParcel.writeByte((byte)dis.readInt());
            rr.mParcel.writeInt(dis.readInt());
            rr.mParcel.writeInt(dis.read());
            rr.mParcel.writeInt(dis.read());
            rr.mParcel.writeInt(dis.read());
            rr.mParcel.writeInt(dis.read());
            int address_nbr_of_digits = dis.read();
            rr.mParcel.writeByte((byte)address_nbr_of_digits);
            for (i = 0; i < address_nbr_of_digits; ++i) {
                rr.mParcel.writeByte(dis.readByte());
            }
            rr.mParcel.writeInt(dis.read());
            rr.mParcel.writeByte((byte)dis.read());
            int subaddr_nbr_of_digits = dis.read();
            rr.mParcel.writeByte((byte)subaddr_nbr_of_digits);
            for (i = 0; i < subaddr_nbr_of_digits; ++i) {
                rr.mParcel.writeByte(dis.readByte());
            }
            int bearerDataLength = dis.read();
            rr.mParcel.writeInt(bearerDataLength);
            for (i = 0; i < bearerDataLength; ++i) {
                rr.mParcel.writeByte(dis.readByte());
            }
        }
        catch (IOException ex) {
            this.riljLog("sendSmsCdma: conversion from input stream to object failed: " + ex);
        }
    }

    @Override
    public void sendCdmaSms(byte[] pdu, Message result) {
        RILRequest rr = RILRequest.obtain(87, result);
        this.constructCdmaSendSmsRilRequest(rr, pdu);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    @Override
    public void sendImsGsmSms(String smscPDU, String pdu, int retry, int messageRef, Message result) {
        RILRequest rr = RILRequest.obtain(113, result);
        rr.mParcel.writeInt(1);
        rr.mParcel.writeByte((byte)retry);
        rr.mParcel.writeInt(messageRef);
        this.constructGsmSendSmsRilRequest(rr, smscPDU, pdu);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    @Override
    public void sendImsCdmaSms(byte[] pdu, int retry, int messageRef, Message result) {
        RILRequest rr = RILRequest.obtain(113, result);
        rr.mParcel.writeInt(2);
        rr.mParcel.writeByte((byte)retry);
        rr.mParcel.writeInt(messageRef);
        this.constructCdmaSendSmsRilRequest(rr, pdu);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    @Override
    public void deleteSmsOnSim(int index, Message response) {
        RILRequest rr = RILRequest.obtain(64, response);
        rr.mParcel.writeInt(1);
        rr.mParcel.writeInt(index);
        this.send(rr);
    }

    @Override
    public void deleteSmsOnRuim(int index, Message response) {
        RILRequest rr = RILRequest.obtain(97, response);
        rr.mParcel.writeInt(1);
        rr.mParcel.writeInt(index);
        this.send(rr);
    }

    @Override
    public void writeSmsToSim(int status, String smsc, String pdu, Message response) {
        status = this.translateStatus(status);
        RILRequest rr = RILRequest.obtain(63, response);
        rr.mParcel.writeInt(status);
        rr.mParcel.writeString(pdu);
        rr.mParcel.writeString(smsc);
        this.send(rr);
    }

    @Override
    public void writeSmsToRuim(int status, String pdu, Message response) {
        status = this.translateStatus(status);
        RILRequest rr = RILRequest.obtain(96, response);
        rr.mParcel.writeInt(status);
        rr.mParcel.writeString(pdu);
        this.send(rr);
    }

    private int translateStatus(int status) {
        switch (status & 7) {
            case 1: {
                return 1;
            }
            case 3: {
                return 0;
            }
            case 5: {
                return 3;
            }
            case 7: {
                return 2;
            }
        }
        return 1;
    }

    @Override
    public void setupDataCall(String radioTechnology, String profile, String apn, String user, String password, String authType, String protocol, Message result) {
        RILRequest rr = RILRequest.obtain(27, result);
        rr.mParcel.writeInt(7);
        rr.mParcel.writeString(radioTechnology);
        rr.mParcel.writeString(profile);
        rr.mParcel.writeString(apn);
        rr.mParcel.writeString(user);
        rr.mParcel.writeString(password);
        rr.mParcel.writeString(authType);
        rr.mParcel.writeString(protocol);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " " + radioTechnology + " " + profile + " " + apn + " " + user + " " + password + " " + authType + " " + protocol);
        this.send(rr);
    }

    @Override
    public void deactivateDataCall(int cid, int reason, Message result) {
        RILRequest rr = RILRequest.obtain(41, result);
        rr.mParcel.writeInt(2);
        rr.mParcel.writeString(Integer.toString(cid));
        rr.mParcel.writeString(Integer.toString(reason));
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " " + cid + " " + reason);
        this.send(rr);
    }

    @Override
    public void setRadioPower(boolean on, Message result) {
        RILRequest rr = RILRequest.obtain(23, result);
        rr.mParcel.writeInt(1);
        rr.mParcel.writeInt(on ? 1 : 0);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + (on ? " on" : " off"));
        this.send(rr);
    }

    @Override
    public void requestShutdown(Message result) {
        RILRequest rr = RILRequest.obtain(129, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    @Override
    public void setSuppServiceNotifications(boolean enable, Message result) {
        RILRequest rr = RILRequest.obtain(62, result);
        rr.mParcel.writeInt(1);
        rr.mParcel.writeInt(enable ? 1 : 0);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    @Override
    public void acknowledgeLastIncomingGsmSms(boolean success, int cause, Message result) {
        RILRequest rr = RILRequest.obtain(37, result);
        rr.mParcel.writeInt(2);
        rr.mParcel.writeInt(success ? 1 : 0);
        rr.mParcel.writeInt(cause);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " " + success + " " + cause);
        this.send(rr);
    }

    @Override
    public void acknowledgeLastIncomingCdmaSms(boolean success, int cause, Message result) {
        RILRequest rr = RILRequest.obtain(88, result);
        rr.mParcel.writeInt(success ? 0 : 1);
        rr.mParcel.writeInt(cause);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " " + success + " " + cause);
        this.send(rr);
    }

    @Override
    public void acknowledgeIncomingGsmSmsWithPdu(boolean success, String ackPdu, Message result) {
        RILRequest rr = RILRequest.obtain(106, result);
        rr.mParcel.writeInt(2);
        rr.mParcel.writeString(success ? "1" : "0");
        rr.mParcel.writeString(ackPdu);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + ' ' + success + " [" + ackPdu + ']');
        this.send(rr);
    }

    @Override
    public void iccIO(int command, int fileid, String path, int p1, int p2, int p3, String data, String pin2, Message result) {
        this.iccIOForApp(command, fileid, path, p1, p2, p3, data, pin2, null, result);
    }

    @Override
    public void iccIOForApp(int command, int fileid, String path, int p1, int p2, int p3, String data, String pin2, String aid, Message result) {
        RILRequest rr = RILRequest.obtain(28, result);
        rr.mParcel.writeInt(command);
        rr.mParcel.writeInt(fileid);
        rr.mParcel.writeString(path);
        rr.mParcel.writeInt(p1);
        rr.mParcel.writeInt(p2);
        rr.mParcel.writeInt(p3);
        rr.mParcel.writeString(data);
        rr.mParcel.writeString(pin2);
        rr.mParcel.writeString(aid);
        this.riljLog(rr.serialString() + "> iccIO: " + RIL.requestToString(rr.mRequest) + " 0x" + Integer.toHexString(command) + " 0x" + Integer.toHexString(fileid) + " " + " path: " + path + "," + p1 + "," + p2 + "," + p3 + " aid: " + aid);
        this.send(rr);
    }

    @Override
    public void getCLIR(Message result) {
        RILRequest rr = RILRequest.obtain(31, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    @Override
    public void setCLIR(int clirMode, Message result) {
        RILRequest rr = RILRequest.obtain(32, result);
        rr.mParcel.writeInt(1);
        rr.mParcel.writeInt(clirMode);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " " + clirMode);
        this.send(rr);
    }

    @Override
    public void queryCallWaiting(int serviceClass, Message response) {
        RILRequest rr = RILRequest.obtain(35, response);
        rr.mParcel.writeInt(1);
        rr.mParcel.writeInt(serviceClass);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " " + serviceClass);
        this.send(rr);
    }

    @Override
    public void setCallWaiting(boolean enable, int serviceClass, Message response) {
        RILRequest rr = RILRequest.obtain(36, response);
        rr.mParcel.writeInt(2);
        rr.mParcel.writeInt(enable ? 1 : 0);
        rr.mParcel.writeInt(serviceClass);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " " + enable + ", " + serviceClass);
        this.send(rr);
    }

    @Override
    public void setNetworkSelectionModeAutomatic(Message response) {
        RILRequest rr = RILRequest.obtain(46, response);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    @Override
    public void setNetworkSelectionModeManual(String operatorNumeric, Message response) {
        RILRequest rr = RILRequest.obtain(47, response);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " " + operatorNumeric);
        rr.mParcel.writeString(operatorNumeric);
        this.send(rr);
    }

    @Override
    public void getNetworkSelectionMode(Message response) {
        RILRequest rr = RILRequest.obtain(45, response);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    @Override
    public void getAvailableNetworks(Message response) {
        RILRequest rr = RILRequest.obtain(48, response);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    @Override
    public void setCallForward(int action, int cfReason, int serviceClass, String number, int timeSeconds, Message response) {
        RILRequest rr = RILRequest.obtain(34, response);
        rr.mParcel.writeInt(action);
        rr.mParcel.writeInt(cfReason);
        rr.mParcel.writeInt(serviceClass);
        rr.mParcel.writeInt(PhoneNumberUtils.toaFromString(number));
        rr.mParcel.writeString(number);
        rr.mParcel.writeInt(timeSeconds);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " " + action + " " + cfReason + " " + serviceClass + timeSeconds);
        this.send(rr);
    }

    @Override
    public void queryCallForwardStatus(int cfReason, int serviceClass, String number, Message response) {
        RILRequest rr = RILRequest.obtain(33, response);
        rr.mParcel.writeInt(2);
        rr.mParcel.writeInt(cfReason);
        rr.mParcel.writeInt(serviceClass);
        rr.mParcel.writeInt(PhoneNumberUtils.toaFromString(number));
        rr.mParcel.writeString(number);
        rr.mParcel.writeInt(0);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " " + cfReason + " " + serviceClass);
        this.send(rr);
    }

    @Override
    public void queryCLIP(Message response) {
        RILRequest rr = RILRequest.obtain(55, response);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    @Override
    public void getBasebandVersion(Message response) {
        RILRequest rr = RILRequest.obtain(51, response);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    @Override
    public void queryFacilityLock(String facility, String password, int serviceClass, Message response) {
        this.queryFacilityLockForApp(facility, password, serviceClass, null, response);
    }

    @Override
    public void queryFacilityLockForApp(String facility, String password, int serviceClass, String appId, Message response) {
        RILRequest rr = RILRequest.obtain(42, response);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " [" + facility + " " + serviceClass + " " + appId + "]");
        rr.mParcel.writeInt(4);
        rr.mParcel.writeString(facility);
        rr.mParcel.writeString(password);
        rr.mParcel.writeString(Integer.toString(serviceClass));
        rr.mParcel.writeString(appId);
        this.send(rr);
    }

    @Override
    public void setFacilityLock(String facility, boolean lockState, String password, int serviceClass, Message response) {
        this.setFacilityLockForApp(facility, lockState, password, serviceClass, null, response);
    }

    @Override
    public void setFacilityLockForApp(String facility, boolean lockState, String password, int serviceClass, String appId, Message response) {
        RILRequest rr = RILRequest.obtain(43, response);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " [" + facility + " " + lockState + " " + serviceClass + " " + appId + "]");
        rr.mParcel.writeInt(5);
        rr.mParcel.writeString(facility);
        String lockString = lockState ? "1" : "0";
        rr.mParcel.writeString(lockString);
        rr.mParcel.writeString(password);
        rr.mParcel.writeString(Integer.toString(serviceClass));
        rr.mParcel.writeString(appId);
        this.send(rr);
    }

    @Override
    public void sendUSSD(String ussdString, Message response) {
        RILRequest rr = RILRequest.obtain(29, response);
        String logUssdString = "*******";
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " " + logUssdString);
        rr.mParcel.writeString(ussdString);
        this.send(rr);
    }

    @Override
    public void cancelPendingUssd(Message response) {
        RILRequest rr = RILRequest.obtain(30, response);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    @Override
    public void resetRadio(Message result) {
        RILRequest rr = RILRequest.obtain(58, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    @Override
    public void invokeOemRilRequestRaw(byte[] data, Message response) {
        RILRequest rr = RILRequest.obtain(59, response);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + "[" + IccUtils.bytesToHexString(data) + "]");
        rr.mParcel.writeByteArray(data);
        this.send(rr);
    }

    @Override
    public void invokeOemRilRequestStrings(String[] strings, Message response) {
        RILRequest rr = RILRequest.obtain(60, response);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        rr.mParcel.writeStringArray(strings);
        this.send(rr);
    }

    @Override
    public void setBandMode(int bandMode, Message response) {
        RILRequest rr = RILRequest.obtain(65, response);
        rr.mParcel.writeInt(1);
        rr.mParcel.writeInt(bandMode);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " " + bandMode);
        this.send(rr);
    }

    @Override
    public void queryAvailableBandMode(Message response) {
        RILRequest rr = RILRequest.obtain(66, response);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    @Override
    public void sendTerminalResponse(String contents, Message response) {
        RILRequest rr = RILRequest.obtain(70, response);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        rr.mParcel.writeString(contents);
        this.send(rr);
    }

    @Override
    public void sendEnvelope(String contents, Message response) {
        RILRequest rr = RILRequest.obtain(69, response);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        rr.mParcel.writeString(contents);
        this.send(rr);
    }

    @Override
    public void sendEnvelopeWithStatus(String contents, Message response) {
        RILRequest rr = RILRequest.obtain(107, response);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + '[' + contents + ']');
        rr.mParcel.writeString(contents);
        this.send(rr);
    }

    @Override
    public void handleCallSetupRequestFromSim(boolean accept, Message response) {
        RILRequest rr = RILRequest.obtain(71, response);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        int[] param = new int[]{accept ? 1 : 0};
        rr.mParcel.writeIntArray(param);
        this.send(rr);
    }

    @Override
    public void setPreferredNetworkType(int networkType, Message response) {
        RILRequest rr = RILRequest.obtain(73, response);
        rr.mParcel.writeInt(1);
        rr.mParcel.writeInt(networkType);
        this.mPreferredNetworkType = networkType;
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " : " + networkType);
        this.send(rr);
    }

    @Override
    public void getPreferredNetworkType(Message response) {
        RILRequest rr = RILRequest.obtain(74, response);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    @Override
    public void getNeighboringCids(Message response) {
        RILRequest rr = RILRequest.obtain(75, response);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    @Override
    public void setLocationUpdates(boolean enable, Message response) {
        RILRequest rr = RILRequest.obtain(76, response);
        rr.mParcel.writeInt(1);
        rr.mParcel.writeInt(enable ? 1 : 0);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + ": " + enable);
        this.send(rr);
    }

    @Override
    public void getSmscAddress(Message result) {
        RILRequest rr = RILRequest.obtain(100, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    @Override
    public void setSmscAddress(String address, Message result) {
        RILRequest rr = RILRequest.obtain(101, result);
        rr.mParcel.writeString(address);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " : " + address);
        this.send(rr);
    }

    @Override
    public void reportSmsMemoryStatus(boolean available, Message result) {
        RILRequest rr = RILRequest.obtain(102, result);
        rr.mParcel.writeInt(1);
        rr.mParcel.writeInt(available ? 1 : 0);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + ": " + available);
        this.send(rr);
    }

    @Override
    public void reportStkServiceIsRunning(Message result) {
        RILRequest rr = RILRequest.obtain(103, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    @Override
    public void getGsmBroadcastConfig(Message response) {
        RILRequest rr = RILRequest.obtain(89, response);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    @Override
    public void setGsmBroadcastConfig(SmsBroadcastConfigInfo[] config, Message response) {
        int i;
        RILRequest rr = RILRequest.obtain(90, response);
        int numOfConfig = config.length;
        rr.mParcel.writeInt(numOfConfig);
        for (i = 0; i < numOfConfig; ++i) {
            rr.mParcel.writeInt(config[i].getFromServiceId());
            rr.mParcel.writeInt(config[i].getToServiceId());
            rr.mParcel.writeInt(config[i].getFromCodeScheme());
            rr.mParcel.writeInt(config[i].getToCodeScheme());
            rr.mParcel.writeInt(config[i].isSelected() ? 1 : 0);
        }
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " with " + numOfConfig + " configs : ");
        for (i = 0; i < numOfConfig; ++i) {
            this.riljLog(config[i].toString());
        }
        this.send(rr);
    }

    @Override
    public void setGsmBroadcastActivation(boolean activate, Message response) {
        RILRequest rr = RILRequest.obtain(91, response);
        rr.mParcel.writeInt(1);
        rr.mParcel.writeInt(activate ? 0 : 1);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    private void updateScreenState() {
        int oldState = this.mDefaultDisplayState;
        this.mDefaultDisplayState = this.mDefaultDisplay.getState();
        if (this.mDefaultDisplayState != oldState) {
            if (oldState != 2 && this.mDefaultDisplayState == 2) {
                this.sendScreenState(true);
            } else if ((oldState == 2 || oldState == 0) && this.mDefaultDisplayState != 2) {
                this.sendScreenState(false);
            }
        }
    }

    private void sendScreenState(boolean on) {
        RILRequest rr = RILRequest.obtain(61, null);
        rr.mParcel.writeInt(1);
        rr.mParcel.writeInt(on ? 1 : 0);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + ": " + on);
        this.send(rr);
    }

    @Override
    protected void onRadioAvailable() {
        this.updateScreenState();
    }

    private CommandsInterface.RadioState getRadioStateFromInt(int stateInt) {
        CommandsInterface.RadioState state;
        switch (stateInt) {
            case 0: {
                state = CommandsInterface.RadioState.RADIO_OFF;
                break;
            }
            case 1: {
                state = CommandsInterface.RadioState.RADIO_UNAVAILABLE;
                break;
            }
            case 10: {
                state = CommandsInterface.RadioState.RADIO_ON;
                break;
            }
            default: {
                throw new RuntimeException("Unrecognized RIL_RadioState: " + stateInt);
            }
        }
        return state;
    }

    private void switchToRadioState(CommandsInterface.RadioState newState) {
        this.setRadioState(newState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acquireWakeLock() {
        PowerManager.WakeLock wakeLock = this.mWakeLock;
        synchronized (wakeLock) {
            this.mWakeLock.acquire();
            ++this.mWakeLockCount;
            this.mSender.removeMessages(2);
            Message msg = this.mSender.obtainMessage(2);
            this.mSender.sendMessageDelayed(msg, this.mWakeLockTimeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrementWakeLock() {
        PowerManager.WakeLock wakeLock = this.mWakeLock;
        synchronized (wakeLock) {
            if (this.mWakeLockCount > 1) {
                --this.mWakeLockCount;
            } else {
                this.mWakeLockCount = 0;
                this.mWakeLock.release();
                this.mSender.removeMessages(2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean clearWakeLock() {
        PowerManager.WakeLock wakeLock = this.mWakeLock;
        synchronized (wakeLock) {
            if (this.mWakeLockCount == 0 && !this.mWakeLock.isHeld()) {
                return false;
            }
            Rlog.d(RILJ_LOG_TAG, "NOTE: mWakeLockCount is " + this.mWakeLockCount + "at time of clearing");
            this.mWakeLockCount = 0;
            this.mWakeLock.release();
            this.mSender.removeMessages(2);
            return true;
        }
    }

    private void send(RILRequest rr) {
        if (this.mSocket == null) {
            rr.onError(1, null);
            rr.release();
            return;
        }
        Message msg = this.mSender.obtainMessage(1, rr);
        this.acquireWakeLock();
        msg.sendToTarget();
    }

    private void processResponse(Parcel p) {
        RILRequest rr;
        int type = p.readInt();
        if (type == 1) {
            this.processUnsolicited(p);
        } else if (type == 0 && (rr = this.processSolicited(p)) != null) {
            rr.release();
            this.decrementWakeLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearRequestList(int error, boolean loggable) {
        SparseArray<RILRequest> sparseArray = this.mRequestList;
        synchronized (sparseArray) {
            int count = this.mRequestList.size();
            if (loggable) {
                Rlog.d(RILJ_LOG_TAG, "clearRequestList  mWakeLockCount=" + this.mWakeLockCount + " mRequestList=" + count);
            }
            for (int i = 0; i < count; ++i) {
                RILRequest rr = this.mRequestList.valueAt(i);
                if (loggable) {
                    Rlog.d(RILJ_LOG_TAG, i + ": [" + rr.mSerial + "] " + RIL.requestToString(rr.mRequest));
                }
                rr.onError(error, null);
                rr.release();
                this.decrementWakeLock();
            }
            this.mRequestList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RILRequest findAndRemoveRequestFromList(int serial) {
        RILRequest rr = null;
        SparseArray<RILRequest> sparseArray = this.mRequestList;
        synchronized (sparseArray) {
            rr = this.mRequestList.get(serial);
            if (rr != null) {
                this.mRequestList.remove(serial);
            }
        }
        return rr;
    }

    private RILRequest processSolicited(Parcel p) {
        boolean found = false;
        int serial = p.readInt();
        int error = p.readInt();
        RILRequest rr = this.findAndRemoveRequestFromList(serial);
        if (rr == null) {
            Rlog.w(RILJ_LOG_TAG, "Unexpected solicited response! sn: " + serial + " error: " + error);
            return null;
        }
        Object ret = null;
        if (error == 0 || p.dataAvail() > 0) {
            try {
                switch (rr.mRequest) {
                    case 1: {
                        ret = this.responseIccCardStatus(p);
                        break;
                    }
                    case 2: {
                        ret = this.responseInts(p);
                        break;
                    }
                    case 3: {
                        ret = this.responseInts(p);
                        break;
                    }
                    case 4: {
                        ret = this.responseInts(p);
                        break;
                    }
                    case 5: {
                        ret = this.responseInts(p);
                        break;
                    }
                    case 6: {
                        ret = this.responseInts(p);
                        break;
                    }
                    case 7: {
                        ret = this.responseInts(p);
                        break;
                    }
                    case 8: {
                        ret = this.responseInts(p);
                        break;
                    }
                    case 9: {
                        ret = this.responseCallList(p);
                        break;
                    }
                    case 10: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 11: {
                        ret = this.responseString(p);
                        break;
                    }
                    case 12: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 13: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 14: {
                        if (this.mTestingEmergencyCall.getAndSet(false) && this.mEmergencyCallbackModeRegistrant != null) {
                            this.riljLog("testing emergency call, notify ECM Registrants");
                            this.mEmergencyCallbackModeRegistrant.notifyRegistrant();
                        }
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 15: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 16: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 17: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 18: {
                        ret = this.responseInts(p);
                        break;
                    }
                    case 19: {
                        ret = this.responseSignalStrength(p);
                        break;
                    }
                    case 20: {
                        ret = this.responseStrings(p);
                        break;
                    }
                    case 21: {
                        ret = this.responseStrings(p);
                        break;
                    }
                    case 22: {
                        ret = this.responseStrings(p);
                        break;
                    }
                    case 23: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 24: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 25: {
                        ret = this.responseSMS(p);
                        break;
                    }
                    case 26: {
                        ret = this.responseSMS(p);
                        break;
                    }
                    case 27: {
                        ret = this.responseSetupDataCall(p);
                        break;
                    }
                    case 28: {
                        ret = this.responseICC_IO(p);
                        break;
                    }
                    case 29: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 30: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 31: {
                        ret = this.responseInts(p);
                        break;
                    }
                    case 32: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 33: {
                        ret = this.responseCallForward(p);
                        break;
                    }
                    case 34: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 35: {
                        ret = this.responseInts(p);
                        break;
                    }
                    case 36: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 37: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 38: {
                        ret = this.responseString(p);
                        break;
                    }
                    case 39: {
                        ret = this.responseString(p);
                        break;
                    }
                    case 40: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 41: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 42: {
                        ret = this.responseInts(p);
                        break;
                    }
                    case 43: {
                        ret = this.responseInts(p);
                        break;
                    }
                    case 44: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 45: {
                        ret = this.responseInts(p);
                        break;
                    }
                    case 46: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 47: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 48: {
                        ret = this.responseOperatorInfos(p);
                        break;
                    }
                    case 49: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 50: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 51: {
                        ret = this.responseString(p);
                        break;
                    }
                    case 52: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 53: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 54: {
                        ret = this.responseInts(p);
                        break;
                    }
                    case 55: {
                        ret = this.responseInts(p);
                        break;
                    }
                    case 56: {
                        ret = this.responseInts(p);
                        break;
                    }
                    case 57: {
                        ret = this.responseDataCallList(p);
                        break;
                    }
                    case 58: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 59: {
                        ret = this.responseRaw(p);
                        break;
                    }
                    case 60: {
                        ret = this.responseStrings(p);
                        break;
                    }
                    case 61: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 62: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 63: {
                        ret = this.responseInts(p);
                        break;
                    }
                    case 64: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 65: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 66: {
                        ret = this.responseInts(p);
                        break;
                    }
                    case 67: {
                        ret = this.responseString(p);
                        break;
                    }
                    case 68: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 69: {
                        ret = this.responseString(p);
                        break;
                    }
                    case 70: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 71: {
                        ret = this.responseInts(p);
                        break;
                    }
                    case 72: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 73: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 74: {
                        ret = this.responseGetPreferredNetworkType(p);
                        break;
                    }
                    case 75: {
                        ret = this.responseCellList(p);
                        break;
                    }
                    case 76: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 77: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 78: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 79: {
                        ret = this.responseInts(p);
                        break;
                    }
                    case 80: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 81: {
                        ret = this.responseInts(p);
                        break;
                    }
                    case 82: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 83: {
                        ret = this.responseInts(p);
                        break;
                    }
                    case 84: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 85: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 87: {
                        ret = this.responseSMS(p);
                        break;
                    }
                    case 88: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 89: {
                        ret = this.responseGmsBroadcastConfig(p);
                        break;
                    }
                    case 90: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 91: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 92: {
                        ret = this.responseCdmaBroadcastConfig(p);
                        break;
                    }
                    case 93: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 94: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 86: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 95: {
                        ret = this.responseStrings(p);
                        break;
                    }
                    case 96: {
                        ret = this.responseInts(p);
                        break;
                    }
                    case 97: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 98: {
                        ret = this.responseStrings(p);
                        break;
                    }
                    case 100: {
                        ret = this.responseString(p);
                        break;
                    }
                    case 101: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 99: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 102: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 103: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 104: {
                        ret = this.responseInts(p);
                        break;
                    }
                    case 105: {
                        ret = this.responseString(p);
                        break;
                    }
                    case 106: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 107: {
                        ret = this.responseICC_IO(p);
                        break;
                    }
                    case 108: {
                        ret = this.responseInts(p);
                        break;
                    }
                    case 109: {
                        ret = this.responseCellInfoList(p);
                        break;
                    }
                    case 110: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 111: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 128: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 112: {
                        ret = this.responseInts(p);
                        break;
                    }
                    case 113: {
                        ret = this.responseSMS(p);
                        break;
                    }
                    case 114: {
                        ret = this.responseICC_IO(p);
                        break;
                    }
                    case 115: {
                        ret = this.responseInts(p);
                        break;
                    }
                    case 116: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 117: {
                        ret = this.responseICC_IO(p);
                        break;
                    }
                    case 118: {
                        ret = this.responseString(p);
                        break;
                    }
                    case 119: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 120: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 121: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 122: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 123: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    case 124: {
                        ret = this.responseHardwareConfig(p);
                        break;
                    }
                    case 125: {
                        ret = this.responseICC_IOBase64(p);
                        break;
                    }
                    case 129: {
                        ret = this.responseVoid(p);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unrecognized solicited response: " + rr.mRequest);
                    }
                }
            }
            catch (Throwable tr) {
                Rlog.w(RILJ_LOG_TAG, rr.serialString() + "< " + RIL.requestToString(rr.mRequest) + " exception, possible invalid RIL response", tr);
                if (rr.mResult != null) {
                    AsyncResult.forMessage(rr.mResult, null, tr);
                    rr.mResult.sendToTarget();
                }
                return rr;
            }
        }
        if (rr.mRequest == 129) {
            this.riljLog("Response to RIL_REQUEST_SHUTDOWN received. Error is " + error + " Setting Radio State to Unavailable regardless of error.");
            this.setRadioState(CommandsInterface.RadioState.RADIO_UNAVAILABLE);
        }
        switch (rr.mRequest) {
            case 3: 
            case 5: {
                if (this.mIccStatusChangedRegistrants == null) break;
                this.riljLog("ON enter sim puk fakeSimStatusChanged: reg count=" + this.mIccStatusChangedRegistrants.size());
                this.mIccStatusChangedRegistrants.notifyRegistrants();
            }
        }
        if (error != 0) {
            switch (rr.mRequest) {
                case 2: 
                case 4: 
                case 6: 
                case 7: 
                case 43: {
                    if (this.mIccStatusChangedRegistrants == null) break;
                    this.riljLog("ON some errors fakeSimStatusChanged: reg count=" + this.mIccStatusChangedRegistrants.size());
                    this.mIccStatusChangedRegistrants.notifyRegistrants();
                }
            }
            rr.onError(error, ret);
        } else {
            this.riljLog(rr.serialString() + "< " + RIL.requestToString(rr.mRequest) + " " + RIL.retToString(rr.mRequest, ret));
            if (rr.mResult != null) {
                AsyncResult.forMessage(rr.mResult, ret, null);
                rr.mResult.sendToTarget();
            }
        }
        return rr;
    }

    static String retToString(int req, Object ret) {
        String s;
        if (ret == null) {
            return "";
        }
        switch (req) {
            case 11: 
            case 38: 
            case 39: 
            case 115: 
            case 117: {
                return "";
            }
        }
        if (ret instanceof int[]) {
            int[] intArray = (int[])ret;
            int length = intArray.length;
            StringBuilder sb = new StringBuilder("{");
            if (length > 0) {
                int i = 0;
                sb.append(intArray[i++]);
                while (i < length) {
                    sb.append(", ").append(intArray[i++]);
                }
            }
            sb.append("}");
            s = sb.toString();
        } else if (ret instanceof String[]) {
            String[] strings = (String[])ret;
            int length = strings.length;
            StringBuilder sb = new StringBuilder("{");
            if (length > 0) {
                int i = 0;
                sb.append(strings[i++]);
                while (i < length) {
                    sb.append(", ").append(strings[i++]);
                }
            }
            sb.append("}");
            s = sb.toString();
        } else if (req == 9) {
            ArrayList calls = (ArrayList)ret;
            StringBuilder sb = new StringBuilder(" ");
            for (DriverCall dc : calls) {
                sb.append("[").append(dc).append("] ");
            }
            s = sb.toString();
        } else if (req == 75) {
            ArrayList cells = (ArrayList)ret;
            StringBuilder sb = new StringBuilder(" ");
            for (NeighboringCellInfo cell : cells) {
                sb.append(cell).append(" ");
            }
            s = sb.toString();
        } else if (req == 124) {
            ArrayList hwcfgs = (ArrayList)ret;
            StringBuilder sb = new StringBuilder(" ");
            for (HardwareConfig hwcfg : hwcfgs) {
                sb.append("[").append(hwcfg).append("] ");
            }
            s = sb.toString();
        } else {
            s = ret.toString();
        }
        return s;
    }

    private void processUnsolicited(Parcel p) {
        Object ret;
        int response = p.readInt();
        try {
            switch (response) {
                case 1000: {
                    ret = this.responseVoid(p);
                    break;
                }
                case 1001: {
                    ret = this.responseVoid(p);
                    break;
                }
                case 1002: {
                    ret = this.responseVoid(p);
                    break;
                }
                case 1003: {
                    ret = this.responseString(p);
                    break;
                }
                case 1004: {
                    ret = this.responseString(p);
                    break;
                }
                case 1005: {
                    ret = this.responseInts(p);
                    break;
                }
                case 1006: {
                    ret = this.responseStrings(p);
                    break;
                }
                case 1008: {
                    ret = this.responseString(p);
                    break;
                }
                case 1009: {
                    ret = this.responseSignalStrength(p);
                    break;
                }
                case 1010: {
                    ret = this.responseDataCallList(p);
                    break;
                }
                case 1011: {
                    ret = this.responseSuppServiceNotification(p);
                    break;
                }
                case 1012: {
                    ret = this.responseVoid(p);
                    break;
                }
                case 1013: {
                    ret = this.responseString(p);
                    break;
                }
                case 1014: {
                    ret = this.responseString(p);
                    break;
                }
                case 1015: {
                    ret = this.responseInts(p);
                    break;
                }
                case 1016: {
                    ret = this.responseVoid(p);
                    break;
                }
                case 1017: {
                    ret = this.responseSimRefresh(p);
                    break;
                }
                case 1018: {
                    ret = this.responseCallRing(p);
                    break;
                }
                case 1023: {
                    ret = this.responseInts(p);
                    break;
                }
                case 1019: {
                    ret = this.responseVoid(p);
                    break;
                }
                case 1020: {
                    ret = this.responseCdmaSms(p);
                    break;
                }
                case 1021: {
                    ret = this.responseRaw(p);
                    break;
                }
                case 1022: {
                    ret = this.responseVoid(p);
                    break;
                }
                case 1024: {
                    ret = this.responseVoid(p);
                    break;
                }
                case 1025: {
                    ret = this.responseCdmaCallWaiting(p);
                    break;
                }
                case 1026: {
                    ret = this.responseInts(p);
                    break;
                }
                case 1027: {
                    ret = this.responseCdmaInformationRecord(p);
                    break;
                }
                case 1028: {
                    ret = this.responseRaw(p);
                    break;
                }
                case 1029: {
                    ret = this.responseInts(p);
                    break;
                }
                case 1030: {
                    ret = this.responseVoid(p);
                    break;
                }
                case 1031: {
                    ret = this.responseInts(p);
                    break;
                }
                case 1032: {
                    ret = this.responseInts(p);
                    break;
                }
                case 1033: {
                    ret = this.responseVoid(p);
                    break;
                }
                case 1034: {
                    ret = this.responseInts(p);
                    break;
                }
                case 1035: {
                    ret = this.responseInts(p);
                    break;
                }
                case 1036: {
                    ret = this.responseCellInfoList(p);
                    break;
                }
                case 1037: {
                    ret = this.responseVoid(p);
                    break;
                }
                case 1038: {
                    ret = this.responseInts(p);
                    break;
                }
                case 1039: {
                    ret = this.responseInts(p);
                    break;
                }
                case 1040: {
                    ret = this.responseHardwareConfig(p);
                    break;
                }
                default: {
                    throw new RuntimeException("Unrecognized unsol response: " + response);
                }
            }
        }
        catch (Throwable tr) {
            Rlog.e(RILJ_LOG_TAG, "Exception processing unsol response: " + response + "Exception:" + tr.toString());
            return;
        }
        switch (response) {
            case 1000: {
                CommandsInterface.RadioState newState = this.getRadioStateFromInt(p.readInt());
                this.unsljLogMore(response, newState.toString());
                this.switchToRadioState(newState);
                break;
            }
            case 1037: {
                this.unsljLog(response);
                this.mImsNetworkStateChangedRegistrants.notifyRegistrants(new AsyncResult(null, null, null));
                break;
            }
            case 1001: {
                this.unsljLog(response);
                this.mCallStateRegistrants.notifyRegistrants(new AsyncResult(null, null, null));
                break;
            }
            case 1002: {
                this.unsljLog(response);
                this.mVoiceNetworkStateRegistrants.notifyRegistrants(new AsyncResult(null, null, null));
                break;
            }
            case 1003: {
                this.unsljLog(response);
                String[] a = new String[2];
                a[1] = (String)ret;
                SmsMessage sms = SmsMessage.newFromCMT(a);
                if (this.mGsmSmsRegistrant == null) break;
                this.mGsmSmsRegistrant.notifyRegistrant(new AsyncResult(null, sms, null));
                break;
            }
            case 1004: {
                this.unsljLogRet(response, ret);
                if (this.mSmsStatusRegistrant == null) break;
                this.mSmsStatusRegistrant.notifyRegistrant(new AsyncResult(null, ret, null));
                break;
            }
            case 1005: {
                this.unsljLogRet(response, ret);
                int[] smsIndex = (int[])ret;
                if (smsIndex.length == 1) {
                    if (this.mSmsOnSimRegistrant == null) break;
                    this.mSmsOnSimRegistrant.notifyRegistrant(new AsyncResult(null, smsIndex, null));
                    break;
                }
                this.riljLog(" NEW_SMS_ON_SIM ERROR with wrong length " + smsIndex.length);
                break;
            }
            case 1006: {
                String[] resp = (String[])ret;
                if (resp.length < 2) {
                    resp = new String[]{((String[])ret)[0], null};
                }
                this.unsljLogMore(response, resp[0]);
                if (this.mUSSDRegistrant == null) break;
                this.mUSSDRegistrant.notifyRegistrant(new AsyncResult(null, resp, null));
                break;
            }
            case 1008: {
                this.unsljLogRet(response, ret);
                long nitzReceiveTime = p.readLong();
                Object[] result = new Object[]{ret, nitzReceiveTime};
                boolean ignoreNitz = SystemProperties.getBoolean("telephony.test.ignore.nitz", false);
                if (ignoreNitz) {
                    this.riljLog("ignoring UNSOL_NITZ_TIME_RECEIVED");
                    break;
                }
                if (this.mNITZTimeRegistrant != null) {
                    this.mNITZTimeRegistrant.notifyRegistrant(new AsyncResult(null, result, null));
                    break;
                }
                this.mLastNITZTimeInfo = result;
                break;
            }
            case 1009: {
                if (this.mSignalStrengthRegistrant == null) break;
                this.mSignalStrengthRegistrant.notifyRegistrant(new AsyncResult(null, ret, null));
                break;
            }
            case 1010: {
                this.unsljLogRet(response, ret);
                this.mDataNetworkStateRegistrants.notifyRegistrants(new AsyncResult(null, ret, null));
                break;
            }
            case 1011: {
                this.unsljLogRet(response, ret);
                if (this.mSsnRegistrant == null) break;
                this.mSsnRegistrant.notifyRegistrant(new AsyncResult(null, ret, null));
                break;
            }
            case 1012: {
                this.unsljLog(response);
                if (this.mCatSessionEndRegistrant == null) break;
                this.mCatSessionEndRegistrant.notifyRegistrant(new AsyncResult(null, ret, null));
                break;
            }
            case 1013: {
                this.unsljLog(response);
                if (this.mCatProCmdRegistrant == null) break;
                this.mCatProCmdRegistrant.notifyRegistrant(new AsyncResult(null, ret, null));
                break;
            }
            case 1014: {
                this.unsljLog(response);
                if (this.mCatEventRegistrant == null) break;
                this.mCatEventRegistrant.notifyRegistrant(new AsyncResult(null, ret, null));
                break;
            }
            case 1015: {
                this.unsljLogRet(response, ret);
                if (this.mCatCallSetUpRegistrant == null) break;
                this.mCatCallSetUpRegistrant.notifyRegistrant(new AsyncResult(null, ret, null));
                break;
            }
            case 1016: {
                this.unsljLog(response);
                if (this.mIccSmsFullRegistrant == null) break;
                this.mIccSmsFullRegistrant.notifyRegistrant();
                break;
            }
            case 1017: {
                this.unsljLogRet(response, ret);
                if (this.mIccRefreshRegistrants == null) break;
                this.mIccRefreshRegistrants.notifyRegistrants(new AsyncResult(null, ret, null));
                break;
            }
            case 1018: {
                this.unsljLogRet(response, ret);
                if (this.mRingRegistrant == null) break;
                this.mRingRegistrant.notifyRegistrant(new AsyncResult(null, ret, null));
                break;
            }
            case 1023: {
                this.unsljLogvRet(response, ret);
                if (this.mRestrictedStateRegistrant == null) break;
                this.mRestrictedStateRegistrant.notifyRegistrant(new AsyncResult(null, ret, null));
                break;
            }
            case 1019: {
                this.unsljLog(response);
                if (this.mIccStatusChangedRegistrants == null) break;
                this.mIccStatusChangedRegistrants.notifyRegistrants();
                break;
            }
            case 1020: {
                this.unsljLog(response);
                SmsMessage sms = (SmsMessage)ret;
                if (this.mCdmaSmsRegistrant == null) break;
                this.mCdmaSmsRegistrant.notifyRegistrant(new AsyncResult(null, sms, null));
                break;
            }
            case 1021: {
                this.unsljLog(response);
                if (this.mGsmBroadcastSmsRegistrant == null) break;
                this.mGsmBroadcastSmsRegistrant.notifyRegistrant(new AsyncResult(null, ret, null));
                break;
            }
            case 1022: {
                this.unsljLog(response);
                if (this.mIccSmsFullRegistrant == null) break;
                this.mIccSmsFullRegistrant.notifyRegistrant();
                break;
            }
            case 1024: {
                this.unsljLog(response);
                if (this.mEmergencyCallbackModeRegistrant == null) break;
                this.mEmergencyCallbackModeRegistrant.notifyRegistrant();
                break;
            }
            case 1025: {
                this.unsljLogRet(response, ret);
                if (this.mCallWaitingInfoRegistrants == null) break;
                this.mCallWaitingInfoRegistrants.notifyRegistrants(new AsyncResult(null, ret, null));
                break;
            }
            case 1026: {
                this.unsljLogRet(response, ret);
                if (this.mOtaProvisionRegistrants == null) break;
                this.mOtaProvisionRegistrants.notifyRegistrants(new AsyncResult(null, ret, null));
                break;
            }
            case 1027: {
                ArrayList listInfoRecs;
                try {
                    listInfoRecs = (ArrayList)ret;
                }
                catch (ClassCastException e) {
                    Rlog.e(RILJ_LOG_TAG, "Unexpected exception casting to listInfoRecs", e);
                    break;
                }
                for (CdmaInformationRecords rec : listInfoRecs) {
                    this.unsljLogRet(response, rec);
                    this.notifyRegistrantsCdmaInfoRec(rec);
                }
                break;
            }
            case 1028: {
                this.unsljLogvRet(response, IccUtils.bytesToHexString((byte[])ret));
                if (this.mUnsolOemHookRawRegistrant == null) break;
                this.mUnsolOemHookRawRegistrant.notifyRegistrant(new AsyncResult(null, ret, null));
                break;
            }
            case 1029: {
                this.unsljLogvRet(response, ret);
                if (this.mRingbackToneRegistrants == null) break;
                boolean playtone = ((int[])ret)[0] == 1;
                this.mRingbackToneRegistrants.notifyRegistrants(new AsyncResult(null, playtone, null));
                break;
            }
            case 1030: {
                this.unsljLogRet(response, ret);
                if (this.mResendIncallMuteRegistrants == null) break;
                this.mResendIncallMuteRegistrants.notifyRegistrants(new AsyncResult(null, ret, null));
                break;
            }
            case 1035: {
                this.unsljLogRet(response, ret);
                if (this.mVoiceRadioTechChangedRegistrants == null) break;
                this.mVoiceRadioTechChangedRegistrants.notifyRegistrants(new AsyncResult(null, ret, null));
                break;
            }
            case 1031: {
                this.unsljLogRet(response, ret);
                if (this.mCdmaSubscriptionChangedRegistrants == null) break;
                this.mCdmaSubscriptionChangedRegistrants.notifyRegistrants(new AsyncResult(null, ret, null));
                break;
            }
            case 1032: {
                this.unsljLogRet(response, ret);
                if (this.mCdmaPrlChangedRegistrants == null) break;
                this.mCdmaPrlChangedRegistrants.notifyRegistrants(new AsyncResult(null, ret, null));
                break;
            }
            case 1033: {
                this.unsljLogRet(response, ret);
                if (this.mExitEmergencyCallbackModeRegistrants == null) break;
                this.mExitEmergencyCallbackModeRegistrants.notifyRegistrants(new AsyncResult(null, null, null));
                break;
            }
            case 1034: {
                this.unsljLogRet(response, ret);
                this.setRadioPower(false, null);
                this.setPreferredNetworkType(this.mPreferredNetworkType, null);
                this.setCdmaSubscriptionSource(this.mCdmaSubscription, null);
                this.setCellInfoListRate(Integer.MAX_VALUE, null);
                this.notifyRegistrantsRilConnectionChanged(((int[])ret)[0]);
                break;
            }
            case 1036: {
                this.unsljLogRet(response, ret);
                if (this.mRilCellInfoListRegistrants == null) break;
                this.mRilCellInfoListRegistrants.notifyRegistrants(new AsyncResult(null, ret, null));
                break;
            }
            case 1038: {
                this.unsljLogRet(response, ret);
                if (this.mSubscriptionStatusRegistrants == null) break;
                this.mSubscriptionStatusRegistrants.notifyRegistrants(new AsyncResult(null, ret, null));
                break;
            }
            case 1039: {
                this.unsljLogRet(response, ret);
                if (this.mSrvccStateRegistrants == null) break;
                this.mSrvccStateRegistrants.notifyRegistrants(new AsyncResult(null, ret, null));
                break;
            }
            case 1040: {
                this.unsljLogRet(response, ret);
                if (this.mHardwareConfigChangeRegistrants == null) break;
                this.mHardwareConfigChangeRegistrants.notifyRegistrants(new AsyncResult(null, ret, null));
            }
        }
    }

    private void notifyRegistrantsRilConnectionChanged(int rilVer) {
        this.mRilVersion = rilVer;
        if (this.mRilConnectedRegistrants != null) {
            this.mRilConnectedRegistrants.notifyRegistrants(new AsyncResult(null, new Integer(rilVer), null));
        }
    }

    private Object responseInts(Parcel p) {
        int numInts = p.readInt();
        int[] response = new int[numInts];
        for (int i = 0; i < numInts; ++i) {
            response[i] = p.readInt();
        }
        return response;
    }

    private Object responseVoid(Parcel p) {
        return null;
    }

    private Object responseCallForward(Parcel p) {
        int numInfos = p.readInt();
        CallForwardInfo[] infos = new CallForwardInfo[numInfos];
        for (int i = 0; i < numInfos; ++i) {
            infos[i] = new CallForwardInfo();
            infos[i].status = p.readInt();
            infos[i].reason = p.readInt();
            infos[i].serviceClass = p.readInt();
            infos[i].toa = p.readInt();
            infos[i].number = p.readString();
            infos[i].timeSeconds = p.readInt();
        }
        return infos;
    }

    private Object responseSuppServiceNotification(Parcel p) {
        SuppServiceNotification notification = new SuppServiceNotification();
        notification.notificationType = p.readInt();
        notification.code = p.readInt();
        notification.index = p.readInt();
        notification.type = p.readInt();
        notification.number = p.readString();
        return notification;
    }

    private Object responseCdmaSms(Parcel p) {
        SmsMessage sms = SmsMessage.newFromParcel(p);
        return sms;
    }

    private Object responseString(Parcel p) {
        String response = p.readString();
        return response;
    }

    private Object responseStrings(Parcel p) {
        String[] response = p.readStringArray();
        return response;
    }

    private Object responseRaw(Parcel p) {
        byte[] response = p.createByteArray();
        return response;
    }

    private Object responseSMS(Parcel p) {
        int messageRef = p.readInt();
        String ackPDU = p.readString();
        int errorCode = p.readInt();
        SmsResponse response = new SmsResponse(messageRef, ackPDU, errorCode);
        return response;
    }

    private Object responseICC_IO(Parcel p) {
        int sw1 = p.readInt();
        int sw2 = p.readInt();
        String s = p.readString();
        return new IccIoResult(sw1, sw2, s);
    }

    private Object responseICC_IOBase64(Parcel p) {
        int sw1 = p.readInt();
        int sw2 = p.readInt();
        String s = p.readString();
        return new IccIoResult(sw1, sw2, Base64.decode(s, 0));
    }

    private Object responseIccCardStatus(Parcel p) {
        IccCardStatus cardStatus = new IccCardStatus();
        cardStatus.setCardState(p.readInt());
        cardStatus.setUniversalPinState(p.readInt());
        cardStatus.mGsmUmtsSubscriptionAppIndex = p.readInt();
        cardStatus.mCdmaSubscriptionAppIndex = p.readInt();
        cardStatus.mImsSubscriptionAppIndex = p.readInt();
        int numApplications = p.readInt();
        if (numApplications > 8) {
            numApplications = 8;
        }
        cardStatus.mApplications = new IccCardApplicationStatus[numApplications];
        for (int i = 0; i < numApplications; ++i) {
            IccCardApplicationStatus appStatus = new IccCardApplicationStatus();
            appStatus.app_type = appStatus.AppTypeFromRILInt(p.readInt());
            appStatus.app_state = appStatus.AppStateFromRILInt(p.readInt());
            appStatus.perso_substate = appStatus.PersoSubstateFromRILInt(p.readInt());
            appStatus.aid = p.readString();
            appStatus.app_label = p.readString();
            appStatus.pin1_replaced = p.readInt();
            appStatus.pin1 = appStatus.PinStateFromRILInt(p.readInt());
            appStatus.pin2 = appStatus.PinStateFromRILInt(p.readInt());
            cardStatus.mApplications[i] = appStatus;
        }
        return cardStatus;
    }

    private Object responseSimRefresh(Parcel p) {
        IccRefreshResponse response = new IccRefreshResponse();
        response.refreshResult = p.readInt();
        response.efId = p.readInt();
        response.aid = p.readString();
        return response;
    }

    private Object responseCallList(Parcel p) {
        int num = p.readInt();
        ArrayList<DriverCall> response = new ArrayList<DriverCall>(num);
        for (int i = 0; i < num; ++i) {
            DriverCall dc = new DriverCall();
            dc.state = DriverCall.stateFromCLCC(p.readInt());
            dc.index = p.readInt();
            dc.TOA = p.readInt();
            dc.isMpty = 0 != p.readInt();
            dc.isMT = 0 != p.readInt();
            dc.als = p.readInt();
            int voiceSettings = p.readInt();
            dc.isVoice = 0 != voiceSettings;
            dc.isVoicePrivacy = 0 != p.readInt();
            dc.number = p.readString();
            int np = p.readInt();
            dc.numberPresentation = DriverCall.presentationFromCLIP(np);
            dc.name = p.readString();
            dc.namePresentation = DriverCall.presentationFromCLIP(p.readInt());
            int uusInfoPresent = p.readInt();
            if (uusInfoPresent == 1) {
                dc.uusInfo = new UUSInfo();
                dc.uusInfo.setType(p.readInt());
                dc.uusInfo.setDcs(p.readInt());
                byte[] userData = p.createByteArray();
                dc.uusInfo.setUserData(userData);
                this.riljLogv(String.format("Incoming UUS : type=%d, dcs=%d, length=%d", dc.uusInfo.getType(), dc.uusInfo.getDcs(), dc.uusInfo.getUserData().length));
                this.riljLogv("Incoming UUS : data (string)=" + new String(dc.uusInfo.getUserData()));
                this.riljLogv("Incoming UUS : data (hex): " + IccUtils.bytesToHexString(dc.uusInfo.getUserData()));
            } else {
                this.riljLogv("Incoming UUS : NOT present!");
            }
            dc.number = PhoneNumberUtils.stringFromStringAndTOA(dc.number, dc.TOA);
            response.add(dc);
            if (dc.isVoicePrivacy) {
                this.mVoicePrivacyOnRegistrants.notifyRegistrants();
                this.riljLog("InCall VoicePrivacy is enabled");
                continue;
            }
            this.mVoicePrivacyOffRegistrants.notifyRegistrants();
            this.riljLog("InCall VoicePrivacy is disabled");
        }
        Collections.sort(response);
        if (num == 0 && this.mTestingEmergencyCall.getAndSet(false) && this.mEmergencyCallbackModeRegistrant != null) {
            this.riljLog("responseCallList: call ended, testing emergency call, notify ECM Registrants");
            this.mEmergencyCallbackModeRegistrant.notifyRegistrant();
        }
        return response;
    }

    private DataCallResponse getDataCallResponse(Parcel p, int version) {
        DataCallResponse dataCall = new DataCallResponse();
        dataCall.version = version;
        if (version < 5) {
            dataCall.cid = p.readInt();
            dataCall.active = p.readInt();
            dataCall.type = p.readString();
            String addresses = p.readString();
            if (!TextUtils.isEmpty(addresses)) {
                dataCall.addresses = addresses.split(" ");
            }
        } else {
            String pcscf;
            String gateways;
            String dnses;
            dataCall.status = p.readInt();
            dataCall.suggestedRetryTime = p.readInt();
            dataCall.cid = p.readInt();
            dataCall.active = p.readInt();
            dataCall.type = p.readString();
            dataCall.ifname = p.readString();
            if (dataCall.status == DcFailCause.NONE.getErrorCode() && TextUtils.isEmpty(dataCall.ifname)) {
                throw new RuntimeException("getDataCallResponse, no ifname");
            }
            String addresses = p.readString();
            if (!TextUtils.isEmpty(addresses)) {
                dataCall.addresses = addresses.split(" ");
            }
            if (!TextUtils.isEmpty(dnses = p.readString())) {
                dataCall.dnses = dnses.split(" ");
            }
            if (!TextUtils.isEmpty(gateways = p.readString())) {
                dataCall.gateways = gateways.split(" ");
            }
            if (version >= 10 && !TextUtils.isEmpty(pcscf = p.readString())) {
                dataCall.pcscf = pcscf.split(" ");
            }
            if (version >= 11) {
                dataCall.mtu = p.readInt();
            }
        }
        return dataCall;
    }

    private Object responseDataCallList(Parcel p) {
        int ver = p.readInt();
        int num = p.readInt();
        this.riljLog("responseDataCallList ver=" + ver + " num=" + num);
        ArrayList<DataCallResponse> response = new ArrayList<DataCallResponse>(num);
        for (int i = 0; i < num; ++i) {
            response.add(this.getDataCallResponse(p, ver));
        }
        return response;
    }

    private Object responseSetupDataCall(Parcel p) {
        DataCallResponse dataCall;
        int ver = p.readInt();
        int num = p.readInt();
        if (ver < 5) {
            dataCall = new DataCallResponse();
            dataCall.version = ver;
            dataCall.cid = Integer.parseInt(p.readString());
            dataCall.ifname = p.readString();
            if (TextUtils.isEmpty(dataCall.ifname)) {
                throw new RuntimeException("RIL_REQUEST_SETUP_DATA_CALL response, no ifname");
            }
            String addresses = p.readString();
            if (!TextUtils.isEmpty(addresses)) {
                dataCall.addresses = addresses.split(" ");
            }
            if (num >= 4) {
                String dnses = p.readString();
                this.riljLog("responseSetupDataCall got dnses=" + dnses);
                if (!TextUtils.isEmpty(dnses)) {
                    dataCall.dnses = dnses.split(" ");
                }
            }
            if (num >= 5) {
                String gateways = p.readString();
                this.riljLog("responseSetupDataCall got gateways=" + gateways);
                if (!TextUtils.isEmpty(gateways)) {
                    dataCall.gateways = gateways.split(" ");
                }
            }
            if (num >= 6) {
                String pcscf = p.readString();
                this.riljLog("responseSetupDataCall got pcscf=" + pcscf);
                if (!TextUtils.isEmpty(pcscf)) {
                    dataCall.pcscf = pcscf.split(" ");
                }
            }
        } else {
            if (num != 1) {
                throw new RuntimeException("RIL_REQUEST_SETUP_DATA_CALL response expecting 1 RIL_Data_Call_response_v5 got " + num);
            }
            dataCall = this.getDataCallResponse(p, ver);
        }
        return dataCall;
    }

    private Object responseOperatorInfos(Parcel p) {
        String[] strings = (String[])this.responseStrings(p);
        if (strings.length % 4 != 0) {
            throw new RuntimeException("RIL_REQUEST_QUERY_AVAILABLE_NETWORKS: invalid response. Got " + strings.length + " strings, expected multible of 4");
        }
        ArrayList<OperatorInfo> ret = new ArrayList<OperatorInfo>(strings.length / 4);
        for (int i = 0; i < strings.length; i += 4) {
            ret.add(new OperatorInfo(strings[i + 0], strings[i + 1], strings[i + 2], strings[i + 3]));
        }
        return ret;
    }

    private Object responseCellList(Parcel p) {
        int num = p.readInt();
        ArrayList<NeighboringCellInfo> response = new ArrayList<NeighboringCellInfo>();
        String radioString = SystemProperties.get("gsm.network.type", "unknown");
        int radioType = radioString.equals("GPRS") ? 1 : (radioString.equals("EDGE") ? 2 : (radioString.equals("UMTS") ? 3 : (radioString.equals("HSDPA") ? 8 : (radioString.equals("HSUPA") ? 9 : (radioString.equals("HSPA") ? 10 : 0)))));
        if (radioType != 0) {
            for (int i = 0; i < num; ++i) {
                int rssi = p.readInt();
                String location = p.readString();
                NeighboringCellInfo cell = new NeighboringCellInfo(rssi, location, radioType);
                response.add(cell);
            }
        }
        return response;
    }

    private Object responseGetPreferredNetworkType(Parcel p) {
        int[] response = (int[])this.responseInts(p);
        if (response.length >= 1) {
            this.mPreferredNetworkType = response[0];
        }
        return response;
    }

    private Object responseGmsBroadcastConfig(Parcel p) {
        int num = p.readInt();
        ArrayList<SmsBroadcastConfigInfo> response = new ArrayList<SmsBroadcastConfigInfo>(num);
        for (int i = 0; i < num; ++i) {
            int fromId = p.readInt();
            int toId = p.readInt();
            int fromScheme = p.readInt();
            int toScheme = p.readInt();
            boolean selected = p.readInt() == 1;
            SmsBroadcastConfigInfo info = new SmsBroadcastConfigInfo(fromId, toId, fromScheme, toScheme, selected);
            response.add(info);
        }
        return response;
    }

    private Object responseCdmaBroadcastConfig(Parcel p) {
        int[] response;
        int numServiceCategories = p.readInt();
        if (numServiceCategories == 0) {
            int numInts = 94;
            response = new int[numInts];
            response[0] = 31;
            for (int i = 1; i < numInts; i += 3) {
                response[i + 0] = i / 3;
                response[i + 1] = 1;
                response[i + 2] = 0;
            }
        } else {
            int numInts = numServiceCategories * 3 + 1;
            response = new int[numInts];
            response[0] = numServiceCategories;
            for (int i = 1; i < numInts; ++i) {
                response[i] = p.readInt();
            }
        }
        return response;
    }

    private Object responseSignalStrength(Parcel p) {
        SignalStrength signalStrength = SignalStrength.makeSignalStrengthFromRilParcel(p);
        return signalStrength;
    }

    private ArrayList<CdmaInformationRecords> responseCdmaInformationRecord(Parcel p) {
        int numberOfInfoRecs = p.readInt();
        ArrayList<CdmaInformationRecords> response = new ArrayList<CdmaInformationRecords>(numberOfInfoRecs);
        for (int i = 0; i < numberOfInfoRecs; ++i) {
            CdmaInformationRecords InfoRec = new CdmaInformationRecords(p);
            response.add(InfoRec);
        }
        return response;
    }

    private Object responseCdmaCallWaiting(Parcel p) {
        CdmaCallWaitingNotification notification = new CdmaCallWaitingNotification();
        notification.number = p.readString();
        notification.numberPresentation = CdmaCallWaitingNotification.presentationFromCLIP(p.readInt());
        notification.name = p.readString();
        notification.namePresentation = notification.numberPresentation;
        notification.isPresent = p.readInt();
        notification.signalType = p.readInt();
        notification.alertPitch = p.readInt();
        notification.signal = p.readInt();
        notification.numberType = p.readInt();
        notification.numberPlan = p.readInt();
        return notification;
    }

    private Object responseCallRing(Parcel p) {
        char[] response = new char[]{(char)p.readInt(), (char)p.readInt(), (char)p.readInt(), (char)p.readInt()};
        return response;
    }

    private void notifyRegistrantsCdmaInfoRec(CdmaInformationRecords infoRec) {
        int response = 1027;
        if (infoRec.record instanceof CdmaInformationRecords.CdmaDisplayInfoRec) {
            if (this.mDisplayInfoRegistrants != null) {
                this.unsljLogRet(response, infoRec.record);
                this.mDisplayInfoRegistrants.notifyRegistrants(new AsyncResult(null, infoRec.record, null));
            }
        } else if (infoRec.record instanceof CdmaInformationRecords.CdmaSignalInfoRec) {
            if (this.mSignalInfoRegistrants != null) {
                this.unsljLogRet(response, infoRec.record);
                this.mSignalInfoRegistrants.notifyRegistrants(new AsyncResult(null, infoRec.record, null));
            }
        } else if (infoRec.record instanceof CdmaInformationRecords.CdmaNumberInfoRec) {
            if (this.mNumberInfoRegistrants != null) {
                this.unsljLogRet(response, infoRec.record);
                this.mNumberInfoRegistrants.notifyRegistrants(new AsyncResult(null, infoRec.record, null));
            }
        } else if (infoRec.record instanceof CdmaInformationRecords.CdmaRedirectingNumberInfoRec) {
            if (this.mRedirNumInfoRegistrants != null) {
                this.unsljLogRet(response, infoRec.record);
                this.mRedirNumInfoRegistrants.notifyRegistrants(new AsyncResult(null, infoRec.record, null));
            }
        } else if (infoRec.record instanceof CdmaInformationRecords.CdmaLineControlInfoRec) {
            if (this.mLineControlInfoRegistrants != null) {
                this.unsljLogRet(response, infoRec.record);
                this.mLineControlInfoRegistrants.notifyRegistrants(new AsyncResult(null, infoRec.record, null));
            }
        } else if (infoRec.record instanceof CdmaInformationRecords.CdmaT53ClirInfoRec) {
            if (this.mT53ClirInfoRegistrants != null) {
                this.unsljLogRet(response, infoRec.record);
                this.mT53ClirInfoRegistrants.notifyRegistrants(new AsyncResult(null, infoRec.record, null));
            }
        } else if (infoRec.record instanceof CdmaInformationRecords.CdmaT53AudioControlInfoRec && this.mT53AudCntrlInfoRegistrants != null) {
            this.unsljLogRet(response, infoRec.record);
            this.mT53AudCntrlInfoRegistrants.notifyRegistrants(new AsyncResult(null, infoRec.record, null));
        }
    }

    private ArrayList<CellInfo> responseCellInfoList(Parcel p) {
        int numberOfInfoRecs = p.readInt();
        ArrayList<CellInfo> response = new ArrayList<CellInfo>(numberOfInfoRecs);
        for (int i = 0; i < numberOfInfoRecs; ++i) {
            CellInfo InfoRec = CellInfo.CREATOR.createFromParcel(p);
            response.add(InfoRec);
        }
        return response;
    }

    private Object responseHardwareConfig(Parcel p) {
        int num = p.readInt();
        ArrayList<HardwareConfig> response = new ArrayList<HardwareConfig>(num);
        for (int i = 0; i < num; ++i) {
            HardwareConfig hw;
            int type = p.readInt();
            switch (type) {
                case 0: {
                    hw = new HardwareConfig(type);
                    hw.assignModem(p.readString(), p.readInt(), p.readInt(), p.readInt(), p.readInt(), p.readInt(), p.readInt());
                    break;
                }
                case 1: {
                    hw = new HardwareConfig(type);
                    hw.assignSim(p.readString(), p.readInt(), p.readString());
                    break;
                }
                default: {
                    throw new RuntimeException("RIL_REQUEST_GET_HARDWARE_CONFIG invalid hardward type:" + type);
                }
            }
            response.add(hw);
        }
        return response;
    }

    static String requestToString(int request) {
        switch (request) {
            case 1: {
                return "GET_SIM_STATUS";
            }
            case 2: {
                return "ENTER_SIM_PIN";
            }
            case 3: {
                return "ENTER_SIM_PUK";
            }
            case 4: {
                return "ENTER_SIM_PIN2";
            }
            case 5: {
                return "ENTER_SIM_PUK2";
            }
            case 6: {
                return "CHANGE_SIM_PIN";
            }
            case 7: {
                return "CHANGE_SIM_PIN2";
            }
            case 8: {
                return "ENTER_NETWORK_DEPERSONALIZATION";
            }
            case 9: {
                return "GET_CURRENT_CALLS";
            }
            case 10: {
                return "DIAL";
            }
            case 11: {
                return "GET_IMSI";
            }
            case 12: {
                return "HANGUP";
            }
            case 13: {
                return "HANGUP_WAITING_OR_BACKGROUND";
            }
            case 14: {
                return "HANGUP_FOREGROUND_RESUME_BACKGROUND";
            }
            case 15: {
                return "REQUEST_SWITCH_WAITING_OR_HOLDING_AND_ACTIVE";
            }
            case 16: {
                return "CONFERENCE";
            }
            case 17: {
                return "UDUB";
            }
            case 18: {
                return "LAST_CALL_FAIL_CAUSE";
            }
            case 19: {
                return "SIGNAL_STRENGTH";
            }
            case 20: {
                return "VOICE_REGISTRATION_STATE";
            }
            case 21: {
                return "DATA_REGISTRATION_STATE";
            }
            case 22: {
                return "OPERATOR";
            }
            case 23: {
                return "RADIO_POWER";
            }
            case 24: {
                return "DTMF";
            }
            case 25: {
                return "SEND_SMS";
            }
            case 26: {
                return "SEND_SMS_EXPECT_MORE";
            }
            case 27: {
                return "SETUP_DATA_CALL";
            }
            case 28: {
                return "SIM_IO";
            }
            case 29: {
                return "SEND_USSD";
            }
            case 30: {
                return "CANCEL_USSD";
            }
            case 31: {
                return "GET_CLIR";
            }
            case 32: {
                return "SET_CLIR";
            }
            case 33: {
                return "QUERY_CALL_FORWARD_STATUS";
            }
            case 34: {
                return "SET_CALL_FORWARD";
            }
            case 35: {
                return "QUERY_CALL_WAITING";
            }
            case 36: {
                return "SET_CALL_WAITING";
            }
            case 37: {
                return "SMS_ACKNOWLEDGE";
            }
            case 38: {
                return "GET_IMEI";
            }
            case 39: {
                return "GET_IMEISV";
            }
            case 40: {
                return "ANSWER";
            }
            case 41: {
                return "DEACTIVATE_DATA_CALL";
            }
            case 42: {
                return "QUERY_FACILITY_LOCK";
            }
            case 43: {
                return "SET_FACILITY_LOCK";
            }
            case 44: {
                return "CHANGE_BARRING_PASSWORD";
            }
            case 45: {
                return "QUERY_NETWORK_SELECTION_MODE";
            }
            case 46: {
                return "SET_NETWORK_SELECTION_AUTOMATIC";
            }
            case 47: {
                return "SET_NETWORK_SELECTION_MANUAL";
            }
            case 48: {
                return "QUERY_AVAILABLE_NETWORKS ";
            }
            case 49: {
                return "DTMF_START";
            }
            case 50: {
                return "DTMF_STOP";
            }
            case 51: {
                return "BASEBAND_VERSION";
            }
            case 52: {
                return "SEPARATE_CONNECTION";
            }
            case 53: {
                return "SET_MUTE";
            }
            case 54: {
                return "GET_MUTE";
            }
            case 55: {
                return "QUERY_CLIP";
            }
            case 56: {
                return "LAST_DATA_CALL_FAIL_CAUSE";
            }
            case 57: {
                return "DATA_CALL_LIST";
            }
            case 58: {
                return "RESET_RADIO";
            }
            case 59: {
                return "OEM_HOOK_RAW";
            }
            case 60: {
                return "OEM_HOOK_STRINGS";
            }
            case 61: {
                return "SCREEN_STATE";
            }
            case 62: {
                return "SET_SUPP_SVC_NOTIFICATION";
            }
            case 63: {
                return "WRITE_SMS_TO_SIM";
            }
            case 64: {
                return "DELETE_SMS_ON_SIM";
            }
            case 65: {
                return "SET_BAND_MODE";
            }
            case 66: {
                return "QUERY_AVAILABLE_BAND_MODE";
            }
            case 67: {
                return "REQUEST_STK_GET_PROFILE";
            }
            case 68: {
                return "REQUEST_STK_SET_PROFILE";
            }
            case 69: {
                return "REQUEST_STK_SEND_ENVELOPE_COMMAND";
            }
            case 70: {
                return "REQUEST_STK_SEND_TERMINAL_RESPONSE";
            }
            case 71: {
                return "REQUEST_STK_HANDLE_CALL_SETUP_REQUESTED_FROM_SIM";
            }
            case 72: {
                return "REQUEST_EXPLICIT_CALL_TRANSFER";
            }
            case 73: {
                return "REQUEST_SET_PREFERRED_NETWORK_TYPE";
            }
            case 74: {
                return "REQUEST_GET_PREFERRED_NETWORK_TYPE";
            }
            case 75: {
                return "REQUEST_GET_NEIGHBORING_CELL_IDS";
            }
            case 76: {
                return "REQUEST_SET_LOCATION_UPDATES";
            }
            case 77: {
                return "RIL_REQUEST_CDMA_SET_SUBSCRIPTION_SOURCE";
            }
            case 78: {
                return "RIL_REQUEST_CDMA_SET_ROAMING_PREFERENCE";
            }
            case 79: {
                return "RIL_REQUEST_CDMA_QUERY_ROAMING_PREFERENCE";
            }
            case 80: {
                return "RIL_REQUEST_SET_TTY_MODE";
            }
            case 81: {
                return "RIL_REQUEST_QUERY_TTY_MODE";
            }
            case 82: {
                return "RIL_REQUEST_CDMA_SET_PREFERRED_VOICE_PRIVACY_MODE";
            }
            case 83: {
                return "RIL_REQUEST_CDMA_QUERY_PREFERRED_VOICE_PRIVACY_MODE";
            }
            case 84: {
                return "RIL_REQUEST_CDMA_FLASH";
            }
            case 85: {
                return "RIL_REQUEST_CDMA_BURST_DTMF";
            }
            case 87: {
                return "RIL_REQUEST_CDMA_SEND_SMS";
            }
            case 88: {
                return "RIL_REQUEST_CDMA_SMS_ACKNOWLEDGE";
            }
            case 89: {
                return "RIL_REQUEST_GSM_GET_BROADCAST_CONFIG";
            }
            case 90: {
                return "RIL_REQUEST_GSM_SET_BROADCAST_CONFIG";
            }
            case 92: {
                return "RIL_REQUEST_CDMA_GET_BROADCAST_CONFIG";
            }
            case 93: {
                return "RIL_REQUEST_CDMA_SET_BROADCAST_CONFIG";
            }
            case 91: {
                return "RIL_REQUEST_GSM_BROADCAST_ACTIVATION";
            }
            case 86: {
                return "RIL_REQUEST_CDMA_VALIDATE_AND_WRITE_AKEY";
            }
            case 94: {
                return "RIL_REQUEST_CDMA_BROADCAST_ACTIVATION";
            }
            case 95: {
                return "RIL_REQUEST_CDMA_SUBSCRIPTION";
            }
            case 96: {
                return "RIL_REQUEST_CDMA_WRITE_SMS_TO_RUIM";
            }
            case 97: {
                return "RIL_REQUEST_CDMA_DELETE_SMS_ON_RUIM";
            }
            case 98: {
                return "RIL_REQUEST_DEVICE_IDENTITY";
            }
            case 100: {
                return "RIL_REQUEST_GET_SMSC_ADDRESS";
            }
            case 101: {
                return "RIL_REQUEST_SET_SMSC_ADDRESS";
            }
            case 99: {
                return "REQUEST_EXIT_EMERGENCY_CALLBACK_MODE";
            }
            case 102: {
                return "RIL_REQUEST_REPORT_SMS_MEMORY_STATUS";
            }
            case 103: {
                return "RIL_REQUEST_REPORT_STK_SERVICE_IS_RUNNING";
            }
            case 104: {
                return "RIL_REQUEST_CDMA_GET_SUBSCRIPTION_SOURCE";
            }
            case 105: {
                return "RIL_REQUEST_ISIM_AUTHENTICATION";
            }
            case 106: {
                return "RIL_REQUEST_ACKNOWLEDGE_INCOMING_GSM_SMS_WITH_PDU";
            }
            case 107: {
                return "RIL_REQUEST_STK_SEND_ENVELOPE_WITH_STATUS";
            }
            case 108: {
                return "RIL_REQUEST_VOICE_RADIO_TECH";
            }
            case 109: {
                return "RIL_REQUEST_GET_CELL_INFO_LIST";
            }
            case 110: {
                return "RIL_REQUEST_SET_CELL_INFO_LIST_RATE";
            }
            case 111: {
                return "RIL_REQUEST_SET_INITIAL_ATTACH_APN";
            }
            case 128: {
                return "RIL_REQUEST_SET_DATA_PROFILE";
            }
            case 112: {
                return "RIL_REQUEST_IMS_REGISTRATION_STATE";
            }
            case 113: {
                return "RIL_REQUEST_IMS_SEND_SMS";
            }
            case 114: {
                return "RIL_REQUEST_SIM_TRANSMIT_APDU_BASIC";
            }
            case 115: {
                return "RIL_REQUEST_SIM_OPEN_CHANNEL";
            }
            case 116: {
                return "RIL_REQUEST_SIM_CLOSE_CHANNEL";
            }
            case 117: {
                return "RIL_REQUEST_SIM_TRANSMIT_APDU_CHANNEL";
            }
            case 118: {
                return "RIL_REQUEST_NV_READ_ITEM";
            }
            case 119: {
                return "RIL_REQUEST_NV_WRITE_ITEM";
            }
            case 120: {
                return "RIL_REQUEST_NV_WRITE_CDMA_PRL";
            }
            case 121: {
                return "RIL_REQUEST_NV_RESET_CONFIG";
            }
            case 122: {
                return "RIL_REQUEST_SET_UICC_SUBSCRIPTION";
            }
            case 123: {
                return "RIL_REQUEST_ALLOW_DATA";
            }
            case 124: {
                return "GET_HARDWARE_CONFIG";
            }
            case 125: {
                return "RIL_REQUEST_SIM_AUTHENTICATION";
            }
            case 129: {
                return "RIL_REQUEST_SHUTDOWN";
            }
        }
        return "<unknown request>";
    }

    static String responseToString(int request) {
        switch (request) {
            case 1000: {
                return "UNSOL_RESPONSE_RADIO_STATE_CHANGED";
            }
            case 1001: {
                return "UNSOL_RESPONSE_CALL_STATE_CHANGED";
            }
            case 1002: {
                return "UNSOL_RESPONSE_VOICE_NETWORK_STATE_CHANGED";
            }
            case 1003: {
                return "UNSOL_RESPONSE_NEW_SMS";
            }
            case 1004: {
                return "UNSOL_RESPONSE_NEW_SMS_STATUS_REPORT";
            }
            case 1005: {
                return "UNSOL_RESPONSE_NEW_SMS_ON_SIM";
            }
            case 1006: {
                return "UNSOL_ON_USSD";
            }
            case 1007: {
                return "UNSOL_ON_USSD_REQUEST";
            }
            case 1008: {
                return "UNSOL_NITZ_TIME_RECEIVED";
            }
            case 1009: {
                return "UNSOL_SIGNAL_STRENGTH";
            }
            case 1010: {
                return "UNSOL_DATA_CALL_LIST_CHANGED";
            }
            case 1011: {
                return "UNSOL_SUPP_SVC_NOTIFICATION";
            }
            case 1012: {
                return "UNSOL_STK_SESSION_END";
            }
            case 1013: {
                return "UNSOL_STK_PROACTIVE_COMMAND";
            }
            case 1014: {
                return "UNSOL_STK_EVENT_NOTIFY";
            }
            case 1015: {
                return "UNSOL_STK_CALL_SETUP";
            }
            case 1016: {
                return "UNSOL_SIM_SMS_STORAGE_FULL";
            }
            case 1017: {
                return "UNSOL_SIM_REFRESH";
            }
            case 1018: {
                return "UNSOL_CALL_RING";
            }
            case 1019: {
                return "UNSOL_RESPONSE_SIM_STATUS_CHANGED";
            }
            case 1020: {
                return "UNSOL_RESPONSE_CDMA_NEW_SMS";
            }
            case 1021: {
                return "UNSOL_RESPONSE_NEW_BROADCAST_SMS";
            }
            case 1022: {
                return "UNSOL_CDMA_RUIM_SMS_STORAGE_FULL";
            }
            case 1023: {
                return "UNSOL_RESTRICTED_STATE_CHANGED";
            }
            case 1024: {
                return "UNSOL_ENTER_EMERGENCY_CALLBACK_MODE";
            }
            case 1025: {
                return "UNSOL_CDMA_CALL_WAITING";
            }
            case 1026: {
                return "UNSOL_CDMA_OTA_PROVISION_STATUS";
            }
            case 1027: {
                return "UNSOL_CDMA_INFO_REC";
            }
            case 1028: {
                return "UNSOL_OEM_HOOK_RAW";
            }
            case 1029: {
                return "UNSOL_RINGBACK_TONE";
            }
            case 1030: {
                return "UNSOL_RESEND_INCALL_MUTE";
            }
            case 1031: {
                return "CDMA_SUBSCRIPTION_SOURCE_CHANGED";
            }
            case 1032: {
                return "UNSOL_CDMA_PRL_CHANGED";
            }
            case 1033: {
                return "UNSOL_EXIT_EMERGENCY_CALLBACK_MODE";
            }
            case 1034: {
                return "UNSOL_RIL_CONNECTED";
            }
            case 1035: {
                return "UNSOL_VOICE_RADIO_TECH_CHANGED";
            }
            case 1036: {
                return "UNSOL_CELL_INFO_LIST";
            }
            case 1037: {
                return "UNSOL_RESPONSE_IMS_NETWORK_STATE_CHANGED";
            }
            case 1038: {
                return "RIL_UNSOL_UICC_SUBSCRIPTION_STATUS_CHANGED";
            }
            case 1039: {
                return "UNSOL_SRVCC_STATE_NOTIFY";
            }
            case 1040: {
                return "RIL_UNSOL_HARDWARE_CONFIG_CHANGED";
            }
        }
        return "<unknown response>";
    }

    private void riljLog(String msg) {
        Rlog.d(RILJ_LOG_TAG, msg + (this.mInstanceId != null ? " [SUB" + this.mInstanceId + "]" : ""));
    }

    private void riljLogv(String msg) {
        Rlog.v(RILJ_LOG_TAG, msg + (this.mInstanceId != null ? " [SUB" + this.mInstanceId + "]" : ""));
    }

    private void unsljLog(int response) {
        this.riljLog("[UNSL]< " + RIL.responseToString(response));
    }

    private void unsljLogMore(int response, String more) {
        this.riljLog("[UNSL]< " + RIL.responseToString(response) + " " + more);
    }

    private void unsljLogRet(int response, Object ret) {
        this.riljLog("[UNSL]< " + RIL.responseToString(response) + " " + RIL.retToString(response, ret));
    }

    private void unsljLogvRet(int response, Object ret) {
        this.riljLogv("[UNSL]< " + RIL.responseToString(response) + " " + RIL.retToString(response, ret));
    }

    @Override
    public void getDeviceIdentity(Message response) {
        RILRequest rr = RILRequest.obtain(98, response);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    @Override
    public void getCDMASubscription(Message response) {
        RILRequest rr = RILRequest.obtain(95, response);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    @Override
    public void setPhoneType(int phoneType) {
        this.riljLog("setPhoneType=" + phoneType + " old value=" + this.mPhoneType);
        this.mPhoneType = phoneType;
    }

    @Override
    public void queryCdmaRoamingPreference(Message response) {
        RILRequest rr = RILRequest.obtain(79, response);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    @Override
    public void setCdmaRoamingPreference(int cdmaRoamingType, Message response) {
        RILRequest rr = RILRequest.obtain(78, response);
        rr.mParcel.writeInt(1);
        rr.mParcel.writeInt(cdmaRoamingType);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " : " + cdmaRoamingType);
        this.send(rr);
    }

    @Override
    public void setCdmaSubscriptionSource(int cdmaSubscription, Message response) {
        RILRequest rr = RILRequest.obtain(77, response);
        rr.mParcel.writeInt(1);
        rr.mParcel.writeInt(cdmaSubscription);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " : " + cdmaSubscription);
        this.send(rr);
    }

    @Override
    public void getCdmaSubscriptionSource(Message response) {
        RILRequest rr = RILRequest.obtain(104, response);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    @Override
    public void queryTTYMode(Message response) {
        RILRequest rr = RILRequest.obtain(81, response);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    @Override
    public void setTTYMode(int ttyMode, Message response) {
        RILRequest rr = RILRequest.obtain(80, response);
        rr.mParcel.writeInt(1);
        rr.mParcel.writeInt(ttyMode);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " : " + ttyMode);
        this.send(rr);
    }

    @Override
    public void sendCDMAFeatureCode(String FeatureCode, Message response) {
        RILRequest rr = RILRequest.obtain(84, response);
        rr.mParcel.writeString(FeatureCode);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " : " + FeatureCode);
        this.send(rr);
    }

    @Override
    public void getCdmaBroadcastConfig(Message response) {
        RILRequest rr = RILRequest.obtain(92, response);
        this.send(rr);
    }

    @Override
    public void setCdmaBroadcastConfig(CdmaSmsBroadcastConfigInfo[] configs, Message response) {
        int i;
        RILRequest rr = RILRequest.obtain(93, response);
        ArrayList<CdmaSmsBroadcastConfigInfo> processedConfigs = new ArrayList<CdmaSmsBroadcastConfigInfo>();
        for (CdmaSmsBroadcastConfigInfo config : configs) {
            for (int i2 = config.getFromServiceCategory(); i2 <= config.getToServiceCategory(); ++i2) {
                processedConfigs.add(new CdmaSmsBroadcastConfigInfo(i2, i2, config.getLanguage(), config.isSelected()));
            }
        }
        CdmaSmsBroadcastConfigInfo[] rilConfigs = processedConfigs.toArray(configs);
        rr.mParcel.writeInt(rilConfigs.length);
        for (i = 0; i < rilConfigs.length; ++i) {
            rr.mParcel.writeInt(rilConfigs[i].getFromServiceCategory());
            rr.mParcel.writeInt(rilConfigs[i].getLanguage());
            rr.mParcel.writeInt(rilConfigs[i].isSelected() ? 1 : 0);
        }
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " with " + rilConfigs.length + " configs : ");
        for (i = 0; i < rilConfigs.length; ++i) {
            this.riljLog(rilConfigs[i].toString());
        }
        this.send(rr);
    }

    @Override
    public void setCdmaBroadcastActivation(boolean activate, Message response) {
        RILRequest rr = RILRequest.obtain(94, response);
        rr.mParcel.writeInt(1);
        rr.mParcel.writeInt(activate ? 0 : 1);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    @Override
    public void exitEmergencyCallbackMode(Message response) {
        RILRequest rr = RILRequest.obtain(99, response);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    @Override
    public void requestIsimAuthentication(String nonce, Message response) {
        RILRequest rr = RILRequest.obtain(105, response);
        rr.mParcel.writeString(nonce);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    @Override
    public void requestIccSimAuthentication(int authContext, String data, String aid, Message response) {
        RILRequest rr = RILRequest.obtain(125, response);
        rr.mParcel.writeInt(authContext);
        rr.mParcel.writeString(data);
        rr.mParcel.writeString(aid);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    @Override
    public void getCellInfoList(Message result) {
        RILRequest rr = RILRequest.obtain(109, result);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    @Override
    public void setCellInfoListRate(int rateInMillis, Message response) {
        this.riljLog("setCellInfoListRate: " + rateInMillis);
        RILRequest rr = RILRequest.obtain(110, response);
        rr.mParcel.writeInt(1);
        rr.mParcel.writeInt(rateInMillis);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    @Override
    public void setInitialAttachApn(String apn, String protocol, int authType, String username, String password, Message result) {
        RILRequest rr = RILRequest.obtain(111, null);
        this.riljLog("Set RIL_REQUEST_SET_INITIAL_ATTACH_APN");
        rr.mParcel.writeString(apn);
        rr.mParcel.writeString(protocol);
        rr.mParcel.writeInt(authType);
        rr.mParcel.writeString(username);
        rr.mParcel.writeString(password);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + ", apn:" + apn + ", protocol:" + protocol + ", authType:" + authType + ", username:" + username + ", password:" + password);
        this.send(rr);
    }

    @Override
    public void setDataProfile(DataProfile[] dps, Message result) {
        this.riljLog("Set RIL_REQUEST_SET_DATA_PROFILE");
        RILRequest rr = RILRequest.obtain(128, null);
        DataProfile.toParcel(rr.mParcel, dps);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " with " + dps + " Data Profiles : ");
        for (int i = 0; i < dps.length; ++i) {
            this.riljLog(dps[i].toString());
        }
        this.send(rr);
    }

    @Override
    public void testingEmergencyCall() {
        this.riljLog("testingEmergencyCall");
        this.mTestingEmergencyCall.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("RIL: " + this);
        pw.println(" mSocket=" + this.mSocket);
        pw.println(" mSenderThread=" + this.mSenderThread);
        pw.println(" mSender=" + this.mSender);
        pw.println(" mReceiverThread=" + this.mReceiverThread);
        pw.println(" mReceiver=" + this.mReceiver);
        pw.println(" mWakeLock=" + this.mWakeLock);
        pw.println(" mWakeLockTimeout=" + this.mWakeLockTimeout);
        SparseArray<RILRequest> sparseArray = this.mRequestList;
        synchronized (sparseArray) {
            PowerManager.WakeLock wakeLock = this.mWakeLock;
            synchronized (wakeLock) {
                pw.println(" mWakeLockCount=" + this.mWakeLockCount);
            }
            int count = this.mRequestList.size();
            pw.println(" mRequestList count=" + count);
            for (int i = 0; i < count; ++i) {
                RILRequest rr = this.mRequestList.valueAt(i);
                pw.println("  [" + rr.mSerial + "] " + RIL.requestToString(rr.mRequest));
            }
        }
        pw.println(" mLastNITZTimeInfo=" + this.mLastNITZTimeInfo);
        pw.println(" mTestingEmergencyCall=" + this.mTestingEmergencyCall.get());
    }

    @Override
    public void iccOpenLogicalChannel(String AID, Message response) {
        RILRequest rr = RILRequest.obtain(115, response);
        rr.mParcel.writeString(AID);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    @Override
    public void iccCloseLogicalChannel(int channel, Message response) {
        RILRequest rr = RILRequest.obtain(116, response);
        rr.mParcel.writeInt(1);
        rr.mParcel.writeInt(channel);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    @Override
    public void iccTransmitApduLogicalChannel(int channel, int cla, int instruction, int p1, int p2, int p3, String data, Message response) {
        if (channel <= 0) {
            throw new RuntimeException("Invalid channel in iccTransmitApduLogicalChannel: " + channel);
        }
        this.iccTransmitApduHelper(117, channel, cla, instruction, p1, p2, p3, data, response);
    }

    @Override
    public void iccTransmitApduBasicChannel(int cla, int instruction, int p1, int p2, int p3, String data, Message response) {
        this.iccTransmitApduHelper(114, 0, cla, instruction, p1, p2, p3, data, response);
    }

    private void iccTransmitApduHelper(int rilCommand, int channel, int cla, int instruction, int p1, int p2, int p3, String data, Message response) {
        RILRequest rr = RILRequest.obtain(rilCommand, response);
        rr.mParcel.writeInt(channel);
        rr.mParcel.writeInt(cla);
        rr.mParcel.writeInt(instruction);
        rr.mParcel.writeInt(p1);
        rr.mParcel.writeInt(p2);
        rr.mParcel.writeInt(p3);
        rr.mParcel.writeString(data);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest));
        this.send(rr);
    }

    @Override
    public void nvReadItem(int itemID, Message response) {
        RILRequest rr = RILRequest.obtain(118, response);
        rr.mParcel.writeInt(itemID);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + ' ' + itemID);
        this.send(rr);
    }

    @Override
    public void nvWriteItem(int itemID, String itemValue, Message response) {
        RILRequest rr = RILRequest.obtain(119, response);
        rr.mParcel.writeInt(itemID);
        rr.mParcel.writeString(itemValue);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + ' ' + itemID + ": " + itemValue);
        this.send(rr);
    }

    @Override
    public void nvWriteCdmaPrl(byte[] preferredRoamingList, Message response) {
        RILRequest rr = RILRequest.obtain(120, response);
        rr.mParcel.writeByteArray(preferredRoamingList);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + " (" + preferredRoamingList.length + " bytes)");
        this.send(rr);
    }

    @Override
    public void nvResetConfig(int resetType, Message response) {
        RILRequest rr = RILRequest.obtain(121, response);
        rr.mParcel.writeInt(1);
        rr.mParcel.writeInt(resetType);
        this.riljLog(rr.serialString() + "> " + RIL.requestToString(rr.mRequest) + ' ' + resetType);
        this.send(rr);
    }

    class RILReceiver
    implements Runnable {
        byte[] buffer = new byte[8192];

        RILReceiver() {
        }

        @Override
        public void run() {
            int retryCount = 0;
            String rilSocket = "rild";
            try {
                while (true) {
                    LocalSocket s = null;
                    rilSocket = RIL.this.mInstanceId == null || RIL.this.mInstanceId == 0 ? SOCKET_NAME_RIL[0] : SOCKET_NAME_RIL[RIL.this.mInstanceId];
                    try {
                        s = new LocalSocket();
                        LocalSocketAddress l = new LocalSocketAddress(rilSocket, LocalSocketAddress.Namespace.RESERVED);
                        s.connect(l);
                    }
                    catch (IOException ex) {
                        try {
                            if (s != null) {
                                s.close();
                            }
                        }
                        catch (IOException ex2) {
                            // empty catch block
                        }
                        if (retryCount == 8) {
                            Rlog.e(RIL.RILJ_LOG_TAG, "Couldn't find '" + rilSocket + "' socket after " + retryCount + " times, continuing to retry silently");
                        } else if (retryCount > 0 && retryCount < 8) {
                            Rlog.i(RIL.RILJ_LOG_TAG, "Couldn't find '" + rilSocket + "' socket; retrying after timeout");
                        }
                        try {
                            Thread.sleep(4000L);
                        }
                        catch (InterruptedException er) {
                            // empty catch block
                        }
                        ++retryCount;
                        continue;
                    }
                    retryCount = 0;
                    RIL.this.mSocket = s;
                    Rlog.i(RIL.RILJ_LOG_TAG, "Connected to '" + rilSocket + "' socket");
                    int length = 0;
                    try {
                        InputStream is = RIL.this.mSocket.getInputStream();
                        while ((length = RIL.readRilMessage(is, this.buffer)) >= 0) {
                            Parcel p = Parcel.obtain();
                            p.unmarshall(this.buffer, 0, length);
                            p.setDataPosition(0);
                            RIL.this.processResponse(p);
                            p.recycle();
                        }
                    }
                    catch (IOException ex) {
                        Rlog.i(RIL.RILJ_LOG_TAG, "'" + rilSocket + "' socket closed", ex);
                    }
                    catch (Throwable tr) {
                        Rlog.e(RIL.RILJ_LOG_TAG, "Uncaught exception read length=" + length + "Exception:" + tr.toString());
                    }
                    Rlog.i(RIL.RILJ_LOG_TAG, "Disconnected from '" + rilSocket + "' socket");
                    RIL.this.setRadioState(CommandsInterface.RadioState.RADIO_UNAVAILABLE);
                    try {
                        RIL.this.mSocket.close();
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                    RIL.this.mSocket = null;
                    RILRequest.resetSerial();
                    RIL.this.clearRequestList(1, false);
                }
            }
            catch (Throwable tr) {
                Rlog.e(RIL.RILJ_LOG_TAG, "Uncaught exception", tr);
                RIL.this.notifyRegistrantsRilConnectionChanged(-1);
                return;
            }
        }
    }

    class RILSender
    extends Handler
    implements Runnable {
        byte[] dataLength;

        public RILSender(Looper looper) {
            super(looper);
            this.dataLength = new byte[4];
        }

        @Override
        public void run() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            RILRequest rr = (RILRequest)msg.obj;
            RILRequest req = null;
            switch (msg.what) {
                case 1: {
                    try {
                        LocalSocket s = RIL.this.mSocket;
                        if (s == null) {
                            rr.onError(1, null);
                            rr.release();
                            RIL.this.decrementWakeLock();
                            return;
                        }
                        SparseArray<RILRequest> sparseArray = RIL.this.mRequestList;
                        synchronized (sparseArray) {
                            RIL.this.mRequestList.append(rr.mSerial, rr);
                        }
                        byte[] data = rr.mParcel.marshall();
                        rr.mParcel.recycle();
                        rr.mParcel = null;
                        if (data.length > 8192) {
                            throw new RuntimeException("Parcel larger than max bytes allowed! " + data.length);
                        }
                        this.dataLength[1] = 0;
                        this.dataLength[0] = 0;
                        this.dataLength[2] = (byte)(data.length >> 8 & 0xFF);
                        this.dataLength[3] = (byte)(data.length & 0xFF);
                        s.getOutputStream().write(this.dataLength);
                        s.getOutputStream().write(data);
                    }
                    catch (IOException ex) {
                        Rlog.e(RIL.RILJ_LOG_TAG, "IOException", ex);
                        req = RIL.this.findAndRemoveRequestFromList(rr.mSerial);
                        if (req == null) break;
                        rr.onError(1, null);
                        rr.release();
                        RIL.this.decrementWakeLock();
                    }
                    catch (RuntimeException exc) {
                        Rlog.e(RIL.RILJ_LOG_TAG, "Uncaught exception ", exc);
                        req = RIL.this.findAndRemoveRequestFromList(rr.mSerial);
                        if (req == null) break;
                        rr.onError(2, null);
                        rr.release();
                        RIL.this.decrementWakeLock();
                    }
                    break;
                }
                case 2: {
                    SparseArray<RILRequest> sparseArray = RIL.this.mRequestList;
                    synchronized (sparseArray) {
                        if (RIL.this.clearWakeLock()) {
                            int count = RIL.this.mRequestList.size();
                            Rlog.d(RIL.RILJ_LOG_TAG, "WAKE_LOCK_TIMEOUT  mRequestList=" + count);
                            for (int i = 0; i < count; ++i) {
                                rr = RIL.this.mRequestList.valueAt(i);
                                Rlog.d(RIL.RILJ_LOG_TAG, i + ": [" + rr.mSerial + "] " + RIL.requestToString(rr.mRequest));
                            }
                        }
                        break;
                    }
                }
            }
        }
    }
}

