/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.AlertDialog;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.database.ContentObserver;
import android.database.sqlite.SqliteWrapper;
import android.net.Uri;
import android.os.AsyncResult;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.SystemProperties;
import android.provider.Settings;
import android.provider.Telephony;
import android.telephony.PhoneNumberUtils;
import android.telephony.Rlog;
import android.telephony.TelephonyManager;
import android.text.Html;
import android.text.Spanned;
import android.text.TextUtils;
import android.util.EventLog;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.TextView;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.GsmAlphabet;
import com.android.internal.telephony.ImsSMSDispatcher;
import com.android.internal.telephony.PhoneBase;
import com.android.internal.telephony.SmsApplication;
import com.android.internal.telephony.SmsHeader;
import com.android.internal.telephony.SmsMessageBase;
import com.android.internal.telephony.SmsResponse;
import com.android.internal.telephony.SmsUsageMonitor;
import com.android.internal.telephony.SubscriptionController;
import com.android.internal.telephony.uicc.UiccCard;
import com.android.internal.telephony.uicc.UiccController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class SMSDispatcher
extends Handler {
    static final String TAG = "SMSDispatcher";
    static final boolean DBG = false;
    private static final String SEND_NEXT_MSG_EXTRA = "SendNextMsg";
    private static final String SEND_SMS_NO_CONFIRMATION_PERMISSION = "android.permission.SEND_SMS_NO_CONFIRMATION";
    private static final int PREMIUM_RULE_USE_SIM = 1;
    private static final int PREMIUM_RULE_USE_NETWORK = 2;
    private static final int PREMIUM_RULE_USE_BOTH = 3;
    private final AtomicInteger mPremiumSmsRule = new AtomicInteger(1);
    private final SettingsObserver mSettingsObserver;
    protected static final int EVENT_SEND_SMS_COMPLETE = 2;
    private static final int EVENT_SEND_RETRY = 3;
    private static final int EVENT_SEND_LIMIT_REACHED_CONFIRMATION = 4;
    static final int EVENT_SEND_CONFIRMED_SMS = 5;
    static final int EVENT_STOP_SENDING = 7;
    private static final int EVENT_CONFIRM_SEND_TO_POSSIBLE_PREMIUM_SHORT_CODE = 8;
    private static final int EVENT_CONFIRM_SEND_TO_PREMIUM_SHORT_CODE = 9;
    protected static final int EVENT_HANDLE_STATUS_REPORT = 10;
    protected static final int EVENT_RADIO_ON = 11;
    protected static final int EVENT_IMS_STATE_CHANGED = 12;
    protected static final int EVENT_IMS_STATE_DONE = 13;
    protected static final int EVENT_NEW_ICC_SMS = 14;
    protected static final int EVENT_ICC_CHANGED = 15;
    protected PhoneBase mPhone;
    protected final Context mContext;
    protected final ContentResolver mResolver;
    protected final CommandsInterface mCi;
    protected final TelephonyManager mTelephonyManager;
    private static final int MAX_SEND_RETRIES = 3;
    private static final int SEND_RETRY_DELAY = 2000;
    private static final int SINGLE_PART_SMS = 1;
    private static final int MO_MSG_QUEUE_LIMIT = 5;
    private static int sConcatenatedRef = new Random().nextInt(256);
    private SmsUsageMonitor mUsageMonitor;
    private ImsSMSDispatcher mImsSMSDispatcher;
    private int mPendingTrackerCount;
    protected boolean mSmsCapable = true;
    protected boolean mSmsSendDisabled;
    protected final ArrayList<SmsTracker> deliveryPendingList = new ArrayList();
    protected final List<SmsTracker> sendPendingList = Collections.synchronizedList(new ArrayList());

    protected static int getNextConcatenatedRef() {
        return ++sConcatenatedRef;
    }

    protected SMSDispatcher(PhoneBase phone, SmsUsageMonitor usageMonitor, ImsSMSDispatcher imsSMSDispatcher) {
        this.mPhone = phone;
        this.mImsSMSDispatcher = imsSMSDispatcher;
        this.mContext = phone.getContext();
        this.mResolver = this.mContext.getContentResolver();
        this.mCi = phone.mCi;
        this.mUsageMonitor = usageMonitor;
        this.mTelephonyManager = (TelephonyManager)this.mContext.getSystemService("phone");
        this.mSettingsObserver = new SettingsObserver(this, this.mPremiumSmsRule, this.mContext);
        this.mContext.getContentResolver().registerContentObserver(Settings.Global.getUriFor("sms_short_code_rule"), false, this.mSettingsObserver);
        this.mSmsCapable = this.mContext.getResources().getBoolean(17956932);
        this.mSmsSendDisabled = !SystemProperties.getBoolean("telephony.sms.send", this.mSmsCapable);
        Rlog.d(TAG, "SMSDispatcher: ctor mSmsCapable=" + this.mSmsCapable + " format=" + this.getFormat() + " mSmsSendDisabled=" + this.mSmsSendDisabled);
    }

    protected void updatePhoneObject(PhoneBase phone) {
        this.mPhone = phone;
        this.mUsageMonitor = phone.mSmsUsageMonitor;
        Rlog.d(TAG, "Active phone changed to " + this.mPhone.getPhoneName());
    }

    public void dispose() {
        this.mContext.getContentResolver().unregisterContentObserver(this.mSettingsObserver);
    }

    protected abstract String getFormat();

    protected void handleStatusReport(Object o) {
        Rlog.d(TAG, "handleStatusReport() called with no subclass.");
    }

    @Override
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 2: {
                this.handleSendComplete((AsyncResult)msg.obj);
                break;
            }
            case 3: {
                Rlog.d(TAG, "SMS retry..");
                this.sendRetrySms((SmsTracker)msg.obj);
                break;
            }
            case 4: {
                this.handleReachSentLimit((SmsTracker)msg.obj);
                break;
            }
            case 8: {
                this.handleConfirmShortCode(false, (SmsTracker)msg.obj);
                break;
            }
            case 9: {
                this.handleConfirmShortCode(true, (SmsTracker)msg.obj);
                break;
            }
            case 5: {
                SmsTracker tracker = (SmsTracker)msg.obj;
                if (tracker.isMultipart()) {
                    this.sendMultipartSms(tracker);
                } else {
                    tracker.mExpectMore = this.mPendingTrackerCount > 1;
                    this.sendSms(tracker);
                }
                --this.mPendingTrackerCount;
                break;
            }
            case 7: {
                SmsTracker tracker = (SmsTracker)msg.obj;
                tracker.onFailed(this.mContext, 5, 0);
                --this.mPendingTrackerCount;
                break;
            }
            case 10: {
                this.handleStatusReport(msg.obj);
                break;
            }
            default: {
                Rlog.e(TAG, "handleMessage() ignoring message of unexpected type " + msg.what);
            }
        }
    }

    protected void handleSendComplete(AsyncResult ar) {
        SmsTracker tracker = (SmsTracker)ar.userObj;
        PendingIntent sentIntent = tracker.mSentIntent;
        if (ar.result != null) {
            tracker.mMessageRef = ((SmsResponse)ar.result).mMessageRef;
        } else {
            Rlog.d(TAG, "SmsResponse was null");
        }
        if (ar.exception == null) {
            if (tracker.mDeliveryIntent != null) {
                this.deliveryPendingList.add(tracker);
            }
            tracker.onSent(this.mContext);
        } else {
            int ss = this.mPhone.getServiceState().getState();
            if (tracker.mImsRetry > 0 && ss != 0) {
                tracker.mRetryCount = 3;
                Rlog.d(TAG, "handleSendComplete: Skipping retry:  isIms()=" + this.isIms() + " mRetryCount=" + tracker.mRetryCount + " mImsRetry=" + tracker.mImsRetry + " mMessageRef=" + tracker.mMessageRef + " SS= " + this.mPhone.getServiceState().getState());
            }
            if (!this.isIms() && ss != 0) {
                tracker.onFailed(this.mContext, SMSDispatcher.getNotInServiceError(ss), 0);
            } else if (((CommandException)ar.exception).getCommandError() == CommandException.Error.SMS_FAIL_RETRY && tracker.mRetryCount < 3) {
                ++tracker.mRetryCount;
                Message retryMsg = this.obtainMessage(3, tracker);
                this.sendMessageDelayed(retryMsg, 2000L);
            } else {
                int errorCode = 0;
                if (ar.result != null) {
                    errorCode = ((SmsResponse)ar.result).mErrorCode;
                }
                int error = 1;
                if (((CommandException)ar.exception).getCommandError() == CommandException.Error.FDN_CHECK_FAILURE) {
                    error = 6;
                }
                tracker.onFailed(this.mContext, error, errorCode);
            }
        }
    }

    protected static void handleNotInService(int ss, PendingIntent sentIntent) {
        if (sentIntent != null) {
            try {
                if (ss == 3) {
                    sentIntent.send(2);
                } else {
                    sentIntent.send(4);
                }
            }
            catch (PendingIntent.CanceledException canceledException) {
                // empty catch block
            }
        }
    }

    protected static int getNotInServiceError(int ss) {
        if (ss == 3) {
            return 2;
        }
        return 4;
    }

    protected abstract void sendData(String var1, String var2, int var3, byte[] var4, PendingIntent var5, PendingIntent var6);

    protected abstract void sendText(String var1, String var2, String var3, PendingIntent var4, PendingIntent var5, Uri var6, String var7);

    protected abstract void injectSmsPdu(byte[] var1, String var2, PendingIntent var3);

    protected abstract GsmAlphabet.TextEncodingDetails calculateLength(CharSequence var1, boolean var2);

    protected abstract void updateSmsSendStatus(int var1, boolean var2);

    protected void sendMultipartText(String destAddr, String scAddr, ArrayList<String> parts, ArrayList<PendingIntent> sentIntents, ArrayList<PendingIntent> deliveryIntents, Uri messageUri, String callingPkg) {
        if (messageUri == null) {
            if (SmsApplication.shouldWriteMessageForPackage(callingPkg, this.mContext)) {
                messageUri = this.writeOutboxMessage(this.getSubId(), destAddr, this.getMultipartMessageText(parts), deliveryIntents != null && deliveryIntents.size() > 0, callingPkg);
            }
        } else {
            this.moveToOutbox(this.getSubId(), messageUri, callingPkg);
        }
        int refNumber = SMSDispatcher.getNextConcatenatedRef() & 0xFF;
        int msgCount = parts.size();
        int encoding = 0;
        GsmAlphabet.TextEncodingDetails[] encodingForParts = new GsmAlphabet.TextEncodingDetails[msgCount];
        for (int i = 0; i < msgCount; ++i) {
            GsmAlphabet.TextEncodingDetails details = this.calculateLength(parts.get(i), false);
            if (encoding != details.codeUnitSize && (encoding == 0 || encoding == 1)) {
                encoding = details.codeUnitSize;
            }
            encodingForParts[i] = details;
        }
        AtomicInteger unsentPartCount = new AtomicInteger(msgCount);
        AtomicBoolean anyPartFailed = new AtomicBoolean(false);
        for (int i = 0; i < msgCount; ++i) {
            SmsHeader.ConcatRef concatRef = new SmsHeader.ConcatRef();
            concatRef.refNumber = refNumber;
            concatRef.seqNumber = i + 1;
            concatRef.msgCount = msgCount;
            concatRef.isEightBits = true;
            SmsHeader smsHeader = new SmsHeader();
            smsHeader.concatRef = concatRef;
            if (encoding == 1) {
                smsHeader.languageTable = encodingForParts[i].languageTable;
                smsHeader.languageShiftTable = encodingForParts[i].languageShiftTable;
            }
            PendingIntent sentIntent = null;
            if (sentIntents != null && sentIntents.size() > i) {
                sentIntent = sentIntents.get(i);
            }
            PendingIntent deliveryIntent = null;
            if (deliveryIntents != null && deliveryIntents.size() > i) {
                deliveryIntent = deliveryIntents.get(i);
            }
            this.sendNewSubmitPdu(destAddr, scAddr, parts.get(i), smsHeader, encoding, sentIntent, deliveryIntent, i == msgCount - 1, unsentPartCount, anyPartFailed, messageUri);
        }
    }

    protected abstract void sendNewSubmitPdu(String var1, String var2, String var3, SmsHeader var4, int var5, PendingIntent var6, PendingIntent var7, boolean var8, AtomicInteger var9, AtomicBoolean var10, Uri var11);

    protected void sendRawPdu(SmsTracker tracker) {
        PackageInfo appInfo;
        HashMap<String, Object> map = tracker.mData;
        byte[] pdu = (byte[])map.get("pdu");
        if (this.mSmsSendDisabled) {
            Rlog.e(TAG, "Device does not support sending sms.");
            tracker.onFailed(this.mContext, 4, 0);
            return;
        }
        if (pdu == null) {
            Rlog.e(TAG, "Empty PDU");
            tracker.onFailed(this.mContext, 3, 0);
            return;
        }
        PackageManager pm = this.mContext.getPackageManager();
        String[] packageNames = pm.getPackagesForUid(Binder.getCallingUid());
        if (packageNames == null || packageNames.length == 0) {
            Rlog.e(TAG, "Can't get calling app package name: refusing to send SMS");
            tracker.onFailed(this.mContext, 1, 0);
            return;
        }
        try {
            appInfo = pm.getPackageInfo(packageNames[0], 64);
        }
        catch (PackageManager.NameNotFoundException e) {
            Rlog.e(TAG, "Can't get calling app package info: refusing to send SMS");
            tracker.onFailed(this.mContext, 1, 0);
            return;
        }
        if (this.checkDestination(tracker)) {
            if (!this.mUsageMonitor.check(appInfo.packageName, 1)) {
                this.sendMessage(this.obtainMessage(4, tracker));
                return;
            }
            this.sendSms(tracker);
        }
    }

    boolean checkDestination(SmsTracker tracker) {
        if (this.mContext.checkCallingOrSelfPermission(SEND_SMS_NO_CONFIRMATION_PERMISSION) == 0) {
            return true;
        }
        int rule = this.mPremiumSmsRule.get();
        int smsCategory = 0;
        if (rule == 1 || rule == 3) {
            String simCountryIso = this.mTelephonyManager.getSimCountryIso();
            if (simCountryIso == null || simCountryIso.length() != 2) {
                Rlog.e(TAG, "Can't get SIM country Iso: trying network country Iso");
                simCountryIso = this.mTelephonyManager.getNetworkCountryIso();
            }
            smsCategory = this.mUsageMonitor.checkDestination(tracker.mDestAddress, simCountryIso);
        }
        if (rule == 2 || rule == 3) {
            String networkCountryIso = this.mTelephonyManager.getNetworkCountryIso();
            if (networkCountryIso == null || networkCountryIso.length() != 2) {
                Rlog.e(TAG, "Can't get Network country Iso: trying SIM country Iso");
                networkCountryIso = this.mTelephonyManager.getSimCountryIso();
            }
            smsCategory = SmsUsageMonitor.mergeShortCodeCategories(smsCategory, this.mUsageMonitor.checkDestination(tracker.mDestAddress, networkCountryIso));
        }
        if (smsCategory == 0 || smsCategory == 1 || smsCategory == 2) {
            return true;
        }
        int premiumSmsPermission = this.mUsageMonitor.getPremiumSmsPermission(tracker.mAppInfo.packageName);
        if (premiumSmsPermission == 0) {
            premiumSmsPermission = 1;
        }
        switch (premiumSmsPermission) {
            case 3: {
                Rlog.d(TAG, "User approved this app to send to premium SMS");
                return true;
            }
            case 2: {
                Rlog.w(TAG, "User denied this app from sending to premium SMS");
                this.sendMessage(this.obtainMessage(7, tracker));
                return false;
            }
        }
        int event = smsCategory == 3 ? 8 : 9;
        this.sendMessage(this.obtainMessage(event, tracker));
        return false;
    }

    private boolean denyIfQueueLimitReached(SmsTracker tracker) {
        if (this.mPendingTrackerCount >= 5) {
            Rlog.e(TAG, "Denied because queue limit reached");
            tracker.onFailed(this.mContext, 5, 0);
            return true;
        }
        ++this.mPendingTrackerCount;
        return false;
    }

    private CharSequence getAppLabel(String appPackage) {
        PackageManager pm = this.mContext.getPackageManager();
        try {
            ApplicationInfo appInfo = pm.getApplicationInfo(appPackage, 0);
            return appInfo.loadLabel(pm);
        }
        catch (PackageManager.NameNotFoundException e) {
            Rlog.e(TAG, "PackageManager Name Not Found for package " + appPackage);
            return appPackage;
        }
    }

    protected void handleReachSentLimit(SmsTracker tracker) {
        if (this.denyIfQueueLimitReached(tracker)) {
            return;
        }
        CharSequence appLabel = this.getAppLabel(tracker.mAppInfo.packageName);
        Resources r = Resources.getSystem();
        Spanned messageText = Html.fromHtml(r.getString(17040570, appLabel));
        ConfirmDialogListener listener = new ConfirmDialogListener(tracker, null);
        AlertDialog d = new AlertDialog.Builder(this.mContext).setTitle(17040569).setIcon(17301642).setMessage(messageText).setPositiveButton(r.getString(17040571), (DialogInterface.OnClickListener)listener).setNegativeButton(r.getString(17040572), (DialogInterface.OnClickListener)listener).setOnCancelListener(listener).create();
        d.getWindow().setType(2003);
        d.show();
    }

    protected void handleConfirmShortCode(boolean isPremium, SmsTracker tracker) {
        if (this.denyIfQueueLimitReached(tracker)) {
            return;
        }
        int detailsId = isPremium ? 17040575 : 17040574;
        CharSequence appLabel = this.getAppLabel(tracker.mAppInfo.packageName);
        Resources r = Resources.getSystem();
        Spanned messageText = Html.fromHtml(r.getString(17040573, appLabel, tracker.mDestAddress));
        LayoutInflater inflater = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
        View layout2 = inflater.inflate(17367245, null);
        ConfirmDialogListener listener = new ConfirmDialogListener(tracker, (TextView)layout2.findViewById(16909197));
        TextView messageView = (TextView)layout2.findViewById(16909191);
        messageView.setText(messageText);
        ViewGroup detailsLayout = (ViewGroup)layout2.findViewById(16909192);
        TextView detailsView = (TextView)detailsLayout.findViewById(16909194);
        detailsView.setText(detailsId);
        CheckBox rememberChoice = (CheckBox)layout2.findViewById(16909195);
        rememberChoice.setOnCheckedChangeListener(listener);
        AlertDialog d = new AlertDialog.Builder(this.mContext).setView(layout2).setPositiveButton(r.getString(17040576), (DialogInterface.OnClickListener)listener).setNegativeButton(r.getString(17040577), (DialogInterface.OnClickListener)listener).setOnCancelListener(listener).create();
        d.getWindow().setType(2003);
        d.show();
        listener.setPositiveButton(d.getButton(-1));
        listener.setNegativeButton(d.getButton(-2));
    }

    public int getPremiumSmsPermission(String packageName) {
        return this.mUsageMonitor.getPremiumSmsPermission(packageName);
    }

    public void setPremiumSmsPermission(String packageName, int permission2) {
        this.mUsageMonitor.setPremiumSmsPermission(packageName, permission2);
    }

    protected abstract void sendSms(SmsTracker var1);

    protected abstract void sendSmsByPstn(SmsTracker var1);

    public void sendRetrySms(SmsTracker tracker) {
        if (this.mImsSMSDispatcher != null) {
            this.mImsSMSDispatcher.sendRetrySms(tracker);
        } else {
            Rlog.e(TAG, this.mImsSMSDispatcher + " is null. Retry failed");
        }
    }

    private void sendMultipartSms(SmsTracker tracker) {
        HashMap<String, Object> map = tracker.mData;
        String destinationAddress = (String)map.get("destination");
        String scAddress = (String)map.get("scaddress");
        ArrayList parts = (ArrayList)map.get("parts");
        ArrayList sentIntents = (ArrayList)map.get("sentIntents");
        ArrayList deliveryIntents = (ArrayList)map.get("deliveryIntents");
        int ss = this.mPhone.getServiceState().getState();
        if (!this.isIms() && ss != 0) {
            int count = parts.size();
            for (int i = 0; i < count; ++i) {
                PendingIntent sentIntent = null;
                if (sentIntents != null && sentIntents.size() > i) {
                    sentIntent = (PendingIntent)sentIntents.get(i);
                }
                SMSDispatcher.handleNotInService(ss, sentIntent);
            }
            return;
        }
        this.sendMultipartText(destinationAddress, scAddress, parts, sentIntents, deliveryIntents, null, null);
    }

    protected SmsTracker getSmsTracker(HashMap<String, Object> data, PendingIntent sentIntent, PendingIntent deliveryIntent, String format, AtomicInteger unsentPartCount, AtomicBoolean anyPartFailed, Uri messageUri, SmsHeader smsHeader, boolean isExpectMore) {
        PackageManager pm = this.mContext.getPackageManager();
        String[] packageNames = pm.getPackagesForUid(Binder.getCallingUid());
        PackageInfo appInfo = null;
        if (packageNames != null && packageNames.length > 0) {
            try {
                appInfo = pm.getPackageInfo(packageNames[0], 64);
            }
            catch (PackageManager.NameNotFoundException e) {
                // empty catch block
            }
        }
        String destAddr = PhoneNumberUtils.extractNetworkPortion((String)data.get("destAddr"));
        return new SmsTracker(data, sentIntent, deliveryIntent, appInfo, destAddr, format, unsentPartCount, anyPartFailed, messageUri, smsHeader, isExpectMore);
    }

    protected SmsTracker getSmsTracker(HashMap<String, Object> data, PendingIntent sentIntent, PendingIntent deliveryIntent, String format, Uri messageUri, boolean isExpectMore) {
        return this.getSmsTracker(data, sentIntent, deliveryIntent, format, null, null, messageUri, null, isExpectMore);
    }

    protected HashMap<String, Object> getSmsTrackerMap(String destAddr, String scAddr, String text, SmsMessageBase.SubmitPduBase pdu) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("destAddr", destAddr);
        map.put("scAddr", scAddr);
        map.put("text", text);
        map.put("smsc", pdu.encodedScAddress);
        map.put("pdu", pdu.encodedMessage);
        return map;
    }

    protected HashMap<String, Object> getSmsTrackerMap(String destAddr, String scAddr, int destPort, byte[] data, SmsMessageBase.SubmitPduBase pdu) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("destAddr", destAddr);
        map.put("scAddr", scAddr);
        map.put("destPort", destPort);
        map.put("data", data);
        map.put("smsc", pdu.encodedScAddress);
        map.put("pdu", pdu.encodedMessage);
        return map;
    }

    public boolean isIms() {
        if (this.mImsSMSDispatcher != null) {
            return this.mImsSMSDispatcher.isIms();
        }
        Rlog.e(TAG, this.mImsSMSDispatcher + " is null");
        return false;
    }

    public String getImsSmsFormat() {
        if (this.mImsSMSDispatcher != null) {
            return this.mImsSMSDispatcher.getImsSmsFormat();
        }
        Rlog.e(TAG, this.mImsSMSDispatcher + " is null");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Uri writeOutboxMessage(long subId, String address, String text, boolean requireDeliveryReport, String creator) {
        ContentValues values = new ContentValues(8);
        values.put("sub_id", subId);
        values.put("address", address);
        values.put("body", text);
        values.put("date", System.currentTimeMillis());
        values.put("seen", 1);
        values.put("read", 1);
        if (!TextUtils.isEmpty(creator)) {
            values.put("creator", creator);
        }
        if (requireDeliveryReport) {
            values.put("status", 32);
        }
        long identity = Binder.clearCallingIdentity();
        try {
            Uri uri;
            Uri uri2 = uri = this.mContext.getContentResolver().insert(Telephony.Sms.Outbox.CONTENT_URI, values);
            return uri2;
        }
        catch (Exception e) {
            Rlog.e(TAG, "writeOutboxMessage: Failed to persist outbox message", e);
            Uri uri = null;
            return uri;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void moveToOutbox(long subId, Uri messageUri, String creator) {
        ContentValues values = new ContentValues(4);
        values.put("sub_id", subId);
        if (!TextUtils.isEmpty(creator)) {
            values.put("creator", creator);
        }
        values.put("date", System.currentTimeMillis());
        values.put("type", 4);
        long identity = Binder.clearCallingIdentity();
        try {
            if (this.mContext.getContentResolver().update(messageUri, values, null, null) != 1) {
                Rlog.e(TAG, "moveToOutbox: failed to update message " + messageUri);
            }
        }
        catch (Exception e) {
            Rlog.e(TAG, "moveToOutbox: Failed to update message", e);
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    private String getMultipartMessageText(ArrayList<String> parts) {
        StringBuilder sb = new StringBuilder();
        for (String part : parts) {
            if (part == null) continue;
            sb.append(part);
        }
        return sb.toString();
    }

    protected String getCarrierAppPackageName(Intent intent) {
        UiccCard card = UiccController.getInstance().getUiccCard();
        if (card == null) {
            return null;
        }
        List<String> carrierPackages = card.getCarrierPackageNamesForIntent(this.mContext.getPackageManager(), intent);
        return carrierPackages != null && carrierPackages.size() == 1 ? carrierPackages.get(0) : null;
    }

    protected long getSubId() {
        return SubscriptionController.getInstance().getSubIdUsingPhoneId(this.mPhone.mPhoneId);
    }

    private final class ConfirmDialogListener
    implements DialogInterface.OnClickListener,
    DialogInterface.OnCancelListener,
    CompoundButton.OnCheckedChangeListener {
        private final SmsTracker mTracker;
        private Button mPositiveButton;
        private Button mNegativeButton;
        private boolean mRememberChoice;
        private final TextView mRememberUndoInstruction;

        ConfirmDialogListener(SmsTracker tracker, TextView textView) {
            this.mTracker = tracker;
            this.mRememberUndoInstruction = textView;
        }

        void setPositiveButton(Button button) {
            this.mPositiveButton = button;
        }

        void setNegativeButton(Button button) {
            this.mNegativeButton = button;
        }

        @Override
        public void onClick(DialogInterface dialog, int which) {
            int newSmsPermission = 1;
            if (which == -1) {
                Rlog.d(SMSDispatcher.TAG, "CONFIRM sending SMS");
                EventLog.writeEvent(50128, this.mTracker.mAppInfo.applicationInfo == null ? -1 : this.mTracker.mAppInfo.applicationInfo.uid);
                SMSDispatcher.this.sendMessage(SMSDispatcher.this.obtainMessage(5, this.mTracker));
                if (this.mRememberChoice) {
                    newSmsPermission = 3;
                }
            } else if (which == -2) {
                Rlog.d(SMSDispatcher.TAG, "DENY sending SMS");
                EventLog.writeEvent(50125, this.mTracker.mAppInfo.applicationInfo == null ? -1 : this.mTracker.mAppInfo.applicationInfo.uid);
                SMSDispatcher.this.sendMessage(SMSDispatcher.this.obtainMessage(7, this.mTracker));
                if (this.mRememberChoice) {
                    newSmsPermission = 2;
                }
            }
            SMSDispatcher.this.setPremiumSmsPermission(this.mTracker.mAppInfo.packageName, newSmsPermission);
        }

        @Override
        public void onCancel(DialogInterface dialog) {
            Rlog.d(SMSDispatcher.TAG, "dialog dismissed: don't send SMS");
            SMSDispatcher.this.sendMessage(SMSDispatcher.this.obtainMessage(7, this.mTracker));
        }

        @Override
        public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
            Rlog.d(SMSDispatcher.TAG, "remember this choice: " + isChecked);
            this.mRememberChoice = isChecked;
            if (isChecked) {
                this.mPositiveButton.setText(17040580);
                this.mNegativeButton.setText(17040581);
                if (this.mRememberUndoInstruction != null) {
                    this.mRememberUndoInstruction.setText(17040579);
                    this.mRememberUndoInstruction.setPadding(0, 0, 0, 32);
                }
            } else {
                this.mPositiveButton.setText(17040576);
                this.mNegativeButton.setText(17040577);
                if (this.mRememberUndoInstruction != null) {
                    this.mRememberUndoInstruction.setText("");
                    this.mRememberUndoInstruction.setPadding(0, 0, 0, 0);
                }
            }
        }
    }

    protected static final class SmsTracker {
        public final HashMap<String, Object> mData;
        public int mRetryCount;
        public int mImsRetry;
        public int mMessageRef;
        public boolean mExpectMore;
        String mFormat;
        public final PendingIntent mSentIntent;
        public final PendingIntent mDeliveryIntent;
        public final PackageInfo mAppInfo;
        public final String mDestAddress;
        public final SmsHeader mSmsHeader;
        private long mTimestamp = System.currentTimeMillis();
        public Uri mMessageUri;
        private AtomicInteger mUnsentPartCount;
        private AtomicBoolean mAnyPartFailed;

        private SmsTracker(HashMap<String, Object> data, PendingIntent sentIntent, PendingIntent deliveryIntent, PackageInfo appInfo, String destAddr, String format, AtomicInteger unsentPartCount, AtomicBoolean anyPartFailed, Uri messageUri, SmsHeader smsHeader, boolean isExpectMore) {
            this.mData = data;
            this.mSentIntent = sentIntent;
            this.mDeliveryIntent = deliveryIntent;
            this.mRetryCount = 0;
            this.mAppInfo = appInfo;
            this.mDestAddress = destAddr;
            this.mFormat = format;
            this.mExpectMore = isExpectMore;
            this.mImsRetry = 0;
            this.mMessageRef = 0;
            this.mUnsentPartCount = unsentPartCount;
            this.mAnyPartFailed = anyPartFailed;
            this.mMessageUri = messageUri;
            this.mSmsHeader = smsHeader;
        }

        boolean isMultipart() {
            return this.mData.containsKey("parts");
        }

        void writeSentMessage(Context context) {
            String text = (String)this.mData.get("text");
            if (text != null) {
                boolean deliveryReport = this.mDeliveryIntent != null;
                this.mMessageUri = Telephony.Sms.addMessageToUri(context.getContentResolver(), Telephony.Sms.Sent.CONTENT_URI, this.mDestAddress, text, null, this.mTimestamp, true, deliveryReport, 0L);
            }
        }

        public void updateSentMessageStatus(Context context, int status) {
            if (this.mMessageUri != null) {
                ContentValues values = new ContentValues(1);
                values.put("status", status);
                SqliteWrapper.update(context, context.getContentResolver(), this.mMessageUri, values, null, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateMessageErrorCode(Context context, int errorCode) {
            if (this.mMessageUri == null) {
                return;
            }
            ContentValues values = new ContentValues(1);
            values.put("error_code", errorCode);
            long identity = Binder.clearCallingIdentity();
            try {
                if (SqliteWrapper.update(context, context.getContentResolver(), this.mMessageUri, values, null, null) != 1) {
                    Rlog.e(SMSDispatcher.TAG, "Failed to update message error code");
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setMessageFinalState(Context context, int messageType) {
            if (this.mMessageUri == null) {
                return;
            }
            ContentValues values = new ContentValues(1);
            values.put("type", messageType);
            long identity = Binder.clearCallingIdentity();
            try {
                if (SqliteWrapper.update(context, context.getContentResolver(), this.mMessageUri, values, null, null) != 1) {
                    Rlog.e(SMSDispatcher.TAG, "Failed to move message to " + messageType);
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        public void onFailed(Context context, int error, int errorCode) {
            if (this.mAnyPartFailed != null) {
                this.mAnyPartFailed.set(true);
            }
            boolean isSinglePartOrLastPart = true;
            if (this.mUnsentPartCount != null) {
                boolean bl = isSinglePartOrLastPart = this.mUnsentPartCount.decrementAndGet() == 0;
            }
            if (errorCode != 0) {
                this.updateMessageErrorCode(context, errorCode);
            }
            if (isSinglePartOrLastPart) {
                this.setMessageFinalState(context, 5);
            }
            if (this.mSentIntent != null) {
                try {
                    Intent fillIn = new Intent();
                    if (this.mMessageUri != null) {
                        fillIn.putExtra("uri", this.mMessageUri.toString());
                    }
                    if (errorCode != 0) {
                        fillIn.putExtra("errorCode", errorCode);
                    }
                    if (this.mUnsentPartCount != null && isSinglePartOrLastPart) {
                        fillIn.putExtra(SMSDispatcher.SEND_NEXT_MSG_EXTRA, true);
                    }
                    this.mSentIntent.send(context, error, fillIn);
                }
                catch (PendingIntent.CanceledException ex) {
                    Rlog.e(SMSDispatcher.TAG, "Failed to send result");
                }
            }
        }

        public void onSent(Context context) {
            boolean isSinglePartOrLastPart = true;
            if (this.mUnsentPartCount != null) {
                boolean bl = isSinglePartOrLastPart = this.mUnsentPartCount.decrementAndGet() == 0;
            }
            if (isSinglePartOrLastPart) {
                boolean success = true;
                if (this.mAnyPartFailed != null && this.mAnyPartFailed.get()) {
                    success = false;
                }
                if (success) {
                    this.setMessageFinalState(context, 2);
                } else {
                    this.setMessageFinalState(context, 5);
                }
            }
            if (this.mSentIntent != null) {
                try {
                    Intent fillIn = new Intent();
                    if (this.mMessageUri != null) {
                        fillIn.putExtra("uri", this.mMessageUri.toString());
                    }
                    if (this.mUnsentPartCount != null && isSinglePartOrLastPart) {
                        fillIn.putExtra(SMSDispatcher.SEND_NEXT_MSG_EXTRA, true);
                    }
                    this.mSentIntent.send(context, -1, fillIn);
                }
                catch (PendingIntent.CanceledException ex) {
                    Rlog.e(SMSDispatcher.TAG, "Failed to send result");
                }
            }
        }
    }

    protected final class SMSDispatcherReceiver
    extends BroadcastReceiver {
        private final SmsTracker mTracker;

        public SMSDispatcherReceiver(SmsTracker tracker) {
            this.mTracker = tracker;
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action.equals("android.provider.Telephony.SMS_SEND")) {
                int rc = this.getResultCode();
                if (rc == -1) {
                    Rlog.d(SMSDispatcher.TAG, "Sending SMS by IP pending.");
                    Bundle resultExtras = this.getResultExtras(false);
                    if (resultExtras != null && resultExtras.containsKey("messageref")) {
                        this.mTracker.mMessageRef = resultExtras.getInt("messageref");
                        Rlog.d(SMSDispatcher.TAG, "messageref = " + this.mTracker.mMessageRef);
                    } else {
                        Rlog.e(SMSDispatcher.TAG, "Can't find messageref in result extras.");
                    }
                    SMSDispatcher.this.sendPendingList.add(this.mTracker);
                } else {
                    Rlog.d(SMSDispatcher.TAG, "Sending SMS by IP failed.");
                    SMSDispatcher.this.sendSmsByPstn(this.mTracker);
                }
            } else {
                Rlog.e(SMSDispatcher.TAG, "unexpected BroadcastReceiver action: " + action);
            }
        }
    }

    private static class SettingsObserver
    extends ContentObserver {
        private final AtomicInteger mPremiumSmsRule;
        private final Context mContext;

        SettingsObserver(Handler handler, AtomicInteger premiumSmsRule, Context context) {
            super(handler);
            this.mPremiumSmsRule = premiumSmsRule;
            this.mContext = context;
            this.onChange(false);
        }

        @Override
        public void onChange(boolean selfChange) {
            this.mPremiumSmsRule.set(Settings.Global.getInt(this.mContext.getContentResolver(), "sms_short_code_rule", 1));
        }
    }
}

