/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.AppGlobals;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.res.XmlResourceParser;
import android.database.ContentObserver;
import android.os.Binder;
import android.os.Handler;
import android.os.RemoteException;
import android.os.UserHandle;
import android.provider.Settings;
import android.telephony.PhoneNumberUtils;
import android.telephony.Rlog;
import android.util.AtomicFile;
import android.util.Xml;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.XmlUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class SmsUsageMonitor {
    private static final String TAG = "SmsUsageMonitor";
    private static final boolean DBG = false;
    private static final boolean VDBG = false;
    private static final String SHORT_CODE_PATH = "/data/misc/sms/codes";
    private static final int DEFAULT_SMS_CHECK_PERIOD = 60000;
    private static final int DEFAULT_SMS_MAX_COUNT = 30;
    static final int CATEGORY_NOT_SHORT_CODE = 0;
    static final int CATEGORY_FREE_SHORT_CODE = 1;
    static final int CATEGORY_STANDARD_SHORT_CODE = 2;
    static final int CATEGORY_POSSIBLE_PREMIUM_SHORT_CODE = 3;
    static final int CATEGORY_PREMIUM_SHORT_CODE = 4;
    public static final int PREMIUM_SMS_PERMISSION_UNKNOWN = 0;
    public static final int PREMIUM_SMS_PERMISSION_ASK_USER = 1;
    public static final int PREMIUM_SMS_PERMISSION_NEVER_ALLOW = 2;
    public static final int PREMIUM_SMS_PERMISSION_ALWAYS_ALLOW = 3;
    private final int mCheckPeriod;
    private final int mMaxAllowed;
    private final HashMap<String, ArrayList<Long>> mSmsStamp = new HashMap();
    private final Context mContext;
    private String mCurrentCountry;
    private ShortCodePatternMatcher mCurrentPatternMatcher;
    private final AtomicBoolean mCheckEnabled = new AtomicBoolean(true);
    private final SettingsObserverHandler mSettingsObserverHandler;
    private final File mPatternFile = new File("/data/misc/sms/codes");
    private long mPatternFileLastModified = 0L;
    private static final String SMS_POLICY_FILE_DIRECTORY = "/data/misc/sms";
    private static final String SMS_POLICY_FILE_NAME = "premium_sms_policy.xml";
    private static final String TAG_SHORTCODES = "shortcodes";
    private static final String TAG_SHORTCODE = "shortcode";
    private static final String ATTR_COUNTRY = "country";
    private static final String ATTR_PATTERN = "pattern";
    private static final String ATTR_PREMIUM = "premium";
    private static final String ATTR_FREE = "free";
    private static final String ATTR_STANDARD = "standard";
    private AtomicFile mPolicyFile;
    private final HashMap<String, Integer> mPremiumSmsPolicy = new HashMap();
    private static final String TAG_SMS_POLICY_BODY = "premium-sms-policy";
    private static final String TAG_PACKAGE = "package";
    private static final String ATTR_PACKAGE_NAME = "name";
    private static final String ATTR_PACKAGE_SMS_POLICY = "sms-policy";

    public static int mergeShortCodeCategories(int type1, int type2) {
        if (type1 > type2) {
            return type1;
        }
        return type2;
    }

    public SmsUsageMonitor(Context context) {
        this.mContext = context;
        ContentResolver resolver = context.getContentResolver();
        this.mMaxAllowed = Settings.Global.getInt(resolver, "sms_outgoing_check_max_count", 30);
        this.mCheckPeriod = Settings.Global.getInt(resolver, "sms_outgoing_check_interval_ms", 60000);
        this.mSettingsObserverHandler = new SettingsObserverHandler(this.mContext, this.mCheckEnabled);
        this.loadPremiumSmsPolicyDb();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ShortCodePatternMatcher getPatternMatcherFromFile(String country) {
        FileReader patternReader = null;
        XmlPullParser parser = null;
        try {
            patternReader = new FileReader(this.mPatternFile);
            parser = Xml.newPullParser();
            parser.setInput(patternReader);
            ShortCodePatternMatcher shortCodePatternMatcher = this.getPatternMatcherFromXmlParser(parser, country);
            return shortCodePatternMatcher;
        }
        catch (FileNotFoundException e) {
            Rlog.e(TAG, "Short Code Pattern File not found");
        }
        catch (XmlPullParserException e) {
            Rlog.e(TAG, "XML parser exception reading short code pattern file", e);
        }
        finally {
            this.mPatternFileLastModified = this.mPatternFile.lastModified();
            if (patternReader != null) {
                try {
                    patternReader.close();
                }
                catch (IOException e) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ShortCodePatternMatcher getPatternMatcherFromResource(String country) {
        int id2 = 0x1110011;
        try (XmlResourceParser parser = null;){
            parser = this.mContext.getResources().getXml(id2);
            ShortCodePatternMatcher shortCodePatternMatcher = this.getPatternMatcherFromXmlParser(parser, country);
            return shortCodePatternMatcher;
        }
    }

    private ShortCodePatternMatcher getPatternMatcherFromXmlParser(XmlPullParser parser, String country) {
        try {
            XmlUtils.beginDocument(parser, TAG_SHORTCODES);
            while (true) {
                XmlUtils.nextElement(parser);
                String element = parser.getName();
                if (element == null) {
                    Rlog.e(TAG, "Parsing pattern data found null");
                    break;
                }
                if (element.equals(TAG_SHORTCODE)) {
                    String currentCountry = parser.getAttributeValue(null, ATTR_COUNTRY);
                    if (!country.equals(currentCountry)) continue;
                    String pattern = parser.getAttributeValue(null, ATTR_PATTERN);
                    String premium = parser.getAttributeValue(null, ATTR_PREMIUM);
                    String free = parser.getAttributeValue(null, ATTR_FREE);
                    String standard = parser.getAttributeValue(null, ATTR_STANDARD);
                    return new ShortCodePatternMatcher(pattern, premium, free, standard);
                }
                Rlog.e(TAG, "Error: skipping unknown XML tag " + element);
            }
        }
        catch (XmlPullParserException e) {
            Rlog.e(TAG, "XML parser exception reading short code patterns", e);
        }
        catch (IOException e) {
            Rlog.e(TAG, "I/O exception reading short code patterns", e);
        }
        return null;
    }

    void dispose() {
        this.mSmsStamp.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean check(String appName, int smsWaiting) {
        HashMap<String, ArrayList<Long>> hashMap = this.mSmsStamp;
        synchronized (hashMap) {
            this.removeExpiredTimestamps();
            ArrayList<Long> sentList = this.mSmsStamp.get(appName);
            if (sentList == null) {
                sentList = new ArrayList();
                this.mSmsStamp.put(appName, sentList);
            }
            return this.isUnderLimit(sentList, smsWaiting);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int checkDestination(String destAddress, String countryIso) {
        SettingsObserverHandler settingsObserverHandler = this.mSettingsObserverHandler;
        synchronized (settingsObserverHandler) {
            if (PhoneNumberUtils.isEmergencyNumber(destAddress, countryIso)) {
                return 0;
            }
            if (!this.mCheckEnabled.get()) {
                return 0;
            }
            if (!(countryIso == null || this.mCurrentCountry != null && countryIso.equals(this.mCurrentCountry) && this.mPatternFile.lastModified() == this.mPatternFileLastModified)) {
                this.mCurrentPatternMatcher = this.mPatternFile.exists() ? this.getPatternMatcherFromFile(countryIso) : this.getPatternMatcherFromResource(countryIso);
                this.mCurrentCountry = countryIso;
            }
            if (this.mCurrentPatternMatcher != null) {
                return this.mCurrentPatternMatcher.getNumberCategory(destAddress);
            }
            Rlog.e(TAG, "No patterns for \"" + countryIso + "\": using generic short code rule");
            if (destAddress.length() <= 5) {
                return 3;
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPremiumSmsPolicyDb() {
        HashMap<String, Integer> hashMap = this.mPremiumSmsPolicy;
        synchronized (hashMap) {
            if (this.mPolicyFile == null) {
                File dir = new File(SMS_POLICY_FILE_DIRECTORY);
                this.mPolicyFile = new AtomicFile(new File(dir, SMS_POLICY_FILE_NAME));
                this.mPremiumSmsPolicy.clear();
                FileInputStream infile = null;
                try {
                    infile = this.mPolicyFile.openRead();
                    XmlPullParser parser = Xml.newPullParser();
                    parser.setInput(infile, null);
                    XmlUtils.beginDocument(parser, TAG_SMS_POLICY_BODY);
                    while (true) {
                        XmlUtils.nextElement(parser);
                        String element = parser.getName();
                        if (element == null) {
                            break;
                        }
                        if (element.equals(TAG_PACKAGE)) {
                            String packageName = parser.getAttributeValue(null, ATTR_PACKAGE_NAME);
                            String policy = parser.getAttributeValue(null, ATTR_PACKAGE_SMS_POLICY);
                            if (packageName == null) {
                                Rlog.e(TAG, "Error: missing package name attribute");
                                continue;
                            }
                            if (policy == null) {
                                Rlog.e(TAG, "Error: missing package policy attribute");
                                continue;
                            }
                            try {
                                this.mPremiumSmsPolicy.put(packageName, Integer.parseInt(policy));
                            }
                            catch (NumberFormatException e) {
                                Rlog.e(TAG, "Error: non-numeric policy type " + policy);
                            }
                            continue;
                        }
                        Rlog.e(TAG, "Error: skipping unknown XML tag " + element);
                    }
                }
                catch (FileNotFoundException e) {
                }
                catch (IOException e) {
                    Rlog.e(TAG, "Unable to read premium SMS policy database", e);
                }
                catch (NumberFormatException e) {
                    Rlog.e(TAG, "Unable to parse premium SMS policy database", e);
                }
                catch (XmlPullParserException e) {
                    Rlog.e(TAG, "Unable to parse premium SMS policy database", e);
                }
                finally {
                    if (infile != null) {
                        try {
                            infile.close();
                        }
                        catch (IOException ignored) {}
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePremiumSmsPolicyDb() {
        HashMap<String, Integer> hashMap = this.mPremiumSmsPolicy;
        synchronized (hashMap) {
            block6: {
                FileOutputStream outfile = null;
                try {
                    outfile = this.mPolicyFile.startWrite();
                    FastXmlSerializer out = new FastXmlSerializer();
                    out.setOutput(outfile, "utf-8");
                    out.startDocument(null, true);
                    out.startTag(null, TAG_SMS_POLICY_BODY);
                    for (Map.Entry<String, Integer> policy : this.mPremiumSmsPolicy.entrySet()) {
                        out.startTag(null, TAG_PACKAGE);
                        out.attribute(null, ATTR_PACKAGE_NAME, policy.getKey());
                        out.attribute(null, ATTR_PACKAGE_SMS_POLICY, policy.getValue().toString());
                        out.endTag(null, TAG_PACKAGE);
                    }
                    out.endTag(null, TAG_SMS_POLICY_BODY);
                    out.endDocument();
                    this.mPolicyFile.finishWrite(outfile);
                }
                catch (IOException e) {
                    Rlog.e(TAG, "Unable to write premium SMS policy database", e);
                    if (outfile == null) break block6;
                    this.mPolicyFile.failWrite(outfile);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPremiumSmsPermission(String packageName) {
        SmsUsageMonitor.checkCallerIsSystemOrSameApp(packageName);
        HashMap<String, Integer> hashMap = this.mPremiumSmsPolicy;
        synchronized (hashMap) {
            Integer policy = this.mPremiumSmsPolicy.get(packageName);
            if (policy == null) {
                return 0;
            }
            return policy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPremiumSmsPermission(String packageName, int permission2) {
        SmsUsageMonitor.checkCallerIsSystemOrPhoneApp();
        if (permission2 < 1 || permission2 > 3) {
            throw new IllegalArgumentException("invalid SMS permission type " + permission2);
        }
        HashMap<String, Integer> hashMap = this.mPremiumSmsPolicy;
        synchronized (hashMap) {
            this.mPremiumSmsPolicy.put(packageName, permission2);
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                SmsUsageMonitor.this.writePremiumSmsPolicyDb();
            }
        }).start();
    }

    private static void checkCallerIsSystemOrSameApp(String pkg) {
        int uid = Binder.getCallingUid();
        if (UserHandle.getAppId(uid) == 1000 || uid == 0) {
            return;
        }
        try {
            ApplicationInfo ai = AppGlobals.getPackageManager().getApplicationInfo(pkg, 0, UserHandle.getCallingUserId());
            if (!UserHandle.isSameApp(ai.uid, uid)) {
                throw new SecurityException("Calling uid " + uid + " gave package" + pkg + " which is owned by uid " + ai.uid);
            }
        }
        catch (RemoteException re) {
            throw new SecurityException("Unknown package " + pkg + "\n" + re);
        }
    }

    private static void checkCallerIsSystemOrPhoneApp() {
        int uid = Binder.getCallingUid();
        int appId = UserHandle.getAppId(uid);
        if (appId == 1000 || appId == 1001 || uid == 0) {
            return;
        }
        throw new SecurityException("Disallowed call for uid " + uid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeExpiredTimestamps() {
        long beginCheckPeriod = System.currentTimeMillis() - (long)this.mCheckPeriod;
        HashMap<String, ArrayList<Long>> hashMap = this.mSmsStamp;
        synchronized (hashMap) {
            Iterator<Map.Entry<String, ArrayList<Long>>> iter = this.mSmsStamp.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<String, ArrayList<Long>> entry = iter.next();
                ArrayList<Long> oldList = entry.getValue();
                if (!oldList.isEmpty() && oldList.get(oldList.size() - 1) >= beginCheckPeriod) continue;
                iter.remove();
            }
        }
    }

    private boolean isUnderLimit(ArrayList<Long> sent, int smsWaiting) {
        Long ct = System.currentTimeMillis();
        long beginCheckPeriod = ct - (long)this.mCheckPeriod;
        while (!sent.isEmpty() && sent.get(0) < beginCheckPeriod) {
            sent.remove(0);
        }
        if (sent.size() + smsWaiting <= this.mMaxAllowed) {
            for (int i = 0; i < smsWaiting; ++i) {
                sent.add(ct);
            }
            return true;
        }
        return false;
    }

    private static void log(String msg) {
        Rlog.d(TAG, msg);
    }

    private static class SettingsObserverHandler
    extends Handler {
        SettingsObserverHandler(Context context, AtomicBoolean enabled) {
            ContentResolver resolver = context.getContentResolver();
            SettingsObserver globalObserver = new SettingsObserver(this, context, enabled);
            resolver.registerContentObserver(Settings.Global.getUriFor("sms_short_code_confirmation"), false, globalObserver);
        }
    }

    private static class SettingsObserver
    extends ContentObserver {
        private final Context mContext;
        private final AtomicBoolean mEnabled;

        SettingsObserver(Handler handler, Context context, AtomicBoolean enabled) {
            super(handler);
            this.mContext = context;
            this.mEnabled = enabled;
            this.onChange(false);
        }

        @Override
        public void onChange(boolean selfChange) {
            this.mEnabled.set(Settings.Global.getInt(this.mContext.getContentResolver(), "sms_short_code_confirmation", 1) != 0);
        }
    }

    private static final class ShortCodePatternMatcher {
        private final Pattern mShortCodePattern;
        private final Pattern mPremiumShortCodePattern;
        private final Pattern mFreeShortCodePattern;
        private final Pattern mStandardShortCodePattern;

        ShortCodePatternMatcher(String shortCodeRegex, String premiumShortCodeRegex, String freeShortCodeRegex, String standardShortCodeRegex) {
            this.mShortCodePattern = shortCodeRegex != null ? Pattern.compile(shortCodeRegex) : null;
            this.mPremiumShortCodePattern = premiumShortCodeRegex != null ? Pattern.compile(premiumShortCodeRegex) : null;
            this.mFreeShortCodePattern = freeShortCodeRegex != null ? Pattern.compile(freeShortCodeRegex) : null;
            this.mStandardShortCodePattern = standardShortCodeRegex != null ? Pattern.compile(standardShortCodeRegex) : null;
        }

        int getNumberCategory(String phoneNumber) {
            if (this.mFreeShortCodePattern != null && this.mFreeShortCodePattern.matcher(phoneNumber).matches()) {
                return 1;
            }
            if (this.mStandardShortCodePattern != null && this.mStandardShortCodePattern.matcher(phoneNumber).matches()) {
                return 2;
            }
            if (this.mPremiumShortCodePattern != null && this.mPremiumShortCodePattern.matcher(phoneNumber).matches()) {
                return 4;
            }
            if (this.mShortCodePattern != null && this.mShortCodePattern.matcher(phoneNumber).matches()) {
                return 3;
            }
            return 0;
        }
    }
}

