/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.Process;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.provider.Settings;
import android.telephony.Rlog;
import android.telephony.SubInfoRecord;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.text.format.Time;
import android.util.Log;
import com.android.internal.telephony.CallManager;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.ISub;
import com.android.internal.telephony.MccTable;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneProxy;
import com.android.internal.telephony.uicc.SpnOverride;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class SubscriptionController
extends ISub.Stub {
    static final String LOG_TAG = "SubController";
    static final boolean DBG = true;
    static final boolean VDBG = false;
    static final int MAX_LOCAL_LOG_LINES = 500;
    private ScLocalLog mLocalLog = new ScLocalLog(500);
    protected final Object mLock = new Object();
    protected boolean mSuccess;
    private static SubscriptionController sInstance = null;
    protected static PhoneProxy[] sProxyPhones;
    protected Context mContext;
    protected CallManager mCM;
    private static final int RES_TYPE_BACKGROUND_DARK = 0;
    private static final int RES_TYPE_BACKGROUND_LIGHT = 1;
    private static final int[] sSimBackgroundDarkRes;
    private static final int[] sSimBackgroundLightRes;
    private static HashMap<Integer, Long> mSimInfo;
    private static long mDefaultVoiceSubId;
    private static int mDefaultPhoneId;
    private static final int EVENT_WRITE_MSISDN_DONE = 1;
    protected Handler mHandler = new Handler(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    Object object = SubscriptionController.this.mLock;
                    synchronized (object) {
                        SubscriptionController.this.mSuccess = ar.exception == null;
                        SubscriptionController.this.logd("EVENT_WRITE_MSISDN_DONE, mSuccess = " + SubscriptionController.this.mSuccess);
                        SubscriptionController.this.mLock.notifyAll();
                        break;
                    }
                }
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SubscriptionController init(Phone phone) {
        Class<SubscriptionController> clazz = SubscriptionController.class;
        synchronized (SubscriptionController.class) {
            if (sInstance == null) {
                sInstance = new SubscriptionController(phone);
            } else {
                Log.wtf(LOG_TAG, "init() called multiple times!  sInstance = " + sInstance);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SubscriptionController init(Context c, CommandsInterface[] ci) {
        Class<SubscriptionController> clazz = SubscriptionController.class;
        synchronized (SubscriptionController.class) {
            if (sInstance == null) {
                sInstance = new SubscriptionController(c);
            } else {
                Log.wtf(LOG_TAG, "init() called multiple times!  sInstance = " + sInstance);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return sInstance;
        }
    }

    public static SubscriptionController getInstance() {
        if (sInstance == null) {
            Log.wtf(LOG_TAG, "getInstance null");
        }
        return sInstance;
    }

    private SubscriptionController(Context c) {
        this.mContext = c;
        this.mCM = CallManager.getInstance();
        if (ServiceManager.getService("isub") == null) {
            ServiceManager.addService("isub", this);
        }
        this.logdl("[SubscriptionController] init by Context");
    }

    private boolean isSubInfoReady() {
        return mSimInfo.size() > 0;
    }

    private SubscriptionController(Phone phone) {
        this.mContext = phone.getContext();
        this.mCM = CallManager.getInstance();
        if (ServiceManager.getService("isub") == null) {
            ServiceManager.addService("isub", this);
        }
        this.logdl("[SubscriptionController] init by Phone");
    }

    private void enforceSubscriptionPermission() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.READ_PHONE_STATE", "Requires READ_PHONE_STATE");
    }

    private void broadcastSimInfoContentChanged(long subId, String columnName, int intContent, String stringContent) {
        Intent intent = new Intent("android.intent.action.ACTION_SUBINFO_CONTENT_CHANGE");
        intent.putExtra("_id", subId);
        intent.putExtra("columnName", columnName);
        intent.putExtra("intContent", intContent);
        intent.putExtra("stringContent", stringContent);
        if (intContent != -100) {
            this.logd("[broadcastSimInfoContentChanged] subId" + subId + " changed, " + columnName + " -> " + intContent);
        } else {
            this.logd("[broadcastSimInfoContentChanged] subId" + subId + " changed, " + columnName + " -> " + stringContent);
        }
        this.mContext.sendBroadcast(intent);
    }

    private SubInfoRecord getSubInfoRecord(Cursor cursor) {
        SubInfoRecord info = new SubInfoRecord();
        info.subId = cursor.getLong(cursor.getColumnIndexOrThrow("_id"));
        info.iccId = cursor.getString(cursor.getColumnIndexOrThrow("icc_id"));
        info.slotId = cursor.getInt(cursor.getColumnIndexOrThrow("sim_id"));
        info.displayName = cursor.getString(cursor.getColumnIndexOrThrow("display_name"));
        info.nameSource = cursor.getInt(cursor.getColumnIndexOrThrow("name_source"));
        info.color = cursor.getInt(cursor.getColumnIndexOrThrow("color"));
        info.number = cursor.getString(cursor.getColumnIndexOrThrow("number"));
        info.displayNumberFormat = cursor.getInt(cursor.getColumnIndexOrThrow("display_number_format"));
        info.dataRoaming = cursor.getInt(cursor.getColumnIndexOrThrow("data_roaming"));
        int size = sSimBackgroundDarkRes.length;
        if (info.color >= 0 && info.color < size) {
            info.simIconRes[0] = sSimBackgroundDarkRes[info.color];
            info.simIconRes[1] = sSimBackgroundLightRes[info.color];
        }
        info.mcc = cursor.getInt(cursor.getColumnIndexOrThrow("mcc"));
        info.mnc = cursor.getInt(cursor.getColumnIndexOrThrow("mnc"));
        this.logd("[getSubInfoRecord] SubId:" + info.subId + " iccid:" + info.iccId + " slotId:" + info.slotId + " displayName:" + info.displayName + " color:" + info.color + " mcc/mnc:" + info.mcc + "/" + info.mnc);
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SubInfoRecord> getSubInfo(String selection, Object queryKey) {
        this.logd("selection:" + selection + " " + queryKey);
        String[] selectionArgs = null;
        if (queryKey != null) {
            selectionArgs = new String[]{queryKey.toString()};
        }
        ArrayList<SubInfoRecord> subList = null;
        try (Cursor cursor = this.mContext.getContentResolver().query(SubscriptionManager.CONTENT_URI, null, selection, selectionArgs, null);){
            if (cursor != null) {
                while (cursor.moveToNext()) {
                    SubInfoRecord subInfo = this.getSubInfoRecord(cursor);
                    if (subInfo == null) continue;
                    if (subList == null) {
                        subList = new ArrayList<SubInfoRecord>();
                    }
                    subList.add(subInfo);
                }
            } else {
                this.logd("Query fail");
            }
        }
        return subList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SubInfoRecord getSubInfoForSubscriber(long subId) {
        this.logd("[getSubInfoForSubscriberx]+ subId:" + subId);
        this.enforceSubscriptionPermission();
        if (subId == Long.MAX_VALUE) {
            subId = this.getDefaultSubId();
        }
        if (!SubscriptionManager.isValidSubId(subId) || !this.isSubInfoReady()) {
            this.logd("[getSubInfoForSubscriberx]- invalid subId or not ready");
            return null;
        }
        try (Cursor cursor = this.mContext.getContentResolver().query(SubscriptionManager.CONTENT_URI, null, "_id=?", new String[]{Long.toString(subId)}, null);){
            if (cursor != null && cursor.moveToFirst()) {
                this.logd("[getSubInfoForSubscriberx]- Info detail:");
                SubInfoRecord subInfoRecord = this.getSubInfoRecord(cursor);
                return subInfoRecord;
            }
        }
        this.logd("[getSubInfoForSubscriber]- null info return");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SubInfoRecord> getSubInfoUsingIccId(String iccId) {
        this.logd("[getSubInfoUsingIccId]+ iccId:" + iccId);
        this.enforceSubscriptionPermission();
        if (iccId == null || !this.isSubInfoReady()) {
            this.logd("[getSubInfoUsingIccId]- null iccid or not ready");
            return null;
        }
        ArrayList<SubInfoRecord> subList = null;
        try (Cursor cursor = this.mContext.getContentResolver().query(SubscriptionManager.CONTENT_URI, null, "icc_id=?", new String[]{iccId}, null);){
            if (cursor != null) {
                while (cursor.moveToNext()) {
                    SubInfoRecord subInfo = this.getSubInfoRecord(cursor);
                    if (subInfo == null) continue;
                    if (subList == null) {
                        subList = new ArrayList<SubInfoRecord>();
                    }
                    subList.add(subInfo);
                }
            } else {
                this.logd("Query fail");
            }
        }
        return subList;
    }

    @Override
    public List<SubInfoRecord> getSubInfoUsingSlotId(int slotId) {
        return this.getSubInfoUsingSlotIdWithCheck(slotId, true);
    }

    @Override
    public List<SubInfoRecord> getAllSubInfoList() {
        this.logd("[getAllSubInfoList]+");
        this.enforceSubscriptionPermission();
        List<SubInfoRecord> subList = null;
        subList = this.getSubInfo(null, null);
        if (subList != null) {
            this.logd("[getAllSubInfoList]- " + subList.size() + " infos return");
        } else {
            this.logd("[getAllSubInfoList]- no info return");
        }
        return subList;
    }

    @Override
    public List<SubInfoRecord> getActiveSubInfoList() {
        this.enforceSubscriptionPermission();
        this.logdl("[getActiveSubInfoList]+");
        List<SubInfoRecord> subList = null;
        if (!this.isSubInfoReady()) {
            this.logdl("[getActiveSubInfoList] Sub Controller not ready");
            return subList;
        }
        subList = this.getSubInfo("sim_id!=-1000", null);
        if (subList != null) {
            this.logdl("[getActiveSubInfoList]- " + subList.size() + " infos return");
        } else {
            this.logdl("[getActiveSubInfoList]- no info return");
        }
        return subList;
    }

    @Override
    public int getActiveSubInfoCount() {
        this.logd("[getActiveSubInfoCount]+");
        List<SubInfoRecord> records = this.getActiveSubInfoList();
        if (records == null) {
            this.logd("[getActiveSubInfoCount] records null");
            return 0;
        }
        this.logd("[getActiveSubInfoCount]- count: " + records.size());
        return records.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getAllSubInfoCount() {
        this.logd("[getAllSubInfoCount]+");
        this.enforceSubscriptionPermission();
        try (Cursor cursor = this.mContext.getContentResolver().query(SubscriptionManager.CONTENT_URI, null, null, null, null);){
            if (cursor != null) {
                int count = cursor.getCount();
                this.logd("[getAllSubInfoCount]- " + count + " SUB(s) in DB");
                int n = count;
                return n;
            }
        }
        this.logd("[getAllSubInfoCount]- no SUB in DB");
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int addSubInfoRecord(String iccId, int slotId) {
        String nameToSet;
        long[] subIds;
        this.logdl("[addSubInfoRecord]+ iccId:" + iccId + " slotId:" + slotId);
        this.enforceSubscriptionPermission();
        if (iccId == null) {
            this.logdl("[addSubInfoRecord]- null iccId");
        }
        if ((subIds = this.getSubId(slotId)) == null || subIds.length == 0) {
            this.logdl("[addSubInfoRecord]- getSubId fail");
            return 0;
        }
        SpnOverride mSpnOverride = new SpnOverride();
        String CarrierName = TelephonyManager.getDefault().getSimOperator(subIds[0]);
        this.logdl("[addSubInfoRecord] CarrierName = " + CarrierName);
        if (mSpnOverride.containsCarrier(CarrierName)) {
            nameToSet = mSpnOverride.getSpn(CarrierName) + " 0" + Integer.toString(slotId + 1);
            this.logdl("[addSubInfoRecord] Found, name = " + nameToSet);
        } else {
            nameToSet = "SUB 0" + Integer.toString(slotId + 1);
            this.logdl("[addSubInfoRecord] Not found, name = " + nameToSet);
        }
        ContentResolver resolver = this.mContext.getContentResolver();
        try (Cursor cursor = resolver.query(SubscriptionManager.CONTENT_URI, new String[]{"_id", "sim_id", "name_source"}, "icc_id=?", new String[]{iccId}, null);){
            if (cursor == null || !cursor.moveToFirst()) {
                ContentValues value = new ContentValues();
                value.put("icc_id", iccId);
                value.put("color", slotId);
                value.put("sim_id", slotId);
                value.put("display_name", nameToSet);
                Uri uri = resolver.insert(SubscriptionManager.CONTENT_URI, value);
                this.logdl("[addSubInfoRecord]- New record created: " + uri);
            } else {
                long subId = cursor.getLong(0);
                int oldSimInfoId = cursor.getInt(1);
                int nameSource = cursor.getInt(2);
                ContentValues value = new ContentValues();
                if (slotId != oldSimInfoId) {
                    value.put("sim_id", slotId);
                }
                if (nameSource != 2) {
                    value.put("display_name", nameToSet);
                }
                if (value.size() > 0) {
                    resolver.update(SubscriptionManager.CONTENT_URI, value, "_id=" + Long.toString(subId), null);
                }
                this.logdl("[addSubInfoRecord]- Record already exist");
            }
        }
        cursor = resolver.query(SubscriptionManager.CONTENT_URI, null, "sim_id=?", new String[]{String.valueOf(slotId)}, null);
        try {
            if (cursor != null && cursor.moveToFirst()) {
                do {
                    long subId = cursor.getLong(cursor.getColumnIndexOrThrow("_id"));
                    Long currentSubId = mSimInfo.get(slotId);
                    if (currentSubId == null || !SubscriptionManager.isValidSubId(currentSubId)) {
                        mSimInfo.put(slotId, subId);
                        int simCount = TelephonyManager.getDefault().getSimCount();
                        long defaultSubId = this.getDefaultSubId();
                        this.logdl("[addSubInfoRecord] mSimInfo.size=" + mSimInfo.size() + " slotId=" + slotId + " subId=" + subId + " defaultSubId=" + defaultSubId + " simCount=" + simCount);
                        if (!SubscriptionManager.isValidSubId(defaultSubId) || simCount == 1) {
                            this.setDefaultSubId(subId);
                        }
                        if (simCount == 1) {
                            this.logdl("[addSubInfoRecord] one sim set defaults to subId=" + subId);
                            this.setDefaultDataSubId(subId);
                            this.setDefaultSmsSubId(subId);
                            this.setDefaultVoiceSubId(subId);
                        }
                    } else {
                        this.logdl("[addSubInfoRecord] currentSubId != null && currentSubId is valid, IGNORE");
                    }
                    this.logdl("[addSubInfoRecord]- hashmap(" + slotId + "," + subId + ")");
                } while (cursor.moveToNext());
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        int size = mSimInfo.size();
        this.logdl("[addSubInfoRecord]- info size=" + size);
        this.updateAllDataConnectionTrackers();
        return 1;
    }

    @Override
    public int setColor(int color2, long subId) {
        this.logd("[setColor]+ color:" + color2 + " subId:" + subId);
        this.enforceSubscriptionPermission();
        this.validateSubId(subId);
        int size = sSimBackgroundDarkRes.length;
        if (color2 < 0 || color2 >= size) {
            this.logd("[setColor]- fail");
            return -1;
        }
        ContentValues value = new ContentValues(1);
        value.put("color", color2);
        this.logd("[setColor]- color:" + color2 + " set");
        int result = this.mContext.getContentResolver().update(SubscriptionManager.CONTENT_URI, value, "_id=" + Long.toString(subId), null);
        this.broadcastSimInfoContentChanged(subId, "color", color2, "N/A");
        return result;
    }

    @Override
    public int setDisplayName(String displayName, long subId) {
        return this.setDisplayNameUsingSrc(displayName, subId, -1L);
    }

    @Override
    public int setDisplayNameUsingSrc(String displayName, long subId, long nameSource) {
        this.logd("[setDisplayName]+  displayName:" + displayName + " subId:" + subId + " nameSource:" + nameSource);
        this.enforceSubscriptionPermission();
        this.validateSubId(subId);
        String nameToSet = displayName == null ? this.mContext.getString(17039374) : displayName;
        ContentValues value = new ContentValues(1);
        value.put("display_name", nameToSet);
        if (nameSource >= 0L) {
            this.logd("Set nameSource=" + nameSource);
            value.put("name_source", nameSource);
        }
        this.logd("[setDisplayName]- mDisplayName:" + nameToSet + " set");
        int result = this.mContext.getContentResolver().update(SubscriptionManager.CONTENT_URI, value, "_id=" + Long.toString(subId), null);
        this.broadcastSimInfoContentChanged(subId, "display_name", -100, nameToSet);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setDisplayNumber(String number, long subId) {
        this.logd("[setDisplayNumber]+ number:" + number + " subId:" + subId);
        this.enforceSubscriptionPermission();
        this.validateSubId(subId);
        int result = 0;
        int phoneId = this.getPhoneId(subId);
        if (number == null || phoneId < 0 || phoneId >= TelephonyManager.getDefault().getPhoneCount()) {
            this.logd("[setDispalyNumber]- fail");
            return -1;
        }
        ContentValues value = new ContentValues(1);
        value.put("number", number);
        this.logd("[setDisplayNumber]- number:" + number + " set");
        PhoneProxy phone = sProxyPhones[phoneId];
        String alphaTag = TelephonyManager.getDefault().getLine1AlphaTagForSubscriber(subId);
        Object object = this.mLock;
        synchronized (object) {
            this.mSuccess = false;
            Message response = this.mHandler.obtainMessage(1);
            phone.setLine1Number(alphaTag, number, response);
            try {
                this.mLock.wait();
            }
            catch (InterruptedException e) {
                this.loge("interrupted while trying to write MSISDN");
            }
        }
        if (this.mSuccess) {
            result = this.mContext.getContentResolver().update(SubscriptionManager.CONTENT_URI, value, "_id=" + Long.toString(subId), null);
            this.logd("[setDisplayNumber]- update result :" + result);
            this.broadcastSimInfoContentChanged(subId, "number", -100, number);
        }
        return result;
    }

    @Override
    public int setDisplayNumberFormat(int format, long subId) {
        this.logd("[setDisplayNumberFormat]+ format:" + format + " subId:" + subId);
        this.enforceSubscriptionPermission();
        this.validateSubId(subId);
        if (format < 0) {
            this.logd("[setDisplayNumberFormat]- fail, return -1");
            return -1;
        }
        ContentValues value = new ContentValues(1);
        value.put("display_number_format", format);
        this.logd("[setDisplayNumberFormat]- format:" + format + " set");
        int result = this.mContext.getContentResolver().update(SubscriptionManager.CONTENT_URI, value, "_id=" + Long.toString(subId), null);
        this.broadcastSimInfoContentChanged(subId, "display_number_format", format, "N/A");
        return result;
    }

    @Override
    public int setDataRoaming(int roaming, long subId) {
        this.logd("[setDataRoaming]+ roaming:" + roaming + " subId:" + subId);
        this.enforceSubscriptionPermission();
        this.validateSubId(subId);
        if (roaming < 0) {
            this.logd("[setDataRoaming]- fail");
            return -1;
        }
        ContentValues value = new ContentValues(1);
        value.put("data_roaming", roaming);
        this.logd("[setDataRoaming]- roaming:" + roaming + " set");
        int result = this.mContext.getContentResolver().update(SubscriptionManager.CONTENT_URI, value, "_id=" + Long.toString(subId), null);
        this.broadcastSimInfoContentChanged(subId, "data_roaming", roaming, "N/A");
        return result;
    }

    public int setMccMnc(String mccMnc, long subId) {
        int mcc = 0;
        int mnc = 0;
        try {
            mcc = Integer.parseInt(mccMnc.substring(0, 3));
            mnc = Integer.parseInt(mccMnc.substring(3));
        }
        catch (NumberFormatException e) {
            this.logd("[setMccMnc] - couldn't parse mcc/mnc: " + mccMnc);
        }
        this.logd("[setMccMnc]+ mcc/mnc:" + mcc + "/" + mnc + " subId:" + subId);
        ContentValues value = new ContentValues(2);
        value.put("mcc", mcc);
        value.put("mnc", mnc);
        int result = this.mContext.getContentResolver().update(SubscriptionManager.CONTENT_URI, value, "_id=" + Long.toString(subId), null);
        this.broadcastSimInfoContentChanged(subId, "mcc", mcc, null);
        return result;
    }

    @Override
    public int getSlotId(long subId) {
        if (subId == Long.MAX_VALUE) {
            subId = this.getDefaultSubId();
        }
        if (!SubscriptionManager.isValidSubId(subId)) {
            this.logd("[getSlotId]- subId invalid");
            return -1000;
        }
        int size = mSimInfo.size();
        if (size == 0) {
            this.logd("[getSlotId]- size == 0, return SIM_NOT_INSERTED instead");
            return -1;
        }
        for (Map.Entry<Integer, Long> entry : mSimInfo.entrySet()) {
            int sim = entry.getKey();
            long sub = entry.getValue();
            if (subId != sub) continue;
            return sim;
        }
        this.logd("[getSlotId]- return fail");
        return -1000;
    }

    @Override
    @Deprecated
    public long[] getSubId(int slotId) {
        if (slotId == Integer.MAX_VALUE) {
            this.logd("[getSubId]- default slotId");
            slotId = this.getSlotId(this.getDefaultSubId());
        }
        long[] DUMMY_VALUES = new long[]{-1 - slotId, -1 - slotId};
        if (!SubscriptionManager.isValidSlotId(slotId)) {
            this.logd("[getSubId]- invalid slotId");
            return null;
        }
        if (slotId < 0) {
            this.logd("[getSubId]- slotId < 0, return dummy instead");
            return DUMMY_VALUES;
        }
        int size = mSimInfo.size();
        if (size == 0) {
            this.logd("[getSubId]- size == 0, return dummy instead");
            return DUMMY_VALUES;
        }
        ArrayList<Long> subIds = new ArrayList<Long>();
        for (Map.Entry<Integer, Long> entry : mSimInfo.entrySet()) {
            int slot = entry.getKey();
            long sub = entry.getValue();
            if (slotId != slot) continue;
            subIds.add(sub);
        }
        int numSubIds = subIds.size();
        if (numSubIds == 0) {
            this.logd("[getSubId]- numSubIds == 0, return dummy instead");
            return DUMMY_VALUES;
        }
        long[] subIdArr = new long[numSubIds];
        for (int i = 0; i < numSubIds; ++i) {
            subIdArr[i] = (Long)subIds.get(i);
        }
        return subIdArr;
    }

    @Override
    public int getPhoneId(long subId) {
        if (subId == Long.MAX_VALUE) {
            subId = this.getDefaultSubId();
            this.logdl("[getPhoneId] asked for default subId=" + subId);
        }
        if (!SubscriptionManager.isValidSubId(subId)) {
            this.logdl("[getPhoneId]- invalid subId return=-1000");
            return -1000;
        }
        if (subId < 0L) {
            int phoneId = (int)(-1L - subId);
            return phoneId;
        }
        int size = mSimInfo.size();
        if (size == 0) {
            int phoneId = mDefaultPhoneId;
            this.logdl("[getPhoneId]- no sims, returning default phoneId=" + phoneId);
            return phoneId;
        }
        for (Map.Entry<Integer, Long> entry : mSimInfo.entrySet()) {
            int sim = entry.getKey();
            long sub = entry.getValue();
            if (subId != sub) continue;
            return sim;
        }
        int phoneId = mDefaultPhoneId;
        this.logdl("[getPhoneId]- subId=" + subId + " not found return default phoneId=" + phoneId);
        return phoneId;
    }

    @Override
    public int clearSubInfo() {
        this.enforceSubscriptionPermission();
        this.logd("[clearSubInfo]+");
        int size = mSimInfo.size();
        if (size == 0) {
            this.logdl("[clearSubInfo]- no simInfo size=" + size);
            return 0;
        }
        mSimInfo.clear();
        this.logdl("[clearSubInfo]- clear size=" + size);
        return size;
    }

    private static int[] setSimResource(int type) {
        int[] simResource = null;
        switch (type) {
            case 0: {
                simResource = new int[]{17303045, 17303047, 17303046, 17303048};
                break;
            }
            case 1: {
                simResource = new int[]{17303049, 17303051, 17303050, 17303052};
            }
        }
        return simResource;
    }

    private void logvl(String msg) {
        this.logv(msg);
        this.mLocalLog.log(msg);
    }

    private void logv(String msg) {
        Rlog.v(LOG_TAG, msg);
    }

    private void logdl(String msg) {
        this.logd(msg);
        this.mLocalLog.log(msg);
    }

    private static void slogd(String msg) {
        Rlog.d(LOG_TAG, msg);
    }

    private void logd(String msg) {
        Rlog.d(LOG_TAG, msg);
    }

    private void logel(String msg) {
        this.loge(msg);
        this.mLocalLog.log(msg);
    }

    private void loge(String msg) {
        Rlog.e(LOG_TAG, msg);
    }

    @Override
    @Deprecated
    public long getDefaultSubId() {
        long subId = mDefaultVoiceSubId;
        return subId;
    }

    @Override
    public void setDefaultSmsSubId(long subId) {
        if (subId == Long.MAX_VALUE) {
            throw new RuntimeException("setDefaultSmsSubId called with DEFAULT_SUB_ID");
        }
        this.logdl("[setDefaultSmsSubId] subId=" + subId);
        Settings.Global.putLong(this.mContext.getContentResolver(), "multi_sim_sms", subId);
        this.broadcastDefaultSmsSubIdChanged(subId);
    }

    private void broadcastDefaultSmsSubIdChanged(long subId) {
        this.logdl("[broadcastDefaultSmsSubIdChanged] subId=" + subId);
        Intent intent = new Intent("android.intent.action.ACTION_DEFAULT_SMS_SUBSCRIPTION_CHANGED");
        intent.addFlags(0x20000000);
        intent.putExtra("subscription", subId);
        this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
    }

    @Override
    public long getDefaultSmsSubId() {
        long subId = Settings.Global.getLong(this.mContext.getContentResolver(), "multi_sim_sms", -1000L);
        return subId;
    }

    @Override
    public void setDefaultVoiceSubId(long subId) {
        if (subId == Long.MAX_VALUE) {
            throw new RuntimeException("setDefaultVoiceSubId called with DEFAULT_SUB_ID");
        }
        this.logdl("[setDefaultVoiceSubId] subId=" + subId);
        Settings.Global.putLong(this.mContext.getContentResolver(), "multi_sim_voice_call", subId);
        this.broadcastDefaultVoiceSubIdChanged(subId);
    }

    private void broadcastDefaultVoiceSubIdChanged(long subId) {
        this.logdl("[broadcastDefaultVoiceSubIdChanged] subId=" + subId);
        Intent intent = new Intent("android.intent.action.ACTION_DEFAULT_VOICE_SUBSCRIPTION_CHANGED");
        intent.addFlags(0x20000000);
        intent.putExtra("subscription", subId);
        this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
    }

    @Override
    public long getDefaultVoiceSubId() {
        long subId = Settings.Global.getLong(this.mContext.getContentResolver(), "multi_sim_voice_call", -1000L);
        return subId;
    }

    @Override
    public long getDefaultDataSubId() {
        long subId = Settings.Global.getLong(this.mContext.getContentResolver(), "multi_sim_data_call", -1000L);
        return subId;
    }

    @Override
    public void setDefaultDataSubId(long subId) {
        if (subId == Long.MAX_VALUE) {
            throw new RuntimeException("setDefaultDataSubId called with DEFAULT_SUB_ID");
        }
        this.logdl("[setDefaultDataSubId] subId=" + subId);
        Settings.Global.putLong(this.mContext.getContentResolver(), "multi_sim_data_call", subId);
        this.broadcastDefaultDataSubIdChanged(subId);
        this.updateAllDataConnectionTrackers();
    }

    private void updateAllDataConnectionTrackers() {
        int len = sProxyPhones.length;
        this.logdl("[updateAllDataConnectionTrackers] sProxyPhones.length=" + len);
        for (int phoneId = 0; phoneId < len; ++phoneId) {
            this.logdl("[updateAllDataConnectionTrackers] phoneId=" + phoneId);
            sProxyPhones[phoneId].updateDataConnectionTracker();
        }
    }

    private void broadcastDefaultDataSubIdChanged(long subId) {
        this.logdl("[broadcastDefaultDataSubIdChanged] subId=" + subId);
        Intent intent = new Intent("android.intent.action.ACTION_DEFAULT_DATA_SUBSCRIPTION_CHANGED");
        intent.addFlags(0x20000000);
        intent.putExtra("subscription", subId);
        this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
    }

    public void setDefaultSubId(long subId) {
        int phoneId;
        if (subId == Long.MAX_VALUE) {
            throw new RuntimeException("setDefaultSubId called with DEFAULT_SUB_ID");
        }
        this.logdl("[setDefaultSubId] subId=" + subId);
        if (SubscriptionManager.isValidSubId(subId) && (phoneId = this.getPhoneId(subId)) >= 0 && (phoneId < TelephonyManager.getDefault().getPhoneCount() || TelephonyManager.getDefault().getSimCount() == 1)) {
            this.logdl("[setDefaultSubId] set mDefaultVoiceSubId=" + subId);
            mDefaultVoiceSubId = subId;
            String defaultMccMnc = TelephonyManager.getDefault().getSimOperator(phoneId);
            MccTable.updateMccMncConfiguration(this.mContext, defaultMccMnc, false);
            Intent intent = new Intent("android.intent.action.ACTION_DEFAULT_SUBSCRIPTION_CHANGED");
            intent.addFlags(0x20000000);
            SubscriptionManager.putPhoneIdAndSubIdExtra(intent, phoneId, subId);
            this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
        }
    }

    @Override
    public void clearDefaultsForInactiveSubIds() {
        List<SubInfoRecord> records = this.getActiveSubInfoList();
        this.logdl("[clearDefaultsForInactiveSubIds] records: " + records);
        if (this.shouldDefaultBeCleared(records, this.getDefaultDataSubId())) {
            this.logd("[clearDefaultsForInactiveSubIds] clearing default data sub id");
            this.setDefaultDataSubId(-1000L);
        }
        if (this.shouldDefaultBeCleared(records, this.getDefaultSmsSubId())) {
            this.logdl("[clearDefaultsForInactiveSubIds] clearing default sms sub id");
            this.setDefaultSmsSubId(-1000L);
        }
        if (this.shouldDefaultBeCleared(records, this.getDefaultVoiceSubId())) {
            this.logdl("[clearDefaultsForInactiveSubIds] clearing default voice sub id");
            this.setDefaultVoiceSubId(-1000L);
        }
    }

    private boolean shouldDefaultBeCleared(List<SubInfoRecord> records, long subId) {
        this.logdl("[shouldDefaultBeCleared: subId] " + subId);
        if (records == null) {
            this.logdl("[shouldDefaultBeCleared] return true no records subId=" + subId);
            return true;
        }
        if (subId == -1001L && records.size() > 1) {
            this.logdl("[shouldDefaultBeCleared] return false only one subId, subId=" + subId);
            return false;
        }
        for (SubInfoRecord record : records) {
            this.logdl("[shouldDefaultBeCleared] Record.subId: " + record.subId);
            if (record.subId != subId) continue;
            this.logdl("[shouldDefaultBeCleared] return false subId is active, subId=" + subId);
            return false;
        }
        this.logdl("[shouldDefaultBeCleared] return true not active subId=" + subId);
        return true;
    }

    public long getSubIdUsingPhoneId(int phoneId) {
        long[] subIds = this.getSubId(phoneId);
        if (subIds == null || subIds.length == 0) {
            return -1000L;
        }
        return subIds[0];
    }

    public long[] getSubIdUsingSlotId(int slotId) {
        return this.getSubId(slotId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SubInfoRecord> getSubInfoUsingSlotIdWithCheck(int slotId, boolean needCheck) {
        this.logd("[getSubInfoUsingSlotIdWithCheck]+ slotId:" + slotId);
        this.enforceSubscriptionPermission();
        if (slotId == Integer.MAX_VALUE) {
            slotId = this.getSlotId(this.getDefaultSubId());
        }
        if (!SubscriptionManager.isValidSlotId(slotId)) {
            this.logd("[getSubInfoUsingSlotIdWithCheck]- invalid slotId");
            return null;
        }
        if (needCheck && !this.isSubInfoReady()) {
            this.logd("[getSubInfoUsingSlotIdWithCheck]- not ready");
            return null;
        }
        ArrayList<SubInfoRecord> subList = null;
        try (Cursor cursor = this.mContext.getContentResolver().query(SubscriptionManager.CONTENT_URI, null, "sim_id=?", new String[]{String.valueOf(slotId)}, null);){
            if (cursor != null) {
                while (cursor.moveToNext()) {
                    SubInfoRecord subInfo = this.getSubInfoRecord(cursor);
                    if (subInfo == null) continue;
                    if (subList == null) {
                        subList = new ArrayList<SubInfoRecord>();
                    }
                    subList.add(subInfo);
                }
            }
        }
        this.logd("[getSubInfoUsingSlotId]- null info return");
        return subList;
    }

    private void validateSubId(long subId) {
        this.logd("validateSubId subId: " + subId);
        if (!SubscriptionManager.isValidSubId(subId)) {
            throw new RuntimeException("Invalid sub id passed as parameter");
        }
        if (subId == Long.MAX_VALUE) {
            throw new RuntimeException("Default sub id passed as parameter");
        }
    }

    public void updatePhonesAvailability(PhoneProxy[] phones) {
        sProxyPhones = phones;
    }

    @Override
    public long[] getActiveSubIdList() {
        Set<Map.Entry<Integer, Long>> simInfoSet = mSimInfo.entrySet();
        this.logdl("[getActiveSubIdList] simInfoSet=" + simInfoSet);
        long[] subIdArr = new long[simInfoSet.size()];
        int i = 0;
        for (Map.Entry<Integer, Long> entry : simInfoSet) {
            long sub;
            subIdArr[i] = sub = entry.getValue().longValue();
            ++i;
        }
        this.logdl("[getActiveSubIdList] X subIdArr.length=" + subIdArr.length);
        return subIdArr;
    }

    private static void printStackTrace(String msg) {
        RuntimeException re = new RuntimeException();
        SubscriptionController.slogd("StackTrace - " + msg);
        StackTraceElement[] st = re.getStackTrace();
        boolean first = true;
        for (StackTraceElement ste : st) {
            if (first) {
                first = false;
                continue;
            }
            SubscriptionController.slogd(ste.toString());
        }
    }

    @Override
    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DUMP", "Requires DUMP");
        pw.println("SubscriptionController:");
        pw.println(" defaultSubId=" + this.getDefaultSubId());
        pw.println(" defaultDataSubId=" + this.getDefaultDataSubId());
        pw.println(" defaultVoiceSubId=" + this.getDefaultVoiceSubId());
        pw.println(" defaultSmsSubId=" + this.getDefaultSmsSubId());
        pw.println(" defaultDataPhoneId=" + SubscriptionManager.getDefaultDataPhoneId());
        pw.println(" defaultVoicePhoneId=" + SubscriptionManager.getDefaultVoicePhoneId());
        pw.println(" defaultSmsPhoneId=" + SubscriptionManager.getDefaultSmsPhoneId());
        pw.flush();
        for (Map.Entry<Integer, Long> entry : mSimInfo.entrySet()) {
            pw.println(" mSimInfo[" + entry.getKey() + "]: subId=" + entry.getValue());
        }
        pw.flush();
        pw.println("++++++++++++++++++++++++++++++++");
        List<SubInfoRecord> sirl = this.getActiveSubInfoList();
        if (sirl != null) {
            pw.println(" ActiveSubInfoList:");
            for (SubInfoRecord entry : sirl) {
                pw.println("  " + entry.toString());
            }
        } else {
            pw.println(" ActiveSubInfoList: is null");
        }
        pw.flush();
        pw.println("++++++++++++++++++++++++++++++++");
        sirl = this.getAllSubInfoList();
        if (sirl != null) {
            pw.println(" AllSubInfoList:");
            for (SubInfoRecord entry : sirl) {
                pw.println("  " + entry.toString());
            }
        } else {
            pw.println(" AllSubInfoList: is null");
        }
        pw.flush();
        pw.println("++++++++++++++++++++++++++++++++");
        this.mLocalLog.dump(fd, pw, args);
        pw.flush();
        pw.println("++++++++++++++++++++++++++++++++");
        pw.flush();
    }

    static {
        sSimBackgroundDarkRes = SubscriptionController.setSimResource(0);
        sSimBackgroundLightRes = SubscriptionController.setSimResource(1);
        mSimInfo = new HashMap();
        mDefaultVoiceSubId = -1000L;
        mDefaultPhoneId = Integer.MAX_VALUE;
    }

    static class ScLocalLog {
        private LinkedList<String> mLog = new LinkedList();
        private int mMaxLines;
        private Time mNow;

        public ScLocalLog(int maxLines) {
            this.mMaxLines = maxLines;
            this.mNow = new Time();
        }

        public synchronized void log(String msg) {
            if (this.mMaxLines > 0) {
                int pid = Process.myPid();
                int tid = Process.myTid();
                this.mNow.setToNow();
                this.mLog.add(this.mNow.format("%m-%d %H:%M:%S") + " pid=" + pid + " tid=" + tid + " " + msg);
                while (this.mLog.size() > this.mMaxLines) {
                    this.mLog.remove();
                }
            }
        }

        public synchronized void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            int LOOPS_PER_FLUSH = 10;
            ListIterator<String> itr = this.mLog.listIterator(0);
            int i = 0;
            while (itr.hasNext()) {
                pw.println(Integer.toString(i++) + ": " + (String)itr.next());
                if (i % 10 != 0) continue;
                pw.flush();
            }
        }
    }
}

