/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cat;

import com.android.internal.telephony.cat.CatException;
import com.android.internal.telephony.cat.ResultCode;

public class ResultException
extends CatException {
    private ResultCode mResult;
    private int mAdditionalInfo;
    private String mExplanation;

    public ResultException(ResultCode result) {
        switch (result) {
            case TERMINAL_CRNTLY_UNABLE_TO_PROCESS: 
            case NETWORK_CRNTLY_UNABLE_TO_PROCESS: 
            case LAUNCH_BROWSER_ERROR: 
            case MULTI_CARDS_CMD_ERROR: 
            case USIM_CALL_CONTROL_PERMANENT: 
            case BIP_ERROR: 
            case FRAMES_ERROR: 
            case MMS_ERROR: {
                throw new AssertionError((Object)("For result code, " + (Object)((Object)result) + ", additional information must be given!"));
            }
        }
        this.mResult = result;
        this.mAdditionalInfo = -1;
        this.mExplanation = "";
    }

    public ResultException(ResultCode result, String explanation) {
        this(result);
        this.mExplanation = explanation;
    }

    public ResultException(ResultCode result, int additionalInfo) {
        this(result);
        if (additionalInfo < 0) {
            throw new AssertionError((Object)"Additional info must be greater than zero!");
        }
        this.mAdditionalInfo = additionalInfo;
    }

    public ResultException(ResultCode result, int additionalInfo, String explanation) {
        this(result, additionalInfo);
        this.mExplanation = explanation;
    }

    public ResultCode result() {
        return this.mResult;
    }

    public boolean hasAdditionalInfo() {
        return this.mAdditionalInfo >= 0;
    }

    public int additionalInfo() {
        return this.mAdditionalInfo;
    }

    public String explanation() {
        return this.mExplanation;
    }

    @Override
    public String toString() {
        return "result=" + (Object)((Object)this.mResult) + " additionalInfo=" + this.mAdditionalInfo + " explantion=" + this.mExplanation;
    }
}

