/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma;

import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.Registrant;
import android.os.RegistrantList;
import android.os.SystemProperties;
import android.telephony.PhoneNumberUtils;
import android.telephony.Rlog;
import android.text.TextUtils;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.CallTracker;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.DriverCall;
import com.android.internal.telephony.PhoneBase;
import com.android.internal.telephony.PhoneConstants;
import com.android.internal.telephony.cdma.CDMAPhone;
import com.android.internal.telephony.cdma.CdmaCall;
import com.android.internal.telephony.cdma.CdmaCallWaitingNotification;
import com.android.internal.telephony.cdma.CdmaConnection;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;

public final class CdmaCallTracker
extends CallTracker {
    static final String LOG_TAG = "CdmaCallTracker";
    private static final boolean REPEAT_POLLING = false;
    private static final boolean DBG_POLL = false;
    static final int MAX_CONNECTIONS = 8;
    static final int MAX_CONNECTIONS_PER_CALL = 1;
    CdmaConnection[] mConnections = new CdmaConnection[8];
    RegistrantList mVoiceCallEndedRegistrants = new RegistrantList();
    RegistrantList mVoiceCallStartedRegistrants = new RegistrantList();
    RegistrantList mCallWaitingRegistrants = new RegistrantList();
    ArrayList<CdmaConnection> mDroppedDuringPoll = new ArrayList(8);
    CdmaCall mRingingCall = new CdmaCall(this);
    CdmaCall mForegroundCall = new CdmaCall(this);
    CdmaCall mBackgroundCall = new CdmaCall(this);
    CdmaConnection mPendingMO;
    boolean mHangupPendingMO;
    boolean mPendingCallInEcm = false;
    boolean mIsInEmergencyCall = false;
    CDMAPhone mPhone;
    boolean mDesiredMute = false;
    int mPendingCallClirMode;
    PhoneConstants.State mState = PhoneConstants.State.IDLE;
    private boolean mIsEcmTimerCanceled = false;
    private int m3WayCallFlashDelay = 0;

    CdmaCallTracker(CDMAPhone phone) {
        this.mPhone = phone;
        this.mCi = phone.mCi;
        this.mCi.registerForCallStateChanged(this, 2, null);
        this.mCi.registerForOn(this, 9, null);
        this.mCi.registerForNotAvailable(this, 10, null);
        this.mCi.registerForCallWaitingInfo(this, 15, null);
        this.mForegroundCall.setGeneric(false);
    }

    public void dispose() {
        Rlog.d(LOG_TAG, "CdmaCallTracker dispose");
        this.mCi.unregisterForLineControlInfo(this);
        this.mCi.unregisterForCallStateChanged(this);
        this.mCi.unregisterForOn(this);
        this.mCi.unregisterForNotAvailable(this);
        this.mCi.unregisterForCallWaitingInfo(this);
        this.clearDisconnected();
    }

    protected void finalize() {
        Rlog.d(LOG_TAG, "CdmaCallTracker finalized");
    }

    @Override
    public void registerForVoiceCallStarted(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mVoiceCallStartedRegistrants.add(r);
        if (this.mState != PhoneConstants.State.IDLE) {
            r.notifyRegistrant(new AsyncResult(null, null, null));
        }
    }

    @Override
    public void unregisterForVoiceCallStarted(Handler h) {
        this.mVoiceCallStartedRegistrants.remove(h);
    }

    @Override
    public void registerForVoiceCallEnded(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mVoiceCallEndedRegistrants.add(r);
    }

    @Override
    public void unregisterForVoiceCallEnded(Handler h) {
        this.mVoiceCallEndedRegistrants.remove(h);
    }

    public void registerForCallWaiting(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mCallWaitingRegistrants.add(r);
    }

    public void unregisterForCallWaiting(Handler h) {
        this.mCallWaitingRegistrants.remove(h);
    }

    Connection dial(String dialString, int clirMode) throws CallStateException {
        boolean internationalRoaming;
        this.clearDisconnected();
        if (!this.canDial()) {
            throw new CallStateException("cannot dial in current state");
        }
        String origNumber = dialString;
        String operatorIsoContry = this.mPhone.getSystemProperty("gsm.operator.iso-country", "");
        String simIsoContry = this.mPhone.getSystemProperty("gsm.sim.operator.iso-country", "");
        boolean bl = internationalRoaming = !TextUtils.isEmpty(operatorIsoContry) && !TextUtils.isEmpty(simIsoContry) && !simIsoContry.equals(operatorIsoContry);
        if (internationalRoaming) {
            if ("us".equals(simIsoContry)) {
                internationalRoaming = internationalRoaming && !"vi".equals(operatorIsoContry);
            } else if ("vi".equals(simIsoContry)) {
                boolean bl2 = internationalRoaming = internationalRoaming && !"us".equals(operatorIsoContry);
            }
        }
        if (internationalRoaming) {
            dialString = this.convertNumberIfNecessary(this.mPhone, dialString);
        }
        String inEcm = SystemProperties.get("ril.cdma.inecmmode", "false");
        boolean isPhoneInEcmMode = inEcm.equals("true");
        boolean isEmergencyCall = PhoneNumberUtils.isLocalEmergencyNumber(this.mPhone.getContext(), dialString);
        if (isPhoneInEcmMode && isEmergencyCall) {
            this.handleEcmTimer(1);
        }
        this.mForegroundCall.setGeneric(false);
        if (this.mForegroundCall.getState() == Call.State.ACTIVE) {
            return this.dialThreeWay(dialString);
        }
        this.mPendingMO = new CdmaConnection(this.mPhone.getContext(), this.checkForTestEmergencyNumber(dialString), this, this.mForegroundCall);
        this.mHangupPendingMO = false;
        if (this.mPendingMO.getAddress() == null || this.mPendingMO.getAddress().length() == 0 || this.mPendingMO.getAddress().indexOf(78) >= 0) {
            this.mPendingMO.mCause = 7;
            this.pollCallsWhenSafe();
        } else {
            this.setMute(false);
            this.disableDataCallInEmergencyCall(dialString);
            if (!isPhoneInEcmMode || isPhoneInEcmMode && isEmergencyCall) {
                this.mCi.dial(this.mPendingMO.getAddress(), clirMode, this.obtainCompleteMessage());
            } else {
                this.mPhone.exitEmergencyCallbackMode();
                this.mPhone.setOnEcbModeExitResponse(this, 14, null);
                this.mPendingCallClirMode = clirMode;
                this.mPendingCallInEcm = true;
            }
        }
        if (this.mNumberConverted) {
            this.mPendingMO.setConverted(origNumber);
            this.mNumberConverted = false;
        }
        this.updatePhoneState();
        this.mPhone.notifyPreciseCallStateChanged();
        return this.mPendingMO;
    }

    Connection dial(String dialString) throws CallStateException {
        return this.dial(dialString, 0);
    }

    private Connection dialThreeWay(String dialString) {
        if (!this.mForegroundCall.isIdle()) {
            this.disableDataCallInEmergencyCall(dialString);
            this.mPendingMO = new CdmaConnection(this.mPhone.getContext(), this.checkForTestEmergencyNumber(dialString), this, this.mForegroundCall);
            this.m3WayCallFlashDelay = this.mPhone.getContext().getResources().getInteger(17694837);
            if (this.m3WayCallFlashDelay > 0) {
                this.mCi.sendCDMAFeatureCode("", this.obtainMessage(20));
            } else {
                this.mCi.sendCDMAFeatureCode(this.mPendingMO.getAddress(), this.obtainMessage(16));
            }
            return this.mPendingMO;
        }
        return null;
    }

    void acceptCall() throws CallStateException {
        if (this.mRingingCall.getState() == Call.State.INCOMING) {
            Rlog.i("phone", "acceptCall: incoming...");
            this.setMute(false);
            this.mCi.acceptCall(this.obtainCompleteMessage());
        } else if (this.mRingingCall.getState() == Call.State.WAITING) {
            CdmaConnection cwConn = (CdmaConnection)this.mRingingCall.getLatestConnection();
            cwConn.updateParent(this.mRingingCall, this.mForegroundCall);
            cwConn.onConnectedInOrOut();
            this.updatePhoneState();
            this.switchWaitingOrHoldingAndActive();
        } else {
            throw new CallStateException("phone not ringing");
        }
    }

    void rejectCall() throws CallStateException {
        if (!this.mRingingCall.getState().isRinging()) {
            throw new CallStateException("phone not ringing");
        }
        this.mCi.rejectCall(this.obtainCompleteMessage());
    }

    void switchWaitingOrHoldingAndActive() throws CallStateException {
        if (this.mRingingCall.getState() == Call.State.INCOMING) {
            throw new CallStateException("cannot be in the incoming state");
        }
        if (this.mForegroundCall.getConnections().size() > 1) {
            this.flashAndSetGenericTrue();
        } else {
            this.mCi.sendCDMAFeatureCode("", this.obtainMessage(8));
        }
    }

    void conference() {
        this.flashAndSetGenericTrue();
    }

    void explicitCallTransfer() {
        this.mCi.explicitCallTransfer(this.obtainCompleteMessage(13));
    }

    void clearDisconnected() {
        this.internalClearDisconnected();
        this.updatePhoneState();
        this.mPhone.notifyPreciseCallStateChanged();
    }

    boolean canConference() {
        return this.mForegroundCall.getState() == Call.State.ACTIVE && this.mBackgroundCall.getState() == Call.State.HOLDING && !this.mBackgroundCall.isFull() && !this.mForegroundCall.isFull();
    }

    boolean canDial() {
        boolean ret;
        int serviceState = this.mPhone.getServiceState().getState();
        String disableCall = SystemProperties.get("ro.telephony.disable-call", "false");
        boolean bl = ret = serviceState != 3 && this.mPendingMO == null && !this.mRingingCall.isRinging() && !disableCall.equals("true") && (!this.mForegroundCall.getState().isAlive() || this.mForegroundCall.getState() == Call.State.ACTIVE || !this.mBackgroundCall.getState().isAlive());
        if (!ret) {
            this.log(String.format("canDial is false\n((serviceState=%d) != ServiceState.STATE_POWER_OFF)::=%s\n&& pendingMO == null::=%s\n&& !ringingCall.isRinging()::=%s\n&& !disableCall.equals(\"true\")::=%s\n&& (!foregroundCall.getState().isAlive()::=%s\n   || foregroundCall.getState() == CdmaCall.State.ACTIVE::=%s\n   ||!backgroundCall.getState().isAlive())::=%s)", serviceState, serviceState != 3, this.mPendingMO == null, !this.mRingingCall.isRinging(), !disableCall.equals("true"), !this.mForegroundCall.getState().isAlive(), this.mForegroundCall.getState() == Call.State.ACTIVE, !this.mBackgroundCall.getState().isAlive()));
        }
        return ret;
    }

    boolean canTransfer() {
        Rlog.e(LOG_TAG, "canTransfer: not possible in CDMA");
        return false;
    }

    private void internalClearDisconnected() {
        this.mRingingCall.clearDisconnected();
        this.mForegroundCall.clearDisconnected();
        this.mBackgroundCall.clearDisconnected();
    }

    private Message obtainCompleteMessage() {
        return this.obtainCompleteMessage(4);
    }

    private Message obtainCompleteMessage(int what) {
        ++this.mPendingOperations;
        this.mLastRelevantPoll = null;
        this.mNeedsPoll = true;
        return this.obtainMessage(what);
    }

    private void operationComplete() {
        --this.mPendingOperations;
        if (this.mPendingOperations == 0 && this.mNeedsPoll) {
            this.mLastRelevantPoll = this.obtainMessage(1);
            this.mCi.getCurrentCalls(this.mLastRelevantPoll);
        } else if (this.mPendingOperations < 0) {
            Rlog.e(LOG_TAG, "CdmaCallTracker.pendingOperations < 0");
            this.mPendingOperations = 0;
        }
    }

    private void updatePhoneState() {
        PhoneConstants.State oldState = this.mState;
        this.mState = this.mRingingCall.isRinging() ? PhoneConstants.State.RINGING : (this.mPendingMO != null || !this.mForegroundCall.isIdle() || !this.mBackgroundCall.isIdle() ? PhoneConstants.State.OFFHOOK : PhoneConstants.State.IDLE);
        if (this.mState == PhoneConstants.State.IDLE && oldState != this.mState) {
            this.mVoiceCallEndedRegistrants.notifyRegistrants(new AsyncResult(null, null, null));
        } else if (oldState == PhoneConstants.State.IDLE && oldState != this.mState) {
            this.mVoiceCallStartedRegistrants.notifyRegistrants(new AsyncResult(null, null, null));
        }
        this.log("update phone state, old=" + (Object)((Object)oldState) + " new=" + (Object)((Object)this.mState));
        if (this.mState != oldState) {
            this.mPhone.notifyPhoneStateChanged();
        }
    }

    @Override
    protected void handlePollCalls(AsyncResult ar) {
        int i;
        ArrayList polledCalls;
        if (ar.exception == null) {
            polledCalls = (ArrayList)ar.result;
        } else if (this.isCommandExceptionRadioNotAvailable(ar.exception)) {
            polledCalls = new ArrayList();
        } else {
            this.pollCallsAfterDelay();
            return;
        }
        Connection newRinging = null;
        CdmaConnection newUnknown = null;
        boolean hasNonHangupStateChanged = false;
        boolean hasAnyCallDisconnected = false;
        boolean needsPollDelay = false;
        boolean unknownConnectionAppeared = false;
        int curDC = 0;
        int dcSize = polledCalls.size();
        for (i = 0; i < this.mConnections.length; ++i) {
            CdmaConnection conn = this.mConnections[i];
            DriverCall dc = null;
            if (curDC < dcSize) {
                dc = (DriverCall)polledCalls.get(curDC);
                if (dc.index == i + 1) {
                    ++curDC;
                } else {
                    dc = null;
                }
            }
            if (conn == null && dc != null) {
                if (this.mPendingMO != null && this.mPendingMO.compareTo(dc)) {
                    this.mConnections[i] = this.mPendingMO;
                    this.mPendingMO.mIndex = i;
                    this.mPendingMO.update(dc);
                    this.mPendingMO = null;
                    if (this.mHangupPendingMO) {
                        this.mHangupPendingMO = false;
                        if (this.mIsEcmTimerCanceled) {
                            this.handleEcmTimer(0);
                        }
                        try {
                            this.log("poll: hangupPendingMO, hangup conn " + i);
                            this.hangup(this.mConnections[i]);
                        }
                        catch (CallStateException ex) {
                            Rlog.e(LOG_TAG, "unexpected error on hangup");
                        }
                        return;
                    }
                } else {
                    this.log("pendingMo=" + this.mPendingMO + ", dc=" + dc);
                    this.mConnections[i] = new CdmaConnection(this.mPhone.getContext(), dc, this, i);
                    if (this.mHandoverConnection != null) {
                        this.mPhone.migrateFrom((PhoneBase)this.mPhone.getImsPhone());
                        this.mConnections[i].migrateFrom(this.mHandoverConnection);
                        this.mPhone.notifyHandoverStateChanged(this.mConnections[i]);
                        this.mHandoverConnection = null;
                    } else {
                        newRinging = this.checkMtFindNewRinging(dc, i);
                        if (newRinging == null) {
                            unknownConnectionAppeared = true;
                        }
                    }
                    this.checkAndEnableDataCallAfterEmergencyCallDropped();
                }
                hasNonHangupStateChanged = true;
                continue;
            }
            if (conn != null && dc == null) {
                CdmaConnection cn;
                int n;
                int count = this.mForegroundCall.mConnections.size();
                for (n = 0; n < count; ++n) {
                    this.log("adding fgCall cn " + n + " to droppedDuringPoll");
                    cn = (CdmaConnection)this.mForegroundCall.mConnections.get(n);
                    this.mDroppedDuringPoll.add(cn);
                }
                count = this.mRingingCall.mConnections.size();
                for (n = 0; n < count; ++n) {
                    this.log("adding rgCall cn " + n + " to droppedDuringPoll");
                    cn = (CdmaConnection)this.mRingingCall.mConnections.get(n);
                    this.mDroppedDuringPoll.add(cn);
                }
                this.mForegroundCall.setGeneric(false);
                this.mRingingCall.setGeneric(false);
                if (this.mIsEcmTimerCanceled) {
                    this.handleEcmTimer(0);
                }
                this.checkAndEnableDataCallAfterEmergencyCallDropped();
                this.mConnections[i] = null;
                continue;
            }
            if (conn == null || dc == null) continue;
            if (conn.isIncoming() != dc.isMT) {
                if (dc.isMT) {
                    this.mDroppedDuringPoll.add(conn);
                    newRinging = this.checkMtFindNewRinging(dc, i);
                    if (newRinging == null) {
                        unknownConnectionAppeared = true;
                        newUnknown = conn;
                    }
                    this.checkAndEnableDataCallAfterEmergencyCallDropped();
                    continue;
                }
                Rlog.e(LOG_TAG, "Error in RIL, Phantom call appeared " + dc);
                continue;
            }
            boolean changed = conn.update(dc);
            hasNonHangupStateChanged = hasNonHangupStateChanged || changed;
        }
        if (this.mPendingMO != null) {
            Rlog.d(LOG_TAG, "Pending MO dropped before poll fg state:" + (Object)((Object)this.mForegroundCall.getState()));
            this.mDroppedDuringPoll.add(this.mPendingMO);
            this.mPendingMO = null;
            this.mHangupPendingMO = false;
            if (this.mPendingCallInEcm) {
                this.mPendingCallInEcm = false;
            }
        }
        if (newRinging != null) {
            this.mPhone.notifyNewRingingConnection(newRinging);
        }
        for (i = this.mDroppedDuringPoll.size() - 1; i >= 0; --i) {
            CdmaConnection conn = this.mDroppedDuringPoll.get(i);
            if (conn.isIncoming() && conn.getConnectTime() == 0L) {
                int cause = conn.mCause == 3 ? 16 : 1;
                this.log("missed/rejected call, conn.cause=" + conn.mCause);
                this.log("setting cause to " + cause);
                this.mDroppedDuringPoll.remove(i);
                hasAnyCallDisconnected |= conn.onDisconnect(cause);
                continue;
            }
            if (conn.mCause != 3 && conn.mCause != 7) continue;
            this.mDroppedDuringPoll.remove(i);
            hasAnyCallDisconnected |= conn.onDisconnect(conn.mCause);
        }
        if (this.mDroppedDuringPoll.size() > 0) {
            this.mCi.getLastCallFailCause(this.obtainNoPollCompleteMessage(5));
        }
        if (needsPollDelay) {
            this.pollCallsAfterDelay();
        }
        if (newRinging != null || hasNonHangupStateChanged || hasAnyCallDisconnected) {
            this.internalClearDisconnected();
        }
        this.updatePhoneState();
        if (unknownConnectionAppeared) {
            this.mPhone.notifyUnknownConnection(newUnknown);
        }
        if (hasNonHangupStateChanged || newRinging != null || hasAnyCallDisconnected) {
            this.mPhone.notifyPreciseCallStateChanged();
        }
    }

    void hangup(CdmaConnection conn) throws CallStateException {
        if (conn.mOwner != this) {
            throw new CallStateException("CdmaConnection " + conn + "does not belong to CdmaCallTracker " + this);
        }
        if (conn == this.mPendingMO) {
            this.log("hangup: set hangupPendingMO to true");
            this.mHangupPendingMO = true;
        } else {
            if (conn.getCall() == this.mRingingCall && this.mRingingCall.getState() == Call.State.WAITING) {
                conn.onLocalDisconnect();
                this.updatePhoneState();
                this.mPhone.notifyPreciseCallStateChanged();
                return;
            }
            try {
                this.mCi.hangupConnection(conn.getCDMAIndex(), this.obtainCompleteMessage());
            }
            catch (CallStateException ex) {
                Rlog.w(LOG_TAG, "CdmaCallTracker WARN: hangup() on absent connection " + conn);
            }
        }
        conn.onHangupLocal();
    }

    void separate(CdmaConnection conn) throws CallStateException {
        if (conn.mOwner != this) {
            throw new CallStateException("CdmaConnection " + conn + "does not belong to CdmaCallTracker " + this);
        }
        try {
            this.mCi.separateConnection(conn.getCDMAIndex(), this.obtainCompleteMessage(12));
        }
        catch (CallStateException ex) {
            Rlog.w(LOG_TAG, "CdmaCallTracker WARN: separate() on absent connection " + conn);
        }
    }

    void setMute(boolean mute) {
        this.mDesiredMute = mute;
        this.mCi.setMute(this.mDesiredMute, null);
    }

    boolean getMute() {
        return this.mDesiredMute;
    }

    void hangup(CdmaCall call) throws CallStateException {
        if (call.getConnections().size() == 0) {
            throw new CallStateException("no connections in call");
        }
        if (call == this.mRingingCall) {
            this.log("(ringing) hangup waiting or background");
            this.mCi.hangupWaitingOrBackground(this.obtainCompleteMessage());
        } else if (call == this.mForegroundCall) {
            if (call.isDialingOrAlerting()) {
                this.log("(foregnd) hangup dialing or alerting...");
                this.hangup((CdmaConnection)call.getConnections().get(0));
            } else {
                this.hangupForegroundResumeBackground();
            }
        } else if (call == this.mBackgroundCall) {
            if (this.mRingingCall.isRinging()) {
                this.log("hangup all conns in background call");
                this.hangupAllConnections(call);
            } else {
                this.hangupWaitingOrBackground();
            }
        } else {
            throw new RuntimeException("CdmaCall " + call + "does not belong to CdmaCallTracker " + this);
        }
        call.onHangupLocal();
        this.mPhone.notifyPreciseCallStateChanged();
    }

    void hangupWaitingOrBackground() {
        this.log("hangupWaitingOrBackground");
        this.mCi.hangupWaitingOrBackground(this.obtainCompleteMessage());
    }

    void hangupForegroundResumeBackground() {
        this.log("hangupForegroundResumeBackground");
        this.mCi.hangupForegroundResumeBackground(this.obtainCompleteMessage());
    }

    void hangupConnectionByIndex(CdmaCall call, int index) throws CallStateException {
        int count = call.mConnections.size();
        for (int i = 0; i < count; ++i) {
            CdmaConnection cn = (CdmaConnection)call.mConnections.get(i);
            if (cn.getCDMAIndex() != index) continue;
            this.mCi.hangupConnection(index, this.obtainCompleteMessage());
            return;
        }
        throw new CallStateException("no gsm index found");
    }

    void hangupAllConnections(CdmaCall call) {
        try {
            int count = call.mConnections.size();
            for (int i = 0; i < count; ++i) {
                CdmaConnection cn = (CdmaConnection)call.mConnections.get(i);
                this.mCi.hangupConnection(cn.getCDMAIndex(), this.obtainCompleteMessage());
            }
        }
        catch (CallStateException ex) {
            Rlog.e(LOG_TAG, "hangupConnectionByIndex caught " + ex);
        }
    }

    CdmaConnection getConnectionByIndex(CdmaCall call, int index) throws CallStateException {
        int count = call.mConnections.size();
        for (int i = 0; i < count; ++i) {
            CdmaConnection cn = (CdmaConnection)call.mConnections.get(i);
            if (cn.getCDMAIndex() != index) continue;
            return cn;
        }
        return null;
    }

    private void flashAndSetGenericTrue() {
        this.mCi.sendCDMAFeatureCode("", this.obtainMessage(8));
        this.mForegroundCall.setGeneric(true);
        this.mPhone.notifyPreciseCallStateChanged();
    }

    private void handleRadioNotAvailable() {
        this.pollCallsWhenSafe();
    }

    private void notifyCallWaitingInfo(CdmaCallWaitingNotification obj) {
        if (this.mCallWaitingRegistrants != null) {
            this.mCallWaitingRegistrants.notifyRegistrants(new AsyncResult(null, obj, null));
        }
    }

    private void handleCallWaitingInfo(CdmaCallWaitingNotification cw) {
        if (this.mForegroundCall.mConnections.size() > 1) {
            this.mForegroundCall.setGeneric(true);
        }
        this.mRingingCall.setGeneric(false);
        new CdmaConnection(this.mPhone.getContext(), cw, this, this.mRingingCall);
        this.updatePhoneState();
        this.notifyCallWaitingInfo(cw);
    }

    @Override
    public void handleMessage(Message msg) {
        if (!this.mPhone.mIsTheCurrentActivePhone) {
            Rlog.w(LOG_TAG, "Ignoring events received on inactive CdmaPhone");
            return;
        }
        switch (msg.what) {
            case 1: {
                Rlog.d(LOG_TAG, "Event EVENT_POLL_CALLS_RESULT Received");
                AsyncResult ar = (AsyncResult)msg.obj;
                if (msg != this.mLastRelevantPoll) break;
                this.mNeedsPoll = false;
                this.mLastRelevantPoll = null;
                this.handlePollCalls((AsyncResult)msg.obj);
                break;
            }
            case 4: {
                this.operationComplete();
                break;
            }
            case 8: {
                break;
            }
            case 5: {
                int causeCode;
                AsyncResult ar = (AsyncResult)msg.obj;
                this.operationComplete();
                if (ar.exception != null) {
                    causeCode = 16;
                    Rlog.i(LOG_TAG, "Exception during getLastCallFailCause, assuming normal disconnect");
                } else {
                    causeCode = ((int[])ar.result)[0];
                }
                int s = this.mDroppedDuringPoll.size();
                for (int i = 0; i < s; ++i) {
                    CdmaConnection conn = this.mDroppedDuringPoll.get(i);
                    conn.onRemoteDisconnect(causeCode);
                }
                this.updatePhoneState();
                this.mPhone.notifyPreciseCallStateChanged();
                this.mDroppedDuringPoll.clear();
                break;
            }
            case 2: 
            case 3: {
                this.pollCallsWhenSafe();
                break;
            }
            case 9: {
                this.handleRadioAvailable();
                break;
            }
            case 10: {
                this.handleRadioNotAvailable();
                break;
            }
            case 14: {
                if (this.mPendingCallInEcm) {
                    this.mCi.dial(this.mPendingMO.getAddress(), this.mPendingCallClirMode, this.obtainCompleteMessage());
                    this.mPendingCallInEcm = false;
                }
                this.mPhone.unsetOnEcbModeExitResponse(this);
                break;
            }
            case 15: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null) break;
                this.handleCallWaitingInfo((CdmaCallWaitingNotification)ar.result);
                Rlog.d(LOG_TAG, "Event EVENT_CALL_WAITING_INFO_CDMA Received");
                break;
            }
            case 16: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null) break;
                this.mPendingMO.onConnectedInOrOut();
                this.mPendingMO = null;
                break;
            }
            case 20: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception == null) {
                    this.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            if (CdmaCallTracker.this.mPendingMO != null) {
                                CdmaCallTracker.this.mCi.sendCDMAFeatureCode(CdmaCallTracker.this.mPendingMO.getAddress(), CdmaCallTracker.this.obtainMessage(16));
                            }
                        }
                    }, this.m3WayCallFlashDelay);
                    break;
                }
                this.mPendingMO = null;
                Rlog.w(LOG_TAG, "exception happened on Blank Flash for 3-way call");
                break;
            }
            default: {
                throw new RuntimeException("unexpected event not handled");
            }
        }
    }

    private void handleEcmTimer(int action) {
        this.mPhone.handleTimerInEmergencyCallbackMode(action);
        switch (action) {
            case 1: {
                this.mIsEcmTimerCanceled = true;
                break;
            }
            case 0: {
                this.mIsEcmTimerCanceled = false;
                break;
            }
            default: {
                Rlog.e(LOG_TAG, "handleEcmTimer, unsupported action " + action);
            }
        }
    }

    private void disableDataCallInEmergencyCall(String dialString) {
        if (PhoneNumberUtils.isLocalEmergencyNumber(this.mPhone.getContext(), dialString)) {
            this.log("disableDataCallInEmergencyCall");
            this.mIsInEmergencyCall = true;
            this.mPhone.mDcTracker.setInternalDataEnabled(false);
        }
    }

    private void checkAndEnableDataCallAfterEmergencyCallDropped() {
        if (this.mIsInEmergencyCall) {
            this.mIsInEmergencyCall = false;
            String inEcm = SystemProperties.get("ril.cdma.inecmmode", "false");
            this.log("checkAndEnableDataCallAfterEmergencyCallDropped,inEcm=" + inEcm);
            if (inEcm.compareTo("false") == 0) {
                this.mPhone.mDcTracker.setInternalDataEnabled(true);
            }
        }
    }

    private Connection checkMtFindNewRinging(DriverCall dc, int i) {
        CdmaConnection newRinging = null;
        if (this.mConnections[i].getCall() == this.mRingingCall) {
            newRinging = this.mConnections[i];
            this.log("Notify new ring " + dc);
        } else {
            Rlog.e(LOG_TAG, "Phantom call appeared " + dc);
            if (dc.state != DriverCall.State.ALERTING && dc.state != DriverCall.State.DIALING) {
                this.mConnections[i].onConnectedInOrOut();
                if (dc.state == DriverCall.State.HOLDING) {
                    this.mConnections[i].onStartedHolding();
                }
            }
        }
        return newRinging;
    }

    boolean isInEmergencyCall() {
        return this.mIsInEmergencyCall;
    }

    @Override
    protected void log(String msg) {
        Rlog.d(LOG_TAG, "[CdmaCallTracker] " + msg);
    }

    @Override
    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        int i;
        pw.println("GsmCallTracker extends:");
        super.dump(fd, pw, args);
        pw.println("droppedDuringPoll: length=" + this.mConnections.length);
        for (i = 0; i < this.mConnections.length; ++i) {
            pw.printf(" mConnections[%d]=%s\n", i, this.mConnections[i]);
        }
        pw.println(" mVoiceCallEndedRegistrants=" + this.mVoiceCallEndedRegistrants);
        pw.println(" mVoiceCallStartedRegistrants=" + this.mVoiceCallStartedRegistrants);
        pw.println(" mCallWaitingRegistrants=" + this.mCallWaitingRegistrants);
        pw.println("droppedDuringPoll: size=" + this.mDroppedDuringPoll.size());
        for (i = 0; i < this.mDroppedDuringPoll.size(); ++i) {
            pw.printf(" mDroppedDuringPoll[%d]=%s\n", i, this.mDroppedDuringPoll.get(i));
        }
        pw.println(" mRingingCall=" + this.mRingingCall);
        pw.println(" mForegroundCall=" + this.mForegroundCall);
        pw.println(" mBackgroundCall=" + this.mBackgroundCall);
        pw.println(" mPendingMO=" + this.mPendingMO);
        pw.println(" mHangupPendingMO=" + this.mHangupPendingMO);
        pw.println(" mPendingCallInEcm=" + this.mPendingCallInEcm);
        pw.println(" mIsInEmergencyCall=" + this.mIsInEmergencyCall);
        pw.println(" mPhone=" + this.mPhone);
        pw.println(" mDesiredMute=" + this.mDesiredMute);
        pw.println(" mPendingCallClirMode=" + this.mPendingCallClirMode);
        pw.println(" mState=" + (Object)((Object)this.mState));
        pw.println(" mIsEcmTimerCanceled=" + this.mIsEcmTimerCanceled);
    }
}

