/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma;

import android.app.PendingIntent;
import android.content.Intent;
import android.net.Uri;
import android.os.Message;
import android.os.SystemProperties;
import android.telephony.Rlog;
import com.android.internal.telephony.GsmAlphabet;
import com.android.internal.telephony.ImsSMSDispatcher;
import com.android.internal.telephony.PhoneBase;
import com.android.internal.telephony.PhoneConstants;
import com.android.internal.telephony.SMSDispatcher;
import com.android.internal.telephony.SmsApplication;
import com.android.internal.telephony.SmsHeader;
import com.android.internal.telephony.SmsUsageMonitor;
import com.android.internal.telephony.cdma.SmsMessage;
import com.android.internal.telephony.cdma.sms.UserData;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class CdmaSMSDispatcher
extends SMSDispatcher {
    private static final String TAG = "CdmaSMSDispatcher";
    private static final boolean VDBG = false;

    public CdmaSMSDispatcher(PhoneBase phone, SmsUsageMonitor usageMonitor, ImsSMSDispatcher imsSMSDispatcher) {
        super(phone, usageMonitor, imsSMSDispatcher);
        Rlog.d(TAG, "CdmaSMSDispatcher created");
    }

    @Override
    protected String getFormat() {
        return "3gpp2";
    }

    void sendStatusReportMessage(SmsMessage sms) {
        this.sendMessage(this.obtainMessage(10, sms));
    }

    @Override
    protected void handleStatusReport(Object o) {
        if (o instanceof SmsMessage) {
            this.handleCdmaStatusReport((SmsMessage)o);
        } else {
            Rlog.e(TAG, "handleStatusReport() called for object type " + o.getClass().getName());
        }
    }

    void handleCdmaStatusReport(SmsMessage sms) {
        int count = this.deliveryPendingList.size();
        for (int i = 0; i < count; ++i) {
            SMSDispatcher.SmsTracker tracker = (SMSDispatcher.SmsTracker)this.deliveryPendingList.get(i);
            if (tracker.mMessageRef != sms.mMessageRef) continue;
            this.deliveryPendingList.remove(i);
            tracker.updateSentMessageStatus(this.mContext, 0);
            PendingIntent intent = tracker.mDeliveryIntent;
            Intent fillIn = new Intent();
            fillIn.putExtra("pdu", sms.getPdu());
            fillIn.putExtra("format", this.getFormat());
            try {
                intent.send(this.mContext, -1, fillIn);
            }
            catch (PendingIntent.CanceledException ex) {}
            break;
        }
    }

    @Override
    protected void sendData(String destAddr, String scAddr, int destPort, byte[] data, PendingIntent sentIntent, PendingIntent deliveryIntent) {
        SmsMessage.SubmitPdu pdu = SmsMessage.getSubmitPdu(scAddr, destAddr, destPort, data, deliveryIntent != null);
        HashMap<String, Object> map = this.getSmsTrackerMap(destAddr, scAddr, destPort, data, pdu);
        SMSDispatcher.SmsTracker tracker = this.getSmsTracker(map, sentIntent, deliveryIntent, this.getFormat(), null, false);
        this.sendSubmitPdu(tracker);
    }

    @Override
    protected void sendText(String destAddr, String scAddr, String text, PendingIntent sentIntent, PendingIntent deliveryIntent, Uri messageUri, String callingPkg) {
        SmsMessage.SubmitPdu pdu = SmsMessage.getSubmitPdu(scAddr, destAddr, text, deliveryIntent != null, null);
        if (pdu != null) {
            if (messageUri == null) {
                if (SmsApplication.shouldWriteMessageForPackage(callingPkg, this.mContext)) {
                    messageUri = this.writeOutboxMessage(this.getSubId(), destAddr, text, deliveryIntent != null, callingPkg);
                }
            } else {
                this.moveToOutbox(this.getSubId(), messageUri, callingPkg);
            }
            HashMap<String, Object> map = this.getSmsTrackerMap(destAddr, scAddr, text, pdu);
            SMSDispatcher.SmsTracker tracker = this.getSmsTracker(map, sentIntent, deliveryIntent, this.getFormat(), messageUri, false);
            this.sendSubmitPdu(tracker);
        } else {
            Rlog.e(TAG, "CdmaSMSDispatcher.sendText(): getSubmitPdu() returned null");
        }
    }

    @Override
    protected void injectSmsPdu(byte[] pdu, String format, PendingIntent receivedIntent) {
        throw new IllegalStateException("This method must be called only on ImsSMSDispatcher");
    }

    @Override
    protected GsmAlphabet.TextEncodingDetails calculateLength(CharSequence messageBody, boolean use7bitOnly) {
        return SmsMessage.calculateLength(messageBody, use7bitOnly);
    }

    @Override
    protected void sendNewSubmitPdu(String destinationAddress, String scAddress, String message, SmsHeader smsHeader, int encoding, PendingIntent sentIntent, PendingIntent deliveryIntent, boolean lastPart, AtomicInteger unsentPartCount, AtomicBoolean anyPartFailed, Uri messageUri) {
        UserData uData = new UserData();
        uData.payloadStr = message;
        uData.userDataHeader = smsHeader;
        uData.msgEncoding = encoding == 1 ? 9 : 4;
        uData.msgEncodingSet = true;
        SmsMessage.SubmitPdu submitPdu = SmsMessage.getSubmitPdu(destinationAddress, uData, deliveryIntent != null && lastPart);
        HashMap<String, Object> map = this.getSmsTrackerMap(destinationAddress, scAddress, message, submitPdu);
        SMSDispatcher.SmsTracker tracker = this.getSmsTracker(map, sentIntent, deliveryIntent, this.getFormat(), unsentPartCount, anyPartFailed, messageUri, smsHeader, false);
        this.sendSubmitPdu(tracker);
    }

    protected void sendSubmitPdu(SMSDispatcher.SmsTracker tracker) {
        if (SystemProperties.getBoolean("ril.cdma.inecmmode", false)) {
            tracker.onFailed(this.mContext, 4, 0);
            return;
        }
        this.sendRawPdu(tracker);
    }

    @Override
    protected void sendSms(SMSDispatcher.SmsTracker tracker) {
        HashMap<String, Object> map = tracker.mData;
        byte[] pdu = (byte[])map.get("pdu");
        Rlog.d(TAG, "sendSms:  isIms()=" + this.isIms() + " mRetryCount=" + tracker.mRetryCount + " mImsRetry=" + tracker.mImsRetry + " mMessageRef=" + tracker.mMessageRef + " SS=" + this.mPhone.getServiceState().getState());
        SMSDispatcher.SMSDispatcherReceiver resultReceiver = new SMSDispatcher.SMSDispatcherReceiver(tracker);
        Intent intent = new Intent("android.provider.Telephony.SMS_SEND");
        String carrierPackage = this.getCarrierAppPackageName(intent);
        if (carrierPackage != null) {
            intent.setPackage(this.getCarrierAppPackageName(intent));
            intent.putExtra("pdu", pdu);
            intent.putExtra("format", this.getFormat());
            if (tracker.mSmsHeader != null && tracker.mSmsHeader.concatRef != null) {
                SmsHeader.ConcatRef concatRef = tracker.mSmsHeader.concatRef;
                intent.putExtra("concat.refNumber", concatRef.refNumber);
                intent.putExtra("concat.seqNumber", concatRef.seqNumber);
                intent.putExtra("concat.msgCount", concatRef.msgCount);
            }
            intent.addFlags(0x8000000);
            Rlog.d(TAG, "Sending SMS by carrier app.");
            this.mContext.sendOrderedBroadcast(intent, "android.permission.RECEIVE_SMS", 16, resultReceiver, null, 0, null, null);
        } else {
            this.sendSmsByPstn(tracker);
        }
    }

    @Override
    protected void updateSmsSendStatus(int messageRef, boolean success) {
        Rlog.e(TAG, "updateSmsSendStatus should never be called from here!");
    }

    @Override
    protected void sendSmsByPstn(SMSDispatcher.SmsTracker tracker) {
        boolean imsSmsDisabled;
        int ss = this.mPhone.getServiceState().getState();
        if (!this.isIms() && ss != 0) {
            tracker.onFailed(this.mContext, CdmaSMSDispatcher.getNotInServiceError(ss), 0);
            return;
        }
        Message reply = this.obtainMessage(2, tracker);
        byte[] pdu = (byte[])tracker.mData.get("pdu");
        int currentDataNetwork = this.mPhone.getServiceState().getDataNetworkType();
        boolean bl = imsSmsDisabled = (currentDataNetwork == 14 || currentDataNetwork == 13 && !this.mPhone.getServiceStateTracker().isConcurrentVoiceAndDataAllowed()) && this.mPhone.getServiceState().getVoiceNetworkType() == 7 && this.mPhone.getState() != PhoneConstants.State.IDLE;
        if (0 == tracker.mImsRetry && !this.isIms() || imsSmsDisabled) {
            this.mCi.sendCdmaSms(pdu, reply);
        } else {
            this.mCi.sendImsCdmaSms(pdu, tracker.mImsRetry, tracker.mMessageRef, reply);
            ++tracker.mImsRetry;
        }
    }
}

