/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma;

import android.app.AlarmManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.database.ContentObserver;
import android.os.AsyncResult;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.os.PowerManager;
import android.os.Registrant;
import android.os.RegistrantList;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.provider.Settings;
import android.telephony.CellInfo;
import android.telephony.CellInfoCdma;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import android.telephony.SignalStrength;
import android.telephony.SubscriptionManager;
import android.telephony.cdma.CdmaCellLocation;
import android.text.TextUtils;
import android.util.EventLog;
import android.util.TimeUtils;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.HbpcdUtils;
import com.android.internal.telephony.MccTable;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneFactory;
import com.android.internal.telephony.ServiceStateTracker;
import com.android.internal.telephony.cdma.CDMAPhone;
import com.android.internal.telephony.cdma.CdmaSubscriptionSourceManager;
import com.android.internal.telephony.dataconnection.DcTrackerBase;
import com.android.internal.telephony.uicc.UiccCardApplication;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class CdmaServiceStateTracker
extends ServiceStateTracker {
    static final String LOG_TAG = "CdmaSST";
    CDMAPhone mPhone;
    CdmaCellLocation mCellLoc;
    CdmaCellLocation mNewCellLoc;
    private static final String UNACTIVATED_MIN2_VALUE = "000000";
    private static final String UNACTIVATED_MIN_VALUE = "1111110111";
    private static final int MS_PER_HOUR = 3600000;
    int mCurrentOtaspMode = 0;
    private static final int NITZ_UPDATE_SPACING_DEFAULT = 600000;
    private int mNitzUpdateSpacing = SystemProperties.getInt("ro.nitz_update_spacing", 600000);
    private static final int NITZ_UPDATE_DIFF_DEFAULT = 2000;
    private int mNitzUpdateDiff = SystemProperties.getInt("ro.nitz_update_diff", 2000);
    private boolean mCdmaRoaming = false;
    private int mRoamingIndicator;
    private boolean mIsInPrl;
    private int mDefaultRoamingIndicator;
    protected int mRegistrationState = -1;
    protected RegistrantList mCdmaForSubscriptionInfoReadyRegistrants = new RegistrantList();
    protected boolean mNeedFixZone = false;
    private int mZoneOffset;
    private boolean mZoneDst;
    private long mZoneTime;
    protected boolean mGotCountryCode = false;
    String mSavedTimeZone;
    long mSavedTime;
    long mSavedAtTime;
    private PowerManager.WakeLock mWakeLock;
    private static final String WAKELOCK_TAG = "ServiceStateTracker";
    protected String mCurPlmn = null;
    protected String mMdn;
    protected int[] mHomeSystemId = null;
    protected int[] mHomeNetworkId = null;
    protected String mMin;
    protected String mPrlVersion;
    protected boolean mIsMinInfoReady = false;
    private boolean mIsEriTextLoaded = false;
    protected boolean mIsSubscriptionFromRuim = false;
    private CdmaSubscriptionSourceManager mCdmaSSM;
    protected static final String INVALID_MCC = "000";
    protected static final String DEFAULT_MNC = "00";
    protected HbpcdUtils mHbpcdUtils = null;
    private String mRegistrationDeniedReason;
    private ContentResolver mCr;
    private String mCurrentCarrier = null;
    private ContentObserver mAutoTimeObserver = new ContentObserver(new Handler()){

        @Override
        public void onChange(boolean selfChange) {
            CdmaServiceStateTracker.this.log("Auto time state changed");
            CdmaServiceStateTracker.this.revertToNitzTime();
        }
    };
    private ContentObserver mAutoTimeZoneObserver = new ContentObserver(new Handler()){

        @Override
        public void onChange(boolean selfChange) {
            CdmaServiceStateTracker.this.log("Auto time zone state changed");
            CdmaServiceStateTracker.this.revertToNitzTimeZone();
        }
    };

    public CdmaServiceStateTracker(CDMAPhone phone) {
        this(phone, new CellInfoCdma());
    }

    protected CdmaServiceStateTracker(CDMAPhone phone, CellInfo cellInfo) {
        super(phone, phone.mCi, cellInfo);
        this.mPhone = phone;
        this.mCr = phone.getContext().getContentResolver();
        this.mCellLoc = new CdmaCellLocation();
        this.mNewCellLoc = new CdmaCellLocation();
        this.mCdmaSSM = CdmaSubscriptionSourceManager.getInstance(phone.getContext(), this.mCi, this, 39, null);
        this.mIsSubscriptionFromRuim = this.mCdmaSSM.getCdmaSubscriptionSource() == 0;
        PowerManager powerManager = (PowerManager)phone.getContext().getSystemService("power");
        this.mWakeLock = powerManager.newWakeLock(1, WAKELOCK_TAG);
        this.mCi.registerForRadioStateChanged(this, 1, null);
        this.mCi.registerForVoiceNetworkStateChanged(this, 30, null);
        this.mCi.setOnNITZTime(this, 11, null);
        this.mCi.registerForCdmaPrlChanged(this, 40, null);
        phone.registerForEriFileLoaded(this, 36, null);
        this.mCi.registerForCdmaOtaProvision(this, 37, null);
        int airplaneMode = Settings.Global.getInt(this.mCr, "airplane_mode_on", 0);
        this.mDesiredPowerState = airplaneMode <= 0;
        this.mCr.registerContentObserver(Settings.Global.getUriFor("auto_time"), true, this.mAutoTimeObserver);
        this.mCr.registerContentObserver(Settings.Global.getUriFor("auto_time_zone"), true, this.mAutoTimeZoneObserver);
        this.setSignalStrengthDefaultValues();
        this.mHbpcdUtils = new HbpcdUtils(phone.getContext());
        phone.notifyOtaspChanged(0);
    }

    @Override
    public void dispose() {
        this.checkCorrectThread();
        this.log("ServiceStateTracker dispose");
        this.mCi.unregisterForRadioStateChanged(this);
        this.mCi.unregisterForVoiceNetworkStateChanged(this);
        this.mCi.unregisterForCdmaOtaProvision(this);
        this.mPhone.unregisterForEriFileLoaded(this);
        if (this.mUiccApplcation != null) {
            this.mUiccApplcation.unregisterForReady(this);
        }
        if (this.mIccRecords != null) {
            this.mIccRecords.unregisterForRecordsLoaded(this);
        }
        this.mCi.unSetOnNITZTime(this);
        this.mCr.unregisterContentObserver(this.mAutoTimeObserver);
        this.mCr.unregisterContentObserver(this.mAutoTimeZoneObserver);
        this.mCdmaSSM.dispose(this);
        this.mCi.unregisterForCdmaPrlChanged(this);
        super.dispose();
    }

    protected void finalize() {
        this.log("CdmaServiceStateTracker finalized");
    }

    public void registerForSubscriptionInfoReady(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mCdmaForSubscriptionInfoReadyRegistrants.add(r);
        if (this.isMinInfoReady()) {
            r.notifyRegistrant();
        }
    }

    public void unregisterForSubscriptionInfoReady(Handler h) {
        this.mCdmaForSubscriptionInfoReadyRegistrants.remove(h);
    }

    private void saveCdmaSubscriptionSource(int source) {
        this.log("Storing cdma subscription source: " + source);
        Settings.Global.putInt(this.mPhone.getContext().getContentResolver(), "subscription_mode", source);
    }

    private void getSubscriptionInfoAndStartPollingThreads() {
        this.mCi.getCDMASubscription(this.obtainMessage(34));
        this.pollState();
    }

    @Override
    public void handleMessage(Message msg) {
        if (!this.mPhone.mIsTheCurrentActivePhone) {
            this.loge("Received message " + msg + "[" + msg.what + "]" + " while being destroyed. Ignoring.");
            return;
        }
        switch (msg.what) {
            case 39: {
                this.handleCdmaSubscriptionSource(this.mCdmaSSM.getCdmaSubscriptionSource());
                break;
            }
            case 26: {
                int networkType = PhoneFactory.calculatePreferredNetworkType(this.mPhone.getContext());
                this.mCi.setPreferredNetworkType(networkType, null);
                if (this.mPhone.getLteOnCdmaMode() == 1) {
                    this.log("Receive EVENT_RUIM_READY");
                    this.pollState();
                } else {
                    this.log("Receive EVENT_RUIM_READY and Send Request getCDMASubscription.");
                    this.getSubscriptionInfoAndStartPollingThreads();
                }
                this.mPhone.setNetworkSelectionModeAutomatic(null);
                this.mPhone.prepareEri();
                break;
            }
            case 35: {
                this.updatePhoneObject();
                this.mPhone.setNetworkSelectionModeAutomatic(null);
                this.getSubscriptionInfoAndStartPollingThreads();
                break;
            }
            case 1: {
                if (this.mCi.getRadioState() == CommandsInterface.RadioState.RADIO_ON) {
                    this.handleCdmaSubscriptionSource(this.mCdmaSSM.getCdmaSubscriptionSource());
                    this.queueNextSignalStrengthPoll();
                }
                this.setPowerStateToDesired();
                this.pollState();
                break;
            }
            case 30: {
                this.pollState();
                break;
            }
            case 3: {
                if (!this.mCi.getRadioState().isOn()) {
                    return;
                }
                AsyncResult ar = (AsyncResult)msg.obj;
                this.onSignalStrengthResult(ar, false);
                this.queueNextSignalStrengthPoll();
                break;
            }
            case 31: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception == null) {
                    String[] states = (String[])ar.result;
                    int baseStationId = -1;
                    int baseStationLatitude = Integer.MAX_VALUE;
                    int baseStationLongitude = Integer.MAX_VALUE;
                    int systemId = -1;
                    int networkId = -1;
                    if (states.length > 9) {
                        try {
                            if (states[4] != null) {
                                baseStationId = Integer.parseInt(states[4]);
                            }
                            if (states[5] != null) {
                                baseStationLatitude = Integer.parseInt(states[5]);
                            }
                            if (states[6] != null) {
                                baseStationLongitude = Integer.parseInt(states[6]);
                            }
                            if (baseStationLatitude == 0 && baseStationLongitude == 0) {
                                baseStationLatitude = Integer.MAX_VALUE;
                                baseStationLongitude = Integer.MAX_VALUE;
                            }
                            if (states[8] != null) {
                                systemId = Integer.parseInt(states[8]);
                            }
                            if (states[9] != null) {
                                networkId = Integer.parseInt(states[9]);
                            }
                        }
                        catch (NumberFormatException ex) {
                            this.loge("error parsing cell location data: " + ex);
                        }
                    }
                    this.mCellLoc.setCellLocationData(baseStationId, baseStationLatitude, baseStationLongitude, systemId, networkId);
                    this.mPhone.notifyLocationChanged();
                }
                this.disableSingleLocationUpdate();
                break;
            }
            case 5: 
            case 24: 
            case 25: {
                AsyncResult ar = (AsyncResult)msg.obj;
                this.handlePollStateResult(msg.what, ar);
                break;
            }
            case 34: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null) break;
                String[] cdmaSubscription = (String[])ar.result;
                if (cdmaSubscription != null && cdmaSubscription.length >= 5) {
                    this.mMdn = cdmaSubscription[0];
                    this.parseSidNid(cdmaSubscription[1], cdmaSubscription[2]);
                    this.mMin = cdmaSubscription[3];
                    this.mPrlVersion = cdmaSubscription[4];
                    this.log("GET_CDMA_SUBSCRIPTION: MDN=" + this.mMdn);
                    this.mIsMinInfoReady = true;
                    this.updateOtaspState();
                    if (!this.mIsSubscriptionFromRuim && this.mIccRecords != null) {
                        this.log("GET_CDMA_SUBSCRIPTION set imsi in mIccRecords");
                        this.mIccRecords.setImsi(this.getImsi());
                        break;
                    }
                    this.log("GET_CDMA_SUBSCRIPTION either mIccRecords is null  or NV type device - not setting Imsi in mIccRecords");
                    break;
                }
                this.log("GET_CDMA_SUBSCRIPTION: error parsing cdmaSubscription params num=" + cdmaSubscription.length);
                break;
            }
            case 10: {
                this.mCi.getSignalStrength(this.obtainMessage(3));
                break;
            }
            case 11: {
                AsyncResult ar = (AsyncResult)msg.obj;
                String nitzString = (String)((Object[])ar.result)[0];
                long nitzReceiveTime = (Long)((Object[])ar.result)[1];
                this.setTimeFromNITZString(nitzString, nitzReceiveTime);
                break;
            }
            case 12: {
                AsyncResult ar = (AsyncResult)msg.obj;
                this.mDontPollSignalStrength = true;
                this.onSignalStrengthResult(ar, false);
                break;
            }
            case 27: {
                this.log("EVENT_RUIM_RECORDS_LOADED: what=" + msg.what);
                this.updatePhoneObject();
                this.updateSpnDisplay();
                break;
            }
            case 18: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null) break;
                this.mCi.getVoiceRegistrationState(this.obtainMessage(31, null));
                break;
            }
            case 36: {
                this.log("[CdmaServiceStateTracker] ERI file has been loaded, repolling.");
                this.pollState();
                break;
            }
            case 37: {
                int[] ints;
                int otaStatus;
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null || (otaStatus = (ints = (int[])ar.result)[0]) != 8 && otaStatus != 10) break;
                this.log("EVENT_OTA_PROVISION_STATUS_CHANGE: Complete, Reload MDN");
                this.mCi.getCDMASubscription(this.obtainMessage(34));
                break;
            }
            case 40: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null) break;
                int[] ints = (int[])ar.result;
                this.mPrlVersion = Integer.toString(ints[0]);
                break;
            }
            case 45: {
                this.log("EVENT_CHANGE_IMS_STATE");
                this.setPowerStateToDesired();
                break;
            }
            default: {
                super.handleMessage(msg);
            }
        }
    }

    private void handleCdmaSubscriptionSource(int newSubscriptionSource) {
        this.log("Subscription Source : " + newSubscriptionSource);
        this.mIsSubscriptionFromRuim = newSubscriptionSource == 0;
        this.saveCdmaSubscriptionSource(newSubscriptionSource);
        if (!this.mIsSubscriptionFromRuim) {
            this.sendMessage(this.obtainMessage(35));
        }
    }

    @Override
    protected void setPowerStateToDesired() {
        if (this.mDesiredPowerState && this.mCi.getRadioState() == CommandsInterface.RadioState.RADIO_OFF) {
            this.mCi.setRadioPower(true, null);
        } else if (!this.mDesiredPowerState && this.mCi.getRadioState().isOn()) {
            DcTrackerBase dcTracker = this.mPhone.mDcTracker;
            this.powerOffRadioSafely(dcTracker);
        } else if (this.mDeviceShuttingDown && this.mCi.getRadioState().isAvailable()) {
            this.mCi.requestShutdown(null);
        }
    }

    @Override
    protected void updateSpnDisplay() {
        String plmn = this.mSS.getOperatorAlphaLong();
        if (!TextUtils.equals(plmn, this.mCurPlmn)) {
            boolean showPlmn = plmn != null;
            this.log(String.format("updateSpnDisplay: changed sending intent showPlmn='%b' plmn='%s'", showPlmn, plmn));
            Intent intent = new Intent("android.provider.Telephony.SPN_STRINGS_UPDATED");
            intent.addFlags(0x20000000);
            intent.putExtra("showSpn", false);
            intent.putExtra("spn", "");
            intent.putExtra("showPlmn", showPlmn);
            intent.putExtra("plmn", plmn);
            SubscriptionManager.putPhoneIdAndSubIdExtra(intent, this.mPhone.getPhoneId());
            this.mPhone.getContext().sendStickyBroadcastAsUser(intent, UserHandle.ALL);
        }
        this.mCurPlmn = plmn;
    }

    @Override
    protected Phone getPhone() {
        return this.mPhone;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void handlePollStateResultMessage(int what, AsyncResult ar) {
        switch (what) {
            case 5: {
                String[] states = (String[])ar.result;
                this.log("handlePollStateResultMessage: EVENT_POLL_STATE_GPRS states.length=" + states.length + " states=" + states);
                int regState = 4;
                int dataRadioTechnology = 0;
                if (states.length > 0) {
                    try {
                        regState = Integer.parseInt(states[0]);
                        if (states.length >= 4 && states[3] != null) {
                            dataRadioTechnology = Integer.parseInt(states[3]);
                        }
                    }
                    catch (NumberFormatException ex) {
                        this.loge("handlePollStateResultMessage: error parsing GprsRegistrationState: " + ex);
                    }
                }
                int dataRegState = this.regCodeToServiceState(regState);
                this.mNewSS.setDataRegState(dataRegState);
                this.mNewSS.setRilDataRadioTechnology(dataRadioTechnology);
                this.log("handlPollStateResultMessage: cdma setDataRegState=" + dataRegState + " regState=" + regState + " dataRadioTechnology=" + dataRadioTechnology);
                return;
            }
            case 24: {
                String[] states = (String[])ar.result;
                int registrationState = 4;
                int radioTechnology = -1;
                int baseStationId = -1;
                int baseStationLatitude = Integer.MAX_VALUE;
                int baseStationLongitude = Integer.MAX_VALUE;
                int cssIndicator = 0;
                int systemId = 0;
                int networkId = 0;
                int roamingIndicator = -1;
                int systemIsInPrl = 0;
                int defaultRoamingIndicator = 0;
                int reasonForDenial = 0;
                if (states.length < 14) throw new RuntimeException("Warning! Wrong number of parameters returned from RIL_REQUEST_REGISTRATION_STATE: expected 14 or more strings and got " + states.length + " strings");
                try {
                    if (states[0] != null) {
                        registrationState = Integer.parseInt(states[0]);
                    }
                    if (states[3] != null) {
                        radioTechnology = Integer.parseInt(states[3]);
                    }
                    if (states[4] != null) {
                        baseStationId = Integer.parseInt(states[4]);
                    }
                    if (states[5] != null) {
                        baseStationLatitude = Integer.parseInt(states[5]);
                    }
                    if (states[6] != null) {
                        baseStationLongitude = Integer.parseInt(states[6]);
                    }
                    if (baseStationLatitude == 0 && baseStationLongitude == 0) {
                        baseStationLatitude = Integer.MAX_VALUE;
                        baseStationLongitude = Integer.MAX_VALUE;
                    }
                    if (states[7] != null) {
                        cssIndicator = Integer.parseInt(states[7]);
                    }
                    if (states[8] != null) {
                        systemId = Integer.parseInt(states[8]);
                    }
                    if (states[9] != null) {
                        networkId = Integer.parseInt(states[9]);
                    }
                    if (states[10] != null) {
                        roamingIndicator = Integer.parseInt(states[10]);
                    }
                    if (states[11] != null) {
                        systemIsInPrl = Integer.parseInt(states[11]);
                    }
                    if (states[12] != null) {
                        defaultRoamingIndicator = Integer.parseInt(states[12]);
                    }
                    if (states[13] != null) {
                        reasonForDenial = Integer.parseInt(states[13]);
                    }
                }
                catch (NumberFormatException ex) {
                    this.loge("EVENT_POLL_STATE_REGISTRATION_CDMA: error parsing: " + ex);
                }
                this.mRegistrationState = registrationState;
                this.mCdmaRoaming = this.regCodeIsRoaming(registrationState) && !this.isRoamIndForHomeSystem(states[10]);
                this.mNewSS.setState(this.regCodeToServiceState(registrationState));
                this.mNewSS.setRilVoiceRadioTechnology(radioTechnology);
                this.mNewSS.setCssIndicator(cssIndicator);
                this.mNewSS.setSystemAndNetworkId(systemId, networkId);
                this.mRoamingIndicator = roamingIndicator;
                this.mIsInPrl = systemIsInPrl != 0;
                this.mDefaultRoamingIndicator = defaultRoamingIndicator;
                this.mNewCellLoc.setCellLocationData(baseStationId, baseStationLatitude, baseStationLongitude, systemId, networkId);
                this.mRegistrationDeniedReason = reasonForDenial == 0 ? "General" : (reasonForDenial == 1 ? "Authentication Failure" : "");
                if (this.mRegistrationState != 3) return;
                this.log("Registration denied, " + this.mRegistrationDeniedReason);
                return;
            }
            case 25: {
                String[] opNames = (String[])ar.result;
                if (opNames != null && opNames.length >= 3) {
                    String brandOverride;
                    if (opNames[2] == null || opNames[2].length() < 5 || "00000".equals(opNames[2])) {
                        opNames[2] = SystemProperties.get(CDMAPhone.PROPERTY_CDMA_HOME_OPERATOR_NUMERIC, "00000");
                        this.log("RIL_REQUEST_OPERATOR.response[2], the numeric,  is bad. Using SystemProperties '" + CDMAPhone.PROPERTY_CDMA_HOME_OPERATOR_NUMERIC + "'= " + opNames[2]);
                    }
                    if (!this.mIsSubscriptionFromRuim) {
                        this.mNewSS.setOperatorName(null, opNames[1], opNames[2]);
                        return;
                    }
                    String string2 = brandOverride = this.mUiccController.getUiccCard() != null ? this.mUiccController.getUiccCard().getOperatorBrandOverride() : null;
                    if (brandOverride != null) {
                        this.mNewSS.setOperatorName(brandOverride, brandOverride, opNames[2]);
                        return;
                    }
                    this.mNewSS.setOperatorName(opNames[0], opNames[1], opNames[2]);
                    return;
                }
                this.log("EVENT_POLL_STATE_OPERATOR_CDMA: error parsing opNames");
                return;
            }
        }
        this.loge("handlePollStateResultMessage: RIL response handle in wrong phone! Expected CDMA RIL request and get GSM RIL request.");
    }

    @Override
    protected void handlePollStateResult(int what, AsyncResult ar) {
        if (ar.userObj != this.mPollingContext) {
            return;
        }
        if (ar.exception != null) {
            CommandException.Error err = null;
            if (ar.exception instanceof CommandException) {
                err = ((CommandException)ar.exception).getCommandError();
            }
            if (err == CommandException.Error.RADIO_NOT_AVAILABLE) {
                this.cancelPollState();
                return;
            }
            if (!this.mCi.getRadioState().isOn()) {
                this.cancelPollState();
                return;
            }
            if (err != CommandException.Error.OP_NOT_ALLOWED_BEFORE_REG_NW) {
                this.loge("handlePollStateResult: RIL returned an error where it must succeed" + ar.exception);
            }
        } else {
            try {
                this.handlePollStateResultMessage(what, ar);
            }
            catch (RuntimeException ex) {
                this.loge("handlePollStateResult: Exception while polling service state. Probably malformed RIL response." + ex);
            }
        }
        this.mPollingContext[0] = this.mPollingContext[0] - 1;
        if (this.mPollingContext[0] == 0) {
            boolean namMatch = false;
            if (!this.isSidsAllZeros() && this.isHomeSid(this.mNewSS.getSystemId())) {
                namMatch = true;
            }
            if (this.mIsSubscriptionFromRuim) {
                this.mNewSS.setRoaming(this.isRoamingBetweenOperators(this.mCdmaRoaming, this.mNewSS));
            } else {
                this.mNewSS.setRoaming(this.mCdmaRoaming);
            }
            this.mNewSS.setCdmaDefaultRoamingIndicator(this.mDefaultRoamingIndicator);
            this.mNewSS.setCdmaRoamingIndicator(this.mRoamingIndicator);
            boolean isPrlLoaded = true;
            if (TextUtils.isEmpty(this.mPrlVersion)) {
                isPrlLoaded = false;
            }
            if (!isPrlLoaded || this.mNewSS.getRilVoiceRadioTechnology() == 0) {
                this.log("Turn off roaming indicator if !isPrlLoaded or voice RAT is unknown");
                this.mNewSS.setCdmaRoamingIndicator(1);
            } else if (!this.isSidsAllZeros()) {
                if (!namMatch && !this.mIsInPrl) {
                    this.mNewSS.setCdmaRoamingIndicator(this.mDefaultRoamingIndicator);
                } else if (namMatch && !this.mIsInPrl) {
                    if (this.mNewSS.getRilVoiceRadioTechnology() == 14) {
                        this.log("Turn off roaming indicator as voice is LTE");
                        this.mNewSS.setCdmaRoamingIndicator(1);
                    } else {
                        this.mNewSS.setCdmaRoamingIndicator(2);
                    }
                } else if (!namMatch && this.mIsInPrl) {
                    this.mNewSS.setCdmaRoamingIndicator(this.mRoamingIndicator);
                } else if (this.mRoamingIndicator <= 2) {
                    this.mNewSS.setCdmaRoamingIndicator(1);
                } else {
                    this.mNewSS.setCdmaRoamingIndicator(this.mRoamingIndicator);
                }
            }
            int roamingIndicator = this.mNewSS.getCdmaRoamingIndicator();
            this.mNewSS.setCdmaEriIconIndex(this.mPhone.mEriManager.getCdmaEriIconIndex(roamingIndicator, this.mDefaultRoamingIndicator));
            this.mNewSS.setCdmaEriIconMode(this.mPhone.mEriManager.getCdmaEriIconMode(roamingIndicator, this.mDefaultRoamingIndicator));
            this.log("Set CDMA Roaming Indicator to: " + this.mNewSS.getCdmaRoamingIndicator() + ". mCdmaRoaming = " + this.mCdmaRoaming + ", isPrlLoaded = " + isPrlLoaded + ". namMatch = " + namMatch + " , mIsInPrl = " + this.mIsInPrl + ", mRoamingIndicator = " + this.mRoamingIndicator + ", mDefaultRoamingIndicator= " + this.mDefaultRoamingIndicator);
            this.pollStateDone();
        }
    }

    protected void setSignalStrengthDefaultValues() {
        this.mSignalStrength = new SignalStrength(false);
    }

    @Override
    public void pollState() {
        this.mPollingContext = new int[1];
        this.mPollingContext[0] = 0;
        switch (this.mCi.getRadioState()) {
            case RADIO_UNAVAILABLE: {
                this.mNewSS.setStateOutOfService();
                this.mNewCellLoc.setStateInvalid();
                this.setSignalStrengthDefaultValues();
                this.mGotCountryCode = false;
                this.pollStateDone();
                break;
            }
            case RADIO_OFF: {
                this.mNewSS.setStateOff();
                this.mNewCellLoc.setStateInvalid();
                this.setSignalStrengthDefaultValues();
                this.mGotCountryCode = false;
                this.pollStateDone();
                break;
            }
            default: {
                this.mPollingContext[0] = this.mPollingContext[0] + 1;
                this.mCi.getOperator(this.obtainMessage(25, this.mPollingContext));
                this.mPollingContext[0] = this.mPollingContext[0] + 1;
                this.mCi.getVoiceRegistrationState(this.obtainMessage(24, this.mPollingContext));
                this.mPollingContext[0] = this.mPollingContext[0] + 1;
                this.mCi.getDataRegistrationState(this.obtainMessage(5, this.mPollingContext));
            }
        }
    }

    protected void fixTimeZone(String isoCountryCode) {
        TimeZone zone = null;
        String zoneName = SystemProperties.get("persist.sys.timezone");
        this.log("fixTimeZone zoneName='" + zoneName + "' mZoneOffset=" + this.mZoneOffset + " mZoneDst=" + this.mZoneDst + " iso-cc='" + isoCountryCode + "' iso-cc-idx=" + Arrays.binarySearch(GMT_COUNTRY_CODES, isoCountryCode));
        if (this.mZoneOffset == 0 && !this.mZoneDst && zoneName != null && zoneName.length() > 0 && Arrays.binarySearch(GMT_COUNTRY_CODES, isoCountryCode) < 0) {
            zone = TimeZone.getDefault();
            if (this.mNeedFixZone) {
                long ctm = System.currentTimeMillis();
                long tzOffset = zone.getOffset(ctm);
                this.log("fixTimeZone: tzOffset=" + tzOffset + " ltod=" + TimeUtils.logTimeOfDay(ctm));
                if (this.getAutoTime()) {
                    long adj = ctm - tzOffset;
                    this.log("fixTimeZone: adj ltod=" + TimeUtils.logTimeOfDay(adj));
                    this.setAndBroadcastNetworkSetTime(adj);
                } else {
                    this.mSavedTime -= tzOffset;
                    this.log("fixTimeZone: adj mSavedTime=" + this.mSavedTime);
                }
            }
            this.log("fixTimeZone: using default TimeZone");
        } else if (isoCountryCode.equals("")) {
            zone = this.getNitzTimeZone(this.mZoneOffset, this.mZoneDst, this.mZoneTime);
            this.log("fixTimeZone: using NITZ TimeZone");
        } else {
            zone = TimeUtils.getTimeZone(this.mZoneOffset, this.mZoneDst, this.mZoneTime, isoCountryCode);
            this.log("fixTimeZone: using getTimeZone(off, dst, time, iso)");
        }
        this.mNeedFixZone = false;
        if (zone != null) {
            this.log("fixTimeZone: zone != null zone.getID=" + zone.getID());
            if (this.getAutoTimeZone()) {
                this.setAndBroadcastNetworkSetTimeZone(zone.getID());
            } else {
                this.log("fixTimeZone: skip changing zone as getAutoTimeZone was false");
            }
            this.saveNitzTimeZone(zone.getID());
        } else {
            this.log("fixTimeZone: zone == null, do nothing for zone");
        }
    }

    protected void pollStateDone() {
        boolean hasLocationChanged;
        this.log("pollStateDone: cdma oldSS=[" + this.mSS + "] newSS=[" + this.mNewSS + "]");
        if (Build.IS_DEBUGGABLE && SystemProperties.getBoolean("telephony.test.forceRoaming", false)) {
            this.mNewSS.setRoaming(true);
        }
        this.useDataRegStateForDataOnlyDevices();
        boolean hasRegistered = this.mSS.getVoiceRegState() != 0 && this.mNewSS.getVoiceRegState() == 0;
        boolean hasDeregistered = this.mSS.getVoiceRegState() == 0 && this.mNewSS.getVoiceRegState() != 0;
        boolean hasCdmaDataConnectionAttached = this.mSS.getDataRegState() != 0 && this.mNewSS.getDataRegState() == 0;
        boolean hasCdmaDataConnectionDetached = this.mSS.getDataRegState() == 0 && this.mNewSS.getDataRegState() != 0;
        boolean hasCdmaDataConnectionChanged = this.mSS.getDataRegState() != this.mNewSS.getDataRegState();
        boolean hasRilVoiceRadioTechnologyChanged = this.mSS.getRilVoiceRadioTechnology() != this.mNewSS.getRilVoiceRadioTechnology();
        boolean hasRilDataRadioTechnologyChanged = this.mSS.getRilDataRadioTechnology() != this.mNewSS.getRilDataRadioTechnology();
        boolean hasChanged = !this.mNewSS.equals(this.mSS);
        boolean hasRoamingOn = !this.mSS.getRoaming() && this.mNewSS.getRoaming();
        boolean hasRoamingOff = this.mSS.getRoaming() && !this.mNewSS.getRoaming();
        boolean bl = hasLocationChanged = !this.mNewCellLoc.equals(this.mCellLoc);
        if (this.mSS.getVoiceRegState() != this.mNewSS.getVoiceRegState() || this.mSS.getDataRegState() != this.mNewSS.getDataRegState()) {
            EventLog.writeEvent(50116, this.mSS.getVoiceRegState(), this.mSS.getDataRegState(), this.mNewSS.getVoiceRegState(), this.mNewSS.getDataRegState());
        }
        ServiceState tss = this.mSS;
        this.mSS = this.mNewSS;
        this.mNewSS = tss;
        this.mNewSS.setStateOutOfService();
        CdmaCellLocation tcl = this.mCellLoc;
        this.mCellLoc = this.mNewCellLoc;
        this.mNewCellLoc = tcl;
        if (hasRilVoiceRadioTechnologyChanged) {
            this.updatePhoneObject();
        }
        if (hasRilDataRadioTechnologyChanged) {
            this.mPhone.setSystemProperty("gsm.network.type", ServiceState.rilRadioTechnologyToString(this.mSS.getRilDataRadioTechnology()));
        }
        if (hasRegistered) {
            this.mNetworkAttachedRegistrants.notifyRegistrants();
        }
        if (hasChanged) {
            if (this.mCi.getRadioState().isOn() && !this.mIsSubscriptionFromRuim) {
                String eriText = this.mSS.getVoiceRegState() == 0 ? this.mPhone.getCdmaEriText() : this.mPhone.getContext().getText(17039557).toString();
                this.mSS.setOperatorAlphaLong(eriText);
            }
            this.mPhone.setSystemProperty("gsm.operator.alpha", this.mSS.getOperatorAlphaLong());
            String prevOperatorNumeric = SystemProperties.get("gsm.operator.numeric", "");
            String operatorNumeric = this.mSS.getOperatorNumeric();
            if (this.isInvalidOperatorNumeric(operatorNumeric)) {
                int sid = this.mSS.getSystemId();
                operatorNumeric = this.fixUnknownMcc(operatorNumeric, sid);
            }
            this.mPhone.setSystemProperty("gsm.operator.numeric", operatorNumeric);
            this.updateCarrierMccMncConfiguration(operatorNumeric, prevOperatorNumeric, this.mPhone.getContext());
            if (this.isInvalidOperatorNumeric(operatorNumeric)) {
                this.log("operatorNumeric " + operatorNumeric + "is invalid");
                this.mPhone.setSystemProperty("gsm.operator.iso-country", "");
                this.mGotCountryCode = false;
            } else {
                String isoCountryCode = "";
                String mcc = operatorNumeric.substring(0, 3);
                try {
                    isoCountryCode = MccTable.countryCodeForMcc(Integer.parseInt(operatorNumeric.substring(0, 3)));
                }
                catch (NumberFormatException ex) {
                    this.loge("pollStateDone: countryCodeForMcc error" + ex);
                }
                catch (StringIndexOutOfBoundsException ex) {
                    this.loge("pollStateDone: countryCodeForMcc error" + ex);
                }
                this.mPhone.setSystemProperty("gsm.operator.iso-country", isoCountryCode);
                this.mGotCountryCode = true;
                this.setOperatorIdd(operatorNumeric);
                if (this.shouldFixTimeZoneNow(this.mPhone, operatorNumeric, prevOperatorNumeric, this.mNeedFixZone)) {
                    this.fixTimeZone(isoCountryCode);
                }
            }
            this.mPhone.setSystemProperty("gsm.operator.isroaming", this.mSS.getRoaming() ? "true" : "false");
            this.updateSpnDisplay();
            this.mPhone.notifyServiceStateChanged(this.mSS);
        }
        if (hasCdmaDataConnectionAttached) {
            this.mAttachedRegistrants.notifyRegistrants();
        }
        if (hasCdmaDataConnectionDetached) {
            this.mDetachedRegistrants.notifyRegistrants();
        }
        if (hasCdmaDataConnectionChanged || hasRilDataRadioTechnologyChanged) {
            this.notifyDataRegStateRilRadioTechnologyChanged();
            this.mPhone.notifyDataConnection(null);
        }
        if (hasRoamingOn) {
            this.mRoamingOnRegistrants.notifyRegistrants();
        }
        if (hasRoamingOff) {
            this.mRoamingOffRegistrants.notifyRegistrants();
        }
        if (hasLocationChanged) {
            this.mPhone.notifyLocationChanged();
        }
    }

    protected boolean isInvalidOperatorNumeric(String operatorNumeric) {
        return operatorNumeric == null || operatorNumeric.length() < 5 || operatorNumeric.startsWith(INVALID_MCC);
    }

    protected String fixUnknownMcc(String operatorNumeric, int sid) {
        if (sid <= 0) {
            return operatorNumeric;
        }
        boolean isNitzTimeZone = false;
        int timeZone = 0;
        TimeZone tzone = null;
        if (this.mSavedTimeZone != null) {
            timeZone = TimeZone.getTimeZone(this.mSavedTimeZone).getRawOffset() / 3600000;
            isNitzTimeZone = true;
        } else {
            tzone = this.getNitzTimeZone(this.mZoneOffset, this.mZoneDst, this.mZoneTime);
            if (tzone != null) {
                timeZone = tzone.getRawOffset() / 3600000;
            }
        }
        int mcc = this.mHbpcdUtils.getMcc(sid, timeZone, this.mZoneDst ? 1 : 0, isNitzTimeZone);
        if (mcc > 0) {
            operatorNumeric = Integer.toString(mcc) + DEFAULT_MNC;
        }
        return operatorNumeric;
    }

    protected void setOperatorIdd(String operatorNumeric) {
        String idd = this.mHbpcdUtils.getIddByMcc(Integer.parseInt(operatorNumeric.substring(0, 3)));
        if (idd != null && !idd.isEmpty()) {
            this.mPhone.setSystemProperty("gsm.operator.idpstring", idd);
        } else {
            this.mPhone.setSystemProperty("gsm.operator.idpstring", "+");
        }
    }

    private TimeZone getNitzTimeZone(int offset, boolean dst, long when) {
        TimeZone guess = this.findTimeZone(offset, dst, when);
        if (guess == null) {
            guess = this.findTimeZone(offset, !dst, when);
        }
        this.log("getNitzTimeZone returning " + (guess == null ? guess : guess.getID()));
        return guess;
    }

    private TimeZone findTimeZone(int offset, boolean dst, long when) {
        int rawOffset = offset;
        if (dst) {
            rawOffset -= 3600000;
        }
        String[] zones = TimeZone.getAvailableIDs(rawOffset);
        TimeZone guess = null;
        Date d = new Date(when);
        for (String zone : zones) {
            TimeZone tz = TimeZone.getTimeZone(zone);
            if (tz.getOffset(when) != offset || tz.inDaylightTime(d) != dst) continue;
            guess = tz;
            break;
        }
        return guess;
    }

    private void queueNextSignalStrengthPoll() {
        if (this.mDontPollSignalStrength) {
            return;
        }
        Message msg = this.obtainMessage();
        msg.what = 10;
        this.sendMessageDelayed(msg, 20000L);
    }

    protected int radioTechnologyToDataServiceState(int code) {
        int retVal = 1;
        switch (code) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: {
                retVal = 0;
                break;
            }
            default: {
                this.loge("radioTechnologyToDataServiceState: Wrong radioTechnology code.");
            }
        }
        return retVal;
    }

    protected int regCodeToServiceState(int code) {
        switch (code) {
            case 0: {
                return 1;
            }
            case 1: {
                return 0;
            }
            case 2: 
            case 3: 
            case 4: {
                return 1;
            }
            case 5: {
                return 0;
            }
        }
        this.loge("regCodeToServiceState: unexpected service state " + code);
        return 1;
    }

    @Override
    public int getCurrentDataConnectionState() {
        return this.mSS.getDataRegState();
    }

    private boolean regCodeIsRoaming(int code) {
        return 5 == code;
    }

    private boolean isRoamIndForHomeSystem(String roamInd) {
        String[] homeRoamIndicators = this.mPhone.getContext().getResources().getStringArray(17236023);
        if (homeRoamIndicators != null) {
            for (String homeRoamInd : homeRoamIndicators) {
                if (!homeRoamInd.equals(roamInd)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean isRoamingBetweenOperators(boolean cdmaRoaming, ServiceState s) {
        String spn = this.getSystemProperty("gsm.sim.operator.alpha", "empty");
        String onsl = s.getOperatorAlphaLong();
        String onss = s.getOperatorAlphaShort();
        boolean equalsOnsl = onsl != null && spn.equals(onsl);
        boolean equalsOnss = onss != null && spn.equals(onss);
        return cdmaRoaming && !equalsOnsl && !equalsOnss;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTimeFromNITZString(String nitz, long nitzReceiveTime) {
        long start = SystemClock.elapsedRealtime();
        this.log("NITZ: " + nitz + "," + nitzReceiveTime + " start=" + start + " delay=" + (start - nitzReceiveTime));
        try {
            String ignore;
            Calendar c = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            c.clear();
            c.set(16, 0);
            String[] nitzSubs = nitz.split("[/:,+-]");
            int year = 2000 + Integer.parseInt(nitzSubs[0]);
            c.set(1, year);
            int month = Integer.parseInt(nitzSubs[1]) - 1;
            c.set(2, month);
            int date = Integer.parseInt(nitzSubs[2]);
            c.set(5, date);
            int hour = Integer.parseInt(nitzSubs[3]);
            c.set(10, hour);
            int minute = Integer.parseInt(nitzSubs[4]);
            c.set(12, minute);
            int second = Integer.parseInt(nitzSubs[5]);
            c.set(13, second);
            boolean sign = nitz.indexOf(45) == -1;
            int tzOffset = Integer.parseInt(nitzSubs[6]);
            int dst = nitzSubs.length >= 8 ? Integer.parseInt(nitzSubs[7]) : 0;
            tzOffset = (sign ? 1 : -1) * tzOffset * 15 * 60 * 1000;
            TimeZone zone = null;
            if (nitzSubs.length >= 9) {
                String tzname = nitzSubs[8].replace('!', '/');
                zone = TimeZone.getTimeZone(tzname);
            }
            String iso = this.getSystemProperty("gsm.operator.iso-country", "");
            if (zone == null && this.mGotCountryCode) {
                zone = iso != null && iso.length() > 0 ? TimeUtils.getTimeZone(tzOffset, dst != 0, c.getTimeInMillis(), iso) : this.getNitzTimeZone(tzOffset, dst != 0, c.getTimeInMillis());
            }
            if (zone == null || this.mZoneOffset != tzOffset || this.mZoneDst != (dst != 0)) {
                this.mNeedFixZone = true;
                this.mZoneOffset = tzOffset;
                this.mZoneDst = dst != 0;
                this.mZoneTime = c.getTimeInMillis();
            }
            this.log("NITZ: tzOffset=" + tzOffset + " dst=" + dst + " zone=" + (zone != null ? zone.getID() : "NULL") + " iso=" + iso + " mGotCountryCode=" + this.mGotCountryCode + " mNeedFixZone=" + this.mNeedFixZone);
            if (zone != null) {
                if (this.getAutoTimeZone()) {
                    this.setAndBroadcastNetworkSetTimeZone(zone.getID());
                }
                this.saveNitzTimeZone(zone.getID());
            }
            if ((ignore = SystemProperties.get("gsm.ignore-nitz")) != null && ignore.equals("yes")) {
                this.log("NITZ: Not setting clock because gsm.ignore-nitz is set");
                return;
            }
            try {
                this.mWakeLock.acquire();
                long millisSinceNitzReceived = SystemClock.elapsedRealtime() - nitzReceiveTime;
                if (millisSinceNitzReceived < 0L) {
                    this.log("NITZ: not setting time, clock has rolled backwards since NITZ time was received, " + nitz);
                    return;
                }
                if (millisSinceNitzReceived > Integer.MAX_VALUE) {
                    this.log("NITZ: not setting time, processing has taken " + millisSinceNitzReceived / 86400000L + " days");
                    return;
                }
                c.add(14, (int)millisSinceNitzReceived);
                if (this.getAutoTime()) {
                    long gained = c.getTimeInMillis() - System.currentTimeMillis();
                    long timeSinceLastUpdate = SystemClock.elapsedRealtime() - this.mSavedAtTime;
                    int nitzUpdateSpacing = Settings.Global.getInt(this.mCr, "nitz_update_spacing", this.mNitzUpdateSpacing);
                    int nitzUpdateDiff = Settings.Global.getInt(this.mCr, "nitz_update_diff", this.mNitzUpdateDiff);
                    if (this.mSavedAtTime == 0L || timeSinceLastUpdate > (long)nitzUpdateSpacing || Math.abs(gained) > (long)nitzUpdateDiff) {
                        this.log("NITZ: Auto updating time of day to " + c.getTime() + " NITZ receive delay=" + millisSinceNitzReceived + "ms gained=" + gained + "ms from " + nitz);
                        this.setAndBroadcastNetworkSetTime(c.getTimeInMillis());
                    } else {
                        this.log("NITZ: ignore, a previous update was " + timeSinceLastUpdate + "ms ago and gained=" + gained + "ms");
                        return;
                    }
                }
                this.log("NITZ: update nitz time property");
                SystemProperties.set("gsm.nitz.time", String.valueOf(c.getTimeInMillis()));
                this.mSavedTime = c.getTimeInMillis();
                this.mSavedAtTime = SystemClock.elapsedRealtime();
            }
            finally {
                long end = SystemClock.elapsedRealtime();
                this.log("NITZ: end=" + end + " dur=" + (end - start));
                this.mWakeLock.release();
            }
        }
        catch (RuntimeException ex) {
            this.loge("NITZ: Parsing NITZ time " + nitz + " ex=" + ex);
        }
    }

    private boolean getAutoTime() {
        try {
            return Settings.Global.getInt(this.mCr, "auto_time") > 0;
        }
        catch (Settings.SettingNotFoundException snfe) {
            return true;
        }
    }

    private boolean getAutoTimeZone() {
        try {
            return Settings.Global.getInt(this.mCr, "auto_time_zone") > 0;
        }
        catch (Settings.SettingNotFoundException snfe) {
            return true;
        }
    }

    private void saveNitzTimeZone(String zoneId) {
        this.mSavedTimeZone = zoneId;
    }

    private void setAndBroadcastNetworkSetTimeZone(String zoneId) {
        this.log("setAndBroadcastNetworkSetTimeZone: setTimeZone=" + zoneId);
        AlarmManager alarm = (AlarmManager)this.mPhone.getContext().getSystemService("alarm");
        alarm.setTimeZone(zoneId);
        Intent intent = new Intent("android.intent.action.NETWORK_SET_TIMEZONE");
        intent.addFlags(0x20000000);
        intent.putExtra("time-zone", zoneId);
        this.mPhone.getContext().sendStickyBroadcastAsUser(intent, UserHandle.ALL);
    }

    private void setAndBroadcastNetworkSetTime(long time) {
        this.log("setAndBroadcastNetworkSetTime: time=" + time + "ms");
        SystemClock.setCurrentTimeMillis(time);
        Intent intent = new Intent("android.intent.action.NETWORK_SET_TIME");
        intent.addFlags(0x20000000);
        intent.putExtra("time", time);
        this.mPhone.getContext().sendStickyBroadcastAsUser(intent, UserHandle.ALL);
    }

    private void revertToNitzTime() {
        if (Settings.Global.getInt(this.mCr, "auto_time", 0) == 0) {
            return;
        }
        this.log("revertToNitzTime: mSavedTime=" + this.mSavedTime + " mSavedAtTime=" + this.mSavedAtTime);
        if (this.mSavedTime != 0L && this.mSavedAtTime != 0L) {
            this.setAndBroadcastNetworkSetTime(this.mSavedTime + (SystemClock.elapsedRealtime() - this.mSavedAtTime));
        }
    }

    private void revertToNitzTimeZone() {
        if (Settings.Global.getInt(this.mPhone.getContext().getContentResolver(), "auto_time_zone", 0) == 0) {
            return;
        }
        this.log("revertToNitzTimeZone: tz='" + this.mSavedTimeZone);
        if (this.mSavedTimeZone != null) {
            this.setAndBroadcastNetworkSetTimeZone(this.mSavedTimeZone);
        }
    }

    protected boolean isSidsAllZeros() {
        if (this.mHomeSystemId != null) {
            for (int i = 0; i < this.mHomeSystemId.length; ++i) {
                if (this.mHomeSystemId[i] == 0) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isHomeSid(int sid) {
        if (this.mHomeSystemId != null) {
            for (int i = 0; i < this.mHomeSystemId.length; ++i) {
                if (sid != this.mHomeSystemId[i]) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isConcurrentVoiceAndDataAllowed() {
        return false;
    }

    public String getMdnNumber() {
        return this.mMdn;
    }

    public String getCdmaMin() {
        return this.mMin;
    }

    public String getPrlVersion() {
        return this.mPrlVersion;
    }

    String getImsi() {
        String operatorNumeric = this.getSystemProperty("gsm.sim.operator.numeric", "");
        if (!TextUtils.isEmpty(operatorNumeric) && this.getCdmaMin() != null) {
            return operatorNumeric + this.getCdmaMin();
        }
        return null;
    }

    public boolean isMinInfoReady() {
        return this.mIsMinInfoReady;
    }

    int getOtasp() {
        int provisioningState;
        if (this.mIsSubscriptionFromRuim && this.mMin == null) {
            return 2;
        }
        if (this.mMin == null || this.mMin.length() < 6) {
            this.log("getOtasp: bad mMin='" + this.mMin + "'");
            provisioningState = 1;
        } else {
            provisioningState = this.mMin.equals(UNACTIVATED_MIN_VALUE) || this.mMin.substring(0, 6).equals(UNACTIVATED_MIN2_VALUE) || SystemProperties.getBoolean("test_cdma_setup", false) ? 2 : 3;
        }
        this.log("getOtasp: state=" + provisioningState);
        return provisioningState;
    }

    @Override
    protected void hangupAndPowerOff() {
        this.mPhone.mCT.mRingingCall.hangupIfAlive();
        this.mPhone.mCT.mBackgroundCall.hangupIfAlive();
        this.mPhone.mCT.mForegroundCall.hangupIfAlive();
        this.mCi.setRadioPower(false, null);
    }

    protected void parseSidNid(String sidStr, String nidStr) {
        int i;
        if (sidStr != null) {
            String[] sid = sidStr.split(",");
            this.mHomeSystemId = new int[sid.length];
            for (i = 0; i < sid.length; ++i) {
                try {
                    this.mHomeSystemId[i] = Integer.parseInt(sid[i]);
                    continue;
                }
                catch (NumberFormatException ex) {
                    this.loge("error parsing system id: " + ex);
                }
            }
        }
        this.log("CDMA_SUBSCRIPTION: SID=" + sidStr);
        if (nidStr != null) {
            String[] nid = nidStr.split(",");
            this.mHomeNetworkId = new int[nid.length];
            for (i = 0; i < nid.length; ++i) {
                try {
                    this.mHomeNetworkId[i] = Integer.parseInt(nid[i]);
                    continue;
                }
                catch (NumberFormatException ex) {
                    this.loge("CDMA_SUBSCRIPTION: error parsing network id: " + ex);
                }
            }
        }
        this.log("CDMA_SUBSCRIPTION: NID=" + nidStr);
    }

    protected void updateOtaspState() {
        int otaspMode = this.getOtasp();
        int oldOtaspMode = this.mCurrentOtaspMode;
        this.mCurrentOtaspMode = otaspMode;
        if (this.mCdmaForSubscriptionInfoReadyRegistrants != null) {
            this.log("CDMA_SUBSCRIPTION: call notifyRegistrants()");
            this.mCdmaForSubscriptionInfoReadyRegistrants.notifyRegistrants();
        }
        if (oldOtaspMode != this.mCurrentOtaspMode) {
            this.log("CDMA_SUBSCRIPTION: call notifyOtaspChanged old otaspMode=" + oldOtaspMode + " new otaspMode=" + this.mCurrentOtaspMode);
            this.mPhone.notifyOtaspChanged(this.mCurrentOtaspMode);
        }
    }

    protected UiccCardApplication getUiccCardApplication() {
        return this.mUiccController.getUiccCardApplication(this.mPhone.getPhoneId(), 2);
    }

    @Override
    protected void onUpdateIccAvailability() {
        if (this.mUiccController == null) {
            return;
        }
        UiccCardApplication newUiccApplication = this.getUiccCardApplication();
        if (this.mUiccApplcation != newUiccApplication) {
            if (this.mUiccApplcation != null) {
                this.log("Removing stale icc objects.");
                this.mUiccApplcation.unregisterForReady(this);
                if (this.mIccRecords != null) {
                    this.mIccRecords.unregisterForRecordsLoaded(this);
                }
                this.mIccRecords = null;
                this.mUiccApplcation = null;
            }
            if (newUiccApplication != null) {
                this.log("New card found");
                this.mUiccApplcation = newUiccApplication;
                this.mIccRecords = this.mUiccApplcation.getIccRecords();
                if (this.mIsSubscriptionFromRuim) {
                    this.mUiccApplcation.registerForReady(this, 26, null);
                    if (this.mIccRecords != null) {
                        this.mIccRecords.registerForRecordsLoaded(this, 27, null);
                    }
                }
            }
        }
    }

    @Override
    protected void log(String s) {
        Rlog.d(LOG_TAG, "[CdmaSST] " + s);
    }

    @Override
    protected void loge(String s) {
        Rlog.e(LOG_TAG, "[CdmaSST] " + s);
    }

    @Override
    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("CdmaServiceStateTracker extends:");
        super.dump(fd, pw, args);
        pw.println(" mPhone=" + this.mPhone);
        pw.println(" mSS=" + this.mSS);
        pw.println(" mNewSS=" + this.mNewSS);
        pw.println(" mCellLoc=" + this.mCellLoc);
        pw.println(" mNewCellLoc=" + this.mNewCellLoc);
        pw.println(" mCurrentOtaspMode=" + this.mCurrentOtaspMode);
        pw.println(" mCdmaRoaming=" + this.mCdmaRoaming);
        pw.println(" mRoamingIndicator=" + this.mRoamingIndicator);
        pw.println(" mIsInPrl=" + this.mIsInPrl);
        pw.println(" mDefaultRoamingIndicator=" + this.mDefaultRoamingIndicator);
        pw.println(" mRegistrationState=" + this.mRegistrationState);
        pw.println(" mNeedFixZone=" + this.mNeedFixZone);
        pw.println(" mZoneOffset=" + this.mZoneOffset);
        pw.println(" mZoneDst=" + this.mZoneDst);
        pw.println(" mZoneTime=" + this.mZoneTime);
        pw.println(" mGotCountryCode=" + this.mGotCountryCode);
        pw.println(" mSavedTimeZone=" + this.mSavedTimeZone);
        pw.println(" mSavedTime=" + this.mSavedTime);
        pw.println(" mSavedAtTime=" + this.mSavedAtTime);
        pw.println(" mWakeLock=" + this.mWakeLock);
        pw.println(" mCurPlmn=" + this.mCurPlmn);
        pw.println(" mMdn=" + this.mMdn);
        pw.println(" mHomeSystemId=" + this.mHomeSystemId);
        pw.println(" mHomeNetworkId=" + this.mHomeNetworkId);
        pw.println(" mMin=" + this.mMin);
        pw.println(" mPrlVersion=" + this.mPrlVersion);
        pw.println(" mIsMinInfoReady=" + this.mIsMinInfoReady);
        pw.println(" mIsEriTextLoaded=" + this.mIsEriTextLoaded);
        pw.println(" mIsSubscriptionFromRuim=" + this.mIsSubscriptionFromRuim);
        pw.println(" mCdmaSSM=" + this.mCdmaSSM);
        pw.println(" mRegistrationDeniedReason=" + this.mRegistrationDeniedReason);
        pw.println(" mCurrentCarrier=" + this.mCurrentCarrier);
    }

    @Override
    public void setImsRegistrationState(boolean registered) {
        this.log("ImsRegistrationState - registered : " + registered);
        if (this.mImsRegistrationOnOff && !registered && this.mAlarmSwitch) {
            this.mImsRegistrationOnOff = registered;
            Context context = this.mPhone.getContext();
            AlarmManager am = (AlarmManager)context.getSystemService("alarm");
            am.cancel(this.mRadioOffIntent);
            this.mAlarmSwitch = false;
            this.sendMessage(this.obtainMessage(45));
            return;
        }
        this.mImsRegistrationOnOff = registered;
    }
}

