/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.dataconnection;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.database.ContentObserver;
import android.net.ConnectivityManager;
import android.net.LinkProperties;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.TrafficStats;
import android.os.AsyncResult;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.preference.PreferenceManager;
import android.provider.Settings;
import android.telephony.Rlog;
import android.text.TextUtils;
import android.util.EventLog;
import com.android.internal.telephony.DctConstants;
import com.android.internal.telephony.PhoneBase;
import com.android.internal.telephony.PhoneConstants;
import com.android.internal.telephony.dataconnection.ApnContext;
import com.android.internal.telephony.dataconnection.ApnSetting;
import com.android.internal.telephony.dataconnection.DataConnection;
import com.android.internal.telephony.dataconnection.DataProfile;
import com.android.internal.telephony.dataconnection.DcAsyncChannel;
import com.android.internal.telephony.dataconnection.DcController;
import com.android.internal.telephony.dataconnection.DcFailCause;
import com.android.internal.telephony.dataconnection.DcTesterFailBringUpAll;
import com.android.internal.telephony.uicc.IccRecords;
import com.android.internal.telephony.uicc.UiccController;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.AsyncChannel;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public abstract class DcTrackerBase
extends Handler {
    protected static final boolean DBG = true;
    protected static final boolean VDBG = false;
    protected static final boolean VDBG_STALL = true;
    protected static final boolean RADIO_TESTS = false;
    static boolean mIsCleanupRequired = false;
    protected static final int DATA_CONNECTION_ACTIVE_PH_LINK_INACTIVE = 0;
    protected static final int DATA_CONNECTION_ACTIVE_PH_LINK_DOWN = 1;
    protected static final int DATA_CONNECTION_ACTIVE_PH_LINK_UP = 2;
    protected static final int APN_DELAY_DEFAULT_MILLIS = 20000;
    protected static final int APN_FAIL_FAST_DELAY_DEFAULT_MILLIS = 3000;
    AlarmManager mAlarmManager;
    protected Object mDataEnabledLock = new Object();
    protected boolean mInternalDataEnabled = true;
    protected boolean mUserDataEnabled = true;
    protected static boolean sPolicyDataEnabled = true;
    private boolean[] mDataEnabled = new boolean[10];
    private int mEnabledCount = 0;
    protected String mRequestedApnType = "default";
    protected static final String DEFAULT_DATA_RETRY_CONFIG = "default_randomization=2000,5000,10000,20000,40000,80000:5000,160000:5000,320000:5000,640000:5000,1280000:5000,1800000:5000";
    protected static final String SECONDARY_DATA_RETRY_CONFIG = "max_retries=3, 5000, 5000, 5000";
    protected static final int POLL_NETSTAT_SLOW_MILLIS = 5000;
    protected static final int DEFAULT_MAX_PDP_RESET_FAIL = 3;
    protected static final int NO_RECV_POLL_LIMIT = 24;
    protected static final int POLL_NETSTAT_MILLIS = 1000;
    protected static final int POLL_NETSTAT_SCREEN_OFF_MILLIS = 600000;
    protected static final int POLL_LONGEST_RTT = 120000;
    protected static final int NUMBER_SENT_PACKETS_OF_HANG = 10;
    protected static final int RESTORE_DEFAULT_APN_DELAY = 60000;
    protected static final String APN_RESTORE_DELAY_PROP_NAME = "android.telephony.apn-restore";
    protected static final String NULL_IP = "0.0.0.0";
    protected static final int DATA_STALL_ALARM_NON_AGGRESSIVE_DELAY_IN_MS_DEFAULT = 360000;
    protected static final int DATA_STALL_ALARM_AGGRESSIVE_DELAY_IN_MS_DEFAULT = 60000;
    protected static final int DATA_STALL_NO_RECV_POLL_LIMIT = 1;
    protected static final String DATA_STALL_ALARM_TAG_EXTRA = "data.stall.alram.tag";
    protected static final boolean DATA_STALL_SUSPECTED = true;
    protected static final boolean DATA_STALL_NOT_SUSPECTED = false;
    protected String RADIO_RESET_PROPERTY = "gsm.radioreset";
    protected static final String INTENT_RECONNECT_ALARM = "com.android.internal.telephony.data-reconnect";
    protected static final String INTENT_RECONNECT_ALARM_EXTRA_TYPE = "reconnect_alarm_extra_type";
    protected static final String INTENT_RECONNECT_ALARM_EXTRA_REASON = "reconnect_alarm_extra_reason";
    protected static final String INTENT_RESTART_TRYSETUP_ALARM = "com.android.internal.telephony.data-restart-trysetup";
    protected static final String INTENT_RESTART_TRYSETUP_ALARM_EXTRA_TYPE = "restart_trysetup_alarm_extra_type";
    protected static final String INTENT_DATA_STALL_ALARM = "com.android.internal.telephony.data-stall";
    protected static final String DEFALUT_DATA_ON_BOOT_PROP = "net.def_data_on_boot";
    protected DcTesterFailBringUpAll mDcTesterFailBringUpAll;
    protected DcController mDcc;
    protected PhoneBase mPhone;
    protected UiccController mUiccController;
    protected AtomicReference<IccRecords> mIccRecords = new AtomicReference();
    protected DctConstants.Activity mActivity = DctConstants.Activity.NONE;
    protected DctConstants.State mState = DctConstants.State.IDLE;
    protected Handler mDataConnectionTracker = null;
    protected long mTxPkts;
    protected long mRxPkts;
    protected int mNetStatPollPeriod;
    protected boolean mNetStatPollEnabled = false;
    protected TxRxSum mDataStallTxRxSum = new TxRxSum(0L, 0L);
    protected int mDataStallAlarmTag = (int)SystemClock.elapsedRealtime();
    protected PendingIntent mDataStallAlarmIntent = null;
    protected long mSentSinceLastRecv;
    protected int mNoRecvPollCount = 0;
    protected static int sEnableFailFastRefCounter = 0;
    protected volatile boolean mDataStallDetectionEnabled = true;
    protected volatile boolean mFailFast = false;
    protected boolean mInVoiceCall = false;
    protected boolean mIsWifiConnected = false;
    protected PendingIntent mReconnectIntent = null;
    protected int mCidActive;
    protected boolean mAutoAttachOnCreationConfig = false;
    protected boolean mAutoAttachOnCreation = false;
    protected boolean mIsScreenOn = true;
    protected AtomicInteger mUniqueIdGenerator = new AtomicInteger(0);
    protected HashMap<Integer, DataConnection> mDataConnections = new HashMap();
    protected HashMap<Integer, DcAsyncChannel> mDataConnectionAcHashMap = new HashMap();
    protected HashMap<String, Integer> mApnToDataConnectionId = new HashMap();
    protected final ConcurrentHashMap<String, ApnContext> mApnContexts = new ConcurrentHashMap();
    protected final PriorityQueue<ApnContext> mPrioritySortedApnContexts = new PriorityQueue<ApnContext>(5, new Comparator<ApnContext>(){

        @Override
        public int compare(ApnContext c1, ApnContext c2) {
            return c2.priority - c1.priority;
        }
    });
    protected ApnSetting mActiveApn;
    protected ArrayList<ApnSetting> mAllApnSettings = null;
    protected ApnSetting mPreferredApn = null;
    protected boolean mIsPsRestricted = false;
    protected ApnSetting mEmergencyApn = null;
    protected boolean mIsDisposed = false;
    protected ContentResolver mResolver;
    protected boolean mIsProvisioning = false;
    protected String mProvisioningUrl = null;
    protected static final String INTENT_PROVISIONING_APN_ALARM = "com.android.internal.telephony.provisioning_apn_alarm";
    protected static final String PROVISIONING_APN_ALARM_TAG_EXTRA = "provisioning.apn.alarm.tag";
    protected static final String DEBUG_PROV_APN_ALARM = "persist.debug.prov_apn_alarm";
    protected static final int PROVISIONING_APN_ALARM_DELAY_IN_MS_DEFAULT = 900000;
    protected PendingIntent mProvisioningApnAlarmIntent = null;
    protected int mProvisioningApnAlarmTag = (int)SystemClock.elapsedRealtime();
    protected AsyncChannel mReplyAc = new AsyncChannel();
    protected BroadcastReceiver mIntentReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            DcTrackerBase.this.log("onReceive: action=" + action);
            if (action.equals("android.intent.action.SCREEN_ON")) {
                DcTrackerBase.this.mIsScreenOn = true;
                DcTrackerBase.this.stopNetStatPoll();
                DcTrackerBase.this.startNetStatPoll();
                DcTrackerBase.this.restartDataStallAlarm();
            } else if (action.equals("android.intent.action.SCREEN_OFF")) {
                DcTrackerBase.this.mIsScreenOn = false;
                DcTrackerBase.this.stopNetStatPoll();
                DcTrackerBase.this.startNetStatPoll();
                DcTrackerBase.this.restartDataStallAlarm();
            } else if (action.startsWith(DcTrackerBase.INTENT_RECONNECT_ALARM)) {
                DcTrackerBase.this.log("Reconnect alarm. Previous state was " + (Object)((Object)DcTrackerBase.this.mState));
                DcTrackerBase.this.onActionIntentReconnectAlarm(intent);
            } else if (action.startsWith(DcTrackerBase.INTENT_RESTART_TRYSETUP_ALARM)) {
                DcTrackerBase.this.log("Restart trySetup alarm");
                DcTrackerBase.this.onActionIntentRestartTrySetupAlarm(intent);
            } else if (action.equals(DcTrackerBase.INTENT_DATA_STALL_ALARM)) {
                DcTrackerBase.this.onActionIntentDataStallAlarm(intent);
            } else if (action.equals(DcTrackerBase.INTENT_PROVISIONING_APN_ALARM)) {
                DcTrackerBase.this.onActionIntentProvisioningApnAlarm(intent);
            } else if (action.equals("android.net.wifi.STATE_CHANGE")) {
                NetworkInfo networkInfo = (NetworkInfo)intent.getParcelableExtra("networkInfo");
                DcTrackerBase.this.mIsWifiConnected = networkInfo != null && networkInfo.isConnected();
                DcTrackerBase.this.log("NETWORK_STATE_CHANGED_ACTION: mIsWifiConnected=" + DcTrackerBase.this.mIsWifiConnected);
            } else if (action.equals("android.net.wifi.WIFI_STATE_CHANGED")) {
                boolean enabled;
                boolean bl = enabled = intent.getIntExtra("wifi_state", 4) == 3;
                if (!enabled) {
                    DcTrackerBase.this.mIsWifiConnected = false;
                }
                DcTrackerBase.this.log("WIFI_STATE_CHANGED_ACTION: enabled=" + enabled + " mIsWifiConnected=" + DcTrackerBase.this.mIsWifiConnected);
            }
        }
    };
    private Runnable mPollNetStat = new Runnable(){

        @Override
        public void run() {
            DcTrackerBase.this.updateDataActivity();
            DcTrackerBase.this.mNetStatPollPeriod = DcTrackerBase.this.mIsScreenOn ? Settings.Global.getInt(DcTrackerBase.this.mResolver, "pdp_watchdog_poll_interval_ms", 1000) : Settings.Global.getInt(DcTrackerBase.this.mResolver, "pdp_watchdog_long_poll_interval_ms", 600000);
            if (DcTrackerBase.this.mNetStatPollEnabled) {
                DcTrackerBase.this.mDataConnectionTracker.postDelayed(this, DcTrackerBase.this.mNetStatPollPeriod);
            }
        }
    };
    private final DataRoamingSettingObserver mDataRoamingSettingObserver;
    private static final int DEFAULT_MDC_INITIAL_RETRY = 1;
    ConnectivityManager mCm;

    protected int getInitialMaxRetry() {
        if (this.mFailFast) {
            return 0;
        }
        int value = SystemProperties.getInt("mdc_initial_max_retry", 1);
        return Settings.Global.getInt(this.mResolver, "mdc_initial_max_retry", value);
    }

    protected void onActionIntentReconnectAlarm(Intent intent) {
        String reason = intent.getStringExtra(INTENT_RECONNECT_ALARM_EXTRA_REASON);
        String apnType = intent.getStringExtra(INTENT_RECONNECT_ALARM_EXTRA_TYPE);
        long phoneSubId = this.mPhone.getSubId();
        long currSubId = intent.getLongExtra("subscription", -1000L);
        this.log("onActionIntentReconnectAlarm: currSubId = " + currSubId + " phoneSubId=" + phoneSubId);
        ApnContext apnContext = this.mApnContexts.get(apnType);
        this.log("onActionIntentReconnectAlarm: mState=" + (Object)((Object)this.mState) + " reason=" + reason + " apnType=" + apnType + " apnContext=" + apnContext + " mDataConnectionAsyncChannels=" + this.mDataConnectionAcHashMap);
        if (apnContext != null && apnContext.isEnabled()) {
            apnContext.setReason(reason);
            DctConstants.State apnContextState = apnContext.getState();
            this.log("onActionIntentReconnectAlarm: apnContext state=" + (Object)((Object)apnContextState));
            if (apnContextState == DctConstants.State.FAILED || apnContextState == DctConstants.State.IDLE) {
                this.log("onActionIntentReconnectAlarm: state is FAILED|IDLE, disassociate");
                DcAsyncChannel dcac = apnContext.getDcAc();
                if (dcac != null) {
                    dcac.tearDown(apnContext, "", null);
                }
                apnContext.setDataConnectionAc(null);
                apnContext.setState(DctConstants.State.IDLE);
            } else {
                this.log("onActionIntentReconnectAlarm: keep associated");
            }
            this.sendMessage(this.obtainMessage(270339, apnContext));
            apnContext.setReconnectIntent(null);
        }
    }

    protected void onActionIntentRestartTrySetupAlarm(Intent intent) {
        String apnType = intent.getStringExtra(INTENT_RESTART_TRYSETUP_ALARM_EXTRA_TYPE);
        ApnContext apnContext = this.mApnContexts.get(apnType);
        this.log("onActionIntentRestartTrySetupAlarm: mState=" + (Object)((Object)this.mState) + " apnType=" + apnType + " apnContext=" + apnContext + " mDataConnectionAsyncChannels=" + this.mDataConnectionAcHashMap);
        this.sendMessage(this.obtainMessage(270339, apnContext));
    }

    protected void onActionIntentDataStallAlarm(Intent intent) {
        this.log("onActionIntentDataStallAlarm: action=" + intent.getAction());
        Message msg = this.obtainMessage(270353, intent.getAction());
        msg.arg1 = intent.getIntExtra(DATA_STALL_ALARM_TAG_EXTRA, 0);
        this.sendMessage(msg);
    }

    protected DcTrackerBase(PhoneBase phone) {
        this.mPhone = phone;
        this.log("DCT.constructor");
        this.mResolver = this.mPhone.getContext().getContentResolver();
        this.mUiccController = UiccController.getInstance();
        this.mUiccController.registerForIccChanged(this, 270369, null);
        this.mAlarmManager = (AlarmManager)this.mPhone.getContext().getSystemService("alarm");
        this.mCm = (ConnectivityManager)this.mPhone.getContext().getSystemService("connectivity");
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.SCREEN_ON");
        filter.addAction("android.intent.action.SCREEN_OFF");
        filter.addAction("android.net.wifi.STATE_CHANGE");
        filter.addAction("android.net.wifi.WIFI_STATE_CHANGED");
        filter.addAction(INTENT_DATA_STALL_ALARM);
        filter.addAction(INTENT_PROVISIONING_APN_ALARM);
        this.mUserDataEnabled = Settings.Global.getInt(this.mPhone.getContext().getContentResolver(), "mobile_data", 1) == 1;
        this.mPhone.getContext().registerReceiver(this.mIntentReceiver, filter, null, this.mPhone);
        this.mDataEnabled[0] = SystemProperties.getBoolean(DEFALUT_DATA_ON_BOOT_PROP, true);
        if (this.mDataEnabled[0]) {
            ++this.mEnabledCount;
        }
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.mPhone.getContext());
        this.mAutoAttachOnCreation = sp.getBoolean("disabled_on_boot_key", false);
        this.mDataRoamingSettingObserver = new DataRoamingSettingObserver(this.mPhone, this.mPhone.getContext());
        this.mDataRoamingSettingObserver.register();
        HandlerThread dcHandlerThread = new HandlerThread("DcHandlerThread");
        dcHandlerThread.start();
        Handler dcHandler = new Handler(dcHandlerThread.getLooper());
        this.mDcc = DcController.makeDcc(this.mPhone, this, dcHandler);
        this.mDcTesterFailBringUpAll = new DcTesterFailBringUpAll(this.mPhone, dcHandler);
    }

    public void dispose() {
        this.log("DCT.dispose");
        for (DcAsyncChannel dcac : this.mDataConnectionAcHashMap.values()) {
            dcac.disconnect();
        }
        this.mDataConnectionAcHashMap.clear();
        this.mIsDisposed = true;
        this.mPhone.getContext().unregisterReceiver(this.mIntentReceiver);
        this.mUiccController.unregisterForIccChanged(this);
        this.mDataRoamingSettingObserver.unregister();
        this.mDcc.dispose();
        this.mDcTesterFailBringUpAll.dispose();
    }

    public DctConstants.Activity getActivity() {
        return this.mActivity;
    }

    void setActivity(DctConstants.Activity activity) {
        this.log("setActivity = " + (Object)((Object)activity));
        this.mActivity = activity;
        this.mPhone.notifyDataActivity();
    }

    public boolean isApnTypeActive(String type) {
        ApnSetting dunApn;
        if ("dun".equals(type) && (dunApn = this.fetchDunApn()) != null) {
            return this.mActiveApn != null && dunApn.toString().equals(this.mActiveApn.toString());
        }
        return this.mActiveApn != null && this.mActiveApn.canHandleType(type);
    }

    protected ApnSetting fetchDunApn() {
        if (SystemProperties.getBoolean("net.tethering.noprovisioning", false)) {
            this.log("fetchDunApn: net.tethering.noprovisioning=true ret: null");
            return null;
        }
        int bearer = -1;
        Context c = this.mPhone.getContext();
        String apnData = Settings.Global.getString(c.getContentResolver(), "tether_dun_apn");
        List<ApnSetting> dunSettings = ApnSetting.arrayFromString(apnData);
        for (ApnSetting dunSetting : dunSettings) {
            String operator;
            IccRecords r = this.mIccRecords.get();
            String string2 = operator = r != null ? r.getOperatorNumeric() : "";
            if (dunSetting.bearer != 0) {
                if (bearer == -1) {
                    bearer = this.mPhone.getServiceState().getRilDataRadioTechnology();
                }
                if (dunSetting.bearer != bearer) continue;
            }
            if (!dunSetting.numeric.equals(operator)) continue;
            if (dunSetting.hasMvnoParams()) {
                if (r == null || !this.mvnoMatches(r, dunSetting.mvnoType, dunSetting.mvnoMatchData)) continue;
                return dunSetting;
            }
            return dunSetting;
        }
        apnData = c.getResources().getString(17039385);
        ApnSetting dunSetting = ApnSetting.fromString(apnData);
        return dunSetting;
    }

    public String[] getActiveApnTypes() {
        String[] result = this.mActiveApn != null ? this.mActiveApn.types : new String[]{"default"};
        return result;
    }

    public String getActiveApnString(String apnType) {
        String result = null;
        if (this.mActiveApn != null) {
            result = this.mActiveApn.apn;
        }
        return result;
    }

    public void setDataOnRoamingEnabled(boolean enabled) {
        if (this.getDataOnRoamingEnabled() != enabled) {
            ContentResolver resolver = this.mPhone.getContext().getContentResolver();
            Settings.Global.putInt(resolver, "data_roaming", enabled ? 1 : 0);
        }
    }

    public boolean getDataOnRoamingEnabled() {
        try {
            ContentResolver resolver = this.mPhone.getContext().getContentResolver();
            return Settings.Global.getInt(resolver, "data_roaming") != 0;
        }
        catch (Settings.SettingNotFoundException snfe) {
            return false;
        }
    }

    public void setDataEnabled(boolean enable) {
        Message msg = this.obtainMessage(270366);
        msg.arg1 = enable ? 1 : 0;
        this.sendMessage(msg);
    }

    public boolean getDataEnabled() {
        try {
            ContentResolver resolver = this.mPhone.getContext().getContentResolver();
            return Settings.Global.getInt(resolver, "mobile_data") != 0;
        }
        catch (Settings.SettingNotFoundException snfe) {
            return false;
        }
    }

    protected abstract void restartRadio();

    protected abstract void log(String var1);

    protected abstract void loge(String var1);

    protected abstract boolean isDataAllowed();

    protected abstract boolean isApnTypeAvailable(String var1);

    public abstract DctConstants.State getState(String var1);

    protected abstract boolean isProvisioningApn(String var1);

    protected abstract void setState(DctConstants.State var1);

    protected abstract void gotoIdleAndNotifyDataConnection(String var1);

    protected abstract boolean onTrySetupData(String var1);

    protected abstract void onRoamingOff();

    protected abstract void onRoamingOn();

    protected abstract void onRadioAvailable();

    protected abstract void onRadioOffOrNotAvailable();

    protected abstract void onDataSetupComplete(AsyncResult var1);

    protected abstract void onDataSetupCompleteError(AsyncResult var1);

    protected abstract void onDisconnectDone(int var1, AsyncResult var2);

    protected abstract void onDisconnectDcRetrying(int var1, AsyncResult var2);

    protected abstract void onVoiceCallStarted();

    protected abstract void onVoiceCallEnded();

    protected abstract void onCleanUpConnection(boolean var1, int var2, String var3);

    protected abstract void onCleanUpAllConnections(String var1);

    public abstract boolean isDataPossible(String var1);

    protected abstract void onUpdateIcc();

    protected abstract void completeConnection(ApnContext var1);

    public abstract void setDataAllowed(boolean var1, Message var2);

    public abstract String[] getPcscfAddress(String var1);

    public abstract void setImsRegistrationState(boolean var1);

    protected abstract boolean mvnoMatches(IccRecords var1, String var2, String var3);

    protected abstract boolean isPermanentFail(DcFailCause var1);

    @Override
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 69636: {
                this.log("DISCONNECTED_CONNECTED: msg=" + msg);
                DcAsyncChannel dcac = (DcAsyncChannel)msg.obj;
                this.mDataConnectionAcHashMap.remove(dcac.getDataConnectionIdSync());
                dcac.disconnected();
                break;
            }
            case 270349: {
                this.onEnableApn(msg.arg1, msg.arg2);
                break;
            }
            case 270339: {
                String reason = null;
                if (msg.obj instanceof String) {
                    reason = (String)msg.obj;
                }
                this.onTrySetupData(reason);
                break;
            }
            case 270353: {
                this.onDataStallAlarm(msg.arg1);
                break;
            }
            case 270348: {
                this.onRoamingOff();
                break;
            }
            case 270347: {
                this.onRoamingOn();
                break;
            }
            case 270337: {
                this.onRadioAvailable();
                break;
            }
            case 270342: {
                this.onRadioOffOrNotAvailable();
                break;
            }
            case 270336: {
                this.mCidActive = msg.arg1;
                this.onDataSetupComplete((AsyncResult)msg.obj);
                break;
            }
            case 270371: {
                this.onDataSetupCompleteError((AsyncResult)msg.obj);
                break;
            }
            case 270351: {
                this.log("DataConnectionTracker.handleMessage: EVENT_DISCONNECT_DONE msg=" + msg);
                this.onDisconnectDone(msg.arg1, (AsyncResult)msg.obj);
                break;
            }
            case 270370: {
                this.log("DataConnectionTracker.handleMessage: EVENT_DISCONNECT_DC_RETRYING msg=" + msg);
                this.onDisconnectDcRetrying(msg.arg1, (AsyncResult)msg.obj);
                break;
            }
            case 270343: {
                this.onVoiceCallStarted();
                break;
            }
            case 270344: {
                this.onVoiceCallEnded();
                break;
            }
            case 270365: {
                this.onCleanUpAllConnections((String)msg.obj);
                break;
            }
            case 270360: {
                boolean tearDown = msg.arg1 != 0;
                this.onCleanUpConnection(tearDown, msg.arg2, (String)msg.obj);
                break;
            }
            case 270363: {
                boolean enabled = msg.arg1 == 1;
                this.onSetInternalDataEnabled(enabled);
                break;
            }
            case 270364: {
                this.log("EVENT_RESET_DONE");
                this.onResetDone((AsyncResult)msg.obj);
                break;
            }
            case 270366: {
                boolean enabled = msg.arg1 == 1;
                this.log("CMD_SET_USER_DATA_ENABLE enabled=" + enabled);
                this.onSetUserDataEnabled(enabled);
                break;
            }
            case 270367: {
                String apnType;
                boolean met = msg.arg1 == 1;
                this.log("CMD_SET_DEPENDENCY_MET met=" + met);
                Bundle bundle = msg.getData();
                if (bundle == null || (apnType = (String)bundle.get("apnType")) == null) break;
                this.onSetDependencyMet(apnType, met);
                break;
            }
            case 270368: {
                boolean enabled = msg.arg1 == 1;
                this.onSetPolicyDataEnabled(enabled);
                break;
            }
            case 270372: {
                this.log("CMD_SET_ENABLE_FAIL_FAST_MOBILE_DATA:  sEnableFailFastRefCounter=" + (sEnableFailFastRefCounter += msg.arg1 == 1 ? 1 : -1));
                if (sEnableFailFastRefCounter < 0) {
                    String s = "CMD_SET_ENABLE_FAIL_FAST_MOBILE_DATA: sEnableFailFastRefCounter:" + sEnableFailFastRefCounter + " < 0";
                    this.loge(s);
                    sEnableFailFastRefCounter = 0;
                }
                boolean enabled = sEnableFailFastRefCounter > 0;
                this.log("CMD_SET_ENABLE_FAIL_FAST_MOBILE_DATA: enabled=" + enabled + " sEnableFailFastRefCounter=" + sEnableFailFastRefCounter);
                if (this.mFailFast == enabled) break;
                this.mFailFast = enabled;
                boolean bl = this.mDataStallDetectionEnabled = !enabled;
                if (this.mDataStallDetectionEnabled && this.getOverallState() == DctConstants.State.CONNECTED && (!this.mInVoiceCall || this.mPhone.getServiceStateTracker().isConcurrentVoiceAndDataAllowed())) {
                    this.log("CMD_SET_ENABLE_FAIL_FAST_MOBILE_DATA: start data stall");
                    this.stopDataStallAlarm();
                    this.startDataStallAlarm(false);
                    break;
                }
                this.log("CMD_SET_ENABLE_FAIL_FAST_MOBILE_DATA: stop data stall");
                this.stopDataStallAlarm();
                break;
            }
            case 270373: {
                Bundle bundle = msg.getData();
                if (bundle != null) {
                    try {
                        this.mProvisioningUrl = (String)bundle.get("provisioningUrl");
                    }
                    catch (ClassCastException e) {
                        this.loge("CMD_ENABLE_MOBILE_PROVISIONING: provisioning url not a string" + e);
                        this.mProvisioningUrl = null;
                    }
                }
                if (TextUtils.isEmpty(this.mProvisioningUrl)) {
                    this.loge("CMD_ENABLE_MOBILE_PROVISIONING: provisioning url is empty, ignoring");
                    this.mIsProvisioning = false;
                    this.mProvisioningUrl = null;
                    break;
                }
                this.loge("CMD_ENABLE_MOBILE_PROVISIONING: provisioningUrl=" + this.mProvisioningUrl);
                this.mIsProvisioning = true;
                this.startProvisioningApnAlarm();
                break;
            }
            case 270375: {
                this.log("EVENT_PROVISIONING_APN_ALARM");
                ApnContext apnCtx = this.mApnContexts.get("default");
                if (apnCtx.isProvisioningApn() && apnCtx.isConnectedOrConnecting()) {
                    if (this.mProvisioningApnAlarmTag == msg.arg1) {
                        this.log("EVENT_PROVISIONING_APN_ALARM: Disconnecting");
                        this.mIsProvisioning = false;
                        this.mProvisioningUrl = null;
                        this.stopProvisioningApnAlarm();
                        this.sendCleanUpConnection(true, apnCtx);
                        break;
                    }
                    this.log("EVENT_PROVISIONING_APN_ALARM: ignore stale tag, mProvisioningApnAlarmTag:" + this.mProvisioningApnAlarmTag + " != arg1:" + msg.arg1);
                    break;
                }
                this.log("EVENT_PROVISIONING_APN_ALARM: Not connected ignore");
                break;
            }
            case 270374: {
                boolean isProvApn;
                this.log("CMD_IS_PROVISIONING_APN");
                try {
                    String apnType = null;
                    Bundle bundle = msg.getData();
                    if (bundle != null) {
                        apnType = (String)bundle.get("apnType");
                    }
                    if (TextUtils.isEmpty(apnType)) {
                        this.loge("CMD_IS_PROVISIONING_APN: apnType is empty");
                        isProvApn = false;
                    } else {
                        isProvApn = this.isProvisioningApn(apnType);
                    }
                }
                catch (ClassCastException e) {
                    this.loge("CMD_IS_PROVISIONING_APN: NO provisioning url ignoring");
                    isProvApn = false;
                }
                this.log("CMD_IS_PROVISIONING_APN: ret=" + isProvApn);
                this.mReplyAc.replyToMessage(msg, 270374, isProvApn ? 1 : 0);
                break;
            }
            case 270369: {
                this.onUpdateIcc();
                break;
            }
            case 270362: {
                this.restartRadio();
                break;
            }
            case 270376: {
                if (msg.arg1 == 1) {
                    this.handleStartNetStatPoll((DctConstants.Activity)((Object)msg.obj));
                    break;
                }
                if (msg.arg1 != 0) break;
                this.handleStopNetStatPoll((DctConstants.Activity)((Object)msg.obj));
                break;
            }
            default: {
                Rlog.e("DATA", "Unidentified event msg=" + msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getAnyDataEnabled() {
        boolean result;
        Object object = this.mDataEnabledLock;
        synchronized (object) {
            result = this.mInternalDataEnabled && this.mUserDataEnabled && sPolicyDataEnabled && this.mEnabledCount != 0;
        }
        if (!result) {
            this.log("getAnyDataEnabled " + result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isEmergency() {
        boolean result;
        Object object = this.mDataEnabledLock;
        synchronized (object) {
            result = this.mPhone.isInEcm() || this.mPhone.isInEmergencyCall();
        }
        this.log("isEmergency: result=" + result);
        return result;
    }

    protected int apnTypeToId(String type) {
        if (TextUtils.equals(type, "default")) {
            return 0;
        }
        if (TextUtils.equals(type, "mms")) {
            return 1;
        }
        if (TextUtils.equals(type, "supl")) {
            return 2;
        }
        if (TextUtils.equals(type, "dun")) {
            return 3;
        }
        if (TextUtils.equals(type, "hipri")) {
            return 4;
        }
        if (TextUtils.equals(type, "ims")) {
            return 5;
        }
        if (TextUtils.equals(type, "fota")) {
            return 6;
        }
        if (TextUtils.equals(type, "cbs")) {
            return 7;
        }
        if (TextUtils.equals(type, "ia")) {
            return 8;
        }
        if (TextUtils.equals(type, "emergency")) {
            return 9;
        }
        return -1;
    }

    protected String apnIdToType(int id2) {
        switch (id2) {
            case 0: {
                return "default";
            }
            case 1: {
                return "mms";
            }
            case 2: {
                return "supl";
            }
            case 3: {
                return "dun";
            }
            case 4: {
                return "hipri";
            }
            case 5: {
                return "ims";
            }
            case 6: {
                return "fota";
            }
            case 7: {
                return "cbs";
            }
            case 8: {
                return "ia";
            }
            case 9: {
                return "emergency";
            }
        }
        this.log("Unknown id (" + id2 + ") in apnIdToType");
        return "default";
    }

    public LinkProperties getLinkProperties(String apnType) {
        int id2 = this.apnTypeToId(apnType);
        if (this.isApnIdEnabled(id2)) {
            DcAsyncChannel dcac = this.mDataConnectionAcHashMap.get(0);
            return dcac.getLinkPropertiesSync();
        }
        return new LinkProperties();
    }

    public NetworkCapabilities getNetworkCapabilities(String apnType) {
        int id2 = this.apnTypeToId(apnType);
        if (this.isApnIdEnabled(id2)) {
            DcAsyncChannel dcac = this.mDataConnectionAcHashMap.get(0);
            return dcac.getNetworkCapabilitiesSync();
        }
        return new NetworkCapabilities();
    }

    protected void notifyDataConnection(String reason) {
        for (int id2 = 0; id2 < 10; ++id2) {
            if (!this.mDataEnabled[id2]) continue;
            this.mPhone.notifyDataConnection(reason, this.apnIdToType(id2));
        }
        this.notifyOffApnsOfAvailability(reason);
    }

    private void notifyApnIdUpToCurrent(String reason, int apnId) {
        switch (this.mState) {
            case IDLE: {
                break;
            }
            case RETRYING: 
            case CONNECTING: 
            case SCANNING: {
                this.mPhone.notifyDataConnection(reason, this.apnIdToType(apnId), PhoneConstants.DataState.CONNECTING);
                break;
            }
            case CONNECTED: 
            case DISCONNECTING: {
                this.mPhone.notifyDataConnection(reason, this.apnIdToType(apnId), PhoneConstants.DataState.CONNECTING);
                this.mPhone.notifyDataConnection(reason, this.apnIdToType(apnId), PhoneConstants.DataState.CONNECTED);
                break;
            }
        }
    }

    private void notifyApnIdDisconnected(String reason, int apnId) {
        this.mPhone.notifyDataConnection(reason, this.apnIdToType(apnId), PhoneConstants.DataState.DISCONNECTED);
    }

    protected void notifyOffApnsOfAvailability(String reason) {
        this.log("notifyOffApnsOfAvailability - reason= " + reason);
        for (int id2 = 0; id2 < 10; ++id2) {
            if (this.isApnIdEnabled(id2)) continue;
            this.notifyApnIdDisconnected(reason, id2);
        }
    }

    public boolean isApnTypeEnabled(String apnType) {
        if (apnType == null) {
            return false;
        }
        return this.isApnIdEnabled(this.apnTypeToId(apnType));
    }

    protected synchronized boolean isApnIdEnabled(int id2) {
        if (id2 != -1) {
            return this.mDataEnabled[id2];
        }
        return false;
    }

    protected void setEnabled(int id2, boolean enable) {
        this.log("setEnabled(" + id2 + ", " + enable + ") with old state = " + this.mDataEnabled[id2] + " and enabledCount = " + this.mEnabledCount);
        Message msg = this.obtainMessage(270349);
        msg.arg1 = id2;
        msg.arg2 = enable ? 1 : 0;
        this.sendMessage(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onEnableApn(int apnId, int enabled) {
        this.log("EVENT_APN_ENABLE_REQUEST apnId=" + apnId + ", apnType=" + this.apnIdToType(apnId) + ", enabled=" + enabled + ", dataEnabled = " + this.mDataEnabled[apnId] + ", enabledCount = " + this.mEnabledCount + ", isApnTypeActive = " + this.isApnTypeActive(this.apnIdToType(apnId)));
        if (enabled == 1) {
            DcTrackerBase dcTrackerBase = this;
            synchronized (dcTrackerBase) {
                if (!this.mDataEnabled[apnId]) {
                    this.mDataEnabled[apnId] = true;
                    ++this.mEnabledCount;
                }
            }
            String type = this.apnIdToType(apnId);
            if (!this.isApnTypeActive(type)) {
                this.mRequestedApnType = type;
                this.onEnableNewApn();
            } else {
                this.notifyApnIdUpToCurrent("apnSwitched", apnId);
            }
        } else {
            boolean didDisable = false;
            DcTrackerBase dcTrackerBase = this;
            synchronized (dcTrackerBase) {
                if (this.mDataEnabled[apnId]) {
                    this.mDataEnabled[apnId] = false;
                    --this.mEnabledCount;
                    didDisable = true;
                }
            }
            if (didDisable) {
                if (this.mEnabledCount == 0 || apnId == 3) {
                    this.mRequestedApnType = "default";
                    this.onCleanUpConnection(true, apnId, "dataDisabled");
                }
                this.notifyApnIdDisconnected("dataDisabled", apnId);
                if (this.mDataEnabled[0] && !this.isApnTypeActive("default")) {
                    this.mRequestedApnType = "default";
                    this.onEnableNewApn();
                }
            }
        }
    }

    protected void onEnableNewApn() {
    }

    protected void onResetDone(AsyncResult ar) {
        this.log("EVENT_RESET_DONE");
        String reason = null;
        if (ar.userObj instanceof String) {
            reason = (String)ar.userObj;
        }
        this.gotoIdleAndNotifyDataConnection(reason);
    }

    public boolean setInternalDataEnabled(boolean enable) {
        this.log("setInternalDataEnabled(" + enable + ")");
        Message msg = this.obtainMessage(270363);
        msg.arg1 = enable ? 1 : 0;
        this.sendMessage(msg);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onSetInternalDataEnabled(boolean enabled) {
        Object object = this.mDataEnabledLock;
        synchronized (object) {
            this.mInternalDataEnabled = enabled;
            if (enabled) {
                this.log("onSetInternalDataEnabled: changed to enabled, try to setup data call");
                this.onTrySetupData("dataEnabled");
            } else {
                this.log("onSetInternalDataEnabled: changed to disabled, cleanUpAllConnections");
                this.cleanUpAllConnections(null);
            }
        }
    }

    public void cleanUpAllConnections(String cause) {
        Message msg = this.obtainMessage(270365);
        msg.obj = cause;
        this.sendMessage(msg);
    }

    public abstract boolean isDisconnected();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onSetUserDataEnabled(boolean enabled) {
        Object object = this.mDataEnabledLock;
        synchronized (object) {
            boolean prevEnabled = this.getAnyDataEnabled();
            if (this.mUserDataEnabled != enabled) {
                this.mUserDataEnabled = enabled;
                Settings.Global.putInt(this.mPhone.getContext().getContentResolver(), "mobile_data", enabled ? 1 : 0);
                if (!this.getDataOnRoamingEnabled() && this.mPhone.getServiceState().getRoaming()) {
                    if (enabled) {
                        this.notifyOffApnsOfAvailability("roamingOn");
                    } else {
                        this.notifyOffApnsOfAvailability("dataDisabled");
                    }
                }
                if (prevEnabled != this.getAnyDataEnabled()) {
                    if (!prevEnabled) {
                        this.onTrySetupData("dataEnabled");
                    } else {
                        this.onCleanUpAllConnections("specificDisabled");
                    }
                }
            }
        }
    }

    protected void onSetDependencyMet(String apnType, boolean met) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onSetPolicyDataEnabled(boolean enabled) {
        Object object = this.mDataEnabledLock;
        synchronized (object) {
            boolean prevEnabled = this.getAnyDataEnabled();
            if (sPolicyDataEnabled != enabled) {
                sPolicyDataEnabled = enabled;
                if (prevEnabled != this.getAnyDataEnabled()) {
                    if (!prevEnabled) {
                        this.onTrySetupData("dataEnabled");
                    } else {
                        this.onCleanUpAllConnections("specificDisabled");
                    }
                }
            }
        }
    }

    protected String getReryConfig(boolean forDefault) {
        int nt = this.mPhone.getServiceState().getNetworkType();
        if (nt == 4 || nt == 7 || nt == 5 || nt == 6 || nt == 12 || nt == 14) {
            return SystemProperties.get("ro.cdma.data_retry_config");
        }
        if (forDefault) {
            return SystemProperties.get("ro.gsm.data_retry_config");
        }
        return SystemProperties.get("ro.gsm.2nd_data_retry_config");
    }

    protected void resetPollStats() {
        this.mTxPkts = -1L;
        this.mRxPkts = -1L;
        this.mNetStatPollPeriod = 1000;
    }

    protected abstract DctConstants.State getOverallState();

    void startNetStatPoll() {
        if (this.getOverallState() == DctConstants.State.CONNECTED && !this.mNetStatPollEnabled) {
            this.log("startNetStatPoll");
            this.resetPollStats();
            this.mNetStatPollEnabled = true;
            this.mPollNetStat.run();
        }
    }

    void stopNetStatPoll() {
        this.mNetStatPollEnabled = false;
        this.removeCallbacks(this.mPollNetStat);
        this.log("stopNetStatPoll");
    }

    public void sendStartNetStatPoll(DctConstants.Activity activity) {
        Message msg = this.obtainMessage(270376);
        msg.arg1 = 1;
        msg.obj = activity;
        this.sendMessage(msg);
    }

    protected void handleStartNetStatPoll(DctConstants.Activity activity) {
        this.startNetStatPoll();
        this.startDataStallAlarm(false);
        this.setActivity(activity);
    }

    public void sendStopNetStatPoll(DctConstants.Activity activity) {
        Message msg = this.obtainMessage(270376);
        msg.arg1 = 0;
        msg.obj = activity;
        this.sendMessage(msg);
    }

    protected void handleStopNetStatPoll(DctConstants.Activity activity) {
        this.stopNetStatPoll();
        this.stopDataStallAlarm();
        this.setActivity(activity);
    }

    public void updateDataActivity() {
        TxRxSum preTxRxSum = new TxRxSum(this.mTxPkts, this.mRxPkts);
        TxRxSum curTxRxSum = new TxRxSum();
        curTxRxSum.updateTxRxSum();
        this.mTxPkts = curTxRxSum.txPkts;
        this.mRxPkts = curTxRxSum.rxPkts;
        if (this.mNetStatPollEnabled && (preTxRxSum.txPkts > 0L || preTxRxSum.rxPkts > 0L)) {
            DctConstants.Activity newActivity;
            long sent = this.mTxPkts - preTxRxSum.txPkts;
            long received = this.mRxPkts - preTxRxSum.rxPkts;
            if (sent > 0L && received > 0L) {
                newActivity = DctConstants.Activity.DATAINANDOUT;
            } else if (sent > 0L && received == 0L) {
                newActivity = DctConstants.Activity.DATAOUT;
            } else if (sent == 0L && received > 0L) {
                newActivity = DctConstants.Activity.DATAIN;
            } else {
                DctConstants.Activity activity = newActivity = this.mActivity == DctConstants.Activity.DORMANT ? this.mActivity : DctConstants.Activity.NONE;
            }
            if (this.mActivity != newActivity && this.mIsScreenOn) {
                this.mActivity = newActivity;
                this.mPhone.notifyDataActivity();
            }
        }
    }

    public int getRecoveryAction() {
        int action = Settings.System.getInt(this.mPhone.getContext().getContentResolver(), "radio.data.stall.recovery.action", 0);
        this.log("getRecoveryAction: " + action);
        return action;
    }

    public void putRecoveryAction(int action) {
        Settings.System.putInt(this.mPhone.getContext().getContentResolver(), "radio.data.stall.recovery.action", action);
        this.log("putRecoveryAction: " + action);
    }

    protected boolean isConnected() {
        return false;
    }

    protected void doRecovery() {
        if (this.getOverallState() == DctConstants.State.CONNECTED) {
            int recoveryAction = this.getRecoveryAction();
            switch (recoveryAction) {
                case 0: {
                    EventLog.writeEvent(50118, this.mSentSinceLastRecv);
                    this.log("doRecovery() get data call list");
                    this.mPhone.mCi.getDataCallList(this.obtainMessage(270340));
                    this.putRecoveryAction(1);
                    break;
                }
                case 1: {
                    EventLog.writeEvent(50119, this.mSentSinceLastRecv);
                    this.log("doRecovery() cleanup all connections");
                    this.cleanUpAllConnections("pdpReset");
                    this.putRecoveryAction(2);
                    break;
                }
                case 2: {
                    EventLog.writeEvent(50120, this.mSentSinceLastRecv);
                    this.log("doRecovery() re-register");
                    this.mPhone.getServiceStateTracker().reRegisterNetwork(null);
                    this.putRecoveryAction(3);
                    break;
                }
                case 3: {
                    EventLog.writeEvent(50121, this.mSentSinceLastRecv);
                    this.log("restarting radio");
                    this.putRecoveryAction(4);
                    this.restartRadio();
                    break;
                }
                case 4: {
                    EventLog.writeEvent(50122, -1);
                    this.log("restarting radio with gsm.radioreset to true");
                    SystemProperties.set(this.RADIO_RESET_PROPERTY, "true");
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.restartRadio();
                    this.putRecoveryAction(0);
                    break;
                }
                default: {
                    throw new RuntimeException("doRecovery: Invalid recoveryAction=" + recoveryAction);
                }
            }
            this.mSentSinceLastRecv = 0L;
        }
    }

    private void updateDataStallInfo() {
        TxRxSum preTxRxSum = new TxRxSum(this.mDataStallTxRxSum);
        this.mDataStallTxRxSum.updateTxRxSum();
        this.log("updateDataStallInfo: mDataStallTxRxSum=" + this.mDataStallTxRxSum + " preTxRxSum=" + preTxRxSum);
        long sent = this.mDataStallTxRxSum.txPkts - preTxRxSum.txPkts;
        long received = this.mDataStallTxRxSum.rxPkts - preTxRxSum.rxPkts;
        if (sent > 0L && received > 0L) {
            this.log("updateDataStallInfo: IN/OUT");
            this.mSentSinceLastRecv = 0L;
            this.putRecoveryAction(0);
        } else if (sent > 0L && received == 0L) {
            this.mSentSinceLastRecv = this.mPhone.getState() == PhoneConstants.State.IDLE ? (this.mSentSinceLastRecv += sent) : 0L;
            this.log("updateDataStallInfo: OUT sent=" + sent + " mSentSinceLastRecv=" + this.mSentSinceLastRecv);
        } else if (sent == 0L && received > 0L) {
            this.log("updateDataStallInfo: IN");
            this.mSentSinceLastRecv = 0L;
            this.putRecoveryAction(0);
        } else {
            this.log("updateDataStallInfo: NONE");
        }
    }

    protected void onDataStallAlarm(int tag) {
        if (this.mDataStallAlarmTag != tag) {
            this.log("onDataStallAlarm: ignore, tag=" + tag + " expecting " + this.mDataStallAlarmTag);
            return;
        }
        this.updateDataStallInfo();
        int hangWatchdogTrigger = Settings.Global.getInt(this.mResolver, "pdp_watchdog_trigger_packet_count", 10);
        boolean suspectedStall = false;
        if (this.mSentSinceLastRecv >= (long)hangWatchdogTrigger) {
            this.log("onDataStallAlarm: tag=" + tag + " do recovery action=" + this.getRecoveryAction());
            suspectedStall = true;
            this.sendMessage(this.obtainMessage(270354));
        } else {
            this.log("onDataStallAlarm: tag=" + tag + " Sent " + String.valueOf(this.mSentSinceLastRecv) + " pkts since last received, < watchdogTrigger=" + hangWatchdogTrigger);
        }
        this.startDataStallAlarm(suspectedStall);
    }

    protected void startDataStallAlarm(boolean suspectedStall) {
        int nextAction = this.getRecoveryAction();
        if (this.mDataStallDetectionEnabled && this.getOverallState() == DctConstants.State.CONNECTED) {
            int delayInMs = this.mIsScreenOn || suspectedStall || RecoveryAction.isAggressiveRecovery(nextAction) ? Settings.Global.getInt(this.mResolver, "data_stall_alarm_aggressive_delay_in_ms", 60000) : Settings.Global.getInt(this.mResolver, "data_stall_alarm_non_aggressive_delay_in_ms", 360000);
            ++this.mDataStallAlarmTag;
            this.log("startDataStallAlarm: tag=" + this.mDataStallAlarmTag + " delay=" + delayInMs / 1000 + "s");
            Intent intent = new Intent(INTENT_DATA_STALL_ALARM);
            intent.putExtra(DATA_STALL_ALARM_TAG_EXTRA, this.mDataStallAlarmTag);
            this.mDataStallAlarmIntent = PendingIntent.getBroadcast(this.mPhone.getContext(), 0, intent, 0x8000000);
            this.mAlarmManager.set(2, SystemClock.elapsedRealtime() + (long)delayInMs, this.mDataStallAlarmIntent);
        } else {
            this.log("startDataStallAlarm: NOT started, no connection tag=" + this.mDataStallAlarmTag);
        }
    }

    protected void stopDataStallAlarm() {
        this.log("stopDataStallAlarm: current tag=" + this.mDataStallAlarmTag + " mDataStallAlarmIntent=" + this.mDataStallAlarmIntent);
        ++this.mDataStallAlarmTag;
        if (this.mDataStallAlarmIntent != null) {
            this.mAlarmManager.cancel(this.mDataStallAlarmIntent);
            this.mDataStallAlarmIntent = null;
        }
    }

    protected void restartDataStallAlarm() {
        if (!this.isConnected()) {
            return;
        }
        int nextAction = this.getRecoveryAction();
        if (RecoveryAction.isAggressiveRecovery(nextAction)) {
            this.log("restartDataStallAlarm: action is pending. not resetting the alarm.");
            return;
        }
        this.log("restartDataStallAlarm: stop then start.");
        this.stopDataStallAlarm();
        this.startDataStallAlarm(false);
    }

    protected void setInitialAttachApn() {
        ApnSetting iaApnSetting = null;
        ApnSetting defaultApnSetting = null;
        ApnSetting firstApnSetting = null;
        this.log("setInitialApn: E mPreferredApn=" + this.mPreferredApn);
        if (this.mAllApnSettings != null && !this.mAllApnSettings.isEmpty()) {
            firstApnSetting = this.mAllApnSettings.get(0);
            this.log("setInitialApn: firstApnSetting=" + firstApnSetting);
            for (ApnSetting apn : this.mAllApnSettings) {
                if (ArrayUtils.contains(apn.types, "ia") && apn.carrierEnabled) {
                    this.log("setInitialApn: iaApnSetting=" + apn);
                    iaApnSetting = apn;
                    break;
                }
                if (defaultApnSetting != null || !apn.canHandleType("default")) continue;
                this.log("setInitialApn: defaultApnSetting=" + apn);
                defaultApnSetting = apn;
            }
        }
        ApnSetting initialAttachApnSetting = null;
        if (iaApnSetting != null) {
            this.log("setInitialAttachApn: using iaApnSetting");
            initialAttachApnSetting = iaApnSetting;
        } else if (this.mPreferredApn != null) {
            this.log("setInitialAttachApn: using mPreferredApn");
            initialAttachApnSetting = this.mPreferredApn;
        } else if (defaultApnSetting != null) {
            this.log("setInitialAttachApn: using defaultApnSetting");
            initialAttachApnSetting = defaultApnSetting;
        } else if (firstApnSetting != null) {
            this.log("setInitialAttachApn: using firstApnSetting");
            initialAttachApnSetting = firstApnSetting;
        }
        if (initialAttachApnSetting == null) {
            this.log("setInitialAttachApn: X There in no available apn");
        } else {
            this.log("setInitialAttachApn: X selected Apn=" + initialAttachApnSetting);
            this.mPhone.mCi.setInitialAttachApn(initialAttachApnSetting.apn, initialAttachApnSetting.protocol, initialAttachApnSetting.authType, initialAttachApnSetting.user, initialAttachApnSetting.password, null);
        }
    }

    protected void setDataProfilesAsNeeded() {
        this.log("setDataProfilesAsNeeded");
        if (this.mAllApnSettings != null && !this.mAllApnSettings.isEmpty()) {
            ArrayList<DataProfile> dps = new ArrayList<DataProfile>();
            for (ApnSetting apn : this.mAllApnSettings) {
                if (!apn.modemCognitive) continue;
                DataProfile dp = new DataProfile(apn, this.mPhone.getServiceState().getRoaming());
                boolean isDup = false;
                for (DataProfile dpIn : dps) {
                    if (!dp.equals(dpIn)) continue;
                    isDup = true;
                    break;
                }
                if (isDup) continue;
                dps.add(dp);
            }
            if (dps.size() > 0) {
                this.mPhone.mCi.setDataProfile(dps.toArray(new DataProfile[0]), null);
            }
        }
    }

    protected void onActionIntentProvisioningApnAlarm(Intent intent) {
        this.log("onActionIntentProvisioningApnAlarm: action=" + intent.getAction());
        Message msg = this.obtainMessage(270375, intent.getAction());
        msg.arg1 = intent.getIntExtra(PROVISIONING_APN_ALARM_TAG_EXTRA, 0);
        this.sendMessage(msg);
    }

    protected void startProvisioningApnAlarm() {
        int delayInMs = Settings.Global.getInt(this.mResolver, "provisioning_apn_alarm_delay_in_ms", 900000);
        if (Build.IS_DEBUGGABLE) {
            String delayInMsStrg = Integer.toString(delayInMs);
            delayInMsStrg = System.getProperty(DEBUG_PROV_APN_ALARM, delayInMsStrg);
            try {
                delayInMs = Integer.parseInt(delayInMsStrg);
            }
            catch (NumberFormatException e) {
                this.loge("startProvisioningApnAlarm: e=" + e);
            }
        }
        ++this.mProvisioningApnAlarmTag;
        this.log("startProvisioningApnAlarm: tag=" + this.mProvisioningApnAlarmTag + " delay=" + delayInMs / 1000 + "s");
        Intent intent = new Intent(INTENT_PROVISIONING_APN_ALARM);
        intent.putExtra(PROVISIONING_APN_ALARM_TAG_EXTRA, this.mProvisioningApnAlarmTag);
        this.mProvisioningApnAlarmIntent = PendingIntent.getBroadcast(this.mPhone.getContext(), 0, intent, 0x8000000);
        this.mAlarmManager.set(2, SystemClock.elapsedRealtime() + (long)delayInMs, this.mProvisioningApnAlarmIntent);
    }

    protected void stopProvisioningApnAlarm() {
        this.log("stopProvisioningApnAlarm: current tag=" + this.mProvisioningApnAlarmTag + " mProvsioningApnAlarmIntent=" + this.mProvisioningApnAlarmIntent);
        ++this.mProvisioningApnAlarmTag;
        if (this.mProvisioningApnAlarmIntent != null) {
            this.mAlarmManager.cancel(this.mProvisioningApnAlarmIntent);
            this.mProvisioningApnAlarmIntent = null;
        }
    }

    void sendCleanUpConnection(boolean tearDown, ApnContext apnContext) {
        this.log("sendCleanUpConnection: tearDown=" + tearDown + " apnContext=" + apnContext);
        Message msg = this.obtainMessage(270360);
        msg.arg1 = tearDown ? 1 : 0;
        msg.arg2 = 0;
        msg.obj = apnContext;
        this.sendMessage(msg);
    }

    void sendRestartRadio() {
        this.log("sendRestartRadio:");
        Message msg = this.obtainMessage(270362);
        this.sendMessage(msg);
    }

    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("DataConnectionTrackerBase:");
        pw.println(" RADIO_TESTS=false");
        pw.println(" mInternalDataEnabled=" + this.mInternalDataEnabled);
        pw.println(" mUserDataEnabled=" + this.mUserDataEnabled);
        pw.println(" sPolicyDataEnabed=" + sPolicyDataEnabled);
        pw.println(" mDataEnabled:");
        for (int i = 0; i < this.mDataEnabled.length; ++i) {
            pw.printf("  mDataEnabled[%d]=%b\n", i, this.mDataEnabled[i]);
        }
        pw.flush();
        pw.println(" mEnabledCount=" + this.mEnabledCount);
        pw.println(" mRequestedApnType=" + this.mRequestedApnType);
        pw.println(" mPhone=" + this.mPhone.getPhoneName());
        pw.println(" mActivity=" + (Object)((Object)this.mActivity));
        pw.println(" mState=" + (Object)((Object)this.mState));
        pw.println(" mTxPkts=" + this.mTxPkts);
        pw.println(" mRxPkts=" + this.mRxPkts);
        pw.println(" mNetStatPollPeriod=" + this.mNetStatPollPeriod);
        pw.println(" mNetStatPollEnabled=" + this.mNetStatPollEnabled);
        pw.println(" mDataStallTxRxSum=" + this.mDataStallTxRxSum);
        pw.println(" mDataStallAlarmTag=" + this.mDataStallAlarmTag);
        pw.println(" mDataStallDetectionEanbled=" + this.mDataStallDetectionEnabled);
        pw.println(" mSentSinceLastRecv=" + this.mSentSinceLastRecv);
        pw.println(" mNoRecvPollCount=" + this.mNoRecvPollCount);
        pw.println(" mResolver=" + this.mResolver);
        pw.println(" mIsWifiConnected=" + this.mIsWifiConnected);
        pw.println(" mReconnectIntent=" + this.mReconnectIntent);
        pw.println(" mCidActive=" + this.mCidActive);
        pw.println(" mAutoAttachOnCreation=" + this.mAutoAttachOnCreation);
        pw.println(" mIsScreenOn=" + this.mIsScreenOn);
        pw.println(" mUniqueIdGenerator=" + this.mUniqueIdGenerator);
        pw.flush();
        pw.println(" ***************************************");
        DcController dcc = this.mDcc;
        if (dcc != null) {
            dcc.dump(fd, pw, args);
        } else {
            pw.println(" mDcc=null");
        }
        pw.println(" ***************************************");
        HashMap<Integer, DataConnection> dcs = this.mDataConnections;
        if (dcs != null) {
            Set<Map.Entry<Integer, DataConnection>> mDcSet = this.mDataConnections.entrySet();
            pw.println(" mDataConnections: count=" + mDcSet.size());
            for (Map.Entry<Integer, DataConnection> entry : mDcSet) {
                pw.printf(" *** mDataConnection[%d] \n", entry.getKey());
                entry.getValue().dump(fd, pw, args);
            }
        } else {
            pw.println("mDataConnections=null");
        }
        pw.println(" ***************************************");
        pw.flush();
        HashMap<String, Integer> apnToDcId = this.mApnToDataConnectionId;
        if (apnToDcId != null) {
            Set<Map.Entry<String, Integer>> apnToDcIdSet = apnToDcId.entrySet();
            pw.println(" mApnToDataConnectonId size=" + apnToDcIdSet.size());
            for (Map.Entry<String, Integer> entry : apnToDcIdSet) {
                pw.printf(" mApnToDataConnectonId[%s]=%d\n", entry.getKey(), entry.getValue());
            }
        } else {
            pw.println("mApnToDataConnectionId=null");
        }
        pw.println(" ***************************************");
        pw.flush();
        ConcurrentHashMap<String, ApnContext> apnCtxs = this.mApnContexts;
        if (apnCtxs != null) {
            Set<Map.Entry<String, ApnContext>> apnCtxsSet = apnCtxs.entrySet();
            pw.println(" mApnContexts size=" + apnCtxsSet.size());
            for (Map.Entry<String, ApnContext> entry : apnCtxsSet) {
                entry.getValue().dump(fd, pw, args);
            }
            pw.println(" ***************************************");
        } else {
            pw.println(" mApnContexts=null");
        }
        pw.flush();
        pw.println(" mActiveApn=" + this.mActiveApn);
        ArrayList<ApnSetting> apnSettings = this.mAllApnSettings;
        if (apnSettings != null) {
            pw.println(" mAllApnSettings size=" + apnSettings.size());
            for (int i = 0; i < apnSettings.size(); ++i) {
                pw.printf(" mAllApnSettings[%d]: %s\n", i, apnSettings.get(i));
            }
            pw.flush();
        } else {
            pw.println(" mAllApnSettings=null");
        }
        pw.println(" mPreferredApn=" + this.mPreferredApn);
        pw.println(" mIsPsRestricted=" + this.mIsPsRestricted);
        pw.println(" mIsDisposed=" + this.mIsDisposed);
        pw.println(" mIntentReceiver=" + this.mIntentReceiver);
        pw.println(" mDataRoamingSettingObserver=" + this.mDataRoamingSettingObserver);
        pw.flush();
    }

    protected static class RecoveryAction {
        public static final int GET_DATA_CALL_LIST = 0;
        public static final int CLEANUP = 1;
        public static final int REREGISTER = 2;
        public static final int RADIO_RESTART = 3;
        public static final int RADIO_RESTART_WITH_PROP = 4;

        protected RecoveryAction() {
        }

        private static boolean isAggressiveRecovery(int value) {
            return value == 1 || value == 2 || value == 3 || value == 4;
        }
    }

    public class TxRxSum {
        public long txPkts;
        public long rxPkts;

        public TxRxSum() {
            this.reset();
        }

        public TxRxSum(long txPkts, long rxPkts) {
            this.txPkts = txPkts;
            this.rxPkts = rxPkts;
        }

        public TxRxSum(TxRxSum sum) {
            this.txPkts = sum.txPkts;
            this.rxPkts = sum.rxPkts;
        }

        public void reset() {
            this.txPkts = -1L;
            this.rxPkts = -1L;
        }

        public String toString() {
            return "{txSum=" + this.txPkts + " rxSum=" + this.rxPkts + "}";
        }

        public void updateTxRxSum() {
            this.txPkts = TrafficStats.getMobileTcpTxPackets();
            this.rxPkts = TrafficStats.getMobileTcpRxPackets();
        }
    }

    private class DataRoamingSettingObserver
    extends ContentObserver {
        public DataRoamingSettingObserver(Handler handler, Context context) {
            super(handler);
            DcTrackerBase.this.mResolver = context.getContentResolver();
        }

        public void register() {
            DcTrackerBase.this.mResolver.registerContentObserver(Settings.Global.getUriFor("data_roaming"), false, this);
        }

        public void unregister() {
            DcTrackerBase.this.mResolver.unregisterContentObserver(this);
        }

        @Override
        public void onChange(boolean selfChange) {
            if (DcTrackerBase.this.mPhone.getServiceState().getRoaming()) {
                DcTrackerBase.this.sendMessage(DcTrackerBase.this.obtainMessage(270347));
            }
        }
    }
}

