/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.dataconnection;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.Registrant;
import android.os.RegistrantList;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import android.telephony.SubscriptionManager;
import android.util.Log;
import com.android.internal.telephony.DefaultPhoneNotifier;
import com.android.internal.telephony.IccCardConstants;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneBase;
import com.android.internal.telephony.PhoneConstants;
import com.android.internal.telephony.PhoneProxy;
import com.android.internal.telephony.SubscriptionController;
import com.android.internal.telephony.dataconnection.DcSwitchAsyncChannel;
import com.android.internal.telephony.dataconnection.DcSwitchState;
import com.android.internal.telephony.dataconnection.DcTrackerBase;
import java.util.HashSet;
import java.util.Iterator;

public class DctController
extends Handler {
    private static final String LOG_TAG = "DctController";
    private static final boolean DBG = true;
    private static final int EVENT_PHONE1_DETACH = 1;
    private static final int EVENT_PHONE2_DETACH = 2;
    private static final int EVENT_PHONE3_DETACH = 3;
    private static final int EVENT_PHONE4_DETACH = 4;
    private static final int EVENT_PHONE1_RADIO_OFF = 5;
    private static final int EVENT_PHONE2_RADIO_OFF = 6;
    private static final int EVENT_PHONE3_RADIO_OFF = 7;
    private static final int EVENT_PHONE4_RADIO_OFF = 8;
    private static final int PHONE_NONE = -1;
    private static DctController sDctController;
    private static final int EVENT_ALL_DATA_DISCONNECTED = 1;
    private static final int EVENT_SET_DATA_ALLOW_DONE = 2;
    private RegistrantList mNotifyDataSwitchInfo = new RegistrantList();
    private SubscriptionController mSubController = SubscriptionController.getInstance();
    private Phone mActivePhone;
    private int mPhoneNum;
    private boolean[] mServicePowerOffFlag;
    private PhoneProxy[] mPhones;
    private DcSwitchState[] mDcSwitchState;
    private DcSwitchAsyncChannel[] mDcSwitchAsyncChannel;
    private Handler[] mDcSwitchStateHandler;
    private HashSet<String> mApnTypes = new HashSet();
    private BroadcastReceiver mDataStateReceiver;
    private Context mContext;
    private int mCurrentDataPhone = -1;
    private int mRequestedDataPhone = -1;
    private Handler mRspHander = new Handler(){

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    DctController.logd("EVENT_PHONE" + msg.what + "_DETACH: mRequestedDataPhone=" + DctController.this.mRequestedDataPhone);
                    DctController.this.mCurrentDataPhone = -1;
                    if (DctController.this.mRequestedDataPhone == -1) break;
                    DctController.this.mCurrentDataPhone = DctController.this.mRequestedDataPhone;
                    DctController.this.mRequestedDataPhone = -1;
                    Iterator itrType = DctController.this.mApnTypes.iterator();
                    while (itrType.hasNext()) {
                        DctController.this.mDcSwitchAsyncChannel[DctController.this.mCurrentDataPhone].connectSync((String)itrType.next());
                    }
                    DctController.this.mApnTypes.clear();
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    DctController.logd("EVENT_PHONE" + (msg.what - 5 + 1) + "_RADIO_OFF.");
                    ((DctController)DctController.this).mServicePowerOffFlag[msg.what - 5] = true;
                    break;
                }
            }
        }
    };
    private DefaultPhoneNotifier.IDataStateChangedCallback mDataStateChangedCallback = new DefaultPhoneNotifier.IDataStateChangedCallback(){

        @Override
        public void onDataStateChanged(long subId, String state, String reason, String apnName, String apnType, boolean unavailable) {
            DctController.logd("[DataStateChanged]:state=" + state + ",reason=" + reason + ",apnName=" + apnName + ",apnType=" + apnType + ",from subId=" + subId);
            int phoneId = SubscriptionManager.getPhoneId(subId);
            DctController.this.mDcSwitchState[phoneId].notifyDataConnection(phoneId, state, reason, apnName, apnType, unavailable);
        }
    };

    public DefaultPhoneNotifier.IDataStateChangedCallback getDataStateChangedCallback() {
        return this.mDataStateChangedCallback;
    }

    public static DctController getInstance() {
        if (sDctController == null) {
            throw new RuntimeException("DCTrackerController.getInstance can't be called before makeDCTController()");
        }
        return sDctController;
    }

    public static DctController makeDctController(PhoneProxy[] phones) {
        if (sDctController == null) {
            sDctController = new DctController(phones);
        }
        return sDctController;
    }

    private DctController(PhoneProxy[] phones) {
        if (phones == null || phones.length == 0) {
            if (phones == null) {
                DctController.loge("DctController(phones): UNEXPECTED phones=null, ignore");
            } else {
                DctController.loge("DctController(phones): UNEXPECTED phones.length=0, ignore");
            }
            return;
        }
        this.mPhoneNum = phones.length;
        this.mServicePowerOffFlag = new boolean[this.mPhoneNum];
        this.mPhones = phones;
        this.mDcSwitchState = new DcSwitchState[this.mPhoneNum];
        this.mDcSwitchAsyncChannel = new DcSwitchAsyncChannel[this.mPhoneNum];
        this.mDcSwitchStateHandler = new Handler[this.mPhoneNum];
        this.mActivePhone = this.mPhones[0];
        for (int i = 0; i < this.mPhoneNum; ++i) {
            int phoneId = i;
            this.mServicePowerOffFlag[i] = true;
            this.mDcSwitchState[i] = new DcSwitchState(this.mPhones[i], "DcSwitchState-" + phoneId, phoneId);
            this.mDcSwitchState[i].start();
            this.mDcSwitchAsyncChannel[i] = new DcSwitchAsyncChannel(this.mDcSwitchState[i], phoneId);
            this.mDcSwitchStateHandler[i] = new Handler();
            int status = this.mDcSwitchAsyncChannel[i].fullyConnectSync(this.mPhones[i].getContext(), this.mDcSwitchStateHandler[i], this.mDcSwitchState[i].getHandler());
            if (status == 0) {
                DctController.logd("DctController(phones): Connect success: " + i);
            } else {
                DctController.loge("DctController(phones): Could not connect to " + i);
            }
            this.mDcSwitchState[i].registerForIdle(this.mRspHander, 1 + i, null);
            PhoneBase phoneBase = (PhoneBase)this.mPhones[i].getActivePhone();
            phoneBase.mCi.registerForOffOrNotAvailable(this.mRspHander, 5 + i, null);
        }
        this.mContext = this.mActivePhone.getContext();
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.DATA_CONNECTION_FAILED");
        filter.addAction("android.intent.action.SERVICE_STATE");
        this.mDataStateReceiver = new DataStateReceiver();
        Intent intent = this.mContext.registerReceiver(this.mDataStateReceiver, filter);
    }

    private IccCardConstants.State getIccCardState(int phoneId) {
        return this.mPhones[phoneId].getIccCard().getState();
    }

    public synchronized int enableApnType(long subId, String type) {
        int phoneId = SubscriptionManager.getPhoneId(subId);
        if (phoneId == -1 || !this.isValidphoneId(phoneId)) {
            DctController.logw("enableApnType(): with PHONE_NONE or Invalid PHONE ID");
            return 3;
        }
        DctController.logd("enableApnType():type=" + type + ",phoneId=" + phoneId + ",powerOff=" + this.mServicePowerOffFlag[phoneId]);
        if (!"default".equals(type)) {
            for (int peerphoneId = 0; peerphoneId < this.mPhoneNum; ++peerphoneId) {
                String[] activeApnTypes;
                if (phoneId == peerphoneId || (activeApnTypes = this.mPhones[peerphoneId].getActiveApnTypes()) == null || activeApnTypes.length == 0) continue;
                for (int i = 0; i < activeApnTypes.length; ++i) {
                    if ("default".equals(activeApnTypes[i]) || this.mPhones[peerphoneId].getDataConnectionState(activeApnTypes[i]) == PhoneConstants.DataState.DISCONNECTED) continue;
                    DctController.logd("enableApnType:Peer Phone still have non-default active APN type:activeApnTypes[" + i + "]=" + activeApnTypes[i]);
                    return 3;
                }
            }
        }
        DctController.logd("enableApnType(): CurrentDataPhone=" + this.mCurrentDataPhone + ", RequestedDataPhone=" + this.mRequestedDataPhone);
        if (phoneId == this.mCurrentDataPhone && !this.mDcSwitchAsyncChannel[this.mCurrentDataPhone].isIdleOrDeactingSync()) {
            this.mRequestedDataPhone = -1;
            DctController.logd("enableApnType(): mRequestedDataPhone equals request PHONE ID.");
            return this.mDcSwitchAsyncChannel[phoneId].connectSync(type);
        }
        if (this.mCurrentDataPhone == -1) {
            this.mCurrentDataPhone = phoneId;
            this.mRequestedDataPhone = -1;
            DctController.logd("enableApnType(): current PHONE is NONE or IDLE, mCurrentDataPhone=" + this.mCurrentDataPhone);
            return this.mDcSwitchAsyncChannel[phoneId].connectSync(type);
        }
        DctController.logd("enableApnType(): current PHONE:" + this.mCurrentDataPhone + " is active.");
        if (phoneId != this.mRequestedDataPhone) {
            this.mApnTypes.clear();
        }
        this.mApnTypes.add(type);
        this.mRequestedDataPhone = phoneId;
        this.mDcSwitchState[this.mCurrentDataPhone].cleanupAllConnection();
        return 1;
    }

    public synchronized int disableApnType(long subId, String type) {
        int phoneId = SubscriptionManager.getPhoneId(subId);
        if (phoneId == -1 || !this.isValidphoneId(phoneId)) {
            DctController.logw("disableApnType(): with PHONE_NONE or Invalid PHONE ID");
            return 3;
        }
        DctController.logd("disableApnType():type=" + type + ",phoneId=" + phoneId + ",powerOff=" + this.mServicePowerOffFlag[phoneId]);
        return this.mDcSwitchAsyncChannel[phoneId].disconnectSync(type);
    }

    public boolean isDataConnectivityPossible(String type, int phoneId) {
        if (phoneId == -1 || !this.isValidphoneId(phoneId)) {
            DctController.logw("isDataConnectivityPossible(): with PHONE_NONE or Invalid PHONE ID");
            return false;
        }
        return this.mPhones[phoneId].isDataConnectivityPossible(type);
    }

    public boolean isIdleOrDeacting(int phoneId) {
        return this.mDcSwitchAsyncChannel[phoneId].isIdleOrDeactingSync();
    }

    private boolean isValidphoneId(int phoneId) {
        return phoneId >= 0 && phoneId <= this.mPhoneNum;
    }

    private boolean isValidApnType(String apnType) {
        return apnType.equals("default") || apnType.equals("mms") || apnType.equals("supl") || apnType.equals("dun") || apnType.equals("hipri") || apnType.equals("fota") || apnType.equals("ims") || apnType.equals("cbs");
    }

    private int getDataConnectionFromSetting() {
        long[] subId = SubscriptionManager.getSubId(0);
        int phoneId = SubscriptionManager.getPhoneId(subId[0]);
        return phoneId;
    }

    private static void logv(String s) {
        Log.v(LOG_TAG, "[DctController] " + s);
    }

    private static void logd(String s) {
        Log.d(LOG_TAG, "[DctController] " + s);
    }

    private static void logw(String s) {
        Log.w(LOG_TAG, "[DctController] " + s);
    }

    private static void loge(String s) {
        Log.e(LOG_TAG, "[DctController] " + s);
    }

    public void setDataSubId(long subId) {
        Rlog.d(LOG_TAG, "setDataAllowed subId :" + subId);
        int phoneId = this.mSubController.getPhoneId(subId);
        int prefPhoneId = this.mSubController.getPhoneId(this.mSubController.getDefaultDataSubId());
        Phone phone = this.mPhones[prefPhoneId].getActivePhone();
        DcTrackerBase dcTracker = ((PhoneBase)phone).mDcTracker;
        dcTracker.setDataAllowed(false, null);
        this.mPhones[prefPhoneId].registerForAllDataDisconnected(this, 1, new Integer(phoneId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerForDataSwitchInfo(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        RegistrantList registrantList = this.mNotifyDataSwitchInfo;
        synchronized (registrantList) {
            this.mNotifyDataSwitchInfo.add(r);
        }
    }

    @Override
    public void handleMessage(Message msg) {
        AsyncResult ar = (AsyncResult)msg.obj;
        Rlog.d(LOG_TAG, "handleMessage msg=" + msg);
        switch (msg.what) {
            case 1: {
                Integer phoneId = (Integer)ar.userObj;
                int prefPhoneId = this.mSubController.getPhoneId(this.mSubController.getDefaultDataSubId());
                Rlog.d(LOG_TAG, "EVENT_ALL_DATA_DISCONNECTED phoneId :" + phoneId);
                this.mPhones[prefPhoneId].unregisterForAllDataDisconnected(this);
                Message alllowedDataDone = Message.obtain(this, 2, new Integer(phoneId));
                Phone phone = this.mPhones[phoneId].getActivePhone();
                DcTrackerBase dcTracker = ((PhoneBase)phone).mDcTracker;
                dcTracker.setDataAllowed(true, alllowedDataDone);
                break;
            }
            case 2: {
                Integer phoneId = (Integer)ar.userObj;
                long[] subId = this.mSubController.getSubId(phoneId);
                Rlog.d(LOG_TAG, "EVENT_SET_DATA_ALLOWED_DONE  phoneId :" + subId[0]);
                this.mNotifyDataSwitchInfo.notifyRegistrants(new AsyncResult(null, subId[0], null));
                this.mPhones[phoneId].updateDataConnectionTracker();
            }
        }
    }

    private class DataStateReceiver
    extends BroadcastReceiver {
        private DataStateReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            DataStateReceiver dataStateReceiver = this;
            synchronized (dataStateReceiver) {
                if (intent.getAction().equals("android.intent.action.SERVICE_STATE")) {
                    ServiceState ss = ServiceState.newFromBundle(intent.getExtras());
                    long subId = intent.getLongExtra("subscription", 0L);
                    int phoneId = SubscriptionManager.getPhoneId(subId);
                    DctController.logd("DataStateReceiver: phoneId= " + phoneId);
                    if (!SubscriptionManager.isValidSubId(subId) || subId < 0L) {
                        DctController.logd("DataStateReceiver: ignore invalid subId=" + subId);
                        return;
                    }
                    if (!SubscriptionManager.isValidPhoneId(phoneId)) {
                        DctController.logd("DataStateReceiver: ignore invalid phoneId=" + phoneId);
                        return;
                    }
                    boolean prevPowerOff = DctController.this.mServicePowerOffFlag[phoneId];
                    if (ss != null) {
                        int state = ss.getState();
                        switch (state) {
                            case 3: {
                                ((DctController)DctController.this).mServicePowerOffFlag[phoneId] = true;
                                DctController.logd("DataStateReceiver: STATE_POWER_OFF Intent from phoneId=" + phoneId);
                                break;
                            }
                            case 0: {
                                ((DctController)DctController.this).mServicePowerOffFlag[phoneId] = false;
                                DctController.logd("DataStateReceiver: STATE_IN_SERVICE Intent from phoneId=" + phoneId);
                                break;
                            }
                            case 1: {
                                DctController.logd("DataStateReceiver: STATE_OUT_OF_SERVICE Intent from phoneId=" + phoneId);
                                if (!DctController.this.mServicePowerOffFlag[phoneId]) break;
                                ((DctController)DctController.this).mServicePowerOffFlag[phoneId] = false;
                                break;
                            }
                            case 2: {
                                DctController.logd("DataStateReceiver: STATE_EMERGENCY_ONLY Intent from phoneId=" + phoneId);
                                break;
                            }
                            default: {
                                DctController.logd("DataStateReceiver: SERVICE_STATE_CHANGED invalid state");
                            }
                        }
                        if (prevPowerOff && !DctController.this.mServicePowerOffFlag[phoneId] && DctController.this.mCurrentDataPhone == -1 && phoneId == DctController.this.getDataConnectionFromSetting()) {
                            DctController.logd("DataStateReceiver: Current Phone is none and default phoneId=" + phoneId + ", then enableApnType()");
                            DctController.this.enableApnType(subId, "default");
                        }
                    }
                }
            }
        }
    }
}

