/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.imsphone;

import android.telephony.Rlog;
import com.android.ims.ImsCall;
import com.android.ims.ImsException;
import com.android.ims.ImsStreamMediaProfile;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.imsphone.ImsPhoneCallTracker;
import com.android.internal.telephony.imsphone.ImsPhoneConnection;
import java.util.List;

public class ImsPhoneCall
extends Call {
    private static final String LOG_TAG = "ImsPhoneCall";
    ImsPhoneCallTracker mOwner;
    private boolean mRingbackTonePlayed = false;

    ImsPhoneCall() {
    }

    ImsPhoneCall(ImsPhoneCallTracker owner) {
        this.mOwner = owner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        try {
            this.mOwner.hangup(this);
        }
        catch (CallStateException ex) {
            int s = this.mConnections.size();
            for (int i = 0; i < s; ++i) {
                ImsPhoneConnection c = (ImsPhoneConnection)this.mConnections.get(i);
                c.onDisconnect(14);
            }
        }
        finally {
            int s = this.mConnections.size();
            for (int i = 0; i < s; ++i) {
                ImsPhoneConnection c = (ImsPhoneConnection)this.mConnections.get(i);
                c.onDisconnect(14);
            }
        }
    }

    @Override
    public List<Connection> getConnections() {
        return this.mConnections;
    }

    @Override
    public Phone getPhone() {
        return this.mOwner.mPhone;
    }

    @Override
    public boolean isMultiparty() {
        return this.mConnections.size() > 1;
    }

    @Override
    public void hangup() throws CallStateException {
        this.mOwner.hangup(this);
    }

    public String toString() {
        return this.mState.toString();
    }

    void attach(Connection conn) {
        this.clearDisconnected();
        this.mConnections.add(conn);
    }

    void attach(Connection conn, Call.State state) {
        this.attach(conn);
        this.mState = state;
    }

    void attachFake(Connection conn, Call.State state) {
        this.attach(conn, state);
    }

    boolean connectionDisconnected(ImsPhoneConnection conn) {
        if (this.mState != Call.State.DISCONNECTED) {
            boolean hasOnlyDisconnectedConnections = true;
            int s = this.mConnections.size();
            for (int i = 0; i < s; ++i) {
                if (((Connection)this.mConnections.get(i)).getState() == Call.State.DISCONNECTED) continue;
                hasOnlyDisconnectedConnections = false;
                break;
            }
            if (hasOnlyDisconnectedConnections) {
                this.mState = Call.State.DISCONNECTED;
                return true;
            }
        }
        return false;
    }

    void detach(ImsPhoneConnection conn) {
        this.mConnections.remove(conn);
        if (this.mConnections.size() == 0) {
            this.mState = Call.State.IDLE;
        }
    }

    boolean isFull() {
        return this.mConnections.size() == 5;
    }

    void onHangupLocal() {
        int s = this.mConnections.size();
        for (int i = 0; i < s; ++i) {
            ImsPhoneConnection cn = (ImsPhoneConnection)this.mConnections.get(i);
            cn.onHangupLocal();
        }
        this.mState = Call.State.DISCONNECTING;
    }

    void clearDisconnected() {
        for (int i = this.mConnections.size() - 1; i >= 0; --i) {
            ImsPhoneConnection cn = (ImsPhoneConnection)this.mConnections.get(i);
            if (cn.getState() != Call.State.DISCONNECTED) continue;
            this.mConnections.remove(i);
        }
        if (this.mConnections.size() == 0) {
            this.mState = Call.State.IDLE;
        }
    }

    ImsPhoneConnection getFirstConnection() {
        if (this.mConnections.size() == 0) {
            return null;
        }
        return (ImsPhoneConnection)this.mConnections.get(0);
    }

    void setMute(boolean mute) {
        ImsCall imsCall;
        ImsCall imsCall2 = imsCall = this.getFirstConnection() == null ? null : this.getFirstConnection().getImsCall();
        if (imsCall != null) {
            try {
                imsCall.setMute(mute);
            }
            catch (ImsException e) {
                Rlog.e(LOG_TAG, "setMute failed : " + e.getMessage());
            }
        }
    }

    void merge(ImsPhoneCall that, Call.State state) {
        ImsPhoneConnection[] cc;
        for (ImsPhoneConnection c : cc = that.mConnections.toArray(new ImsPhoneConnection[that.mConnections.size()])) {
            c.update(null, state);
        }
    }

    ImsCall getImsCall() {
        return this.getFirstConnection() == null ? null : this.getFirstConnection().getImsCall();
    }

    static boolean isLocalTone(ImsCall imsCall) {
        if (imsCall == null || imsCall.getCallProfile() == null || imsCall.getCallProfile().mMediaProfile == null) {
            return false;
        }
        ImsStreamMediaProfile mediaProfile = imsCall.getCallProfile().mMediaProfile;
        return mediaProfile.mAudioDirection == 0;
    }

    boolean update(ImsPhoneConnection conn, ImsCall imsCall, Call.State state) {
        Call.State newState = state;
        boolean changed = false;
        if (state == Call.State.ALERTING) {
            if (this.mRingbackTonePlayed && !ImsPhoneCall.isLocalTone(imsCall)) {
                this.mOwner.mPhone.stopRingbackTone();
                this.mRingbackTonePlayed = false;
            } else if (!this.mRingbackTonePlayed && ImsPhoneCall.isLocalTone(imsCall)) {
                this.mOwner.mPhone.startRingbackTone();
                this.mRingbackTonePlayed = true;
            }
        } else if (this.mRingbackTonePlayed) {
            this.mOwner.mPhone.stopRingbackTone();
            this.mRingbackTonePlayed = false;
        }
        if (newState != this.mState && state != Call.State.DISCONNECTED) {
            this.mState = newState;
            changed = true;
        } else if (state == Call.State.DISCONNECTED) {
            changed = true;
        }
        return changed;
    }

    ImsPhoneConnection getHandoverConnection() {
        ImsPhoneConnection conn = (ImsPhoneConnection)this.getEarliestConnection();
        if (conn != null) {
            conn.setMultiparty(this.isMultiparty());
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void switchWith(ImsPhoneCall that) {
        Class<ImsPhoneCall> clazz = ImsPhoneCall.class;
        synchronized (ImsPhoneCall.class) {
            ImsPhoneCall tmp = new ImsPhoneCall();
            tmp.takeOver(this);
            this.takeOver(that);
            that.takeOver(tmp);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private void takeOver(ImsPhoneCall that) {
        this.mConnections = that.mConnections;
        this.mState = that.mState;
        for (Connection c : this.mConnections) {
            ((ImsPhoneConnection)c).changeParent(this);
        }
    }
}

