/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.imsphone;

import android.content.Context;
import android.content.res.Resources;
import android.os.AsyncResult;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.telephony.PhoneNumberUtils;
import android.telephony.Rlog;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import com.android.ims.ImsException;
import com.android.ims.ImsSsInfo;
import com.android.internal.telephony.CallForwardInfo;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.MmiCode;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.imsphone.ImsPhone;
import com.android.internal.telephony.uicc.IccRecords;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ImsPhoneMmiCode
extends Handler
implements MmiCode {
    static final String LOG_TAG = "ImsPhoneMmiCode";
    private static final int MAX_LENGTH_SHORT_CODE = 2;
    private static final char END_OF_USSD_COMMAND = '#';
    private static final String ACTION_ACTIVATE = "*";
    private static final String ACTION_DEACTIVATE = "#";
    private static final String ACTION_INTERROGATE = "*#";
    private static final String ACTION_REGISTER = "**";
    private static final String ACTION_ERASURE = "##";
    private static final String SC_CLIP = "30";
    private static final String SC_CLIR = "31";
    private static final String SC_COLP = "76";
    private static final String SC_COLR = "77";
    private static final String SC_CNAP = "300";
    private static final String SC_CFU = "21";
    private static final String SC_CFB = "67";
    private static final String SC_CFNRy = "61";
    private static final String SC_CFNR = "62";
    private static final String SC_CF_All = "002";
    private static final String SC_CF_All_Conditional = "004";
    private static final String SC_WAIT = "43";
    private static final String SC_BAOC = "33";
    private static final String SC_BAOIC = "331";
    private static final String SC_BAOICxH = "332";
    private static final String SC_BAIC = "35";
    private static final String SC_BAICr = "351";
    private static final String SC_BA_ALL = "330";
    private static final String SC_BA_MO = "333";
    private static final String SC_BA_MT = "353";
    private static final String SC_BS_MT = "156";
    private static final String SC_BAICa = "157";
    private static final String SC_PWD = "03";
    private static final String SC_PIN = "04";
    private static final String SC_PIN2 = "042";
    private static final String SC_PUK = "05";
    private static final String SC_PUK2 = "052";
    private static final int EVENT_SET_COMPLETE = 0;
    private static final int EVENT_QUERY_CF_COMPLETE = 1;
    private static final int EVENT_USSD_COMPLETE = 2;
    private static final int EVENT_QUERY_COMPLETE = 3;
    private static final int EVENT_SET_CFF_COMPLETE = 4;
    private static final int EVENT_USSD_CANCEL_COMPLETE = 5;
    private static final int EVENT_GET_CLIR_COMPLETE = 6;
    private static final int EVENT_SUPP_SVC_QUERY_COMPLETE = 7;
    private static final int NUM_PRESENTATION_ALLOWED = 0;
    private static final int NUM_PRESENTATION_RESTRICTED = 1;
    public static final String UT_BUNDLE_KEY_CLIR = "queryClir";
    public static final String UT_BUNDLE_KEY_SSINFO = "imsSsInfo";
    private static final int CLIR_NOT_PROVISIONED = 0;
    private static final int CLIR_PROVISIONED_PERMANENT = 1;
    private static final int CLIR_PRESENTATION_RESTRICTED_TEMPORARY = 3;
    private static final int CLIR_PRESENTATION_ALLOWED_TEMPORARY = 4;
    private static final int CLIR_DEFAULT = 0;
    private static final int CLIR_INVOCATION = 1;
    private static final int CLIR_SUPPRESSION = 2;
    private ImsPhone mPhone;
    private Context mContext;
    private IccRecords mIccRecords;
    private String mAction;
    private String mSc;
    private String mSia;
    private String mSib;
    private String mSic;
    private String mPoundString;
    private String mDialingNumber;
    private String mPwd;
    private boolean mIsPendingUSSD;
    private boolean mIsUssdRequest;
    private boolean mIsCallFwdReg;
    private MmiCode.State mState = MmiCode.State.PENDING;
    private CharSequence mMessage;
    private static Pattern sPatternSuppService = Pattern.compile("((\\*|#|\\*#|\\*\\*|##)(\\d{2,3})(\\*([^*#]*)(\\*([^*#]*)(\\*([^*#]*)(\\*([^*#]*))?)?)?)?#)(.*)");
    private static final int MATCH_GROUP_POUND_STRING = 1;
    private static final int MATCH_GROUP_ACTION = 2;
    private static final int MATCH_GROUP_SERVICE_CODE = 3;
    private static final int MATCH_GROUP_SIA = 5;
    private static final int MATCH_GROUP_SIB = 7;
    private static final int MATCH_GROUP_SIC = 9;
    private static final int MATCH_GROUP_PWD_CONFIRM = 11;
    private static final int MATCH_GROUP_DIALING_NUMBER = 12;
    private static String[] sTwoDigitNumberPattern;

    static ImsPhoneMmiCode newFromDialString(String dialString, ImsPhone phone) {
        ImsPhoneMmiCode ret = null;
        Matcher m = sPatternSuppService.matcher(dialString);
        if (m.matches()) {
            ret = new ImsPhoneMmiCode(phone);
            ret.mPoundString = ImsPhoneMmiCode.makeEmptyNull(m.group(1));
            ret.mAction = ImsPhoneMmiCode.makeEmptyNull(m.group(2));
            ret.mSc = ImsPhoneMmiCode.makeEmptyNull(m.group(3));
            ret.mSia = ImsPhoneMmiCode.makeEmptyNull(m.group(5));
            ret.mSib = ImsPhoneMmiCode.makeEmptyNull(m.group(7));
            ret.mSic = ImsPhoneMmiCode.makeEmptyNull(m.group(9));
            ret.mPwd = ImsPhoneMmiCode.makeEmptyNull(m.group(11));
            ret.mDialingNumber = ImsPhoneMmiCode.makeEmptyNull(m.group(12));
            if (ret.mDialingNumber != null && ret.mDialingNumber.endsWith(ACTION_DEACTIVATE) && dialString.endsWith(ACTION_DEACTIVATE)) {
                ret = new ImsPhoneMmiCode(phone);
                ret.mPoundString = dialString;
            }
        } else if (dialString.endsWith(ACTION_DEACTIVATE)) {
            ret = new ImsPhoneMmiCode(phone);
            ret.mPoundString = dialString;
        } else if (ImsPhoneMmiCode.isTwoDigitShortCode(phone.getContext(), dialString)) {
            ret = null;
        } else if (ImsPhoneMmiCode.isShortCode(dialString, phone)) {
            ret = new ImsPhoneMmiCode(phone);
            ret.mDialingNumber = dialString;
        }
        return ret;
    }

    static ImsPhoneMmiCode newNetworkInitiatedUssd(String ussdMessage, boolean isUssdRequest, ImsPhone phone) {
        ImsPhoneMmiCode ret = new ImsPhoneMmiCode(phone);
        ret.mMessage = ussdMessage;
        ret.mIsUssdRequest = isUssdRequest;
        if (isUssdRequest) {
            ret.mIsPendingUSSD = true;
            ret.mState = MmiCode.State.PENDING;
        } else {
            ret.mState = MmiCode.State.COMPLETE;
        }
        return ret;
    }

    static ImsPhoneMmiCode newFromUssdUserInput(String ussdMessge, ImsPhone phone) {
        ImsPhoneMmiCode ret = new ImsPhoneMmiCode(phone);
        ret.mMessage = ussdMessge;
        ret.mState = MmiCode.State.PENDING;
        ret.mIsPendingUSSD = true;
        return ret;
    }

    private static String makeEmptyNull(String s) {
        if (s != null && s.length() == 0) {
            return null;
        }
        return s;
    }

    private static boolean isEmptyOrNull(CharSequence s) {
        return s == null || s.length() == 0;
    }

    private static int scToCallForwardReason(String sc) {
        if (sc == null) {
            throw new RuntimeException("invalid call forward sc");
        }
        if (sc.equals(SC_CF_All)) {
            return 4;
        }
        if (sc.equals(SC_CFU)) {
            return 0;
        }
        if (sc.equals(SC_CFB)) {
            return 1;
        }
        if (sc.equals(SC_CFNR)) {
            return 3;
        }
        if (sc.equals(SC_CFNRy)) {
            return 2;
        }
        if (sc.equals(SC_CF_All_Conditional)) {
            return 5;
        }
        throw new RuntimeException("invalid call forward sc");
    }

    private static int siToServiceClass(String si) {
        if (si == null || si.length() == 0) {
            return 0;
        }
        int serviceCode = Integer.parseInt(si, 10);
        switch (serviceCode) {
            case 10: {
                return 13;
            }
            case 11: {
                return 1;
            }
            case 12: {
                return 12;
            }
            case 13: {
                return 4;
            }
            case 16: {
                return 8;
            }
            case 19: {
                return 5;
            }
            case 20: {
                return 48;
            }
            case 21: {
                return 160;
            }
            case 22: {
                return 80;
            }
            case 24: {
                return 16;
            }
            case 25: {
                return 32;
            }
            case 26: {
                return 17;
            }
            case 99: {
                return 64;
            }
        }
        throw new RuntimeException("unsupported MMI service code " + si);
    }

    private static int siToTime(String si) {
        if (si == null || si.length() == 0) {
            return 0;
        }
        return Integer.parseInt(si, 10);
    }

    static boolean isServiceCodeCallForwarding(String sc) {
        return sc != null && (sc.equals(SC_CFU) || sc.equals(SC_CFB) || sc.equals(SC_CFNRy) || sc.equals(SC_CFNR) || sc.equals(SC_CF_All) || sc.equals(SC_CF_All_Conditional));
    }

    static boolean isServiceCodeCallBarring(String sc) {
        String[] barringMMI;
        Resources resource = Resources.getSystem();
        if (sc != null && (barringMMI = resource.getStringArray(17236020)) != null) {
            for (String match : barringMMI) {
                if (!sc.equals(match)) continue;
                return true;
            }
        }
        return false;
    }

    static String scToBarringFacility(String sc) {
        if (sc == null) {
            throw new RuntimeException("invalid call barring sc");
        }
        if (sc.equals(SC_BAOC)) {
            return "AO";
        }
        if (sc.equals(SC_BAOIC)) {
            return "OI";
        }
        if (sc.equals(SC_BAOICxH)) {
            return "OX";
        }
        if (sc.equals(SC_BAIC)) {
            return "AI";
        }
        if (sc.equals(SC_BAICr)) {
            return "IR";
        }
        if (sc.equals(SC_BA_ALL)) {
            return "AB";
        }
        if (sc.equals(SC_BA_MO)) {
            return "AG";
        }
        if (sc.equals(SC_BA_MT)) {
            return "AC";
        }
        throw new RuntimeException("invalid call barring sc");
    }

    ImsPhoneMmiCode(ImsPhone phone) {
        super(phone.getHandler().getLooper());
        this.mPhone = phone;
        this.mContext = phone.getContext();
        this.mIccRecords = this.mPhone.mDefaultPhone.mIccRecords.get();
    }

    @Override
    public MmiCode.State getState() {
        return this.mState;
    }

    @Override
    public CharSequence getMessage() {
        return this.mMessage;
    }

    @Override
    public Phone getPhone() {
        return this.mPhone;
    }

    @Override
    public void cancel() {
        if (this.mState == MmiCode.State.COMPLETE || this.mState == MmiCode.State.FAILED) {
            return;
        }
        this.mState = MmiCode.State.CANCELLED;
        if (this.mIsPendingUSSD) {
            this.mPhone.cancelUSSD();
        } else {
            this.mPhone.onMMIDone(this);
        }
    }

    @Override
    public boolean isCancelable() {
        return this.mIsPendingUSSD;
    }

    String getDialingNumber() {
        return this.mDialingNumber;
    }

    boolean isMMI() {
        return this.mPoundString != null;
    }

    boolean isShortCode() {
        return this.mPoundString == null && this.mDialingNumber != null && this.mDialingNumber.length() <= 2;
    }

    private static boolean isTwoDigitShortCode(Context context, String dialString) {
        Rlog.d(LOG_TAG, "isTwoDigitShortCode");
        if (dialString == null || dialString.length() > 2) {
            return false;
        }
        if (sTwoDigitNumberPattern == null) {
            sTwoDigitNumberPattern = context.getResources().getStringArray(17236008);
        }
        for (String dialnumber : sTwoDigitNumberPattern) {
            Rlog.d(LOG_TAG, "Two Digit Number Pattern " + dialnumber);
            if (!dialString.equals(dialnumber)) continue;
            Rlog.d(LOG_TAG, "Two Digit Number Pattern -true");
            return true;
        }
        Rlog.d(LOG_TAG, "Two Digit Number Pattern -false");
        return false;
    }

    private static boolean isShortCode(String dialString, ImsPhone phone) {
        if (dialString == null) {
            return false;
        }
        if (dialString.length() == 0) {
            return false;
        }
        if (PhoneNumberUtils.isLocalEmergencyNumber(phone.getContext(), dialString)) {
            return false;
        }
        return ImsPhoneMmiCode.isShortCodeUSSD(dialString, phone);
    }

    private static boolean isShortCodeUSSD(String dialString, ImsPhone phone) {
        if (dialString != null && dialString.length() <= 2) {
            if (phone.isInCall()) {
                return true;
            }
            if (dialString.length() != 2 || dialString.charAt(0) != '1') {
                return true;
            }
        }
        return false;
    }

    boolean isPinPukCommand() {
        return this.mSc != null && (this.mSc.equals(SC_PIN) || this.mSc.equals(SC_PIN2) || this.mSc.equals(SC_PUK) || this.mSc.equals(SC_PUK2));
    }

    boolean isTemporaryModeCLIR() {
        return this.mSc != null && this.mSc.equals(SC_CLIR) && this.mDialingNumber != null && (this.isActivate() || this.isDeactivate());
    }

    int getCLIRMode() {
        if (this.mSc != null && this.mSc.equals(SC_CLIR)) {
            if (this.isActivate()) {
                return 2;
            }
            if (this.isDeactivate()) {
                return 1;
            }
        }
        return 0;
    }

    boolean isActivate() {
        return this.mAction != null && this.mAction.equals(ACTION_ACTIVATE);
    }

    boolean isDeactivate() {
        return this.mAction != null && this.mAction.equals(ACTION_DEACTIVATE);
    }

    boolean isInterrogate() {
        return this.mAction != null && this.mAction.equals(ACTION_INTERROGATE);
    }

    boolean isRegister() {
        return this.mAction != null && this.mAction.equals(ACTION_REGISTER);
    }

    boolean isErasure() {
        return this.mAction != null && this.mAction.equals(ACTION_ERASURE);
    }

    public boolean isPendingUSSD() {
        return this.mIsPendingUSSD;
    }

    @Override
    public boolean isUssdRequest() {
        return this.mIsUssdRequest;
    }

    boolean isSupportedOverImsPhone() {
        if (this.isShortCode()) {
            return true;
        }
        if (this.mDialingNumber != null) {
            return false;
        }
        if (ImsPhoneMmiCode.isServiceCodeCallForwarding(this.mSc) || ImsPhoneMmiCode.isServiceCodeCallBarring(this.mSc) || this.mSc != null && this.mSc.equals(SC_WAIT) || this.mSc != null && this.mSc.equals(SC_CLIR) || this.mSc != null && this.mSc.equals(SC_CLIP) || this.mSc != null && this.mSc.equals(SC_COLR) || this.mSc != null && this.mSc.equals(SC_COLP) || this.mSc != null && this.mSc.equals(SC_BS_MT) || this.mSc != null && this.mSc.equals(SC_BAICa)) {
            int serviceClass = ImsPhoneMmiCode.siToServiceClass(this.mSib);
            return serviceClass == 0 || serviceClass == 1;
        }
        if (this.isPinPukCommand() || this.mSc != null && (this.mSc.equals(SC_PWD) || this.mSc.equals(SC_CLIP) || this.mSc.equals(SC_CLIR))) {
            return false;
        }
        return this.mPoundString != null;
    }

    void processCode() throws CallStateException {
        block67: {
            try {
                if (this.isShortCode()) {
                    Rlog.d(LOG_TAG, "isShortCode");
                    Rlog.d(LOG_TAG, "Sending short code '" + this.mDialingNumber + "' over CS pipe.");
                    throw new CallStateException("cs_fallback");
                }
                if (ImsPhoneMmiCode.isServiceCodeCallForwarding(this.mSc)) {
                    Rlog.d(LOG_TAG, "is CF");
                    String dialingNumber = this.mSia;
                    int reason = ImsPhoneMmiCode.scToCallForwardReason(this.mSc);
                    int time = ImsPhoneMmiCode.siToTime(this.mSic);
                    if (this.isInterrogate()) {
                        this.mPhone.getCallForwardingOption(reason, this.obtainMessage(1, this));
                    } else {
                        int cfAction;
                        if (this.isActivate()) {
                            if (ImsPhoneMmiCode.isEmptyOrNull(dialingNumber)) {
                                cfAction = 1;
                                this.mIsCallFwdReg = false;
                            } else {
                                cfAction = 3;
                                this.mIsCallFwdReg = true;
                            }
                        } else if (this.isDeactivate()) {
                            cfAction = 0;
                        } else if (this.isRegister()) {
                            cfAction = 3;
                        } else if (this.isErasure()) {
                            cfAction = 4;
                        } else {
                            throw new RuntimeException("invalid action");
                        }
                        int isSettingUnconditional = reason == 0 || reason == 4 ? 1 : 0;
                        int isEnableDesired = cfAction == 1 || cfAction == 3 ? 1 : 0;
                        Rlog.d(LOG_TAG, "is CF setCallForward");
                        this.mPhone.setCallForwardingOption(cfAction, reason, dialingNumber, time, this.obtainMessage(4, isSettingUnconditional, isEnableDesired, this));
                    }
                    break block67;
                }
                if (ImsPhoneMmiCode.isServiceCodeCallBarring(this.mSc)) {
                    String password = this.mSia;
                    String facility = ImsPhoneMmiCode.scToBarringFacility(this.mSc);
                    if (this.isInterrogate()) {
                        this.mPhone.getCallBarring(facility, this.obtainMessage(7, this));
                        break block67;
                    }
                    if (this.isActivate() || this.isDeactivate()) {
                        this.mPhone.setCallBarring(facility, this.isActivate(), password, this.obtainMessage(0, this));
                        break block67;
                    }
                    throw new RuntimeException("Invalid or Unsupported MMI Code");
                }
                if (this.mSc != null && this.mSc.equals(SC_CLIR)) {
                    if (this.isActivate()) {
                        try {
                            this.mPhone.mCT.getUtInterface().updateCLIR(1, this.obtainMessage(0, this));
                        }
                        catch (ImsException e) {
                            Rlog.d(LOG_TAG, "Could not get UT handle for updateCLIR.");
                        }
                        break block67;
                    }
                    if (this.isDeactivate()) {
                        try {
                            this.mPhone.mCT.getUtInterface().updateCLIR(2, this.obtainMessage(0, this));
                        }
                        catch (ImsException e) {
                            Rlog.d(LOG_TAG, "Could not get UT handle for updateCLIR.");
                        }
                        break block67;
                    }
                    if (this.isInterrogate()) {
                        try {
                            this.mPhone.mCT.getUtInterface().queryCLIR(this.obtainMessage(6, this));
                        }
                        catch (ImsException e) {
                            Rlog.d(LOG_TAG, "Could not get UT handle for queryCLIR.");
                        }
                        break block67;
                    }
                    throw new RuntimeException("Invalid or Unsupported MMI Code");
                }
                if (this.mSc != null && this.mSc.equals(SC_CLIP)) {
                    if (this.isInterrogate()) {
                        try {
                            this.mPhone.mCT.getUtInterface().queryCLIP(this.obtainMessage(7, this));
                        }
                        catch (ImsException e) {
                            Rlog.d(LOG_TAG, "Could not get UT handle for queryCLIP.");
                        }
                        break block67;
                    }
                    if (this.isActivate() || this.isDeactivate()) {
                        try {
                            this.mPhone.mCT.getUtInterface().updateCLIP(this.isActivate(), this.obtainMessage(0, this));
                        }
                        catch (ImsException e) {
                            Rlog.d(LOG_TAG, "Could not get UT handle for updateCLIP.");
                        }
                        break block67;
                    }
                    throw new RuntimeException("Invalid or Unsupported MMI Code");
                }
                if (this.mSc != null && this.mSc.equals(SC_COLP)) {
                    if (this.isInterrogate()) {
                        try {
                            this.mPhone.mCT.getUtInterface().queryCOLP(this.obtainMessage(7, this));
                        }
                        catch (ImsException e) {
                            Rlog.d(LOG_TAG, "Could not get UT handle for queryCOLP.");
                        }
                        break block67;
                    }
                    if (this.isActivate() || this.isDeactivate()) {
                        try {
                            this.mPhone.mCT.getUtInterface().updateCOLP(this.isActivate(), this.obtainMessage(0, this));
                        }
                        catch (ImsException e) {
                            Rlog.d(LOG_TAG, "Could not get UT handle for updateCOLP.");
                        }
                        break block67;
                    }
                    throw new RuntimeException("Invalid or Unsupported MMI Code");
                }
                if (this.mSc != null && this.mSc.equals(SC_COLR)) {
                    if (this.isActivate()) {
                        try {
                            this.mPhone.mCT.getUtInterface().updateCOLR(0, this.obtainMessage(0, this));
                        }
                        catch (ImsException e) {
                            Rlog.d(LOG_TAG, "Could not get UT handle for updateCOLR.");
                        }
                        break block67;
                    }
                    if (this.isDeactivate()) {
                        try {
                            this.mPhone.mCT.getUtInterface().updateCOLR(1, this.obtainMessage(0, this));
                        }
                        catch (ImsException e) {
                            Rlog.d(LOG_TAG, "Could not get UT handle for updateCOLR.");
                        }
                        break block67;
                    }
                    if (this.isInterrogate()) {
                        try {
                            this.mPhone.mCT.getUtInterface().queryCOLR(this.obtainMessage(7, this));
                        }
                        catch (ImsException e) {
                            Rlog.d(LOG_TAG, "Could not get UT handle for queryCOLR.");
                        }
                        break block67;
                    }
                    throw new RuntimeException("Invalid or Unsupported MMI Code");
                }
                if (this.mSc != null && this.mSc.equals(SC_BS_MT)) {
                    try {
                        if (this.isInterrogate()) {
                            this.mPhone.mCT.getUtInterface().queryCallBarring(10, this.obtainMessage(7, this));
                        } else if (this.isActivate() || this.isDeactivate()) {
                            this.processIcbMmiCodeForUpdate();
                        }
                        break block67;
                    }
                    catch (ImsException e) {
                        Rlog.d(LOG_TAG, "Could not get UT handle for ICB.");
                    }
                    break block67;
                }
                if (this.mSc != null && this.mSc.equals(SC_BAICa)) {
                    try {
                        if (this.isInterrogate()) {
                            this.mPhone.mCT.getUtInterface().queryCallBarring(6, this.obtainMessage(7, this));
                        }
                        break block67;
                    }
                    catch (ImsException e) {
                        Rlog.d(LOG_TAG, "Could not get UT handle for ICBa.");
                    }
                    break block67;
                }
                if (this.mSc != null && this.mSc.equals(SC_WAIT)) {
                    if (this.isActivate() || this.isDeactivate()) {
                        this.mPhone.setCallWaiting(this.isActivate(), this.obtainMessage(0, this));
                        break block67;
                    }
                    if (this.isInterrogate()) {
                        this.mPhone.getCallWaiting(this.obtainMessage(3, this));
                        break block67;
                    }
                    throw new RuntimeException("Invalid or Unsupported MMI Code");
                }
                if (this.mPoundString != null) {
                    Rlog.d(LOG_TAG, "Sending pound string '" + this.mDialingNumber + "' over CS pipe.");
                    throw new CallStateException("cs_fallback");
                }
                throw new RuntimeException("Invalid or Unsupported MMI Code");
            }
            catch (RuntimeException exc) {
                this.mState = MmiCode.State.FAILED;
                this.mMessage = this.mContext.getText(17039487);
                this.mPhone.onMMIDone(this);
            }
        }
    }

    void onUssdFinished(String ussdMessage, boolean isUssdRequest) {
        if (this.mState == MmiCode.State.PENDING) {
            this.mMessage = ussdMessage == null ? this.mContext.getText(17039495) : ussdMessage;
            this.mIsUssdRequest = isUssdRequest;
            if (!isUssdRequest) {
                this.mState = MmiCode.State.COMPLETE;
            }
            this.mPhone.onMMIDone(this);
        }
    }

    void onUssdFinishedError() {
        if (this.mState == MmiCode.State.PENDING) {
            this.mState = MmiCode.State.FAILED;
            this.mMessage = this.mContext.getText(17039487);
            this.mPhone.onMMIDone(this);
        }
    }

    void sendUssd(String ussdMessage) {
        this.mIsPendingUSSD = true;
        this.mPhone.sendUSSD(ussdMessage, this.obtainMessage(2, this));
    }

    @Override
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 0: {
                AsyncResult ar = (AsyncResult)msg.obj;
                this.onSetComplete(msg, ar);
                break;
            }
            case 4: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception == null && msg.arg1 == 1) {
                    boolean cffEnabled;
                    boolean bl = cffEnabled = msg.arg2 == 1;
                    if (this.mIccRecords != null) {
                        this.mIccRecords.setVoiceCallForwardingFlag(1, cffEnabled, this.mDialingNumber);
                    }
                }
                this.onSetComplete(msg, ar);
                break;
            }
            case 1: {
                AsyncResult ar = (AsyncResult)msg.obj;
                this.onQueryCfComplete(ar);
                break;
            }
            case 3: {
                AsyncResult ar = (AsyncResult)msg.obj;
                this.onQueryComplete(ar);
                break;
            }
            case 2: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception == null) break;
                this.mState = MmiCode.State.FAILED;
                this.mMessage = this.getErrorMessage(ar);
                this.mPhone.onMMIDone(this);
                break;
            }
            case 5: {
                this.mPhone.onMMIDone(this);
                break;
            }
            case 7: {
                AsyncResult ar = (AsyncResult)msg.obj;
                this.onSuppSvcQueryComplete(ar);
                break;
            }
            case 6: {
                AsyncResult ar = (AsyncResult)msg.obj;
                this.onQueryClirComplete(ar);
                break;
            }
        }
    }

    private void processIcbMmiCodeForUpdate() {
        String dialingNumber = this.mSia;
        String[] icbNum = null;
        if (dialingNumber != null) {
            icbNum = dialingNumber.split("\\$");
        }
        try {
            this.mPhone.mCT.getUtInterface().updateCallBarring(10, this.isActivate(), this.obtainMessage(7, this), icbNum);
        }
        catch (ImsException e) {
            Rlog.d(LOG_TAG, "Could not get UT handle for updating ICB.");
        }
    }

    private CharSequence getErrorMessage(AsyncResult ar) {
        return this.mContext.getText(17039487);
    }

    private CharSequence getScString() {
        if (this.mSc != null) {
            if (ImsPhoneMmiCode.isServiceCodeCallBarring(this.mSc)) {
                return this.mContext.getText(17039512);
            }
            if (ImsPhoneMmiCode.isServiceCodeCallForwarding(this.mSc)) {
                return this.mContext.getText(17039510);
            }
            if (this.mSc.equals(SC_PWD)) {
                return this.mContext.getText(17039513);
            }
            if (this.mSc.equals(SC_WAIT)) {
                return this.mContext.getText(17039511);
            }
            if (this.mSc.equals(SC_CLIP)) {
                return this.mContext.getText(17039506);
            }
            if (this.mSc.equals(SC_CLIR)) {
                return this.mContext.getText(17039507);
            }
            if (this.mSc.equals(SC_COLP)) {
                return this.mContext.getText(17039508);
            }
            if (this.mSc.equals(SC_COLR)) {
                return this.mContext.getText(17039509);
            }
        }
        return "";
    }

    private void onSetComplete(Message msg, AsyncResult ar) {
        StringBuilder sb = new StringBuilder(this.getScString());
        sb.append("\n");
        if (ar.exception != null) {
            this.mState = MmiCode.State.FAILED;
            if (ar.exception instanceof CommandException) {
                CommandException.Error err = ((CommandException)ar.exception).getCommandError();
                if (err == CommandException.Error.PASSWORD_INCORRECT) {
                    sb.append(this.mContext.getText(17039494));
                } else {
                    sb.append(this.mContext.getText(17039487));
                }
            } else {
                ImsException error = (ImsException)ar.exception;
                if (error.getMessage() != null) {
                    sb.append(error.getMessage());
                } else {
                    sb.append(this.getErrorMessage(ar));
                }
            }
        } else if (this.isActivate()) {
            this.mState = MmiCode.State.COMPLETE;
            if (this.mIsCallFwdReg) {
                sb.append(this.mContext.getText(17039492));
            } else {
                sb.append(this.mContext.getText(17039489));
            }
        } else if (this.isDeactivate()) {
            this.mState = MmiCode.State.COMPLETE;
            sb.append(this.mContext.getText(17039491));
        } else if (this.isRegister()) {
            this.mState = MmiCode.State.COMPLETE;
            sb.append(this.mContext.getText(17039492));
        } else if (this.isErasure()) {
            this.mState = MmiCode.State.COMPLETE;
            sb.append(this.mContext.getText(17039493));
        } else {
            this.mState = MmiCode.State.FAILED;
            sb.append(this.mContext.getText(17039487));
        }
        this.mMessage = sb;
        this.mPhone.onMMIDone(this);
    }

    private CharSequence serviceClassToCFString(int serviceClass) {
        switch (serviceClass) {
            case 1: {
                return this.mContext.getText(17039536);
            }
            case 2: {
                return this.mContext.getText(17039537);
            }
            case 4: {
                return this.mContext.getText(17039538);
            }
            case 8: {
                return this.mContext.getText(17039539);
            }
            case 16: {
                return this.mContext.getText(17039541);
            }
            case 32: {
                return this.mContext.getText(17039540);
            }
            case 64: {
                return this.mContext.getText(17039542);
            }
            case 128: {
                return this.mContext.getText(17039543);
            }
        }
        return null;
    }

    private CharSequence makeCFQueryResultMessage(CallForwardInfo info, int serviceClassMask) {
        boolean needTimeTemplate;
        String[] sources = new String[]{"{0}", "{1}", "{2}"};
        CharSequence[] destinations = new CharSequence[3];
        boolean bl = needTimeTemplate = info.reason == 2;
        CharSequence template = info.status == 1 ? (needTimeTemplate ? this.mContext.getText(17039560) : this.mContext.getText(17039559)) : (info.status == 0 && ImsPhoneMmiCode.isEmptyOrNull(info.number) ? this.mContext.getText(17039558) : (needTimeTemplate ? this.mContext.getText(17039562) : this.mContext.getText(17039561)));
        destinations[0] = this.serviceClassToCFString(info.serviceClass & serviceClassMask);
        destinations[1] = PhoneNumberUtils.stringFromStringAndTOA(info.number, info.toa);
        destinations[2] = Integer.toString(info.timeSeconds);
        if (info.reason == 0 && (info.serviceClass & serviceClassMask) == 1) {
            boolean cffEnabled;
            boolean bl2 = cffEnabled = info.status == 1;
            if (this.mIccRecords != null) {
                this.mIccRecords.setVoiceCallForwardingFlag(1, cffEnabled, info.number);
            }
        }
        return TextUtils.replace(template, sources, destinations);
    }

    private void onQueryCfComplete(AsyncResult ar) {
        StringBuilder sb = new StringBuilder(this.getScString());
        sb.append("\n");
        if (ar.exception != null) {
            this.mState = MmiCode.State.FAILED;
            if (ar.exception instanceof ImsException) {
                ImsException error = (ImsException)ar.exception;
                if (error.getMessage() != null) {
                    sb.append(error.getMessage());
                } else {
                    sb.append(this.getErrorMessage(ar));
                }
            } else {
                sb.append(this.getErrorMessage(ar));
            }
        } else {
            CallForwardInfo[] infos = (CallForwardInfo[])ar.result;
            if (infos.length == 0) {
                sb.append(this.mContext.getText(17039491));
                if (this.mIccRecords != null) {
                    this.mIccRecords.setVoiceCallForwardingFlag(1, false, null);
                }
            } else {
                SpannableStringBuilder tb = new SpannableStringBuilder();
                for (int serviceClassMask = 1; serviceClassMask <= 128; serviceClassMask <<= 1) {
                    int s = infos.length;
                    for (int i = 0; i < s; ++i) {
                        if ((serviceClassMask & infos[i].serviceClass) == 0) continue;
                        tb.append(this.makeCFQueryResultMessage(infos[i], serviceClassMask));
                        tb.append("\n");
                    }
                }
                sb.append(tb);
            }
            this.mState = MmiCode.State.COMPLETE;
        }
        this.mMessage = sb;
        this.mPhone.onMMIDone(this);
    }

    private void onSuppSvcQueryComplete(AsyncResult ar) {
        StringBuilder sb = new StringBuilder(this.getScString());
        sb.append("\n");
        if (ar.exception != null) {
            this.mState = MmiCode.State.FAILED;
            if (ar.exception instanceof ImsException) {
                ImsException error = (ImsException)ar.exception;
                if (error.getMessage() != null) {
                    sb.append(error.getMessage());
                } else {
                    sb.append(this.getErrorMessage(ar));
                }
            } else {
                sb.append(this.getErrorMessage(ar));
            }
        } else {
            this.mState = MmiCode.State.FAILED;
            ImsSsInfo ssInfo = null;
            if (ar.result instanceof Bundle) {
                Rlog.d(LOG_TAG, "Received CLIP/COLP/COLR Response.");
                Bundle ssInfoResp = (Bundle)ar.result;
                ssInfo = (ImsSsInfo)ssInfoResp.getParcelable(UT_BUNDLE_KEY_SSINFO);
                if (ssInfo != null) {
                    Rlog.d(LOG_TAG, "ImsSsInfo mStatus = " + ssInfo.mStatus);
                    if (ssInfo.mStatus == 0) {
                        sb.append(this.mContext.getText(17039491));
                        this.mState = MmiCode.State.COMPLETE;
                    } else if (ssInfo.mStatus == 1) {
                        sb.append(this.mContext.getText(17039489));
                        this.mState = MmiCode.State.COMPLETE;
                    } else {
                        sb.append(this.mContext.getText(17039487));
                    }
                } else {
                    sb.append(this.mContext.getText(17039487));
                }
            } else {
                Rlog.d(LOG_TAG, "Received Call Barring Response.");
                int[] cbInfos = (int[])ar.result;
                if (cbInfos[0] == 1) {
                    sb.append(this.mContext.getText(17039489));
                    this.mState = MmiCode.State.COMPLETE;
                } else {
                    sb.append(this.mContext.getText(17039491));
                    this.mState = MmiCode.State.COMPLETE;
                }
            }
        }
        this.mMessage = sb;
        this.mPhone.onMMIDone(this);
    }

    private void onQueryClirComplete(AsyncResult ar) {
        StringBuilder sb = new StringBuilder(this.getScString());
        sb.append("\n");
        this.mState = MmiCode.State.FAILED;
        if (ar.exception != null) {
            if (ar.exception instanceof ImsException) {
                ImsException error = (ImsException)ar.exception;
                if (error.getMessage() != null) {
                    sb.append(error.getMessage());
                } else {
                    sb.append(this.getErrorMessage(ar));
                }
            }
        } else {
            Bundle ssInfo = (Bundle)ar.result;
            int[] clirInfo = ssInfo.getIntArray(UT_BUNDLE_KEY_CLIR);
            Rlog.d(LOG_TAG, "CLIR param n=" + clirInfo[0] + " m=" + clirInfo[1]);
            block0 : switch (clirInfo[1]) {
                case 0: {
                    sb.append(this.mContext.getText(17039525));
                    this.mState = MmiCode.State.COMPLETE;
                    break;
                }
                case 1: {
                    sb.append(this.mContext.getText(17039526));
                    this.mState = MmiCode.State.COMPLETE;
                    break;
                }
                case 3: {
                    switch (clirInfo[0]) {
                        case 0: {
                            sb.append(this.mContext.getText(17039521));
                            this.mState = MmiCode.State.COMPLETE;
                            break block0;
                        }
                        case 1: {
                            sb.append(this.mContext.getText(17039521));
                            this.mState = MmiCode.State.COMPLETE;
                            break block0;
                        }
                        case 2: {
                            sb.append(this.mContext.getText(17039522));
                            this.mState = MmiCode.State.COMPLETE;
                            break block0;
                        }
                    }
                    sb.append(this.mContext.getText(17039487));
                    this.mState = MmiCode.State.FAILED;
                    break;
                }
                case 4: {
                    switch (clirInfo[0]) {
                        case 0: {
                            sb.append(this.mContext.getText(17039524));
                            this.mState = MmiCode.State.COMPLETE;
                            break block0;
                        }
                        case 1: {
                            sb.append(this.mContext.getText(17039523));
                            this.mState = MmiCode.State.COMPLETE;
                            break block0;
                        }
                        case 2: {
                            sb.append(this.mContext.getText(17039524));
                            this.mState = MmiCode.State.COMPLETE;
                            break block0;
                        }
                    }
                    sb.append(this.mContext.getText(17039487));
                    this.mState = MmiCode.State.FAILED;
                    break;
                }
                default: {
                    sb.append(this.mContext.getText(17039487));
                    this.mState = MmiCode.State.FAILED;
                }
            }
        }
        this.mMessage = sb;
        this.mPhone.onMMIDone(this);
    }

    private void onQueryComplete(AsyncResult ar) {
        StringBuilder sb = new StringBuilder(this.getScString());
        sb.append("\n");
        if (ar.exception != null) {
            this.mState = MmiCode.State.FAILED;
            if (ar.exception instanceof ImsException) {
                ImsException error = (ImsException)ar.exception;
                if (error.getMessage() != null) {
                    sb.append(error.getMessage());
                } else {
                    sb.append(this.getErrorMessage(ar));
                }
            } else {
                sb.append(this.getErrorMessage(ar));
            }
        } else {
            int[] ints = (int[])ar.result;
            if (ints.length != 0) {
                if (ints[0] == 0) {
                    sb.append(this.mContext.getText(17039491));
                } else if (this.mSc.equals(SC_WAIT)) {
                    sb.append(this.createQueryCallWaitingResultMessage(ints[1]));
                } else if (ints[0] == 1) {
                    sb.append(this.mContext.getText(17039489));
                } else {
                    sb.append(this.mContext.getText(17039487));
                }
            } else {
                sb.append(this.mContext.getText(17039487));
            }
            this.mState = MmiCode.State.COMPLETE;
        }
        this.mMessage = sb;
        this.mPhone.onMMIDone(this);
    }

    private CharSequence createQueryCallWaitingResultMessage(int serviceClass) {
        StringBuilder sb = new StringBuilder(this.mContext.getText(17039490));
        for (int classMask = 1; classMask <= 128; classMask <<= 1) {
            if ((classMask & serviceClass) == 0) continue;
            sb.append("\n");
            sb.append(this.serviceClassToCFString(classMask & serviceClass));
        }
        return sb;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("ImsPhoneMmiCode {");
        sb.append("State=" + (Object)((Object)this.getState()));
        if (this.mAction != null) {
            sb.append(" action=" + this.mAction);
        }
        if (this.mSc != null) {
            sb.append(" sc=" + this.mSc);
        }
        if (this.mSia != null) {
            sb.append(" sia=" + this.mSia);
        }
        if (this.mSib != null) {
            sb.append(" sib=" + this.mSib);
        }
        if (this.mSic != null) {
            sb.append(" sic=" + this.mSic);
        }
        if (this.mPoundString != null) {
            sb.append(" poundString=" + this.mPoundString);
        }
        if (this.mDialingNumber != null) {
            sb.append(" dialingNumber=" + this.mDialingNumber);
        }
        if (this.mPwd != null) {
            sb.append(" pwd=" + this.mPwd);
        }
        sb.append("}");
        return sb.toString();
    }
}

