/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.uicc;

import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.uicc.IccConstants;
import com.android.internal.telephony.uicc.IccException;
import com.android.internal.telephony.uicc.IccFileTypeMismatch;
import com.android.internal.telephony.uicc.IccIoResult;
import com.android.internal.telephony.uicc.IccUtils;
import com.android.internal.telephony.uicc.UiccCardApplication;
import java.util.ArrayList;

public abstract class IccFileHandler
extends Handler
implements IccConstants {
    protected static final int COMMAND_READ_BINARY = 176;
    protected static final int COMMAND_UPDATE_BINARY = 214;
    protected static final int COMMAND_READ_RECORD = 178;
    protected static final int COMMAND_UPDATE_RECORD = 220;
    protected static final int COMMAND_SEEK = 162;
    protected static final int COMMAND_GET_RESPONSE = 192;
    protected static final int READ_RECORD_MODE_ABSOLUTE = 4;
    protected static final int EF_TYPE_TRANSPARENT = 0;
    protected static final int EF_TYPE_LINEAR_FIXED = 1;
    protected static final int EF_TYPE_CYCLIC = 3;
    protected static final int TYPE_RFU = 0;
    protected static final int TYPE_MF = 1;
    protected static final int TYPE_DF = 2;
    protected static final int TYPE_EF = 4;
    protected static final int GET_RESPONSE_EF_SIZE_BYTES = 15;
    protected static final int GET_RESPONSE_EF_IMG_SIZE_BYTES = 10;
    protected static final int RESPONSE_DATA_RFU_1 = 0;
    protected static final int RESPONSE_DATA_RFU_2 = 1;
    protected static final int RESPONSE_DATA_FILE_SIZE_1 = 2;
    protected static final int RESPONSE_DATA_FILE_SIZE_2 = 3;
    protected static final int RESPONSE_DATA_FILE_ID_1 = 4;
    protected static final int RESPONSE_DATA_FILE_ID_2 = 5;
    protected static final int RESPONSE_DATA_FILE_TYPE = 6;
    protected static final int RESPONSE_DATA_RFU_3 = 7;
    protected static final int RESPONSE_DATA_ACCESS_CONDITION_1 = 8;
    protected static final int RESPONSE_DATA_ACCESS_CONDITION_2 = 9;
    protected static final int RESPONSE_DATA_ACCESS_CONDITION_3 = 10;
    protected static final int RESPONSE_DATA_FILE_STATUS = 11;
    protected static final int RESPONSE_DATA_LENGTH = 12;
    protected static final int RESPONSE_DATA_STRUCTURE = 13;
    protected static final int RESPONSE_DATA_RECORD_LENGTH = 14;
    protected static final int EVENT_GET_BINARY_SIZE_DONE = 4;
    protected static final int EVENT_READ_BINARY_DONE = 5;
    protected static final int EVENT_GET_RECORD_SIZE_DONE = 6;
    protected static final int EVENT_READ_RECORD_DONE = 7;
    protected static final int EVENT_GET_EF_LINEAR_RECORD_SIZE_DONE = 8;
    protected static final int EVENT_READ_IMG_DONE = 9;
    protected static final int EVENT_READ_ICON_DONE = 10;
    protected static final int EVENT_GET_RECORD_SIZE_IMG_DONE = 11;
    protected final CommandsInterface mCi;
    protected final UiccCardApplication mParentApp;
    protected final String mAid;

    protected IccFileHandler(UiccCardApplication app, String aid, CommandsInterface ci) {
        this.mParentApp = app;
        this.mAid = aid;
        this.mCi = ci;
    }

    public void dispose() {
    }

    public void loadEFLinearFixed(int fileid, int recordNum, Message onLoaded) {
        Message response = this.obtainMessage(6, new LoadLinearFixedContext(fileid, recordNum, onLoaded));
        this.mCi.iccIOForApp(192, fileid, this.getEFPath(fileid), 0, 0, 15, null, null, this.mAid, response);
    }

    public void loadEFImgLinearFixed(int recordNum, Message onLoaded) {
        Message response = this.obtainMessage(11, new LoadLinearFixedContext(20256, recordNum, onLoaded));
        this.mCi.iccIOForApp(192, 20256, this.getEFPath(20256), recordNum, 4, 10, null, null, this.mAid, response);
    }

    public void getEFLinearRecordSize(int fileid, Message onLoaded) {
        Message response = this.obtainMessage(8, new LoadLinearFixedContext(fileid, onLoaded));
        this.mCi.iccIOForApp(192, fileid, this.getEFPath(fileid), 0, 0, 15, null, null, this.mAid, response);
    }

    public void loadEFLinearFixedAll(int fileid, Message onLoaded) {
        Message response = this.obtainMessage(6, new LoadLinearFixedContext(fileid, onLoaded));
        this.mCi.iccIOForApp(192, fileid, this.getEFPath(fileid), 0, 0, 15, null, null, this.mAid, response);
    }

    public void loadEFTransparent(int fileid, Message onLoaded) {
        Message response = this.obtainMessage(4, fileid, 0, onLoaded);
        this.mCi.iccIOForApp(192, fileid, this.getEFPath(fileid), 0, 0, 15, null, null, this.mAid, response);
    }

    public void loadEFTransparent(int fileid, int size, Message onLoaded) {
        Message response = this.obtainMessage(5, fileid, 0, onLoaded);
        this.mCi.iccIOForApp(176, fileid, this.getEFPath(fileid), 0, 0, size, null, null, this.mAid, response);
    }

    public void loadEFImgTransparent(int fileid, int highOffset, int lowOffset, int length, Message onLoaded) {
        Message response = this.obtainMessage(10, fileid, 0, onLoaded);
        this.logd("IccFileHandler: loadEFImgTransparent fileid = " + fileid + " filePath = " + this.getEFPath(20256) + " highOffset = " + highOffset + " lowOffset = " + lowOffset + " length = " + length);
        this.mCi.iccIOForApp(176, fileid, this.getEFPath(20256), highOffset, lowOffset, length, null, null, this.mAid, response);
    }

    public void updateEFLinearFixed(int fileid, int recordNum, byte[] data, String pin2, Message onComplete) {
        this.mCi.iccIOForApp(220, fileid, this.getEFPath(fileid), recordNum, 4, data.length, IccUtils.bytesToHexString(data), pin2, this.mAid, onComplete);
    }

    public void updateEFTransparent(int fileid, byte[] data, Message onComplete) {
        this.mCi.iccIOForApp(214, fileid, this.getEFPath(fileid), 0, 0, data.length, IccUtils.bytesToHexString(data), null, this.mAid, onComplete);
    }

    private void sendResult(Message response, Object result, Throwable ex) {
        if (response == null) {
            return;
        }
        AsyncResult.forMessage(response, result, ex);
        response.sendToTarget();
    }

    private boolean processException(Message response, AsyncResult ar) {
        boolean flag = false;
        IccIoResult result = (IccIoResult)ar.result;
        if (ar.exception != null) {
            this.sendResult(response, null, ar.exception);
            flag = true;
        } else {
            IccException iccException = result.getException();
            if (iccException != null) {
                this.sendResult(response, null, iccException);
                flag = true;
            }
        }
        return flag;
    }

    @Override
    public void handleMessage(Message msg) {
        Message response = null;
        try {
            switch (msg.what) {
                case 8: {
                    int[] recordSize;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    LoadLinearFixedContext lc = (LoadLinearFixedContext)ar.userObj;
                    IccIoResult result = (IccIoResult)ar.result;
                    response = lc.mOnLoaded;
                    if (this.processException(response, (AsyncResult)msg.obj)) break;
                    byte[] data = result.payload;
                    if (4 != data[6] || 1 != data[13]) {
                        throw new IccFileTypeMismatch();
                    }
                    recordSize = new int[]{data[14] & 0xFF, ((data[2] & 0xFF) << 8) + (data[3] & 0xFF), recordSize[1] / recordSize[0]};
                    this.sendResult(response, recordSize, null);
                    break;
                }
                case 6: 
                case 11: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    LoadLinearFixedContext lc = (LoadLinearFixedContext)ar.userObj;
                    IccIoResult result = (IccIoResult)ar.result;
                    response = lc.mOnLoaded;
                    if (this.processException(response, (AsyncResult)msg.obj)) break;
                    byte[] data = result.payload;
                    if (4 != data[6]) {
                        throw new IccFileTypeMismatch();
                    }
                    if (1 != data[13]) {
                        throw new IccFileTypeMismatch();
                    }
                    lc.mRecordSize = data[14] & 0xFF;
                    int size = ((data[2] & 0xFF) << 8) + (data[3] & 0xFF);
                    lc.mCountRecords = size / lc.mRecordSize;
                    if (lc.mLoadAll) {
                        lc.results = new ArrayList(lc.mCountRecords);
                    }
                    this.mCi.iccIOForApp(178, lc.mEfid, this.getEFPath(lc.mEfid), lc.mRecordNum, 4, lc.mRecordSize, null, null, this.mAid, this.obtainMessage(7, lc));
                    break;
                }
                case 4: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    response = (Message)ar.userObj;
                    IccIoResult result = (IccIoResult)ar.result;
                    if (this.processException(response, (AsyncResult)msg.obj)) break;
                    byte[] data = result.payload;
                    int fileid = msg.arg1;
                    if (4 != data[6]) {
                        throw new IccFileTypeMismatch();
                    }
                    if (0 != data[13]) {
                        throw new IccFileTypeMismatch();
                    }
                    int size = ((data[2] & 0xFF) << 8) + (data[3] & 0xFF);
                    this.mCi.iccIOForApp(176, fileid, this.getEFPath(fileid), 0, 0, size, null, null, this.mAid, this.obtainMessage(5, fileid, 0, response));
                    break;
                }
                case 7: 
                case 9: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    LoadLinearFixedContext lc = (LoadLinearFixedContext)ar.userObj;
                    IccIoResult result = (IccIoResult)ar.result;
                    response = lc.mOnLoaded;
                    if (this.processException(response, (AsyncResult)msg.obj)) break;
                    if (!lc.mLoadAll) {
                        this.sendResult(response, result.payload, null);
                        break;
                    }
                    lc.results.add(result.payload);
                    ++lc.mRecordNum;
                    if (lc.mRecordNum > lc.mCountRecords) {
                        this.sendResult(response, lc.results, null);
                        break;
                    }
                    this.mCi.iccIOForApp(178, lc.mEfid, this.getEFPath(lc.mEfid), lc.mRecordNum, 4, lc.mRecordSize, null, null, this.mAid, this.obtainMessage(7, lc));
                    break;
                }
                case 5: 
                case 10: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    response = (Message)ar.userObj;
                    IccIoResult result = (IccIoResult)ar.result;
                    if (this.processException(response, (AsyncResult)msg.obj)) break;
                    this.sendResult(response, result.payload, null);
                }
            }
        }
        catch (Exception exc) {
            if (response != null) {
                this.sendResult(response, null, exc);
            }
            this.loge("uncaught exception" + exc);
        }
    }

    protected String getCommonIccEFPath(int efid) {
        switch (efid) {
            case 28474: 
            case 28475: 
            case 28480: 
            case 28489: 
            case 28490: 
            case 28491: 
            case 28492: 
            case 28645: {
                return "3F007F10";
            }
            case 12037: 
            case 12258: {
                return "3F00";
            }
            case 20272: {
                return "3F007F105F3A";
            }
            case 20256: {
                return "3F007F105F50";
            }
        }
        return null;
    }

    protected abstract String getEFPath(int var1);

    protected abstract void logd(String var1);

    protected abstract void loge(String var1);

    static class LoadLinearFixedContext {
        int mEfid;
        int mRecordNum;
        int mRecordSize;
        int mCountRecords;
        boolean mLoadAll;
        Message mOnLoaded;
        ArrayList<byte[]> results;

        LoadLinearFixedContext(int efid, int recordNum, Message onLoaded) {
            this.mEfid = efid;
            this.mRecordNum = recordNum;
            this.mOnLoaded = onLoaded;
            this.mLoadAll = false;
        }

        LoadLinearFixedContext(int efid, Message onLoaded) {
            this.mEfid = efid;
            this.mRecordNum = 1;
            this.mLoadAll = true;
            this.mOnLoaded = onLoaded;
        }
    }
}

