/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.uicc;

import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.Signature;
import android.os.AsyncResult;
import android.os.Binder;
import android.os.Handler;
import android.os.Message;
import android.telephony.Rlog;
import com.android.internal.telephony.uicc.IccIoResult;
import com.android.internal.telephony.uicc.IccUtils;
import com.android.internal.telephony.uicc.UiccCard;
import java.io.ByteArrayInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;

public class UiccCarrierPrivilegeRules
extends Handler {
    private static final String LOG_TAG = "UiccCarrierPrivilegeRules";
    private static final String AID = "A00000015141434C00";
    private static final int CLA = 128;
    private static final int COMMAND = 202;
    private static final int P1 = 255;
    private static final int P2 = 64;
    private static final int P3 = 0;
    private static final String DATA = "";
    private static final String TAG_ALL_REF_AR_DO = "FF40";
    private static final String TAG_REF_AR_DO = "E2";
    private static final String TAG_REF_DO = "E1";
    private static final String TAG_DEVICE_APP_ID_REF_DO = "C1";
    private static final String TAG_PKG_REF_DO = "CA";
    private static final String TAG_AR_DO = "E3";
    private static final String TAG_PERM_AR_DO = "DB";
    private static final int EVENT_OPEN_LOGICAL_CHANNEL_DONE = 1;
    private static final int EVENT_TRANSMIT_LOGICAL_CHANNEL_DONE = 2;
    private static final int EVENT_CLOSE_LOGICAL_CHANNEL_DONE = 3;
    private static final int STATE_LOADING = 0;
    private static final int STATE_LOADED = 1;
    private static final int STATE_ERROR = 2;
    private UiccCard mUiccCard;
    private AtomicInteger mState;
    private List<AccessRule> mAccessRules;
    private Message mLoadedCallback;

    public UiccCarrierPrivilegeRules(UiccCard uiccCard, Message loadedCallback) {
        Rlog.d(LOG_TAG, "Creating UiccCarrierPrivilegeRules");
        this.mUiccCard = uiccCard;
        this.mState = new AtomicInteger(0);
        this.mLoadedCallback = loadedCallback;
        this.mUiccCard.iccOpenLogicalChannel(AID, this.obtainMessage(1, null));
    }

    public boolean areCarrierPriviligeRulesLoaded() {
        return this.mState.get() != 0;
    }

    public int getCarrierPrivilegeStatus(Signature signature, String packageName) {
        Rlog.d(LOG_TAG, "hasCarrierPrivileges: " + signature + " : " + packageName);
        int state = this.mState.get();
        if (state == 0) {
            Rlog.d(LOG_TAG, "Rules not loaded.");
            return -1;
        }
        if (state == 2) {
            Rlog.d(LOG_TAG, "Error loading rules.");
            return -2;
        }
        byte[] certHash = UiccCarrierPrivilegeRules.getCertHash(signature);
        if (certHash == null) {
            return 0;
        }
        Rlog.e(LOG_TAG, "Checking: " + IccUtils.bytesToHexString(certHash) + " : " + packageName);
        for (AccessRule ar : this.mAccessRules) {
            if (!ar.matches(certHash, packageName)) continue;
            Rlog.d(LOG_TAG, "Match found!");
            return 1;
        }
        Rlog.d(LOG_TAG, "No matching rule found. Returning false.");
        return 0;
    }

    public int getCarrierPrivilegeStatus(PackageManager packageManager, String packageName) {
        try {
            Signature[] signatures;
            PackageInfo pInfo = packageManager.getPackageInfo(packageName, 64);
            for (Signature sig : signatures = pInfo.signatures) {
                int accessStatus = this.getCarrierPrivilegeStatus(sig, pInfo.packageName);
                if (accessStatus == 0) continue;
                return accessStatus;
            }
        }
        catch (PackageManager.NameNotFoundException ex) {
            Rlog.e(LOG_TAG, "NameNotFoundException", ex);
        }
        return 0;
    }

    public int getCarrierPrivilegeStatusForCurrentTransaction(PackageManager packageManager) {
        String[] packages;
        for (String pkg : packages = packageManager.getPackagesForUid(Binder.getCallingUid())) {
            int accessStatus = this.getCarrierPrivilegeStatus(packageManager, pkg);
            if (accessStatus == 0) continue;
            return accessStatus;
        }
        return 0;
    }

    public List<String> getCarrierPackageNamesForIntent(PackageManager packageManager, Intent intent) {
        ArrayList<String> packages = new ArrayList<String>();
        ArrayList<ResolveInfo> receivers = new ArrayList<ResolveInfo>();
        receivers.addAll(packageManager.queryBroadcastReceivers(intent, 0));
        receivers.addAll(packageManager.queryIntentContentProviders(intent, 0));
        receivers.addAll(packageManager.queryIntentActivities(intent, 0));
        receivers.addAll(packageManager.queryIntentServices(intent, 0));
        for (ResolveInfo resolveInfo : receivers) {
            if (resolveInfo.activityInfo == null) continue;
            String packageName = resolveInfo.activityInfo.packageName;
            int status = this.getCarrierPrivilegeStatus(packageManager, packageName);
            if (status == 1) {
                packages.add(packageName);
                continue;
            }
            if (status == 0) continue;
            return null;
        }
        return packages;
    }

    @Override
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                Rlog.d(LOG_TAG, "EVENT_OPEN_LOGICAL_CHANNEL_DONE");
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception == null && ar.result != null) {
                    int channelId = ((int[])ar.result)[0];
                    this.mUiccCard.iccTransmitApduLogicalChannel(channelId, 128, 202, 255, 64, 0, DATA, this.obtainMessage(2, new Integer(channelId)));
                    break;
                }
                Rlog.e(LOG_TAG, "Error opening channel");
                this.updateState(2);
                break;
            }
            case 2: {
                Rlog.d(LOG_TAG, "EVENT_TRANSMIT_LOGICAL_CHANNEL_DONE");
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception == null && ar.result != null) {
                    IccIoResult response = (IccIoResult)ar.result;
                    if (response.payload != null && response.sw1 == 144 && response.sw2 == 0) {
                        try {
                            this.mAccessRules = UiccCarrierPrivilegeRules.parseRules(IccUtils.bytesToHexString(response.payload));
                            this.updateState(1);
                        }
                        catch (IllegalArgumentException ex) {
                            Rlog.e(LOG_TAG, "Error parsing rules: " + ex);
                            this.updateState(2);
                        }
                    } else {
                        Rlog.e(LOG_TAG, "Invalid response: payload=" + response.payload + " sw1=" + response.sw1 + " sw2=" + response.sw2);
                        this.updateState(2);
                    }
                } else {
                    Rlog.e(LOG_TAG, "Error reading value from SIM.");
                    this.updateState(2);
                }
                int channelId = (Integer)ar.userObj;
                this.mUiccCard.iccCloseLogicalChannel(channelId, this.obtainMessage(3));
                break;
            }
            case 3: {
                Rlog.d(LOG_TAG, "EVENT_CLOSE_LOGICAL_CHANNEL_DONE");
                break;
            }
            default: {
                Rlog.e(LOG_TAG, "Unknown event " + msg.what);
            }
        }
    }

    private static List<AccessRule> parseRules(String rules) {
        rules = rules.toUpperCase(Locale.US);
        Rlog.d(LOG_TAG, "Got rules: " + rules);
        TLV allRefArDo = new TLV(TAG_ALL_REF_AR_DO);
        allRefArDo.parse(rules, true);
        String arDos = allRefArDo.value;
        ArrayList<AccessRule> accessRules = new ArrayList<AccessRule>();
        while (!arDos.isEmpty()) {
            TLV refArDo = new TLV(TAG_REF_AR_DO);
            arDos = refArDo.parse(arDos, false);
            AccessRule accessRule = UiccCarrierPrivilegeRules.parseRefArdo(refArDo.value);
            if (accessRule != null) {
                accessRules.add(accessRule);
                continue;
            }
            Rlog.e(LOG_TAG, "Skip unrecognized rule." + refArDo.value);
        }
        return accessRules;
    }

    private static AccessRule parseRefArdo(String rule) {
        Rlog.d(LOG_TAG, "Got rule: " + rule);
        String certificateHash = null;
        String packageName = null;
        String tmp = null;
        long accessType = 0L;
        while (!rule.isEmpty()) {
            if (rule.startsWith(TAG_REF_DO)) {
                TLV refDo = new TLV(TAG_REF_DO);
                rule = refDo.parse(rule, false);
                if (!refDo.value.startsWith(TAG_DEVICE_APP_ID_REF_DO)) {
                    return null;
                }
                TLV deviceDo = new TLV(TAG_DEVICE_APP_ID_REF_DO);
                tmp = deviceDo.parse(refDo.value, false);
                certificateHash = deviceDo.value;
                if (!tmp.isEmpty()) {
                    if (!tmp.startsWith(TAG_PKG_REF_DO)) {
                        return null;
                    }
                    TLV pkgDo = new TLV(TAG_PKG_REF_DO);
                    pkgDo.parse(tmp, true);
                    packageName = new String(IccUtils.hexStringToBytes(pkgDo.value));
                    continue;
                }
                packageName = null;
                continue;
            }
            if (rule.startsWith(TAG_AR_DO)) {
                TLV arDo = new TLV(TAG_AR_DO);
                rule = arDo.parse(rule, false);
                if (!arDo.value.startsWith(TAG_PERM_AR_DO)) {
                    return null;
                }
                TLV permDo = new TLV(TAG_PERM_AR_DO);
                permDo.parse(arDo.value, true);
                Rlog.e(LOG_TAG, permDo.value);
                continue;
            }
            throw new RuntimeException("Invalid Rule type");
        }
        Rlog.e(LOG_TAG, "Adding: " + certificateHash + " : " + packageName + " : " + accessType);
        AccessRule accessRule = new AccessRule(IccUtils.hexStringToBytes(certificateHash), packageName, accessType);
        Rlog.e(LOG_TAG, "Parsed rule: " + accessRule);
        return accessRule;
    }

    private static byte[] getCertHash(Signature signature) {
        try {
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(signature.toByteArray()));
            MessageDigest md = MessageDigest.getInstance("SHA");
            return md.digest(cert.getEncoded());
        }
        catch (CertificateException ex) {
            Rlog.e(LOG_TAG, "CertificateException: " + ex);
        }
        catch (NoSuchAlgorithmException ex) {
            Rlog.e(LOG_TAG, "NoSuchAlgorithmException: " + ex);
        }
        Rlog.e(LOG_TAG, "Cannot compute cert hash");
        return null;
    }

    private void updateState(int newState) {
        this.mState.set(newState);
        if (this.mLoadedCallback != null) {
            this.mLoadedCallback.sendToTarget();
        }
    }

    private static class TLV {
        private String tag;
        private Integer length;
        private String value;

        public TLV(String tag) {
            this.tag = tag;
        }

        public String parse(String data, boolean shouldConsumeAll) {
            Rlog.d(UiccCarrierPrivilegeRules.LOG_TAG, "Parse TLV: " + this.tag);
            if (!data.startsWith(this.tag)) {
                throw new IllegalArgumentException("Tags don't match.");
            }
            int index = this.tag.length();
            if (index + 2 > data.length()) {
                throw new IllegalArgumentException("No length.");
            }
            this.length = new Integer(2 * Integer.parseInt(data.substring(index, index + 2), 16));
            int remainingLength = data.length() - ((index += 2) + this.length);
            if (remainingLength < 0) {
                throw new IllegalArgumentException("Not enough data.");
            }
            if (shouldConsumeAll && remainingLength != 0) {
                throw new IllegalArgumentException("Did not consume all.");
            }
            this.value = data.substring(index, index + this.length);
            Rlog.d(UiccCarrierPrivilegeRules.LOG_TAG, "Got TLV: " + this.tag + "," + this.length + "," + this.value);
            return data.substring(index + this.length);
        }
    }

    private static class AccessRule {
        public byte[] certificateHash;
        public String packageName;
        public long accessType;

        AccessRule(byte[] certificateHash, String packageName, long accessType) {
            this.certificateHash = certificateHash;
            this.packageName = packageName;
            this.accessType = accessType;
        }

        boolean matches(byte[] certHash, String packageName) {
            return certHash != null && Arrays.equals(this.certificateHash, certHash) && (this.packageName == null || this.packageName.equals(packageName));
        }

        public String toString() {
            return "cert: " + this.certificateHash + " pkg: " + this.packageName + " access: " + this.accessType;
        }
    }
}

