/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.uicc;

import android.content.Context;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.Registrant;
import android.os.RegistrantList;
import android.telephony.Rlog;
import android.telephony.TelephonyManager;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.SubscriptionController;
import com.android.internal.telephony.uicc.IccCardStatus;
import com.android.internal.telephony.uicc.IccFileHandler;
import com.android.internal.telephony.uicc.IccRecords;
import com.android.internal.telephony.uicc.UiccCard;
import com.android.internal.telephony.uicc.UiccCardApplication;
import java.io.FileDescriptor;
import java.io.PrintWriter;

public class UiccController
extends Handler {
    private static final boolean DBG = true;
    private static final String LOG_TAG = "UiccController";
    public static final int APP_FAM_3GPP = 1;
    public static final int APP_FAM_3GPP2 = 2;
    public static final int APP_FAM_IMS = 3;
    private static final int EVENT_ICC_STATUS_CHANGED = 1;
    private static final int EVENT_GET_ICC_STATUS_DONE = 2;
    private static final int EVENT_RADIO_UNAVAILABLE = 3;
    private CommandsInterface[] mCis;
    private UiccCard[] mUiccCards = new UiccCard[TelephonyManager.getDefault().getPhoneCount()];
    private static final Object mLock = new Object();
    private static UiccController mInstance;
    private Context mContext;
    protected RegistrantList mIccChangedRegistrants = new RegistrantList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UiccController make(Context c, CommandsInterface[] ci) {
        Object object = mLock;
        synchronized (object) {
            if (mInstance != null) {
                throw new RuntimeException("MSimUiccController.make() should only be called once");
            }
            mInstance = new UiccController(c, ci);
            return mInstance;
        }
    }

    private UiccController(Context c, CommandsInterface[] ci) {
        this.log("Creating UiccController");
        this.mContext = c;
        this.mCis = ci;
        for (int i = 0; i < this.mCis.length; ++i) {
            Integer index = new Integer(i);
            this.mCis[i].registerForIccStatusChanged(this, 1, index);
            this.mCis[i].registerForAvailable(this, 1, index);
            this.mCis[i].registerForNotAvailable(this, 3, index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UiccController getInstance() {
        Object object = mLock;
        synchronized (object) {
            if (mInstance == null) {
                throw new RuntimeException("UiccController.getInstance can't be called before make()");
            }
            return mInstance;
        }
    }

    public UiccCard getUiccCard() {
        return this.getUiccCard(SubscriptionController.getInstance().getPhoneId(SubscriptionController.getInstance().getDefaultSubId()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UiccCard getUiccCard(int slotId) {
        Object object = mLock;
        synchronized (object) {
            if (this.isValidCardIndex(slotId)) {
                return this.mUiccCards[slotId];
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UiccCard[] getUiccCards() {
        Object object = mLock;
        synchronized (object) {
            return (UiccCard[])this.mUiccCards.clone();
        }
    }

    public UiccCardApplication getUiccCardApplication(int family) {
        return this.getUiccCardApplication(SubscriptionController.getInstance().getPhoneId(SubscriptionController.getInstance().getDefaultSubId()), family);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IccRecords getIccRecords(int slotId, int family) {
        Object object = mLock;
        synchronized (object) {
            UiccCardApplication app = this.getUiccCardApplication(slotId, family);
            if (app != null) {
                return app.getIccRecords();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IccFileHandler getIccFileHandler(int slotId, int family) {
        Object object = mLock;
        synchronized (object) {
            UiccCardApplication app = this.getUiccCardApplication(slotId, family);
            if (app != null) {
                return app.getIccFileHandler();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerForIccChanged(Handler h, int what, Object obj) {
        Object object = mLock;
        synchronized (object) {
            Registrant r = new Registrant(h, what, obj);
            this.mIccChangedRegistrants.add(r);
            r.notifyRegistrant();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterForIccChanged(Handler h) {
        Object object = mLock;
        synchronized (object) {
            this.mIccChangedRegistrants.remove(h);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMessage(Message msg) {
        Object object = mLock;
        synchronized (object) {
            Integer index = this.getCiIndex(msg);
            if (index < 0 || index >= this.mCis.length) {
                Rlog.e(LOG_TAG, "Invalid index : " + index + " received with event " + msg.what);
                return;
            }
            switch (msg.what) {
                case 1: {
                    this.log("Received EVENT_ICC_STATUS_CHANGED, calling getIccCardStatus");
                    this.mCis[index].getIccCardStatus(this.obtainMessage(2, index));
                    break;
                }
                case 2: {
                    this.log("Received EVENT_GET_ICC_STATUS_DONE");
                    AsyncResult ar = (AsyncResult)msg.obj;
                    this.onGetIccCardStatusDone(ar, index);
                    break;
                }
                case 3: {
                    this.log("EVENT_RADIO_UNAVAILABLE, dispose card");
                    if (this.mUiccCards[index] != null) {
                        this.mUiccCards[index].dispose();
                    }
                    this.mUiccCards[index.intValue()] = null;
                    this.mIccChangedRegistrants.notifyRegistrants(new AsyncResult(null, index, null));
                    break;
                }
                default: {
                    Rlog.e(LOG_TAG, " Unknown Event " + msg.what);
                }
            }
        }
    }

    private Integer getCiIndex(Message msg) {
        Integer index = new Integer(0);
        if (msg != null) {
            if (msg.obj != null && msg.obj instanceof Integer) {
                index = (Integer)msg.obj;
            } else if (msg.obj != null && msg.obj instanceof AsyncResult) {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.userObj != null && ar.userObj instanceof Integer) {
                    index = (Integer)ar.userObj;
                }
            }
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UiccCardApplication getUiccCardApplication(int slotId, int family) {
        Object object = mLock;
        synchronized (object) {
            UiccCard c;
            if (this.isValidCardIndex(slotId) && (c = this.mUiccCards[slotId]) != null) {
                return this.mUiccCards[slotId].getApplication(family);
            }
            return null;
        }
    }

    private synchronized void onGetIccCardStatusDone(AsyncResult ar, Integer index) {
        if (ar.exception != null) {
            Rlog.e(LOG_TAG, "Error getting ICC status. RIL_REQUEST_GET_ICC_STATUS should never return an error", ar.exception);
            return;
        }
        if (!this.isValidCardIndex(index)) {
            Rlog.e(LOG_TAG, "onGetIccCardStatusDone: invalid index : " + index);
            return;
        }
        IccCardStatus status = (IccCardStatus)ar.result;
        if (this.mUiccCards[index] == null) {
            this.mUiccCards[index.intValue()] = new UiccCard(this.mContext, this.mCis[index], status, index);
        } else {
            this.mUiccCards[index].update(this.mContext, this.mCis[index], status);
        }
        this.log("Notifying IccChangedRegistrants");
        this.mIccChangedRegistrants.notifyRegistrants(new AsyncResult(null, index, null));
    }

    private boolean isValidCardIndex(int index) {
        return index >= 0 && index < this.mUiccCards.length;
    }

    private void log(String string2) {
        Rlog.d(LOG_TAG, string2);
    }

    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("UiccController: " + this);
        pw.println(" mContext=" + this.mContext);
        pw.println(" mInstance=" + mInstance);
        pw.println(" mIccChangedRegistrants: size=" + this.mIccChangedRegistrants.size());
        for (int i = 0; i < this.mIccChangedRegistrants.size(); ++i) {
            pw.println("  mIccChangedRegistrants[" + i + "]=" + ((Registrant)this.mIccChangedRegistrants.get(i)).getHandler());
        }
        pw.println();
        pw.flush();
    }
}

