/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.util.AttributeSet;
import android.util.Log;
import android.util.StateSet;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.widget.RemoteViews;
import com.android.internal.R;

@RemoteViews.RemoteView
public class SizeAdaptiveLayout
extends ViewGroup {
    private static final String TAG = "SizeAdaptiveLayout";
    private static final boolean DEBUG = false;
    private static final boolean REPORT_BAD_BOUNDS = true;
    private static final long CROSSFADE_TIME = 250L;
    private static final int MIN_VALID_HEIGHT = 1;
    private static final int MAX_VALID_HEIGHT = 0;
    private View mActiveChild;
    private View mLastActive;
    private AnimatorSet mTransitionAnimation;
    private Animator.AnimatorListener mAnimatorListener;
    private ObjectAnimator mFadePanel;
    private ObjectAnimator mFadeView;
    private int mCanceledAnimationCount;
    private View mEnteringView;
    private View mLeavingView;
    private View mModestyPanel;
    private int mModestyPanelTop;

    public SizeAdaptiveLayout(Context context) {
        this(context, null);
    }

    public SizeAdaptiveLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SizeAdaptiveLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public SizeAdaptiveLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initialize();
    }

    private void initialize() {
        this.mModestyPanel = new View(this.getContext());
        Drawable background = this.getBackground();
        if (background instanceof StateListDrawable) {
            StateListDrawable sld = (StateListDrawable)background;
            sld.setState(StateSet.WILD_CARD);
            background = sld.getCurrent();
        }
        if (background instanceof ColorDrawable) {
            this.mModestyPanel.setBackgroundDrawable(background);
        }
        LayoutParams layout2 = new LayoutParams(-1, -1);
        this.mModestyPanel.setLayoutParams(layout2);
        this.addView(this.mModestyPanel);
        this.mFadePanel = ObjectAnimator.ofFloat((Object)this.mModestyPanel, "alpha", 0.0f);
        this.mFadeView = ObjectAnimator.ofFloat(null, "alpha", 0.0f);
        this.mAnimatorListener = new BringToFrontOnEnd();
        this.mTransitionAnimation = new AnimatorSet();
        this.mTransitionAnimation.play(this.mFadeView).with(this.mFadePanel);
        this.mTransitionAnimation.setDuration(250L);
        this.mTransitionAnimation.addListener(this.mAnimatorListener);
    }

    public Animator getTransitionAnimation() {
        return this.mTransitionAnimation;
    }

    public View getModestyPanel() {
        return this.mModestyPanel;
    }

    @Override
    public void onAttachedToWindow() {
        this.mLastActive = null;
        for (int i = 0; i < this.getChildCount(); ++i) {
            this.getChildAt(i).setVisibility(8);
        }
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        View model = this.selectActiveChild(heightMeasureSpec);
        if (model == null) {
            this.setMeasuredDimension(0, 0);
            return;
        }
        LayoutParams lp = (LayoutParams)model.getLayoutParams();
        this.measureChild(model, widthMeasureSpec, heightMeasureSpec);
        int childHeight = model.getMeasuredHeight();
        int childWidth = model.getMeasuredHeight();
        int childState = SizeAdaptiveLayout.combineMeasuredStates(0, model.getMeasuredState());
        int resolvedWidth = SizeAdaptiveLayout.resolveSizeAndState(childWidth, widthMeasureSpec, childState);
        int resolvedHeight = SizeAdaptiveLayout.resolveSizeAndState(childHeight, heightMeasureSpec, childState);
        int boundedHeight = this.clampSizeToBounds(resolvedHeight, model);
        this.setMeasuredDimension(resolvedWidth, boundedHeight);
    }

    private int clampSizeToBounds(int measuredHeight, View child) {
        LayoutParams lp = (LayoutParams)child.getLayoutParams();
        int heightIn = 0xFFFFFF & measuredHeight;
        int height = Math.max(heightIn, lp.minHeight);
        if (lp.maxHeight != -1) {
            height = Math.min(height, lp.maxHeight);
        }
        if (heightIn != height) {
            Log.d(TAG, this + "child view " + child + " " + "measured out of bounds at " + heightIn + "px " + "clamped to " + height + "px");
        }
        return height;
    }

    private View selectActiveChild(int heightMeasureSpec) {
        int heightMode = View.MeasureSpec.getMode(heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize(heightMeasureSpec);
        View unboundedView = null;
        View tallestView = null;
        int tallestViewSize = 0;
        View smallestView = null;
        int smallestViewSize = Integer.MAX_VALUE;
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            if (child == this.mModestyPanel) continue;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (lp.maxHeight == -1 && unboundedView == null) {
                unboundedView = child;
            }
            if (lp.maxHeight > tallestViewSize) {
                tallestViewSize = lp.maxHeight;
                tallestView = child;
            }
            if (lp.minHeight < smallestViewSize) {
                smallestViewSize = lp.minHeight;
                smallestView = child;
            }
            if (heightMode == 0 || heightSize < lp.minHeight || heightSize > lp.maxHeight) continue;
            return child;
        }
        if (unboundedView != null) {
            tallestView = unboundedView;
        }
        if (heightMode == 0 || heightSize > tallestViewSize) {
            return tallestView;
        }
        return smallestView;
    }

    @Override
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.mLastActive = this.mActiveChild;
        int measureSpec = View.MeasureSpec.makeMeasureSpec(bottom - top, 0x40000000);
        this.mActiveChild = this.selectActiveChild(measureSpec);
        if (this.mActiveChild == null) {
            return;
        }
        this.mActiveChild.setVisibility(0);
        if (this.mLastActive != this.mActiveChild && this.mLastActive != null) {
            this.mEnteringView = this.mActiveChild;
            this.mLeavingView = this.mLastActive;
            this.mEnteringView.setAlpha(1.0f);
            this.mModestyPanel.setAlpha(1.0f);
            this.mModestyPanel.bringToFront();
            this.mModestyPanelTop = this.mLeavingView.getHeight();
            this.mModestyPanel.setVisibility(0);
            this.mLeavingView.bringToFront();
            if (this.mTransitionAnimation.isRunning()) {
                this.mTransitionAnimation.cancel();
            }
            this.mFadeView.setTarget(this.mLeavingView);
            this.mFadeView.setFloatValues(0.0f);
            this.mFadePanel.setFloatValues(0.0f);
            this.mTransitionAnimation.setupStartValues();
            this.mTransitionAnimation.start();
        }
        int childWidth = this.mActiveChild.getMeasuredWidth();
        int childHeight = this.mActiveChild.getMeasuredHeight();
        this.mActiveChild.layout(0, 0, childWidth, childHeight);
        this.mModestyPanel.layout(0, this.mModestyPanelTop, childWidth, this.mModestyPanelTop + childHeight);
    }

    @Override
    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    @Override
    protected LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams(p);
    }

    @Override
    protected LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams();
    }

    @Override
    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    class BringToFrontOnEnd
    implements Animator.AnimatorListener {
        BringToFrontOnEnd() {
        }

        @Override
        public void onAnimationEnd(Animator animation) {
            if (SizeAdaptiveLayout.this.mCanceledAnimationCount == 0) {
                SizeAdaptiveLayout.this.mLeavingView.setVisibility(8);
                SizeAdaptiveLayout.this.mModestyPanel.setVisibility(8);
                SizeAdaptiveLayout.this.mEnteringView.bringToFront();
                SizeAdaptiveLayout.this.mEnteringView = null;
                SizeAdaptiveLayout.this.mLeavingView = null;
            } else {
                SizeAdaptiveLayout.this.mCanceledAnimationCount--;
            }
        }

        @Override
        public void onAnimationCancel(Animator animation) {
            SizeAdaptiveLayout.this.mCanceledAnimationCount++;
        }

        @Override
        public void onAnimationRepeat(Animator animation) {
            assert (false);
        }

        @Override
        public void onAnimationStart(Animator animation) {
        }
    }

    public static class LayoutParams
    extends ViewGroup.LayoutParams {
        @ViewDebug.ExportedProperty(category="layout")
        public int minHeight;
        @ViewDebug.ExportedProperty(category="layout")
        public int maxHeight;
        public static final int UNBOUNDED = -1;

        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
            TypedArray a = c.obtainStyledAttributes(attrs, R.styleable.SizeAdaptiveLayout_Layout);
            this.minHeight = a.getDimensionPixelSize(1, 0);
            try {
                this.maxHeight = a.getLayoutDimension(0, -1);
            }
            catch (Exception e) {
                // empty catch block
            }
            a.recycle();
        }

        public LayoutParams(int width, int height, int minHeight, int maxHeight) {
            super(width, height);
            this.minHeight = minHeight;
            this.maxHeight = maxHeight;
        }

        public LayoutParams(int width, int height) {
            this(width, height, -1, -1);
        }

        public LayoutParams() {
            this(0, 0);
        }

        public LayoutParams(ViewGroup.LayoutParams p) {
            super(p);
            this.minHeight = -1;
            this.maxHeight = -1;
        }

        @Override
        public String debug(String output) {
            return output + "SizeAdaptiveLayout.LayoutParams={" + ", max=" + this.maxHeight + ", max=" + this.minHeight + "}";
        }
    }
}

